/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.app.AbstractBgDataFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgDataFacadeControllerBean
extends AbstractBgDataFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgDataFacadeControllerBean");

    private SelectorItemCollection getSelected() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    private SelectorItemCollection getBgPeriod() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("periodType"));
        return sic;
    }

    private SelectorItemCollection getCurrency() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        return sic;
    }

    protected boolean isUpgrade(Context ctx) throws Exception {
        return BgItemFacadeFactory.getLocalInstance(ctx).checkIsUpgrade();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _getHistoryData(Context ctx, BOSUuid orgUnitID, BOSUuid bgSchemeID, String[] parameter) throws BOSException, EASBizException {
        ArrayList<Object> hisData = new ArrayList<Object>();
        if (orgUnitID == null) return hisData;
        if (bgSchemeID == null) return hisData;
        if (parameter == null) return hisData;
        if (parameter[0] == null) return hisData;
        if (parameter[0].trim().length() == 0) return hisData;
        if (parameter[2] == null) return hisData;
        if (parameter[2].trim().length() == 0) {
            return hisData;
        }
        HashMap formulaMap = new HashMap();
        HashMap<String, BgPeriodInfo> periodMap = new HashMap<String, BgPeriodInfo>();
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        HashMap<String, BgSchemeInfo> bgSchemeMap = new HashMap<String, BgSchemeInfo>();
        HashSet<String> currencySet = new HashSet<String>();
        HashSet<String> periodSet = new HashSet<String>();
        HashSet<String> itemSet = new HashSet<String>();
        HashSet<String> bgSchemeSet = new HashSet<String>();
        String[] info = null;
        String[] para = null;
        String[] items = null;
        String formulaString = null;
        String itemString = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            items = parameter[0].split(",");
            for (int i = 0; i < items.length; ++i) {
                itemSet.add(items[i]);
            }
            BgItemCollection itemCol = null;
            BgItemInfo itemInfo = null;
            IBgItem ibgItem = BgItemFactory.getLocalInstance(ctx);
            if (ibgItem != null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", itemSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(ctx, orgUnitID.toString()), CompareType.EQUALS));
                view.setFilter(filter);
                view.getSelector().addObjectCollection((IObjectCollection)this.getSelected());
                itemCol = ibgItem.getBgItemCollection(view);
                Iterator iter = itemCol.iterator();
                while (iter.hasNext()) {
                    itemInfo = (BgItemInfo)iter.next();
                    if (itemString == null || itemString.trim().length() == 0) {
                        itemString = itemInfo.getName();
                        continue;
                    }
                    itemString = itemString + "," + itemInfo.getName();
                }
                hisData.add(itemString);
            } else {
                hisData.add("");
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select a.FBgValue, a.FBizActual, a.FBgSchemeId, a.FFormula, a.FCurrencyID from T_BG_BgData a, T_BG_BgItemCombination b where a.FBgItemCombinId = b.FID and a.FOrgUnitId=? and b.FKey=?");
            pstmt.setString(1, orgUnitID.toString());
            pstmt.setString(2, parameter[0].replaceAll(",", "_"));
            rst = pstmt.executeQuery();
            while (rst.next()) {
                info = new String[6];
                formulaString = rst.getString("FFormula");
                para = this.getFormulaInfo(formulaMap, formulaString);
                if (!para[2].equals(parameter[2])) continue;
                if (para[1] != null && para[1].trim().length() > 0) {
                    periodSet.add(para[1]);
                }
                currencySet.add(rst.getString("FCurrencyID"));
                info[0] = rst.getString("FBgSchemeId");
                bgSchemeSet.add(info[0]);
                info[1] = para[1];
                info[3] = rst.getString("FCurrencyID");
                info[4] = rst.getBigDecimal("FBgValue").toString();
                info[5] = rst.getBigDecimal("FBizActual").toString();
                hisData.add(info);
            }
            if (hisData.size() > 1) {
                BgPeriodCollection periodCol = null;
                BgPeriodInfo periodInfo = null;
                IBgPeriod ibgPeriod = BgPeriodFactory.getLocalInstance(ctx);
                if (ibgPeriod != null) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", periodSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    view.getSelector().addObjectCollection((IObjectCollection)this.getBgPeriod());
                    periodCol = ibgPeriod.getBgPeriodCollection(view);
                    Iterator iter = periodCol.iterator();
                    while (iter.hasNext()) {
                        periodInfo = (BgPeriodInfo)iter.next();
                        if (periodMap.containsKey(periodInfo.getNumber())) continue;
                        periodMap.put(periodInfo.getNumber(), periodInfo);
                    }
                }
                CurrencyCollection currencyCol = null;
                CurrencyInfo currencyInfo2222 = null;
                ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                if (icurrency != null) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", currencySet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    view.getSelector().addObjectCollection((IObjectCollection)this.getCurrency());
                    currencyCol = icurrency.getCurrencyCollection(view);
                    for (CurrencyInfo currencyInfo2222 : currencyCol) {
                        if (currencyMap.containsKey(currencyInfo2222.getNumber())) continue;
                        currencyMap.put(currencyInfo2222.getId().toString(), currencyInfo2222);
                    }
                }
                BgSchemeInfo bgSchemeInfo = null;
                BgSchemeCollection bgSchemeCol = null;
                IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
                if (iBgScheme == null) {
                    throw new BgException(BgException.NOINSTANCE);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", bgSchemeSet, CompareType.INCLUDE));
                view.setFilter(filter);
                view.getSelector().addObjectCollection((IObjectCollection)this.getSelected());
                bgSchemeCol = iBgScheme.getBgSchemeCollection(view);
                Iterator iter = bgSchemeCol.iterator();
                while (iter.hasNext()) {
                    bgSchemeInfo = (BgSchemeInfo)iter.next();
                    if (bgSchemeMap.containsKey(bgSchemeInfo.getId().toString())) continue;
                    bgSchemeMap.put(bgSchemeInfo.getId().toString(), bgSchemeInfo);
                }
                int n = hisData.size();
                for (int i = 1; i < n; ++i) {
                    info = (String[])hisData.get(i);
                    bgSchemeInfo = (BgSchemeInfo)bgSchemeMap.get(info[0]);
                    periodInfo = (BgPeriodInfo)periodMap.get(info[1]);
                    currencyInfo2222 = (CurrencyInfo)currencyMap.get(info[3]);
                    info[0] = bgSchemeInfo.getName();
                    info[2] = periodInfo.getPeriodType().getAlias();
                    info[3] = currencyInfo2222.getName();
                    if (info[4] != null && info[4].trim().length() > 0) {
                        info[4] = new BigDecimal(info[4]).setScale(currencyInfo2222.getPrecision(), 4).toString();
                    }
                    if (info[5] == null || info[5].trim().length() <= 0) continue;
                    info[5] = new BigDecimal(info[5]).setScale(currencyInfo2222.getPrecision(), 4).toString();
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
                catch (BOSException ex3) {
                    throw ex3;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return hisData;
    }

    protected String[] getFormulaInfo(Map map, String formulaString) {
        if (map == null || formulaString == null) {
            return null;
        }
        String[] parameter = null;
        List formulaHint = null;
        FormulaHint formulas = null;
        if (map.containsKey(formulaString)) {
            parameter = (String[])map.get(formulaString);
        } else {
            try {
                formulaHint = TableToolkit.parseFormula((String)formulaString, (boolean)false);
            }
            catch (ParserException ex) {
                logger.error((Object)ex.getMessage());
            }
            if (formulaHint != null) {
                formulas = (FormulaHint)formulaHint.get(0);
                parameter = formulas.getParams();
                map.put(formulaString, parameter);
                formulaHint.clear();
            }
        }
        return parameter;
    }

    @Override
    protected String _getItemCombinName(Context ctx, String itemCombinId, String orgUnitId) throws BOSException, EASBizException {
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)"select fkey from t_bg_bgitemcombination where fid = ?", (Object[])new Object[]{itemCombinId});
        String number = "";
        String name = "";
        try {
            if (set.next()) {
                number = set.getString(1);
            }
            if (!number.equals("")) {
                String[] numbers = number.split("_");
                for (int i = 0; i < numbers.length; ++i) {
                    number = numbers[i];
                    set = DbUtil.executeQuery((Context)ctx, (String)("select fname_" + ctx.getLocale() + " from t_bg_bgitem where fnumber = ? and forgUnitId = ? "), (Object[])new Object[]{number, BgSHelper.getIsolateOrg(ctx, orgUnitId)});
                    if (!set.next()) continue;
                    name = name + set.getString(1) + "_";
                }
                name = name.substring(0, name.length() - 1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return name;
    }

    @Override
    protected String _getItemCombinNumber(Context ctx, String itemCombinId) throws BOSException, EASBizException {
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)"select fkey from t_bg_bgitemcombination where fid = ?", (Object[])new Object[]{itemCombinId});
        String number = "";
        try {
            if (set.next()) {
                number = set.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return number;
    }

    @Override
    protected String _getBgFormid(Context ctx, String bgDataId) throws BOSException {
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)"select fbgformid from T_BG_BGdata where fid= ?", (Object[])new Object[]{bgDataId});
        String bgformid = "";
        try {
            if (set.next()) {
                bgformid = set.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return bgformid;
    }

    @Override
    protected Map _getRollHistoryData(Context ctx, String bgFormId, String formula) throws BOSException, EASBizException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String[] parameter = null;
        String[] items = null;
        String orgUnitId = null;
        String bgSchemeId = null;
        BgFormInfo bgFormInfo = null;
        String adjustId = null;
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId));
        adjustId = bgFormInfo.getAdjust().getId().toString();
        orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        parameter = BgNFSHelper.parseFormulaPara((String)formula);
        items = parameter[0].split(",");
        BgItemCollection itemCol = null;
        BgItemInfo itemInfo = null;
        String itemString = null;
        IBgItem ibgItem = BgItemFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(Arrays.asList(items)), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(ctx, orgUnitId), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)this.getSelected());
        itemCol = ibgItem.getBgItemCollection(view);
        Iterator iter = itemCol.iterator();
        while (iter.hasNext()) {
            itemInfo = (BgItemInfo)iter.next();
            if (itemString == null || itemString.trim().length() == 0) {
                itemString = itemInfo.getName();
                continue;
            }
            itemString = itemString + "," + itemInfo.getName();
        }
        res.put("ItemName", itemString);
        BgElementCollection elementCol = null;
        IBgElement ibgElement = BgElementFactory.getLocalInstance(ctx);
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)parameter[2], CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)this.getSelected());
        elementCol = ibgElement.getBgElementCollection(view);
        res.put("ElementName", elementCol.get(0).getName());
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        BigDecimal bgValue = BigDecimal.ZERO;
        StringBuffer strSql = new StringBuffer();
        strSql.append("SELECT FBgValue FROM T_BG_BGDATA WHERE FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula = ?");
        Connection conn = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            pstm = conn.prepareStatement(strSql.toString());
            pstm.setString(1, orgUnitId);
            pstm.setString(2, bgSchemeId);
            pstm.setString(3, formula);
            rs = pstm.executeQuery();
            if (rs.next()) {
                bgValue = rs.getBigDecimal("FBgValue");
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgException(BgFormException.DATABASEERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)conn);
        Object[] dataObj = null;
        BgFormCollection formCol = null;
        BgFormInfo form = null;
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adjust.id", (Object)adjustId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)15, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dataSource", (Object)13, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("versionNo"));
        sic.add(new SelectorItemInfo("dataSource"));
        sic.add(new SelectorItemInfo("bgRollPeriod.number"));
        sic.add(new SelectorItemInfo("auditTime"));
        view.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("versionNo"));
        view.setSorter(sorter);
        formCol = iBgForm.getBgFormCollection(view);
        for (int i = 0; i < formCol.size(); ++i) {
            form = formCol.get(i);
            dataObj = new Object[]{form.getId().toString(), form.getVersionNo().setScale(1), form.getDataSource(), form.getBgRollPeriod().getNumber(), bgValue, form.getAuditTime()};
            dataList.add(dataObj);
        }
        if (dataList.size() > 0) {
            strSql = new StringBuffer();
            strSql.append("SELECT pastrecord.FCreateTime, pastdata.FPastValue ").append(" FROM T_BG_BGPASTRECORD pastrecord, T_BG_BGPASTDATA pastdata, T_BG_BGDATA data").append(" WHERE pastrecord.FID = pastdata.FPastRecordID AND pastdata.FBgDataID = data.FID ").append(" AND data.FOrgUnitId = ? AND data.FBgSchemeId = ? AND data.FFormula = ? ");
            Timestamp createTime = null;
            try {
                conn = this.getConnection(ctx);
                pstm = conn.prepareStatement(strSql.toString());
                pstm.setString(1, orgUnitId);
                pstm.setString(2, bgSchemeId);
                pstm.setString(3, formula);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    createTime = rs.getTimestamp("FCreateTime");
                    for (int i = 0; i < dataList.size(); ++i) {
                        dataObj = (Object[])dataList.get(i);
                        if (!((Timestamp)dataObj[5]).before(createTime)) continue;
                        dataObj[4] = ((BigDecimal)dataObj[4]).subtract(rs.getBigDecimal("FPastValue"));
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BgException(BgFormException.DATABASEERROR);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)conn);
            }
        }
        res.put("VersionData", dataList);
        return res;
    }
}

