/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.budget.ActualTypeEnum;
import com.kingdee.eas.ma.budget.BgCtrlRecordCollection;
import com.kingdee.eas.ma.budget.BgCtrlRecordInfo;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgDataFactory;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgDataMoveAfterOrgMoveFacadeFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BgTraceTypeEnum;
import com.kingdee.eas.ma.budget.BudgetCtrlConstants;
import com.kingdee.eas.ma.budget.BudgetCtrlFacadeFactory;
import com.kingdee.eas.ma.budget.BudgetCtrlState;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.BudgetRequestType;
import com.kingdee.eas.ma.budget.IBgData;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.app.AbstractBgDataMoveAfterOrgMoveFacadeControllerBean;
import com.kingdee.eas.ma.budget.app.BudgetCtrlHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgDataMoveAfterOrgMoveFacadeControllerBean
extends AbstractBgDataMoveAfterOrgMoveFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgDataMoveAfterOrgMoveFacadeControllerBean");

    @Override
    protected void _updateBgItem(Context ctx, String orgId, String newParentId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select FID from t_bg_bgItem \n");
        sb.append("where FAssignRootOrgID = '" + orgId + "' \n");
        sb.append("\t\tand FID not in ( \n");
        sb.append("\t\t\tselect FID from t_bg_bgItem \n");
        sb.append("\t\t\twhere FAssignRootOrgID = '" + newParentId + "') \n");
        String paramValue = null;
        IRowSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs == null) {
                return;
            }
            paramValue = ParamManager.getParamValue((Context)ctx, null, (String)"BG063");
            if (paramValue.equals("false")) {
                while (rs.next()) {
                    list.add(rs.getString("FID"));
                }
                StringBuffer sql = new StringBuffer();
                sql.append("update t_bg_bgItem set FCurOrgUnitLongNumber =  \n");
                sql.append("( \n");
                sql.append("\tselect FLongNumber \n");
                sql.append("\t\tfrom t_org_baseUnit \n");
                sql.append("\twhere FID = '" + orgId + "' \n");
                sql.append(") \n");
                sql.append("where FID in ( \n");
                for (int i = 0; i < list.size(); ++i) {
                    sql.append("'" + list.get(i).toString() + "'");
                    if (i == list.size() - 1) continue;
                    sql.append(",");
                }
                sql.append(") \n");
                sql.append(" \n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _checkBgData(Context ctx, String orgId) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select 1 \n");
        sb.append("from t_bg_bgData \n");
        sb.append("where FOrgUnitId = '" + orgId + "' \n");
        sb.append("\t\tand \n");
        sb.append("\t\t\t( \n");
        sb.append("\t\t\t\tFBgValue <> 0 \n");
        sb.append("\t\t\t\tor FBgActual <> 0 \n");
        sb.append("\t\t\t) \n");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        return false;
    }

    @Override
    protected TreeModel _getOldParentTreeModel(Context ctx, String orgId, OrgViewType orgViewType, String oldParentId) throws BOSException, EASBizException {
        int i;
        if (StringUtils.isEmpty((String)orgId)) {
            orgId = ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString();
        }
        if (orgViewType == null) {
            orgViewType = OrgViewType.COSTCENTER;
        }
        String treeid = NewOrgViewHelper.convert2TreeId((OrgViewType)orgViewType);
        OrgStructureInfo selectNode = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("select id, longnumber ,unit.id,unit.number,unit.longnumber,unit.name where unit.id = '" + orgId + "' and tree.id = '" + NewOrgViewHelper.convert2TreeId((OrgViewType)orgViewType) + "'");
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)selectNode);
        IRowSet rs = null;
        String longNumber = null;
        String[] longNumberArr = null;
        ArrayList<OrgStructureInfo> orgStructureList = new ArrayList<OrgStructureInfo>();
        ArrayList<String> orgStructureNameList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("select FLongNumber \n");
        sb.append("from t_org_baseUnit \n");
        sb.append("where FID = '" + oldParentId + "' \n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                longNumber = rs.getString("FLongNumber");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (longNumber != null) {
            longNumberArr = longNumber.split("!");
            OrgStructureInfo orgStructure = null;
            for (int i2 = 1; i2 < longNumberArr.length; ++i2) {
                orgStructure = this.getOrgStructureFromNumber(ctx, longNumberArr[i2], orgViewType);
                orgStructureList.add(orgStructure);
                orgStructureNameList.add(orgStructure.getUnit().getName());
            }
        }
        DefaultKingdeeTreeNode node = this.getChildNode(ctx, orgViewType, treeid, rootNode);
        ArrayList<DefaultKingdeeTreeNode> delChildNodeList = new ArrayList<DefaultKingdeeTreeNode>();
        for (i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (orgStructureNameList.contains(childNode.getText())) continue;
            delChildNodeList.add(childNode);
        }
        for (i = 0; i < delChildNodeList.size(); ++i) {
            node.remove((MutableTreeNode)((DefaultKingdeeTreeNode)delChildNodeList.get(i)));
        }
        delChildNodeList.clear();
        node.setTextColor(Color.BLACK);
        this.buildTreeModel(ctx, node, orgStructureNameList);
        return new DefaultTreeModel((TreeNode)node);
    }

    private void buildTreeModel(Context ctx, DefaultKingdeeTreeNode node, List orgStructureNameList) throws EASBizException, BOSException {
        int count = node.getChildCount();
        ArrayList<DefaultKingdeeTreeNode> delChildNodeList = new ArrayList<DefaultKingdeeTreeNode>();
        for (int index = 0; index < count; ++index) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(index);
            childNode.setTextColor(Color.BLACK);
            OrgStructureInfo orginfo = (OrgStructureInfo)childNode.getUserObject();
            String unitId = orginfo.getUnit().getId().toString();
            FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitId));
            if (fullOrgUnitInfo.isIsLeaf()) continue;
            this.getChildNode(ctx, null, null, childNode);
            for (int j = 0; j < childNode.getChildCount(); ++j) {
                DefaultKingdeeTreeNode childNode2 = (DefaultKingdeeTreeNode)childNode.getChildAt(j);
                if (orgStructureNameList.contains(childNode2.getText())) continue;
                delChildNodeList.add(childNode2);
            }
            for (int i = 0; i < delChildNodeList.size(); ++i) {
                childNode.remove((MutableTreeNode)((DefaultKingdeeTreeNode)delChildNodeList.get(i)));
            }
            delChildNodeList.clear();
            this.buildTreeModel(ctx, childNode, orgStructureNameList);
        }
    }

    private DefaultKingdeeTreeNode getChildNode(Context ctx, OrgViewType orgViewType, String treeid, DefaultKingdeeTreeNode node) throws EASBizException, BOSException {
        if (orgViewType == null) {
            orgViewType = OrgViewType.COSTCENTER;
        }
        if (StringUtils.isEmpty((String)treeid)) {
            treeid = NewOrgViewHelper.convert2TreeId((OrgViewType)orgViewType);
        }
        return NewOrgViewFacadeFactory.getLocalInstance((Context)ctx).getViewDirectChildNodesByMultiCondition(orgViewType, treeid, true, true, node, true, true, null, null, null);
    }

    public OrgStructureInfo getOrgStructureFromNumber(Context ctx, String number, OrgViewType orgViewType) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        IRowSet rs = null;
        String orgId = null;
        OrgStructureInfo selectNode = null;
        sql.append("select FID \n");
        sql.append("from t_org_baseUnit \n");
        sql.append("where FNumber = '" + number + "' \n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                orgId = rs.getString("FID");
            }
            if (orgId != null) {
                selectNode = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("select id, longnumber ,unit.id,unit.number,unit.longnumber,unit.name where unit.id = '" + orgId + "' and tree.id = '" + NewOrgViewHelper.convert2TreeId((OrgViewType)orgViewType) + "'");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return selectNode;
    }

    @Override
    protected TreeModel _getNewParentTreModel(Context ctx, String orgId, OrgViewType orgViewType, String moveOrgId) throws BOSException, EASBizException {
        int i;
        if (StringUtils.isEmpty((String)orgId)) {
            orgId = ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString();
        }
        if (orgViewType == null) {
            orgViewType = OrgViewType.COSTCENTER;
        }
        String treeid = NewOrgViewHelper.convert2TreeId((OrgViewType)orgViewType);
        OrgStructureInfo selectNode = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("select id, longnumber ,unit.id,unit.number,unit.longnumber,unit.name where unit.id = '" + orgId + "' and tree.id = '" + NewOrgViewHelper.convert2TreeId((OrgViewType)orgViewType) + "'");
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)selectNode);
        IRowSet rs = null;
        String longNumber = null;
        String[] longNumberArr = null;
        ArrayList<OrgStructureInfo> orgStructureList = new ArrayList<OrgStructureInfo>();
        ArrayList<String> orgStructureNameList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("select FLongNumber \n");
        sb.append("from t_org_baseUnit \n");
        sb.append("where FID = '" + moveOrgId + "' \n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                longNumber = rs.getString("FLongNumber");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (longNumber != null) {
            longNumberArr = longNumber.split("!");
            OrgStructureInfo orgStructure = null;
            for (int i2 = 1; i2 < longNumberArr.length - 1; ++i2) {
                orgStructure = this.getOrgStructureFromNumber(ctx, longNumberArr[i2], orgViewType);
                orgStructureList.add(orgStructure);
                orgStructureNameList.add(orgStructure.getUnit().getName());
            }
        }
        DefaultKingdeeTreeNode node = this.getChildNode(ctx, orgViewType, treeid, rootNode);
        ArrayList<DefaultKingdeeTreeNode> delChildNodeList = new ArrayList<DefaultKingdeeTreeNode>();
        for (i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (orgStructureNameList.contains(childNode.getText())) continue;
            delChildNodeList.add(childNode);
        }
        for (i = 0; i < delChildNodeList.size(); ++i) {
            node.remove((MutableTreeNode)((DefaultKingdeeTreeNode)delChildNodeList.get(i)));
        }
        delChildNodeList.clear();
        node.setTextColor(Color.BLACK);
        this.buildTreeModel(ctx, node, orgStructureNameList);
        return new DefaultTreeModel((TreeNode)node);
    }

    @Override
    protected void _collectCtrlResult(Context ctx, List ctrlRecordIds, Map orgMap) throws BOSException, EASBizException {
        if (ctrlRecordIds == null || ctrlRecordIds.isEmpty() || orgMap == null || orgMap.isEmpty()) {
            return;
        }
        BgCtrlResultCollection col = this.getCtrlResultCol(ctx, ctrlRecordIds, "FID", false);
        this.setCtrlResultOtherInfo(ctx, col);
        col = this.filterBgCtrlResultCollection(col, orgMap);
        this.collectCtrlResultCol(ctx, col, orgMap);
    }

    private BgCtrlResultCollection filterBgCtrlResultCollection(BgCtrlResultCollection coll, Map orgMap) {
        BgCtrlResultCollection newColl = new BgCtrlResultCollection();
        if (coll != null && orgMap != null) {
            String orgUnitID = null;
            for (int i = 0; i < coll.size(); ++i) {
                orgUnitID = coll.get(i).getOrgUnitId();
                if (orgUnitID == null || !orgMap.containsKey(orgUnitID)) continue;
                newColl.add(coll.get(i));
            }
        }
        return newColl;
    }

    private void collectCtrlResultCol(Context ctx, BgCtrlResultCollection col, Map orgMap) throws BOSException, EASBizException {
        if (col == null || col.isEmpty()) {
            return;
        }
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.WF_APPROVE);
        List ctrlRecordIds = this.getCtrlRecordIds(col);
        this.setCollectedFlag(ctx, ctrlRecordIds);
        this.collectCtrlDataImmediately(ctx, state, col, orgMap);
    }

    private Set isLeagalStateToRequestBudget(Context ctx, Set parentOrgIds, Set parentSchemeIds, String formula) throws BOSException {
        HashSet<String> res = new HashSet<String>();
        if (parentOrgIds == null || parentOrgIds.isEmpty()) {
            return res;
        }
        if (parentSchemeIds == null || parentSchemeIds.isEmpty()) {
            return res;
        }
        if (formula == null) {
            return res;
        }
        IBgData iBgData = BgDataFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)parentOrgIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)parentSchemeIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("formula", (Object)formula, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dataState", (Object)9, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("orgUnit.id");
        sic.add("bgScheme.id");
        sic.add("formula");
        CoreBaseCollection col = iBgData.getCollection(view);
        if (col != null) {
            BgDataInfo data = null;
            String key = null;
            for (int i = 0; i < col.size(); ++i) {
                data = (BgDataInfo)col.get(i);
                key = data.getOrgUnit().getId().toString() + "-" + data.getBgScheme().getId().toString() + "-" + data.getFormula();
                if (res.contains(key)) continue;
                res.add(key);
            }
        }
        return res;
    }

    private void filterParentOrgMap(Map orgId2parentOrgMap, Map orgMap) {
        if (orgId2parentOrgMap != null && orgMap != null) {
            Set set = orgId2parentOrgMap.entrySet();
            CostCenterOrgUnitInfo ccInfo = null;
            Map.Entry entry2 = null;
            String key = null;
            List value = null;
            ArrayList<CostCenterOrgUnitInfo> newValue = null;
            for (Map.Entry entry2 : set) {
                key = (String)entry2.getKey();
                value = (List)entry2.getValue();
                if (value == null) continue;
                newValue = new ArrayList<CostCenterOrgUnitInfo>();
                for (int i = 0; i < value.size(); ++i) {
                    ccInfo = (CostCenterOrgUnitInfo)value.get(i);
                    if (!orgMap.containsKey(ccInfo.getId().toString())) continue;
                    newValue.add(ccInfo);
                }
                orgId2parentOrgMap.put(key, newValue);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectCtrlDataImmediately(Context ctx, BudgetCtrlState state, BgCtrlResultCollection ctrlResultCol, Map orgMap) throws EASBizException, BOSException {
        PreparedStatement deleteCtrlRecordSta;
        PreparedStatement updateCtrlRecordSta;
        PreparedStatement insertCtrlRecordSta;
        PreparedStatement updateBgDataSta;
        IRowSet rst;
        Connection conn;
        HashMap org2parentOrgSchemeMap;
        block25: {
            if (ctrlResultCol == null || ctrlResultCol.isEmpty()) {
                return;
            }
            HashSet<String> orgIdSet = new HashSet<String>();
            HashSet<String> billIdSet = new HashSet<String>();
            HashMap<String, String> orgId2schemeIdMap = new HashMap<String, String>();
            for (int i = 0; i < ctrlResultCol.size(); ++i) {
                BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
                if (!BudgetCtrlHelper.isCanCollect(ctrlResultInfo)) continue;
                String orgUnitId = ctrlResultInfo.getOrgUnitId();
                String bgSchemeId = ctrlResultInfo.getBgSchemeId();
                String billId = ctrlResultInfo.getBillId();
                orgId2schemeIdMap.put(orgUnitId, bgSchemeId);
                orgIdSet.add(orgUnitId);
                billIdSet.add(billId);
            }
            if (BudgetCtrlUtil.isEmpty(orgIdSet) || BudgetCtrlUtil.isEmpty(orgId2schemeIdMap)) {
                orgIdSet.clear();
                orgId2schemeIdMap.clear();
                return;
            }
            Map orgId2parentOrgMap = BudgetCtrlHelper.getAllParentOrgMap(ctx, orgIdSet);
            this.filterParentOrgMap(orgId2parentOrgMap, orgMap);
            if (BudgetCtrlUtil.isEmpty(orgId2parentOrgMap)) {
                return;
            }
            org2parentOrgSchemeMap = new HashMap();
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            String userId = user != null ? user.getId().toString() : "";
            Date time = new Date(System.currentTimeMillis());
            conn = null;
            rst = null;
            updateBgDataSta = null;
            insertCtrlRecordSta = null;
            updateCtrlRecordSta = null;
            deleteCtrlRecordSta = null;
            try {
                for (int i = 0; i < ctrlResultCol.size(); ++i) {
                    String parentOrgId;
                    List parents;
                    BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
                    if (!BudgetCtrlHelper.isCanCollect(ctrlResultInfo)) continue;
                    Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
                    boolean isRequestBudget = true;
                    if (obj instanceof Boolean) {
                        isRequestBudget = (Boolean)obj;
                    }
                    if (!isRequestBudget) continue;
                    String orgUnitId = ctrlResultInfo.getOrgUnitId();
                    String schemeId = (String)orgId2schemeIdMap.get(orgUnitId);
                    if (org2parentOrgSchemeMap.containsKey(orgUnitId) || BudgetCtrlUtil.isEmpty(parents = (List)orgId2parentOrgMap.get(orgUnitId))) continue;
                    StringBuffer parentOrgIds = new StringBuffer("(");
                    for (int j = 0; j < parents.size(); ++j) {
                        CostCenterOrgUnitInfo parent = (CostCenterOrgUnitInfo)parents.get(j);
                        parentOrgId = parent.getId().toString();
                        if (j == 0) {
                            parentOrgIds.append("'").append(parentOrgId).append("'");
                            continue;
                        }
                        parentOrgIds.append(",'").append(parentOrgId).append("'");
                    }
                    parentOrgIds.append(")");
                    StringBuffer kSQL = new StringBuffer();
                    kSQL.append(" select FOrgUnitId,");
                    kSQL.append("        FId");
                    kSQL.append("   from T_BG_BgScheme");
                    kSQL.append("  where FOrgUnitId in " + parentOrgIds.toString());
                    kSQL.append("    and frootid = (select FRootId from T_BG_BgScheme where FId = ?)");
                    kSQL.append("    and FId <> ?");
                    rst = DbUtil.executeQuery((Context)ctx, (String)kSQL.toString(), (Object[])new String[]{schemeId, schemeId});
                    HashMap<String, String> parentOrg2SchemeMap = new HashMap<String, String>();
                    while (rst.next()) {
                        parentOrgId = rst.getString("FOrgUnitId");
                        String parentSchemeId = rst.getString("FId");
                        parentOrg2SchemeMap.put(parentOrgId, parentSchemeId);
                    }
                    org2parentOrgSchemeMap.put(orgUnitId, parentOrg2SchemeMap);
                }
                conn = this.getConnection(ctx);
                StringBuffer updateBgDataSQL = new StringBuffer();
                updateBgDataSQL.append(" update T_BG_BgData ");
                updateBgDataSQL.append("    set FBizActual = FBizActual + ?");
                updateBgDataSQL.append("  where FOrgUnitId= ?");
                updateBgDataSQL.append("    and FBgSchemeId = ?");
                updateBgDataSQL.append("    and FFormula = ?");
                updateBgDataSta = conn.prepareStatement(updateBgDataSQL.toString());
                StringBuffer insertCtrlRecordSQL = new StringBuffer();
                insertCtrlRecordSQL.append(" insert into T_BG_BgCtrlRecord");
                insertCtrlRecordSQL.append("   (FId,");
                insertCtrlRecordSQL.append("    FCreatorId,");
                insertCtrlRecordSQL.append("    FCreateTime,");
                insertCtrlRecordSQL.append("    FLastUpdateUserId,");
                insertCtrlRecordSQL.append("    FLastUpdateTime,");
                insertCtrlRecordSQL.append("    FControlUnitId,");
                insertCtrlRecordSQL.append("    FBgDataId,");
                insertCtrlRecordSQL.append("    FBillId,");
                insertCtrlRecordSQL.append("    FBillName,");
                insertCtrlRecordSQL.append("    FBillNumber,");
                insertCtrlRecordSQL.append("    FBillAlias,");
                insertCtrlRecordSQL.append("    FBillType,");
                insertCtrlRecordSQL.append("    FBizDate,");
                insertCtrlRecordSQL.append("    FActualAmount,");
                insertCtrlRecordSQL.append("    FBillOperate,");
                insertCtrlRecordSQL.append("    FBgPeriodId,");
                insertCtrlRecordSQL.append("    FItemName,");
                insertCtrlRecordSQL.append("    FBgTraceType,");
                insertCtrlRecordSQL.append("    FOrgUnitId,");
                insertCtrlRecordSQL.append("    FBgSchemeId,");
                insertCtrlRecordSQL.append("    FItemFormula,");
                insertCtrlRecordSQL.append("    FPayState,");
                insertCtrlRecordSQL.append("    FISCollected,");
                insertCtrlRecordSQL.append("    FDayDate,");
                insertCtrlRecordSQL.append("    FActualType,");
                insertCtrlRecordSQL.append("    FBillSourceOrgunitID ) ");
                insertCtrlRecordSQL.append(" values (newbosid('FF6153C2'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                insertCtrlRecordSta = conn.prepareStatement(insertCtrlRecordSQL.toString());
                StringBuffer updateCtrlRecordSQL = new StringBuffer();
                updateCtrlRecordSQL.append(" update T_BG_BgCtrlRecord");
                updateCtrlRecordSQL.append("    set FBgDataId = (select FId");
                updateCtrlRecordSQL.append("                         from T_BG_BgData");
                updateCtrlRecordSQL.append("                        where FOrgUnitId = ?");
                updateCtrlRecordSQL.append("                          and FBgSchemeId = ?");
                updateCtrlRecordSQL.append("                          and FFormula = ?");
                updateCtrlRecordSQL.append("                        )");
                updateCtrlRecordSQL.append("  where FBillId = ?");
                updateCtrlRecordSQL.append("    and FOrgUnitId = ?");
                updateCtrlRecordSQL.append("    and FBgSchemeId = ?");
                updateCtrlRecordSQL.append("    and FItemFormula = ?");
                updateCtrlRecordSta = conn.prepareStatement(updateCtrlRecordSQL.toString());
                StringBuffer deleteKSQL = new StringBuffer();
                deleteKSQL.append(" delete T_BG_BgCtrlRecord where FBillId = ? and FBgDataId is null ");
                deleteCtrlRecordSta = conn.prepareStatement(deleteKSQL.toString());
                BgCtrlRecordCollection ctrlRecordCol = new BgCtrlRecordCollection();
                int batchCounter = 0;
                boolean isRunUpdate = false;
                for (int i2 = 0; i2 < ctrlResultCol.size(); ++i2) {
                    String orgUnitId;
                    Map parentOrg2SchemeMap;
                    BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i2);
                    if (!BudgetCtrlHelper.isCanCollect(ctrlResultInfo) || ctrlResultInfo.getReqAmount() != null && ctrlResultInfo.getReqAmount().compareTo(BgNConstants.ZERO) == 0) continue;
                    Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
                    boolean isRequestBudget = true;
                    if (obj instanceof Boolean) {
                        isRequestBudget = (Boolean)obj;
                    }
                    if (!isRequestBudget || BudgetCtrlUtil.isEmpty(parentOrg2SchemeMap = (Map)org2parentOrgSchemeMap.get(orgUnitId = ctrlResultInfo.getOrgUnitId()))) continue;
                    String formula = ctrlResultInfo.getBgItemFormula();
                    BigDecimal actualValue = ctrlResultInfo.getReqAmount();
                    Set leagalBgDataCol = this.isLeagalStateToRequestBudget(ctx, new HashSet(parentOrg2SchemeMap.keySet()), new HashSet(parentOrg2SchemeMap.values()), formula);
                    for (String orgId : parentOrg2SchemeMap.keySet()) {
                        String schemeId = (String)parentOrg2SchemeMap.get(orgId);
                        String key = orgId + "-" + schemeId + "-" + formula;
                        if (!leagalBgDataCol.contains(key)) continue;
                        updateBgDataSta.setBigDecimal(1, actualValue);
                        updateBgDataSta.setString(2, orgId);
                        updateBgDataSta.setString(3, schemeId);
                        updateBgDataSta.setString(4, formula);
                        updateBgDataSta.addBatch();
                        BgCtrlRecordInfo ctrlRecordInfo = new BgCtrlRecordInfo();
                        ctrlRecordInfo.setBgDataId(null);
                        ctrlRecordInfo.setBillId(ctrlResultInfo.getBillId());
                        ctrlRecordInfo.setBillNumber(ctrlResultInfo.getBillNumber());
                        ctrlRecordInfo.setBillName(ctrlResultInfo.getBillNumber());
                        ctrlRecordInfo.setBillAlias(ctrlResultInfo.getBillType());
                        ctrlRecordInfo.setBillType(BudgetCtrlHelper.getTypeAllias(ctrlResultInfo.getBillType(), BgTraceTypeEnum.SumFromLower));
                        ctrlRecordInfo.setBizDate(ctrlResultInfo.getBizDate());
                        ctrlRecordInfo.setActualAmount(ctrlResultInfo.getReqAmount());
                        ctrlRecordInfo.setItemName(ctrlResultInfo.getItemCombinName());
                        ctrlRecordInfo.setBgPeriodId(ctrlResultInfo.getBgPeriodNumber());
                        ctrlRecordInfo.setOrgUnitId(orgId);
                        ctrlRecordInfo.setBgSchemeId(schemeId);
                        ctrlRecordInfo.setItemFormula(formula);
                        ctrlRecordInfo.setBgTraceType(BgTraceTypeEnum.SumFromLower);
                        ctrlRecordInfo.setIsCollected(true);
                        ctrlRecordInfo.setActualType(ctrlResultInfo.getActualType());
                        ctrlRecordInfo.setBillSourceOrgunitID(ctrlResultInfo.getBillSourceOrgunitID());
                        ctrlRecordCol.add(ctrlRecordInfo);
                        insertCtrlRecordSta.setString(1, userId);
                        insertCtrlRecordSta.setDate(2, time);
                        insertCtrlRecordSta.setString(3, userId);
                        insertCtrlRecordSta.setDate(4, time);
                        insertCtrlRecordSta.setString(5, ctrlRecordInfo.getOrgUnitId());
                        insertCtrlRecordSta.setString(6, ctrlRecordInfo.getBgDataId());
                        insertCtrlRecordSta.setString(7, ctrlRecordInfo.getBillId());
                        insertCtrlRecordSta.setString(8, ctrlRecordInfo.getBillName());
                        insertCtrlRecordSta.setString(9, ctrlRecordInfo.getBillNumber());
                        insertCtrlRecordSta.setString(10, ctrlRecordInfo.getBillAlias());
                        insertCtrlRecordSta.setString(11, ctrlRecordInfo.getBillType());
                        insertCtrlRecordSta.setDate(12, ctrlRecordInfo.getBizDate() != null ? new Date(ctrlRecordInfo.getBizDate().getTime()) : null);
                        insertCtrlRecordSta.setBigDecimal(13, ctrlRecordInfo.getActualAmount());
                        insertCtrlRecordSta.setString(14, ctrlRecordInfo.getBillOperate());
                        insertCtrlRecordSta.setString(15, ctrlRecordInfo.getBgPeriodId());
                        insertCtrlRecordSta.setString(16, ctrlRecordInfo.getItemName());
                        insertCtrlRecordSta.setInt(17, ctrlRecordInfo.getBgTraceType().getValue());
                        insertCtrlRecordSta.setString(18, ctrlRecordInfo.getOrgUnitId());
                        insertCtrlRecordSta.setString(19, ctrlRecordInfo.getBgSchemeId());
                        insertCtrlRecordSta.setString(20, ctrlRecordInfo.getItemFormula());
                        insertCtrlRecordSta.setInt(21, 0);
                        insertCtrlRecordSta.setInt(22, ctrlRecordInfo.isIsCollected() ? 1 : 0);
                        insertCtrlRecordSta.setDate(23, ctrlRecordInfo.getBizDate() != null ? new Date(ctrlRecordInfo.getBizDate().getTime()) : null);
                        if (BudgetCtrlState.isOccupation(state)) {
                            insertCtrlRecordSta.setInt(24, 10);
                        } else if (ctrlRecordInfo.getActualType() != null) {
                            insertCtrlRecordSta.setInt(24, ctrlRecordInfo.getActualType().getValue());
                        } else {
                            insertCtrlRecordSta.setInt(24, 20);
                        }
                        insertCtrlRecordSta.setString(25, ctrlRecordInfo.getBillSourceOrgunitID());
                        insertCtrlRecordSta.addBatch();
                        updateCtrlRecordSta.setString(1, orgId);
                        updateCtrlRecordSta.setString(2, schemeId);
                        updateCtrlRecordSta.setString(3, formula);
                        updateCtrlRecordSta.setString(4, ctrlResultInfo.getBillId());
                        updateCtrlRecordSta.setString(5, orgId);
                        updateCtrlRecordSta.setString(6, schemeId);
                        updateCtrlRecordSta.setString(7, formula);
                        updateCtrlRecordSta.addBatch();
                        if (!isRunUpdate) {
                            isRunUpdate = true;
                        }
                        if (++batchCounter < 200) continue;
                        updateBgDataSta.executeBatch();
                        insertCtrlRecordSta.executeBatch();
                        updateCtrlRecordSta.executeBatch();
                        batchCounter = 0;
                    }
                }
                if (!isRunUpdate) break block25;
                if (batchCounter != 0) {
                    updateBgDataSta.executeBatch();
                    insertCtrlRecordSta.executeBatch();
                    updateCtrlRecordSta.executeBatch();
                }
                batchCounter = 0;
                for (String billId : billIdSet) {
                    this.updateNeverAudit(ctx, billId);
                    deleteCtrlRecordSta.setString(1, billId);
                    deleteCtrlRecordSta.addBatch();
                    if (++batchCounter < 200) continue;
                    deleteCtrlRecordSta.executeBatch();
                    batchCounter = 0;
                }
                if (batchCounter != 0) {
                    deleteCtrlRecordSta.executeBatch();
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, ex);
                    catch (Exception ex2) {
                        logger.error((Object)ex2.getMessage());
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    SQLUtils.cleanup(updateBgDataSta);
                    SQLUtils.cleanup(insertCtrlRecordSta);
                    SQLUtils.cleanup(updateCtrlRecordSta);
                    SQLUtils.cleanup(deleteCtrlRecordSta);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Statement)updateBgDataSta);
        SQLUtils.cleanup((Statement)insertCtrlRecordSta);
        SQLUtils.cleanup((Statement)updateCtrlRecordSta);
        SQLUtils.cleanup((Statement)deleteCtrlRecordSta);
        SQLUtils.cleanup((Connection)conn);
        this.updateUpperOrgUpperItemCtrlData(ctx, state, ctrlResultCol, org2parentOrgSchemeMap);
    }

    private void updateUpperOrgUpperItemCtrlData(Context ctx, BudgetCtrlState state, BgCtrlResultCollection ctrlResultCol, Map org2parentOrgSchemeMap) throws BOSException, EASBizException {
        if (ctrlResultCol == null || ctrlResultCol.size() == 0) {
            return;
        }
        IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            if (!BudgetCtrlHelper.isCanCollect(ctrlResultInfo)) continue;
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (!isRequestBudget) continue;
            BigDecimal actualValue = ctrlResultInfo.getReqAmount();
            String formula = ctrlResultInfo.getBgItemFormula();
            String orgUnitId = ctrlResultInfo.getOrgUnitId();
            Map parentOrg2SchemeMap = (Map)org2parentOrgSchemeMap.get(orgUnitId);
            if (BudgetCtrlUtil.isEmpty(parentOrg2SchemeMap)) continue;
            Set leagalBgDataCol = this.isLeagalStateToRequestBudget(ctx, new HashSet(parentOrg2SchemeMap.keySet()), new HashSet(parentOrg2SchemeMap.values()), formula);
            for (String orgId : parentOrg2SchemeMap.keySet()) {
                String schemeId = (String)parentOrg2SchemeMap.get(orgId);
                String key = orgId + "-" + schemeId + "-" + formula;
                if (!leagalBgDataCol.contains(key)) continue;
                iBgItem.updateBgItemSuperiorValue(BOSUuid.read((String)orgId), BOSUuid.read((String)schemeId), formula, actualValue);
                iBgItem.updateBgItemSuperiorCtrlRecord(BOSUuid.read((String)orgId), BOSUuid.read((String)schemeId), formula, ctrlResultInfo, state == null ? null : state.getCategory());
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateNeverAudit(Context ctx, String billId) throws EASBizException, BOSException {
        ResultSet rst;
        PreparedStatement pstup;
        PreparedStatement pstmt;
        Connection conn;
        block9: {
            StringBuffer upSQL;
            ArrayList<String> bgDataIds;
            block8: {
                conn = null;
                pstmt = null;
                pstup = null;
                rst = null;
                bgDataIds = new ArrayList<String>();
                StringBuffer kSQL = new StringBuffer();
                kSQL.append(" select t.fid ");
                kSQL.append(" from T_BG_BgData t left join T_BG_BgForm f on f.fid = t.fbgformid ");
                kSQL.append(" where f.FState in " + BgHelper.tranArray2Int(BudgetCtrlConstants.INVALIDATE_STATES));
                kSQL.append(" and t.fid in (select fid from T_BG_BgData where fid in (select fbgdataid from T_BG_BgCtrlRecord where FBillId = ?))");
                upSQL = new StringBuffer();
                upSQL.append(" update T_BG_BgCtrlRecord set FBgDataId = null ");
                upSQL.append("  where FBillId = ? ");
                upSQL.append("  and FBgDataId = ? ");
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(kSQL.toString());
                pstmt.setString(1, billId);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgDataIds.add(rst.getString("fid"));
                }
                if (!bgDataIds.isEmpty()) break block8;
                SQLUtils.cleanup((ResultSet)rst);
                SQLUtils.cleanup((Statement)pstmt);
                SQLUtils.cleanup(pstup);
                SQLUtils.cleanup((Connection)conn);
                return;
            }
            try {
                int index = 0;
                int batchSize = 100;
                pstup = conn.prepareStatement(upSQL.toString());
                int jn = bgDataIds.size();
                for (int j = 0; j < jn; ++j) {
                    pstup.setString(1, billId);
                    pstup.setString(2, (String)bgDataIds.get(j));
                    pstup.addBatch();
                    if (++index <= batchSize) continue;
                    pstup.executeBatch();
                    index = 0;
                }
                if (index == 0) break block9;
                pstup.executeBatch();
                index = 0;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, ex);
                    catch (Exception ex2) {
                        logger.error((Object)ex2.getMessage());
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    SQLUtils.cleanup(pstmt);
                    SQLUtils.cleanup(pstup);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)pstup);
        SQLUtils.cleanup((Connection)conn);
        return;
    }

    private void setCollectedFlag(Context ctx, List ctrlRecordIds) throws BOSException {
        int index = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgCtrlRecord set FIsCollected = 1 where FId = ? ");
            int jn = ctrlRecordIds.size();
            for (int j = 0; j < jn; ++j) {
                pstmt.setString(1, (String)ctrlRecordIds.get(j));
                pstmt.addBatch();
                if (++index <= 200) continue;
                pstmt.executeBatch();
                index = 0;
            }
            if (index != 0) {
                pstmt.executeBatch();
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"error", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private List getCtrlRecordIds(BgCtrlResultCollection col) {
        if (col == null || col.isEmpty()) {
            return null;
        }
        ArrayList<String> ctrlRecordIds = new ArrayList<String>();
        for (int i = 0; i < col.size(); ++i) {
            ctrlRecordIds.add(col.get(i).getId().toString());
            col.get(i).setId(null);
        }
        return ctrlRecordIds;
    }

    private void setCtrlResultOtherInfo(Context ctx, BgCtrlResultCollection col) throws BOSException, EASBizException {
        if (col == null || col.isEmpty()) {
            return;
        }
        HashSet<String> bgDataIds = new HashSet<String>();
        for (int i = 0; i < col.size(); ++i) {
            bgDataIds.add(col.get(i).getBgDataId());
        }
        String[] bgFormula = null;
        HashMap<String, String[]> bgDataIdMap = new HashMap<String, String[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FOrgUnitId, FBgSchemeId, FFormula from T_BG_BgData where FID IN (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Object[] params = bgDataIds.toArray();
        int batchCount = (params.length - 1) / 200 + 1;
        conn = this.getConnection(ctx);
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < batchCount; ++i) {
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)i, (int)200, (Object[])params);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgFormula = new String[]{rst.getString("FID"), rst.getString("FOrgUnitId"), rst.getString("FBgSchemeId"), rst.getString("FFormula")};
                    bgDataIdMap.put(bgFormula[0], bgFormula);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
            bgDataIds.clear();
        }
        BgCtrlResultInfo ctrlResultInfo = null;
        int in = col.size();
        for (int i = 0; i < in; ++i) {
            ctrlResultInfo = col.get(i);
            if (!bgDataIdMap.containsKey(col.get(i).getBgDataId())) continue;
            bgFormula = (String[])bgDataIdMap.get(ctrlResultInfo.getBgDataId());
            ctrlResultInfo.setOrgUnitId(bgFormula[1]);
            ctrlResultInfo.setBgSchemeId(bgFormula[2]);
            ctrlResultInfo.setBgItemFormula(bgFormula[3]);
        }
        bgDataIdMap.clear();
    }

    private BgCtrlResultCollection getCtrlResultCol(Context ctx, List param, String fieldName, boolean isOnlyId) throws BOSException, EASBizException {
        if (param == null || param.isEmpty()) {
            return null;
        }
        BgCtrlResultCollection col = new BgCtrlResultCollection();
        BgCtrlResultInfo ctrlResultInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select cr.FId           AS bgCtrlRecordId");
        if (!isOnlyId) {
            sql.append(",        cr.FBgDataId     AS bgDataId");
            sql.append(",        cr.FBillId       AS billId");
            sql.append(",        cr.FBillNumber   AS billNumber");
            sql.append(",        cr.FActualAmount AS requestAmt");
            sql.append(",        cr.FBillType     AS billType");
            sql.append(",        cr.FBizDate      AS bizDate");
            sql.append(",        cr.FItemName     AS itemName");
            sql.append(",        cr.FActualType   AS actualType");
            sql.append(",        cr.FBillSourceOrgunitID   AS billSourceOrgunitID,");
            sql.append(" cr.FBgPeriodId AS bgPeriodId");
        }
        sql.append(" from T_BG_BgCtrlRecord cr ");
        sql.append(" where cr.FIsCollected = 0 and cr.FBgTraceType = ").append(3);
        sql.append(" and cr." + fieldName + " IN (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            Object[] params = param.toArray();
            int batchCount = (params.length - 1) / 200 + 1;
            for (int i = 0; i < batchCount; ++i) {
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)i, (int)200, (Object[])params);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    ctrlResultInfo = new BgCtrlResultInfo();
                    ctrlResultInfo.setId(BOSUuid.read((String)rst.getString("bgCtrlRecordId")));
                    if (!isOnlyId) {
                        ctrlResultInfo.setBgDataId(rst.getString("bgDataId"));
                        ctrlResultInfo.setBillId(rst.getString("billId"));
                        ctrlResultInfo.setBillNumber(rst.getString("billNumber"));
                        ctrlResultInfo.setReqAmount(rst.getBigDecimal("requestAmt"));
                        ctrlResultInfo.setBillType(rst.getString("billType"));
                        ctrlResultInfo.setBizDate(rst.getTimestamp("bizDate"));
                        ctrlResultInfo.setItemName(rst.getString("itemName"));
                        ctrlResultInfo.setActualType(ActualTypeEnum.getEnum(rst.getInt("actualType")));
                        ctrlResultInfo.setBillSourceOrgunitID(rst.getString("billSourceOrgunitID"));
                        ctrlResultInfo.setBgPeriodNumber(rst.getString("bgPeriodId"));
                    }
                    col.add(ctrlResultInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return col;
    }

    @Override
    protected void _moveBgData(Context ctx, Map params) throws BOSException, EASBizException {
        String moveOrgID = (String)params.get("MOVE_ORG_ID");
        String newParentID = (String)params.get("NEW_PARENT_ID");
        String oldParentID = (String)params.get("OLD_PARENT_ID");
        BgTemplateCollection bgTemplateCollection = this.getBgTemplateCollection(ctx, moveOrgID);
        BgSchemeCollection bgSchemeCollection = this.getBgSchemeCollection(ctx, moveOrgID);
        logger.info((Object)"kingdee budget logger : begin update parent template.....");
        this.updateBgTemplateCollection(ctx, bgTemplateCollection, moveOrgID);
        logger.info((Object)"update parent template finish");
        logger.info((Object)"kingdee budget logger : begin update parent scheme.....");
        this.updateBgSchemeCollection(ctx, bgSchemeCollection, moveOrgID);
        logger.info((Object)"update parent scheme finish");
        logger.info((Object)"kingdee budget logger : begin update collected record.....");
        this.updateCurrentLevelCtrlRecord(ctx, moveOrgID, newParentID);
        logger.info((Object)"update update collected record finish");
        Map orgMap = this.getNotCommonOrgUnit(ctx, moveOrgID, oldParentID);
        logger.info((Object)"kingdee budget logger : \u4ea4\u53c9\u70b9\u4ee5\u4e0b\u7684\u7ec4\u7ec7");
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : orgMap.entrySet()) {
            logger.info(entry2.getValue());
        }
        logger.info((Object)"kingdee budget logger : begin collected ctrlrecord.....");
        List ctrlRecordIds = BudgetCtrlFacadeFactory.getLocalInstance(ctx).getNeedCollectCtrlRecords();
        BgDataMoveAfterOrgMoveFacadeFactory.getLocalInstance(ctx).collectCtrlResult(ctrlRecordIds, orgMap);
        logger.info((Object)"update collected record finish");
    }

    private Map getNotCommonOrgUnit(Context ctx, String newParentID, String oldParentID) throws BOSException {
        HashMap orgMap = new HashMap();
        Map<String, String> newOrgMap = new HashMap();
        Map<String, String> oldOrgMap = new HashMap();
        newOrgMap = this.getParentOrgUnit(ctx, newParentID);
        oldOrgMap = this.getParentOrgUnit(ctx, oldParentID);
        newOrgMap.put(newParentID, newParentID);
        oldOrgMap.put(oldParentID, oldParentID);
        if (newOrgMap != null && oldOrgMap != null) {
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : newOrgMap.entrySet()) {
                if (oldOrgMap.containsKey(entry2.getKey())) continue;
                orgMap.put(entry2.getKey(), entry2.getValue());
            }
        }
        return orgMap;
    }

    private Map getParentOrgUnit(Context ctx, String orgUnitID) throws BOSException {
        HashMap<String, String> orgUnitMap = new HashMap<String, String>();
        String sql = "select fid,fparentid from T_ORG_CostCenter where fid = ?";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitID});
            if (rs.next()) {
                String id = rs.getString("fid");
                String parentID = rs.getString("fparentid");
                if (parentID != null) {
                    Map parentOrgUnitMap;
                    orgUnitMap.put(parentID, parentID);
                    if (!id.equals(parentID) && !(parentOrgUnitMap = this.getParentOrgUnit(ctx, parentID)).isEmpty()) {
                        orgUnitMap.putAll(parentOrgUnitMap);
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return orgUnitMap;
    }

    private void deleteParentCollectCtrlRecord(Context ctx, String newParentID) throws BOSException {
        String deleteSQL = "delete t_bg_bgctrlrecord where forgUnitid = '" + newParentID + "'";
        DbUtil.execute((Context)ctx, (String)deleteSQL);
    }

    private void updateCurrentLevelCtrlRecord(Context ctx, String moveOrgUnit, String newParentID) throws BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        String selectSql = "select t1.fid from t_bg_bgctrlrecord t1 inner join t_bg_bgdata t2 on t1.fbgdataid = t2.fid where t1.FBgTraceType = 3 and t1.FIsCollected = 1 and t2.forgunitid = ?";
        StringBuffer updateSQL = new StringBuffer("update t_bg_bgctrlrecord set FIsCollected = 0 where fid in (");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{moveOrgUnit});
            while (rs.next()) {
                ids.add(rs.getString("fid"));
            }
            if (ids.isEmpty()) {
                return;
            }
            for (int i = 0; i < ids.size(); ++i) {
                if (i + 1 == ids.size()) {
                    updateSQL.append("?");
                    continue;
                }
                updateSQL.append("?,");
            }
            updateSQL.append(")");
            DbUtil.execute((Context)ctx, (String)updateSQL.toString(), (Object[])ids.toArray());
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void updateBgSchemeCollection(Context ctx, BgSchemeCollection coll, String moveOrgID) throws BOSException, EASBizException {
        if (coll != null && !coll.isEmpty()) {
            FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo(ctx, moveOrgID);
            for (int i = 0; i < coll.size(); ++i) {
                if (this.checkIsExistByOrgStructs(ctx, moveOrgID, coll.get(i).getParentScheme().getOrgUnit().getId().toString())) continue;
                this.updateBgSchemeData(ctx, coll.get(i), orgUnitInfo);
            }
        }
    }

    private void updateBgTemplateCollection(Context ctx, BgTemplateCollection coll, String moveOrgID) throws BOSException, EASBizException {
        if (coll != null && !coll.isEmpty()) {
            FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo(ctx, moveOrgID);
            for (int i = 0; i < coll.size(); ++i) {
                if (this.checkIsExistByOrgStructs(ctx, moveOrgID, coll.get(i).getParent().getOrgUnit().getId().toString())) continue;
                this.updateBgTemplateData(ctx, coll.get(i), orgUnitInfo);
            }
        }
    }

    private void updateBgTemplateData(Context ctx, BgTemplateInfo info, FullOrgUnitInfo orgUnitID) throws EASBizException, BOSException {
        BgTemplateInfo parentBgTemplateInfo;
        if (info == null || orgUnitID == null) {
            return;
        }
        if (info.getRootId().toString().equals(info.getId().toString())) {
            return;
        }
        FullOrgUnitInfo parentOrgUnitInfo = this.getParentOrgUnitInfo(ctx, orgUnitID.getId().toString());
        if (parentOrgUnitInfo != null && (parentBgTemplateInfo = this.getParentBgTemplate(ctx, orgUnitID.getId().toString(), info.getNumber())) != null) {
            this.updateBgTempalteBySQL(ctx, info, parentBgTemplateInfo);
            this.updateBgTemplateData(ctx, parentBgTemplateInfo, parentOrgUnitInfo);
        }
    }

    private void updateBgSchemeData(Context ctx, BgSchemeInfo info, FullOrgUnitInfo orgUnitID) throws EASBizException, BOSException {
        BgSchemeInfo parentBgSchemeInfo;
        if (info == null || orgUnitID == null) {
            return;
        }
        if (info.getRootId().toString().equals(info.getId().toString())) {
            return;
        }
        FullOrgUnitInfo parentOrgUnitInfo = this.getParentOrgUnitInfo(ctx, orgUnitID.getId().toString());
        if (parentOrgUnitInfo != null && (parentBgSchemeInfo = this.getParentBgScheme(ctx, orgUnitID.getId().toString(), info.getNumber())) != null) {
            this.updateBgSchemeBySQL(ctx, info, parentBgSchemeInfo);
            this.updateBgSchemeData(ctx, parentBgSchemeInfo, parentOrgUnitInfo);
        }
    }

    private void updateBgTempalteBySQL(Context ctx, BgTemplateInfo currentBgTemplate, BgTemplateInfo parentBgTemplate) throws BOSException {
        String updateSQL = "update t_bg_bgTemplate set FParentID = ? where FID = ?";
        DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])new Object[]{parentBgTemplate.getId().toString(), currentBgTemplate.getId().toString()});
    }

    private void updateBgSchemeBySQL(Context ctx, BgSchemeInfo currentBgScheme, BgSchemeInfo parentBgScheme) throws BOSException {
        String updateSQL = "update t_bg_BgScheme set FParentSchemeID = ? where FID = ?";
        DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])new Object[]{parentBgScheme.getId().toString(), currentBgScheme.getId().toString()});
    }

    private BgTemplateInfo getParentBgTemplate(Context ctx, String orgUnitID, String number) throws BOSException {
        BgTemplateInfo bgTemplateInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = this.getBgTemplateSelector();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID, CompareType.EQUALS));
        view.setSelector(selector);
        view.setFilter(filter);
        BgTemplateCollection coll = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateCollection(view);
        if (coll != null && !coll.isEmpty()) {
            bgTemplateInfo = coll.get(0);
        }
        return bgTemplateInfo;
    }

    private BgSchemeInfo getParentBgScheme(Context ctx, String orgUnitID, String number) throws BOSException {
        BgSchemeInfo bgSchemeInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = this.getBgScehmeSelector();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID, CompareType.EQUALS));
        view.setSelector(selector);
        view.setFilter(filter);
        BgSchemeCollection coll = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(view);
        if (coll != null && !coll.isEmpty()) {
            bgSchemeInfo = coll.get(0);
        }
        return bgSchemeInfo;
    }

    private BgTemplateCollection getBgTemplateCollection(Context ctx, String orgUnitID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = this.getBgTemplateSelector();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID, CompareType.EQUALS));
        view.setSelector(selector);
        view.setFilter(filter);
        return BgTemplateFactory.getLocalInstance(ctx).getBgTemplateCollection(view);
    }

    private SelectorItemCollection getBgTemplateSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("rootId"));
        selector.add(new SelectorItemInfo("parent.*"));
        selector.add(new SelectorItemInfo("orgUnit.*"));
        return selector;
    }

    private SelectorItemCollection getBgScehmeSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("rootId"));
        selector.add(new SelectorItemInfo("parentScheme.*"));
        selector.add(new SelectorItemInfo("orgUnit.*"));
        return selector;
    }

    private BgSchemeCollection getBgSchemeCollection(Context ctx, String orgUnitID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("parentScheme.id"));
        selector.add(new SelectorItemInfo("parentScheme.orgUnit.id"));
        selector.add(new SelectorItemInfo("rootId"));
        selector.add(new SelectorItemInfo("orgUnit.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID, CompareType.EQUALS));
        view.setSelector(selector);
        view.setFilter(filter);
        return BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(view);
    }

    public boolean checkIsExistByOrgStructs(Context ctx, String currentOrgUnitNode, String orgUnitID) throws EASBizException, BOSException {
        boolean isExist = false;
        FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo(ctx, currentOrgUnitNode);
        if (orgUnitInfo.getId().toString().equals(orgUnitID)) {
            isExist = true;
        } else if (orgUnitInfo.getParent() != null && !orgUnitInfo.getParent().getId().toString().equals(orgUnitInfo.getId().toString())) {
            isExist = this.checkIsExistByOrgStructs(ctx, orgUnitInfo.getParent().getId().toString(), orgUnitID);
        }
        return isExist;
    }

    public FullOrgUnitInfo getParentOrgUnitInfo(Context ctx, String orgUnitID) throws EASBizException, BOSException {
        FullOrgUnitInfo orgUnit = this.getOrgUnitInfo(ctx, orgUnitID);
        if (orgUnit != null) {
            return orgUnit.getParent();
        }
        return null;
    }

    public FullOrgUnitInfo getOrgUnitInfo(Context ctx, String orgUnitID) throws EASBizException, BOSException {
        return FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitID));
    }

    @Override
    protected IRowSet _getGatherFormAfterOrgMove(Context ctx, String moveOrgId, String newParentId) throws BOSException, EASBizException {
        IRowSet rs = null;
        ArrayList<String> sameTmpList = new ArrayList<String>();
        StringBuffer sameTmpSb = new StringBuffer();
        sameTmpSb.append("select FID \n");
        sameTmpSb.append("from t_bg_bgTemplate \n");
        sameTmpSb.append("where FOrgUnitId = '" + moveOrgId + "' \n");
        sameTmpSb.append("\t\tand FNumber in ( \n");
        sameTmpSb.append("\t\t\tselect FNumber \n");
        sameTmpSb.append("\t\t\tfrom t_bg_bgTemplate \n");
        sameTmpSb.append("\t\t\twhere FOrgUnitID = '" + newParentId + "' \n");
        sameTmpSb.append("\t\t\t) \n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sameTmpSb.toString());
        try {
            while (rs.next()) {
                sameTmpList.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        StringBuffer gatherFormSb = new StringBuffer();
        gatherFormSb.append("select bu.FName_" + ctx.getLocale() + " orgUnitName, \n");
        gatherFormSb.append("\t\tbs.FName_" + ctx.getLocale() + " bgSchemeName, \n");
        gatherFormSb.append("\t\tbf.FName bgFormName \n");
        gatherFormSb.append("from t_bg_bgForm bf \n");
        gatherFormSb.append("inner join t_bg_bgScheme bs on bf.FBgSchemeID = bs.FID \n");
        gatherFormSb.append("inner join t_org_baseUnit bu on bf.FOrgUnitID = bu.FID \n");
        gatherFormSb.append("where bf.FBgTemplateID in ( \n");
        if (sameTmpList.size() > 0) {
            for (int i = 0; i < sameTmpList.size(); ++i) {
                gatherFormSb.append("'" + sameTmpList.get(i) + "'");
                if (i == sameTmpList.size() - 1) continue;
                gatherFormSb.append(",");
            }
        } else {
            gatherFormSb.append("null");
        }
        gatherFormSb.append(") \n");
        gatherFormSb.append("\t\tand bf.FOrgUnitID = '" + moveOrgId + "' \n");
        gatherFormSb.append("order by orgUnitName, bgSchemeName, bgFormName \n");
        rs = DbUtil.executeQuery((Context)ctx, (String)gatherFormSb.toString());
        return rs;
    }
}

