/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgDecForPeriodFormFactory;
import com.kingdee.eas.ma.budget.BgDecForPeriodFormInfo;
import com.kingdee.eas.ma.budget.BgDecomposerStateEnum;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgDecForPeriodForm;
import com.kingdee.eas.ma.budget.RefBgDecPeriodsCollection;
import com.kingdee.eas.ma.budget.app.AbstractBgDecForPeriodFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgDecForPeriodFacadeControllerBean
extends AbstractBgDecForPeriodFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgDecForPeriodFacadeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _getSourcePeriod(Context ctx, String bgFormId, int periodType) throws BOSException, EASBizException {
        BgPeriodCollection periodCol = new BgPeriodCollection();
        if (bgFormId == null) return periodCol;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgPeriodInfo perInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select fid, fnumber, fname_" + ctx.getLocale() + " fname from t_bg_bgPeriod where FPeriodType = ? and fid in (select fbgperiodid from t_bg_bgdata where fbgformid = ?) order by fnumber");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setInt(1, periodType);
            pstmt.setString(2, bgFormId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                perInfo = new BgPeriodInfo();
                perInfo.setId(BOSUuid.read((String)rst.getString("fid")));
                perInfo.setNumber(rst.getString("fnumber"));
                perInfo.setName(rst.getString("fname"));
                periodCol.add(perInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((ResultSet)rst);
        return periodCol;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getFormOldData(Context ctx, Map formIds, Map bgPeriods) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer formid = new StringBuffer();
        Iterator ite = formIds.keySet().iterator();
        while (ite.hasNext()) {
            formid.append("'" + ite.next() + "' , ");
        }
        StringBuffer periods = new StringBuffer();
        Iterator ite2 = bgPeriods.keySet().iterator();
        while (ite2.hasNext()) {
            periods.append("'" + ite2.next() + "' , ");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fbgformid, fformula , fbgvalue from t_bg_bgdata where fbgformid in (" + formid.substring(0, formid.length() - 3) + ") and  fbgperiodid in (select fid from t_bg_bgperiod where fnumber in (" + periods.substring(0, periods.length() - 3) + "))");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                dataMap.put(rst.getString("fformula") + "@" + rst.getString("fbgformid"), rst.getBigDecimal("fbgvalue"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((ResultSet)rst);
        return dataMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getFormId(Context ctx, String bgSchemeId, String bgFormId, Map endPeriods) throws BOSException, EASBizException {
        HashMap formIdMap = new HashMap();
        if (bgSchemeId == null) return formIdMap;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        _tmpList.add(bgSchemeId);
        Iterator ite = endPeriods.keySet().iterator();
        while (ite.hasNext()) {
            _tmpList.add(ite.next().toString());
        }
        _tmpList.add(new Integer(1));
        Map conditionMap = this.getQueryCondition(ctx, bgFormId, bgSchemeId);
        String _tmp = (String)conditionMap.get("FBgitemCombinIDs");
        String[] _tmps = _tmp.split(",");
        int bgItemSize = 0;
        if (_tmps != null) {
            bgItemSize = _tmps.length;
            int in = _tmps.length;
            for (int i = 0; i < in; ++i) {
                _tmpList.add(_tmps[i]);
            }
        }
        _tmp = (String)conditionMap.get("FBgElementIDs");
        _tmps = _tmp.split(",");
        int bgElementSize = 0;
        if (_tmps != null) {
            bgElementSize = _tmps.length;
            int in = _tmps.length;
            for (int i = 0; i < in; ++i) {
                _tmpList.add(_tmps[i]);
            }
        }
        _tmp = (String)conditionMap.get("FCurrencyIDs");
        _tmps = _tmp.split(",");
        int currencySize = 0;
        if (_tmps != null) {
            currencySize = _tmps.length;
            int in = _tmps.length;
            for (int i = 0; i < in; ++i) {
                _tmpList.add(_tmps[i]);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct fbgformid from t_bg_bgdata where Fbgschemeid = ? and  fbgperiodid in ( select fid from t_bg_bgperiod where fnumber in (" + BgNSQLHelper.getParamSizeString(endPeriods.keySet()) + ")) and fbgformid in (select fid from t_bg_bgform where fState = ? ) and fbgitemcombinid in (" + BgNSQLHelper.getParamSizeString((int)bgItemSize) + ")  and FBgElementId in (" + BgNSQLHelper.getParamSizeString((int)bgElementSize) + ") and FCurrencyId in (" + BgNSQLHelper.getParamSizeString((int)currencySize) + ")");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                formIdMap.put(rst.getString("fbgformid"), null);
            }
            ArrayList formIdsList = new ArrayList();
            Iterator it = formIdMap.keySet().iterator();
            while (it.hasNext()) {
                formIdsList.add(it.next());
            }
            formIdMap.put("formIdsList", formIdsList);
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((ResultSet)rst);
        return formIdMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getQueryCondition(Context ctx, String bgFormId, String bgSchemeId) throws BOSException, EASBizException {
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FBgItemCombinId,FBgElementId,FCurrencyId from t_bg_bgdata where fbgformid = ? and  Fbgschemeid = ?  ");
        StringBuffer FBgitemCombinIDs = new StringBuffer("");
        StringBuffer FBgElementIDs = new StringBuffer("");
        StringBuffer FCurrencyIDs = new StringBuffer("");
        HashMap FBgitemCombinIDsMap = new HashMap();
        HashMap FBgElementIDsMap = new HashMap();
        HashMap FCurrencyIDsMap = new HashMap();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormId);
            pstmt.setString(2, bgSchemeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String FBgitemCombinId = rst.getString("FBgItemCombinId");
                String FBgElementId = rst.getString("FBgElementId");
                String FCurrencyId = rst.getString("FCurrencyId");
                if (!FBgitemCombinIDsMap.containsKey(FBgitemCombinId)) {
                    FBgitemCombinIDs.append(FBgitemCombinId + ",");
                    FBgitemCombinIDsMap.put(FBgitemCombinId, null);
                }
                if (!FBgElementIDsMap.containsKey(FBgElementId)) {
                    FBgElementIDs.append(FBgElementId + ",");
                    FBgElementIDsMap.put(FBgElementId, null);
                }
                if (FCurrencyIDsMap.containsKey(FCurrencyId)) continue;
                FCurrencyIDs.append(FCurrencyId + ",");
                FCurrencyIDsMap.put(FCurrencyId, null);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((ResultSet)rst);
        FBgitemCombinIDs.delete(FBgitemCombinIDs.length() - 1, FBgitemCombinIDs.length());
        FBgElementIDs.delete(FBgElementIDs.length() - 1, FBgElementIDs.length());
        FCurrencyIDs.delete(FCurrencyIDs.length() - 1, FCurrencyIDs.length());
        conditionMap.put("FBgitemCombinIDs", FBgitemCombinIDs.toString());
        conditionMap.put("FBgElementIDs", FBgElementIDs.toString());
        conditionMap.put("FCurrencyIDs", FCurrencyIDs.toString());
        FBgitemCombinIDsMap.clear();
        FBgElementIDsMap.clear();
        FCurrencyIDsMap.clear();
        return conditionMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _addNewData(Context ctx, Map formIds) throws BOSException, EASBizException {
        if (formIds == null) {
            return;
        }
        String decId = (String)formIds.get("decId");
        String mainFormID = (String)formIds.get("mainFormId");
        Map refIds = (Map)formIds.get("refIds");
        byte[] data = null;
        String mainSql = "update T_BG_BgDecForPeriodForm set fkdtdata = ? where fid = ?";
        String valueSql = "select fdata from t_bg_bgform where fid = ?";
        Connection conn = null;
        PreparedStatement pstmtM = null;
        PreparedStatement pstmtV = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_RefBgDecPeriods set fkdtdata = ? where fbgformid = ? and FBgDecForPeriodFormID = ?");
        try {
            conn = this.getConnection(ctx);
            pstmtV = conn.prepareStatement(valueSql);
            pstmtV.setString(1, mainFormID);
            rst = pstmtV.executeQuery();
            if (rst.next()) {
                data = BgInfoHelper.getBytes((ResultSet)rst, (int)1);
            }
            pstmtM = conn.prepareStatement(mainSql);
            pstmtM.setBytes(1, data);
            pstmtM.setString(2, decId);
            pstmtM.executeUpdate();
            pstmt = conn.prepareStatement(sql.toString());
            for (String id : refIds.keySet()) {
                data = null;
                pstmtV = null;
                pstmtV = conn.prepareStatement(valueSql);
                pstmtV.setString(1, id);
                rst = pstmtV.executeQuery();
                if (rst.next()) {
                    data = BgInfoHelper.getBytes((ResultSet)rst, (int)1);
                }
                pstmt.setBytes(1, data);
                pstmt.setString(2, id);
                pstmt.setString(3, decId);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (IOException ex3) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                SQLUtils.cleanup(pstmtM);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((Statement)pstmtM);
    }

    @Override
    protected void _setState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgForm");
        sic.add("refBgDecPeriods");
        sic.add("refBgDecPeriods.bgForm.id");
        sic.add("state");
        IBgDecForPeriodForm ibgDec = BgDecForPeriodFormFactory.getLocalInstance(ctx);
        BgDecForPeriodFormInfo bgDecFormInfo = (BgDecForPeriodFormInfo)ibgDec.getValue((IObjectPK)new ObjectUuidPK(id), sic);
        this.setBgFormStatus(ctx, bgDecFormInfo, BgFormStateEnum.Edited, true);
        this.setBgDecFormState(ctx, bgDecFormInfo, BgDecomposerStateEnum.SIGNED);
    }

    private void setBgDecFormState(Context ctx, BgDecForPeriodFormInfo bgDecFormInfo, BgDecomposerStateEnum state) throws BOSException {
        StringBuffer sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgDecForPeriodForm SET FState = ? WHERE");
        sqlToUpdateBgFormStatus.append(" FID = ");
        sqlToUpdateBgFormStatus.append("'");
        sqlToUpdateBgFormStatus.append(bgDecFormInfo.getId().toString());
        sqlToUpdateBgFormStatus.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue())});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setBgFormStatus(Context ctx, BgDecForPeriodFormInfo bgDecFormInfo, BgFormStateEnum state, boolean end) throws BOSException {
        StringBuffer sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgForm SET FState = ?  WHERE");
        RefBgDecPeriodsCollection refBgFormCols = bgDecFormInfo.getRefBgDecPeriods();
        if (refBgFormCols != null && !refBgFormCols.isEmpty()) {
            sqlToUpdateBgFormStatus.append("(");
            int count = refBgFormCols.size();
            for (int i = 0; i < count; ++i) {
                if (i != 0) {
                    sqlToUpdateBgFormStatus.append(" OR ");
                }
                sqlToUpdateBgFormStatus.append(" FID = ");
                sqlToUpdateBgFormStatus.append("'");
                sqlToUpdateBgFormStatus.append(refBgFormCols.get(i).getBgForm().getId().toString());
                sqlToUpdateBgFormStatus.append("'");
            }
            sqlToUpdateBgFormStatus.append(") and fid <> '" + bgDecFormInfo.getId().toString() + "' ");
            try {
                DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue())});
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgForm SET FState = ?  WHERE");
        sqlToUpdateBgFormStatus.append(" FID = ");
        sqlToUpdateBgFormStatus.append("'");
        sqlToUpdateBgFormStatus.append(bgDecFormInfo.getBgForm().getId().toString());
        sqlToUpdateBgFormStatus.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(1)});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

