/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCollectException;
import com.kingdee.eas.ma.budget.BgDecForPeriodFacadeFactory;
import com.kingdee.eas.ma.budget.BgDecForPeriodFormInfo;
import com.kingdee.eas.ma.budget.BgDecomposerStateEnum;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.RefBgDecPeriodsCollection;
import com.kingdee.eas.ma.budget.RefBgDecPeriodsInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgDecForPeriodFormControllerBean;
import com.kingdee.eas.ma.nbudget.BgNAdjHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgDecForPeriodFormControllerBean
extends AbstractBgDecForPeriodFormControllerBean {
    private static final long serialVersionUID = 5979270828736502753L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgDecForPeriodFormControllerBean");

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.setBgFormStatus(ctx, (BgDecForPeriodFormInfo)model, BgFormStateEnum.Decomposer);
        super._addnew(ctx, pk, model);
        BgDecForPeriodFacadeFactory.getLocalInstance(ctx).addNewData(this.getDecIdsMap((BgDecForPeriodFormInfo)model));
    }

    private Map getDecIdsMap(BgDecForPeriodFormInfo editData) {
        HashMap<String, Object> decIds = new HashMap<String, Object>();
        HashMap<String, Object> refIds = new HashMap<String, Object>();
        decIds.put("decId", editData.getId().toString());
        decIds.put("mainFormId", editData.getBgForm().getId().toString());
        RefBgDecPeriodsCollection coll = editData.getRefBgDecPeriods();
        for (int i = 0; i < coll.size(); ++i) {
            refIds.put(coll.get(i).getBgForm().getId().toString(), null);
        }
        decIds.put("refIds", refIds);
        return decIds;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setBgFormStatus(ctx, (BgDecForPeriodFormInfo)model, BgFormStateEnum.Decomposer);
        IObjectPK pk = super._addnew(ctx, model);
        BgDecForPeriodFacadeFactory.getLocalInstance(ctx).addNewData(this.getDecIdsMap((BgDecForPeriodFormInfo)model));
        return pk;
    }

    private void setBgFormStatus(Context ctx, BgDecForPeriodFormInfo bgDecForPeriodFormInfo, BgFormStateEnum state) throws BOSException {
        StringBuffer sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgForm SET FState = ? WHERE FSTate = ? AND (");
        RefBgDecPeriodsCollection refBgFormCols = bgDecForPeriodFormInfo.getRefBgDecPeriods();
        sqlToUpdateBgFormStatus.append(" FID = ");
        sqlToUpdateBgFormStatus.append("'");
        sqlToUpdateBgFormStatus.append(bgDecForPeriodFormInfo.getBgForm().getId().toString());
        sqlToUpdateBgFormStatus.append("'");
        int count = refBgFormCols.size();
        for (int i = 0; i < count; ++i) {
            sqlToUpdateBgFormStatus.append(" OR ");
            sqlToUpdateBgFormStatus.append(" FID = ");
            sqlToUpdateBgFormStatus.append("'");
            sqlToUpdateBgFormStatus.append(refBgFormCols.get(i).getBgForm().getId().toString());
            sqlToUpdateBgFormStatus.append("'");
        }
        sqlToUpdateBgFormStatus.append(")");
        try {
            if (BgFormStateEnum.Edited.equals((Object)state)) {
                DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue()), new Integer(30)});
            } else if (BgFormStateEnum.Decomposer.equals((Object)state)) {
                DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue()), new Integer(1)});
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgForm");
        sic.add("bgForm.id");
        sic.add("refBgDecPeriods");
        sic.add("refBgDecPeriods.bgForm.id");
        sic.add("state");
        BgDecForPeriodFormInfo bgDecForPeriodFormInfo = (BgDecForPeriodFormInfo)this.getValue(ctx, pk, sic);
        if (BgDecomposerStateEnum.SIGNED.equals((Object)bgDecForPeriodFormInfo.getState())) {
            throw new BgCollectException(BgCollectException.BGCOLLECTFORMNODELETE);
        }
        this.setBgFormStatus(ctx, bgDecForPeriodFormInfo, BgFormStateEnum.Edited);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + bgDecForPeriodFormInfo.getBgForm().getId().toString() + "'"));
            int n = bgDecForPeriodFormInfo.getRefBgDecPeriods().size();
            for (int i = 0; i < n; ++i) {
                SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + bgDecForPeriodFormInfo.getRefBgDecPeriods().get(i).getBgForm().getId().toString() + "'"));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgDecForPeriodFormInfo bgDecFormInfo = (BgDecForPeriodFormInfo)model;
        InputStream is = null;
        ObjectInputStream ois = null;
        HashMap adjustMap = null;
        Map formAdjMap = null;
        Connection conn = null;
        BgFormInfo bgFormInfo = null;
        try {
            conn = this.getConnection(ctx);
            byte[] data = bgDecFormInfo.getMapData();
            if (data != null && data.length > 0) {
                is = ZipUtil.unpack((byte[])data);
                ois = new ObjectInputStream(is);
                adjustMap = BgHelper.buildHashMapByByte((byte[])((HashMap)ois.readObject()).get("adjustMap"));
                formAdjMap = this.getFormAdjustMap(conn, bgDecFormInfo.getBgForm().getId(), adjustMap);
                if (formAdjMap != null && !formAdjMap.isEmpty()) {
                    bgFormInfo = BgFSHelper.getBgFormInfo(conn, bgDecFormInfo.getBgForm().getId(), false);
                    BgNAdjHelper.createTmpDataOfFormula((Context)ctx, (Connection)conn, (BOSUuid)bgFormInfo.getOrgUnit().getId(), (BOSUuid)bgFormInfo.getBgScheme().getId(), (BOSUuid)bgFormInfo.getBgTemplate().getId(), (BOSUuid)bgFormInfo.getId(), (Map)formAdjMap);
                    formAdjMap.clear();
                } else {
                    SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + bgDecFormInfo.getBgForm().getId().toString() + "'"));
                }
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ois.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            RefBgDecPeriodsInfo refBgDecFormInfo = null;
            Iterator iter = bgDecFormInfo.getRefBgDecPeriods().iterator();
            while (iter.hasNext()) {
                refBgDecFormInfo = (RefBgDecPeriodsInfo)iter.next();
                refBgDecFormInfo.remove("kdtData");
                formAdjMap = this.getFormAdjustMap(conn, refBgDecFormInfo.getBgForm().getId(), adjustMap);
                if (formAdjMap != null && !formAdjMap.isEmpty()) {
                    bgFormInfo = BgFSHelper.getBgFormInfo(conn, refBgDecFormInfo.getBgForm().getId(), false);
                    BgFSHelper.createTmpDataOfFormula(ctx, conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getBgTemplate().getId(), bgFormInfo.getId(), formAdjMap);
                    formAdjMap.clear();
                } else {
                    SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + refBgDecFormInfo.getBgForm().getId().toString() + "'"));
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (ois == null) continue;
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        IObjectPK pk = super._submit(ctx, model);
        BgFormInfo bgForm = bgDecFormInfo.getBgForm();
        if (bgForm != null) {
            String sql = "update t_bg_bgform set fstate = ? where fid = ?";
            int bgFormState = bgForm.getState().getValue();
            String bgFormID = bgForm.getId().toString();
            if (bgFormState == 1) {
                bgFormState = 30;
            }
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(bgFormState), bgFormID});
        }
        return pk;
    }

    private Map getFormAdjustMap(Connection conn, BOSUuid id, Map adjustMap) throws BgException {
        HashMap newMap = null;
        if (adjustMap != null && !adjustMap.isEmpty()) {
            newMap = new HashMap();
            String selectSql = "select fformula from t_bg_bgdata where fbgformid = ?";
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            try {
                pstmt = conn.prepareStatement(selectSql);
                pstmt.setString(1, id.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!adjustMap.containsKey(rst.getString("fformula"))) continue;
                    newMap.put(rst.getString("fformula"), adjustMap.get(rst.getString("fformula")));
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        return newMap;
    }

    @Override
    protected void _saveKdt(Context ctx, String id, byte[] data) throws BOSException, EASBizException {
    }
}

