/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgExamineCollection;
import com.kingdee.eas.ma.budget.BgExamineFactory;
import com.kingdee.eas.ma.budget.BgExamineNodeInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgExamine;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.app.AbstractBgExamineNodeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgExamineNodeControllerBean
extends AbstractBgExamineNodeControllerBean {
    private static final long serialVersionUID = -4270897821100508235L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgExamineNodeControllerBean");

    @Override
    protected void _addNodes(Context ctx, IObjectValue model, Vector examineIds, Vector hadExamineIds) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)model;
        if (hadExamineIds == null) {
            hadExamineIds = new Vector();
        }
        if (examineIds == null) {
            examineIds = new Vector();
        }
        this.addExamieNodes(ctx, bgTemplateInfo.getId().toString(), examineIds, hadExamineIds, false);
    }

    @Override
    protected IObjectCollection _getExamine(Context ctx, String templateId) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        ArrayList<String> examineIds;
        IBgExamine iBgEx;
        BgExamineCollection col;
        block9: {
            col = new BgExamineCollection();
            iBgEx = BgExamineFactory.getLocalInstance(ctx);
            examineIds = new ArrayList<String>();
            String sql = "select FBgExamineID from t_bg_bgexaminenode where FBgTemplateID = ?";
            conn = null;
            pstmt = null;
            rs = null;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, templateId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                examineIds.add(rs.getString("FBgExamineID").toString());
            }
            if (examineIds.size() != 0) break block9;
            IObjectCollection iObjectCollection = null;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return iObjectCollection;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (examineIds.size() == 1) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)examineIds.get(0).toString(), CompareType.EQUALS));
            } else if (examineIds.size() > 1) {
                filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(examineIds), CompareType.INCLUDE));
            }
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("name"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("examineGroup.id"));
            view.getSelector().add(new SelectorItemInfo("examineGroup.name"));
            view.getSelector().add(new SelectorItemInfo("examineGroup.number"));
            col = iBgEx.getBgExamineCollection(view);
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return col;
    }

    @Override
    protected boolean _examineUpdate(Context ctx, String bgTemplateId) throws BOSException, EASBizException {
        return this.nexamineUpdate(ctx, bgTemplateId);
    }

    protected boolean nexamineUpdate(Context ctx, String bgTemplateId) throws BOSException, EASBizException {
        Vector<String> parentExamineIds = new Vector<String>();
        Vector<String> templateIds = new Vector<String>();
        IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance(ctx);
        BgTemplateInfo bgTemInfo = iBgTemplate.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgTemplateId), this.getSelectors());
        BOSObjectType type = new BgExamineNodeInfo().getBOSType();
        if (bgTemInfo != null && bgTemInfo.getRootId() != null && bgTemInfo.getOrgUnit().getLongNumber() != null) {
            String getExamineSQL = "select FBgExamineID from t_bg_bgexamineNode where FBgTemplateID = ?";
            String getTemplateIds = "select B.fid from t_bg_bgtemplate B, T_ORG_BaseUnit O where B.FRootId = ? and B.fid <> ? and O.Flongnumber like ? and B.forgunitid = O.fid";
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            String insSql = "insert into t_bg_bgexamineNode (fid,FBgTemplateID,FBgExamineID,FIsParent)  values (?,?,?,1);";
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(getExamineSQL);
                pstmt.setString(1, bgTemplateId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    parentExamineIds.add(rs.getString("FBgExamineID").toString());
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                pstmt = conn.prepareStatement(getTemplateIds);
                pstmt.setString(1, bgTemInfo.getRootId().toString());
                pstmt.setString(2, bgTemplateId);
                pstmt.setString(3, bgTemInfo.getOrgUnit().getLongNumber() + "!%");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    templateIds.add(rs.getString("fid").toString());
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                if (!templateIds.isEmpty()) {
                    int i;
                    int batchNum = 500;
                    int size = templateIds.size();
                    int count = (size - 1) / batchNum + 1;
                    int pos = 0;
                    StringBuffer delSql = new StringBuffer("delete from t_bg_bgexamineNode where fbgtemplateid in (");
                    for (i = 0; i < batchNum; ++i) {
                        if (i != batchNum - 1) {
                            delSql.append("?,");
                            continue;
                        }
                        delSql.append("?)");
                    }
                    if (!parentExamineIds.isEmpty()) {
                        delSql.append(" and (FIsParent = 1 or FBgExamineID in (");
                        for (i = 0; i < parentExamineIds.size(); ++i) {
                            if (i != parentExamineIds.size() - 1) {
                                delSql.append("'").append(parentExamineIds.get(i)).append("',");
                                continue;
                            }
                            delSql.append("'").append(parentExamineIds.get(i)).append("'))");
                        }
                    } else {
                        delSql.append(" and FIsParent = 1");
                    }
                    pstmt = conn.prepareStatement(delSql.toString());
                    for (int index = 0; index < count; ++index) {
                        int k = 1;
                        while (k <= batchNum) {
                            if (pos < size) {
                                pstmt.setString(k, (String)templateIds.get(pos));
                            } else {
                                pstmt.setString(k, "#");
                            }
                            ++k;
                            ++pos;
                        }
                        pstmt.execute();
                    }
                    SQLUtils.cleanup((Statement)pstmt);
                    pstmt = conn.prepareStatement(insSql.toString());
                    int n = 0;
                    for (int i2 = 0; i2 < templateIds.size(); ++i2) {
                        for (int j = 0; j < parentExamineIds.size(); ++j) {
                            pstmt.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                            pstmt.setString(2, (String)templateIds.get(i2));
                            pstmt.setString(3, (String)parentExamineIds.get(j));
                            pstmt.addBatch();
                            if (++n < 100) continue;
                            pstmt.executeBatch();
                            n = 0;
                        }
                    }
                    pstmt.executeBatch();
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return true;
        }
        return false;
    }

    @Override
    protected void _schemeExamineUpdate(Context ctx, String newTemplateId, Vector parentExamineIds) throws BOSException, EASBizException {
        if (parentExamineIds == null) {
            parentExamineIds = new Vector();
        }
        if (newTemplateId != null && parentExamineIds.size() >= 0) {
            this.addExamieNodes(ctx, newTemplateId, parentExamineIds, new Vector(), true);
        }
    }

    private void addExamieNodes(Context ctx, String templateId, Vector examineIds, Vector hadExamineIds, boolean isDispatch) throws BOSException, EASBizException {
        ArrayList _tmpList = new ArrayList();
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from t_bg_bgexamineNode where FBgTemplateID = ? and FBgExamineID = ?");
            for (int i = 0; i < hadExamineIds.size(); ++i) {
                if (examineIds.contains(hadExamineIds.get(i))) continue;
                pstmt.setString(1, templateId);
                pstmt.setString(2, hadExamineIds.get(i).toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        try {
            if (isDispatch) {
                BgNSQLHelper.execute((Context)ctx, (String)"delete from t_bg_bgexamineNode where FIsParent = 1 and FBgTemplateID = ?", (Object[])new Object[]{templateId});
            }
            pstmt = conn.prepareStatement("delete from t_bg_bgexamineNode where FBgTemplateID = ? and  FbgExamineId = ?");
            pstmt1 = conn.prepareStatement("Insert into t_bg_bgexamineNode (fid,FBgTemplateID,FBgExamineID,FIsParent) values (?,?,?,?)");
            for (int n = 0; n < examineIds.size(); ++n) {
                if (hadExamineIds.contains(examineIds.get(n))) continue;
                if (isDispatch) {
                    pstmt.setString(1, templateId);
                    pstmt.setString(2, examineIds.get(n).toString());
                    pstmt.addBatch();
                }
                pstmt1.setString(1, BOSUuid.create((BOSObjectType)new BgExamineNodeInfo().getBOSType()).toString());
                pstmt1.setString(2, templateId);
                pstmt1.setString(3, examineIds.get(n).toString());
                pstmt1.setInt(4, 0);
                pstmt1.addBatch();
            }
            if (isDispatch) {
                pstmt.executeBatch();
            }
            pstmt1.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Statement)pstmt);
                SQLUtils.cleanup(pstmt1, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)pstmt1, (Connection)conn);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("rootId"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        return sic;
    }

    @Override
    protected void _removeexamineontemplate(Context ctx, String templateId) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        Vector<String> examineIds;
        block8: {
            examineIds = new Vector<String>();
            String sql = "select FBgExamineID from t_bg_bgexaminenode where FBgTemplateID = ?";
            conn = null;
            pstmt = null;
            rs = null;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, templateId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                examineIds.add(rs.getString("FBgExamineID").toString());
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            if (examineIds.size() != 0) break block8;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return;
        }
        try {
            if (examineIds.size() > 0) {
                String deleteSQL = "delete from t_bg_bgexamineNode where FBgExamineID = ?";
                pstmt = conn.prepareStatement(deleteSQL);
                for (int i = 0; i < examineIds.size(); ++i) {
                    pstmt.setString(1, examineIds.get(i).toString());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }
}

