/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgExamineFactory;
import com.kingdee.eas.ma.budget.BgExamineInfo;
import com.kingdee.eas.ma.budget.BgExamineNoPassEnum;
import com.kingdee.eas.ma.budget.BgFormExamineResultCollection;
import com.kingdee.eas.ma.budget.BgFormExamineResultInfo;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgFormExamineResultControllerBean;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BgFormExamineResultControllerBean
extends AbstractBgFormExamineResultControllerBean {
    private static final long serialVersionUID = -903538721005301798L;

    @Override
    protected void _saveExamineResult(Context ctx, String bgFormId, Object[] values) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgFormId) || values == null || values.length == 0) {
            return;
        }
        if (values[1] == null || !(values[1] instanceof Map)) {
            return;
        }
        DbUtil.execute((Context)ctx, (String)(" delete from T_BG_BgFormExamineResult  where FBgFormId = '" + bgFormId + "'"));
        BgFormExamineResultCollection col = new BgFormExamineResultCollection();
        Map parameter = (Map)values[1];
        Map passMap = (Map)parameter.get("EXAMINE_PASS");
        Map passSetMap = (Map)parameter.get("EXAMINE_PASS_SET");
        Map nopassMap = (Map)parameter.get("EXAMINE_NOPASS");
        this.buildObject(ctx, bgFormId, passMap, col, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"25_BgFormExamineResultControllerBean", (Locale)ctx.getLocale()));
        this.buildObject(ctx, bgFormId, passSetMap, col, null);
        this.buildObject(ctx, bgFormId, nopassMap, col, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"26_BgFormExamineResultControllerBean", (Locale)ctx.getLocale()));
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                this._addnew(ctx, (IObjectValue)col.get(i));
            }
        }
    }

    private void buildObject(Context ctx, String bgFormId, Map valueMap, BgFormExamineResultCollection col, String eXResult) throws EASBizException, BOSException {
        Map _examineMap = null;
        Map _examineItems = null;
        List _tmpList = null;
        BgFormInfo bgFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId));
        String eXNumber = null;
        String eXName = null;
        String eXExpression = null;
        String eXCondition = null;
        String eXType = null;
        String eXValue = null;
        String note = null;
        for (String eXId : valueMap.keySet()) {
            BgExamineInfo eXInfo = BgExamineFactory.getLocalInstance(ctx).getBgExamineInfo((IObjectPK)new ObjectUuidPK(eXId));
            eXType = eXInfo.getNoPass().getAlias();
            int passType = eXInfo.getNoPass().getValue();
            _examineMap = (Map)valueMap.get(eXId);
            eXNumber = (String)_examineMap.get("EXAMINE_NUMBER");
            eXName = (String)_examineMap.get("EXAMINE_NAME");
            eXExpression = (String)_examineMap.get("EXAMINE_FORMULA_ALIAS");
            _examineItems = (Map)_examineMap.get("EXAMINE_CITATION");
            _tmpList = (List)_examineMap.get("EXAMINE_CIAATION_FORMULA");
            if (_tmpList == null || _tmpList.size() == 0 || _examineItems == null || _examineItems.size() == 0) continue;
            String key = null;
            Map infoMap = null;
            for (int i = 1; i <= _tmpList.size(); ++i) {
                key = (String)_tmpList.get(i - 1);
                if (!_examineItems.containsKey(key) || key != null && !key.startsWith(bgFormInfo.getId().toString())) continue;
                infoMap = (Map)_examineItems.get(key);
                eXCondition = (String)infoMap.get("EXAMINE_FORMULA");
                eXValue = (String)infoMap.get("EXAMINE_FORMULA_VALUE");
                note = infoMap.get("EXAMINE_CITATION_POSTIAL1") != null ? (String)infoMap.get("EXAMINE_CITATION_POSTIAL1") : null;
                BgFormExamineResultInfo info = new BgFormExamineResultInfo();
                info.setBgForm(bgFormInfo);
                info.setExamineId(eXInfo);
                info.setExamineNumber(eXNumber);
                info.setExamineName(eXName);
                info.setExExpression(eXExpression);
                info.setExCondition(eXCondition);
                info.setExamineType(eXType);
                info.setExValue(eXValue);
                if (BgExamineNoPassEnum.noSubmit.getValue() == passType) {
                    info.setExResult(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"26_BgFormExamineResultControllerBean", (Locale)ctx.getLocale()));
                    info.setNote(note);
                } else if (BgExamineNoPassEnum.showErrorMes.getValue() == passType) {
                    info.setExResult(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"25_BgFormExamineResultControllerBean", (Locale)ctx.getLocale()));
                    info.setNote(_examineMap.get("EXAMINE_EXPLAIN") != null ? (String)_examineMap.get("EXAMINE_EXPLAIN") : null);
                } else if (BgExamineNoPassEnum.addPostil.getValue() == passType) {
                    info.setExResult(note == null ? ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"26_BgFormExamineResultControllerBean", (Locale)ctx.getLocale()) : ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"25_BgFormExamineResultControllerBean", (Locale)ctx.getLocale()));
                    info.setNote(note);
                }
                col.add(info);
            }
        }
    }

    @Override
    protected Map _queryExamineResult(Context ctx, List formIds, List examineIds) throws BOSException, EASBizException {
        HashMap<String, Map<String, Map<String, Map<String, String>>>> result = new HashMap<String, Map<String, Map<String, Map<String, String>>>>();
        if (formIds == null || formIds.isEmpty()) {
            return result;
        }
        ArrayList<String> _tmp = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select c.fnumber orgUnitNumber, ");
        sql.append("        c.fname_l2 orgUnitName, ");
        sql.append("        b.fnumber bgFormNumber, ");
        sql.append("        b.fname bgFormName, ");
        sql.append("        a.fexaminenumber eXNumber, ");
        sql.append("        a.fexaminename eXName, ");
        sql.append("        a.fexaminetype eXType, ");
        sql.append("        a.fexexpression eXExpression, ");
        sql.append("        a.fexcondition eXCondition, ");
        sql.append("        a.fexvalue eXValue, ");
        sql.append("        a.fexresult eXResult, ");
        sql.append("        a.fnote eXNote ");
        sql.append("   from T_Bg_BgFormExamineResult a, ");
        sql.append("        T_Bg_BgForm b, ");
        sql.append("        T_ORG_BaseUnit c ");
        sql.append("  where a.FBgFormId=b.FId ");
        sql.append("    and b.FOrgUnitId=c.FId ");
        sql.append("    and b.fid in(");
        for (int i = 0; i < formIds.size(); ++i) {
            String bgFormId = formIds.get(i).toString();
            _tmp.add(bgFormId);
            if (i == formIds.size() - 1) {
                sql.append("?");
                continue;
            }
            sql.append("?,");
        }
        sql.append(") ");
        if (examineIds != null && !examineIds.isEmpty()) {
            sql.append("    and a.fexamineid in(");
            for (int j = 0; j < examineIds.size(); ++j) {
                String exId = examineIds.get(j).toString();
                _tmp.add(exId);
                if (j == examineIds.size() - 1) {
                    sql.append("?");
                    continue;
                }
                sql.append("?,");
            }
            sql.append(") ");
        }
        sql.append("  order by c.fid,b.fid,a.fexamineid ");
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet ret = null;
        try {
            conn = this.getConnection(ctx);
            statement = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)statement, _tmp);
            ret = statement.executeQuery();
            while (ret.next()) {
                String orgUnitNumber = ret.getString("orgUnitNumber");
                String orgUnitName = ret.getString("orgUnitName");
                String bgFormNumber = ret.getString("bgFormNumber");
                String bgFormName = ret.getString("bgFormName");
                String eXNumber = ret.getString("eXNumber");
                String eXName = ret.getString("eXName");
                String eXType = ret.getString("eXType");
                String eXExpression = ret.getString("eXExpression");
                String eXCondition = ret.getString("eXCondition");
                String eXValue = ret.getString("eXValue");
                String eXResult = ret.getString("eXResult");
                String eXNote = ret.getString("eXNote");
                Map<String, Map<String, Map<String, String>>> bgFormMap = null;
                Map<String, Map<String, String>> examineMap = null;
                Map<String, String> valueMap = null;
                String orgKey = orgUnitNumber + "|" + orgUnitName;
                String bgFormKey = bgFormNumber + "|" + bgFormName;
                String examineKey = eXNumber + "|" + eXName;
                String valueKey = orgKey + bgFormKey + examineKey + eXCondition;
                if (result.containsKey(orgKey)) {
                    bgFormMap = (Map)result.get(orgKey);
                } else {
                    bgFormMap = new HashMap();
                    result.put(orgKey, bgFormMap);
                }
                if (bgFormMap.containsKey(examineKey)) {
                    examineMap = (Map)bgFormMap.get(examineKey);
                } else {
                    examineMap = new HashMap();
                    bgFormMap.put(examineKey, examineMap);
                }
                if (examineMap.containsKey(valueKey)) {
                    valueMap = (Map)examineMap.get(valueKey);
                } else {
                    valueMap = new HashMap();
                    examineMap.put(valueKey, valueMap);
                }
                valueMap.put("EXAMINE_CITATION_ORGUNIT", orgUnitNumber);
                valueMap.put("EXAMINE_CITATION_ORGUNIT_NAME", orgUnitName);
                valueMap.put("EXAMINE_CITATION_FORM", bgFormNumber);
                valueMap.put("EXAMINE_CITATION_FORM_NAME", bgFormName);
                valueMap.put("EXAMINE_NUMBER", eXNumber);
                valueMap.put("EXAMINE_NAME", eXName);
                valueMap.put("EXAMINE_TYPE", eXType);
                valueMap.put("EXAMINE_EXPLAIN", eXExpression);
                valueMap.put("EXAMINE_FORMULA_ALIAS", eXCondition);
                valueMap.put("EXAMINE_FORMULA", eXValue);
                valueMap.put("EXAMINE_RESULT", eXResult);
                valueMap.put("EXAMINE_CITATION_POSTIAL", eXNote);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ret, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)ret, (Statement)statement, (Connection)conn);
        return result;
    }

    @Override
    protected List _getBgSchemesByOrgUnits(Context ctx, List orgUnitIds) throws BOSException, EASBizException {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (orgUnitIds == null || orgUnitIds.size() == 0) {
            return ret;
        }
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rSet = null;
        StringBuffer multiQuery = new StringBuffer();
        multiQuery.append("  select t.fid schemeId,t.fnumber orgNumber,q.flevel orgLevel");
        multiQuery.append("    from t_bg_bgscheme t, t_org_baseunit q ");
        multiQuery.append("   where t.forgunitid in ");
        multiQuery.append(this.buildSqlINSection(orgUnitIds));
        multiQuery.append("     and t.forgunitid = q.fid ");
        if (orgUnitIds.size() > 1) {
            multiQuery.append("     and exists (select * ");
            multiQuery.append("            from t_bg_bgscheme tt ");
            multiQuery.append("           where tt.forgunitid in ");
            multiQuery.append(this.buildSqlINSection(orgUnitIds));
            multiQuery.append("             and t.fnumber = tt.fnumber ");
            multiQuery.append("             and t.fid <> tt.fid) ");
            multiQuery.append("     and t.fnumber in (select x.fnumber ");
            multiQuery.append("                         from t_bg_bgscheme x ");
            multiQuery.append("                         where x.forgunitid in ");
            multiQuery.append(this.buildSqlINSection(orgUnitIds));
            multiQuery.append("                        group by x.fnumber ");
            multiQuery.append("                       having count(x.fid) = " + orgUnitIds.size() + ") ");
        }
        multiQuery.append("     order by t.fnumber,q.flevel ");
        HashMap<String, List<Object[]>> checkMap = new HashMap<String, List<Object[]>>();
        try {
            conn = this.getConnection(ctx);
            statement = conn.prepareStatement(multiQuery.toString());
            rSet = statement.executeQuery();
            while (rSet.next()) {
                String bgSchemeId = rSet.getString("schemeId");
                String bgSchemeNumber = rSet.getString("orgNumber");
                int orgLevel = rSet.getInt("orgLevel");
                List<Object[]> schemes = null;
                Object[] orgInfo = null;
                if (checkMap.containsKey(bgSchemeNumber)) {
                    schemes = (List)checkMap.get(bgSchemeNumber);
                } else {
                    schemes = new ArrayList();
                    checkMap.put(bgSchemeNumber, schemes);
                }
                if (schemes.isEmpty()) {
                    orgInfo = new Object[]{bgSchemeId, bgSchemeNumber, new Integer(orgLevel)};
                    schemes.add(orgInfo);
                    continue;
                }
                orgInfo = (Object[])schemes.get(0);
                int maxLevel = (Integer)orgInfo[2];
                if (orgLevel < maxLevel) {
                    schemes.clear();
                    orgInfo = new Object[]{bgSchemeId, bgSchemeNumber, new Integer(orgLevel)};
                    schemes.add(orgInfo);
                    continue;
                }
                if (orgLevel != maxLevel) continue;
                orgInfo = new Object[]{bgSchemeId, bgSchemeNumber, new Integer(orgLevel)};
                schemes.add(orgInfo);
            }
            if (checkMap != null && checkMap.size() > 0) {
                Iterator itr = checkMap.keySet().iterator();
                while (itr.hasNext()) {
                    List lst = (List)checkMap.get(itr.next());
                    for (Object[] values : lst) {
                        ret.add(values[0]);
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rSet, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rSet, (Statement)statement, (Connection)conn);
        return ret;
    }

    private String buildSqlINSection(List ids) {
        StringBuffer _in = new StringBuffer();
        _in.append("(");
        for (int i = 0; i < ids.size(); ++i) {
            if (i == ids.size() - 1) {
                _in.append("'" + (String)ids.get(i) + "'");
                continue;
            }
            _in.append("'" + (String)ids.get(i) + "',");
        }
        _in.append(")");
        return _in.toString();
    }
}

