/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgCommonException;
import com.kingdee.eas.ma.budget.BgCompareAndAnalysisFacadeFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.BgCompareAndAnalysisObjInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgFormulaFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgFormulaFacadeControllerBean
extends AbstractBgFormulaFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgFormulaFacadeControllerBean");

    @Override
    protected BigDecimal _getBgValue(Context ctx, String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber, String field, int state) throws BOSException, EASBizException {
        ResultSet myRst;
        PreparedStatement myStmt;
        Connection myConn;
        BigDecimal result;
        block36: {
            int i;
            if (field.equalsIgnoreCase("fbgbalance")) {
                field = "fbgvalue - fbizactual";
            }
            result = new BigDecimal("0.00");
            if (orgNumber.equals("")) {
                orgNumber = ContextUtil.getCurrentOrgUnit((Context)ctx).getNumber();
            }
            Hashtable<String, String> orgTable = (Hashtable<String, String>)ctx.get((Object)"bgFormula_org");
            String orgUnitId = "";
            if (orgTable != null) {
                if (orgTable.get(orgNumber) != null) {
                    orgUnitId = (String)orgTable.get(orgNumber);
                } else {
                    orgUnitId = this.getObjectValueId(ctx, "t_org_baseunit", orgNumber);
                    orgTable.put(orgNumber, orgUnitId);
                }
            } else {
                orgUnitId = this.getObjectValueId(ctx, "t_org_baseunit", orgNumber);
                orgTable = new Hashtable<String, String>();
                orgTable.put(orgNumber, orgUnitId);
                ctx.put((Object)"bgFormula_org", orgTable);
            }
            Hashtable<String, String> bgSchemeTable = (Hashtable<String, String>)ctx.get((Object)"bgFormula_bgScheme");
            String bgSchemeId = "";
            if (bgSchemeTable != null) {
                if (bgSchemeTable.get(bgSchemeNumber + "_" + orgNumber) != null) {
                    bgSchemeId = (String)bgSchemeTable.get(bgSchemeNumber + "_" + orgNumber);
                } else {
                    bgSchemeId = this.getBgSchemeId(ctx, bgSchemeNumber, orgNumber);
                    bgSchemeTable.put(bgSchemeNumber + "_" + orgNumber, bgSchemeId);
                }
            } else {
                bgSchemeId = this.getBgSchemeId(ctx, bgSchemeNumber, orgNumber);
                bgSchemeTable = new Hashtable<String, String>();
                bgSchemeTable.put(bgSchemeNumber + "_" + orgNumber, bgSchemeId);
                ctx.put((Object)"bgFormula_bgScheme", bgSchemeTable);
            }
            Hashtable<String, String> beginPeriodTable = (Hashtable<String, String>)ctx.get((Object)"bgFormula_beginPeriod");
            String beginPeriodId = "";
            if (beginPeriodTable != null) {
                if (beginPeriodTable.get(beginPeriodNumber) != null) {
                    beginPeriodId = (String)beginPeriodTable.get(beginPeriodNumber);
                } else {
                    beginPeriodId = this.getObjectValueId(ctx, "t_bg_bgperiod", beginPeriodNumber);
                    beginPeriodTable.put(beginPeriodNumber, beginPeriodId);
                }
            } else {
                beginPeriodId = this.getObjectValueId(ctx, "t_bg_bgperiod", beginPeriodNumber);
                beginPeriodTable = new Hashtable<String, String>();
                beginPeriodTable.put(beginPeriodNumber, beginPeriodId);
                ctx.put((Object)"bgFormula_beginPeriod", beginPeriodTable);
            }
            Hashtable<String, String> endPeriodTable = (Hashtable<String, String>)ctx.get((Object)"bgFormula_endPeriod");
            String endPeriodId = "";
            if (endPeriodTable != null) {
                if (endPeriodTable.get(endPeriodNumber) != null) {
                    endPeriodId = (String)endPeriodTable.get(endPeriodNumber);
                } else {
                    endPeriodId = this.getObjectValueId(ctx, "t_bg_bgperiod", endPeriodNumber);
                    endPeriodTable.put(endPeriodNumber, endPeriodId);
                }
            } else {
                endPeriodId = this.getObjectValueId(ctx, "t_bg_bgperiod", endPeriodNumber);
                endPeriodTable = new Hashtable<String, String>();
                endPeriodTable.put(endPeriodNumber, endPeriodId);
                ctx.put((Object)"bgFormula_endPeriod", endPeriodTable);
            }
            if (beginPeriodId == null || beginPeriodId.equals("")) {
                return new BigDecimal("0.00");
            }
            if (endPeriodId == null || endPeriodId.equals("")) {
                return new BigDecimal("0.00");
            }
            IBgPeriod iBgP = BgPeriodFactory.getLocalInstance(ctx);
            BgPeriodCollection bgPC = iBgP.getPeriodCollection(BOSUuid.read((String)beginPeriodId), BOSUuid.read((String)endPeriodId));
            if (bgPC.size() == 0) {
                return new BigDecimal("0.00");
            }
            String[] formula = new String[bgPC.size()];
            for (int i2 = 0; i2 < bgPC.size(); ++i2) {
                String bgPeriodNumber = bgPC.get(i2).getNumber();
                formula[i2] = "=BgItem(\"" + strItemCombinNum + "\",\"" + bgPeriodNumber + "\",\"" + bgElementNumber + "\",\"BgData\",true,\"" + currencyNumber + "\")";
            }
            myConn = this.getConnection(ctx);
            myStmt = null;
            myRst = null;
            StringBuffer mySb = new StringBuffer(1024);
            mySb.append("select sum(" + field + ") bgvalue from t_bg_bgdata where  forgunitid = ? and fbgschemeid = ? and ( ");
            for (int i3 = 0; i3 < bgPC.size(); ++i3) {
                if (i3 == 0) {
                    mySb.append(" fformula = ? ");
                    continue;
                }
                mySb.append(" or fformula = ? ");
            }
            mySb.append(" )");
            StringBuffer mySb1 = new StringBuffer(1024);
            mySb1.append("select sum(fbgbalance) bgvalue from t_bg_bgtmpdata where  forgunitid = ? and fbgschemeid = ? and ( ");
            for (i = 0; i < bgPC.size(); ++i) {
                if (i == 0) {
                    mySb1.append(" fformula = ? ");
                    continue;
                }
                mySb1.append(" or fformula = ? ");
            }
            mySb1.append(" )");
            try {
                myStmt = myConn.prepareStatement(mySb.toString());
                myStmt.setString(1, orgUnitId);
                myStmt.setString(2, bgSchemeId);
                for (i = 0; i < bgPC.size(); ++i) {
                    myStmt.setString(3 + i, formula[i]);
                }
                myRst = myStmt.executeQuery();
                if (myRst.next()) {
                    result = myRst.getBigDecimal("bgvalue");
                }
                if (result == null) {
                    result = new BigDecimal("0.00");
                }
                if (!field.equals("fbgvalue")) break block36;
                myStmt = myConn.prepareStatement(mySb1.toString());
                myStmt.setString(1, orgUnitId);
                myStmt.setString(2, bgSchemeId);
                for (i = 0; i < bgPC.size(); ++i) {
                    myStmt.setString(3 + i, formula[i]);
                }
                myRst = myStmt.executeQuery();
                if (myRst.next()) {
                    result = result.add(myRst.getBigDecimal("bgvalue") == null ? new BigDecimal("0.00") : myRst.getBigDecimal("bgvalue"));
                }
            }
            catch (SQLException e) {
                try {
                    throw new BgException(BgException.DATABASEERROR, e, new Object[]{"T_BG_BgForm"});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(myRst, (Statement)myStmt, (Connection)myConn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)myRst, (Statement)myStmt, (Connection)myConn);
        if (currencyNumber == null || currencyNumber.trim().length() == 0) {
            return result;
        }
        int precision = this.getPrecision(ctx, currencyNumber);
        result = result.divide(new BigDecimal("1"), precision, 6);
        return result;
    }

    private String getBgItemCombinId(Context ctx, String bgItemCombinNumber) throws SQLDataException, EASBizException {
        String key = this.getKey(bgItemCombinNumber);
        String id = "";
        Connection myConn = this.getConnection(ctx);
        PreparedStatement myStmt = null;
        ResultSet myRst = null;
        StringBuffer mySb = new StringBuffer(1024);
        mySb.append("select fid from t_bg_bgitemcombination where fkey = ? ");
        try {
            myStmt = myConn.prepareStatement(mySb.toString());
            myStmt.setString(1, key);
            myRst = myStmt.executeQuery();
            if (myRst.next()) {
                id = myRst.getString("fid");
            }
        }
        catch (SQLException e) {
            try {
                throw new BgException(BgException.DATABASEERROR, e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(myRst, (Statement)myStmt, (Connection)myConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)myRst, (Statement)myStmt, (Connection)myConn);
        return id;
    }

    private String getKey(String bgItemCombinNumber) {
        String result = "";
        result = bgItemCombinNumber.replaceAll(",", "_");
        return result;
    }

    private String getObjectValueId(Context ctx, String tableName, String number) throws SQLDataException, EASBizException {
        String id = "";
        Connection myConn = this.getConnection(ctx);
        PreparedStatement myStmt = null;
        ResultSet myRst = null;
        StringBuffer mySb = new StringBuffer(1024);
        mySb.append("select fid from " + tableName + " where fnumber=?");
        try {
            myStmt = myConn.prepareStatement(mySb.toString());
            myStmt.setString(1, number);
            myRst = myStmt.executeQuery();
            if (myRst.next()) {
                id = myRst.getString("fid");
            }
        }
        catch (SQLException e) {
            try {
                throw new BgException(BgException.DATABASEERROR, e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(myRst, (Statement)myStmt, (Connection)myConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)myRst, (Statement)myStmt, (Connection)myConn);
        return id;
    }

    private String getBgSchemeId(Context ctx, String schemeNumber, String orgNumber) throws SQLDataException, EASBizException {
        String id = "";
        Connection myConn = this.getConnection(ctx);
        PreparedStatement myStmt = null;
        ResultSet myRst = null;
        StringBuffer mySb = new StringBuffer(1024);
        mySb.append("select a.fid from t_bg_bgscheme a ,t_org_baseunit b  where a.forgunitid=b.fid and a.fnumber = ? and b.fnumber = ? ");
        try {
            myStmt = myConn.prepareStatement(mySb.toString());
            myStmt.setString(1, schemeNumber);
            myStmt.setString(2, orgNumber);
            myRst = myStmt.executeQuery();
            if (myRst.next()) {
                id = myRst.getString("fid");
            }
        }
        catch (SQLException e) {
            try {
                throw new BgException(BgException.DATABASEERROR, e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(myRst, (Statement)myStmt, (Connection)myConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)myRst, (Statement)myStmt, (Connection)myConn);
        return id;
    }

    @Override
    protected BigDecimal _getBgValue(Context ctx, String orgNumber, String bgElementNumber, String strBgItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber, String field) throws BOSException, EASBizException {
        return this.getActual(ctx, orgNumber, "", bgElementNumber, strBgItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber, field);
    }

    private BigDecimal getActual(Context ctx, String orgNumber, String schemeNumber, String bgElementNumber, String strBgItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber, String field) throws SQLDataException, EASBizException, BOSException {
        int i;
        BigDecimal result = new BigDecimal("0.00");
        if (orgNumber.equals("")) {
            orgNumber = ContextUtil.getCurrentOrgUnit((Context)ctx).getNumber();
        }
        Hashtable<String, String> orgTable = (Hashtable<String, String>)ctx.get((Object)"bgFormula_org");
        String orgUnitId = "";
        if (orgTable != null) {
            if (orgTable.get(orgNumber) != null) {
                orgUnitId = (String)orgTable.get(orgNumber);
            } else {
                orgUnitId = this.getObjectValueId(ctx, "t_org_baseunit", orgNumber);
                orgTable.put(orgNumber, orgUnitId);
            }
        } else {
            orgUnitId = this.getObjectValueId(ctx, "t_org_baseunit", orgNumber);
            orgTable = new Hashtable<String, String>();
            orgTable.put(orgNumber, orgUnitId);
            ctx.put((Object)"bgFormula_org", orgTable);
        }
        Vector vecScheme = new Vector();
        if (schemeNumber == null || schemeNumber.trim().equals("")) {
            vecScheme = this.getExeBgSchemeIds(ctx, orgUnitId);
            if (vecScheme == null) {
                return result;
            }
            if (vecScheme.size() == 0) {
                return result;
            }
        } else {
            IBgScheme iScheme = BgSchemeFactory.getLocalInstance(ctx);
            BgSchemeInfo scheme = null;
            try {
                scheme = iScheme.getBgSchemeInfo("select id where number ='" + schemeNumber + "' and orgUnit.id='" + orgUnitId + "'");
            }
            catch (ObjectNotFoundException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            if (scheme != null) {
                vecScheme.add(scheme.getId().toString());
            }
        }
        if (vecScheme.size() == 0) {
            vecScheme.add("XXX");
        }
        Hashtable<String, String> bgElementTable = (Hashtable<String, String>)ctx.get((Object)"bgFormula_bgElement");
        String bgElementId = "";
        if (bgElementTable != null) {
            if (bgElementTable.get(bgElementNumber) != null) {
                bgElementId = (String)bgElementTable.get(bgElementNumber);
            } else {
                bgElementId = this.getObjectValueId(ctx, "t_bg_bgelement", bgElementNumber);
                bgElementTable.put(bgElementNumber, bgElementId);
            }
        } else {
            bgElementId = this.getObjectValueId(ctx, "t_bg_bgelement", bgElementNumber);
            bgElementTable = new Hashtable<String, String>();
            bgElementTable.put(bgElementNumber, bgElementId);
            ctx.put((Object)"bgFormula_bgElement", bgElementTable);
        }
        Hashtable<String, String> currencyTable = (Hashtable<String, String>)ctx.get((Object)"bgFormula_currency");
        String currencyId = "";
        if (currencyTable != null) {
            if (currencyTable.get(currencyNumber) != null) {
                currencyId = (String)currencyTable.get(currencyNumber);
            } else {
                currencyId = this.getObjectValueId(ctx, "t_bd_currency", currencyNumber);
                currencyTable.put(currencyNumber, currencyId);
            }
        } else {
            currencyId = this.getObjectValueId(ctx, "t_bd_currency", currencyNumber);
            currencyTable = new Hashtable<String, String>();
            currencyTable.put(currencyNumber, currencyId);
            ctx.put((Object)"bgFormula_currency", currencyTable);
        }
        Hashtable<String, String> beginPeriodTable = (Hashtable<String, String>)ctx.get((Object)"bgFormula_beginPeriod");
        String beginPeriodId = "";
        if (beginPeriodTable != null) {
            if (beginPeriodTable.get(beginPeriodNumber) != null) {
                beginPeriodId = (String)beginPeriodTable.get(beginPeriodNumber);
            } else {
                beginPeriodId = this.getObjectValueId(ctx, "t_bg_bgperiod", beginPeriodNumber);
                beginPeriodTable.put(beginPeriodNumber, beginPeriodId);
            }
        } else {
            beginPeriodId = this.getObjectValueId(ctx, "t_bg_bgperiod", beginPeriodNumber);
            beginPeriodTable = new Hashtable<String, String>();
            beginPeriodTable.put(beginPeriodNumber, beginPeriodId);
            ctx.put((Object)"bgFormula_beginPeriod", beginPeriodTable);
        }
        Hashtable<String, String> endPeriodTable = (Hashtable<String, String>)ctx.get((Object)"bgFormula_endPeriod");
        String endPeriodId = "";
        if (endPeriodTable != null) {
            if (endPeriodTable.get(endPeriodNumber) != null) {
                endPeriodId = (String)endPeriodTable.get(endPeriodNumber);
            } else {
                endPeriodId = this.getObjectValueId(ctx, "t_bg_bgperiod", endPeriodNumber);
                endPeriodTable.put(endPeriodNumber, endPeriodId);
            }
        } else {
            endPeriodId = this.getObjectValueId(ctx, "t_bg_bgperiod", endPeriodNumber);
            endPeriodTable = new Hashtable<String, String>();
            endPeriodTable.put(endPeriodNumber, endPeriodId);
            ctx.put((Object)"bgFormula_endPeriod", endPeriodTable);
        }
        if (beginPeriodId == null || beginPeriodId.equals("")) {
            return new BigDecimal("0.00");
        }
        if (endPeriodId == null || endPeriodId.equals("")) {
            return new BigDecimal("0.00");
        }
        String bgItemCombinId = this.getBgItemCombinId(ctx, strBgItemCombinNum);
        IBgPeriod iBgP = BgPeriodFactory.getLocalInstance(ctx);
        BgPeriodCollection bgPC = iBgP.getPeriodCollection(BOSUuid.read((String)beginPeriodId), BOSUuid.read((String)endPeriodId));
        if (bgPC.size() == 0) {
            return new BigDecimal("0.00");
        }
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer periodIds = new StringBuffer("(");
        for (int i2 = 0; i2 < bgPC.size(); ++i2) {
            periodIds.append("?,");
            _tmpList.add(bgPC.get(i2).getId().toString());
        }
        periodIds.delete(periodIds.length() - 1, periodIds.length());
        periodIds.append(")");
        Connection myConn = this.getConnection(ctx);
        PreparedStatement myStmt = null;
        ResultSet myRst = null;
        StringBuffer mySb = new StringBuffer(1024);
        StringBuffer schemeSql = new StringBuffer("(");
        for (i = 0; i < vecScheme.size(); ++i) {
            if (i == 0) {
                schemeSql.append(" fbgschemeid = ? ");
                continue;
            }
            schemeSql.append(" or fbgschemeid = ? ");
        }
        schemeSql.append(" ) ");
        mySb.append("select sum(" + field + ") bgvalue from t_bg_bgdata where  fbgperiodid in " + periodIds + " and fbgelementid = ? and  fcurrencyId = ? and forgunitid = ? and  fbgitemcombinid = ? and " + schemeSql);
        try {
            myStmt = myConn.prepareStatement(mySb.toString());
            BgNSQLHelper.setParams((PreparedStatement)myStmt, _tmpList);
            myStmt.setString(_tmpList.size() + 1, bgElementId);
            myStmt.setString(_tmpList.size() + 2, currencyId);
            myStmt.setString(_tmpList.size() + 3, orgUnitId);
            myStmt.setString(_tmpList.size() + 4, bgItemCombinId);
            for (i = 0; i < vecScheme.size(); ++i) {
                String schemeId = (String)vecScheme.get(i);
                myStmt.setString(_tmpList.size() + 5 + i, schemeId);
            }
            myRst = myStmt.executeQuery();
            if (myRst.next()) {
                result = myRst.getBigDecimal("bgvalue");
            }
        }
        catch (SQLException e) {
            try {
                throw new BgException(BgException.DATABASEERROR, e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(myRst, (Statement)myStmt, (Connection)myConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)myRst, (Statement)myStmt, (Connection)myConn);
        if (result == null) {
            result = new BigDecimal("0.00");
        }
        if (currencyNumber == null || currencyNumber.trim().length() == 0) {
            return result;
        }
        int precision = this.getPrecision(ctx, currencyNumber);
        result = result.divide(new BigDecimal("1"), precision, 6);
        return result;
    }

    private Vector getExeBgSchemeIds(Context ctx, String orgUnitId) throws SQLDataException, EASBizException {
        Vector<String> result = new Vector<String>();
        Connection myConn = this.getConnection(ctx);
        PreparedStatement myStmt = null;
        ResultSet myRst = null;
        StringBuffer mySb = new StringBuffer(1024);
        mySb.append("select fid from t_bg_bgscheme where forgunitid = ? and fisformal=1");
        try {
            myStmt = myConn.prepareStatement(mySb.toString());
            myStmt.setString(1, orgUnitId);
            myRst = myStmt.executeQuery();
            while (myRst.next()) {
                result.add(myRst.getString("fid"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BgException(BgException.DATABASEERROR, e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(myRst, (Statement)myStmt, (Connection)myConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)myRst, (Statement)myStmt, (Connection)myConn);
        return result;
    }

    @Override
    protected String _parseBgItemCombi(Context ctx, String bgItemCombin, String orgUnitId) throws BOSException, EASBizException {
        if (bgItemCombin == null) {
            return "";
        }
        if (bgItemCombin.equals("")) {
            return "";
        }
        String[] strs = bgItemCombin.replaceAll("_", ",").split(",");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        String result = "";
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String sql = "select fnumber ,freffield from t_bg_bgitem where ";
            String numberFilterSql = "";
            for (int i = 0; i < strs.length; ++i) {
                numberFilterSql = i == 0 ? "( fnumber = ? " : numberFilterSql + "  or fnumber = ? ";
            }
            String orgFilterSql = " ) and forgunitid = ?";
            String orderSql = " order by TO_NUMBER(SUBSTRING(FRefField, 2, LENGTH(FRefField)-1)) asc";
            sql = sql + numberFilterSql + orgFilterSql + orderSql;
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            for (int i = 0; i < strs.length; ++i) {
                ps.setString(i + 1, strs[i]);
            }
            ps.setString(strs.length + 1, BgSHelper.getIsolateOrg(ctx, orgUnitId));
            rs = ps.executeQuery();
            while (rs.next()) {
                result = result + rs.getString(1) + ",";
                if (map.containsKey(rs.getString(2))) {
                    throw new BgCommonException(BgCommonException.EXISTSAMEITEMGROUP);
                }
                map.put(rs.getString(2), rs.getString(2));
            }
            if (result.length() > 0) {
                result = result.substring(0, result.length() - 1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return result;
    }

    @Override
    protected String _parseBgItemCombi_ctrl(Context ctx, String bgItemCombin, String orgUnitId) throws BOSException, EASBizException {
        if (bgItemCombin == null) {
            return "";
        }
        if (bgItemCombin.equals("")) {
            return "";
        }
        String[] strs = bgItemCombin.replaceAll("_", ",").split(",");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        String result = "";
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String sql = "select fnumber ,freffield from t_bg_bgitem where ";
            String numberFilterSql = "";
            if (strs.length > 0) {
                numberFilterSql = "(";
                for (int i = 0; i < strs.length; ++i) {
                    numberFilterSql = i == 0 ? numberFilterSql + " fnumber = ? " : numberFilterSql + "  or fnumber = ? ";
                }
                numberFilterSql = numberFilterSql + ")";
            }
            String orgFilterSql = " and FOrgUnitId = ?";
            String orderSql = " order by TO_NUMBER(SUBSTRING(FRefField, 2, LENGTH(FRefField)-1)) asc";
            sql = sql + numberFilterSql + orgFilterSql + orderSql;
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            for (int i = 0; i < strs.length; ++i) {
                ps.setString(i + 1, strs[i]);
            }
            ps.setString(strs.length + 1, BgSHelper.getIsolateOrg(ctx, orgUnitId));
            rs = ps.executeQuery();
            while (rs.next()) {
                result = result + rs.getString(1) + ",";
                if (map.containsKey(rs.getString(2))) {
                    throw new BgCommonException(BgCommonException.EXISTSAMEITEMGROUP);
                }
                map.put(rs.getString(2), rs.getString(2));
            }
            if (result.length() > 0) {
                result = result.substring(0, result.length() - 1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        if (result == null || result.trim().length() == 0 || result.split(",").length != strs.length) {
            return bgItemCombin;
        }
        return result;
    }

    @Override
    protected HashMap _batchParseBgItemCombi(Context ctx, HashMap bgItemCombinMap, String orgUnitId) throws BOSException, EASBizException {
        if (bgItemCombinMap == null || bgItemCombinMap.isEmpty()) {
            return null;
        }
        HashMap bgItemMap = new HashMap();
        for (String bgItemCombin : bgItemCombinMap.keySet()) {
            if (bgItemCombin == null || bgItemCombin.trim().equals("")) continue;
            String[] strs = bgItemCombin.split(",");
            for (int i = 0; i < strs.length; ++i) {
                bgItemMap.put(strs[i], null);
            }
        }
        BgNFSHelper.getRefField((Context)ctx, bgItemMap, (String)orgUnitId);
        HashMap tmpMap = new HashMap();
        Vector refFieldVec = new Vector();
        block2: for (String bgItemCombin : bgItemCombinMap.keySet()) {
            tmpMap.clear();
            refFieldVec.clear();
            Object[] obj1 = new Object[2];
            if (StringUtils.isEmpty((String)bgItemCombin)) continue;
            String[] strs = bgItemCombin.split(",");
            for (int i = 0; i < strs.length; ++i) {
                Object _obj;
                if (!bgItemMap.containsKey(strs[i]) || (_obj = bgItemMap.get(strs[i])) == null) continue;
                if (!tmpMap.containsKey(bgItemMap.get(strs[i]))) {
                    tmpMap.put(bgItemMap.get(strs[i]), strs[i]);
                    continue;
                }
                obj1[0] = null;
                obj1[1] = true;
                bgItemCombinMap.put(bgItemCombin, obj1);
                continue block2;
            }
            refFieldVec = this.sort(tmpMap, refFieldVec);
            String newBgItemCombin = "";
            for (int i = 0; i < refFieldVec.size(); ++i) {
                String number;
                String refField = (String)refFieldVec.get(i);
                if (!tmpMap.containsKey(refField) || StringUtils.isEmpty((String)(number = (String)tmpMap.get(refField)))) continue;
                newBgItemCombin = newBgItemCombin + number + ",";
            }
            if (!StringUtils.isEmpty((String)newBgItemCombin)) {
                newBgItemCombin = newBgItemCombin.substring(0, newBgItemCombin.length() - 1);
                obj1[0] = newBgItemCombin;
                obj1[1] = false;
                bgItemCombinMap.put(bgItemCombin, obj1);
                continue;
            }
            obj1[0] = null;
            obj1[1] = false;
            bgItemCombinMap.put(bgItemCombin, obj1);
        }
        return bgItemCombinMap;
    }

    private Vector sort(Map sort, Vector result) {
        if (sort == null) {
            return result;
        }
        if (sort.size() == 1) {
            result.addAll(sort.keySet());
            return result;
        }
        ArrayList _tmpList = new ArrayList();
        _tmpList.addAll(sort.keySet());
        Collections.sort(_tmpList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int one = Integer.parseInt(arg0.toString().substring(1));
                int two = Integer.parseInt(arg1.toString().substring(1));
                return one - two;
            }
        });
        result.addAll(_tmpList);
        return result;
    }

    private void getRefField(Context ctx, HashMap bgItemMap) throws BOSException {
        if (ctx == null || bgItemMap == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList tmpList = new ArrayList();
        tmpList.addAll(bgItemMap.keySet());
        int index = 0;
        int batchNum = 50;
        int size = tmpList.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select fnumber, freffield from T_BG_BgItem where fnumber in(");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < count; ++i) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)tmpList.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgItemMap.put(rst.getString(1), rst.getString(2));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    private int getPrecision(Context ctx, String currencyNumber) {
        int result = 2;
        Hashtable table = null;
        if (ctx.get((Object)"BgCurrencyPrec") == null) {
            table = new Hashtable();
            try {
                CoreBaseInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getValue("select id,precision where number ='" + currencyNumber + "'");
                result = currency.getInt("precision");
            }
            catch (EASBizException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            table.put(currencyNumber, new Integer(result));
            ctx.put((Object)"BgCurrencyPrec", (Object)table);
        } else {
            table = (Hashtable)ctx.get((Object)"BgCurrencyPrec");
            if (table.get(currencyNumber) == null) {
                try {
                    CoreBaseInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getValue("select id,precision where number ='" + currencyNumber + "'");
                    result = currency.getInt("precision");
                }
                catch (EASBizException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                table.put(currencyNumber, new Integer(result));
            } else {
                result = (Integer)table.get(currencyNumber);
            }
        }
        return result;
    }

    @Override
    protected String _bgRefBgForm(Context ctx, String orgCode, String bgFormCode, String sheetName, String cellName) throws BOSException, EASBizException {
        String result = "0";
        IBgForm iBg = BgFormFactory.getLocalInstance(ctx);
        BgFormCollection coll = null;
        try {
            coll = iBg.getBgFormCollection("select data where  orgUnit.number='" + orgCode + "' and  number='" + bgFormCode + "'  and ( state=" + 2 + " or state = " + 1 + ")");
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (coll != null && coll.size() > 0) {
            BgFormInfo info = coll.get(0);
            Book _book = null;
            try {
                _book = info.getBook();
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            Rect pos = TableToolkit.range2xy((String)cellName);
            if (pos == null || !pos.isValid()) {
                return "";
            }
            int x = pos.getXBase();
            int y = pos.getYBase();
            if (_book != null) {
                Sheet _sheet = null;
                int _sheetSize = _book.getSheetCount();
                for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
                    _sheet = _book.getSheet(_sheetIndex);
                    if (!_sheet.getSheetName().equals(sheetName)) continue;
                    Cell cell = _sheet.getCell(y, x, false);
                    String string = result = BgNFSHelper.getValue((Cell)cell) == null ? result : BgNFSHelper.getValue((Cell)cell).toString();
                    if (result == null || result.equals("")) {
                        result = "0";
                    }
                    return result;
                }
            }
        }
        return result;
    }

    @Override
    protected String _bgRefBgTem(Context ctx, String orgCode, String schemeCode, String bgTemCode, String bgPeriodCode, String sheetName, String cellName) throws BOSException, EASBizException {
        String result = "";
        BigDecimal result1 = new BigDecimal("0.00");
        IBgForm iBg = BgFormFactory.getLocalInstance(ctx);
        String[] orgs = orgCode.split(";");
        for (int i = 0; i < orgs.length; ++i) {
            BgFormInfo info = null;
            try {
                info = iBg.getBgFormInfo("select number where (state=2 or state=1) and orgUnit.number='" + orgs[i].trim() + "' and bgScheme.number='" + schemeCode + "'  and bgTemplate.number='" + bgTemCode + "' and bgPeriod.number='" + bgPeriodCode + "'");
            }
            catch (ObjectNotFoundException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            if (info == null) continue;
            result = this._bgRefBgForm(ctx, orgs[i].trim(), info.getNumber(), sheetName, cellName);
            try {
                BigDecimal tmp = new BigDecimal(result.trim());
                result1 = result1.add(tmp);
                continue;
            }
            catch (NumberFormatException e) {
                logger.error((Object)e);
            }
        }
        return result1.toString();
    }

    @Override
    protected BigDecimal _BgActualFD(Context ctx, String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        return this.getActual(ctx, orgNumber, bgSchemeNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber, "fbizactual");
    }

    @Override
    protected BigDecimal _getAdjust(Context ctx, String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        BigDecimal result = new BigDecimal("0.00");
        IBgPeriod ibgperiod = BgPeriodFactory.getLocalInstance(ctx);
        BgPeriodInfo beginPeriodInfo = null;
        BgPeriodInfo endPeriodInfo = null;
        NewBgCompareAndAnalysisFilterParam filterParam = new NewBgCompareAndAnalysisFilterParam();
        beginPeriodInfo = ibgperiod.getBgPeriodInfo("select beginDate,endDate,periodType,id where number='" + beginPeriodNumber + "'");
        if (beginPeriodInfo == null) {
            return result;
        }
        endPeriodInfo = ibgperiod.getBgPeriodInfo("select beginDate,endDate,periodType,id where number='" + endPeriodNumber + "'");
        BgSchemeInfo scheme = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo("select id where number ='" + bgSchemeNumber + "' and orgunit.number = '" + orgNumber + "'");
        FullOrgUnitInfo org = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("where number ='" + orgNumber + "'");
        filterParam.setBgSchemeInfo(scheme);
        filterParam.setBeginPeriod(beginPeriodInfo);
        filterParam.setEndPeriod(endPeriodInfo);
        BgCompareAndAnalysisObjInfo.BudgetAdjustRecordDataObj info = null;
        BgPeriodCollection periodCol = null;
        try {
            periodCol = BgPeriodFactory.getLocalInstance(ctx).getPeriodCollection(beginPeriodInfo.getId(), endPeriodInfo.getId());
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        int size = periodCol.size();
        for (int i = 0; i < size; ++i) {
            String formula = "=BgItem(\"" + strItemCombinNum + "\",\"" + periodCol.get(i).getNumber() + "\",\"" + bgElementNumber + "\",\"BgData\",true,\"" + currencyNumber + "\")";
            List list = BgCompareAndAnalysisFacadeFactory.getLocalInstance(ctx).getBudgetViewValueList(filterParam, org.getId().toString(), formula);
            int sizeList = list.size();
            for (int j = 0; j < sizeList; ++j) {
                info = (BgCompareAndAnalysisObjInfo.BudgetAdjustRecordDataObj)list.get(j);
                result = result.add(info.getPastVal());
            }
        }
        return result;
    }
}

