/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.budget.ActualTypeEnum;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgCtrlRecordCollection;
import com.kingdee.eas.ma.budget.BgCtrlRecordInfo;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgElimHelper;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemEfficacyException;
import com.kingdee.eas.ma.budget.BgItemException;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemHelper;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemReferenceException;
import com.kingdee.eas.ma.budget.BgItemReferenceHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTraceTypeEnum;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.BudgetRequestCategory;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.app.AbstractBgItemControllerBean;
import com.kingdee.eas.ma.budget.app.BudgetCtrlCacheHelper;
import com.kingdee.eas.ma.budget.app.BudgetCtrlHelper;
import com.kingdee.eas.ma.nbudget.BgDataRelationEnum;
import com.kingdee.eas.ma.nbudget.BgElimTypeEnum;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BgItemControllerBean
extends AbstractBgItemControllerBean {
    private static final long serialVersionUID = -7177759359746840940L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgItemControllerBean");
    private static final int bgItemGroupMaxNumber = 100;
    private static final String sumItemPatternString = "([\\(]*)([^\\+|^\\-|^\\*|^\\/|^\\(|^\\))]{1,})([\\+|\\-|\\*|\\/|\\(|\\)]*)";
    private static final String RES_PATH = "com.kingdee.eas.ma.budget.BgItemAppResource";
    private static final int MAX_LONGNUMBER = 1000;

    private ArrayList getItemTreeIds(Context ctx, String number, String orgUnitId) throws BOSException {
        orgUnitId = BgSHelper.getIsolateOrg(ctx, orgUnitId);
        ArrayList<String> Ids = new ArrayList<String>();
        String sql = "select FId from t_bg_bgitem where forgUnitId = '" + orgUnitId + "' and (fLongNumber like '" + number + "!%' or fnumber = '" + number + "' )";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (null != rs) {
            try {
                while (rs.next()) {
                    Ids.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return Ids;
    }

    private ArrayList getItemTreeNums(Context ctx, String number, String orgUnitId) throws BOSException {
        orgUnitId = BgSHelper.getIsolateOrg(ctx, orgUnitId);
        ArrayList<String> Ids = new ArrayList<String>();
        String sql = "select FNumber from t_bg_bgitem where forgUnitId = '" + orgUnitId + "' and (fLongNumber like '" + number + "!%' or fnumber = '" + number + "' )";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (null != rs) {
            try {
                while (rs.next()) {
                    Ids.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return Ids;
    }

    private void updateItemFpFields(Context ctx, List ids, int isForFP, int fpDirection) throws BOSException {
        String headIds = BgElimHelper.convertToSqlParam(ids);
        if (headIds == null) {
            return;
        }
        ArrayList<Integer> param = new ArrayList<Integer>();
        param.add(new Integer(isForFP));
        param.add(new Integer(fpDirection));
        String updateHead = "update t_bg_bgitem set FIsForFp = ?, FFpDirection = ? where FId in " + headIds;
        DbUtil.execute((Context)ctx, (String)updateHead, (Object[])param.toArray());
    }

    protected int getLongNumberLen(Context ctx, TreeBaseInfo info) throws EASBizException, BOSException {
        return 1000;
    }

    private void updateItemFpElims(Context ctx, List ids, int elimType, int dataRela) throws BOSException {
        String headIds = BgElimHelper.convertToSqlParam(ids);
        if (headIds == null) {
            return;
        }
        ArrayList<Integer> param = new ArrayList<Integer>();
        param.add(new Integer(elimType));
        param.add(new Integer(dataRela));
        String updateHead = "update t_bg_bgitem set felimtype = ?, fdatarela = ? where FId in " + headIds;
        DbUtil.execute((Context)ctx, (String)updateHead, (Object[])param.toArray());
    }

    private void updateFpFields(Context ctx, BgItemInfo info) throws BOSException, EASBizException {
        if (!this.isFpFieldChange(ctx, info)) {
            return;
        }
        ArrayList Ids = this.getItemTreeIds(ctx, info.getNumber(), info.getOrgUnit().getId().toString());
        Map referenceMap = BgItemReferenceHelper.getAllReferencedItemNumber(ctx, Ids);
        List referenceNumList = null;
        if (referenceMap != null) {
            referenceNumList = (List)referenceMap.get("referenceNumbers");
        }
        boolean isRef = false;
        StringBuffer refNum = null;
        boolean isTooLong = false;
        if (referenceNumList != null && referenceNumList.size() > 0) {
            isRef = true;
            refNum = new StringBuffer();
            int size = referenceNumList.size();
            isTooLong = false;
            if (size > 10) {
                size = 10;
                isTooLong = true;
            }
            for (int i = 0; i < size; ++i) {
                refNum.append(referenceNumList.get(i) + ",");
            }
        }
        if (isRef) {
            refNum.delete(refNum.length() - 1, refNum.length());
            if (isTooLong) {
                refNum.append("\u7b49");
            }
            throw new BgItemReferenceException(BgItemReferenceException.ITEMREFERENCED, new Object[]{refNum.toString()});
        }
        int fpDrc = 0;
        fpDrc = info.getFpDirection() == null ? 10 : info.getFpDirection().getValue();
        this.updateItemFpFields(ctx, Ids, info.isIsForFP() ? 1 : 0, fpDrc);
    }

    private void updateFpElims(Context ctx, BgItemInfo info) throws BOSException, EASBizException {
        if (!this.isFpElimChange(ctx, info)) {
            return;
        }
        ArrayList Ids = this.getItemTreeIds(ctx, info.getNumber(), info.getOrgUnit().getId().toString());
        int elimType = 0;
        int dataRela = -1;
        elimType = info.getElimType() == null ? 0 : info.getElimType().getValue();
        dataRela = info.getDataRelation().getValue();
        this.updateItemFpElims(ctx, Ids, elimType, dataRela);
    }

    @Override
    protected String _updateFpDirection(Context ctx, ArrayList ids, FpCashDirectionEnum fpDirection) throws BOSException, EASBizException {
        int fpDrcValue = fpDirection.getValue();
        BgItemCollection coll = this.getItemColl(ctx, ids);
        BgItemInfo info = null;
        String orgUnitId = null;
        if (coll != null && !coll.isEmpty() && coll.get(0) != null && coll.get(0).getOrgUnit() != null) {
            orgUnitId = coll.get(0).getOrgUnit().getId().toString();
        }
        String headNumber = null;
        ArrayList<String> level1Number = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            String logName = info.getNumber() + " " + info.getName();
            IObjectPK objectPK = LogUtil.beginLog((Context)ctx, (String)"_updateFpDirection", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgItem_setFIType");
            headNumber = info.getNumber();
            if (headNumber.indexOf(".") == -1) {
                level1Number.add(headNumber);
            } else {
                String number = headNumber.substring(0, headNumber.indexOf("."));
                if (!level1Number.contains(number)) {
                    level1Number.add(number);
                }
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)objectPK);
        }
        ArrayList treeIds = null;
        StringBuffer refNumber = new StringBuffer();
        StringBuffer passNumber = new StringBuffer();
        ArrayList<String> sqls = new ArrayList<String>();
        String l1Number = null;
        Map referenceMap = null;
        List referenceNumList = null;
        for (int i = 0; i < level1Number.size(); ++i) {
            l1Number = (String)level1Number.get(i);
            treeIds = this.getItemTreeIds(ctx, l1Number, orgUnitId);
            referenceMap = BgItemReferenceHelper.getAllReferencedItemNumber(ctx, treeIds);
            if (referenceMap != null) {
                referenceNumList = (List)referenceMap.get("referenceNumbers");
            }
            if (referenceNumList != null && referenceNumList.size() > 0) {
                int size = referenceNumList.size();
                for (int j = 0; j < size; ++j) {
                    refNumber.append(referenceNumList.get(j)).append(",");
                }
                continue;
            }
            passNumber.append(l1Number).append(",");
            String param = BgElimHelper.convertToSqlParam(treeIds);
            sqls.add("update t_bg_bgitem set FIsForFp = 1, FFpDirection = " + fpDrcValue + " where FId in " + param);
        }
        BgElimHelper.executeBatch(ctx, sqls);
        String detail = "";
        String refN = " ";
        String passN = " ";
        if (refNumber.length() > 0) {
            refN = refNumber.substring(0, refNumber.lastIndexOf(","));
        }
        if (passNumber.length() > 0) {
            passN = passNumber.substring(0, passNumber.lastIndexOf(","));
        }
        detail = refN + "!" + passN;
        return detail;
    }

    private BgItemCollection getItemColl(Context ctx, ArrayList headId) throws BOSException {
        BgItemCollection coll = new BgItemCollection();
        HashSet set = new HashSet();
        set.addAll(headId);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("orgUnit.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSelector(selector);
        view.setFilter(filter);
        view.setSorter(sorter);
        coll = BgItemFactory.getLocalInstance(ctx).getBgItemCollection(view);
        return coll;
    }

    private boolean isFpFieldChange(Context ctx, BgItemInfo info) throws BOSException {
        boolean isChanged = true;
        String sql = "select 1 from t_bg_bgitem where fnumber =? and forgUnitId = ?  and FIsForFp = ? and FFpDirection = ? ";
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(info.getNumber());
        try {
            param.add(BgSHelper.getIsolateOrg(ctx, info.getOrgUnit().getId().toString()));
        }
        catch (Exception e1) {
            logger.error((Object)"budget error:", (Throwable)e1);
        }
        param.add(new Integer(info.isIsForFP() ? 1 : 0));
        if (info.getFpDirection() == null) {
            param.add(new Integer(10));
        } else {
            param.add(new Integer(info.getFpDirection().getValue()));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param.toArray());
        if (null != rs) {
            try {
                if (rs.next()) {
                    isChanged = false;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return isChanged;
    }

    private boolean isFpElimChange(Context ctx, BgItemInfo info) throws BOSException {
        boolean isChanged = true;
        String sql = "select 1 from t_bg_bgitem where fnumber =? and forgUnitId = ?  and fdatarela = ? and felimtype = ? ";
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(info.getNumber());
        param.add(BgSHelper.getIsolateOrg(ctx, info.getOrgUnit().getId().toString()));
        param.add(new Integer(info.getDataRelation().getValue()));
        if (info.getElimType() == null) {
            param.add(new Integer(0));
        } else {
            param.add(new Integer(info.getElimType().getValue()));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param.toArray());
        if (null != rs) {
            try {
                if (rs.next()) {
                    isChanged = false;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return isChanged;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostCenterOrgUnitInfo costCenterInfo;
        String orgLongNum = "";
        if (model == null) {
            return null;
        }
        IObjectPK pk = null;
        IObjectValue _parent = null;
        BgItemInfo info = (BgItemInfo)model;
        model.setBOSUuid("id", BOSUuid.create((BOSObjectType)model.getBOSType()));
        String ccorgUnitId = ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString();
        FullOrgUnitInfo ccOrgUnit = new FullOrgUnitInfo();
        ccOrgUnit.setId(BOSUuid.read((String)ccorgUnitId));
        String orgUnitId = null;
        orgUnitId = info.getOrgUnit() == null || info.getOrgUnit().getId() == null ? ccorgUnitId : info.getOrgUnit().getId().toString();
        if (info.getOrgUnit() != null && (costCenterInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getOrgUnit().getId().toString()))) != null) {
            orgLongNum = costCenterInfo.getLongNumber();
        }
        if (StringUtils.isEmpty((String)orgLongNum)) {
            orgLongNum = ContextUtil.getCurrentCostUnit((Context)ctx).getLongNumber();
        }
        if (info.getAssignParentOrg() == null) {
            info.setAssignParentOrg(ccOrgUnit);
        }
        if (info.getAssignRootOrg() == null) {
            info.setAssignRootOrg(ccOrgUnit);
        }
        this.checkNumber(ctx, info);
        _parent = this.getParent(ctx, orgUnitId, info);
        this.setParams(_parent, orgUnitId, info);
        pk = super._addnew(ctx, (IObjectValue)info);
        this.updateParentAfterAddNew(ctx, _parent);
        if (!BgSHelper.isBgItemIsolate(ctx)) {
            this.updateBgItemAfterAddNew(ctx, orgLongNum, info.getNumber());
        }
        return pk;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkNumber(Context ctx, BgItemInfo info) throws BOSException, EASBizException {
        int i;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String companyId = null;
        companyId = info.getOrgUnit() == null || info.getOrgUnit().getId() == null ? ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString() : info.getOrgUnit().getId().toString();
        if (StringUtils.isEmpty((String)info.getNumber())) {
            BgHelper.setSNumber(ctx, companyId, (CoreBaseInfo)info);
            if (StringUtils.isEmpty((String)info.getNumber())) {
                info.setNumber("BgItem-" + System.currentTimeMillis());
            }
        }
        String number = info.getNumber();
        String orgUnitId = BgSHelper.getIsolateOrg(ctx, companyId);
        String refField = info.getRefField();
        int elimType = info.getElimType().getValue();
        String[] especialChar = new String[20];
        for (i = 0; i < 20; ++i) {
            especialChar[i] = "";
        }
        especialChar[0] = "_";
        i = 0;
        while (!especialChar[i].equals("")) {
            if (number.indexOf(especialChar[i]) != -1) {
                throw new BgItemException(BgItemException.ERRORNUM, new String[]{number});
            }
            ++i;
        }
        try {
            conn = this.getConnection(ctx);
            if (!BgSHelper.isBgItemIsolate(ctx)) {
                pstmt = conn.prepareStatement("select FNumber from t_bg_bgItem where FNumber = ? ");
                pstmt.setString(1, number);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    throw new BgItemException(BgItemException.BGITEMNUMBEREXISTS, new String[]{rst.getString(1)});
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            } else {
                pstmt = conn.prepareStatement("select FNumber from t_bg_bgItem where FNumber = ? and FOrgUnitId = ? ");
                pstmt.setString(1, number);
                pstmt.setString(2, orgUnitId);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    throw new BgItemException(BgItemException.BGITEMNUMBEREXISTS, new String[]{rst.getString(1)});
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                pstmt = conn.prepareStatement("select distinct i.FRefField, g.FName_" + ctx.getLocale() + ", k.FName_L2,i.felimtype from t_bg_bgItem i  join t_bg_bgItemGroup g on i.fRefField = g.fRefField join t_org_costcenter k on i.forgunitid=k.fid  where i.FNumber = ? ");
                pstmt.setString(1, number);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!rst.getString(1).equals(refField)) {
                        throw new BgItemException(BgItemException.ORGUNITREPEATERROR, new String[]{number, rst.getString(3), rst.getString(2)});
                    }
                    if (rst.getInt(4) == elimType) continue;
                    throw new BgItemException(BgItemException.BGELIMITIONDIF, new String[]{rst.getString(3), rst.getString(2), number});
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    public IObjectValue getParent(Context ctx, String orgUnitId, BgItemInfo info) throws BOSException, EASBizException {
        orgUnitId = BgSHelper.getIsolateOrg(ctx, orgUnitId);
        String number = info.getNumber();
        String longNumber = info.getLongNumber();
        String itemGroupID = info.getBgItemGroup().getId().toString();
        String parentNumber = null;
        String parentLongNumber = null;
        IBgItem bgItem = null;
        BgItemInfo _parent = null;
        bgItem = BgItemFactory.getLocalInstance(ctx);
        int dot = number.lastIndexOf(".");
        if (dot != -1) {
            parentNumber = number.substring(0, dot);
            try {
                _parent = bgItem.getBgItemInfo("select id, number, level where number = '" + parentNumber + "' and bgItemGroup.id = '" + itemGroupID + "' and orgUnit.id = '" + orgUnitId + "'");
            }
            catch (BOSException e) {
                if (e instanceof ObjectNotFoundException) {
                    throw new BgItemException(BgItemException.PARENTNOTEXIST, new String[]{parentNumber});
                }
                throw e;
            }
            catch (EASBizException e) {
                throw e;
            }
            if (_parent == null) {
                throw new BgItemException(BgItemException.PARENTNOTEXIST, new String[]{parentNumber});
            }
        } else {
            int index;
            int n = index = longNumber == null ? -1 : longNumber.lastIndexOf("!");
            if (index != -1) {
                parentLongNumber = longNumber.substring(0, index);
                try {
                    _parent = bgItem.getBgItemInfo("select id, number, level where longNumber = '" + parentLongNumber + "' and bgItemGroup.id = '" + itemGroupID + "' and orgUnit.id = '" + orgUnitId + "'");
                }
                catch (BOSException e) {
                    int n2 = index = parentLongNumber == null ? -1 : parentLongNumber.lastIndexOf("!");
                    if (e instanceof ObjectNotFoundException) {
                        if (index != -1 && parentLongNumber.length() >= index + 1) {
                            parentNumber = parentLongNumber.substring(index + 1);
                            throw new BgItemException(BgItemException.PARENTNOTEXIST, new String[]{parentNumber});
                        }
                        throw new BgItemException(BgItemException.PARENTNOTEXIST, new String[]{parentLongNumber});
                    }
                    throw e;
                }
                catch (EASBizException e) {
                    throw e;
                }
                if (_parent == null) {
                    throw new BgItemException(BgItemException.PARENTNOTEXIST, new String[]{parentLongNumber});
                }
            }
        }
        return _parent;
    }

    public void setParams(IObjectValue parent, String orgUnitId, BgItemInfo info) {
        if (info == null) {
            return;
        }
        if (parent != null && parent instanceof BgItemInfo) {
            BgItemInfo _parent = (BgItemInfo)parent;
            info.setParent(_parent);
            info.setLevel(_parent.getLevel() + 1);
        } else {
            info.setParent(info);
            info.setLevel(1);
        }
        info.setAssignParent(info);
        info.setAssignRoot(info);
        info.setIsEffective(true);
        info.setIsLeaf(true);
    }

    public void updateParentAfterAddNew(Context ctx, IObjectValue parent) throws BOSException {
        if (parent == null) {
            return;
        }
        BgItemInfo _parent = (BgItemInfo)parent;
        String sql = "update T_BG_BgItem set FIsLeaf = 0 where FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{_parent.getId().toString()});
    }

    public void updateBgItemAfterAddNew(Context ctx, String orgLongNum, String number) throws BOSException {
        if (number == null) {
            return;
        }
        String sql = "update t_bg_bgItem set FOrgUnitID = '00000000-0000-0000-0000-000000000000CCE7AED4', FSimpleName ='no_dataMigrate', FCurOrgUnitLongNumber = ? where fnumber = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{orgLongNum, number});
    }

    public void updateParentAfterDelete(Context ctx, IObjectValue parent) throws BOSException {
        if (parent == null) {
            return;
        }
        BgItemInfo _parent = (BgItemInfo)parent;
        String sql = "update T_BG_BgItem set FIsLeaf = 1 where FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{_parent.getId().toString()});
    }

    public void deleteWithChildren(Context ctx, TreeBaseInfo model) throws BOSException, TreeBaseException, EASBizException {
        super.deleteWithChildren(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgItemInfo _bgItemInfo = (BgItemInfo)this._getValue(ctx, pk);
        Map map = this.checkCanDelete(ctx, pk);
        this.deleteInfo(ctx, pk);
        this.updateParentAfterDelete(ctx, (IObjectValue)_bgItemInfo.getParent());
        this.dealBgItemCombinForDeleteBgItem(ctx, map);
        String companyId = null;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (company != null) {
            companyId = company.getId().toString();
        }
        BgHelper.recycleNumber(ctx, (CoreBaseInfo)_bgItemInfo, companyId);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK, String curOrgUnitId) throws BOSException, EASBizException {
        if (arrayPK == null || arrayPK.length <= 0) {
            return;
        }
        HashSet<IObjectPK> pkSet = new HashSet<IObjectPK>();
        for (int i = 0; i < arrayPK.length; ++i) {
            pkSet.add(arrayPK[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("Level"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.longNumber"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("refField"));
        sic.add(new SelectorItemInfo("assignRootOrg.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", pkSet, CompareType.INCLUDE));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(sorter);
        BgItemCollection col = this.getBgItemCollection(ctx, view);
        Map notDeleteMap = this.batchCheckCanDelete(ctx, col, curOrgUnitId);
        BgItemInfo info = null;
        String number = null;
        BgItemCollection toDelete = new BgItemCollection();
        StringBuffer errorDetailMSG = new StringBuffer();
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            number = info.getNumber();
            if (!notDeleteMap.containsKey(number)) {
                toDelete.add(info);
                continue;
            }
            errorDetailMSG.append(notDeleteMap.get(number)).append("\n");
        }
        if (!toDelete.isEmpty()) {
            this.deleteInfo(ctx, toDelete);
            this.dealBgItemCombinForDeleteBgItem(ctx, toDelete);
        }
        if (errorDetailMSG.length() > 0) {
            throw new BgItemException(BgItemException.FINDFDCBILLERROR, new String[]{errorDetailMSG.toString()});
        }
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        this._delete(ctx, arrayPK, null);
    }

    /*
     * Exception decompiling
     */
    protected Map checkCanDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map batchCheckCanDelete(Context ctx, BgItemCollection col, String curOrgUnitId) throws BOSException, EASBizException {
        if (col == null) return new HashMap();
        if (col.isEmpty()) {
            return new HashMap();
        }
        boolean isBgItemIsolate = BgSHelper.isBgItemIsolate(ctx);
        String currOrgUnitId = StringUtils.isEmpty((String)curOrgUnitId) ? ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString() : curOrgUnitId;
        HashMap<String, String> notDeleteMap = new HashMap<String, String>();
        HashMap refMap = new HashMap();
        HashMap<String, String> longNumMap = new HashMap<String, String>();
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> allNumbers = new ArrayList<String>();
        BgItemInfo info = null;
        String id = null;
        String number2 = null;
        String longNum = null;
        String refField2 = null;
        String orgUnitId = null;
        int level = 0;
        for (int i = 0; i < col.size(); ++i) {
            List<String> numberList;
            info = col.get(i);
            id = info.getId().toString();
            number2 = info.getNumber();
            longNum = info.getLongNumber();
            refField2 = info.getRefField();
            if (orgUnitId == null) {
                orgUnitId = info.getOrgUnit().getId().toString();
            }
            if (!isBgItemIsolate && !currOrgUnitId.equals(info.getAssignRootOrg().getId().toString())) {
                notDeleteMap.put(number2, MessageFormat.format(ResourceBase.getString((String)RES_PATH, (String)"CanNotDelItemForOrg", (Locale)ctx.getLocale()), info.getNumber()));
            }
            idList.add(id);
            allNumbers.add(number2);
            longNumMap.put(number2, longNum);
            if (!refMap.containsKey(refField2)) {
                numberList = new ArrayList<String>();
                numberList.add(number2);
                refMap.put(refField2, numberList);
                continue;
            }
            numberList = (List)refMap.get(refField2);
            numberList.add(number2);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 200;
        int size = idList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        try {
            conn = this.getConnection(ctx);
            List numberList = null;
            HashMap<String, String> refMsgMap = new HashMap<String, String>();
            String temStr = null;
            StringBuffer sql = new StringBuffer();
            for (String refField2 : refMap.keySet()) {
                int i;
                int i2;
                int i3;
                int i4;
                int i5;
                int i6;
                numberList = (List)refMap.get(refField2);
                if (numberList.isEmpty()) continue;
                sql.delete(0, sql.length());
                sql.append("select distinct c." + refField2 + ", t.fnumber from t_bg_bgItemCombination c ");
                sql.append("join t_bg_bgTemRefBgItemcombin refItem on c.fid = refItem.fbgitemcombinid ");
                sql.append("join t_bg_bgTemplate t on t.fid = refItem.fbgTemplateid ");
                sql.append("where c." + refField2 + " in (");
                for (i6 = 1; i6 < numberList.size(); ++i6) {
                    sql.append("?,");
                }
                sql.append("?) ");
                if (isBgItemIsolate) {
                    sql.append("and t.fOrgUnitId = ? ");
                }
                sql.append("order by c." + refField2);
                pstmt = conn.prepareStatement(sql.toString());
                for (i6 = 0; i6 < numberList.size(); ++i6) {
                    pstmt.setString(i6 + 1, (String)numberList.get(i6));
                }
                if (isBgItemIsolate) {
                    pstmt.setString(numberList.size() + 1, orgUnitId);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!refMsgMap.containsKey(rst.getString(1))) {
                        refMsgMap.put(rst.getString(1), rst.getString(2));
                        continue;
                    }
                    temStr = (String)refMsgMap.get(rst.getString(1));
                    refMsgMap.put(rst.getString(1), temStr + "," + rst.getString(2));
                }
                for (String number2 : refMsgMap.keySet()) {
                    if (!notDeleteMap.containsKey(number2)) {
                        notDeleteMap.put(number2, new BgItemException(BgItemException.REFBYTEMPLATE, new String[]{number2, (String)refMsgMap.get(number2)}).getMessage());
                        continue;
                    }
                    temStr = (String)notDeleteMap.get(number2);
                    notDeleteMap.put(number2, temStr + "\n" + new BgItemException(BgItemException.REFBYTEMPLATE, new String[]{number2, (String)refMsgMap.get(number2)}).getMessage());
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                refMsgMap.clear();
                sql.delete(0, sql.length());
                sql.append("select distinct c." + refField2 + ", f.fnumber from t_bg_bgItemCombination c ");
                sql.append("join t_bg_bgdata d on c.fid = d.fbgitemcombinid ");
                sql.append("join t_bg_bgForm f on f.fid = d.fbgFormid ");
                sql.append("where c." + refField2 + " in (");
                for (i5 = 1; i5 < numberList.size(); ++i5) {
                    sql.append("?,");
                }
                sql.append("?) ");
                if (isBgItemIsolate) {
                    sql.append("and f.fOrgUnitId = ? ");
                }
                sql.append("order by c." + refField2);
                pstmt = conn.prepareStatement(sql.toString());
                for (i5 = 0; i5 < numberList.size(); ++i5) {
                    pstmt.setString(i5 + 1, (String)numberList.get(i5));
                }
                if (isBgItemIsolate) {
                    pstmt.setString(numberList.size() + 1, orgUnitId);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!refMsgMap.containsKey(rst.getString(1))) {
                        refMsgMap.put(rst.getString(1), rst.getString(2));
                        continue;
                    }
                    temStr = (String)refMsgMap.get(rst.getString(1));
                    refMsgMap.put(rst.getString(1), temStr + "," + rst.getString(2));
                }
                for (String number2 : refMsgMap.keySet()) {
                    if (!notDeleteMap.containsKey(number2)) {
                        notDeleteMap.put(number2, new BgItemException(BgItemException.REFBYBGFORM, new String[]{number2, (String)refMsgMap.get(number2)}).getMessage());
                        continue;
                    }
                    temStr = (String)notDeleteMap.get(number2);
                    notDeleteMap.put(number2, temStr + "\n" + new BgItemException(BgItemException.REFBYBGFORM, new String[]{number2, (String)refMsgMap.get(number2)}).getMessage());
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                refMsgMap.clear();
                sql.delete(0, sql.length());
                sql.append("select distinct c." + refField2 + ", f.fnumber from t_bg_bgItemCombination c ");
                sql.append("join T_BG_BgInnerFillDataEntry d on c.fid = d.FBgItemId ");
                sql.append("join T_BG_BgInnerFillData f on f.fid = d.FBgInnerFillDataID ");
                sql.append("where c." + refField2 + " in (");
                for (i4 = 1; i4 < numberList.size(); ++i4) {
                    sql.append("?,");
                }
                sql.append("?) ");
                if (isBgItemIsolate) {
                    sql.append("and d.fOrgUnitId = ? ");
                }
                sql.append("order by c." + refField2);
                pstmt = conn.prepareStatement(sql.toString());
                for (i4 = 0; i4 < numberList.size(); ++i4) {
                    pstmt.setString(i4 + 1, (String)numberList.get(i4));
                }
                if (isBgItemIsolate) {
                    pstmt.setString(numberList.size() + 1, orgUnitId);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!refMsgMap.containsKey(rst.getString(1))) {
                        refMsgMap.put(rst.getString(1), rst.getString(2));
                        continue;
                    }
                    temStr = (String)refMsgMap.get(rst.getString(1));
                    refMsgMap.put(rst.getString(1), temStr + "," + rst.getString(2));
                }
                for (String number2 : refMsgMap.keySet()) {
                    if (!notDeleteMap.containsKey(number2)) {
                        notDeleteMap.put(number2, new BgItemException(BgItemException.BGINNERFILLDATAREF, new String[]{number2, (String)refMsgMap.get(number2)}).getMessage());
                        continue;
                    }
                    temStr = (String)notDeleteMap.get(number2);
                    notDeleteMap.put(number2, temStr + "\n" + new BgItemException(BgItemException.BGINNERFILLDATAREF, new String[]{number2, (String)refMsgMap.get(number2)}).getMessage());
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                refMsgMap.clear();
                sql.delete(0, sql.length());
                sql.append("select distinct c." + refField2 + ", f.fnumber from t_bg_bgItemCombination c ");
                sql.append("join t_bg_bgElimTemplateEntry d on c.fid = d.FBgItemId ");
                sql.append("join t_bg_bgElimTemplate f on f.fid = d.FElimTemplateId ");
                sql.append("where c." + refField2 + " in (");
                for (i3 = 1; i3 < numberList.size(); ++i3) {
                    sql.append("?,");
                }
                sql.append("?) ");
                if (isBgItemIsolate) {
                    sql.append("and f.fOrgUnitId = ? ");
                }
                sql.append("order by c." + refField2);
                pstmt = conn.prepareStatement(sql.toString());
                for (i3 = 0; i3 < numberList.size(); ++i3) {
                    pstmt.setString(i3 + 1, (String)numberList.get(i3));
                }
                if (isBgItemIsolate) {
                    pstmt.setString(numberList.size() + 1, orgUnitId);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!refMsgMap.containsKey(rst.getString(1))) {
                        refMsgMap.put(rst.getString(1), rst.getString(2));
                        continue;
                    }
                    temStr = (String)refMsgMap.get(rst.getString(1));
                    refMsgMap.put(rst.getString(1), temStr + "," + rst.getString(2));
                }
                for (String number2 : refMsgMap.keySet()) {
                    if (!notDeleteMap.containsKey(number2)) {
                        notDeleteMap.put(number2, new BgItemException(BgItemException.BGELIMTEMPLATEREF, new String[]{number2, (String)refMsgMap.get(number2)}).getMessage());
                        continue;
                    }
                    temStr = (String)notDeleteMap.get(number2);
                    notDeleteMap.put(number2, temStr + "\n" + new BgItemException(BgItemException.BGELIMTEMPLATEREF, new String[]{number2, (String)refMsgMap.get(number2)}).getMessage());
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                refMsgMap.clear();
                sql.delete(0, sql.length());
                sql.append("select distinct c." + refField2 + ", f.fnumber from t_bg_bgItemCombination c ");
                sql.append("join t_bg_bgEliminationEntry d on c.fid = d.FBgItemId ");
                sql.append("join t_bg_bgElimination f on f.fid = d.FBgEliminationID ");
                sql.append("where c." + refField2 + " in (");
                for (i2 = 1; i2 < numberList.size(); ++i2) {
                    sql.append("?,");
                }
                sql.append("?) ");
                if (isBgItemIsolate) {
                    sql.append("and d.fOrgUnitId = ? ");
                }
                sql.append("order by c." + refField2);
                pstmt = conn.prepareStatement(sql.toString());
                for (i2 = 0; i2 < numberList.size(); ++i2) {
                    pstmt.setString(i2 + 1, (String)numberList.get(i2));
                }
                if (isBgItemIsolate) {
                    pstmt.setString(numberList.size() + 1, orgUnitId);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!refMsgMap.containsKey(rst.getString(1))) {
                        refMsgMap.put(rst.getString(1), rst.getString(2));
                        continue;
                    }
                    temStr = (String)refMsgMap.get(rst.getString(1));
                    refMsgMap.put(rst.getString(1), temStr + "," + rst.getString(2));
                }
                for (String number2 : refMsgMap.keySet()) {
                    if (!notDeleteMap.containsKey(number2)) {
                        notDeleteMap.put(number2, new BgItemException(BgItemException.BGELIMITIONREF, new String[]{number2, (String)refMsgMap.get(number2)}).getMessage());
                        continue;
                    }
                    temStr = (String)notDeleteMap.get(number2);
                    notDeleteMap.put(number2, temStr + "\n" + new BgItemException(BgItemException.BGELIMITIONREF, new String[]{number2, (String)refMsgMap.get(number2)}).getMessage());
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                refMsgMap.clear();
                sql.delete(0, sql.length());
                sql.append("select distinct c." + refField2 + ", f.fnumber from t_bg_bgItemCombination c ");
                sql.append("join t_bg_bgworkdata d on c.fid = d.FBgItemId ");
                sql.append("join t_bg_bgworkpaper f on f.fid = d.FBgWorkPaperID ");
                sql.append("where c." + refField2 + " in (");
                for (i = 1; i < numberList.size(); ++i) {
                    sql.append("?,");
                }
                sql.append("?) ");
                sql.append("order by c." + refField2);
                pstmt = conn.prepareStatement(sql.toString());
                for (i = 0; i < numberList.size(); ++i) {
                    pstmt.setString(i + 1, (String)numberList.get(i));
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!refMsgMap.containsKey(rst.getString(1))) {
                        refMsgMap.put(rst.getString(1), rst.getString(2));
                        continue;
                    }
                    temStr = (String)refMsgMap.get(rst.getString(1));
                    refMsgMap.put(rst.getString(1), temStr + "," + rst.getString(2));
                }
                for (String number2 : refMsgMap.keySet()) {
                    if (!notDeleteMap.containsKey(number2)) {
                        notDeleteMap.put(number2, new BgItemException(BgItemException.BGWORKPAPERREF, new String[]{number2, (String)refMsgMap.get(number2)}).getMessage());
                        continue;
                    }
                    temStr = (String)notDeleteMap.get(number2);
                    notDeleteMap.put(number2, temStr + "\n" + new BgItemException(BgItemException.BGWORKPAPERREF, new String[]{number2, (String)refMsgMap.get(number2)}).getMessage());
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                refMsgMap.clear();
            }
            if (isBgItemIsolate) {
                int i;
                sql.delete(0, sql.length());
                sql.append("select distinct fnumber from t_bg_bgItem where forgUnitId <> ? ");
                sql.append("and FAssignParentID in (");
                for (i = 1; i < batchSize; ++i) {
                    sql.append("?,");
                }
                sql.append("?)");
                pstmt = conn.prepareStatement(sql.toString());
                pos = 0;
                for (i = 0; i < count; ++i) {
                    pstmt.setString(1, orgUnitId);
                    for (int j = 1; j <= batchSize; ++j, ++pos) {
                        if (pos < idList.size()) {
                            pstmt.setString(j + 1, (String)idList.get(pos));
                            continue;
                        }
                        pstmt.setString(j + 1, "#");
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        number2 = rst.getString(1);
                        if (!notDeleteMap.containsKey(number2)) {
                            notDeleteMap.put(number2, new BgItemException(BgItemException.ALREADYASSIGNED, new String[]{number2}).getMessage());
                            continue;
                        }
                        temStr = (String)notDeleteMap.get(number2);
                        notDeleteMap.put(number2, temStr + "\n" + new BgItemException(BgItemException.ALREADYASSIGNED, new String[]{number2}).getMessage());
                    }
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
                sql.delete(0, sql.length());
                sql.append("select distinct fnumber from t_bg_bgItem where forgUnitId = ? ");
                sql.append("and FAssignParentID <> FID ");
                sql.append("and FID in (");
                for (i = 1; i < batchSize; ++i) {
                    sql.append("?,");
                }
                sql.append("?)");
                pstmt = conn.prepareStatement(sql.toString());
                pos = 0;
                for (i = 0; i < count; ++i) {
                    pstmt.setString(1, orgUnitId);
                    for (int j = 1; j <= batchSize; ++j, ++pos) {
                        if (pos < idList.size()) {
                            pstmt.setString(j + 1, (String)idList.get(pos));
                            continue;
                        }
                        pstmt.setString(j + 1, "#");
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        number2 = rst.getString(1);
                        if (!notDeleteMap.containsKey(number2)) {
                            notDeleteMap.put(number2, new BgItemException(BgItemException.ISFROMASSIGN, new String[]{number2}).getMessage());
                            continue;
                        }
                        temStr = (String)notDeleteMap.get(number2);
                        notDeleteMap.put(number2, temStr + "\n" + new BgItemException(BgItemException.ISFROMASSIGN, new String[]{number2}).getMessage());
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                refMsgMap.clear();
            }
            sql.delete(0, sql.length());
            sql.append("select fid from t_bg_bgitem where flongnumber like ?  and FLevel = ? ");
            if (isBgItemIsolate) {
                sql.append(" and forgunitid = ?");
            }
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                if (info.isIsLeaf()) continue;
                longNum = info.getLongNumber();
                number2 = info.getNumber();
                level = info.getLevel();
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, longNum + "!%");
                pstmt.setInt(2, level + 1);
                if (isBgItemIsolate) {
                    pstmt.setString(3, orgUnitId);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    id = rst.getString(1);
                    if (idList.contains(id)) continue;
                    refMsgMap.put(number2, null);
                }
            }
            for (String number2 : refMsgMap.keySet()) {
                notDeleteMap.put(number2, new BgItemException(BgItemException.ISNOTLEAF, new String[]{number2}).getMessage());
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                refMap.clear();
                longNumMap.clear();
                idList.clear();
                allNumbers.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        refMap.clear();
        longNumMap.clear();
        idList.clear();
        allNumbers.clear();
        return notDeleteMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement("DELETE FROM T_BG_Bgitem WHERE (FID = ?)");
            ps.setString(1, pk.toString());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    /*
     * Exception decompiling
     */
    public void deleteInfo(Context ctx, BgItemCollection col) throws BOSException, EASBizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateFpFields(ctx, (BgItemInfo)model);
        this.updateFpElims(ctx, (BgItemInfo)model);
        super._update(ctx, pk, model);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkCanUpdateModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean re = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgItemInfo _bgItemInfo = (BgItemInfo)model;
        CostCenterOrgUnitInfo costInfo = ContextUtil.getCurrentCostUnit((Context)ctx);
        String _orgUnitId = BgSHelper.getIsolateOrg(ctx, costInfo.getId().toString());
        String _number = _bgItemInfo.getNumber();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_BG_BgItem where FOrgUnitId = ? and FNumber = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, _orgUnitId);
            pstmt.setString(2, _number);
            rst = pstmt.executeQuery();
            if (!rst.next()) {
                re = true;
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _removeAll(Context ctx, BOSUuid bgItemGroupId, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (bgItemGroupId == null) return;
        if (orgUnitId == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        try {
            conn = this.getConnection(ctx);
            this.checkCanRemoveAll(ctx, conn, bgItemGroupId, orgUnitId);
            String sqlLogDisplay = "select fnumber ,fname_l2 FROM T_BG_Bgitem WHERE FBgItemGroupId = ? AND FOrgUnitId = ? ";
            pstmt = conn.prepareStatement(sqlLogDisplay);
            pstmt.setString(1, bgItemGroupId.toString());
            pstmt.setString(2, BgSHelper.getIsolateOrg(ctx, orgUnitId.toString()));
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String logName = rst.getString("fnumber") + " " + rst.getString("fname_l2");
                IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"_removeAll", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgItem_removeAll");
                LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            sql.append("DELETE FROM T_BG_Bgitem WHERE FBgItemGroupId = ? AND FOrgUnitId = ?");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgItemGroupId.toString());
            pstmt.setString(2, BgSHelper.getIsolateOrg(ctx, orgUnitId.toString()));
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (EASBizException ex2) {
                    throw ex2;
                }
                catch (SQLException ex3) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
                catch (Exception e1) {
                    logger.error((Object)"", (Throwable)e1);
                    throw new BOSException((Throwable)e1);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected void checkCanRemoveAll(Context ctx, Connection conn, BOSUuid bgItemGroupId, BOSUuid orgUnitId) throws BOSException, EASBizException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        boolean isBgItemIsolate = BgSHelper.isBgItemIsolate(ctx);
        String _refField = null;
        try {
            pstmt = conn.prepareStatement("select FRefField from T_BG_BgItemGroup where FID = ?");
            pstmt.setString(1, bgItemGroupId.toString());
            rst = pstmt.executeQuery();
            if (!rst.next()) {
                throw new BgItemException(BgItemException.REMOVEGROUPERROR);
            }
            _refField = rst.getString(1);
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!isBgItemIsolate) {
                pstmt = conn.prepareStatement("Select top 1 fid from t_bg_bgitem where fbgitemgroupid = ? and FAssignRootOrgID <> ?");
                pstmt.setString(1, bgItemGroupId.toString());
                pstmt.setString(2, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString());
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    throw new BgItemException(BgItemException.ISCANTREMOVEBYCREATEORG);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
            if (!StringUtils.isEmpty((String)_refField)) {
                pstmt = conn.prepareStatement("select top 1 fid from t_bg_bgtemplate where fid in ( select fbgtemplateid  from t_bg_bgtemrefbgitemcombin where fbgitemcombinid in (SELECT FID FROM T_BG_BgItemCombination WHERE " + _refField + " is not null) )" + (isBgItemIsolate ? " and forgunitid = ?" : ""));
                if (isBgItemIsolate) {
                    pstmt.setString(1, orgUnitId.toString());
                }
                if ((rst = pstmt.executeQuery()).next()) {
                    throw new BgItemException(BgItemException.ISUSEDFORGROUP);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                pstmt = conn.prepareStatement("select top 1 fid from t_bg_bgform where fid in ( select fbgformid  from t_bg_bgdata where fbgitemcombinid in (SELECT FID FROM T_BG_BgItemCombination WHERE " + _refField + " is not null) )" + (isBgItemIsolate ? " and forgunitid = ?" : ""));
                if (isBgItemIsolate) {
                    pstmt.setString(1, orgUnitId.toString());
                }
                if ((rst = pstmt.executeQuery()).next()) {
                    throw new BgItemException(BgItemException.ISUSEDFORGROUP);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (isBgItemIsolate) {
                    pstmt = conn.prepareStatement("select top 1 fid from t_bg_bgitem where (FAssignParentID IN  (select fid from t_bg_bgitem where FRefField = ? and forgunitid = ?) or FAssignRootID IN  (select fid from t_bg_bgitem where FRefField = ? and forgunitid = ?))  and  forgunitid <> ?");
                    pstmt.setString(1, _refField);
                    pstmt.setString(2, orgUnitId.toString());
                    pstmt.setString(3, _refField);
                    pstmt.setString(4, orgUnitId.toString());
                    pstmt.setString(5, orgUnitId.toString());
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        throw new BgItemException(BgItemException.ISUSEDFORGROUP);
                    }
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    pstmt = conn.prepareStatement("select top 1 fid from t_bg_bgitem where FRefField = ? and forgunitid = ?  and (FAssignParentID is not null and FAssignParentID <> FID) ");
                    pstmt.setString(1, _refField);
                    pstmt.setString(2, orgUnitId.toString());
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        throw new BgItemException(BgItemException.ISUSEDFORGROUP);
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    protected void _removeAll(Context ctx, BOSUuid bgItemGroupID, String orgUnitLongNum) throws BOSException, EASBizException {
        String sql = null;
        this.isUsedForGroup(ctx, bgItemGroupID.toString(), orgUnitLongNum);
        ArrayList<String> _tmpList = new ArrayList<String>();
        if (!"".equals(bgItemGroupID.toString())) {
            sql = " DELETE FROM T_BG_Bgitem WHERE (FBGITEMGROUPID = ? and forgunitId in (select fid from t_org_baseunit where flongnumber = ? or flongnumber like ?))";
            if (BgSHelper.isBgItemNumberRepeat(ctx)) {
                sql = sql + " and FID not in (select distinct FBgItemId from T_BG_BgItemInfo)";
            }
            _tmpList.add(bgItemGroupID.toString());
            _tmpList.add(orgUnitLongNum);
            _tmpList.add(orgUnitLongNum + "!%");
        } else {
            sql = " DELETE FROM T_BG_Bgitem WHERE forgunitId in (select fid from t_org_baseunit where flongnumber = ? or flongnumber like ?)";
            if (BgSHelper.isBgItemNumberRepeat(ctx)) {
                sql = sql + " and FID not in (select distinct FBgItemId from T_BG_BgItemInfo)";
            }
            _tmpList.add(orgUnitLongNum);
            _tmpList.add(orgUnitLongNum + "!%");
        }
        CostCenterOrgUnitInfo costInfo = ContextUtil.getCurrentCostUnit((Context)ctx);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            BgNSQLHelper.setParams((PreparedStatement)stmt, _tmpList);
            stmt.executeUpdate();
            SQLUtils.cleanup((Statement)stmt);
            if (!StringUtils.isEmpty((String)bgItemGroupID.toString())) {
                stmt = conn.prepareStatement("delete from T_BG_BgItemInfo where FOrgUnitId = ? and FBgItemGroupId = ?");
                stmt.setString(1, costInfo.getId().toString());
                stmt.setString(2, bgItemGroupID.toString());
                stmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void isUsedForGroup(Context ctx, String groupID, String orgLongNum) throws BgItemException {
        OrgUnitInfo orgUnitInfo = ContextUtil.getCurrentOrgUnit((Context)ctx);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "";
        int n = 0;
        try {
            if (!StringUtils.isEmpty((String)groupID)) {
                IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bgItemGroup.id", (Object)groupID));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(ctx, orgUnitInfo.getId().toString())));
                viewInfo.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("refField"));
                viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
                BgItemCollection coll = iBgItem.getBgItemCollection(viewInfo);
                if (coll.size() == 0) {
                    throw new BgItemException(BgItemException.NOTHAVEITEM);
                }
                String refField = coll.get(0).getRefField();
                n = coll.size();
                sql = "select fid from T_BG_BgItemCombination where " + refField + " in (";
                for (int i = 0; i < n; ++i) {
                    sql = sql + "'" + coll.get(i).getNumber().toString() + "'";
                    if (i == n - 1) continue;
                    sql = sql + ",";
                }
                sql = sql + ")";
                conn = this.getConnection(ctx);
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    throw new BgItemException(BgItemException.ISUSEDFORGROUP);
                }
            }
        }
        catch (BOSException e) {
            throw new BgItemException(BgItemException.ISUSEDFORGROUP);
        }
        catch (SQLException e) {
            throw new BgItemException(BgItemException.ISUSEDFORGROUP);
        }
        catch (Exception e1) {
            logger.error((Object)"budget error:", (Throwable)e1);
        }
        finally {
            SQLUtils.cleanup(stmt, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean _isCreator(Context ctx, String creatorID, String groupID) throws BOSException, EASBizException {
        PreparedStatement stmt;
        Connection conn;
        boolean isCreator;
        block6: {
            isCreator = false;
            String sql = "select fid from t_bg_bgitem where fbgitemgroupid=? and fcreatorid !=? ";
            conn = null;
            stmt = null;
            ResultSet rs = null;
            try {
                conn = this.getConnection(ctx);
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, groupID);
                stmt.setString(2, creatorID);
                rs = stmt.executeQuery();
                if (!rs.next()) break block6;
                isCreator = true;
            }
            catch (SQLException e) {
                logger.error((Object)"budget error:", (Throwable)e);
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            }
            catch (SQLDataException e2) {
                logger.error((Object)"budget error:", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(stmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return isCreator;
    }

    @Override
    protected String _getMaxNumber(Context ctx, String startStr) throws BOSException, EASBizException {
        String result = null;
        if (startStr == null || startStr.length() == 0) {
            return null;
        }
        String sql = "select top 1 fid,fnumber from t_bg_bgitem where fnumber like '" + startStr + "%' order by fnumber desc";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getString("fnumber");
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    @Override
    protected void _updateErrorData(Context ctx, Vector itemGroupNumberVec) throws BOSException, EASBizException {
        int index = 40;
        for (int i = 0; i < itemGroupNumberVec.size(); ++i) {
            String f = (String)itemGroupNumberVec.get(i);
            String sql = "select fnumber from t_bg_bgitemgroup where freffield = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{f});
            Vector<String> tmp = new Vector<String>();
            try {
                while (rs.next()) {
                    tmp.add(rs.getString(1));
                }
                for (int k = 0; k < tmp.size(); ++k) {
                    String number = (String)tmp.get(k);
                    String f1 = "F" + index;
                    String sql1 = "update t_bg_bgitemcombination set " + f1 + " = " + f + " where  " + f + " in ( select a.fnumber from t_bg_bgitem  a ,t_bg_bgitemgroup b  where a.fbgitemgroupid = b.fid and b.fnumber = '" + number + "')";
                    String sql2 = "update t_bg_bgitemcombination set " + f + " = null  where  " + f + " in ( select a.fnumber from t_bg_bgitem  a ,t_bg_bgitemgroup b  where a.fbgitemgroupid = b.fid and b.fnumber = '" + number + "')";
                    String sql3 = "update t_bg_bgitem set freffield = '" + f1 + "'  where fid in ( select a.fid from t_bg_bgitem  a ,t_bg_bgitemgroup b  where a.fbgitemgroupid = b.fid and b.fnumber = '" + number + "' )";
                    String sql4 = "update t_bg_bgitemgroup set freffield = '" + f1 + "' where  fnumber = '" + number + "'";
                    DbUtil.execute((Context)ctx, (String)sql1);
                    DbUtil.execute((Context)ctx, (String)sql2);
                    DbUtil.execute((Context)ctx, (String)sql3);
                    DbUtil.execute((Context)ctx, (String)sql4);
                    --index;
                }
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
    }

    @Override
    protected void _updateBgItemSuperior(Context ctx, Map bgItemInfo, boolean isInit) throws BOSException, EASBizException {
    }

    protected SelectorItemCollection getBgItemSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        sic.add("specialNumber");
        sic.add("refField");
        sic.add("bgItemGroup.id");
        sic.add("bgItemGroup.refField");
        return sic;
    }

    protected Map getBgItemsInfo(Context ctx, String bgItemNumber, Map bgItemSupInfo) {
        if (bgItemNumber == null || bgItemNumber.trim().length() == 0) {
            return bgItemSupInfo;
        }
        String number2 = null;
        String[] numbers = null;
        numbers = bgItemNumber.split(",");
        if (numbers != null) {
            for (String number2 : numbers) {
                if (bgItemSupInfo.containsKey(number2)) continue;
                bgItemSupInfo.put(number2, null);
            }
        }
        return bgItemSupInfo;
    }

    protected Map getBgItemsSuperiorInfo(Context ctx, Map bgItemsInfo, Map getBgItemSupInfo, String orgUnitId) throws BOSException, EASBizException {
        if (bgItemsInfo == null || bgItemsInfo.isEmpty()) {
            return getBgItemSupInfo;
        }
        BgItemInfo bgItemInfo = null;
        String number2 = null;
        String longnumber = null;
        String[] numbers = null;
        HashMap supNumber = new HashMap();
        for (String number2 : bgItemsInfo.keySet()) {
            bgItemInfo = (BgItemInfo)bgItemsInfo.get(number2);
            longnumber = bgItemInfo.getLongNumber();
            if (longnumber == null) continue;
            numbers = longnumber.split("!");
            int n = numbers.length;
            for (int i = 0; i < n; ++i) {
                supNumber.put(numbers[i], null);
            }
        }
        try {
            if (!supNumber.isEmpty()) {
                getBgItemSupInfo = BgSHelper.getBgItemsInfoBySQL(ctx, supNumber, getBgItemSupInfo, this.getBgItemSelector(), orgUnitId);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return getBgItemSupInfo;
    }

    protected void updateSuperiorInfo(Context ctx, String bgItemNumber, BOSUuid uuid, Map bgItemSupInfo, Connection conn, boolean isSuperior) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        block19: {
            if (bgItemSupInfo == null || bgItemSupInfo.isEmpty()) {
                return;
            }
            Iterator iter = null;
            HashMap keyMap = new HashMap();
            Map<String, Object> tmpMap = null;
            HashMap<String, String> insertMap = new HashMap<String, String>();
            BgItemInfo bgItemInfo = null;
            String number2 = null;
            String keyString2 = null;
            String valueString = null;
            String tmpString = null;
            for (String number2 : bgItemSupInfo.keySet()) {
                bgItemInfo = (BgItemInfo)bgItemSupInfo.get(number2);
                if (keyMap.containsKey(bgItemInfo.getBgItemGroup().getRefField())) {
                    tmpMap = (Map)keyMap.get(bgItemInfo.getBgItemGroup().getRefField());
                } else {
                    tmpMap = new HashMap();
                    keyMap.put(bgItemInfo.getBgItemGroup().getRefField(), tmpMap);
                }
                tmpMap.put(bgItemInfo.getNumber(), null);
            }
            StringBuffer sql = new StringBuffer(2048);
            if (isSuperior) {
                sql.append("select '" + uuid + "', FID from T_BG_BgItemCombination where ");
            } else {
                sql.append("select FID, '" + uuid + "' from T_BG_BgItemCombination where ");
            }
            for (int i = 1; i <= 250; ++i) {
                keyString2 = "F" + i;
                if (keyMap.containsKey(keyString2)) {
                    tmpMap = (Map)keyMap.get(keyString2);
                    sql.append("(" + keyString2 + " in (");
                    iter = tmpMap.keySet().iterator();
                    while (iter.hasNext()) {
                        sql.append("'" + iter.next() + "',");
                    }
                    sql.delete(sql.length() - 1, sql.length());
                    if (isSuperior) {
                        sql.append(") or " + keyString2 + " is null) and ");
                        continue;
                    }
                    sql.append(")) and ");
                    continue;
                }
                if (!isSuperior) continue;
                sql.append("(" + keyString2 + " is null) and ");
            }
            sql.append("(FKey <> '" + bgItemNumber.replaceAll(",", "_") + "')");
            pstmt = null;
            rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    insertMap.put(rst.getString(1), rst.getString(2));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (insertMap.isEmpty()) break block19;
                sql = new StringBuffer();
                sql.append("select FBgItemCombinID, FBgItemSuperiorID from T_BG_BgItemSuperior where ");
                for (String keyString2 : insertMap.keySet()) {
                    valueString = (String)insertMap.get(keyString2);
                    sql.append("(FBgItemCombinID='" + keyString2 + "' and FBgItemSuperiorID='" + valueString + "') or ");
                }
                sql.delete(sql.length() - 4, sql.length());
                pstmt = conn.prepareStatement(sql.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    keyString2 = rst.getString(1);
                    valueString = rst.getString(2);
                    if (!insertMap.containsKey(keyString2) || !(tmpString = (String)insertMap.get(keyString2)).equals(valueString)) continue;
                    insertMap.remove(keyString2);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (!insertMap.isEmpty()) {
                    pstmt = conn.prepareStatement("Insert Into T_BG_BgItemSuperior (FBgItemCombinID, FBgItemSuperiorID) values (?, ?)");
                    for (String keyString2 : insertMap.keySet()) {
                        valueString = (String)insertMap.get(keyString2);
                        pstmt.setString(1, keyString2);
                        pstmt.setString(2, valueString);
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    private Set getSuperiorInfo(Context ctx, String bgItemNumber, Map bgItemSupInfo, Connection conn) throws BOSException, EASBizException {
        if (bgItemSupInfo == null || bgItemSupInfo.isEmpty()) {
            return new HashSet();
        }
        Iterator iter = null;
        HashMap keyMap = new HashMap();
        Map<String, Object> tmpMap = null;
        HashSet<String> keySet = new HashSet<String>();
        BgItemInfo bgItemInfo = null;
        String number2 = null;
        String keyString = null;
        for (String number2 : bgItemSupInfo.keySet()) {
            bgItemInfo = (BgItemInfo)bgItemSupInfo.get(number2);
            if (keyMap.containsKey(bgItemInfo.getBgItemGroup().getRefField())) {
                tmpMap = (Map)keyMap.get(bgItemInfo.getBgItemGroup().getRefField());
            } else {
                tmpMap = new HashMap();
                keyMap.put(bgItemInfo.getBgItemGroup().getRefField(), tmpMap);
            }
            tmpMap.put(bgItemInfo.getNumber(), null);
        }
        StringBuffer sql = new StringBuffer(2048);
        sql.append("select FKey from T_BG_BgItemCombination where ");
        for (int i = 1; i <= 250; ++i) {
            keyString = "F" + i;
            if (keyMap.containsKey(keyString)) {
                tmpMap = (Map)keyMap.get(keyString);
                sql.append("(" + keyString + " in (");
                iter = tmpMap.keySet().iterator();
                while (iter.hasNext()) {
                    sql.append("'" + iter.next() + "',");
                }
                sql.delete(sql.length() - 1, sql.length());
                sql.append(") or " + keyString + " is null) and ");
                continue;
            }
            sql.append("(" + keyString + " is null) and ");
        }
        sql.append("(FKey <> '" + bgItemNumber.replaceAll(",", "_") + "')");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                keySet.add(rst.getString(1).replaceAll("_", ","));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return keySet;
    }

    protected Map getBgItemsSubInfo(Context ctx, Map bgItemsInfo, Map getBgItemSubInfo, Connection conn) throws BOSException, EASBizException {
        if (bgItemsInfo == null || bgItemsInfo.isEmpty()) {
            return getBgItemSubInfo;
        }
        Iterator iter = null;
        BgItemInfo bgItemInfo = null;
        String number2 = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName_" + ctx.getLocale() + ", FNumber, FLongNumber, FBgItemGroupId, FRefField from T_BG_BgItem where ");
        for (String number2 : bgItemsInfo.keySet()) {
            bgItemInfo = (BgItemInfo)bgItemsInfo.get(number2);
            sql.append("(FLongNumber like '" + bgItemInfo.getLongNumber() + "!%') or ");
        }
        sql.delete(sql.length() - 4, sql.length());
        try {
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgItemInfo = new BgItemInfo();
                bgItemInfo.setId(BOSUuid.read((String)rst.getString(1)));
                bgItemInfo.setName(rst.getString(2), ctx.getLocale());
                bgItemInfo.setNumber(rst.getString(3));
                bgItemInfo.setLongNumber(rst.getString(4));
                bgItemInfo.setBgItemGroup(new BgItemGroupInfo());
                bgItemInfo.getBgItemGroup().setId(BOSUuid.read((String)rst.getString(5)));
                bgItemInfo.getBgItemGroup().setRefField(rst.getString(6));
                bgItemInfo.setRefField(rst.getString(6));
                getBgItemSubInfo.put(bgItemInfo.getNumber(), bgItemInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return getBgItemSubInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _removeBgItemSuperior(Context ctx, Map bgItemInfo) throws BOSException, EASBizException {
        if (bgItemInfo == null) return;
        if (bgItemInfo.isEmpty()) {
            return;
        }
        String bgItemNumber2222222 = null;
        String uuidString = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_BG_BgItemSuperior where (FBgItemCombinID = ?) or (FBgItemSuperiorID = ?)");
            for (String bgItemNumber2222222 : bgItemInfo.keySet()) {
                uuidString = (String)bgItemInfo.get(bgItemNumber2222222);
                pstmt.setString(1, uuidString);
                pstmt.setString(2, uuidString);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _removeBgItemSuperior(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_BG_BgItemSuperior where (FBgItemCombinID not in (select FBgItemCombinId from T_BG_BgTemRefBgItemCombin)) and (FBgItemCombinID not in (select FBgItemCombinId from T_BG_BgRefBgItemCombin))");
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected BgCtrlResultCollection _getSuperiorItemCtrlData(Context ctx, BgCtrlResultCollection bgCtrlResultCol) throws BOSException, EASBizException {
        if (BudgetCtrlUtil.isEmpty((Object)bgCtrlResultCol)) {
            return bgCtrlResultCol;
        }
        Connection conn = null;
        Map bgItemMap = new HashMap();
        Map bgItemSupMap = null;
        StringBuffer formulsStr = null;
        ArrayList<String> formulaList = new ArrayList<String>();
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            for (int i = 0; i < bgCtrlResultCol.size(); ++i) {
                String[] parameter;
                BgCtrlResultInfo ctrlResultInfo = bgCtrlResultCol.get(i);
                String bgDataId = ctrlResultInfo.getBgDataId();
                String orgUnitId = ctrlResultInfo.getOrgUnitId();
                String bgSchemeId = ctrlResultInfo.getBgSchemeId();
                String formula = ctrlResultInfo.getBgItemFormula();
                if (BudgetCtrlUtil.isEmpty(bgDataId) || BudgetCtrlUtil.isEmpty(orgUnitId) || BudgetCtrlUtil.isEmpty(bgSchemeId) || BudgetCtrlUtil.isEmpty(formula)) continue;
                if (bgItemMap != null) {
                    bgItemMap.clear();
                }
                if (bgItemSupMap != null) {
                    bgItemSupMap.clear();
                }
                if (formulaList != null) {
                    formulaList.clear();
                }
                if ((parameter = BgSHelper.getFormulaInfo(null, formula)) == null || parameter[0] == null) continue;
                bgItemMap.put(parameter[0], null);
                bgItemMap = BgSHelper.getBgItemsInfoBySQL(ctx, bgItemMap, null, null, ctrlResultInfo.getOrgUnitId());
                bgItemSupMap = this.getBgItemsSuperiorInfo(ctx, bgItemMap, null, orgUnitId);
                Set fKey = BudgetCtrlCacheHelper.getSuperiorBgItemCombinationKeys(ctx, parameter[0], bgItemSupMap);
                Iterator iter = fKey.iterator();
                while (iter.hasNext()) {
                    formulsStr = new StringBuffer("=BgItem(\"" + iter.next().toString() + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\"," + parameter[4] + ",\"" + parameter[5] + "\")");
                    if (formulsStr.toString().equals(formula)) continue;
                    formulaList.add(formulsStr.toString());
                }
                if (formulaList == null || formulaList.isEmpty()) continue;
                HashSet states = new HashSet();
                for (int x = 0; x < formulaList.size(); ++x) {
                    states.add(formulaList.get(x));
                }
                StringBuffer SQL = new StringBuffer();
                SQL.append(" select FId,");
                SQL.append("        FFormula");
                SQL.append("   from T_BG_BgData");
                SQL.append("  where FOrgUnitId = '" + orgUnitId + "'");
                SQL.append("    and FBgSchemeId = '" + bgSchemeId + "'");
                SQL.append("    and FFormula in " + BgHelper.tranSet2String(states));
                rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString());
                BgCtrlResultCollection superCtrlResultCol = new BgCtrlResultCollection();
                while (rst.next()) {
                    String superBgDataId = rst.getString("FId");
                    String superFormula = rst.getString("FFormula");
                    BgCtrlResultInfo superCtrlResultInfo = (BgCtrlResultInfo)ctrlResultInfo.clone();
                    superCtrlResultInfo.setBgDataId(superBgDataId);
                    superCtrlResultInfo.setBgItemFormula(superFormula);
                    String fkey = BgNFSHelper.parseFormulaPara(null, (String)superFormula)[0];
                    superCtrlResultInfo.setItemCombinNumber(fkey);
                    superCtrlResultInfo.setItemCombinName(BudgetCtrlCacheHelper.getBgItemCombinationName(ctx, fkey, orgUnitId));
                    superCtrlResultCol.add(superCtrlResultInfo);
                }
                ctrlResultInfo.put("superiorItemCtrlResultCol", (Object)superCtrlResultCol);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            formulaList.clear();
            SQLUtils.cleanup(rst);
            SQLUtils.cleanup((Connection)conn);
        }
        return bgCtrlResultCol;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateBgItemSuperiorValue(Context ctx, BOSUuid orgUnitID, BOSUuid bgSchemeID, String formula, BigDecimal value) throws BOSException, EASBizException {
        if (orgUnitID == null) return;
        if (bgSchemeID == null) return;
        if (formula == null) return;
        if (value == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        Map<String, Object> bgItemMap = new HashMap<String, Object>();
        Map bgItemSupMap = null;
        Set fKey = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer formulsStr = null;
        sql.append("update T_BG_BgData set FBizActual = FBizActual + ?  where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ? and FDataState = 9");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            String[] parameter = BgSHelper.getFormulaInfo(null, formula);
            if (parameter != null && parameter[0] != null) {
                bgItemMap.put(parameter[0], null);
                bgItemMap = BgSHelper.getBgItemsInfo(ctx, bgItemMap, null, null, orgUnitID.toString());
                bgItemSupMap = this.getBgItemsSuperiorInfo(ctx, bgItemMap, null, orgUnitID.toString());
                fKey = this.getSuperiorInfo(ctx, parameter[0], bgItemSupMap, conn);
                Iterator iter = fKey.iterator();
                while (iter.hasNext()) {
                    formulsStr = new StringBuffer("=BgItem(\"" + iter.next().toString() + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\"," + parameter[4] + ",\"" + parameter[5] + "\")");
                    if (formulsStr.toString().equals(formula)) continue;
                    pstmt.setBigDecimal(1, value);
                    pstmt.setString(2, orgUnitID.toString());
                    pstmt.setString(3, bgSchemeID.toString());
                    pstmt.setString(4, formulsStr.toString());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateBgItemSuperiorValue(Context ctx, BOSUuid orgUnitID, BOSUuid bgSchemeID, List formula, List value) throws BOSException, EASBizException {
        if (orgUnitID == null) return;
        if (bgSchemeID == null) return;
        if (formula == null) return;
        if (value == null) {
            return;
        }
        if (formula.isEmpty()) return;
        if (value.isEmpty()) return;
        if (formula.size() != value.size()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstexe = null;
        ResultSet rst = null;
        String bgItemCombinId = null;
        String bgElementId = null;
        String bgPeriodId = null;
        String currencyId = null;
        String formulaString = null;
        String valueString = null;
        BigDecimal bigValue = null;
        boolean isUpdate = false;
        StringBuffer sql = new StringBuffer();
        StringBuffer update = new StringBuffer();
        sql.append("select FID, FBgItemCombinId, FBgElementId, FBgPeriodId, FCurrencyId from T_BG_BgData where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ?");
        update.append("update T_BG_BgData set FBizActual = FBizActual + ? where FOrgUnitId = ? and FBgSchemeId = ? and FBgElementId = ? and FBgPeriodId = ? and FCurrencyId = ? and FBgItemCombinId in (select FBgItemSuperiorId from T_BG_BgItemSuperior where FBgItemCombinId = ?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstexe = conn.prepareStatement(update.toString());
            int count = formula.size();
            for (int index = 0; index < count; ++index) {
                formulaString = (String)formula.get(index);
                valueString = (String)value.get(index);
                pstmt.setString(1, orgUnitID.toString());
                pstmt.setString(2, bgSchemeID.toString());
                pstmt.setString(3, formulaString);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    bgItemCombinId = rst.getString("FBgItemCombinId");
                    bgElementId = rst.getString("FBgElementId");
                    bgPeriodId = rst.getString("FBgPeriodId");
                    currencyId = rst.getString("FCurrencyId");
                    isUpdate = true;
                }
                SQLUtils.cleanup((ResultSet)rst);
                if (!isUpdate) continue;
                try {
                    bigValue = new BigDecimal(valueString);
                }
                catch (Exception ex) {
                    bigValue = BgConstants.BIGZERO;
                }
                pstexe.setBigDecimal(1, bigValue);
                pstexe.setString(2, orgUnitID.toString());
                pstexe.setString(3, bgSchemeID.toString());
                pstexe.setString(4, bgElementId);
                pstexe.setString(5, bgPeriodId);
                pstexe.setString(6, currencyId);
                pstexe.setString(7, bgItemCombinId);
                pstexe.executeUpdate();
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstexe);
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstexe);
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _bgItemSupriorMaintenance(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String bgItemCombinNumber = null;
        String bgItemCombinId = null;
        HashMap<String, String> bgItemMap = new HashMap<String, String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID, FKey from T_BG_BgItemCombination");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgItemCombinId = rst.getString("FID");
                bgItemCombinNumber = rst.getString("FKey").replaceAll("_", ",");
                bgItemMap.put(bgItemCombinNumber, bgItemCombinId);
            }
            if (!bgItemMap.isEmpty()) {
                this._updateBgItemSuperior(ctx, bgItemMap, true);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return true;
    }

    @Override
    protected boolean _importBgItemCollection(Context ctx, BOSUuid bgItemGroupId, IObjectCollection bgItemCollection) throws BOSException, EASBizException {
        if (bgItemGroupId == null || bgItemCollection == null || bgItemCollection.isEmpty()) {
            throw new BgItemException(BgItemException.CANTISNULLBYGROUP);
        }
        if (this._checkBgItemCollection(ctx, bgItemGroupId, bgItemCollection)) {
            // empty if block
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _checkBgItemCollection(Context ctx, BOSUuid bgItemGroupId, IObjectCollection bgItemCollection) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 50;
        int size = bgItemCollection.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer();
        sql.append("select FNumber from T_BG_BgItem where FNumber in (");
        for (int i = 1; i < batchNum; ++i) {
            sql.append("?, ");
        }
        sql.append("?)");
        BgItemInfo bgItemInfo = null;
        BgItemCollection bgItemCol = (BgItemCollection)bgItemCollection;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int k = 1; k <= batchNum; ++k, ++pos) {
                    if (pos < size) {
                        bgItemInfo = bgItemCol.get(pos);
                        pstmt.setString(k, bgItemInfo.getNumber());
                        continue;
                    }
                    pstmt.setString(k, noFindStr);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _setItemInefficacy(Context ctx, String longNum) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = null;
        try {
            conn = this.getConnection(ctx);
            sql = new StringBuffer();
            sql.append("update T_BG_BgItem set FIsEffective = 0 where flongNumber =  ? or flongNumber like ?");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, longNum);
            pstmt.setString(2, longNum + "!%");
            pstmt.executeUpdate();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _setItemEfficacy(Context ctx, String id) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = null;
        try {
            conn = this.getConnection(ctx);
            sql = new StringBuffer();
            sql.append("update T_BG_BgItem set FIsEffective = 1 where fid = ?");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, id);
            pstmt.executeUpdate();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected boolean _isJunior(Context ctx, int orgUnitID, String itemGroupID) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected void _modifyBgItemOrg(Context ctx, Hashtable itemIdMap, Hashtable itemLongNumberMap, Hashtable itemTargetOrgMap, Hashtable itemNameMap, Hashtable itemNumberMap) throws BOSException, EASBizException {
        String itemNumber;
        String itemName;
        String targetOrgLongNumber;
        String targetItemLongNumber;
        int i;
        Vector vec;
        for (String longNumber : itemLongNumberMap.keySet()) {
            vec = (Vector)itemLongNumberMap.get(longNumber);
            for (i = vec.size() - 1; i >= 0; --i) {
                targetItemLongNumber = (String)vec.get(i);
                targetOrgLongNumber = (String)itemTargetOrgMap.get(targetItemLongNumber);
                itemName = (String)itemNameMap.get(targetItemLongNumber);
                itemNumber = (String)itemNumberMap.get(targetItemLongNumber);
                this.checkBeforeModify(ctx, targetItemLongNumber, targetOrgLongNumber, itemName, itemNumber);
            }
        }
        this.modify(ctx, itemIdMap);
        for (String longNumber : itemLongNumberMap.keySet()) {
            vec = (Vector)itemLongNumberMap.get(longNumber);
            for (i = vec.size() - 1; i >= 0; --i) {
                targetItemLongNumber = (String)vec.get(i);
                targetOrgLongNumber = (String)itemTargetOrgMap.get(targetItemLongNumber);
                itemName = (String)itemNameMap.get(targetItemLongNumber);
                itemNumber = (String)itemNumberMap.get(targetItemLongNumber);
                this.checkAfterModify(ctx, targetItemLongNumber, targetOrgLongNumber, itemName, itemNumber);
            }
        }
    }

    private void modify(Context ctx, Hashtable itemIdMap) throws SQLDataException, BgException {
        String sql = "update T_BG_BgItem set FOrgUnitId = ? where FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String id : itemIdMap.keySet()) {
                String orgId = (String)itemIdMap.get(id);
                pstmt.setString(1, orgId);
                pstmt.setString(2, id);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.debug((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void checkAfterModify(Context ctx, String itemLongNumber, String orgLongNumber, String itemName, String itemNumber) throws BOSException, EASBizException {
        String sql = " select a.flongnumber  from t_org_baseunit a ,t_bg_bgitem b  where a.fid = b.forgunitid and b.flongnumber like '" + itemLongNumber + "!%' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String tmpLongNumber = rs.getString(1);
                if (tmpLongNumber.equals(orgLongNumber) || tmpLongNumber.startsWith(orgLongNumber + "!")) continue;
                throw new BgItemException(BgItemException.ORGERROR, new Object[]{itemName, itemNumber});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (itemLongNumber != null && itemLongNumber.indexOf("!") == -1) {
            return;
        }
        String parentItemLongNumber = null;
        parentItemLongNumber = itemLongNumber.substring(0, itemLongNumber.lastIndexOf("!"));
        String SQL = " select a.flongnumber  from t_org_baseunit a ,t_bg_bgitem b  where a.fid = b.forgunitid and b.flongnumber = '" + parentItemLongNumber + "'";
        IRowSet ret = DbUtil.executeQuery((Context)ctx, (String)SQL);
        try {
            String parentItemOrgLongNumber;
            if (ret.next() && !(parentItemOrgLongNumber = ret.getString(1)).equals(orgLongNumber) && !orgLongNumber.startsWith(parentItemOrgLongNumber + "!")) {
                throw new BgItemException(BgItemException.ORGERROR2, new Object[]{itemName, itemNumber});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    private void checkBeforeModify(Context ctx, String itemLongNumber, String orgLongNumber, String itemName, String itemNumber) throws BOSException, EASBizException {
        String sql0 = " select freffield from T_BG_BgItem where fnumber = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql0, (Object[])new String[]{itemNumber});
        try {
            String refField = "";
            if (rs.next()) {
                refField = rs.getString(1);
            }
            if (!"".equals(refField)) {
                String longNumber;
                Hashtable<String, String> tmpOrgNumberMap = new Hashtable<String, String>();
                String sql1 = " select a.flongnumber  from T_ORG_BaseUnit a ,t_bg_bgtemplate b ,t_bg_bgtemrefbgitemcombin c ,t_bg_bgitemcombination d  where a.fid = b.forgunitid and b.fid = c.fbgtemplateid and c.fbgitemcombinid = d.fid and d." + refField + " = ?";
                String sql2 = " select a.flongnumber  from t_org_baseunit a ,t_bg_bgform b ,t_bg_bgrefbgitemcombin c ,t_bg_bgitemcombination d  where a.fid = b.forgunitid and b.fid = c.fbgformid and c.fbgitemcombinid = d.fid and d." + refField + " = ?";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{itemNumber});
                while (rs.next()) {
                    longNumber = rs.getString(1);
                    tmpOrgNumberMap.put(longNumber, longNumber);
                }
                SQLUtils.cleanup((ResultSet)rs);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new String[]{itemNumber});
                while (rs.next()) {
                    longNumber = rs.getString(1);
                    tmpOrgNumberMap.put(longNumber, longNumber);
                }
                for (String tmpLongNumber : tmpOrgNumberMap.keySet()) {
                    if (!(tmpLongNumber.length() >= orgLongNumber.length() ? !tmpLongNumber.equals(orgLongNumber) && !tmpLongNumber.startsWith(orgLongNumber + "!") : !orgLongNumber.equals(tmpLongNumber) && !orgLongNumber.startsWith(tmpLongNumber + "!"))) continue;
                    throw new BgItemException(BgItemException.ORGRANGEREDUCEERROR, new Object[]{itemName, itemNumber});
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _updateName(Context ctx, IObjectValue info) throws BOSException {
        PreparedStatement pstmt = null;
        Connection connection = null;
        String sql = null;
        BgItemInfo bgItemInfo = (BgItemInfo)info;
        if (bgItemInfo != null) {
            sql = "update  T_Bg_BgItem set fname_l2 = ? where fnumber = ?";
        }
        try {
            connection = this.getConnection(ctx);
            pstmt = connection.prepareStatement(sql);
            pstmt.setString(1, bgItemInfo.getName());
            pstmt.setString(2, bgItemInfo.getNumber());
            pstmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            boolean bl;
            try {
                logger.error((Object)"budget error:", (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)connection);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)connection);
        return true;
    }

    @Override
    protected void _updateBgItemSuperiorCtrlRecord(Context ctx, BOSUuid orgUnitID, BOSUuid bgSchemeID, String formula, IObjectValue record, BudgetRequestCategory category) throws BOSException, EASBizException {
        if (orgUnitID == null || bgSchemeID == null || formula == null) {
            return;
        }
        Connection conn = null;
        Map<String, Object> bgItemMap = new HashMap<String, Object>();
        Map bgItemSupMap = null;
        Set fKey = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer formulsStr = null;
        sql.append("select fid from T_BG_BgData  where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ? and FDataState = 9");
        BgCtrlRecordCollection ctrlRecordCol = new BgCtrlRecordCollection();
        try {
            conn = this.getConnection(ctx);
            String[] parameter = BgSHelper.getFormulaInfo(null, formula);
            if (parameter != null && parameter[0] != null) {
                bgItemMap.put(parameter[0], null);
                bgItemMap = BgSHelper.getBgItemsInfo(ctx, bgItemMap, null, null, orgUnitID.toString());
                bgItemSupMap = this.getBgItemsSuperiorInfo(ctx, bgItemMap, null, orgUnitID.toString());
                fKey = this.getSuperiorInfo(ctx, parameter[0], bgItemSupMap, conn);
                Iterator iter = fKey.iterator();
                while (iter.hasNext()) {
                    String bgDataId;
                    String tmp = iter.next().toString();
                    formulsStr = new StringBuffer("=BgItem(\"" + tmp + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\"," + parameter[4] + ",\"" + parameter[5] + "\")");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{orgUnitID.toString(), bgSchemeID.toString(), formulsStr.toString()});
                    if (!rs.next() || (bgDataId = rs.getString(1)) == null) continue;
                    BgCtrlResultInfo ctrlRecord = (BgCtrlResultInfo)((BgCtrlResultInfo)record).clone();
                    String superItemName = this.getItemCombinName(ctx, tmp.replaceAll(",", "_"), orgUnitID.toString());
                    BgCtrlRecordInfo bgCtrlRecordInfo = new BgCtrlRecordInfo();
                    bgCtrlRecordInfo.setBgDataId(bgDataId);
                    bgCtrlRecordInfo.setActualAmount(ctrlRecord.getReqAmount());
                    bgCtrlRecordInfo.setBillId(ctrlRecord.getBillId());
                    bgCtrlRecordInfo.setBillName(ctrlRecord.getBillNumber());
                    bgCtrlRecordInfo.setBillNumber(ctrlRecord.getBillNumber());
                    bgCtrlRecordInfo.setBillType(BudgetCtrlHelper.getTypeAllias(ctrlRecord.getBillType(), BgTraceTypeEnum.lowerOrgItemCollect));
                    bgCtrlRecordInfo.setBillAlias(ctrlRecord.getBillType());
                    bgCtrlRecordInfo.setBizDate(ctrlRecord.getBizDate());
                    bgCtrlRecordInfo.setBgPeriodId(ctrlRecord.getBgPeriodNumber());
                    bgCtrlRecordInfo.setItemName(superItemName);
                    bgCtrlRecordInfo.setBgTraceType(BgTraceTypeEnum.lowerOrgItemCollect);
                    bgCtrlRecordInfo.setDayDate(ctrlRecord.getBizDate());
                    bgCtrlRecordInfo.setIsCollected(true);
                    if (BudgetRequestCategory.CATEGORY_OCCUPATION == category) {
                        bgCtrlRecordInfo.setActualType(ActualTypeEnum.occupation);
                    } else if (ctrlRecord.getActualType() != null) {
                        bgCtrlRecordInfo.setActualType(ctrlRecord.getActualType());
                    } else {
                        bgCtrlRecordInfo.setActualType(ActualTypeEnum.execution);
                    }
                    bgCtrlRecordInfo.setBillSourceOrgunitID(ctrlRecord.getBillSourceOrgunitID());
                    ctrlRecordCol.add(bgCtrlRecordInfo);
                }
                BudgetCtrlHelper.insertCtrlRecord(ctx, ctrlRecordCol);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _sumBgItemSuperiorCtrlRecord(Context ctx, BOSUuid orgUnitID, BOSUuid bgSchemeID, String formula, IObjectValue resultInfo) throws BOSException, EASBizException {
        PreparedStatement insertDetailRecordSta;
        PreparedStatement insertSumRecordSta;
        PreparedStatement updateSumRecordSta;
        Connection conn;
        block14: {
            if (orgUnitID == null) return;
            if (bgSchemeID == null) return;
            if (formula == null) return;
            if (resultInfo == null) {
                return;
            }
            conn = null;
            PreparedStatement queryBgDataSta = null;
            String queryBgDataSQL = "select fid from T_BG_BgData where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ? ";
            PreparedStatement querySumRecordSta = null;
            String querySumRecordSQL = " select fid from t_bg_bgctrlrecord where forgunitid = ? and fbgschemeid = ? and fitemformula = ? ";
            updateSumRecordSta = null;
            String updateSumRecordSQL = "update t_bg_bgctrlrecord set factualAmount = factualAmount + ?  where forgunitid = ? and fbgschemeid = ? and fitemformula = ? ";
            insertSumRecordSta = null;
            String insertSumRecordSQL = "insert into  T_BG_BGCTRLRECORD (FID, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, \tFLASTUPDATETIME, FCONTROLUNITID, FBGDATAID, FBILLID, \tFBILLNAME, FBILLNUMBER, FBILLALIAS, FBILLTYPE, \tFBIZDATE, FACTUALAMOUNT, FBILLOPERATE, FBGPERIODID, FITEMNAME, FBgTraceType, FOrgUnitID, FBgSchemeID, fitemFormula)    values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            insertDetailRecordSta = null;
            String insertDetailRecordSQL = "INSERT INTO T_BG_BgCtrlRecordSumDetail (FID, FBillId, FBgCtrlRecordId, FActualAmount) VALUES (?, ?, ?, ?)";
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Timestamp time = new Timestamp(System.currentTimeMillis());
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            Set itemCmbNumberMap = null;
            StringBuffer _formula = null;
            try {
                conn = this.getConnection(ctx);
                queryBgDataSta = conn.prepareStatement(queryBgDataSQL);
                querySumRecordSta = conn.prepareStatement(querySumRecordSQL);
                updateSumRecordSta = conn.prepareStatement(updateSumRecordSQL);
                insertSumRecordSta = conn.prepareStatement(insertSumRecordSQL);
                insertDetailRecordSta = conn.prepareStatement(insertDetailRecordSQL);
                Map<String, Object> bgItemMap = new HashMap<String, Object>();
                Map bgItemSupMap = null;
                String[] parameter = BgSHelper.getFormulaInfo(null, formula);
                if (parameter == null || parameter[0] == null) break block14;
                bgItemMap.put(parameter[0], null);
                bgItemMap = BgSHelper.getBgItemsInfo(ctx, bgItemMap, null, null, orgUnitID.toString());
                bgItemSupMap = this.getBgItemsSuperiorInfo(ctx, bgItemMap, null, orgUnitID.toString());
                itemCmbNumberMap = this.getSuperiorInfo(ctx, parameter[0], bgItemSupMap, conn);
                boolean isSubmitUpdate = false;
                boolean isSubmitInsert = false;
                Iterator iter = itemCmbNumberMap.iterator();
                while (iter.hasNext()) {
                    String bgDataId;
                    String itemCmbNumber = iter.next().toString();
                    _formula = new StringBuffer("=BgItem(\"" + itemCmbNumber + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\"," + parameter[4] + ",\"" + parameter[5] + "\")");
                    queryBgDataSta.setString(1, orgUnitID.toString());
                    queryBgDataSta.setString(2, bgSchemeID.toString());
                    queryBgDataSta.setString(3, _formula.toString());
                    ResultSet bgDataRet = queryBgDataSta.executeQuery();
                    if (!bgDataRet.next() || (bgDataId = bgDataRet.getString("fid")) == null) continue;
                    BgCtrlResultInfo _resultInfo = (BgCtrlResultInfo)((BgCtrlResultInfo)resultInfo).clone();
                    String superItemName = this.getItemCombinName(ctx, itemCmbNumber.replaceAll(",", "_"), orgUnitID.toString());
                    _resultInfo.setBgDataId(bgDataId);
                    _resultInfo.setItemCombinName(superItemName);
                    querySumRecordSta.setString(1, orgUnitID.toString());
                    querySumRecordSta.setString(2, bgSchemeID.toString());
                    querySumRecordSta.setString(3, _formula.toString());
                    ResultSet sumRecordRet = querySumRecordSta.executeQuery();
                    String bgCtrlRecordId = null;
                    if (sumRecordRet.next()) {
                        bgCtrlRecordId = sumRecordRet.getString("fid");
                        updateSumRecordSta.setBigDecimal(1, _resultInfo.getReqAmount());
                        updateSumRecordSta.setString(2, orgUnitID.toString());
                        updateSumRecordSta.setString(3, bgSchemeID.toString());
                        updateSumRecordSta.setString(4, _formula.toString());
                        updateSumRecordSta.addBatch();
                        if (!isSubmitUpdate) {
                            isSubmitUpdate = true;
                        }
                    } else {
                        bgCtrlRecordId = BOSUuid.create((String)"FF6153C2").toString();
                        insertSumRecordSta.setString(1, bgCtrlRecordId);
                        insertSumRecordSta.setString(2, userId);
                        insertSumRecordSta.setTimestamp(3, time);
                        insertSumRecordSta.setString(4, userId);
                        insertSumRecordSta.setTimestamp(5, time);
                        insertSumRecordSta.setString(6, cuId);
                        insertSumRecordSta.setString(7, bgDataId);
                        insertSumRecordSta.setString(8, _resultInfo.getBillId());
                        insertSumRecordSta.setString(9, null);
                        insertSumRecordSta.setString(10, null);
                        insertSumRecordSta.setString(11, null);
                        insertSumRecordSta.setString(12, "\u4e0b\u7ea7\u7ec4\u7ec7\u9879\u76ee\u6c47\u603b");
                        insertSumRecordSta.setTimestamp(13, time);
                        insertSumRecordSta.setBigDecimal(14, _resultInfo.getReqAmount());
                        insertSumRecordSta.setString(15, null);
                        insertSumRecordSta.setString(16, _resultInfo.getBgPeriodNumber());
                        insertSumRecordSta.setString(17, _resultInfo.getItemCombinName());
                        insertSumRecordSta.setInt(18, 4);
                        insertSumRecordSta.setString(19, orgUnitID.toString());
                        insertSumRecordSta.setString(20, bgSchemeID.toString());
                        insertSumRecordSta.setString(21, _formula.toString());
                        insertSumRecordSta.addBatch();
                        if (!isSubmitInsert) {
                            isSubmitInsert = true;
                        }
                    }
                    String bgCtrlRecordDetailId = BOSUuid.create((String)"390384DA").toString();
                    insertDetailRecordSta.setString(1, bgCtrlRecordDetailId);
                    insertDetailRecordSta.setString(2, _resultInfo.getBillId());
                    insertDetailRecordSta.setString(3, bgCtrlRecordId);
                    insertDetailRecordSta.setBigDecimal(4, _resultInfo.getReqAmount());
                    insertDetailRecordSta.addBatch();
                }
                if (isSubmitUpdate) {
                    updateSumRecordSta.executeBatch();
                }
                if (isSubmitInsert) {
                    insertSumRecordSta.executeBatch();
                }
                if (isSubmitUpdate || isSubmitInsert) {
                    insertDetailRecordSta.executeBatch();
                }
            }
            catch (BOSException ex) {
                try {
                    throw ex;
                    catch (SQLException ex2) {
                        throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(updateSumRecordSta, (Connection)conn);
                    SQLUtils.cleanup(insertSumRecordSta, (Connection)conn);
                    SQLUtils.cleanup(insertDetailRecordSta, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)updateSumRecordSta, (Connection)conn);
        SQLUtils.cleanup((Statement)insertSumRecordSta, (Connection)conn);
        SQLUtils.cleanup((Statement)insertDetailRecordSta, (Connection)conn);
    }

    private String getItemCombinName(Context ctx, String itemKey, String orgUnitId) throws BOSException {
        String sql = " select fname_" + ctx.getLocale() + " from t_bg_bgitem where fnumber = ? and forgUnitId = ? ";
        orgUnitId = BgSHelper.getIsolateOrg(ctx, orgUnitId);
        String[] strs = itemKey.split("_");
        String nameStr = "";
        try {
            for (int i = 0; i < strs.length; ++i) {
                String name = "";
                String number = strs[i];
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{number, orgUnitId});
                if (rs.next()) {
                    name = rs.getString(1);
                }
                SQLUtils.cleanup((ResultSet)rs);
                nameStr = nameStr + name + "_";
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        nameStr = nameStr.substring(0, nameStr.length() - 1);
        return nameStr;
    }

    @Override
    protected void _batchSetItemInefficacy(Context ctx, List bgItems) throws BOSException, EASBizException {
        if (bgItems == null || bgItems.isEmpty()) {
            return;
        }
        CostCenterOrgUnitInfo costInfo = ContextUtil.getCurrentCostUnit((Context)ctx);
        Object _tmpMap = null;
        List updateList = this.getAllChild(ctx, costInfo, bgItems);
        updateList.addAll(bgItems);
        String sql = "update T_BG_BgItem set FIsEffective = 0 where FID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            if (updateList != null && !updateList.isEmpty()) {
                pstmt = conn.prepareStatement(sql);
                for (int i = 0; i < updateList.size(); ++i) {
                    pstmt.setString(1, (String)updateList.get(i));
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
    }

    /*
     * Exception decompiling
     */
    private List getAllChild(Context ctx, CostCenterOrgUnitInfo ccoInfo, List idList) throws BOSException, EASBizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void _batchSetItemEfficacy(Context ctx, List bgItems) throws BOSException, EASBizException {
        if (bgItems == null || bgItems.isEmpty()) {
            return;
        }
        Object _tmpMap = null;
        List updateList = this.getCanEfficacyItems(ctx, bgItems);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            if (updateList != null && !updateList.isEmpty()) {
                pstmt = conn.prepareStatement("update T_BG_BgItem set FIsEffective = 1 where FID = ? ");
                for (int i = 0; i < updateList.size(); ++i) {
                    pstmt.setString(1, (String)updateList.get(i));
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getCanEfficacyItems(Context ctx, List bgItemIds) throws BOSException, BgException, BgItemException, BgItemEfficacyException {
        if (bgItemIds == null) return bgItemIds;
        if (bgItemIds.isEmpty()) {
            return bgItemIds;
        }
        ArrayList<String> canEfficacyItems = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchSize = 50;
        int size = bgItemIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fid, t1.fnumber, t2.fid, t2.fnumber, t2.FIsEffective from t_bg_bgItem t1  left outer join t_bg_bgItem t2 on t1.FParentID = t2.FID  where t1.fid in (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?) order by t1.flongnumber");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int i = 1; i < batchSize + 1; ++i, ++pos) {
                    if (pos < size) {
                        pstmt.setString(i, (String)bgItemIds.get(pos));
                        continue;
                    }
                    pstmt.setString(i, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!rst.getBoolean(5) && !bgItemIds.contains(rst.getString(3))) {
                        throw new BgItemEfficacyException(BgItemEfficacyException.PARENTISINEFFICACY, new String[]{"\u3010" + rst.getString(4) + "\u3011"});
                    }
                    canEfficacyItems.add(rst.getString(1));
                }
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return canEfficacyItems;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getBatchBgItemName(Context ctx, BOSUuid orgUnitId, BOSUuid bgItemGroupId) throws BOSException, EASBizException {
        HashMap<String, BgItemInfo> bgItemMap = new HashMap<String, BgItemInfo>();
        if (orgUnitId == null) {
            return bgItemMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String bgItemId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FBgItemId, FBgItemName_L2, FBgItemName_L3 from T_BG_BgItemInfo where FOrgUnitId = ? and FBgItemLevel = 1");
        if (bgItemGroupId != null) {
            sql.append(" and FBgItemGroupId = ?");
        }
        BgItemInfo bgItemInfo = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnitId.toString());
            if (bgItemGroupId != null) {
                pstmt.setString(2, bgItemGroupId.toString());
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgItemInfo = new BgItemInfo();
                bgItemId = rst.getString("FBgItemId");
                bgItemInfo.setId(BOSUuid.read((String)bgItemId));
                bgItemInfo.setName(rst.getString("FBgItemName_L2"), locale_L2);
                bgItemInfo.setName(rst.getString("FBgItemName_L2"), locale_L3);
                bgItemMap.put(bgItemId, bgItemInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgItemMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getBatchBgItemName(Context ctx, BOSUuid orgUnitId, BOSUuid parentId, int level) throws BOSException, EASBizException {
        HashMap<String, BgItemInfo> bgItemMap = new HashMap<String, BgItemInfo>();
        if (orgUnitId == null) {
            return bgItemMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String bgItemId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FBgItemId, FBgItemName_L2, FBgItemName_L3 from T_BG_BgItemInfo where FOrgUnitId = ? and FBgItemParentID = ? and FBgItemLevel = ?");
        BgItemInfo bgItemInfo = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnitId.toString());
            pstmt.setString(2, parentId.toString());
            pstmt.setInt(3, level + 1);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgItemInfo = new BgItemInfo();
                bgItemId = rst.getString("FBgItemId");
                bgItemInfo.setId(BOSUuid.read((String)bgItemId));
                bgItemInfo.setName(rst.getString("FBgItemName_L2"), locale_L2);
                bgItemInfo.setName(rst.getString("FBgItemName_L2"), locale_L3);
                bgItemMap.put(bgItemId, bgItemInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgItemMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectValue _getBgItemName(Context ctx, BOSUuid orgUnitId, String number) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgItemInfo bgItemInfo = null;
        try {
            conn = this.getConnection(ctx);
            String sql = null;
            if (BgSHelper.isBgItemIsolate(ctx)) {
                sql = "select fid, FName_L2 from T_BG_BgItem where FOrgUnitId = ? and FNumber = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, orgUnitId.toString());
                pstmt.setString(2, number);
            } else {
                sql = "select fid, FName_L2 from T_BG_BgItem where FNumber = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, number);
            }
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgItemInfo = new BgItemInfo();
                bgItemInfo.setId(BOSUuid.read((String)rst.getString("fid")));
                bgItemInfo.setName(rst.getString("FName_L2"), locale_L2);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgItemInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _deleteBgItemName(Context ctx, BOSUuid orgUnitId, BOSUuid bgItemId) throws BOSException, EASBizException {
        if (orgUnitId == null) return;
        if (bgItemId == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_BG_BgItemInfo where FOrgUnitId = ? and FBgItemId = ?");
            pstmt.setString(1, orgUnitId.toString());
            pstmt.setString(2, bgItemId.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _deleteBgItemName(Context ctx, List orgUnitIds, BOSUuid bgItemId) throws BOSException, EASBizException {
        if (orgUnitIds == null) return;
        if (orgUnitIds.isEmpty()) return;
        if (bgItemId == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String _orgUnitId2222222 = null;
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_BG_BgItemInfo where FBgItemId = ? and FOrgUnitId in (");
        for (String _orgUnitId2222222 : orgUnitIds) {
            sql.append("'" + _orgUnitId2222222 + "',");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(")");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgItemId.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected Set getOrgUnitIds(Connection conn, BOSUuid orgUnitId) throws EASBizException {
        HashSet<String> orgUnitIdSet = new HashSet<String>();
        if (conn == null || orgUnitId == null) {
            return orgUnitIdSet;
        }
        String[] numberStr = null;
        String _number = null;
        String _longnumber = null;
        String _orgUnitId = null;
        StringBuffer query = new StringBuffer();
        _orgUnitId = orgUnitId.toString();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select FNumber, FLongNumber from T_ORG_CostCenter where FID = ?");
            pstmt.setString(1, _orgUnitId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                _number = rst.getString(1);
                _longnumber = rst.getString(2);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!StringUtils.isEmpty((String)_number) && !StringUtils.isEmpty((String)_longnumber)) {
                ArrayList<String> _tmpList = new ArrayList<String>();
                query.append("select FID from T_ORG_CostCenter where ");
                orgUnitIdSet = new HashSet();
                if (_longnumber != null) {
                    numberStr = _longnumber.split("\\!");
                    if (numberStr != null) {
                        query.append(" FNumber IN (");
                        int in = numberStr.length;
                        for (int i = 0; i < in; ++i) {
                            query.append("?,");
                            _tmpList.add(numberStr[i]);
                        }
                        query.delete(query.length() - 1, query.length());
                        query.append(") or ");
                    }
                    query.append("FLongNumber like ?");
                    _tmpList.add(_longnumber + "!%");
                }
                pstmt = conn.prepareStatement(query.toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    orgUnitIdSet.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return orgUnitIdSet;
    }

    protected Set getsubOrgUnitIds(Connection conn, BOSUuid orgUnitId, Context ctx) throws EASBizException {
        HashSet<String> orgUnitIdSet = new HashSet<String>();
        if (conn == null || orgUnitId == null) {
            return orgUnitIdSet;
        }
        String _number = null;
        String _longnumber = null;
        String _orgUnitId = null;
        StringBuffer query = new StringBuffer();
        _orgUnitId = orgUnitId.toString();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select FNumber, FLongNumber from T_ORG_CostCenter where FID = ?");
            pstmt.setString(1, _orgUnitId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                _number = rst.getString(1);
                _longnumber = rst.getString(2);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!StringUtils.isEmpty((String)_number) && !StringUtils.isEmpty((String)_number)) {
                String inNum = this.getInNum(_longnumber);
                query.append("select FID from T_ORG_CostCenter where " + inNum);
                if (!BgSHelper.isBgItemNumberRepeat(ctx)) {
                    query.append(" or FLongNumber like '" + _longnumber + "%'");
                }
                pstmt = conn.prepareStatement(query.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    orgUnitIdSet.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return orgUnitIdSet;
    }

    private String getInNum(String _longnumber) {
        String[] numLs = _longnumber.split("!");
        String inNum = " fnumber in " + BgHelper.tranArray2String(numLs);
        return inNum;
    }

    @Override
    protected IObjectCollection _getItemListBySumItemFormula(Context ctx, String sumItemFormula) throws BOSException, EASBizException {
        Pattern pt = Pattern.compile(sumItemPatternString);
        return this.get_ItemListBySumItemFormula(ctx, sumItemFormula, pt);
    }

    private BgItemCollection get_ItemListBySumItemFormula(Context ctx, String sumItemFormula, Pattern pt) throws BOSException, ServerException {
        if (sumItemFormula == null || sumItemFormula.length() == 0) {
            return null;
        }
        Matcher matcher = pt.matcher(sumItemFormula);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("parent"));
        view.getSelector().add(new SelectorItemInfo("itemId"));
        view.getSelector().add(new SelectorItemInfo("itemNumber"));
        view.getSelector().add(new SelectorItemInfo("itemName"));
        ArrayList<String> sumItemNumber = new ArrayList<String>();
        String itemNumber = null;
        StringBuffer maskString = new StringBuffer("(");
        int count = 0;
        while (matcher.find()) {
            itemNumber = matcher.group(2);
            if (sumItemNumber.contains(itemNumber)) {
                throw new ServerException(ServerException.FORMULARPTITEMREPEAT, new Object[]{itemNumber});
            }
            sumItemNumber.add(itemNumber);
            if (itemNumber == null || itemNumber.trim().length() == 0) continue;
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)itemNumber.trim(), CompareType.EQUALS));
            if (count != 0) {
                maskString.append(" OR ");
            }
            maskString.append("#").append(count);
            ++count;
        }
        maskString.append(")");
        String orgUnitId = BgSHelper.getIsolateOrg(ctx, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString());
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        maskString.append(" AND #").append(count);
        filter.setMaskString(maskString.toString());
        view.setFilter(filter);
        IBgItem ie = BgItemFactory.getLocalInstance(ctx);
        BgItemCollection subItems = ie.getBgItemCollection(view);
        if (subItems == null || subItems.isEmpty()) {
            throw new ServerException(ServerException.SUMITEMFORMULAERROR, new Object[]{((Object)sumItemNumber).toString()});
        }
        if (sumItemNumber.size() != subItems.size()) {
            for (int i = 0; i < subItems.size(); ++i) {
                sumItemNumber.remove(subItems.get(i).getNumber());
            }
            if (!sumItemNumber.isEmpty()) {
                throw new ServerException(ServerException.SUMITEMFORMULAERROR, new Object[]{((Object)sumItemNumber).toString()});
            }
        }
        sumItemNumber.clear();
        sumItemNumber = null;
        return subItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _updateSumFormula(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        BgItemInfo info = (BgItemInfo)model;
        BgItemInfo itemInfo = null;
        BgItemCollection itemCol = null;
        BOSUuid itemId = info.getItemID();
        String subItemNumbers = "";
        String subItemNumber2 = null;
        String notExitsItemNumber = "";
        String itemDirection = null;
        String subItemDirection = null;
        int isSumItem = 0;
        String sumFormula = "";
        Map<String, Boolean> numberMap = new TreeMap<String, Object>();
        CostCenterOrgUnitInfo ccorgUnitInfo = ContextUtil.getCurrentCostUnit((Context)ctx);
        IBgItem ibgItem = BgItemFactory.getLocalInstance(ctx);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            if (itemId != null && itemId.getType().toString().equals("237A9505")) {
                pstmt = conn.prepareStatement("select FIsSumItem, FSumItemFormula from T_CSL_RptItem where FID = '" + itemId + "'");
                rst = pstmt.executeQuery();
                if (!rst.next()) throw new BgItemException(BgItemException.CANTUPDATESUMFORMULARPTITEMREMOVE);
                isSumItem = rst.getInt(1);
                sumFormula = rst.getString(2);
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (isSumItem == 0) throw new BgItemException(BgItemException.CANTUPDATESUMFORMULARPTITEMDEL);
                if (StringUtils.isEmpty((String)sumFormula)) throw new BgItemException(BgItemException.CANTUPDATESUMFORMULARPTITEMDEL);
                numberMap = BgItemHelper.getItemNumbersFromSumFormula(sumFormula);
                if (numberMap == null || numberMap.isEmpty()) {
                    String string = null;
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
                    return string;
                }
                itemCol = ibgItem.getBgItemCollection("select number where orgUnit.id = '" + BgSHelper.getIsolateOrg(ctx, ccorgUnitInfo.getId().toString()) + "'  and number in " + BgItemHelper.mapkey2String(numberMap));
                Iterator it = itemCol.iterator();
                while (it.hasNext()) {
                    itemInfo = (BgItemInfo)it.next();
                    if (!numberMap.containsKey(itemInfo.getNumber())) continue;
                    numberMap.put(itemInfo.getNumber(), new Boolean(true));
                }
                if (numberMap.containsValue(null)) {
                    Iterator itNumberMap = numberMap.keySet().iterator();
                    while (true) {
                        if (!itNumberMap.hasNext()) {
                            throw new BgItemException(BgItemException.IMPORTSUMFORMULAFROMRPTFAIL, new String[]{info.getNumber(), sumFormula, notExitsItemNumber.substring(0, notExitsItemNumber.length() - 1)});
                        }
                        subItemNumber2 = (String)itNumberMap.next();
                        if (numberMap.get(subItemNumber2) != null) continue;
                        notExitsItemNumber = notExitsItemNumber + subItemNumber2 + ",";
                    }
                }
            } else if (itemId != null && itemId.getType().toString().equals("9DA99826")) {
                itemCol = this.getChildBgItem(ctx, ccorgUnitInfo, info.getId().toString(), info.getLevel());
                Iterator it = itemCol.iterator();
                while (it.hasNext()) {
                    itemInfo = (BgItemInfo)it.next();
                    numberMap.put(itemInfo.getNumber(), null);
                    subItemNumbers = subItemNumbers + "'" + itemInfo.getNumber() + "',";
                }
                numberMap.put(info.getNumber(), null);
                if (StringUtils.isEmpty((String)subItemNumbers)) {
                    it = null;
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
                    return it;
                }
                String itemIds = "";
                for (int i = 0; i < itemCol.size(); ++i) {
                    itemInfo = itemCol.get(i);
                    if (itemInfo.getItemID() == null) continue;
                    itemIds = itemIds + "'" + itemInfo.getItemID() + "',";
                }
                if (StringUtils.isEmpty((String)itemIds) && !StringUtils.isEmpty((String)subItemNumbers)) {
                    throw new BgItemException(BgItemException.CANTUPDATESUMFORMULAACCOUNTREMOVED, new String[]{subItemNumbers.substring(0, subItemNumbers.length() - 1)});
                }
                pstmt = conn.prepareStatement("select distinct FNumber, FDC from T_BD_AccountView where FNumber in (" + subItemNumbers + "'" + info.getItemNumber() + "') and FControlUnitID in (select distinct FControlUnitID from T_BD_AccountView where FID in (" + itemIds.substring(0, itemIds.length() - 1) + ")) and FAccountTableID in (select distinct FAccountTableID from T_BD_AccountView where FID in (" + itemIds.substring(0, itemIds.length() - 1) + ")) order by FNumber ");
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!numberMap.containsKey(rst.getString(1)) || numberMap.get(rst.getString(1)) != null) continue;
                    numberMap.put(rst.getString(1), (Boolean)((Object)Integer.toString(rst.getInt(2))));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (numberMap.containsValue(null)) {
                    Iterator it2 = numberMap.keySet().iterator();
                    while (true) {
                        if (!it2.hasNext()) {
                            throw new BgItemException(BgItemException.CANTUPDATESUMFORMULAACCOUNTREMOVED, new String[]{notExitsItemNumber.substring(0, notExitsItemNumber.length() - 1)});
                        }
                        subItemNumber2 = (String)it2.next();
                        if (numberMap.get(subItemNumber2) != null) continue;
                        notExitsItemNumber = notExitsItemNumber + subItemNumber2 + ",";
                    }
                }
                sumFormula = "";
                itemDirection = (String)numberMap.get(info.getNumber());
                for (String subItemNumber2 : numberMap.keySet()) {
                    subItemDirection = (String)numberMap.get(subItemNumber2);
                    if (subItemNumber2 != info.getNumber() && subItemDirection.equals(itemDirection)) {
                        sumFormula = sumFormula + "+" + subItemNumber2;
                        continue;
                    }
                    if (subItemNumber2 == info.getNumber() || subItemDirection.equals(itemDirection)) continue;
                    sumFormula = sumFormula + "-" + subItemNumber2;
                }
                if (sumFormula.startsWith("+")) {
                    sumFormula = sumFormula.substring(1, sumFormula.length());
                }
            } else {
                itemCol = this.getChildBgItem(ctx, ccorgUnitInfo, info.getId().toString(), info.getLevel());
                Iterator it = itemCol.iterator();
                while (it.hasNext()) {
                    subItemNumber2 = ((BgItemInfo)it.next()).getNumber();
                    sumFormula = sumFormula + "+" + subItemNumber2;
                }
                if (sumFormula.startsWith("+")) {
                    sumFormula = sumFormula.substring(1, sumFormula.length());
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return sumFormula;
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (BgItemException ex) {
            throw ex;
        }
        catch (Exception e1) {
            logger.error((Object)"budget error:", (Throwable)e1);
            return sumFormula;
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
    }

    private BgItemCollection getChildBgItem(Context ctx, CostCenterOrgUnitInfo ccoInfo, String id, int level) throws BOSException {
        if (id == null || level < 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(ctx, ccoInfo.getId().toString()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)id, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(level + 1), CompareType.EQUALS));
        view.setFilter(filter);
        SorterItemInfo sort = new SorterItemInfo("longnumber");
        sort.setSortType(SortType.ASCEND);
        view.getSorter().add(sort);
        view.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        return this.getBgItemCollection(ctx, view);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("itemID"));
        sic.add(new SelectorItemInfo("itemName"));
        sic.add(new SelectorItemInfo("itemNumber"));
        sic.add(new SelectorItemInfo("bgItemGroup.id"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("specialNumber"));
        sic.add(new SelectorItemInfo("isEffective"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("curOrgUnitId"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("refField"));
        sic.add(new SelectorItemInfo("assignBgItem.id"));
        sic.add(new SelectorItemInfo("root.id"));
        sic.add(new SelectorItemInfo("isSumFormula"));
        sic.add(new SelectorItemInfo("formula"));
        sic.add(new SelectorItemInfo("acctInit"));
        sic.add(new SelectorItemInfo("acctMaintain"));
        sic.add(new SelectorItemInfo("fpDirection"));
        sic.add(new SelectorItemInfo("elimType"));
        sic.add(new SelectorItemInfo("dataRelation"));
        return sic;
    }

    private String processSumFormula(Context ctx, BgItemCollection col) throws BOSException, EASBizException {
        if (col == null || col.isEmpty()) {
            return "";
        }
        String msg = "";
        BgItemInfo itemInfo = null;
        BgItemInfo subItemInfo = null;
        String itemNumber = null;
        String subItemNumber2 = null;
        String notExitsItem = "";
        String itemType = null;
        String sumFormula = "";
        Map numberMap = null;
        BgItemCollection itemCol = null;
        ArrayList<String[]> updateSumFormulas = new ArrayList<String[]>();
        IBgItem ie = BgItemFactory.getLocalInstance(ctx);
        CostCenterOrgUnitInfo ccorgUnitInfo = ContextUtil.getCurrentCostUnit((Context)ctx);
        Iterator it = col.iterator();
        while (it.hasNext()) {
            String[] updates;
            itemInfo = (BgItemInfo)it.next();
            itemNumber = itemInfo.getNumber();
            itemType = itemInfo.getExtendedProperty("itemType");
            if (itemType != null && itemType.equals("rpt")) {
                sumFormula = itemInfo.getExtendedProperty("sumFormula");
                numberMap = BgItemHelper.getItemNumbersFromSumFormula(sumFormula);
                if (numberMap == null || numberMap.isEmpty()) {
                    updates = new String[]{itemNumber, ccorgUnitInfo.getId().toString(), ""};
                    updateSumFormulas.add(updates);
                    continue;
                }
                itemCol = ie.getBgItemCollection("select number where orgUnit.id = '" + BgSHelper.getIsolateOrg(ctx, ccorgUnitInfo.getId().toString()) + "'  and number in " + BgItemHelper.mapkey2String(numberMap));
                Iterator itEntry = itemCol.iterator();
                while (itEntry.hasNext()) {
                    subItemInfo = (BgItemInfo)itEntry.next();
                    if (!numberMap.containsKey(subItemInfo.getNumber())) continue;
                    numberMap.put(subItemInfo.getNumber(), new Boolean(true));
                }
                if (numberMap.containsValue(null)) {
                    for (String subItemNumber2 : numberMap.keySet()) {
                        if (numberMap.get(subItemNumber2) != null) continue;
                        notExitsItem = notExitsItem + subItemNumber2 + ",";
                    }
                    msg = msg + new BgItemException(BgItemException.IMPORTSUMFORMULAFROMRPTFAIL, new String[]{itemNumber, sumFormula, notExitsItem.substring(0, notExitsItem.length() - 1)}).getMessage() + "\n";
                    sumFormula = "";
                }
            } else {
                sumFormula = BgItemHelper.getSumFormulaFromChild(itemInfo, col);
            }
            if (itemNumber == null || ccorgUnitInfo.getNumber() == null) continue;
            updates = new String[]{itemNumber, ccorgUnitInfo.getId().toString(), sumFormula == null ? "" : sumFormula};
            updateSumFormulas.add(updates);
        }
        if (!updateSumFormulas.isEmpty()) {
            this._batchUpdateSumFormula(ctx, updateSumFormulas);
        }
        return msg;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _batchUpdateSumFormula(Context ctx, List updateSumFormulas) throws BOSException, EASBizException {
        if (updateSumFormulas == null) return;
        if (updateSumFormulas.isEmpty()) {
            return;
        }
        String[] updates2222222 = null;
        StringBuffer updateSql = new StringBuffer();
        String orgUnitId = BgSHelper.getIsolateOrg(ctx, ((String[])updateSumFormulas.get(0))[1]);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            updateSql.append("update T_BG_BgItem set FFormula = ?, FIsSumFormula = ?  where FNumber = ? and FOrgUnitId = ? ");
            pstmt = conn.prepareStatement(updateSql.toString());
            for (String[] updates2222222 : updateSumFormulas) {
                pstmt.setString(1, updates2222222[2]);
                if (StringUtils.isEmpty((String)updates2222222[2])) {
                    pstmt.setInt(2, 0);
                } else {
                    pstmt.setInt(2, 1);
                }
                pstmt.setString(3, updates2222222[0]);
                pstmt.setString(4, orgUnitId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _checkExpIsUpdate(Context ctx, IObjectPK pk, IObjectValue newValue) throws BOSException, EASBizException {
        if (pk == null || newValue == null) {
            return null;
        }
        BgItemInfo _newValue = (BgItemInfo)newValue;
        HashMap<String, Object> extraInfomation = new HashMap<String, Object>();
        boolean isRefered = false;
        IBgItem ie = BgItemFactory.getLocalInstance(ctx);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        CostCenterOrgUnitInfo costInfo = ContextUtil.getCurrentCostUnit((Context)ctx);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("number"));
        selectorItemCollection.add(new SelectorItemInfo("refField"));
        selectorItemCollection.add(new SelectorItemInfo("isSumFormula"));
        selectorItemCollection.add(new SelectorItemInfo("formula"));
        selectorItemCollection.add(new SelectorItemInfo("acctInit"));
        selectorItemCollection.add(new SelectorItemInfo("acctMaintain"));
        BgItemInfo _oldValue = ie.getBgItemInfo(pk, selectorItemCollection);
        String _refField = _oldValue.getRefField();
        String _number = _oldValue.getNumber();
        if (_oldValue.getFormula() == null) {
            _oldValue.setFormula("");
        }
        if (_oldValue.getAcctInit() == null) {
            _oldValue.setAcctInit("");
        }
        if (_oldValue.getAcctMaintain() == null) {
            _oldValue.setAcctMaintain("");
        }
        if (_newValue.getFormula() == null) {
            _newValue.setFormula("");
        }
        if (_newValue.getAcctInit() == null) {
            _newValue.setAcctInit("");
        }
        if (_newValue.getAcctMaintain() == null) {
            _newValue.setAcctMaintain("");
        }
        if (!(Boolean.valueOf(_oldValue.isIsSumFormula()).equals(_newValue.isIsSumFormula()) && _oldValue.getFormula().equals(_newValue.getFormula()) && _oldValue.getAcctInit().equals(_newValue.getAcctInit()) && _oldValue.getAcctMaintain().equals(_newValue.getAcctMaintain()))) {
            try {
                StringBuffer relatedTemplates = new StringBuffer();
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement("select fid, fnumber, fname from t_bg_bgtemplate where fid in ( select fbgtemplateid  from t_bg_bgtemrefbgitemcombin where fbgitemcombinid in (SELECT FID FROM T_BG_BgItemCombination WHERE " + _refField + " = '" + _number + "') ) and forgunitid = '" + costInfo.getId().toString() + "'");
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    relatedTemplates.append(EASResource.getString((String)RES_PATH, (String)"bgTemplateNumber")).append(": ").append(rst.getString(2)).append("\r\n").append(EASResource.getString((String)RES_PATH, (String)"bgTemplateName")).append(": ").append(rst.getString(3)).append("\r\n").append("-----------------------------------------------------------------------\r\n");
                }
                if (relatedTemplates.length() != 0) {
                    isRefered = true;
                    relatedTemplates.insert(0, "-----------------------------------------------------------------------\r\n");
                    relatedTemplates.insert(0, BgItemControllerBean.getStringWithCR("ItemRelatedTemplate_TemplateReferred") + "\r\n\r\n");
                    extraInfomation.put("relatedTemplates", relatedTemplates.toString());
                }
                StringBuffer relatedBgforms = new StringBuffer();
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                pstmt = conn.prepareStatement("select fid, fnumber, fname from t_bg_bgform where fid in ( select fbgformid  from t_bg_bgdata where fbgitemcombinid in (SELECT FID FROM T_BG_BgItemCombination WHERE " + _refField + " = '" + _number + "') ) and forgunitid = '" + costInfo.getId().toString() + "'");
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    relatedBgforms.append(EASResource.getString((String)RES_PATH, (String)"bgformNumber")).append(": ").append(rst.getString("fnumber")).append("\r\n").append(EASResource.getString((String)RES_PATH, (String)"bgformName")).append(": ").append(rst.getString("fname")).append("\r\n").append("-----------------------------------------------------------------------\r\n");
                }
                if (relatedBgforms.length() != 0) {
                    isRefered = true;
                    relatedBgforms.insert(0, "-----------------------------------------------------------------------\r\n");
                    relatedBgforms.insert(0, BgItemControllerBean.getStringWithCR("ItemRelatedBgforms_BgformReferred") + "\r\n\r\n");
                    extraInfomation.put("relatedBgforms", relatedBgforms.toString());
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (BOSException ex2) {
                        throw ex2;
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        extraInfomation.put("isRefered", new Boolean(isRefered));
        return extraInfomation;
    }

    public static String getStringWithCR(String resName) {
        String s = EASResource.getString((String)RES_PATH, (String)resName);
        if (s != null && s.length() > 0) {
            s = s.replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n");
        }
        return s;
    }

    public static String getString(Context ctx, String resName) {
        String s = ResourceBase.getString((String)RES_PATH, (String)resName, (Locale)ctx.getLocale());
        return s;
    }

    protected void preProcessImportItems(Context ctx, BgItemCollection col, String orgUnitId) throws EASBizException, BOSException {
        if (col == null || col.isEmpty() || orgUnitId == null) {
            return;
        }
        CostCenterOrgUnitInfo costCenter = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
        FullOrgUnitInfo orgUnit = costCenter.castToFullOrgUnitInfo();
        BgItemInfo info = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            info.setOrgUnit(orgUnit);
            if (info.getAssignParentOrg() == null) {
                info.setAssignParentOrg(orgUnit);
            }
            if (info.getAssignRootOrg() == null) {
                info.setAssignRootOrg(orgUnit);
            }
            if (info.getId() != null) continue;
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map checkImportItemNumbers(Context ctx, String orgUnitId, BgItemCollection col, String importSource) throws EASBizException, BOSException {
        HashMap<String, String> notImportMap = new HashMap<String, String>();
        if (col == null) return notImportMap;
        if (col.isEmpty()) {
            return notImportMap;
        }
        orgUnitId = BgSHelper.getIsolateOrg(ctx, orgUnitId);
        String[] especialChar = new String[]{"_"};
        BgItemInfo info = null;
        String number = null;
        HashMap<String, BgItemInfo> numberInfoMap = new HashMap<String, BgItemInfo>();
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            if (StringUtils.isEmpty((String)info.getNumber())) {
                String companyId = info.getOrgUnit().getId().toString();
                BgHelper.setSNumber(ctx, companyId, (CoreBaseInfo)info);
                if (StringUtils.isEmpty((String)info.getNumber())) {
                    info.setNumber("BgItem-" + System.currentTimeMillis());
                }
            }
            number = info.getNumber();
            for (int j = 0; j < especialChar.length; ++j) {
                if (number.indexOf(especialChar[j]) == -1) continue;
                if (!notImportMap.containsKey(number)) {
                    notImportMap.put(number, new BgItemException(BgItemException.ERRORNUM, new String[]{number}).getMessage());
                    break;
                }
                notImportMap.put(number, new BgItemException(BgItemException.BGITEMNUMBEREXISTS, new String[]{number}).getMessage());
                break;
            }
            numberInfoMap.put(number, info);
        }
        String num = null;
        ArrayList<String> numList = new ArrayList<String>();
        String refField = null;
        int elimType = 0;
        for (int i2 = 0; i2 < col.size(); ++i2) {
            num = col.get(i2).getNumber();
            numList.add(num);
        }
        int batchSize = 300;
        int size = numList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select FNumber from t_bg_bgItem where FNumber in (");
        for (int i3 = 1; i3 < batchSize; ++i3) {
            sql.append("?,");
        }
        sql.append("?) and ForgUnitId = ? ");
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select distinct i.FNumber, i.FRefField, i.FElimType, g.FName_" + ctx.getLocale() + " from t_bg_bgItem i  join t_bg_bgItemGroup g on i.FRefField = g.FRefField where i.FNumber in (");
        for (int i4 = 1; i4 < batchSize; ++i4) {
            sql2.append("?,");
        }
        sql2.append("?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rst = null;
        ResultSet rst2 = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt2 = conn.prepareStatement(sql2.toString());
            for (int i5 = 0; i5 < count; ++i5) {
                for (int j = 1; j <= batchSize; ++j, ++pos) {
                    if (pos < size) {
                        pstmt.setString(j, (String)numList.get(pos));
                        pstmt2.setString(j, (String)numList.get(pos));
                        continue;
                    }
                    pstmt.setString(j, "#");
                    pstmt2.setString(j, "#");
                }
                pstmt.setString(batchSize + 1, orgUnitId);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    number = rst.getString(1);
                    info = (BgItemInfo)numberInfoMap.get(number);
                    notImportMap.put(number, null);
                    if (notImportMap.containsKey(number) && notImportMap.get(number) != null) continue;
                    notImportMap.put(number, BgItemControllerBean.getString(ctx, "bgItem") + number + BgItemControllerBean.getString(ctx, "alreadyExist"));
                }
                SQLUtils.cleanup((ResultSet)rst);
                rst2 = pstmt2.executeQuery();
                while (rst2.next()) {
                    number = rst2.getString(1);
                    refField = rst2.getString(2);
                    elimType = rst2.getInt(3);
                    info = (BgItemInfo)numberInfoMap.get(number);
                    if (number.equals(info.getNumber()) && !refField.equals(info.getRefField())) {
                        notImportMap.put(number, BgItemControllerBean.getString(ctx, "bgItem") + number + BgItemControllerBean.getString(ctx, "import") + BgItemControllerBean.getString(ctx, "failed") + ": " + BgItemControllerBean.getString(ctx, "number") + BgItemControllerBean.getString(ctx, "alreadyExist") + "," + BgItemControllerBean.getString(ctx, "and") + BgItemControllerBean.getString(ctx, "itemGroupNotIdentical"));
                    }
                    if (!number.equals(info.getNumber()) || elimType == info.getElimType().getValue()) continue;
                    notImportMap.put(number, BgItemControllerBean.getString(ctx, "bgItem") + number + BgItemControllerBean.getString(ctx, "import") + BgItemControllerBean.getString(ctx, "failed") + ": " + BgItemControllerBean.getString(ctx, "number") + BgItemControllerBean.getString(ctx, "alreadyExist") + "," + BgItemControllerBean.getString(ctx, "and") + BgItemControllerBean.getString(ctx, "itemElimNotIdentical"));
                }
                SQLUtils.cleanup((ResultSet)rst2);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                SQLUtils.cleanup(rst2, pstmt2);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup(rst2, (Statement)pstmt2);
        return notImportMap;
    }

    private String getDirectParentNum(String longNum) {
        if (StringUtils.isEmpty((String)longNum) || longNum.indexOf("!") == -1) {
            return longNum;
        }
        String[] longNumSplited = longNum.split("!");
        return longNumSplited[longNumSplited.length - 2];
    }

    private String[] getDirectParentNums(String longNum) {
        if (StringUtils.isEmpty((String)longNum) || longNum.indexOf("!") == -1) {
            return new String[]{longNum};
        }
        String[] longNumSplited = longNum.split("!");
        int size = longNumSplited.length - 1;
        String[] parentNums = new String[size];
        for (int i = 0; i < size; ++i) {
            parentNums[i] = longNumSplited[i];
        }
        return parentNums;
    }

    private String getDirectParentLongNum(String longNum) {
        if (longNum == null) {
            return null;
        }
        String[] numbers = longNum.split("!");
        if (numbers.length == 1) {
            return longNum;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < numbers.length - 1; ++i) {
            sb.append(numbers[i]).append("!");
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    private String[] getParentLongNum(String longNum) {
        if (longNum == null) {
            return null;
        }
        String[] numbers = longNum.split("!");
        if (numbers.length == 1) {
            return new String[]{longNum};
        }
        String[] parentLongNum = new String[numbers.length - 1];
        for (int i = 0; i < parentLongNum.length; ++i) {
            parentLongNum[i] = i == 0 ? numbers[i] : parentLongNum[i - 1] + "!" + numbers[i];
        }
        return parentLongNum;
    }

    private Map processImportItemParents(Context ctx, String orgUnitId, BgItemCollection col, Map notImported) throws BOSException {
        int i;
        HashMap<String, String> notImportMap = new HashMap<String, String>();
        orgUnitId = BgSHelper.getIsolateOrg(ctx, orgUnitId);
        if (col == null || col.isEmpty()) {
            return notImportMap;
        }
        BgItemCollection existItems = null;
        BgItemInfo info = null;
        BgItemInfo parentInfo = null;
        String number = null;
        String longNum = null;
        String parentNum = null;
        String parentLongNum = null;
        String[] parentLongNums = null;
        String[] parentNums = null;
        String itemGroupId2 = null;
        Set longNumSet = null;
        Set numberSet = null;
        HashMap groupAndNumbers = new HashMap();
        HashMap groupAndLongNums = new HashMap();
        HashMap<String, BgItemInfo> longNumInfoMap = new HashMap<String, BgItemInfo>();
        HashMap<String, BgItemInfo> existLongNumberInfoMap = new HashMap<String, BgItemInfo>();
        HashMap<String, BgItemInfo> existNumberInfoMap = new HashMap<String, BgItemInfo>();
        for (int i2 = 0; i2 < col.size(); ++i2) {
            int j;
            info = col.get(i2);
            number = info.getNumber();
            if (StringUtils.isEmpty((String)info.getLongNumber())) {
                info.setLongNumber(number);
            }
            longNum = info.getLongNumber();
            if (info.getBgItemGroup() == null || info.getBgItemGroup().getId() == null) {
                itemGroupId2 = null;
                notImportMap.put(number, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"bgItemGroupNull", (Locale)ctx.getLocale()));
                continue;
            }
            itemGroupId2 = info.getBgItemGroup().getId().toString();
            if (!groupAndNumbers.containsKey(itemGroupId2)) {
                groupAndNumbers.put(itemGroupId2, new HashSet());
            }
            if (!groupAndLongNums.containsKey(itemGroupId2)) {
                groupAndLongNums.put(itemGroupId2, new HashSet());
            }
            longNumSet = (Set)groupAndLongNums.get(itemGroupId2);
            numberSet = (Set)groupAndNumbers.get(itemGroupId2);
            parentLongNums = this.getParentLongNum(longNum);
            for (j = 0; j < parentLongNums.length; ++j) {
                longNumSet.add(parentLongNums[j]);
            }
            parentNums = this.getDirectParentNums(longNum);
            for (j = 0; j < parentNums.length; ++j) {
                numberSet.add(parentNums[j]);
            }
            longNumInfoMap.put(longNum, info);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = this.getSelectors();
        view.setSelector(sic);
        FilterInfo filter = null;
        for (String itemGroupId2 : groupAndNumbers.keySet()) {
            longNumSet = (Set)groupAndLongNums.get(itemGroupId2);
            numberSet = (Set)groupAndNumbers.get(itemGroupId2);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
            filter.setMaskString("(#0) and ((#1) or (#2))");
            view.setFilter(filter);
            existItems = this.getBgItemCollection(ctx, view);
            for (i = 0; i < existItems.size(); ++i) {
                info = existItems.get(i);
                longNum = info.getLongNumber();
                number = info.getNumber();
                if (!existLongNumberInfoMap.containsKey(longNum)) {
                    existLongNumberInfoMap.put(longNum, info);
                }
                if (existNumberInfoMap.containsKey(number)) continue;
                existNumberInfoMap.put(number, info);
            }
        }
        HashSet<String> notImportLongNumSet = new HashSet<String>();
        for (i = 0; i < col.size(); ++i) {
            info = col.get(i);
            number = info.getNumber();
            longNum = info.getLongNumber();
            parentNum = this.getDirectParentNum(longNum);
            parentLongNum = this.getDirectParentLongNum(longNum);
            if (!(longNumInfoMap.containsKey(parentLongNum) || existLongNumberInfoMap.containsKey(parentLongNum) || existNumberInfoMap.containsKey(number))) {
                notImportMap.put(number, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"importFail", (Locale)ctx.getLocale(), (Object[])new Object[]{number, new BgItemException(BgItemException.PARENTNOTEXIST, new String[]{parentNum}).getMessage()}));
                notImportLongNumSet.add(longNum);
                continue;
            }
            if (notImportMap.containsKey(parentNum) || notImportLongNumSet.contains(parentLongNum)) {
                notImportMap.put(number, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"importFail", (Locale)ctx.getLocale(), (Object[])new Object[]{number, new BgItemException(BgItemException.PARENTIMPOTERROR, new String[]{parentNum}).getMessage()}));
                notImportLongNumSet.add(longNum);
                continue;
            }
            if (existLongNumberInfoMap.containsKey(parentLongNum)) {
                parentInfo = (BgItemInfo)existLongNumberInfoMap.get(parentLongNum);
                if (!number.equals(parentNum) && !info.getBgItemGroup().getId().toString().equals(parentInfo.getBgItemGroup().getId().toString())) {
                    notImportMap.put(number, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"numberRepeatAndGroupDef", (Locale)ctx.getLocale(), (Object[])new Object[]{number, parentNum}));
                    notImportLongNumSet.add(longNum);
                }
                if (parentInfo.getFpDirection() != null && info.getFpDirection() != null) {
                    if (parentInfo.getFpDirection().getValue() != info.getFpDirection().getValue()) {
                        notImportMap.put(number, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"fpDiff", (Locale)ctx.getLocale(), (Object[])new Object[]{number, parentNum}));
                        notImportLongNumSet.add(longNum);
                    }
                    if (parentInfo.getElimType().getValue() != info.getElimType().getValue()) {
                        notImportMap.put(number, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"elimDif", (Locale)ctx.getLocale(), (Object[])new Object[]{number, parentNum}));
                        notImportLongNumSet.add(longNum);
                    }
                    if (parentInfo.getDataRelation().getValue() != info.getDataRelation().getValue()) {
                        notImportMap.put(number, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"dataRelationDif", (Locale)ctx.getLocale(), (Object[])new Object[]{number, parentNum}));
                        notImportLongNumSet.add(longNum);
                    }
                }
            } else if (existNumberInfoMap.containsKey(parentNum) && !existLongNumberInfoMap.containsKey(parentLongNum)) {
                if (!number.equals(parentNum)) {
                    notImportMap.put(number, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"levelDif", (Locale)ctx.getLocale(), (Object[])new Object[]{number, parentNum}));
                } else {
                    notImportMap.put(number, null);
                }
                notImportLongNumSet.add(longNum);
            } else if (longNumInfoMap.containsKey(parentLongNum) && (parentInfo = (BgItemInfo)longNumInfoMap.get(parentLongNum)).getFpDirection() != null && info.getFpDirection() != null) {
                if (parentInfo.getFpDirection().getValue() != info.getFpDirection().getValue()) {
                    notImportMap.put(number, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"fpDiff", (Locale)ctx.getLocale(), (Object[])new Object[]{number, parentNum}));
                    notImportLongNumSet.add(longNum);
                }
                if (parentInfo.getElimType().getValue() != info.getElimType().getValue()) {
                    notImportMap.put(number, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"fpDiff", (Locale)ctx.getLocale(), (Object[])new Object[]{number, parentNum}));
                    notImportLongNumSet.add(longNum);
                }
                if (parentInfo.getDataRelation().getValue() != info.getDataRelation().getValue()) {
                    notImportMap.put(number, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"dataRelationDif", (Locale)ctx.getLocale(), (Object[])new Object[]{number, parentNum}));
                    notImportLongNumSet.add(longNum);
                }
            }
            if (parentInfo == null) continue;
            info.setParent(parentInfo);
            info.setAssignParent(info);
            info.setAssignRoot(info);
            info.setIsEffective(true);
            info.setIsLeaf(true);
            if (!longNum.equals(parentLongNum)) {
                parentInfo.setIsLeaf(false);
                if (parentInfo.getLevel() > 0) {
                    info.setLevel(parentInfo.getLevel() + 1);
                }
            }
            if (info.getLevel() > 0) continue;
            info.setLevel(longNum.split("!").length);
        }
        return notImportMap;
    }

    protected Map checkCanImportItems(Context ctx, String orgUnitId, BgItemCollection col, String importSource) throws EASBizException, BOSException {
        HashMap<String, String> notImportMap = new HashMap<String, String>();
        if (col == null || col.isEmpty()) {
            return notImportMap;
        }
        Map notImportMap1 = this.checkImportItemNumbers(ctx, orgUnitId, col, importSource);
        if (notImportMap1.keySet().size() == col.size()) {
            return notImportMap1;
        }
        Map notImportMap2 = this.processImportItemParents(ctx, orgUnitId, col, notImportMap1);
        String number2 = null;
        String msg = null;
        for (String number2 : notImportMap1.keySet()) {
            msg = (String)notImportMap1.get(number2);
            if (!notImportMap.containsKey(number2)) {
                notImportMap.put(number2, msg);
                continue;
            }
            if (StringUtils.isEmpty((String)msg)) continue;
            notImportMap.put(number2, notImportMap.get(number2) + "\n" + msg);
        }
        for (String number2 : notImportMap2.keySet()) {
            msg = (String)notImportMap2.get(number2);
            if (!notImportMap.containsKey(number2)) {
                notImportMap.put(number2, msg);
                continue;
            }
            if (StringUtils.isEmpty((String)msg)) continue;
            notImportMap.put(number2, notImportMap.get(number2) + "\n" + msg);
        }
        return notImportMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addNewItems(Context ctx, BgItemCollection col) throws EASBizException, BOSException {
        if (col == null) return;
        if (col.isEmpty()) {
            return;
        }
        BgItemInfo info = null;
        String ccOrgUnitId = BgSHelper.getIsolateOrg(ctx, ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString());
        String orgLNum = ContextUtil.getCurrentCostUnit((Context)ctx).getLongNumber().toString();
        String ccuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("insert into t_bg_bgItem (FID, FControlUnitID, FLastUpdateTime, FLastUpdateUserId, FCreateTime, FCreatorID, FSimpleName, FDescription_l1,FDescription_l2,FDescription_l3, FNumber, fname_l1,fname_l2,fname_l3, FDisplayName_l1,FDisplayName_l2,FDisplayName_l3, FLongNumber, FLevel, FIsLeaf, FAcctMaintain, FAcctInit, FFormula, FIsSumFormula, FAssignRootID, FAssignParentID, FOrgUnitID, FSpecialNumber, FRefField, FParentID, FIsEffective, FBgItemGroupID, FItemName_l1,FItemName_l2,FItemName_l3, FItemNumber, FItemID, FAssignParentOrgID, FAssignRootOrgID, FBosType, FIsForFP, FFpDirection, FElimType, FDataRela ) ");
        sqlInsert.append("values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        StringBuffer sqlUpdateParentIsLeaf = new StringBuffer();
        sqlUpdateParentIsLeaf.append("update t_bg_bgitem set FIsLeaf = 0 where fnumber = ? and fOrgUnitId = ? ");
        StringBuffer sqlUpdataIsolate = new StringBuffer();
        sqlUpdataIsolate.append("update t_bg_bgItem set FOrgUnitID = '00000000-0000-0000-0000-000000000000CCE7AED4', FSimpleName ='no_dataMigrate', FCurOrgUnitLongNumber = ? where fnumber = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        PreparedStatement pstmt3 = null;
        String parentNum = null;
        String orgUnitId = null;
        String orgLongNum = null;
        int batchSize = 200;
        int index = 0;
        int index2 = 0;
        int index3 = 0;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sqlInsert.toString());
            pstmt2 = conn.prepareStatement(sqlUpdateParentIsLeaf.toString());
            pstmt3 = conn.prepareStatement(sqlUpdataIsolate.toString());
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                pstmt.setString(1, info.getId().toString());
                pstmt.setString(2, info.getCU() == null ? ccuId : info.getCU().getId().toString());
                pstmt.setDate(3, new Date(System.currentTimeMillis()));
                pstmt.setString(4, userId);
                pstmt.setDate(5, new Date(System.currentTimeMillis()));
                pstmt.setString(6, userId);
                pstmt.setString(7, info.getSimpleName());
                pstmt.setString(8, info.getDescription(LocaleUtils.getLocale((String)"l1")));
                pstmt.setString(9, info.getDescription(LocaleUtils.getLocale((String)"l2")));
                pstmt.setString(10, info.getDescription(LocaleUtils.getLocale((String)"l3")));
                pstmt.setString(11, info.getNumber());
                pstmt.setString(12, info.getName(LocaleUtils.getLocale((String)"l1")));
                pstmt.setString(13, info.getName(LocaleUtils.getLocale((String)"l2")));
                pstmt.setString(14, info.getName(LocaleUtils.getLocale((String)"l3")));
                pstmt.setString(15, info.getDisplayName(LocaleUtils.getLocale((String)"l1")));
                pstmt.setString(16, info.getDisplayName(LocaleUtils.getLocale((String)"l2")));
                pstmt.setString(17, info.getDisplayName(LocaleUtils.getLocale((String)"l3")));
                pstmt.setString(18, info.getLongNumber());
                pstmt.setInt(19, info.getLevel());
                pstmt.setBoolean(20, info.isIsLeaf());
                pstmt.setString(21, info.getAcctMaintain());
                pstmt.setString(22, info.getAcctInit());
                pstmt.setString(23, info.getFormula());
                pstmt.setBoolean(24, info.isIsSumFormula());
                pstmt.setString(25, info.getAssignRoot().getId() == null ? info.getId().toString() : info.getAssignRoot().getId().toString());
                pstmt.setString(26, info.getAssignParent().getId() == null ? info.getId().toString() : info.getAssignParent().getId().toString());
                pstmt.setString(27, info.getOrgUnit().getId() == null ? ccOrgUnitId : info.getOrgUnit().getId().toString());
                pstmt.setString(28, info.getSpecialNumber());
                pstmt.setString(29, info.getRefField());
                pstmt.setString(30, info.getParent().getId() == null ? info.getId().toString() : info.getParent().getId().toString());
                pstmt.setBoolean(31, info.isIsEffective());
                pstmt.setString(32, info.getBgItemGroup().getId().toString());
                pstmt.setString(33, info.getItemName(LocaleUtils.getLocale((String)"l1")));
                pstmt.setString(34, info.getItemName(LocaleUtils.getLocale((String)"l2")));
                pstmt.setString(35, info.getItemName(LocaleUtils.getLocale((String)"l3")));
                pstmt.setString(36, info.getItemNumber());
                pstmt.setString(37, info.getItemID() == null ? null : info.getItemID().toString());
                pstmt.setString(38, info.getAssignParentOrg().getId() == null ? ccOrgUnitId : info.getAssignParentOrg().getId().toString());
                pstmt.setString(39, info.getAssignRootOrg().getId() == null ? ccOrgUnitId : info.getAssignRootOrg().getId().toString());
                pstmt.setString(40, info.getBosType());
                pstmt.setBoolean(41, info.isIsForFP());
                pstmt.setInt(42, info.getFpDirection() == null ? 0 : info.getFpDirection().getValue());
                pstmt.setInt(43, info.getElimType() == null ? 0 : info.getElimType().getValue());
                pstmt.setInt(44, info.getDataRelation() == null ? -1 : info.getDataRelation().getValue());
                String logName = info.getNumber() + " " + info.getName();
                IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"addNewItems", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgItem_import");
                LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
                pstmt.addBatch();
                if (++index > batchSize) {
                    pstmt.executeBatch();
                    index = 0;
                }
                if (info.getParent() != null && info.getParent() != info) {
                    parentNum = this.getDirectParentNum(info.getLongNumber());
                    orgUnitId = info.getOrgUnit().getId() == null ? ccOrgUnitId : info.getOrgUnit().getId().toString();
                    pstmt2.setString(1, parentNum);
                    pstmt2.setString(2, orgUnitId);
                    pstmt2.addBatch();
                    if (++index2 > batchSize) {
                        pstmt2.executeBatch();
                        index2 = 0;
                    }
                }
                if (BgSHelper.isBgItemIsolate(ctx)) continue;
                orgLongNum = info.getOrgUnit().getLongNumber() == null ? orgLNum : info.getOrgUnit().getLongNumber();
                pstmt3.setString(1, orgLongNum);
                pstmt3.setString(2, info.getNumber());
                pstmt3.addBatch();
                if (++index3 <= batchSize) continue;
                pstmt3.executeBatch();
                index3 = 0;
            }
            if (index != 0) {
                pstmt.executeBatch();
            }
            if (index2 != 0) {
                pstmt2.executeBatch();
            }
            if (index3 != 0) {
                pstmt3.executeBatch();
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                SQLUtils.cleanup(pstmt2, (Connection)conn);
                SQLUtils.cleanup(pstmt3, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((Statement)pstmt2, (Connection)conn);
        SQLUtils.cleanup((Statement)pstmt3, (Connection)conn);
    }

    private String getItemLongNumber(String longNumber) {
        StringBuffer sb = new StringBuffer();
        if (longNumber != null) {
            String[] newLongNum = longNumber.split("\\.");
            int i = 0;
            int repeat = 0;
            while (i < newLongNum.length) {
                for (int j = 0; j <= repeat; ++j) {
                    if (j == repeat) {
                        sb.append(newLongNum[j]);
                        continue;
                    }
                    sb.append(newLongNum[j]).append(".");
                }
                sb.append("!");
                ++i;
                ++repeat;
            }
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    protected Map _importItems(Context ctx, IObjectCollection itemCol, String orgUnitId, String importSource) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        BgItemInfo info = null;
        String number = null;
        BgItemCollection col = (BgItemCollection)itemCol;
        String longNumber = null;
        for (int i = 0; i < col.size(); ++i) {
            longNumber = col.get(i).getLongNumber();
            if (longNumber == null || longNumber.indexOf(".") < 0 || longNumber.indexOf("!") >= 0) continue;
            longNumber = this.getItemLongNumber(longNumber);
            col.get(i).setLongNumber(longNumber);
        }
        BgHelper.sortCollection(col, new String[]{"longNumber"});
        BgItemCollection successCol = new BgItemCollection();
        StringBuffer msg = new StringBuffer();
        String processSumFormulaMsg = null;
        this.preProcessImportItems(ctx, col, orgUnitId);
        Map notImportMap = this.checkCanImportItems(ctx, orgUnitId, col, importSource);
        ArrayList<String> numList = new ArrayList<String>();
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            if (numList.contains(info.getNumber())) {
                msg.append(BgItemControllerBean.getString(ctx, "bgItem") + info.getNumber() + BgItemControllerBean.getString(ctx, "alreadyExist") + "\n");
                continue;
            }
            numList.add(info.getNumber());
            number = info.getNumber();
            if (!notImportMap.containsKey(number)) {
                successCol.add(info);
                continue;
            }
            if (StringUtils.isEmpty((String)((String)notImportMap.get(number)))) continue;
            msg.append(number + "\uff1a" + notImportMap.get(number) + "\n");
        }
        this.addNewItems(ctx, successCol);
        if (!StringUtils.isEmpty((String)importSource) && importSource.equals("SYS_IMPORT")) {
            processSumFormulaMsg = this.processSumFormula(ctx, successCol);
            msg.append(processSumFormulaMsg);
        }
        if (successCol.size() == 0) {
            map.put("result", "importLost");
        } else if (successCol.size() < col.size()) {
            map.put("result", "partialSuccess");
        } else {
            map.put("result", "success");
        }
        map.put("detail", msg.toString());
        return map;
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
        OrgUnitInfo orgUnitInfo = ContextUtil.getCurrentOrgUnit((Context)ctx);
        FilterInfo lNfilter = new FilterInfo();
        lNfilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)treeBaseInfo.getLongNumber()));
        lNfilter.getFilterItems().add(new FilterItemInfo("id", (Object)treeBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        lNfilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(ctx, orgUnitInfo.getId().toString())));
        lNfilter.setMaskString("#0 AND #1 AND #2");
        if (this.exists(ctx, lNfilter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeBaseInfo.getNumber()});
        }
    }

    @Override
    protected String _updateElimType(Context ctx, ArrayList headId, BgElimTypeEnum elimType, BgDataRelationEnum dataRela) throws BOSException, EASBizException {
        int elimTypeValue = elimType.getValue();
        int dataRelaValue = dataRela.getValue();
        BgItemCollection coll = this.getItemColl(ctx, headId);
        BgItemInfo info = null;
        String orgUnitId = null;
        if (coll != null && !coll.isEmpty() && coll.get(0) != null && coll.get(0).getOrgUnit() != null) {
            orgUnitId = coll.get(0).getOrgUnit().getId().toString();
        }
        String headNumber = null;
        ArrayList<String> level1Number = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            headNumber = info.getNumber();
            if (headNumber.indexOf(".") == -1) {
                level1Number.add(headNumber);
                continue;
            }
            String number = headNumber.substring(0, headNumber.indexOf("."));
            if (level1Number.contains(number)) continue;
            level1Number.add(number);
        }
        ArrayList treeIds = null;
        String innerRefN = " ";
        String elimTemRefN = " ";
        String eliminationRefN = " ";
        String workPaperRefN = " ";
        String detail = "";
        String prefix = this.getResource("itemPrefix", ctx);
        String innerFillDataRefStr = this.getResource("innerFillDataRef", ctx);
        String elimTemplateRef = this.getResource("elimTemplateRef", ctx);
        String eliminationRef = this.getResource("eliminationRef", ctx);
        String passStr = this.getResource("elimUpdated", ctx);
        ArrayList<String> sqls = new ArrayList<String>();
        String l1Number = null;
        Map referenceMap = null;
        List innerFillDataRefNumList = null;
        List elimTemplateRefNumList = null;
        List eliminationRefNumList = null;
        Object workPaperRefNumList = null;
        for (int i = 0; i < level1Number.size(); ++i) {
            int j;
            int size;
            String detail_inner = "";
            String detail_elimtempalte = "";
            String detail_elimination = "";
            innerFillDataRefNumList = null;
            elimTemplateRefNumList = null;
            eliminationRefNumList = null;
            StringBuffer innerFillDataRefNum = new StringBuffer();
            StringBuffer elimTemplateRefNum = new StringBuffer();
            StringBuffer eliminationRefNum = new StringBuffer();
            l1Number = (String)level1Number.get(i);
            treeIds = this.getItemTreeIds(ctx, l1Number, orgUnitId);
            referenceMap = BgItemReferenceHelper.getElimReferencedItemNumber(ctx, treeIds);
            if (referenceMap != null) {
                innerFillDataRefNumList = (List)referenceMap.get("innerFillDataRefNums");
                elimTemplateRefNumList = (List)referenceMap.get("elimTemplateRefNums");
                eliminationRefNumList = (List)referenceMap.get("eliminationRefNums");
            }
            boolean canUpdateElim = true;
            boolean onlyUpdataRela = false;
            if (innerFillDataRefNumList != null && innerFillDataRefNumList.size() > 0) {
                size = innerFillDataRefNumList.size();
                for (j = 0; j < size; ++j) {
                    innerFillDataRefNum.append(innerFillDataRefNumList.get(j)).append(",");
                }
                if (innerFillDataRefNum.length() > 0) {
                    innerRefN = innerFillDataRefNum.substring(0, innerFillDataRefNum.lastIndexOf(","));
                    canUpdateElim = true;
                    onlyUpdataRela = true;
                    detail_inner = prefix + innerRefN + innerFillDataRefStr + "\n";
                }
            }
            if (elimTemplateRefNumList != null && elimTemplateRefNumList.size() > 0) {
                size = elimTemplateRefNumList.size();
                for (j = 0; j < size; ++j) {
                    elimTemplateRefNum.append(elimTemplateRefNumList.get(j)).append(",");
                }
                if (elimTemplateRefNum.length() > 0) {
                    elimTemRefN = elimTemplateRefNum.substring(0, elimTemplateRefNum.lastIndexOf(","));
                    canUpdateElim = true;
                    onlyUpdataRela = true;
                    detail_elimtempalte = prefix + elimTemRefN + elimTemplateRef + "\n";
                }
            }
            if (eliminationRefNumList != null && eliminationRefNumList.size() > 0) {
                size = eliminationRefNumList.size();
                for (j = 0; j < size; ++j) {
                    eliminationRefNum.append(eliminationRefNumList.get(j)).append(",");
                }
                if (eliminationRefNum.length() > 0) {
                    eliminationRefN = eliminationRefNum.substring(0, eliminationRefNum.lastIndexOf(","));
                    canUpdateElim = false;
                    detail_elimination = prefix + eliminationRefN + eliminationRef + "\n";
                }
            }
            if (canUpdateElim) {
                if (onlyUpdataRela) {
                    sqls.add("update t_bg_bgitem set FDataRela = " + dataRelaValue + " where  fLongNumber like '" + l1Number + "!%' or fnumber = '" + l1Number + "' ");
                    if (!"".equals(detail_inner)) {
                        detail = detail + detail_inner;
                    }
                    if (!"".equals(detail_elimtempalte)) {
                        detail = detail + detail_elimtempalte;
                    }
                } else {
                    sqls.add("update t_bg_bgitem set FElimType = " + elimTypeValue + " , FDataRela = " + dataRelaValue + " where  fLongNumber like '" + l1Number + "!%' or fnumber = '" + l1Number + "' ");
                    detail = detail + prefix + l1Number + passStr + "\n";
                }
                if (info == null) continue;
                String logName = info.getNumber() + " " + info.getName();
                IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"_updateElimType", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgItem_setElimiType");
                LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
                continue;
            }
            detail = detail + detail_elimination + "\n";
        }
        BgElimHelper.executeBatch(ctx, sqls);
        return detail;
    }

    @Override
    protected String _judgeRef(Context ctx, String number, String orgUnitId) throws BOSException, EASBizException {
        String res = "";
        ArrayList treeIds = null;
        Map referenceMap = null;
        List innerFillDataRefNumList = null;
        List elimTemplateRefNumList = null;
        List eliminationRefNumList = null;
        treeIds = this.getItemTreeIds(ctx, number, orgUnitId);
        referenceMap = BgItemReferenceHelper.getElimReferencedItemNumber(ctx, treeIds);
        if (referenceMap != null) {
            innerFillDataRefNumList = (List)referenceMap.get("innerFillDataRefNums");
            elimTemplateRefNumList = (List)referenceMap.get("elimTemplateRefNums");
            eliminationRefNumList = (List)referenceMap.get("eliminationRefNums");
        }
        if (eliminationRefNumList != null && eliminationRefNumList.size() > 0) {
            res = "eliminationRefNums";
        } else if (innerFillDataRefNumList != null && innerFillDataRefNumList.size() > 0 || elimTemplateRefNumList != null && elimTemplateRefNumList.size() > 0) {
            res = "innerFillDataRefNums";
        }
        return res;
    }

    private String getResource(String key, Context ctx) {
        return ResourceBase.getString((String)RES_PATH, (String)key, (Locale)ctx.getLocale());
    }

    public void dealBgItemCombinForDeleteBgItem(Context ctx, Map bgItems) throws BOSException, EASBizException {
        if (bgItems != null && !bgItems.isEmpty()) {
            int batchCount;
            Object[] params;
            ResultSet res;
            PreparedStatement pst;
            Connection conn;
            block13: {
                conn = null;
                pst = null;
                res = null;
                StringBuffer sql = new StringBuffer("Select fnumber from t_bg_bgitem where fnumber in(");
                BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
                conn = this.getConnection(ctx);
                pst = conn.prepareStatement(sql.toString());
                params = bgItems.keySet().toArray();
                batchCount = (params.length - 1) / 200 + 1;
                for (int i = 0; i < batchCount; ++i) {
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pst, (int)i, (int)200, (Object[])params);
                    res = pst.executeQuery();
                    while (res.next()) {
                        bgItems.remove(res.getString(1));
                    }
                    SQLUtils.cleanup((ResultSet)res);
                }
                SQLUtils.cleanup((Statement)pst);
                if (!bgItems.isEmpty()) break block13;
                SQLUtils.cleanup((ResultSet)res, (Statement)pst, (Connection)conn);
                return;
            }
            try {
                HashMap del = new HashMap();
                List<String> list = null;
                String number2 = null;
                String refField2 = null;
                for (String number2 : bgItems.keySet()) {
                    refField2 = (String)bgItems.get(number2);
                    if (StringUtils.isEmpty((String)refField2) || StringUtils.isEmpty((String)number2)) continue;
                    if (del.get(refField2) instanceof List) {
                        list = (List)del.get(refField2);
                    } else {
                        list = new ArrayList();
                        del.put(refField2, list);
                    }
                    list.add(number2);
                }
                bgItems.clear();
                String sqlBefore = "delete t_bg_bgitemcombination where ";
                StringBuffer sqlAfter = new StringBuffer(" in (");
                BgNSQLHelper.addPlaceHolder((StringBuffer)sqlAfter, (int)200).append(")");
                for (String refField2 : del.keySet()) {
                    list = (List)del.get(refField2);
                    pst = conn.prepareStatement(sqlBefore + refField2 + sqlAfter);
                    params = list.toArray();
                    batchCount = (params.length - 1) / 200 + 1;
                    for (int i = 0; i < batchCount; ++i) {
                        BgNSQLHelper.setParam4Batch((PreparedStatement)pst, (int)i, (int)200, (Object[])params);
                        pst.executeUpdate();
                    }
                    SQLUtils.cleanup((Statement)pst);
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, (Statement)pst, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)res, (Statement)pst, (Connection)conn);
        }
    }

    public void dealBgItemCombinForDeleteBgItem(Context ctx, BgItemCollection bgItems) throws BOSException, EASBizException {
        if (bgItems != null && !bgItems.isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>();
            String number = null;
            String refField = null;
            for (int i = 0; i < bgItems.size(); ++i) {
                number = bgItems.get(i).getNumber();
                refField = bgItems.get(i).getRefField();
                map.put(number, refField);
            }
            this.dealBgItemCombinForDeleteBgItem(ctx, map);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgItemInfo info = (BgItemInfo)super._getValue(ctx, pk);
        return info.getNumber() + " " + info.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateBgItemSuperiorValue(Context ctx, BOSUuid orgUnitID, BOSUuid bgSchemeID, List formula, BigDecimal value) throws BOSException, EASBizException {
        if (orgUnitID == null || bgSchemeID == null || formula.isEmpty() || value == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        HashMap bgItemMap = new HashMap();
        Object bgItemSupMap = null;
        Object fKey = null;
        String formulsStr2 = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgData set FBizActual = FBizActual + ?  where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String formulsStr2 : formula) {
                pstmt.setBigDecimal(1, value);
                pstmt.setString(2, orgUnitID.toString());
                pstmt.setString(3, bgSchemeID.toString());
                pstmt.setString(4, formulsStr2);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateBgItemSuperiorCtrlRecord(Context ctx, BOSUuid orgUnitID, BOSUuid bgSchemeID, List formulaList, IObjectValue record, BudgetRequestCategory category) throws BOSException {
        if (orgUnitID == null || bgSchemeID == null || formulaList.isEmpty()) {
            return;
        }
        Connection conn = null;
        HashMap bgItemMap = new HashMap();
        Object bgItemSupMap = null;
        Object fKey = null;
        StringBuffer sql = new StringBuffer();
        Object formulsStr = null;
        sql.append("select fid from T_BG_BgData  where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ?");
        BgCtrlRecordCollection ctrlRecordCol = new BgCtrlRecordCollection();
        try {
            conn = this.getConnection(ctx);
            Iterator it = formulaList.iterator();
            while (it.hasNext()) {
                String bgDataId;
                String tmp = it.next().toString();
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{orgUnitID.toString(), bgSchemeID.toString(), tmp});
                if (!rs.next() || (bgDataId = rs.getString(1)) == null) continue;
                BgCtrlResultInfo ctrlRecord = (BgCtrlResultInfo)((BgCtrlResultInfo)record).clone();
                String superItemName = this.getItemCombinName(ctx, tmp.replaceAll(",", "_"), orgUnitID.toString());
                BgCtrlRecordInfo bgCtrlRecordInfo = new BgCtrlRecordInfo();
                bgCtrlRecordInfo.setBgDataId(bgDataId);
                bgCtrlRecordInfo.setActualAmount(ctrlRecord.getReqAmount());
                bgCtrlRecordInfo.setBillId(ctrlRecord.getBillId());
                bgCtrlRecordInfo.setBillName(ctrlRecord.getBillNumber());
                bgCtrlRecordInfo.setBillNumber(ctrlRecord.getBillNumber());
                bgCtrlRecordInfo.setBillType(BudgetCtrlHelper.getTypeAllias(ctrlRecord.getBillType(), BgTraceTypeEnum.lowerOrgItemCollect));
                bgCtrlRecordInfo.setBillAlias(ctrlRecord.getBillType());
                bgCtrlRecordInfo.setBizDate(ctrlRecord.getBizDate());
                bgCtrlRecordInfo.setBgPeriodId(ctrlRecord.getBgPeriodNumber());
                bgCtrlRecordInfo.setItemName(superItemName);
                bgCtrlRecordInfo.setBgTraceType(BgTraceTypeEnum.lowerOrgItemCollect);
                bgCtrlRecordInfo.setDayDate(ctrlRecord.getBizDate());
                bgCtrlRecordInfo.setIsCollected(true);
                if (BudgetRequestCategory.CATEGORY_OCCUPATION == category) {
                    bgCtrlRecordInfo.setActualType(ActualTypeEnum.occupation);
                } else if (ctrlRecord.getActualType() != null) {
                    bgCtrlRecordInfo.setActualType(ctrlRecord.getActualType());
                } else {
                    bgCtrlRecordInfo.setActualType(ActualTypeEnum.execution);
                }
                bgCtrlRecordInfo.setBillSourceOrgunitID(ctrlRecord.getBillSourceOrgunitID());
                ctrlRecordCol.add(bgCtrlRecordInfo);
            }
            BudgetCtrlHelper.insertCtrlRecord(ctx, ctrlRecordCol);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _getSuperiorItems(Context ctx, BOSUuid orgUnitID, String formula, Set reFormulaList) throws BOSException {
        Map<String, Object> bgItemMap = new HashMap<String, Object>();
        Map bgItemSupMap = null;
        Set fKey = null;
        String[] parameter = BgSHelper.getFormulaInfo(null, formula);
        StringBuffer formulsStr = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            if (parameter != null && parameter[0] != null) {
                bgItemMap.put(parameter[0], null);
                bgItemMap = BgSHelper.getBgItemsInfo1(ctx, bgItemMap, null, null, orgUnitID.toString());
                bgItemSupMap = this.getBgItemsSuperiorInfo(ctx, bgItemMap, null, orgUnitID.toString());
                fKey = this.getSuperiorInfo(ctx, parameter[0], bgItemSupMap, conn);
                Iterator iter = fKey.iterator();
                while (iter.hasNext()) {
                    formulsStr = new StringBuffer("=BgItem(\"" + iter.next().toString() + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\"," + parameter[4] + ",\"" + parameter[5] + "\")");
                    if (formulsStr.toString().equals(formula) || reFormulaList.contains(formulsStr.toString())) continue;
                    reFormulaList.add(formulsStr.toString());
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

