/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.ma.budget.BgDimensionInfo;
import com.kingdee.eas.ma.budget.BgDimensionTypeEnum;
import com.kingdee.eas.ma.budget.BgFDCConstants;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemException;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.app.AbstractBgItemImportFacadeControllerBean;
import com.kingdee.eas.ma.budget.app.BgItemImportFacadeHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BgItemImportFacadeControllerBean
extends AbstractBgItemImportFacadeControllerBean {
    private static final long serialVersionUID = 4902775680462023083L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgItemImportFacadeControllerBean");
    private static final String BGDIMENSION_ExpenseType_FID = "21ee68fc-0108-1000-e000-0185c0a86892CFADEDB8";
    private static final String BGDIMENSION_HR_FID = "21ee34fc-0108-1000-e000-0185c0a81292CFADEDB4";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _getTreeCollection(Context ctx, IObjectValue model) throws BOSException {
        OrgUnitInfo orgInfo;
        String language = ctx.getLocale().toString();
        if (model == null) {
            return null;
        }
        TreeBaseCollection objCol = null;
        BgItemInfo dataInfo = null;
        BgItemGroupInfo bgIGInfo = null;
        BgDimensionInfo bgDimInfo = (BgDimensionInfo)model;
        objCol = new TreeBaseCollection();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(256);
        if (bgDimInfo.getDBbossType() == null) {
            sql.append("select * from " + bgDimInfo.getTreeTable());
            sql.append(" where 1 = 1 ");
            if (BGDIMENSION_HR_FID.equals(bgDimInfo.getId().toString())) {
                if (ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
                    sql.append("  and FHROrgUnitID = '" + ContextUtil.getCurrentHRUnit((Context)ctx).getId() + "'");
                } else {
                    sql.append("  and FHROrgUnitID = '0000000000000000000000'");
                }
            }
            if (bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292-FDCCBKM")) {
                sql.append(" and FIsEnabled = 1 ");
            }
            if (bgDimInfo.isTreeOu()) {
                if (bgDimInfo.getTreeOuField() != null && bgDimInfo.getTreeOuType() != null) {
                    if (BGDIMENSION_ExpenseType_FID.equals(bgDimInfo.getId().toString())) {
                        sql.append(" and " + bgDimInfo.getTreeOuField() + " in " + this.getOrgQueryStr(ctx, bgDimInfo.getTreeOuType()));
                    } else {
                        boolean isCompanyOu = ContextUtil.getCurrentOrgUnit((Context)ctx).isIsCompanyOrgUnit();
                        orgInfo = null;
                        if (isCompanyOu) {
                            orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)bgDimInfo.getTreeOuType());
                        }
                        if (orgInfo != null) {
                            sql.append(" and " + bgDimInfo.getTreeOuField() + "= '" + orgInfo.getId() + "' ");
                        } else {
                            sql.append(" and " + bgDimInfo.getTreeOuField() + "= '_'");
                        }
                    }
                }
            } else if (bgDimInfo.isDetailCu()) {
                sql.append(" and FControlUnitID = '" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId() + "'");
            } else if (BgItemImportFacadeHelper.checkD1BaseData(bgDimInfo)) {
                sql.append(" and fid in " + BgItemImportFacadeHelper.getTreeIdsForQuery(ctx, bgDimInfo));
            } else if (BgItemImportFacadeHelper.checkS4BaseData(bgDimInfo)) {
                sql.append("and FControlUnitID in " + BgItemImportFacadeHelper.getS4BaseDataIDSForQuery(ctx));
            }
            sql.append(" Order by " + bgDimInfo.getTreeOrderField());
        } else {
            sql.append("select * from " + bgDimInfo.getTreeTable());
            if (bgDimInfo.isTreeOu()) {
                if (bgDimInfo.getTreeOuField() != null && bgDimInfo.getTreeOuType() != null) {
                    if (BGDIMENSION_ExpenseType_FID.equals(bgDimInfo.getId().toString())) {
                        sql.append(" where " + bgDimInfo.getTreeOuField() + " in " + this.getOrgQueryStr(ctx, bgDimInfo.getTreeOuType()));
                    } else {
                        boolean isCompanyOu = ContextUtil.getCurrentOrgUnit((Context)ctx).isIsCompanyOrgUnit();
                        orgInfo = null;
                        if (isCompanyOu) {
                            orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)bgDimInfo.getTreeOuType());
                        }
                        if (orgInfo != null) {
                            sql.append(" where " + bgDimInfo.getTreeOuField() + "= '" + orgInfo.getId() + "' ");
                        } else {
                            sql.append(" where " + bgDimInfo.getTreeOuField() + "= '_'");
                        }
                    }
                }
            } else if (bgDimInfo.isDetailCu()) {
                String orgLongNum = ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber();
                String[] orgLongNums = orgLongNum.split("!");
                orgLongNum = BgHelper.tranArray2String(orgLongNums);
                sql.append(" where FControlUnitID in (select fid from t_org_baseunit where fnumber in " + orgLongNum + ")");
            }
            sql.append(" Order by " + bgDimInfo.getTreeOrderField());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql.toString());
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                if (rst.getString("FNumber") == null) continue;
                if (bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.DATABASE)) {
                    dataInfo = new BgItemInfo();
                    dataInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    dataInfo.setNumber(rst.getString("FNumber"));
                    dataInfo.setName(rst.getString("FName_" + language));
                    objCol.addObject((IObjectValue)dataInfo);
                    continue;
                }
                if (bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEBASE) || bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEDATA)) {
                    bgIGInfo = new BgItemGroupInfo();
                    bgIGInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    bgIGInfo.setNumber(rst.getString("FNumber"));
                    bgIGInfo.setLongNumber(rst.getString(bgDimInfo.getTreeOrderField()));
                    bgIGInfo.setName(rst.getString("FName_" + language));
                    if (bgDimInfo.getTreeOrderField().equals("FLongNumber")) {
                        bgIGInfo.setLevel(rst.getInt("FLevel"));
                        bgIGInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                        if (rst.getString("FParentID") != null) {
                            bgIGInfo.put("parentId", BOSUuid.read((String)rst.getString("FParentID")));
                        }
                    }
                    objCol.addObject((IObjectValue)bgIGInfo);
                    continue;
                }
                if (!bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREETYPE)) continue;
                bgIGInfo = new BgItemGroupInfo();
                bgIGInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgIGInfo.setNumber(rst.getString("FNumber"));
                bgIGInfo.setLongNumber(rst.getString(bgDimInfo.getTreeOrderField()));
                bgIGInfo.setName(rst.getString("FName_" + language));
                bgIGInfo.setLevel(rst.getInt("FLevel"));
                bgIGInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                if (rst.getString("FParentID") != null) {
                    bgIGInfo.put("parentId", BOSUuid.read((String)rst.getString("FParentID")));
                }
                objCol.addObject((IObjectValue)bgIGInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return objCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _getTreeCollection(Context ctx, IObjectValue model, BOSUuid type) throws BOSException {
        String language = ctx.getLocale().toString();
        if (model == null || type == null) {
            return null;
        }
        TreeBaseCollection objCol = null;
        BgItemGroupInfo bgIGInfo = null;
        BgDimensionInfo bgDimInfo = (BgDimensionInfo)model;
        objCol = new TreeBaseCollection();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(256);
        sql.append("select * from " + bgDimInfo.getTreeTable());
        sql.append(" where " + bgDimInfo.getTreeTypeField() + " = '" + type);
        if (bgDimInfo.isTreeOu()) {
            if (bgDimInfo.getTreeOuField() != null && bgDimInfo.getTreeOuType() != null) {
                if (BGDIMENSION_ExpenseType_FID.equals(bgDimInfo.getId().toString())) {
                    sql.append(" AND " + bgDimInfo.getTreeOuField() + " in " + this.getOrgQueryStr(ctx, bgDimInfo.getTreeOuType()));
                } else {
                    OrgUnitInfo orgInfo = null;
                    if (ContextUtil.getCurrentOrgUnit((Context)ctx).isIsCompanyOrgUnit()) {
                        orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)bgDimInfo.getTreeOuType());
                    }
                    if (orgInfo != null) {
                        sql.append(" AND " + bgDimInfo.getTreeOuField() + "= '" + orgInfo.getId());
                    } else {
                        sql.append(" AND " + bgDimInfo.getTreeOuField() + "= '_");
                    }
                }
            }
        } else if (bgDimInfo.isDetailCu()) {
            sql.append("' AND FControlUnitID = '" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
        }
        sql.append("' Order by " + bgDimInfo.getTreeOrderField());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql.toString());
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgIGInfo = new BgItemGroupInfo();
                bgIGInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgIGInfo.setNumber(rst.getString("FNumber"));
                bgIGInfo.setLongNumber(rst.getString("FLongNumber"));
                bgIGInfo.setName(rst.getString("FName_" + language));
                bgIGInfo.setLevel(rst.getInt("FLevel"));
                bgIGInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                if (rst.getString("FParentID") != null) {
                    bgIGInfo.put("parentId", BOSUuid.read((String)rst.getString("FParentID")));
                }
                objCol.addObject((IObjectValue)bgIGInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return objCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _getDetailCollection(Context ctx, IObjectValue model) throws BOSException {
        OrgUnitInfo orgInfo;
        String language = ctx.getLocale().toString();
        if (model == null) {
            return null;
        }
        HashMap itemN = new HashMap();
        ctx.getLocale();
        TreeBaseCollection col = null;
        BgDimensionInfo bgDimInfo = (BgDimensionInfo)model;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgItemInfo bgItemInfo = null;
        String orgLongNum = ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber();
        String[] orgLongNums = orgLongNum.split("!");
        orgLongNum = BgHelper.tranArray2String(orgLongNums);
        StringBuffer sql = new StringBuffer(256);
        if (bgDimInfo.getDBbossType() == null) {
            sql.append("select FID, FNumber, FName_" + language);
            if (bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEBASE) || bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREETYPE)) {
                sql.append(", FLongNumber, FLevel, FIsLeaf, FDisplayName_" + language);
            }
            if (bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEBASE) || bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREETYPE) || bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEDATA)) {
                sql.append("," + bgDimInfo.getDetailGroupField());
            }
            if (bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292CFADEDB1")) {
                sql.append(", FSumItemFormula");
            } else if (bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292CFADEDE8")) {
                sql.append(", FDC");
            }
            sql.append(" from " + bgDimInfo.getDetailTable());
            if (bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEBASE) || bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEDATA)) {
                sql.append(" where " + bgDimInfo.getDetailGroupField() + " IS NOT NULL ");
                if (BgItemImportFacadeHelper.checkS4BaseData(bgDimInfo)) {
                    sql.append("and FControlUnitID in " + BgItemImportFacadeHelper.getS4BaseDataIDSForQuery(ctx));
                }
                if (BgItemImportFacadeHelper.checkD1BaseData(bgDimInfo)) {
                    sql.append(" and " + bgDimInfo.getDetailGroupField() + " in " + BgItemImportFacadeHelper.getTreeIdsForQuery(ctx, bgDimInfo));
                }
                if (BGDIMENSION_HR_FID.equals(bgDimInfo.getId().toString())) {
                    if (ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
                        sql.append("AND FHROrgUnitID = '" + ContextUtil.getCurrentHRUnit((Context)ctx).getId() + "'");
                    } else {
                        sql.append("AND FHROrgUnitID = '000000000000000000000000'");
                    }
                }
                if (bgDimInfo.isDetailOu()) {
                    if (bgDimInfo.getDetailOuField() != null && bgDimInfo.getDetailOuType() != null) {
                        if (BGDIMENSION_ExpenseType_FID.equals(bgDimInfo.getId().toString())) {
                            sql.append(" AND " + bgDimInfo.getDetailOuField() + " in " + this.getOrgQueryStr(ctx, bgDimInfo.getDetailOuType()));
                        } else {
                            orgInfo = null;
                            if (ContextUtil.getCurrentOrgUnit((Context)ctx).isIsCompanyOrgUnit()) {
                                orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)bgDimInfo.getDetailOuType());
                            }
                            if (orgInfo != null) {
                                sql.append(" AND " + bgDimInfo.getDetailOuField() + "= '" + orgInfo.getId() + "'");
                            } else {
                                sql.append(" AND " + bgDimInfo.getDetailOuField() + "= '_'");
                            }
                        }
                    }
                } else if (bgDimInfo.isDetailCu()) {
                    sql.append("AND FControlUnitID = '" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId() + "'");
                }
            } else if (bgDimInfo.isDetailOu()) {
                if (bgDimInfo.getDetailOuField() != null && bgDimInfo.getDetailOuType() != null) {
                    if (BGDIMENSION_ExpenseType_FID.equals(bgDimInfo.getId().toString())) {
                        sql.append(" where " + bgDimInfo.getDetailOuField() + " in " + this.getOrgQueryStr(ctx, bgDimInfo.getDetailOuType()));
                    } else {
                        orgInfo = null;
                        if (ContextUtil.getCurrentOrgUnit((Context)ctx).isIsCompanyOrgUnit()) {
                            orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)bgDimInfo.getDetailOuType());
                        }
                        if (orgInfo != null) {
                            sql.append(" where " + bgDimInfo.getDetailOuField() + "= '" + orgInfo.getId() + "'");
                        } else {
                            sql.append(" where " + bgDimInfo.getDetailOuField() + "= '_'");
                        }
                    }
                }
            } else if (bgDimInfo.isDetailCu()) {
                sql.append(" where FControlUnitID = '" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId() + "'");
            }
            if (bgDimInfo.isHasState()) {
                sql.append(" and " + bgDimInfo.getStateField() + " = 1");
            }
            if (bgDimInfo.isDetailTree() || bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292CFADEDET")) {
                sql.append(" Order by FLongNumber");
            } else if ("21ee34fc-0108-1000-e000-0185c0a81292-FDCCBKM".equals(bgDimInfo.getId().toString())) {
                sql.append(" Order by FCodingNumber");
            } else {
                sql.append(" Order by FNumber");
            }
        } else {
            sql.append("select FID, FNumber, FName_" + language);
            if (bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEBASE) || bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREETYPE)) {
                sql.append(", FLongNumber, FLevel, FIsLeaf, FDisplayName_" + language);
            }
            if (bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEBASE) || bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREETYPE) || bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEDATA)) {
                sql.append("," + bgDimInfo.getDetailGroupField());
            }
            if (bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292CFADEDB1")) {
                sql.append(", FSumItemFormula");
            } else if (bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292CFADEDE8")) {
                sql.append(", FDC");
            }
            sql.append(" from " + bgDimInfo.getDetailTable());
            if (bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEBASE)) {
                sql.append(" where " + bgDimInfo.getDetailGroupField() + " IS NOT NULL ");
                if (BgItemImportFacadeHelper.checkD1BaseData(bgDimInfo)) {
                    sql.append(" and " + bgDimInfo.getDetailGroupField() + " in " + BgItemImportFacadeHelper.getTreeIdsForQuery(ctx, bgDimInfo));
                }
                if (bgDimInfo.isDetailOu()) {
                    if (bgDimInfo.getDetailOuField() != null && bgDimInfo.getDetailOuType() != null) {
                        if (BGDIMENSION_ExpenseType_FID.equals(bgDimInfo.getId().toString())) {
                            sql.append(" AND " + bgDimInfo.getDetailOuField() + " in " + this.getOrgQueryStr(ctx, bgDimInfo.getDetailOuType()));
                        } else {
                            orgInfo = null;
                            if (ContextUtil.getCurrentOrgUnit((Context)ctx).isIsCompanyOrgUnit()) {
                                orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)bgDimInfo.getDetailOuType());
                            }
                            if (orgInfo != null) {
                                sql.append(" AND " + bgDimInfo.getDetailOuField() + "= '" + orgInfo.getId() + "'");
                            } else {
                                sql.append(" AND " + bgDimInfo.getDetailOuField() + "= '_'");
                            }
                        }
                    }
                } else if (bgDimInfo.isDetailCu()) {
                    sql.append("AND fid in (select fdatabasedid from t_bd_databasedassign where fbosobjecttype = '" + bgDimInfo.getDBbossType().toString() + "' and fassigncuid in (select fid from t_org_baseunit where fnumber in " + orgLongNum + "))");
                    sql.append(" or FControlUnitID = '" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId() + "'");
                }
            } else {
                sql.append(" where " + bgDimInfo.getDetailGroupField() + " IS NOT NULL ");
                if (bgDimInfo.isDetailOu()) {
                    if (bgDimInfo.getDetailOuField() != null && bgDimInfo.getDetailOuType() != null) {
                        if (BGDIMENSION_ExpenseType_FID.equals(bgDimInfo.getId().toString())) {
                            sql.append(" AND " + bgDimInfo.getDetailOuField() + " in " + this.getOrgQueryStr(ctx, bgDimInfo.getDetailOuType()));
                        } else {
                            orgInfo = null;
                            if (ContextUtil.getCurrentOrgUnit((Context)ctx).isIsCompanyOrgUnit()) {
                                orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)bgDimInfo.getDetailOuType());
                            }
                            if (orgInfo != null) {
                                sql.append(" AND " + bgDimInfo.getDetailOuField() + "= '" + orgInfo.getId() + "'");
                            } else {
                                sql.append(" AND " + bgDimInfo.getDetailOuField() + "= '_'");
                            }
                        }
                    }
                } else if (bgDimInfo.isDetailCu()) {
                    sql.append("AND fid in (select fdatabasedid from t_bd_databasedassign where fbosobjecttype = '" + bgDimInfo.getDBbossType().toString() + "' and fassigncuid in (select fid from t_org_baseunit where fnumber in " + orgLongNum + "))");
                    sql.append(" or FControlUnitID = '" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId() + "'");
                }
            }
            if (bgDimInfo.isHasState()) {
                sql.append(" and " + bgDimInfo.getStateField() + " = 1");
            }
            if (bgDimInfo.isDetailTree()) {
                sql.append(" Order by FLongNumber");
            } else {
                sql.append(" Order by FNumber");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql.toString());
        }
        try {
            boolean isDetailGroupField;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            col = new TreeBaseCollection();
            boolean isHasName = this.isContainField("FName_" + language, rst);
            boolean isHasLongNumber = this.isContainField("FLongNumber", rst);
            boolean isHasLevel = this.isContainField("FLevel", rst);
            boolean isHasLeaf = this.isContainField("FIsLeaf", rst);
            boolean bl = isDetailGroupField = bgDimInfo.getDetailGroupField() == null || bgDimInfo.getDetailGroupField().equals("") ? false : this.isContainField(bgDimInfo.getDetailGroupField(), rst);
            while (rst.next()) {
                if (rst.getString("FNumber") == null) continue;
                if (bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292CFADEDET") || bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292-FDCCBKM")) {
                    if (itemN.containsKey(rst.getString("FLongNumber"))) continue;
                    itemN.put(rst.getString("FLongNumber"), null);
                } else {
                    if (itemN.containsKey(rst.getString("FID"))) continue;
                    itemN.put(rst.getString("FID"), null);
                }
                bgItemInfo = new BgItemInfo();
                bgItemInfo.setId(BOSUuid.create((BOSObjectType)bgItemInfo.getBOSType()));
                bgItemInfo.setItemID(BOSUuid.read((String)rst.getString("FID")));
                bgItemInfo.setItemNumber(rst.getString("FNumber"));
                if (isHasName) {
                    bgItemInfo.setItemName(rst.getString("FName_" + language));
                } else {
                    bgItemInfo.setItemName(rst.getString("FNumber"));
                }
                if (bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292-FDCCBKM")) {
                    bgItemInfo.setItemName(rst.getString("FDisplayName_" + language));
                }
                if (bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292CFADEDB1")) {
                    bgItemInfo.setExtendedProperty("itemType", "rpt");
                    bgItemInfo.setExtendedProperty("sumFormula", rst.getString("FSumItemFormula"));
                } else if (bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292CFADEDE8")) {
                    bgItemInfo.setExtendedProperty("itemType", "accountType");
                    bgItemInfo.setExtendedProperty("direction", Integer.toString(rst.getInt("FDC")));
                } else {
                    bgItemInfo.setExtendedProperty("itemType", "other");
                }
                bgItemInfo.setNumber(bgItemInfo.getItemNumber());
                if (isHasLongNumber) {
                    bgItemInfo.setLongNumber(rst.getString("FLongNumber"));
                } else {
                    bgItemInfo.setLongNumber(rst.getString("FNumber"));
                }
                bgItemInfo.setName(bgItemInfo.getItemName());
                if ((bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEBASE) || bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEDATA)) && isDetailGroupField) {
                    if ("FInService".equalsIgnoreCase(bgDimInfo.getDetailGroupField())) {
                        int type = rst.getInt(bgDimInfo.getDetailGroupField());
                        String groupId = null;
                        if (type == 0) {
                            groupId = "00000000-0000-0000-0000-0000000000017595DB8A";
                        } else if (type == 1) {
                            groupId = "00000000-0000-0000-0000-0000000000007595DB8A";
                        } else if (type == 2) {
                            groupId = "00000000-0000-0000-0000-0000000000027595DB8A";
                        } else if (type == 3) {
                            groupId = "00000000-0000-0000-0000-0000000000037595DB8A";
                        } else if (type == 4) {
                            groupId = "00000000-0000-0000-0000-0000000000047595DB8A";
                        }
                        bgItemInfo.put("bgItemGroupId", BOSUuid.read((String)groupId));
                    } else {
                        bgItemInfo.put("bgItemGroupId", BOSUuid.read((String)rst.getString(bgDimInfo.getDetailGroupField())));
                    }
                }
                if (bgDimInfo.isDetailTree()) {
                    if (isHasLevel) {
                        bgItemInfo.setLevel(rst.getInt("FLevel"));
                    } else {
                        bgItemInfo.setLevel(1);
                    }
                    if (isHasLeaf) {
                        bgItemInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                    } else {
                        bgItemInfo.setIsLeaf(true);
                    }
                }
                col.addObject((IObjectValue)bgItemInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return col;
    }

    private boolean isContainField(String field, ResultSet rst) throws SQLException {
        boolean result = false;
        for (int i = 1; i <= rst.getMetaData().getColumnCount(); ++i) {
            if (!rst.getMetaData().getColumnName(i).equalsIgnoreCase(field)) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _getDetailCollection(Context ctx, IObjectValue model, BOSUuid type) throws BOSException {
        String language = ctx.getLocale().toString();
        if (model == null || type == null) {
            return null;
        }
        HashMap itemN = new HashMap();
        TreeBaseCollection col = null;
        BgDimensionInfo bgDimInfo = (BgDimensionInfo)model;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgItemInfo bgItemInfo = null;
        StringBuffer sql = new StringBuffer(128);
        sql.append("select * from " + bgDimInfo.getDetailTable() + " where ");
        sql.append(bgDimInfo.getDetaiTypeField() + " = '" + type.toString() + "' AND ");
        sql.append(bgDimInfo.getDetailGroupField() + " IS NOT NULL ");
        if (bgDimInfo.isDetailOu()) {
            if (bgDimInfo.getDetailOuField() != null && bgDimInfo.getDetailOuType() != null) {
                if (BGDIMENSION_ExpenseType_FID.equals(bgDimInfo.getId().toString())) {
                    sql.append(" AND " + bgDimInfo.getDetailOuField() + " in " + this.getOrgQueryStr(ctx, bgDimInfo.getDetailOuType()));
                } else {
                    OrgUnitInfo orgInfo = null;
                    if (ContextUtil.getCurrentOrgUnit((Context)ctx).isIsCompanyOrgUnit()) {
                        orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)bgDimInfo.getDetailOuType());
                    }
                    if (orgInfo != null) {
                        sql.append(" AND " + bgDimInfo.getDetailOuField() + "= '" + orgInfo.getId() + "' ");
                    } else {
                        sql.append(" AND " + bgDimInfo.getDetailOuField() + "= '_' ");
                    }
                }
            }
        } else if (bgDimInfo.isDetailCu()) {
            sql.append("AND FControlUnitID = '" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId() + "' ");
        }
        if (bgDimInfo.isHasState()) {
            sql.append(" and " + bgDimInfo.getStateField() + " = 1");
        }
        if (bgDimInfo.isDetailTree()) {
            sql.append("Order by FLongNumber");
        } else {
            sql.append("Order by FNumber");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql.toString());
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            col = new TreeBaseCollection();
            while (rst.next()) {
                if (itemN.containsKey(rst.getString("FNumber"))) continue;
                itemN.put(rst.getString("FNumber"), null);
                bgItemInfo = new BgItemInfo();
                bgItemInfo.setId(BOSUuid.create((BOSObjectType)bgItemInfo.getBOSType()));
                bgItemInfo.setItemID(BOSUuid.read((String)rst.getString("FID")));
                bgItemInfo.setItemNumber(rst.getString("FNumber"));
                bgItemInfo.setItemName(rst.getString("FName_" + language));
                bgItemInfo.setNumber(bgItemInfo.getItemNumber());
                bgItemInfo.setName(bgItemInfo.getItemName());
                bgItemInfo.put("bgItemGroupId", BOSUuid.read((String)rst.getString(bgDimInfo.getDetailGroupField())));
                if (bgDimInfo.getDetailTable().equalsIgnoreCase("T_BD_AccountView")) {
                    bgItemInfo.setExtendedProperty("itemType", "accountType");
                    bgItemInfo.setExtendedProperty("direction", Integer.toString(rst.getInt("FDC")));
                }
                if (bgDimInfo.isDetailTree()) {
                    bgItemInfo.setLevel(rst.getInt("FLevel"));
                    bgItemInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                    bgItemInfo.setLongNumber(rst.getString("FLongNumber"));
                }
                col.addObject((IObjectValue)bgItemInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected IObjectCollection _getTypeCollection(Context ctx, IObjectValue model) throws BOSException {
        String language = ctx.getLocale().toString();
        if (model == null) {
            return null;
        }
        TreeBaseCollection typeCol = null;
        BgDimensionInfo bgDimInfo = (BgDimensionInfo)model;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgItemInfo bgTypeInfo = null;
        StringBuffer sql = new StringBuffer(128);
        boolean hasFAccountTableID = false;
        ArrayList<String> _tmpList = new ArrayList<String>();
        if ("T_BD_AccountTable".equalsIgnoreCase(bgDimInfo.getTypeTable())) {
            CompanyOrgUnitInfo orgInfo = null;
            if (ContextUtil.getCurrentOrgUnit((Context)ctx).isIsCompanyOrgUnit()) {
                orgInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            }
            String id = "_";
            if (orgInfo != null && orgInfo.getId() != null) {
                id = orgInfo.getId().toString();
            }
            sql.append("select distinct at.*,company.FAccountTableID as FAccountTableID from T_BD_AccountTable at inner join T_BD_Acct_Contorl ac on at.FID = AC.FAccountTableID left join T_ORG_Company company on AC.FDestCompanyID = company.FId  and company.FAccountTableID = at.fid  where FDestCompanyID = ? order by at.FNumber");
            _tmpList.add(id);
            hasFAccountTableID = true;
        } else {
            hasFAccountTableID = false;
            sql.append("select * from " + bgDimInfo.getTypeTable() + "  order by FNumber");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql.toString());
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            if (!_tmpList.isEmpty()) {
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            }
            rst = pstmt.executeQuery();
            typeCol = new TreeBaseCollection();
            while (rst.next()) {
                bgTypeInfo = new BgItemInfo();
                bgTypeInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgTypeInfo.setNumber(rst.getString("FNumber"));
                if (hasFAccountTableID && rst.getString("FAccountTableID") != null) {
                    bgTypeInfo.setName(rst.getString("FName_" + language) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"42_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale()));
                } else {
                    bgTypeInfo.setName(rst.getString("FName_" + language));
                }
                bgTypeInfo.setDescription(rst.getString("FDescription_" + language));
                typeCol.addObject((IObjectValue)bgTypeInfo);
            }
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return typeCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected IObjectCollection _getTreeCollectionForCSSP(Context ctx, String type) throws BOSException {
        String language = ctx.getLocale().toString();
        TreeBaseCollection objCol = null;
        BgItemGroupInfo bgIGInfo = null;
        objCol = new TreeBaseCollection();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(256);
        sql.append("select * from T_BD_CSSPGroup");
        String orgLongNum = ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber();
        String[] orgLongNums = orgLongNum.split("!");
        orgLongNum = BgHelper.tranArray2String(orgLongNums);
        sql.append(" where FControlUnitID in (select fid from t_org_baseunit where fnumber in " + orgLongNum + ")");
        sql.append(" and fcsspgroupstandardid in (select fid from t_bd_csspgroupstandard where ftype = 0 or ftype =  " + type + ")");
        sql.append(" Order by flongnumber");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql.toString());
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgIGInfo = new BgItemGroupInfo();
                bgIGInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgIGInfo.setNumber(rst.getString("FNumber"));
                bgIGInfo.setLongNumber(rst.getString("FLongNumber"));
                bgIGInfo.setName(rst.getString("FName_" + language));
                bgIGInfo.setLevel(rst.getInt("FLevel"));
                bgIGInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                if (rst.getString("FParentID") != null) {
                    bgIGInfo.put("parentId", BOSUuid.read((String)rst.getString("FParentID")));
                }
                objCol.addObject((IObjectValue)bgIGInfo);
            }
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return objCol;
    }

    private String getOrgQueryStr(Context ctx, OrgType ouType) {
        OrgUnitInfo orgInfo = null;
        StringBuffer query = new StringBuffer();
        if (ContextUtil.getCurrentOrgUnit((Context)ctx).isIsCompanyOrgUnit()) {
            orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)ouType);
        }
        if (orgInfo != null) {
            String longnumber = orgInfo.getLongNumber();
            String number = null;
            if (longnumber != null) {
                String[] numbers = longnumber.split("!");
                number = BgHelper.tranArray2String(numbers);
                query.append("( select fid from T_ORG_CostCenter where fnumber in" + number + " )");
            }
        } else {
            query.append("('_')");
        }
        return query.toString();
    }

    @Override
    protected void _dealFDCCostAccount(Context ctx) throws BOSException, EASBizException {
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)"select fid from T_BG_BGDIMENSION where fid = '21ee34fc-0108-1000-e000-0185c0a81292-FDCCBKM'");
        try {
            if (rst.next()) {
                return;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage());
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" insert into T_BG_BGDIMENSION");
        kSql.append("   (FID,");
        kSql.append("    FCREATORID,");
        kSql.append("    FCREATETIME,");
        kSql.append("    FLASTUPDATEUSERID,");
        kSql.append("    FLASTUPDATETIME,");
        kSql.append("    FCONTROLUNITID,");
        kSql.append("    FNAME_L1,");
        kSql.append("    FNAME_L2,");
        kSql.append("    FNAME_L3,");
        kSql.append("    FNUMBER,");
        kSql.append("    FDESCRIPTION_L1,");
        kSql.append("    FDESCRIPTION_L2,");
        kSql.append("    FDESCRIPTION_L3,");
        kSql.append("    FSIMPLENAME,");
        kSql.append("    FDIMTYPE,");
        kSql.append("    FTREETABLE,");
        kSql.append("    FDETAILTABLE,");
        kSql.append("    FTYPETABLE,");
        kSql.append("    FNAMEFIELD,");
        kSql.append("    FNUMBERFIELD,");
        kSql.append("    FTREETYPEFIELD,");
        kSql.append("    FDETAILGROUPFIELD,");
        kSql.append("    FDETAITYPEFIELD,");
        kSql.append("    FDETAILCU,");
        kSql.append("    FDETAILTREE,");
        kSql.append("    FTREEORDERFIELD,");
        kSql.append("    FSEQ,");
        kSql.append("    FDBBOSSTYPE)");
        kSql.append(" values");
        kSql.append("   ('21ee34fc-0108-1000-e000-0185c0a81292-FDCCBKM',");
        kSql.append("    null,");
        kSql.append("    null,");
        kSql.append("    null,");
        kSql.append("    null,");
        kSql.append("    null,");
        kSql.append("    null,");
        kSql.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"43_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale()));
        kSql.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"43_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale()));
        kSql.append("    '21ee34fc-0108-1000-e000-0185c0a81292-FDCCBKM',");
        kSql.append("    null,");
        kSql.append("    null,");
        kSql.append("    null,");
        kSql.append("    null,");
        kSql.append("    2,");
        kSql.append("    'T_FDC_CurProject',");
        kSql.append("    'T_FDC_CostAccount',");
        kSql.append("    null,");
        kSql.append("    'FDisplayName_L2',");
        kSql.append("    'FNumber',");
        kSql.append("    null,");
        kSql.append("    'FCurProject',");
        kSql.append("    null,");
        kSql.append("    0,");
        kSql.append("    0,");
        kSql.append("    'FLongNumber',");
        kSql.append("    53,");
        kSql.append("    null)");
        DbUtil.execute((Context)ctx, (String)kSql.toString());
    }

    @Override
    protected String _queryFDCBill(Context ctx, String billType, String costCenterId, String bgPeriodId) throws BOSException, EASBizException {
        IBgPeriod iPeriod = BgPeriodFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("month"));
        BgPeriodInfo periodInfo = iPeriod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriodId), sic);
        if (BgFDCConstants.FDC_YEAR_BILL_ALIAS.equals(billType)) {
            if (!BgPeriodEnum.YEAR.equals((Object)periodInfo.getPeriodType())) {
                throw new BgItemException(BgItemException.FINDFDCBILLERROR, new Object[]{periodInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"44_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale()) + billType + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"45_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale())});
            }
            StringBuffer queryYearKSql = new StringBuffer();
            queryYearKSql.append(" select budget.fid");
            queryYearKSql.append("   from T_FNC_FDCYearBudgetAcct budget");
            queryYearKSql.append("        inner join T_FDC_CurProject prj");
            queryYearKSql.append("           on budget.FProjectid = prj.fid");
            queryYearKSql.append("        inner join T_FNC_FDCBudgetPeriod period");
            queryYearKSql.append("           on budget.ffdcperiodid = period.fid");
            queryYearKSql.append("  where prj.FCostCenterId = ?");
            queryYearKSql.append("    and budget.fisLatestVer = 1");
            queryYearKSql.append("    and period.fyear = ?");
            IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)queryYearKSql.toString(), (Object[])new Object[]{costCenterId, new Integer(periodInfo.getYear())});
            try {
                if (!rst.next()) {
                    throw new BgItemException(BgItemException.FINDFDCBILLERROR, new Object[]{periodInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"44_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale()) + billType + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"45_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale())});
                }
                return rst.getString(1);
            }
            catch (SQLException ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
        }
        if (BgFDCConstants.FDC_MONTH_BILL_ALIAS.equals(billType)) {
            if (!BgPeriodEnum.MONTH.equals((Object)periodInfo.getPeriodType())) {
                throw new BgItemException(BgItemException.FINDFDCBILLERROR, new Object[]{periodInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"44_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale()) + billType + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"45_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale())});
            }
            StringBuffer queryMonthKSql = new StringBuffer();
            queryMonthKSql.append(" select budget.fid");
            queryMonthKSql.append("   from T_FNC_FDCMonthBudgetAcct budget");
            queryMonthKSql.append("        inner join T_FDC_CurProject prj ");
            queryMonthKSql.append("           on budget.fprojectid=prj.fid");
            queryMonthKSql.append("        inner join T_FNC_FDCBudgetPeriod period ");
            queryMonthKSql.append("           on period.fid=budget.ffdcperiodid");
            queryMonthKSql.append("   where prj.fcostcenterid = ? ");
            queryMonthKSql.append("     and period.fyear = ?");
            queryMonthKSql.append("     and period.fmonth = ?");
            IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)queryMonthKSql.toString(), (Object[])new Object[]{costCenterId, new Integer(periodInfo.getYear()), new Integer(periodInfo.getMonth())});
            try {
                if (!rst.next()) {
                    throw new BgItemException(BgItemException.FINDFDCBILLERROR, new Object[]{periodInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"44_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale()) + billType + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"45_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale())});
                }
                return rst.getString(1);
            }
            catch (SQLException ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
        }
        if (BgFDCConstants.FDC_EXE_BILL_ALIAS.equals(billType) && !BgPeriodEnum.MONTH.equals((Object)periodInfo.getPeriodType())) {
            throw new BgItemException(BgItemException.FINDFDCBILLERROR, new Object[]{periodInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"44_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale()) + billType + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"45_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        return null;
    }

    @Override
    protected IObjectCollection _getSpecialProcessCollection(Context ctx, String baseType, String nodeID) throws BOSException, EASBizException {
        TreeBaseCollection coll;
        block21: {
            ResultSet rst;
            PreparedStatement ps;
            Connection conn;
            StringBuffer sql;
            block22: {
                block18: {
                    block20: {
                        block17: {
                            coll = new TreeBaseCollection();
                            sql = new StringBuffer();
                            conn = null;
                            ps = null;
                            rst = null;
                            if (nodeID == null) {
                                return coll;
                            }
                            if (!"T_BD_Material".equals(baseType)) break block20;
                            sql.append("select fid,fnumber,fname_l2,flongnumber from T_BD_Material");
                            sql.append(" where FMaterialGroupID = ? and FSTATUS = ? ");
                            sql.append(" order by fnumber");
                            try {
                                conn = this.getConnection(ctx);
                                ps = conn.prepareStatement(sql.toString());
                                ps.setString(1, nodeID);
                                ps.setInt(2, 1);
                                rst = ps.executeQuery();
                                if (rst == null) break block17;
                                BgItemInfo bgItemInfo = null;
                                while (rst.next()) {
                                    bgItemInfo = new BgItemInfo();
                                    bgItemInfo.setId(BOSUuid.create((BOSObjectType)bgItemInfo.getBOSType()));
                                    bgItemInfo.setItemID(BOSUuid.read((String)rst.getString("FID")));
                                    bgItemInfo.setItemNumber(rst.getString("FNumber"));
                                    bgItemInfo.setItemName(rst.getString("fname_l2"));
                                    bgItemInfo.setLongNumber(rst.getString("flongnumber"));
                                    bgItemInfo.setName(bgItemInfo.getItemName());
                                    bgItemInfo.setNumber(bgItemInfo.getItemNumber());
                                    bgItemInfo.put("bgItemGroupId", BOSUuid.read((String)nodeID));
                                    coll.addObject((IObjectValue)bgItemInfo);
                                }
                            }
                            catch (SQLException e) {
                                try {
                                    throw new BOSException((Throwable)e);
                                }
                                catch (Throwable throwable) {
                                    SQLUtils.cleanup(rst, ps, (Connection)conn);
                                    throw throwable;
                                }
                            }
                        }
                        SQLUtils.cleanup((ResultSet)rst, (Statement)ps, (Connection)conn);
                        break block21;
                    }
                    if (!"T_BD_Customer".equals(baseType)) break block22;
                    sql.append("select fid,fnumber,fname_l2 from T_BD_Customer");
                    sql.append(" where FBrowseGroupID = ? and fcontrolunitid = ?");
                    sql.append(" order by fnumber");
                    try {
                        conn = this.getConnection(ctx);
                        ps = conn.prepareStatement(sql.toString());
                        ps.setString(1, nodeID);
                        ps.setString(2, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                        rst = ps.executeQuery();
                        if (rst == null) break block18;
                        BgItemInfo bgItemInfo = null;
                        while (rst.next()) {
                            bgItemInfo = new BgItemInfo();
                            bgItemInfo.setId(BOSUuid.create((BOSObjectType)bgItemInfo.getBOSType()));
                            bgItemInfo.setItemID(BOSUuid.read((String)rst.getString("FID")));
                            bgItemInfo.setItemNumber(rst.getString("FNumber"));
                            bgItemInfo.setItemName(rst.getString("fname_l2"));
                            bgItemInfo.setLongNumber(rst.getString("FNumber"));
                            bgItemInfo.setName(bgItemInfo.getItemName());
                            bgItemInfo.setNumber(bgItemInfo.getItemNumber());
                            bgItemInfo.put("bgItemGroupId", BOSUuid.read((String)nodeID));
                            coll.addObject((IObjectValue)bgItemInfo);
                        }
                    }
                    catch (SQLException e) {
                        try {
                            throw new BOSException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst, (Statement)ps, (Connection)conn);
                            throw throwable;
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)ps, (Connection)conn);
                break block21;
            }
            if ("T_BD_Supplier".equals(baseType)) {
                block19: {
                    sql.append("select fid,fnumber,fname_l2 from T_BD_Supplier");
                    sql.append(" where FBrowseGroupID = ? and fcontrolunitid = ?");
                    sql.append(" and FUsedstatus <> ?");
                    sql.append(" order by fnumber");
                    try {
                        conn = this.getConnection(ctx);
                        ps = conn.prepareStatement(sql.toString());
                        ps.setString(1, nodeID);
                        ps.setString(2, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                        ps.setString(3, "3");
                        rst = ps.executeQuery();
                        if (rst == null) break block19;
                        BgItemInfo bgItemInfo = null;
                        while (rst.next()) {
                            bgItemInfo = new BgItemInfo();
                            bgItemInfo.setId(BOSUuid.create((BOSObjectType)bgItemInfo.getBOSType()));
                            bgItemInfo.setItemID(BOSUuid.read((String)rst.getString("FID")));
                            bgItemInfo.setItemNumber(rst.getString("FNumber"));
                            bgItemInfo.setItemName(rst.getString("fname_l2"));
                            bgItemInfo.setLongNumber(rst.getString("FNumber"));
                            bgItemInfo.setName(bgItemInfo.getItemName());
                            bgItemInfo.setNumber(bgItemInfo.getItemNumber());
                            bgItemInfo.put("bgItemGroupId", BOSUuid.read((String)nodeID));
                            coll.addObject((IObjectValue)bgItemInfo);
                        }
                    }
                    catch (SQLException e) {
                        try {
                            throw new BOSException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst, (Statement)ps, (Connection)conn);
                            throw throwable;
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)ps, (Connection)conn);
            }
        }
        return coll;
    }
}

