/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgItemMappingObject;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.app.AbstractBgItemMappingControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BgItemMappingControllerBean
extends AbstractBgItemMappingControllerBean {
    private static final long serialVersionUID = -4689680551653762775L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgItemMappingControllerBean");

    @Override
    protected void _batchSave(Context ctx, List dataList) throws BOSException, EASBizException {
        String logName = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgItemMappingResource", (String)"batchSaveMappingInfo", (Locale)ContextUtils.getLocaleFromEnv());
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"_batchSave", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bg_itemMapping_batchSave");
        String insertSql = "insert into T_BG_BgItemMapping (FBgName,FBgNumber,FRptNumber,FRptName,FBgItemId,FID)  values(?,?,?,?,?,?)";
        String deleteSql = "delete from T_BG_BgItemMapping";
        Connection conn = null;
        PreparedStatement insertPst = null;
        Statement deleteSt = null;
        BOSObjectType bostype = this.getBOSType();
        if (dataList == null) {
            dataList = new ArrayList();
        }
        int batchSize = 250;
        int index = 0;
        try {
            conn = this.getConnection(ctx);
            insertPst = conn.prepareStatement(insertSql);
            deleteSt = conn.createStatement();
            deleteSt.execute(deleteSql);
            int maxSize = dataList.size();
            for (int i = 0; i < maxSize; ++i) {
                BgItemMappingObject itemObj = (BgItemMappingObject)dataList.get(i);
                insertPst.setString(1, itemObj.getBgName());
                insertPst.setString(2, itemObj.getBgNumber());
                insertPst.setString(3, itemObj.getRptNumber());
                insertPst.setString(4, itemObj.getRptName());
                insertPst.setString(5, itemObj.getBgFormIdStr());
                insertPst.setString(6, BOSUuid.create((BOSObjectType)bostype).toString());
                insertPst.addBatch();
                if (++index < batchSize) continue;
                insertPst.executeBatch();
                index = 0;
            }
            if (index != 0) {
                insertPst.executeBatch();
            }
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)sqle);
                throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertPst);
                SQLUtils.cleanup(deleteSt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertPst);
        SQLUtils.cleanup((Statement)deleteSt);
        SQLUtils.cleanup((Connection)conn);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    @Override
    protected List _getDataList(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select FBgName,FBgNumber,FRptNumber,FRptName,FBgItemId,FID from T_BG_BgItemMapping");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<BgItemMappingObject> list = new ArrayList<BgItemMappingObject>();
        try {
            while (row.next()) {
                BgItemMappingObject obj = new BgItemMappingObject();
                obj.setBgFormIdStr(row.getString("FBgItemId"));
                obj.setBgName(row.getString("FBgName"));
                obj.setBgNumber(row.getString("FBgNumber"));
                obj.setRptName(row.getString("FRptName"));
                obj.setRptNumber(row.getString("FRptNumber"));
                list.add(obj);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, sqle);
        }
        return list;
    }
}

