/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgOperationEnum;
import com.kingdee.eas.ma.budget.BgPastDataCollection;
import com.kingdee.eas.ma.budget.BgPastDataInfo;
import com.kingdee.eas.ma.budget.BgPastRecordCollection;
import com.kingdee.eas.ma.budget.BgPastRecordFactory;
import com.kingdee.eas.ma.budget.BgPastRecordInfo;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgPastRecord;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.app.AbstractBgPastRecordControllerBean;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgPastRecordControllerBean
extends AbstractBgPastRecordControllerBean {
    private static final long serialVersionUID = 3982416362014517974L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgPastRecordControllerBean");
    private static String noFindStr = "#";

    @Override
    protected List _getValue(Context ctx, String bgFormId, List bgNViewDataInfoList) throws BOSException, EASBizException {
        String[] items;
        ArrayList<String[]> re = new ArrayList<String[]>();
        BgNViewDataInfo bgNViewDatainfo = null;
        HashSet<String> orgSet = new HashSet<String>();
        for (int i = 0; i < bgNViewDataInfoList.size(); ++i) {
            bgNViewDatainfo = (BgNViewDataInfo)bgNViewDataInfoList.get(i);
            if (orgSet.contains(bgNViewDatainfo.getOrgUnitId())) continue;
            orgSet.add(bgNViewDatainfo.getOrgUnitId());
        }
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bgScheme.rootId"));
        sic.add(new SelectorItemInfo("bgTemplate.rootId"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        BgFormInfo curFormInfo = (BgFormInfo)iBgForm.getValue((IObjectPK)new ObjectUuidPK(bgFormId), sic);
        if (curFormInfo == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.rootId", (Object)curFormInfo.getBgScheme().getRootId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.rootId", (Object)curFormInfo.getBgTemplate().getRootId(), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(sic);
        BgFormCollection bgFormCollection = iBgForm.getBgFormCollection(view);
        HashMap<String, String> bgSchemeMap = new HashMap<String, String>();
        for (int i = 0; i < bgFormCollection.size(); ++i) {
            BgFormInfo formInfo = bgFormCollection.get(i);
            bgSchemeMap.put(formInfo.getOrgUnit().getId().toString(), formInfo.getBgScheme().getId().toString());
        }
        ArrayList<String> itemList = new ArrayList<String>();
        ArrayList<String> elementList = new ArrayList<String>();
        ArrayList<String> periodList = new ArrayList<String>();
        ArrayList<String> currencyList = new ArrayList<String>();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        for (int i = 0; i < bgNViewDataInfoList.size(); ++i) {
            bgNViewDatainfo = (BgNViewDataInfo)bgNViewDataInfoList.get(i);
            bgNViewDatainfo.setBgSchemeId((String)bgSchemeMap.get(bgNViewDatainfo.getOrgUnitId()));
            String[] parameter = BgNFSHelper.parseFormulaPara((String)bgNViewDatainfo.getFormula());
            items = parameter[0].split(",");
            for (int j = 0; j < items.length; ++j) {
                if (itemList.contains(items[j])) continue;
                itemList.add(items[j]);
            }
            if (!periodList.contains(parameter[1])) {
                periodList.add(parameter[1]);
            }
            if (!elementList.contains(parameter[2])) {
                elementList.add(parameter[2]);
            }
            if (!currencyList.contains(parameter[5])) {
                currencyList.add(parameter[5]);
            }
            parameterMap.put(bgNViewDatainfo.getFormula(), parameter);
        }
        Map itemsMap = this.getBudgetItemInfo(ctx, itemList, curFormInfo.getOrgUnit().getId().toString());
        Map periodMap = this.getBudgetPeriodInfo(ctx, periodList);
        Map elementMap = this.getBudgetElementInfo(ctx, elementList);
        Map currencyMap = this.getBudgetCurrencyInfo(ctx, currencyList);
        Map orgMap = this.getBudgetOrgInfo(ctx, new ArrayList(orgSet));
        StringBuffer sql = new StringBuffer();
        sql.append("select pastRecord.FPastSource,pastData.FBalance,pastData.FPastValue,pastData.FAdjustorId,pastData.FAdjustTime,pastRecord.FCreatorId,pastRecord.FCreateTime,pastData.FAdjReason,bgData.FID,bgData.FFormula ,bgData.ForgUnitId  from t_bg_bgPastData pastData inner join t_bg_bgdata bgData on pastData.fbgdataId = bgData.fid inner join t_bg_bgpastrecord pastRecord on pastData.fpastRecordId = pastRecord.fid  where pastRecord.FPastSource != 6 and  (( bgData.ForgUnitId = ? and bgData.FBgSchemeId = ? and bgData.FFormula = ?)");
        int index = 0;
        int batchNum = 50;
        int size = bgNViewDataInfoList.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        int decimal = 8;
        for (index = 2; index < batchNum; ++index) {
            sql.append(" or (bgData.ForgUnitId = ? and bgData.FBgSchemeId = ? and bgData.FFormula = ?) ");
        }
        sql.append(" or (bgData.ForgUnitId = ? and bgData.FBgSchemeId = ? and bgData.FFormula = ?))");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            DateFormat format = BgNationalFormatUIUtil.getNationalDateFormat(ctx);
            for (index = 0; index < count; ++index) {
                int k = 0;
                while (k < batchNum) {
                    if (pos < size) {
                        pstmt.setString(k * 3 + 1, ((BgNViewDataInfo)bgNViewDataInfoList.get(pos)).getOrgUnitId());
                        pstmt.setString(k * 3 + 2, ((BgNViewDataInfo)bgNViewDataInfoList.get(pos)).getBgSchemeId());
                        pstmt.setString(k * 3 + 3, ((BgNViewDataInfo)bgNViewDataInfoList.get(pos)).getFormula());
                    } else {
                        pstmt.setString(k * 3 + 1, noFindStr);
                        pstmt.setString(k * 3 + 2, noFindStr);
                        pstmt.setString(k * 3 + 3, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    String[] adjustInfo = new String[14];
                    String formula = rst.getString(10);
                    String[] parameter = (String[])parameterMap.get(formula);
                    items = parameter[0].split(",");
                    adjustInfo[0] = ((CostCenterOrgUnitInfo)orgMap.get(rst.getString(11))).getName();
                    for (int j = 0; j < items.length; ++j) {
                        adjustInfo[1] = j == 0 ? items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName() : adjustInfo[1] + ";" + items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName();
                    }
                    adjustInfo[2] = ((BgElementInfo)elementMap.get(parameter[2])).getName();
                    adjustInfo[3] = ((BgPeriodInfo)periodMap.get(parameter[1])).getName();
                    adjustInfo[4] = rst.getString(1);
                    switch (Integer.parseInt(rst.getString(1))) {
                        case 1: {
                            adjustInfo[4] = BgPastSourceEnum.ADJUST.getAlias();
                            break;
                        }
                        case 2: {
                            adjustInfo[4] = BgPastSourceEnum.COLLECT.getAlias();
                            break;
                        }
                        case 3: {
                            adjustInfo[4] = BgPastSourceEnum.ADJUSTBILL.getAlias();
                            break;
                        }
                        case 4: {
                            adjustInfo[4] = BgPastSourceEnum.SCHEME.getAlias();
                            break;
                        }
                        case 6: {
                            adjustInfo[4] = BgPastSourceEnum.WFAUDITADJUST.getAlias();
                            break;
                        }
                        case 5: {
                            adjustInfo[4] = BgPastSourceEnum.DECOMPOSER.getAlias();
                            break;
                        }
                        case 7: {
                            adjustInfo[4] = BgPastSourceEnum.PERIODDEC.getAlias();
                            break;
                        }
                        case 8: {
                            adjustInfo[4] = BgPastSourceEnum.PERIODADJUSTED.getAlias();
                            break;
                        }
                        case 9: {
                            adjustInfo[4] = BgPastSourceEnum.COURSE.getAlias();
                        }
                    }
                    decimal = ((CurrencyInfo)currencyMap.get(parameter[5])).getPrecision();
                    adjustInfo[5] = rst.getBigDecimal(2).setScale(decimal, 4).toString();
                    adjustInfo[6] = rst.getBigDecimal(2).add(rst.getBigDecimal(3)).setScale(decimal, 4).toString();
                    adjustInfo[7] = rst.getBigDecimal(3).setScale(decimal, 4).toString();
                    UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo("select * where id ='" + rst.getString(4) + "'");
                    adjustInfo[8] = user.getName();
                    adjustInfo[9] = format.format(rst.getDate(5));
                    user = UserFactory.getLocalInstance((Context)ctx).getUserInfo("select * where id ='" + rst.getString(6) + "'");
                    adjustInfo[10] = user.getName();
                    adjustInfo[11] = format.format(rst.getDate(7));
                    adjustInfo[12] = rst.getString(8);
                    adjustInfo[13] = rst.getString(9);
                    re.add(adjustInfo);
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return re;
    }

    @Override
    protected List _getValue(Context ctx, BOSUuid id, String formulaString) throws BOSException, EASBizException {
        int i;
        if (id == null) {
            return new ArrayList();
        }
        ArrayList<String[]> re = new ArrayList<String[]>();
        String formula2 = null;
        String formulaIdString = null;
        BgFormInfo formInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(id));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgFormId", (Object)id.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pastSource", (Object)BgPastSourceEnum.WFAUDITADJUST, CompareType.NOTEQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bgFormId"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("pastDatas.*"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemInfo sort = new SorterItemInfo("CreateTime");
        sort.setSortType(SortType.DESCEND);
        view.getSorter().add(sort);
        BgPastRecordInfo info = null;
        BgPastRecordCollection col = null;
        BgPastDataInfo bgDataInfo = null;
        BgPastDataCollection bgDataCol = null;
        IBgPastRecord bgPastRecord = BgPastRecordFactory.getLocalInstance(ctx);
        if (bgPastRecord == null) {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
        col = bgPastRecord.getBgPastRecordCollection(view);
        if (col.isEmpty()) {
            return re;
        }
        HashMap parameterMap = new HashMap();
        ArrayList<String> formulaIdList = new ArrayList<String>();
        ArrayList<String> itemList = new ArrayList<String>();
        ArrayList<String> elementList = new ArrayList<String>();
        ArrayList<String> periodList = new ArrayList<String>();
        ArrayList<String> currencyList = new ArrayList<String>();
        String[] parameter = null;
        String[] items = null;
        String[] adjustInfo = null;
        String nameString = null;
        String createTime = null;
        String sourceString = null;
        int decimal = 8;
        int xn = col.size();
        for (int x = 0; x < xn; ++x) {
            info = col.get(x);
            bgDataCol = info.getPastDatas();
            int n = bgDataCol.size();
            for (i = 0; i < n; ++i) {
                bgDataInfo = bgDataCol.get(i);
                formulaIdString = bgDataInfo.getBgData();
                formulaIdList.add(formulaIdString);
                if (StringUtils.isEmpty((String)bgDataInfo.getFormula())) continue;
                formula2 = bgDataInfo.getFormula();
                this.getFormulaInfo(parameterMap, formula2);
            }
        }
        Map formulInfo = this.getFormulaInfo(ctx, formulaIdList, parameterMap);
        if (!parameterMap.isEmpty()) {
            for (String formula2 : parameterMap.keySet()) {
                if (!StringUtils.isEmpty((String)formulaString)) {
                    if (!formula2.equals(formulaString)) continue;
                    parameter = this.getFormulaInfo(parameterMap, formula2);
                    items = parameter[0].split(",");
                    for (i = 0; i < items.length; ++i) {
                        itemList.add(items[i]);
                    }
                    periodList.add(parameter[1]);
                    elementList.add(parameter[2]);
                    currencyList.add(parameter[5]);
                    continue;
                }
                parameter = this.getFormulaInfo(parameterMap, formula2);
                items = parameter[0].split(",");
                for (i = 0; i < items.length; ++i) {
                    itemList.add(items[i]);
                }
                periodList.add(parameter[1]);
                elementList.add(parameter[2]);
                currencyList.add(parameter[5]);
            }
            Map itemsMap = this.getBudgetItemInfo(ctx, itemList, formInfo.getOrgUnit().getId().toString());
            Map periodMap = this.getBudgetPeriodInfo(ctx, periodList);
            Map elementMap = this.getBudgetElementInfo(ctx, elementList);
            Map currencyMap = this.getBudgetCurrencyInfo(ctx, currencyList);
            DateFormat dateFormat = BgNationalFormatUIUtil.getNationalDateFormat(ctx);
            int xn2 = col.size();
            for (int x = 0; x < xn2; ++x) {
                info = col.get(x);
                nameString = info.getCreator().getName();
                createTime = dateFormat.format(new Date(info.getCreateTime().getTime()));
                sourceString = info.getPastSource().getAlias();
                bgDataCol = info.getPastDatas();
                int n = bgDataCol.size();
                for (int i2 = 0; i2 < n; ++i2) {
                    int j;
                    bgDataInfo = bgDataCol.get(i2);
                    formulaIdString = bgDataInfo.getBgData();
                    formula2 = !StringUtils.isEmpty((String)bgDataInfo.getFormula()) ? bgDataInfo.getFormula() : (String)formulInfo.get(formulaIdString);
                    if (formulaString != null && formulaString.trim().length() > 0) {
                        if (formula2 == null || !formula2.equals(formulaString)) continue;
                        parameter = (String[])parameterMap.get(formula2);
                        adjustInfo = new String[14];
                        items = parameter[0].split(",");
                        for (j = 0; j < items.length; ++j) {
                            adjustInfo[1] = j == 0 ? items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName() : adjustInfo[1] + ";" + items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName();
                        }
                        adjustInfo[2] = ((BgElementInfo)elementMap.get(parameter[2])).getName();
                        adjustInfo[3] = ((BgPeriodInfo)periodMap.get(parameter[1])).getName();
                        adjustInfo[4] = sourceString;
                        decimal = ((CurrencyInfo)currencyMap.get(parameter[5])).getPrecision();
                        if (bgDataInfo.getBalance() != null) {
                            adjustInfo[5] = bgDataInfo.getBalance().setScale(decimal, 4).toString();
                        }
                        adjustInfo[6] = bgDataInfo.getBalance() == null ? (bgDataInfo.getPastValue() == null ? "" : bgDataInfo.getPastValue().setScale(decimal, 4).toString()) : (bgDataInfo.getPastValue() == null ? bgDataInfo.getBalance().setScale(decimal, 4).toString() : bgDataInfo.getBalance().add(bgDataInfo.getPastValue()).setScale(decimal, 4).toString());
                        if (bgDataInfo.getPastValue() != null) {
                            adjustInfo[7] = bgDataInfo.getPastValue().setScale(decimal, 4).toString();
                        }
                        if (bgDataInfo.getAdjustor() != null) {
                            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo("select * where id ='" + bgDataInfo.getAdjustor().getId().toString() + "'");
                            adjustInfo[8] = user.getName();
                        }
                        if (bgDataInfo.getAdjusttime() != null) {
                            adjustInfo[9] = dateFormat.format(new Date(bgDataInfo.getAdjusttime().getTime()));
                        }
                        adjustInfo[10] = nameString;
                        adjustInfo[11] = createTime;
                        adjustInfo[12] = bgDataInfo.getAdjReason();
                        adjustInfo[13] = formulaIdString;
                        re.add(adjustInfo);
                        continue;
                    }
                    if (formula2 == null || formula2.trim().length() <= 0 || (parameter = (String[])parameterMap.get(formula2)) == null || parameter[0] == null || parameter[0].trim().length() <= 0) continue;
                    adjustInfo = new String[14];
                    items = parameter[0].split(",");
                    for (j = 0; j < items.length; ++j) {
                        adjustInfo[1] = j == 0 ? items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName() : adjustInfo[1] + ";" + items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName();
                    }
                    adjustInfo[2] = ((BgElementInfo)elementMap.get(parameter[2])).getName();
                    adjustInfo[3] = ((BgPeriodInfo)periodMap.get(parameter[1])).getName();
                    adjustInfo[4] = sourceString;
                    decimal = ((CurrencyInfo)currencyMap.get(parameter[5])).getPrecision();
                    if (bgDataInfo.getBalance() != null) {
                        adjustInfo[5] = bgDataInfo.getBalance().setScale(decimal, 4).toString();
                    }
                    adjustInfo[6] = bgDataInfo.getBalance() == null ? (bgDataInfo.getPastValue() == null ? "" : bgDataInfo.getPastValue().setScale(decimal, 4).toString()) : (bgDataInfo.getPastValue() == null ? bgDataInfo.getBalance().setScale(decimal, 4).toString() : bgDataInfo.getBalance().add(bgDataInfo.getPastValue()).setScale(decimal, 4).toString());
                    if (bgDataInfo.getPastValue() != null) {
                        adjustInfo[7] = bgDataInfo.getPastValue().setScale(decimal, 4).toString();
                    }
                    if (bgDataInfo.getAdjustor() != null) {
                        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo("select * where id ='" + bgDataInfo.getAdjustor().getId().toString() + "'");
                        adjustInfo[8] = user.getName();
                    }
                    if (bgDataInfo.getAdjusttime() != null) {
                        adjustInfo[9] = dateFormat.format(new Date(bgDataInfo.getAdjusttime().getTime()));
                    }
                    adjustInfo[10] = nameString;
                    adjustInfo[11] = createTime;
                    adjustInfo[12] = bgDataInfo.getAdjReason();
                    adjustInfo[13] = formulaIdString;
                    re.add(adjustInfo);
                }
            }
        }
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getFormulaInfo(Context ctx, List formulasId, Map parameterMap) throws BOSException, EASBizException {
        if (ctx == null) return new HashMap();
        if (formulasId == null) return new HashMap();
        if (formulasId.isEmpty()) {
            return new HashMap();
        }
        int index = 0;
        int batchNum = 50;
        int size = formulasId.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        HashMap<String, String> formulaMap = new HashMap<String, String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String fid = null;
        String fformula = null;
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FFormula from T_BG_BgData where FID IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int k = 1; k <= batchNum; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k, (String)formulasId.get(pos));
                        continue;
                    }
                    pstmt.setString(k, noFindStr);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    fid = rst.getString(1);
                    fformula = rst.getString(2);
                    if (!formulaMap.containsKey(fid)) {
                        formulaMap.put(fid, fformula);
                    }
                    this.getFormulaInfo(parameterMap, fformula);
                }
                rst.close();
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2.getMessage());
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return formulaMap;
    }

    protected boolean isUpgrade(Context ctx) throws Exception {
        return BgItemFacadeFactory.getLocalInstance(ctx).checkIsUpgrade();
    }

    private Map getBudgetItemInfo(Context ctx, List items, String orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || items == null || items.isEmpty()) {
            return new HashMap();
        }
        String number = null;
        HashMap<String, BgItemInfo> itemsMap = new HashMap<String, BgItemInfo>();
        HashSet<String> numberSet = new HashSet<String>();
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            number = (String)items.get(i);
            numberSet.add(number);
        }
        BgItemInfo info = null;
        BgItemCollection col = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(ctx, orgUnitId), CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        view.setFilter(filter);
        try {
            IBgItem bgItem = BgItemFactory.getLocalInstance(ctx);
            if (bgItem == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            col = bgItem.getBgItemCollection(view);
            int n2 = col.size();
            for (int i = 0; i < n2; ++i) {
                info = col.get(i);
                if (!itemsMap.containsKey(info.getNumber())) {
                    // empty if block
                }
                itemsMap.put(info.getNumber(), info);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        finally {
            if (numberSet != null) {
                numberSet.clear();
            }
        }
        return itemsMap;
    }

    @Override
    public Map _getBudgetOrgInfo(Context ctx, List orgUnits) throws BOSException, EASBizException {
        if (ctx == null || orgUnits == null || orgUnits.isEmpty()) {
            return new HashMap();
        }
        String number = null;
        HashMap<String, CostCenterOrgUnitInfo> orgMap = new HashMap<String, CostCenterOrgUnitInfo>();
        HashSet<String> numberSet = new HashSet<String>();
        int n = orgUnits.size();
        for (int i = 0; i < n; ++i) {
            number = (String)orgUnits.get(i);
            numberSet.add(number);
        }
        CostCenterOrgUnitInfo info = null;
        CostCenterOrgUnitCollection col = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", numberSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        view.setFilter(filter);
        ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        col = iCostCenterOrgUnit.getCostCenterOrgUnitCollection(view);
        int n2 = col.size();
        for (int i = 0; i < n2; ++i) {
            info = col.get(i);
            if (!orgMap.containsKey(info.getNumber())) {
                // empty if block
            }
            orgMap.put(info.getId().toString(), info);
        }
        return orgMap;
    }

    private Map getBudgetElementInfo(Context ctx, List elements) throws BOSException, EASBizException {
        if (ctx == null || elements == null || elements.isEmpty()) {
            return new HashMap();
        }
        String number = null;
        HashMap<String, BgElementInfo> elementMap = new HashMap<String, BgElementInfo>();
        HashSet<String> numberSet = new HashSet<String>();
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            number = (String)elements.get(i);
            numberSet.add(number);
        }
        BgElementInfo info = null;
        BgElementCollection col = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        view.setFilter(filter);
        try {
            IBgElement bgElement = BgElementFactory.getLocalInstance(ctx);
            if (bgElement == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            col = bgElement.getBgElementCollection(view);
            int n2 = col.size();
            for (int i = 0; i < n2; ++i) {
                info = col.get(i);
                if (!elementMap.containsKey(info.getNumber())) {
                    // empty if block
                }
                elementMap.put(info.getNumber(), info);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        finally {
            if (numberSet != null) {
                numberSet.clear();
            }
        }
        return elementMap;
    }

    private Map getBudgetCurrencyInfo(Context ctx, List currency) throws BOSException, EASBizException {
        if (ctx == null || currency == null || currency.isEmpty()) {
            return new HashMap();
        }
        String number = null;
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        HashSet<String> numberSet = new HashSet<String>();
        int n = currency.size();
        for (int i = 0; i < n; ++i) {
            number = (String)currency.get(i);
            numberSet.add(number);
        }
        CurrencyInfo info = null;
        CurrencyCollection col = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("precision"));
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        view.setFilter(filter);
        try {
            ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            if (icurrency == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            col = icurrency.getCurrencyCollection(view);
            int n2 = col.size();
            for (int i = 0; i < n2; ++i) {
                info = col.get(i);
                if (!currencyMap.containsKey(info.getNumber())) {
                    // empty if block
                }
                currencyMap.put(info.getNumber(), info);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        return currencyMap;
    }

    private Map getBudgetPeriodInfo(Context ctx, List periods) throws BOSException, EASBizException {
        if (ctx == null || periods == null || periods.isEmpty()) {
            return new HashMap();
        }
        String number = null;
        HashMap<String, BgPeriodInfo> periodMap = new HashMap<String, BgPeriodInfo>();
        HashSet<String> numberSet = new HashSet<String>();
        int n = periods.size();
        for (int i = 0; i < n; ++i) {
            number = (String)periods.get(i);
            numberSet.add(number);
        }
        BgPeriodInfo info = null;
        BgPeriodCollection col = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        view.setFilter(filter);
        try {
            IBgPeriod bgPeriod = BgPeriodFactory.getLocalInstance(ctx);
            if (bgPeriod == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            col = bgPeriod.getBgPeriodCollection(view);
            int n2 = col.size();
            for (int i = 0; i < n2; ++i) {
                info = col.get(i);
                if (!periodMap.containsKey(info.getNumber())) {
                    // empty if block
                }
                periodMap.put(info.getNumber(), info);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        finally {
            if (numberSet != null) {
                numberSet.clear();
            }
        }
        return periodMap;
    }

    protected String[] getFormulaInfo(Map map, String formulaString) {
        if (map == null || formulaString == null) {
            return null;
        }
        String[] parameter = null;
        List formulaHint = null;
        FormulaHint formulas = null;
        if (map.containsKey(formulaString)) {
            parameter = (String[])map.get(formulaString);
        } else {
            try {
                formulaHint = TableToolkit.parseFormula((String)formulaString, (boolean)false);
            }
            catch (ParserException ex) {
                logger.error((Object)ex.getMessage());
            }
            if (formulaHint != null) {
                formulas = (FormulaHint)formulaHint.get(0);
                parameter = formulas.getParams();
                map.put(formulaString, parameter);
                formulaHint.clear();
            }
        }
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getValue(Context ctx, Map adjustMap, String formula) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String loc = BgPastRecordControllerBean.getLoc(ctx);
        Vector<String> AdjustorName = new Vector<String>();
        DateFormat format = BgNationalFormatUIUtil.getNationalDateFormat(ctx);
        if (adjustMap == null || adjustMap.isEmpty()) {
            return new ArrayList();
        }
        if (formula != null && formula.trim().length() > 0 && !adjustMap.containsKey(formula)) {
            return new ArrayList();
        }
        ArrayList<String[]> re = new ArrayList<String[]>();
        HashMap parameterMap = new HashMap();
        ArrayList<String> itemList = new ArrayList<String>();
        ArrayList<String> elementList = new ArrayList<String>();
        ArrayList<String> periodList = new ArrayList<String>();
        ArrayList<String> currencyList = new ArrayList<String>();
        String formulaString2 = null;
        String[] parameter = null;
        String[] items = null;
        String[] adjustInfo = null;
        String adjustor = null;
        String adjustTime = null;
        BgFormDiversityData date = null;
        int decimal = 10;
        if (formula != null && formula.trim().length() > 0) {
            parameter = this.getFormulaInfo(parameterMap, formula);
            items = parameter[0].split(",");
            if (parameter[0] != null && parameter[0].trim().length() > 0 && parameter[1] != null && parameter[1].trim().length() > 0 && parameter[2] != null && parameter[2].trim().length() > 0 && parameter[5] != null && parameter[5].trim().length() > 0) {
                for (int i = 0; i < items.length; ++i) {
                    itemList.add(items[i]);
                }
                periodList.add(parameter[1]);
                elementList.add(parameter[2]);
                currencyList.add(parameter[5]);
            }
        } else {
            for (String formulaString2 : adjustMap.keySet()) {
                parameter = this.getFormulaInfo(parameterMap, formulaString2);
                items = parameter[0].split(",");
                if (parameter[0] == null || parameter[0].trim().length() <= 0 || parameter[1] == null || parameter[1].trim().length() <= 0 || parameter[2] == null || parameter[2].trim().length() <= 0 || parameter[5] == null || parameter[5].trim().length() <= 0) continue;
                for (int i = 0; i < items.length; ++i) {
                    itemList.add(items[i]);
                }
                periodList.add(parameter[1]);
                elementList.add(parameter[2]);
                currencyList.add(parameter[5]);
            }
        }
        String orgUnitId = BgSHelper.getIsolateOrg(ctx, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString());
        Map itemsMap = this.getBudgetItemInfo(ctx, itemList, orgUnitId);
        Map periodMap = this.getBudgetPeriodInfo(ctx, periodList);
        Map elementMap = this.getBudgetElementInfo(ctx, elementList);
        Map currencyMap = this.getBudgetCurrencyInfo(ctx, currencyList);
        if (formula != null && formula.trim().length() > 0) {
            if (parameter != null && parameter[0] != null && parameter[0].trim() != null && parameter[0].trim().length() > 0 && parameter[1] != null && parameter[1].trim().length() > 0 && parameter[2] != null && parameter[2].trim().length() > 0 && parameter[5] != null && parameter[5].trim().length() > 0) {
                date = (BgFormDiversityData)adjustMap.get(formula);
                parameter = this.getFormulaInfo(parameterMap, formula);
                adjustor = date.getAdjustor();
                adjustTime = format.format(new Date(date.getAdjustTime().getTime()));
                try {
                    conn = this.getConnection(ctx);
                    String sqlcolumn = "Fname_" + loc;
                    String sql = "select FName_" + loc + " from t_pm_user where fid = '" + adjustor + "'";
                    pstmt = conn.prepareStatement(sql);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        AdjustorName.add(rs.getString(sqlcolumn).toString());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
                }
                adjustInfo = new String[13];
                items = parameter[0].split(",");
                for (int j = 0; j < items.length; ++j) {
                    adjustInfo[0] = j == 0 ? items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName() : adjustInfo[0] + ";" + items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName();
                }
                adjustInfo[1] = ((BgElementInfo)elementMap.get(parameter[2])).getName();
                adjustInfo[2] = ((BgPeriodInfo)periodMap.get(parameter[1])).getName();
                adjustInfo[3] = BgOperationEnum.ADJUST.getAlias();
                decimal = ((CurrencyInfo)currencyMap.get(parameter[5])).getPrecision();
                adjustInfo[4] = date.getOldValue() != null ? date.getOldValue().setScale(decimal, 4).toString() : "";
                adjustInfo[5] = date.getNewValue() != null ? date.getNewValue().setScale(decimal, 4).toString() : "";
                adjustInfo[6] = date.getOldValue() == null ? (date.getNewValue() == null ? "" : date.getNewValue().setScale(decimal, 4).toString()) : (date.getNewValue() == null ? "" : date.getNewValue().subtract(date.getOldValue()).setScale(decimal, 4).toString());
                adjustInfo[7] = AdjustorName != null && AdjustorName.size() != 0 ? (AdjustorName.get(0) == null ? "" : (String)AdjustorName.get(0)) : "";
                adjustInfo[8] = adjustTime;
                adjustInfo[9] = "";
                adjustInfo[10] = "";
                adjustInfo[11] = ((BgAdjustFormDiversityData)date).getAdjustReson();
                adjustInfo[12] = formulaString2;
                re.add(adjustInfo);
            }
        } else {
            for (String formulaString2 : adjustMap.keySet()) {
                date = (BgFormDiversityData)adjustMap.get(formulaString2);
                parameter = this.getFormulaInfo(parameterMap, formulaString2);
                adjustor = date.getAdjustor();
                if (date.getAdjustTime() != null) {
                    adjustTime = format.format(new Date(date.getAdjustTime().getTime()));
                }
                try {
                    conn = this.getConnection(ctx);
                    String sqlcolumn = "Fname_" + loc;
                    String sql = "select FName_" + loc + " from t_pm_user where fid = '" + adjustor + "'";
                    pstmt = conn.prepareStatement(sql);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        AdjustorName.add(rs.getString(sqlcolumn).toString());
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
                }
                catch (Exception e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                finally {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                }
                adjustInfo = new String[13];
                items = parameter[0].split(",");
                for (int j = 0; j < items.length; ++j) {
                    adjustInfo[0] = j == 0 ? items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName() : adjustInfo[0] + ";" + items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName();
                }
                adjustInfo[1] = ((BgElementInfo)elementMap.get(parameter[2])).getName();
                adjustInfo[2] = ((BgPeriodInfo)periodMap.get(parameter[1])).getName();
                adjustInfo[3] = BgOperationEnum.ADJUST.getAlias();
                decimal = ((CurrencyInfo)currencyMap.get(parameter[5])).getPrecision();
                adjustInfo[4] = date.getOldValue() != null ? date.getOldValue().setScale(decimal, 4).toString() : "";
                adjustInfo[5] = date.getNewValue() != null ? date.getNewValue().setScale(decimal, 4).toString() : "";
                adjustInfo[6] = date.getOldValue() == null ? (date.getNewValue() == null ? "" : date.getNewValue().setScale(decimal, 4).toString()) : (date.getNewValue() == null ? "" : date.getNewValue().subtract(date.getOldValue()).setScale(decimal, 4).toString());
                adjustInfo[7] = AdjustorName != null && AdjustorName.size() != 0 ? (AdjustorName.get(0) == null ? "" : (String)AdjustorName.get(0)) : "";
                adjustInfo[8] = adjustTime;
                adjustInfo[9] = "";
                adjustInfo[10] = "";
                adjustInfo[11] = date instanceof BgAdjustFormDiversityData ? ((BgAdjustFormDiversityData)date).getAdjustReson() : null;
                adjustInfo[12] = formulaString2;
                re.add(adjustInfo);
            }
        }
        return re;
    }

    @Override
    protected List _getValue(Context ctx, BOSUuid formID, BOSUuid orgUnitID, BOSUuid bgSchemeID, String formulaString) throws BOSException, EASBizException {
        if (orgUnitID == null || bgSchemeID == null || formulaString == null) {
            return null;
        }
        ArrayList<String[]> re = new ArrayList<String[]>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String formulaId = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select * from T_BG_BgData where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula = ?");
            pstmt.setString(1, orgUnitID.toString());
            pstmt.setString(2, bgSchemeID.toString());
            pstmt.setString(3, formulaString);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                formulaId = rst.getString("FID");
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgFormId", (Object)formID.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("bgFormId"));
        selector.add(new SelectorItemInfo("creator.id"));
        selector.add(new SelectorItemInfo("creator.name"));
        selector.add(new SelectorItemInfo("pastDatas.*"));
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        SorterItemInfo sort = new SorterItemInfo("CreateTime");
        sort.setSortType(SortType.DESCEND);
        view.getSorter().add(sort);
        BgPastRecordInfo info = null;
        BgPastRecordCollection col = null;
        BgPastDataInfo bgDataInfo = null;
        BgPastDataCollection bgDataCol = null;
        IBgPastRecord bgPastRecord = BgPastRecordFactory.getLocalInstance(ctx);
        if (bgPastRecord == null) {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
        col = bgPastRecord.getBgPastRecordCollection(view);
        if (col.isEmpty()) {
            return re;
        }
        HashMap parameterMap = new HashMap();
        ArrayList<String> itemList = new ArrayList<String>();
        ArrayList<String> elementList = new ArrayList<String>();
        ArrayList<String> periodList = new ArrayList<String>();
        ArrayList<String> currencyList = new ArrayList<String>();
        String[] parameter = null;
        String[] items = null;
        String[] adjustInfo = null;
        String nameString = null;
        String createTime = null;
        String sourceString = null;
        int decimal = 8;
        parameter = this.getFormulaInfo(parameterMap, formulaString);
        items = parameter[0].split(",");
        for (int i = 0; i < items.length; ++i) {
            itemList.add(items[i]);
        }
        periodList.add(parameter[1]);
        elementList.add(parameter[2]);
        currencyList.add(parameter[5]);
        Map itemsMap = null;
        itemsMap = this.getBudgetItemInfo(ctx, itemList, BgSHelper.getIsolateOrg(ctx, orgUnitID.toString()));
        Map periodMap = this.getBudgetPeriodInfo(ctx, periodList);
        Map elementMap = this.getBudgetElementInfo(ctx, elementList);
        Map currencyMap = this.getBudgetCurrencyInfo(ctx, currencyList);
        DateFormat dateFormat = BgNationalFormatUIUtil.getNationalDateFormat(ctx);
        int xn = col.size();
        for (int x = 0; x < xn; ++x) {
            info = col.get(x);
            nameString = info.getCreator().getName();
            createTime = dateFormat.format(new Date(info.getCreateTime().getTime()));
            sourceString = info.getPastSource().getAlias();
            bgDataCol = info.getPastDatas();
            int n = bgDataCol.size();
            for (int i = 0; i < n; ++i) {
                bgDataInfo = bgDataCol.get(i);
                if (!StringUtils.isEmpty((String)bgDataInfo.getFormula()) ? !bgDataInfo.getFormula().equals(formulaString) : bgDataInfo.getBgData() == null || !bgDataInfo.getBgData().equals(formulaId)) continue;
                adjustInfo = new String[13];
                items = parameter[0].split(",");
                for (int j = 0; j < items.length; ++j) {
                    adjustInfo[0] = j == 0 ? items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName() : adjustInfo[0] + ";" + items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName();
                }
                adjustInfo[1] = ((BgElementInfo)elementMap.get(parameter[2])).getName();
                adjustInfo[2] = ((BgPeriodInfo)periodMap.get(parameter[1])).getName();
                adjustInfo[3] = sourceString;
                decimal = ((CurrencyInfo)currencyMap.get(parameter[5])).getPrecision();
                if (bgDataInfo.getBalance() != null) {
                    adjustInfo[4] = bgDataInfo.getBalance().setScale(decimal, 4).toString();
                }
                adjustInfo[5] = bgDataInfo.getBalance() == null ? (bgDataInfo.getPastValue() == null ? "" : bgDataInfo.getPastValue().setScale(decimal, 4).toString()) : (bgDataInfo.getPastValue() == null ? bgDataInfo.getBalance().setScale(decimal, 4).toString() : bgDataInfo.getBalance().add(bgDataInfo.getPastValue()).setScale(decimal, 4).toString());
                if (bgDataInfo.getPastValue() != null) {
                    adjustInfo[6] = bgDataInfo.getPastValue().setScale(decimal, 4).toString();
                }
                if (bgDataInfo.getAdjustor() != null) {
                    UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo("select * where id ='" + bgDataInfo.getAdjustor().getId().toString() + "'");
                    adjustInfo[7] = user.getName();
                }
                if (bgDataInfo.getAdjusttime() != null) {
                    adjustInfo[8] = dateFormat.format(new Date(bgDataInfo.getAdjusttime().getTime()));
                }
                adjustInfo[9] = nameString;
                adjustInfo[10] = createTime;
                adjustInfo[11] = bgDataInfo.getAdjReason();
                adjustInfo[12] = formulaString;
                re.add(adjustInfo);
            }
        }
        return re;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    public String getSqlDate(java.util.Date time) {
        CalendarHelper Helper = new CalendarHelper();
        java.util.Date a = Helper.getStartDate(time);
        String b = a.getYear() + 1900 + "-" + (a.getMonth() + 1) + "-" + a.getDate();
        Object ps = null;
        return b;
    }

    @Override
    protected List _getValueWithTemplate(Context ctx, String orgUnitID, String templateID, String sqlAspect, String projectFormula, String schemeID) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        ArrayList<Object> _tmpList1 = new ArrayList<Object>();
        StringBuffer strBuff2 = new StringBuffer("select B.FPASTVALUE FPASTVALUE , C.flastUpdateTime dataTime, C.FPastSource dataEnum, A.fformula formula, A.FbgformId bgFormId");
        strBuff2.append(" from T_BG_BgData A , T_BG_bgpastdata B  , t_Bg_Bgpastrecord C , t_bg_bgtemplate D, t_bg_bgscheme E ");
        strBuff2.append(" where A.FOrgUnitId = ?");
        _tmpList.add(orgUnitID);
        if (templateID != null) {
            strBuff2.append(" and (D.frootID = ? or A.Fbgtemplateid = ?) ");
            strBuff2.append(" and A.FFormula = ?");
            _tmpList.add(templateID);
            _tmpList.add(templateID);
            _tmpList.add(sqlAspect);
        } else {
            strBuff2.append(" and A.FFormula = ?");
            _tmpList.add(projectFormula);
        }
        strBuff2.append(" and (E.FrootId = ? or A.Fbgschemeid = ?) ");
        _tmpList.add(schemeID);
        _tmpList.add(schemeID);
        strBuff2.append(" and A.fid = B.fbgdataid ");
        strBuff2.append(" and B.FPastRecordID = C.Fid");
        strBuff2.append(" and A.Fbgtemplateid = D.Fid");
        strBuff2.append(" and A.Fbgschemeid = E.Fid");
        strBuff2.append(" and C.fpastsource <> ?");
        _tmpList.add(new Integer(3));
        StringBuffer strBuff = new StringBuffer("select A.fadjustpass FPASTVALUE ,   B.flastUpdateTime dataTime, A.fadjustcause adjustCause ");
        strBuff.append(" from t_bg_bgadjustbillentry A , t_bg_bgadjustbill B  ");
        strBuff.append(" where A.FOrgUnitId = ?");
        _tmpList1.add(orgUnitID);
        if (templateID != null) {
            strBuff.append(" and A.FFormula = ? ");
            _tmpList1.add(sqlAspect);
        } else {
            strBuff.append(" and A.FFormula = ? ");
            _tmpList1.add(projectFormula);
        }
        strBuff.append(" and  A.Fbgschemeid = ? ");
        _tmpList1.add(schemeID);
        strBuff.append(" and A.Fadjustbillid = B.fid");
        strBuff.append(" and B.fstate = ?");
        _tmpList1.add(new Integer(9));
        try {
            Vector<String> vec;
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(strBuff2.toString());
            BgNSQLHelper.setParams((PreparedStatement)ps, _tmpList);
            rs = ps.executeQuery();
            while (rs.next()) {
                vec = new Vector<String>();
                vec.add(rs.getString("FPASTVALUE"));
                vec.add(rs.getString("dataEnum"));
                vec.add(rs.getString("dataTime"));
                vec.add(null);
                list.add(vec);
            }
            SQLUtils.cleanup((ResultSet)rs);
            ps = connection.prepareStatement(strBuff.toString());
            BgNSQLHelper.setParams((PreparedStatement)ps, _tmpList1);
            rs = ps.executeQuery();
            while (rs.next()) {
                vec = new Vector();
                Integer _enum = new Integer(3);
                vec.add(rs.getString("FPASTVALUE"));
                vec.add(_enum.toString());
                vec.add(rs.getString("dataTime"));
                vec.add(rs.getString("adjustCause"));
                list.add(vec);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return list;
    }

    public static String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getValue(Context ctx, Map adjustMap, String formula, BgOperationEnum operationEnum) throws BOSException, EASBizException {
        DateFormat dateFormat = BgNationalFormatUIUtil.getNationalDateFormat(ctx);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String loc = BgPastRecordControllerBean.getLoc(ctx);
        Vector<String> AdjustorName = new Vector<String>();
        if (adjustMap == null || adjustMap.isEmpty()) {
            return new ArrayList();
        }
        if (formula != null && formula.trim().length() > 0 && !adjustMap.containsKey(formula)) {
            return new ArrayList();
        }
        ArrayList<String[]> re = new ArrayList<String[]>();
        HashMap parameterMap = new HashMap();
        ArrayList<String> itemList = new ArrayList<String>();
        ArrayList<String> elementList = new ArrayList<String>();
        ArrayList<String> periodList = new ArrayList<String>();
        ArrayList<String> currencyList = new ArrayList<String>();
        String formulaString2 = null;
        String[] parameter = null;
        String[] items = null;
        String[] adjustInfo = null;
        String adjustor = null;
        String adjustTime = null;
        BgFormDiversityData date = null;
        int decimal = 10;
        if (formula != null && formula.trim().length() > 0) {
            parameter = this.getFormulaInfo(parameterMap, formula);
            items = parameter[0].split(",");
            if (parameter[0] != null && parameter[0].trim().length() > 0 && parameter[1] != null && parameter[1].trim().length() > 0 && parameter[2] != null && parameter[2].trim().length() > 0 && parameter[5] != null && parameter[5].trim().length() > 0) {
                for (int i = 0; i < items.length; ++i) {
                    itemList.add(items[i]);
                }
                periodList.add(parameter[1]);
                elementList.add(parameter[2]);
                currencyList.add(parameter[5]);
            }
        } else {
            for (String formulaString2 : adjustMap.keySet()) {
                parameter = this.getFormulaInfo(parameterMap, formulaString2);
                items = parameter[0].split(",");
                if (parameter[0] == null || parameter[0].trim().length() <= 0 || parameter[1] == null || parameter[1].trim().length() <= 0 || parameter[2] == null || parameter[2].trim().length() <= 0 || parameter[5] == null || parameter[5].trim().length() <= 0) continue;
                for (int i = 0; i < items.length; ++i) {
                    itemList.add(items[i]);
                }
                periodList.add(parameter[1]);
                elementList.add(parameter[2]);
                currencyList.add(parameter[5]);
            }
        }
        String orgUnitId = BgSHelper.getIsolateOrg(ctx, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString());
        Map itemsMap = this.getBudgetItemInfo(ctx, itemList, orgUnitId);
        Map periodMap = this.getBudgetPeriodInfo(ctx, periodList);
        Map elementMap = this.getBudgetElementInfo(ctx, elementList);
        Map currencyMap = this.getBudgetCurrencyInfo(ctx, currencyList);
        if (operationEnum == null) {
            operationEnum = BgOperationEnum.ADJUST;
        }
        if (formula != null && formula.trim().length() > 0) {
            if (parameter != null && parameter[0] != null && parameter[0].trim() != null && parameter[0].trim().length() > 0 && parameter[1] != null && parameter[1].trim().length() > 0 && parameter[2] != null && parameter[2].trim().length() > 0 && parameter[5] != null && parameter[5].trim().length() > 0) {
                date = (BgFormDiversityData)adjustMap.get(formula);
                parameter = this.getFormulaInfo(parameterMap, formula);
                adjustor = date.getAdjustor();
                adjustTime = dateFormat.format(new Date(date.getAdjustTime().getTime()));
                try {
                    conn = this.getConnection(ctx);
                    String sqlcolumn = "Fname_" + loc;
                    String sql = "select FName_" + loc + " from t_pm_user where fid = '" + adjustor + "'";
                    pstmt = conn.prepareStatement(sql);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        AdjustorName.add(rs.getString(sqlcolumn).toString());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
                }
                adjustInfo = new String[13];
                items = parameter[0].split(",");
                for (int j = 0; j < items.length; ++j) {
                    adjustInfo[0] = j == 0 ? items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName() : adjustInfo[0] + ";" + items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName();
                }
                adjustInfo[1] = ((BgElementInfo)elementMap.get(parameter[2])).getName();
                adjustInfo[2] = ((BgPeriodInfo)periodMap.get(parameter[1])).getName();
                adjustInfo[3] = operationEnum.getAlias();
                decimal = ((CurrencyInfo)currencyMap.get(parameter[5])).getPrecision();
                adjustInfo[4] = date.getOldValue() != null ? date.getOldValue().setScale(decimal, 4).toString() : "";
                adjustInfo[5] = date.getNewValue() != null ? date.getNewValue().setScale(decimal, 4).toString() : "";
                adjustInfo[6] = date.getOldValue() == null ? (date.getNewValue() == null ? "" : date.getNewValue().setScale(decimal, 4).toString()) : (date.getNewValue() == null ? "" : date.getNewValue().subtract(date.getOldValue()).setScale(decimal, 4).toString());
                adjustInfo[7] = AdjustorName != null && AdjustorName.size() != 0 ? (AdjustorName.get(0) == null ? "" : (String)AdjustorName.get(0)) : "";
                adjustInfo[8] = adjustTime;
                adjustInfo[9] = "";
                adjustInfo[10] = "";
                adjustInfo[11] = ((BgAdjustFormDiversityData)date).getAdjustReson();
                adjustInfo[12] = formulaString2;
                re.add(adjustInfo);
            }
        } else {
            for (String formulaString2 : adjustMap.keySet()) {
                date = (BgFormDiversityData)adjustMap.get(formulaString2);
                parameter = this.getFormulaInfo(parameterMap, formulaString2);
                adjustor = date.getAdjustor();
                if (date.getAdjustTime() != null) {
                    adjustTime = dateFormat.format(new Date(date.getAdjustTime().getTime()));
                }
                try {
                    conn = this.getConnection(ctx);
                    String sqlcolumn = "Fname_" + loc;
                    String sql = "select FName_" + loc + " from t_pm_user where fid = '" + adjustor + "'";
                    pstmt = conn.prepareStatement(sql);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        AdjustorName.add(rs.getString(sqlcolumn).toString());
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                }
                adjustInfo = new String[13];
                items = parameter[0].split(",");
                for (int j = 0; j < items.length; ++j) {
                    adjustInfo[0] = j == 0 ? items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName() : adjustInfo[0] + ";" + items[j] + "_" + ((BgItemInfo)itemsMap.get(items[j])).getName();
                }
                adjustInfo[1] = ((BgElementInfo)elementMap.get(parameter[2])).getName();
                adjustInfo[2] = ((BgPeriodInfo)periodMap.get(parameter[1])).getName();
                adjustInfo[3] = operationEnum.getAlias();
                decimal = ((CurrencyInfo)currencyMap.get(parameter[5])).getPrecision();
                adjustInfo[4] = date.getOldValue() != null ? date.getOldValue().setScale(decimal, 4).toString() : "";
                adjustInfo[5] = date.getNewValue() != null ? date.getNewValue().setScale(decimal, 4).toString() : "";
                adjustInfo[6] = date.getOldValue() == null ? (date.getNewValue() == null ? "" : date.getNewValue().setScale(decimal, 4).toString()) : (date.getNewValue() == null ? "" : date.getNewValue().subtract(date.getOldValue()).setScale(decimal, 4).toString());
                adjustInfo[7] = AdjustorName != null && AdjustorName.size() != 0 ? (AdjustorName.get(0) == null ? "" : (String)AdjustorName.get(0)) : "";
                adjustInfo[8] = adjustTime;
                adjustInfo[9] = "";
                adjustInfo[10] = "";
                adjustInfo[11] = date instanceof BgAdjustFormDiversityData ? ((BgAdjustFormDiversityData)date).getAdjustReson() : null;
                adjustInfo[12] = formulaString2;
                re.add(adjustInfo);
            }
        }
        return re;
    }
}

