/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodException;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.app.AbstractBgPeriodControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgPeriodControllerBean
extends AbstractBgPeriodControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgPeriodControllerBean");
    private static final String date_pattern = "yyyy-MM-dd HH:mm:ss";

    @Override
    protected IObjectCollection _getAllPeriodInfo(Context ctx) throws BOSException, EASBizException {
        ArrayList<String> list = null;
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        BgPeriodCollection bgPeriod = null;
        String sql = "select * from T_BG_BgPeriod where FPERIODTYPE = " + String.valueOf(1) + " Order by FNumber DESC";
        try {
            conn = this.getConnection(ctx);
            pst = conn.prepareStatement(sql);
            rst = pst.executeQuery();
            list = new ArrayList<String>();
            while (rst.next()) {
                list.add(rst.getString("FID"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pst, (Connection)conn);
        bgPeriod = new BgPeriodCollection();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                bgPeriod.add(this.getBgPeriodInfo(ctx, (IObjectPK)new ObjectUuidPK(list.get(i).toString())));
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        return bgPeriod;
    }

    @Override
    protected void _batchDeletePeriod(Context ctx, Set idSets) throws BOSException, EASBizException {
        IBgPeriod iBgPeriod;
        if (!idSets.isEmpty() && (iBgPeriod = BgPeriodFactory.getLocalInstance(ctx)) != null) {
            BgPeriodCollection bgPeriodCol = null;
            BgPeriodInfo bgPeriodInfo = null;
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idSets, CompareType.INCLUDE));
            bgPeriodCol = iBgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null) {
                for (int i = 0; i < bgPeriodCol.size(); ++i) {
                    bgPeriodInfo = bgPeriodCol.get(i);
                    if (this.isUse(ctx, bgPeriodInfo)) {
                        throw new BgPeriodException(BgPeriodException.ISUSE);
                    }
                    if (!this.isUseByPersonalPeriod(ctx, bgPeriodInfo)) continue;
                }
            }
            this.batchDeletePeriodInfo(ctx, bgPeriodCol);
        }
    }

    @Override
    protected boolean _deletePeriod(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance(ctx);
        if (iBgPeriod != null) {
            BgPeriodInfo bgPeriodInfo = iBgPeriod.getBgPeriodInfo((IObjectPK)pk);
            if (bgPeriodInfo != null) {
                if (this.isUse(ctx, bgPeriodInfo)) {
                    throw new BgPeriodException(BgPeriodException.ISUSE);
                }
                if (this.isUseByPersonalPeriod(ctx, bgPeriodInfo)) {
                    throw new BgPeriodException(BgPeriodException.DELETEERROR);
                }
                this.deletePeriodInfo(ctx, bgPeriodInfo);
            } else {
                throw new BgPeriodException(BgPeriodException.FINDERROR);
            }
        }
        return true;
    }

    private boolean isUseByPersonalPeriod(Context ctx, BgPeriodInfo info) {
        String sql = "select fid from t_bg_bgperiod a,( select fbegindate , fenddate  from t_bg_bgperiod where fperiodtype = 8 ) b  where a.fbegindate >= b.fbegindate and a.fenddate <= b.fenddate  and a.fid = '" + info.getId() + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return false;
    }

    private boolean isUse(Context ctx, BgPeriodInfo period) throws EASBizException, BOSException {
        boolean isUsed = false;
        if (period == null) {
            return true;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int result = 0;
        try {
            String sql = "Select count(a.fid) cnt from t_bg_bgtemRefBgPeriod a,t_bg_bgperiod b  where a.fbgperiodid=b.fid and b.flongnumber like '" + period.getLongNumber() + "%'";
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        if (result > 0) {
            isUsed = true;
        }
        return isUsed;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void batchDeletePeriodInfo(Context ctx, BgPeriodCollection bgPeroidCol) throws BOSException, EASBizException {
        if (bgPeroidCol == null) return;
        if (bgPeroidCol.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            BgPeriodInfo bgPeriodInfo = null;
            conn = this.getConnection(ctx);
            int batchSize = 200;
            int pos = 0;
            String selSql = "select TOP 1 a.FID from T_BG_bgForm a, T_BG_BgPeriod b where a.FBgPeriodID = b.FID ";
            for (int i = 0; i < bgPeroidCol.size(); ++i) {
                bgPeriodInfo = bgPeroidCol.get(i);
                selSql = i == 0 ? selSql + " and ( b.FLongNumber like '" + bgPeriodInfo.getLongNumber() + "%'" : selSql + " or b.FLongNumber like '" + bgPeriodInfo.getLongNumber() + "%'";
                if (++pos < batchSize) continue;
                pstmt = conn.prepareStatement(selSql = selSql + ")");
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    throw new BgPeriodException(BgPeriodException.DELETEERROR);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                pos = 0;
            }
            if (pos > 0) {
                pstmt = conn.prepareStatement(selSql = selSql + ")");
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    throw new BgPeriodException(BgPeriodException.DELETEERROR);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
            pos = 0;
            String updateSql = "delete from T_BG_BgPeriod where FLongNumber like ?";
            pstmt = conn.prepareStatement(updateSql);
            for (int i = 0; i < bgPeroidCol.size(); ++i) {
                bgPeriodInfo = bgPeroidCol.get(i);
                pstmt.setString(1, bgPeriodInfo.getLongNumber() + "%");
                pstmt.addBatch();
                if (++pos < batchSize) continue;
                pstmt.executeBatch();
                pos = 0;
            }
            if (pos > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deletePeriodInfo(Context ctx, BgPeriodInfo bgPeriodInfo) throws BOSException, EASBizException {
        if (bgPeriodInfo == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select TOP 1 a.FID from T_BG_bgForm a, T_BG_BgPeriod b where a.FBgPeriodID = b.FID and b.FLongNumber like '" + bgPeriodInfo.getLongNumber() + "%'");
            rst = pstmt.executeQuery();
            if (rst.next()) {
                throw new BgPeriodException(BgPeriodException.DELETEERROR);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement("delete from T_BG_BgPeriod where FLongNumber like '" + bgPeriodInfo.getLongNumber() + "%'");
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _deletePeriodOfYear(Context ctx, String year) throws BOSException, EASBizException {
        if (year == null) {
            return false;
        }
        String delsql = "Select TOP 1 a.fid from T_BG_BgTemRefBgPeriod a, T_BG_BgPeriod b where a.fbgperiodid = b.fid and b.FYear = " + year;
        String sqldel = "select TOP 1 a.FID from T_BG_bgForm a, T_BG_BgPeriod b where a.FBgPeriodID = b.FID and b.FYear = " + year;
        String sql = "delete from T_BG_BgPeriod where FYear = " + year;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(delsql);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                throw new BgPeriodException(BgPeriodException.ISUSE);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement(sqldel);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                throw new BgPeriodException(BgPeriodException.DELETEERROR);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return true;
    }

    @Override
    protected IObjectCollection _getPeriodCollection(Context ctx, BOSUuid sId, BOSUuid eId) throws BOSException, EASBizException {
        BgPeriodCollection bgPeriodCol = new BgPeriodCollection();
        if (sId == null || eId == null) {
            return bgPeriodCol;
        }
        ObjectUuidPK sPk = new ObjectUuidPK(sId);
        ObjectUuidPK ePk = new ObjectUuidPK(eId);
        IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance(ctx);
        if (sPk != null && ePk != null && iBgPeriod != null) {
            BgPeriodInfo sBgPeriod = null;
            BgPeriodInfo eBgPeriod = null;
            try {
                if (iBgPeriod.exists((IObjectPK)sPk)) {
                    sBgPeriod = iBgPeriod.getBgPeriodInfo((IObjectPK)sPk);
                }
                if (iBgPeriod.exists((IObjectPK)ePk)) {
                    eBgPeriod = iBgPeriod.getBgPeriodInfo((IObjectPK)ePk);
                }
                if (sBgPeriod != null && eBgPeriod != null && sBgPeriod.getPeriodType().equals((Object)eBgPeriod.getPeriodType())) {
                    int type = sBgPeriod.getPeriodType().getValue();
                    if (type == 8) {
                        bgPeriodCol.add(sBgPeriod);
                    } else {
                        java.util.Date beginDate = BgHelper.getDayBegin(sBgPeriod.getBeginDate());
                        java.util.Date endDate = BgHelper.getDayEnd(eBgPeriod.getEndDate());
                        bgPeriodCol = BgPeriodHelper.getPeriodColInfo(ctx, beginDate, endDate, type);
                    }
                }
            }
            catch (BOSException ex) {
                throw new BgPeriodException(BgPeriodException.FINDERROR);
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        return bgPeriodCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _getPeriodColByNums(Context ctx, String sNum, String eNum) throws BOSException, EASBizException {
        String sql = "";
        sql = !sNum.equals(eNum) ? "select fid from t_bg_bgperiod where fnumber in ('" + sNum + "','" + eNum + "')" : "select fid from t_bg_bgperiod where fnumber = '" + sNum + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (rs.next()) {
                String fid = rs.getString("fid");
                idList.add(fid);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (idList.isEmpty()) {
            return new BgPeriodCollection();
        }
        BOSUuid sId = null;
        BOSUuid eId = null;
        if (sNum.equals(eNum)) {
            eId = sId = BOSUuid.read((String)idList.get(0).toString());
        } else if (idList.size() == 2) {
            sId = BOSUuid.read((String)idList.get(0).toString());
            eId = BOSUuid.read((String)idList.get(1).toString());
        } else {
            return new BgPeriodCollection();
        }
        return this._getPeriodCollection(ctx, sId, eId);
    }

    @Override
    protected List _judgePeriodInfoExistByNums(Context ctx, String periodNums) throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        String sql = "select fnumber from t_bg_bgPeriod where fnumber in " + periodNums;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String fnumber = rs.getString("fnumber");
                list.add(fnumber);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List _getColsByPersonalPeriod(Context ctx, BgPeriodInfo personalPeriod) throws BOSException {
        ArrayList list = new ArrayList();
        java.util.Date beginDate = personalPeriod.getBeginDate();
        java.util.Date endDate = personalPeriod.getEndDate();
        String sql = "select * from t_bg_bgperiod where fbegindate >= ? and fenddate >= ? and fperiodtype = 1";
        Connection con = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            pstm.setDate(1, new Date(beginDate.getYear(), beginDate.getMonth(), beginDate.getDate()));
            pstm.setDate(2, new Date(endDate.getYear(), endDate.getMonth(), endDate.getDate()));
            rs = pstm.executeQuery();
            while (rs.next()) {
                rs.getString("fnumber");
                rs.getString("fname");
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)pstm, (Connection)con);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _deletePersonalPeriod(Context ctx, String periodID) throws BOSException {
        String jugdeSql = " select a.fid from t_bg_bgperiod a where a.fid in  (\tselect FBGPERIODID from t_bg_bgrefbgperiod where fbgperiodid = ? union all  select FBGPERIODID from t_bg_bgtemrefbgperiod where fbgperiodid = ? )";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)jugdeSql, (Object[])new Object[]{periodID, periodID});
        try {
            if (rs.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String sql = "delete from t_bg_bgperiod where fid = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, periodID);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return true;
    }

    @Override
    protected Map _getBgPeriodForAdjust(Context ctx, Map periodMap) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (periodMap != null && periodMap.get("periods") != null) {
            HashSet endPeriodSet = (HashSet)periodMap.get("periods");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)endPeriodSet, CompareType.INCLUDE));
            view.setFilter(filter);
            BgPeriodCollection endPerCol = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodCollection(view);
            String[] num = new String[]{"number"};
            BgHelper.sortCollection(endPerCol, num);
            resultMap.put("endPerCol", (Object)endPerCol);
        }
        if (periodMap != null && periodMap.get("sourcePer") != null) {
            String periodId = (String)periodMap.get("sourcePer");
            BgPeriodInfo sourcePeriod = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo("where number ='" + periodId + "'");
            resultMap.put("sourcePeriod", sourcePeriod);
        }
        return resultMap;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)super._getValue(ctx, pk);
        return bgPeriodInfo.getNumber() + " " + bgPeriodInfo.getName();
    }
}

