/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.PrintSetup;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.IRptSheetParam;
import com.kingdee.eas.fi.rpt.PostilFactory;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.BgCtrSettingFacadeFactory;
import com.kingdee.eas.ma.budget.BgCtrlSetHelper;
import com.kingdee.eas.ma.budget.BgExamineNodeFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgSchemeNodeCollection;
import com.kingdee.eas.ma.budget.BgSchemeNodeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemModifyEnum;
import com.kingdee.eas.ma.budget.BgTemplateException;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BgTemplatePostilCollection;
import com.kingdee.eas.ma.budget.BgTemplatePostilInfo;
import com.kingdee.eas.ma.budget.IBgActualRecord;
import com.kingdee.eas.ma.budget.IBgCtrSettingFacade;
import com.kingdee.eas.ma.budget.IBgExamineNode;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.SchemeAssignMsgObj;
import com.kingdee.eas.ma.budget.app.AbstractBgSchemeFacadeControllerBean;
import com.kingdee.eas.ma.budget.app.BgCatchUtil;
import com.kingdee.eas.ma.nbudget.BgAutoEnurameHelper;
import com.kingdee.eas.ma.nbudget.BgEnumerateHelper;
import com.kingdee.eas.ma.nbudget.BgEnumerateInfo;
import com.kingdee.eas.ma.nbudget.BgExpressionsItemVariableHelper;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNLockProtectHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateException;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.nbudget.BgRowColIdObject;
import com.kingdee.eas.ma.nbudget.BgTemplateFacade;
import com.kingdee.eas.ma.nbudget.app.BgNAssignUpdateUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgSchemeFacadeControllerBean
extends AbstractBgSchemeFacadeControllerBean {
    private static final long serialVersionUID = 5553350081147295953L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgSchemeFacadeControllerBean");
    public static final String SCHEME_SUBMIT_RESOURCE_PATH = "com.kingdee.eas.ma.budget.BgSchemeResource";

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("dateFrom"));
        sic.add(new SelectorItemInfo("dateTo"));
        sic.add(new SelectorItemInfo("isFormal"));
        sic.add(new SelectorItemInfo("isSubmitByScheme"));
        sic.add(new SelectorItemInfo("parentScheme.name"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.number"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.creator.*"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.name"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.isAllowChange"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.creator.name"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.createTime"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.id"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.rootId"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.description"));
        sic.add(new SelectorItemInfo("creator.*"));
        return sic;
    }

    @Override
    protected Vector _getHasChildSchemeOnOu(Context ctx, String schemeId, String schemeRootId) throws BOSException {
        if (schemeId == null) {
            return null;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        Vector<String> vec = new Vector<String>();
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer2 = new StringBuffer(200);
            strBuffer2.append("select distinct FOrgUnitID from T_BG_BgScheme where FRootID=?");
            ps = connection.prepareStatement(strBuffer2.toString());
            ps.setString(1, schemeRootId);
            rs = ps.executeQuery();
            String orgid = null;
            while (rs.next()) {
                orgid = rs.getString("FOrgUnitID");
                vec.add(orgid);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        if (vec.size() < 1) {
            return null;
        }
        return vec;
    }

    protected boolean isHasAssignSchemeToThisOrg(Context ctx, String schemeId, String schemeRootId, String orgid) throws BOSException {
        if (schemeId == null) {
            return true;
        }
        boolean isExit = false;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer2 = new StringBuffer(200);
            strBuffer2.append("select distinct FID from T_BG_BgScheme where FRootID=? and FOrgUnitID=?");
            ps = connection.prepareStatement(strBuffer2.toString());
            ps.setString(1, schemeRootId);
            ps.setString(2, orgid);
            rs = ps.executeQuery();
            while (rs.next()) {
                isExit = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return isExit;
    }

    private BgTemplateInfo getBgTemplateInfo(Context ctx, String orgId, String rootId) throws SQLDataException {
        Connection connection;
        ResultSet rs;
        PreparedStatement ps;
        BgTemplateInfo result;
        block5: {
            result = null;
            ps = null;
            rs = null;
            connection = null;
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select fid,fparentid from T_BG_BgTemplate where forgunitid=? and frootid = ?");
            try {
                connection = this.getConnection(ctx);
                ps = connection.prepareStatement(strBuffer.toString());
                ps.setString(1, orgId);
                ps.setString(2, rootId);
                rs = ps.executeQuery();
                if (!rs.next()) break block5;
                result = new BgTemplateInfo();
                String id = rs.getString(1);
                String parentId = rs.getString(2);
                result.setId(BOSUuid.read((String)id));
                if (parentId != null && !parentId.equals("")) {
                    BgTemplateInfo parent = new BgTemplateInfo();
                    parent.setId(BOSUuid.read((String)parentId));
                    result.setParent(parent);
                }
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)connection);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return result;
    }

    @Override
    protected Vector _getExamineIds(Context ctx, String templateId) throws EASBizException, BOSException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        Vector<String> examineIds;
        block5: {
            Vector vector;
            examineIds = new Vector<String>();
            String sql = "select FBgExamineID from t_bg_bgexaminenode where FBgTemplateID = ?";
            conn = null;
            pstmt = null;
            rs = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, templateId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    examineIds.add(rs.getString("FBgExamineID").toString());
                }
                if (examineIds.size() != 0) break block5;
                vector = null;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"50_BgSchemeFacadeControllerBean", (Locale)ctx.getLocale()), (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return vector;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return examineIds;
    }

    public static boolean isFD(Context ctx) {
        String paramValue = null;
        try {
            paramValue = ctx == null ? ParamManager.getParamValue(null, null, (String)"BG007") : ParamManager.getParamValue((Context)ctx, null, (String)"BG007");
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (paramValue == null || paramValue.trim().equals("")) {
            return false;
        }
        return Boolean.valueOf(paramValue);
    }

    private void createBgTemEntries(Context ctx, BgTemplateInfo bgTemplateInfoOld, BgTemplateInfo bgTemplateInfoNew) throws BOSException {
        String newBgTemplateId = bgTemplateInfoNew.getId().toString();
        String sql1 = "insert into t_bg_bgtemrefbgitemcombin(fid,fbgitemcombinid,fbgtemplateid)  select newbosid('0536ABF1'),fbgitemcombinid,'" + newBgTemplateId + "'  from t_bg_bgtemrefbgitemcombin where fbgtemplateid = ?";
        String sql2 = "insert into t_bg_bgtemrefbgperiod(fid,fbgperiodid,fbgtemplateid)  select newbosid('F051E0D9'),fbgperiodid,'" + newBgTemplateId + "'  from t_bg_bgtemrefbgperiod where fbgtemplateid = ?";
        String sql3 = "insert into t_bg_bgtemrefbgelement(fid,fbgelementid,fbgtemplateid)  select newbosid('DF4216E4'),fbgelementid,'" + newBgTemplateId + "'  from t_bg_bgtemrefbgelement where fbgtemplateid = ?";
        String sql4 = "insert into t_bg_bgtemrefcurrency(fid,fcurrencyid,fbgtemplateid)  select newbosid('0536ABF1'),fcurrencyid,'" + newBgTemplateId + "'  from t_bg_bgtemrefcurrency where fbgtemplateid = ?";
        DbUtil.execute((Context)ctx, (String)sql1, (Object[])new String[]{bgTemplateInfoOld.getId().toString()});
        DbUtil.execute((Context)ctx, (String)sql2, (Object[])new String[]{bgTemplateInfoOld.getId().toString()});
        DbUtil.execute((Context)ctx, (String)sql3, (Object[])new String[]{bgTemplateInfoOld.getId().toString()});
        DbUtil.execute((Context)ctx, (String)sql4, (Object[])new String[]{bgTemplateInfoOld.getId().toString()});
    }

    private SelectorItemCollection getTemplageSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isAllowChange"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("mapData"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("rootId"));
        sic.add(new SelectorItemInfo("templateStatus"));
        sic.add(new SelectorItemInfo("defaultMeasureUnit"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgType.*"));
        return sic;
    }

    private boolean isHaveAssgnThisTemp(Context ctx, BOSUuid rootId, String orgUnitId, String schemeId) throws BOSException {
        boolean success = false;
        String sql = "select top 1 A.fid from T_BG_BgSchemeNode B inner join T_BG_BgTemplate A on B.FBgTemplateID=A.FID where A.FRootId = ? and A.FOrgUnitID = ? and B.FBgSchemeID = ?";
        Object[] obj = new Object[]{rootId.toString(), orgUnitId, schemeId};
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])obj);
        try {
            if (row.next()) {
                success = true;
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"51_BgSchemeFacadeControllerBean", (Locale)ctx.getLocale()), (Throwable)sqle);
            throw new BOSException((Throwable)sqle);
        }
        return success;
    }

    protected void replaceSchemeInBgFormula(Context ctx, Book sourceBook, BgTemplateInfo bgTemplateInfoNew, boolean isEnumerateForm) throws EASBizException, BOSException {
        if (sourceBook == null) {
            return;
        }
        Book book = Book.Manager.getNewBook((String)sourceBook.getName(), (int)0);
        BgNFSHelper.disableUndo((Book)book);
        BgNFSHelper.disableUndo((Book)sourceBook);
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableCal((Book)sourceBook);
        Map mapProTectSourse = new HashMap();
        int count = sourceBook.getSheetCount();
        for (int i = 0; i < count; ++i) {
            Sheet sheet = new Sheet(book, sourceBook.getSheet(i).getSheetName());
            sheet = BgNAssignUpdateUtil.CopySheet((Sheet)sourceBook.getSheet(i), (Sheet)sheet);
            sheet.setUserObject("SHEET_CREATER_ID", (Object)((String)sourceBook.getSheet(i).getUserObjectValue("SHEET_CREATER_ID")));
            sheet.setHide(sourceBook.getSheet(i).isHide());
            sheet.setID(sourceBook.getSheet(i).getID());
            BgNFSHelper.setSheetSign((Sheet)sheet, (String)BgNFSHelper.getSheetSign((Sheet)sourceBook.getSheet(i)));
            this.upSheetSplit(sheet, sourceBook.getSheet(i));
            if (sourceBook.getSheet(i) != null && sourceBook.getSheet(i).getUserObject("ScriptCell") != null) {
                sheet.setUserObject("ScriptCell", (Object)((String)sourceBook.getSheet(i).getUserObjectValue("ScriptCell")));
            }
            if (sourceBook.getSheet(i) != null && sourceBook.getSheet(i).getUserObject("Special_Area") != null) {
                sheet.setUserObject("Special_Area", (Object)((Map)sourceBook.getSheet(i).getUserObjectValue("Special_Area")));
            }
            if (i == 0 && sheet.isHide()) {
                book.addSheet(sheet, false);
                continue;
            }
            book.addSheet(sheet);
        }
        mapProTectSourse = BgNLockProtectHelper.clearChildTemplateBookProAndSheetPro((Book)sourceBook);
        Sheet sheet = null;
        Cell cell = null;
        Range range = null;
        StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(true);
        int count2 = book.getSheetCount();
        for (int k = 0; k < count2; ++k) {
            sheet = book.getSheet(k);
            sheet.setEnableCalculation(false);
            int rowCount = sheet.getMaxRowIndex() + 1;
            int colCount = sheet.getMaxColIndex() + 1;
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    cell = sheet.getCell(i, j, false);
                    if (cell == null) continue;
                    if (BgNLockProtectHelper.isCellLocked((Cell)cell)) {
                        BgNTemplateHelper.setCellCtrlValue((Cell)cell, (String)"CELL_LOCK_SUPER", (Object)BgNConstants.TRUE_UPDATE, (boolean)false);
                        if (range != null) {
                            range.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
                        } else {
                            range = cell.getSheet().getRange(cell);
                        }
                    }
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
                    BgNFSHelper.setFormulaEditOfCell((Cell)cell, (boolean)false);
                    ItemFormula uItemFormual = BgNFSHelper.getItemFormula((Cell)cell);
                    uItemFormual.putExt("isctrl_from_super_collection_form", "true");
                    BgNFSHelper.setItemFormula((Cell)cell, (ItemFormula)uItemFormual);
                }
            }
            if (range == null) continue;
            range.setIgnoreProtected(true);
            range.setStyle(sa, Styles.getEmptySA());
            range = null;
        }
        count2 = sourceBook.getSheetCount();
        for (int index = 0; index < count2; ++index) {
            Sheet template = sourceBook.getSheet(index);
            if (template == null || StringUtils.isEmpty((String)BgNFSHelper.getSheetSign((Sheet)template)) || (sheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId((String)BgNFSHelper.getSheetSign((Sheet)template), (Book)book)) == null && (sheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateSheetID((String)template.getID(), (Book)book)) == null) continue;
            sheet.setEnableCalculation(false);
            PrintSetup src_setting = template.getSheetOption().getPrintSetup(false);
            if (src_setting == null) continue;
            sheet.getSheetOption().getPrintSetup(true).copyFrom(src_setting);
        }
        BgNTemplateHelper.updateAliasSuperior((Book)book);
        this.updateBookUserObject(book, sourceBook);
        Map map = BgNAssignUpdateUtil.getDefaultChildTemFormProMap((Book)book);
        BgNLockProtectHelper.reCombinProMap(mapProTectSourse, (Map)map);
        BgNLockProtectHelper.reDoChildTemplateBookProAndSheetPro((Book)book, (Map)map, (boolean)isEnumerateForm);
        try {
            if (!isEnumerateForm) {
                this.upExpressionWithOldTem(ctx, bgTemplateInfoNew.getBook(), book);
            } else {
                this.upEnumeraterArea(ctx, sourceBook, book);
            }
            bgTemplateInfoNew.setBook(book);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void upSheetSplit(Sheet sheet, Sheet sourceSheet) {
        ViewSplitInfo vs = sourceSheet.getSheetOption().getViewSplitInfo();
        boolean isFreeze = vs.isFreezed();
        if (isFreeze) {
            sheet.getSheetOption().getViewSplitInfo().setFreezed(true);
            sheet.getSheetOption().getViewSplitInfo().copyFrom(vs);
        } else {
            sheet.getSheetOption().getViewSplitInfo().setFreezed(false);
            sheet.getSheetOption().getViewSplitInfo().copyFrom(vs);
        }
    }

    private void upSheetSplitWithID(Sheet update, Sheet source, Map upRowAlias, Map upColAlias) {
        ViewSplitInfo vs = source.getSheetOption().getViewSplitInfo();
        boolean isFreeze = vs.isFreezed();
        int rowSplit = vs.getRowSplit();
        int colSplit = vs.getColSplit();
        if (isFreeze) {
            update.getSheetOption().getViewSplitInfo().setFreezed(true);
            String sorRowId = BgNFSHelper.getRowSign((Row)source.getRow(rowSplit, false));
            String sorColId = BgNFSHelper.getColSign((Column)source.getColumn(colSplit, false));
            if (sorRowId == null || !upRowAlias.containsKey(sorRowId)) {
                update.getSheetOption().getViewSplitInfo().setRowSplit(rowSplit);
            } else {
                update.getSheetOption().getViewSplitInfo().setRowSplit(((Integer)upRowAlias.get(sorRowId)).intValue());
            }
            if (sorColId == null || !upColAlias.containsKey(sorColId)) {
                update.getSheetOption().getViewSplitInfo().setColSplit(colSplit);
            } else {
                update.getSheetOption().getViewSplitInfo().setRowSplit(((Integer)upColAlias.get(sorColId)).intValue());
            }
        } else {
            update.getSheetOption().getViewSplitInfo().setFreezed(false);
        }
    }

    private void upEnumeraterArea(Context ctx, Book oldBook, Book newBook) {
        Object areaObject = oldBook.getUserObjectValue("EnumerAteArea");
        if (newBook == null) {
            return;
        }
        if (areaObject != null) {
            newBook.setUserObject("EnumerAteArea", areaObject);
        } else {
            newBook.removeUserObject("EnumerAteArea");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BgTemplateInfo getBgTemplateInfo(Context ctx, BOSUuid id, Connection conn) throws BOSException, EASBizException {
        BgTemplateInfo bgTemplateInfo = new BgTemplateInfo();
        if (ctx == null) return bgTemplateInfo;
        if (id == null) {
            return bgTemplateInfo;
        }
        Connection conne = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            if (conn == null) {
                conne = this.getConnection(ctx);
                pstmt = conne.prepareStatement("select FID, FName, FNumber, FData, FOrgUnitID from T_BG_BgTemplate where FID = ?");
            } else {
                pstmt = conn.prepareStatement("select FID, FName, FNumber, FData, FOrgUnitID from T_BG_BgTemplate where FID = ?");
            }
            pstmt.setString(1, id.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgTemplateInfo.setId(id);
                bgTemplateInfo.setName(rst.getString(2));
                bgTemplateInfo.setNumber(rst.getString(3));
                bgTemplateInfo.setZipData(BgInfoHelper.getBytes((ResultSet)rst, (int)4));
                bgTemplateInfo.setOrgUnit(new FullOrgUnitInfo());
                bgTemplateInfo.getOrgUnit().setId(BOSUuid.read((String)rst.getString(5)));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (IOException ex3) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conne);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conne);
        return bgTemplateInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getChildBgTemplateInfo(Context ctx, BOSUuid rootID, Set orgUnitSet) throws BOSException, EASBizException {
        HashMap<String, Object> childMap = new HashMap<String, Object>();
        if (ctx == null) return childMap;
        if (rootID == null) {
            return childMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_BG_BgTemplate where FID <> ? and FRootId = ?");
        if (orgUnitSet != null && !orgUnitSet.isEmpty()) {
            sql.append(" and FOrgUnitID in (");
            Iterator iter = orgUnitSet.iterator();
            while (iter.hasNext()) {
                sql.append("?,");
                _tmpList.add(iter.next().toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, rootID.toString());
            pstmt.setString(2, rootID.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList, (int)3);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                childMap.put(rst.getString(1), null);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return childMap;
    }

    protected void checkFormulaOfTables(Book book, Context ctx) throws EASBizException {
        Cell cell = null;
        String formulaString = null;
        String[] formulaInfo = null;
        ArrayList<String[]> formula = new ArrayList<String[]>();
        int sheetCount = book.getSheetCount();
        for (int k = 0; k < sheetCount; ++k) {
            Sheet sheet = book.getSheet(k);
            int maxRowIndex = sheet.getMaxRowIndex();
            for (int i = 0; i <= maxRowIndex; ++i) {
                int maxColIndex = sheet.getMaxColIndex();
                for (int j = 0; j <= maxColIndex; ++j) {
                    cell = sheet.getCell(i, j, false);
                    if (cell == null || !BgNFSHelper.checkHasFormulaOfCell((Cell)cell) || (formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell)) == null || formulaString.trim().length() <= 0) continue;
                    formulaInfo = new String[]{sheet.getSheetName(), formulaString, String.valueOf(i + 1), String.valueOf(j + 1)};
                    formula.add(formulaInfo);
                }
            }
        }
        BgNTemplateHelper.checkFormulaIsEctype(formula, (Locale)ctx.getLocale());
    }

    public SelectorItemCollection getBgFormInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("bgType.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("dataSource"));
        sic.add(new SelectorItemInfo("versionNo"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("adjust.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.id"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("sheetParam.cslSheetManner"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.precision"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        sic.add(new SelectorItemInfo("templateLastUpdateTime"));
        return sic;
    }

    @Override
    protected void _coverChildBook(Context ctx, BgTemplateInfo bgTemplateInfoOld, BgTemplateInfo bgTemplateInfoNew, boolean isEnumateForm) throws EASBizException, BOSException {
        if (bgTemplateInfoOld.getData() != null) {
            Book book = BgCatchUtil.getBgKDFCatch(bgTemplateInfoOld);
            try {
                if (book != null) {
                    this.replaceSchemeInBgFormula(ctx, book, bgTemplateInfoNew, isEnumateForm);
                }
                bgTemplateInfoNew.setBook(null);
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            try {
                bgTemplateInfoNew.setBook(null);
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected Map _checkFormulaDump(Context ctx, List bgTemIdList) throws BOSException, EASBizException {
        HashMap formulaMap = new HashMap();
        IBgTemplate iTem = BgTemplateFactory.getLocalInstance(ctx);
        try {
            for (int i = 0; i < bgTemIdList.size(); ++i) {
                String id = (String)bgTemIdList.get(i);
                BgTemplateInfo info = iTem.getBgTemplateInfo("select id ,name,number ,data where id='" + id + "'");
                if (info.getData() == null) continue;
                this.saveBgItemFormula(formulaMap, info.getBook(), info.getName(), info.getNumber());
            }
        }
        catch (Exception e) {
            throw new BgNTemplateException(BgNTemplateException.OPENBOOKFAIL, (Throwable)e);
        }
        return formulaMap;
    }

    private void saveBgItemFormula(Map formulaMap, Book book, String name, String number) throws BOSException, EASBizException {
        if (book == null) {
            return;
        }
        Cell cell = null;
        int sheetCount = book.getSheetCount();
        for (int k = 0; k < sheetCount; ++k) {
            Sheet sheet = book.getSheet(k);
            if (sheet == null) continue;
            String sheetName = sheet == null ? "" : sheet.getSheetName();
            int maxRowIndex = sheet.getMaxRowIndex();
            int maxColIndex = sheet.getMaxColIndex();
            for (int i = 0; i <= maxRowIndex; ++i) {
                for (int j = 0; j <= maxColIndex; ++j) {
                    List<String> dumpInfoList;
                    List list;
                    cell = sheet.getCell(i, j, false);
                    if (cell == null) continue;
                    String itemFormula = BgNFSHelper.getFormulaOfCell((Cell)cell);
                    if ((itemFormula = BgNTemplateHelper.get6ParematerItemFormula((String)itemFormula)) == null || itemFormula.trim().length() < 1 || (list = TableToolkit.parseFormula((String)itemFormula, (boolean)false)) == null || list.isEmpty()) continue;
                    FormulaHint hint = (FormulaHint)list.get(0);
                    String[] params = hint.getParams();
                    if (!hint.name.trim().equalsIgnoreCase("BgItem") || params == null || params.length != 6) continue;
                    String newItemFormula = "=BgItem(\"" + params[0].trim() + "\",\"" + params[1].trim() + "\",\"" + params[2].trim() + "\",\"" + params[5].trim() + "\")";
                    if (formulaMap.containsKey(newItemFormula)) {
                        dumpInfoList = (List)formulaMap.get(newItemFormula);
                        dumpInfoList.add(name + "," + sheetName + "," + TableToolkit.xy2range((int)j, (int)i) + "," + newItemFormula);
                        formulaMap.put(newItemFormula, dumpInfoList);
                        continue;
                    }
                    dumpInfoList = new ArrayList();
                    dumpInfoList.add(name + "," + sheetName + "," + TableToolkit.xy2range((int)j, (int)i) + "," + newItemFormula);
                    formulaMap.put(newItemFormula, dumpInfoList);
                }
            }
        }
    }

    @Override
    protected Map _invokeMethod(Context ctx, IObjectValue org, IObjectValue tem, IObjectValue scheme, boolean isUpdateBgTemplate, boolean isUpdateBgForm, boolean isCoverChild, Set templateSet) throws BOSException, EASBizException {
        IObjectPK templateNewPK;
        BgTemModifyEnum isAllowChange;
        BgTemModifyEnum canModify;
        if (org == null || tem == null || scheme == null) {
            return null;
        }
        IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance(ctx);
        IBgCtrSettingFacade ibgctrl = BgCtrSettingFacadeFactory.getLocalInstance(ctx);
        IBgExamineNode iBgExamineNode = BgExamineNodeFactory.getLocalInstance(ctx);
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("CU");
        FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(((FullOrgUnitInfo)org).getId()), sic);
        BgTemplateInfo bgTemplateInfoOld = iBgTemplate.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(((BgTemplateInfo)tem).getId()));
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)scheme;
        String orgId = orgUnitInfo.getId().toString();
        BgSchemeInfo bgSchemeInfoNew = null;
        boolean isEnumateForm = false;
        boolean isScript = false;
        boolean isSpecialForm = false;
        if (bgTemplateInfoOld.getFormType().equals((Object)BgTemFormTypeEnum.ENUMERATEFORM)) {
            isEnumateForm = true;
        } else if (bgTemplateInfoOld.getFormType().equals((Object)BgTemFormTypeEnum.SCRIPTFORM)) {
            isScript = true;
            isCoverChild = true;
        } else if (bgTemplateInfoOld.getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM)) {
            isSpecialForm = true;
            isCoverChild = true;
        } else {
            isCoverChild = true;
        }
        Vector examineIds = null;
        Object obj = BgCatchUtil.getBgEXAMPINEIDSCatch(bgTemplateInfoOld);
        if (obj == null) {
            examineIds = this.getExamineIds(ctx, bgTemplateInfoOld.getId().toString());
            if (examineIds == null) {
                BgCatchUtil.putBgEXAMPINEIDCatch(bgTemplateInfoOld.getId().toString(), Boolean.FALSE);
            } else {
                BgCatchUtil.putBgEXAMPINEIDCatch(bgTemplateInfoOld.getId().toString(), examineIds);
            }
        } else {
            examineIds = obj instanceof Boolean ? null : (Vector)obj;
        }
        bgSchemeInfoNew = this.schemeAssginDetailBgschem(ctx, bgSchemeInfo, bgSchemeInfoNew, orgUnitInfo, iBgScheme);
        if (bgSchemeInfoNew == null) {
            return null;
        }
        bgSchemeInfoNew.setIsFormal(false);
        BOSUuid temrootId = bgTemplateInfoOld.getRootId();
        String rootIdString = temrootId == null ? "" : temrootId.toString();
        BgTemplateInfo bgTemplateInfoNew = null;
        BgTemplateInfo _bgTemplateInfoNew = this.getBgTemplateInfo(ctx, orgId, rootIdString);
        if (_bgTemplateInfoNew == null) {
            bgTemplateInfoNew = bgTemplateInfoOld.deepClone();
            bgTemplateInfoNew.setOrgUnit(orgUnitInfo);
            bgTemplateInfoNew.setCU(orgUnitInfo.getCU());
            bgTemplateInfoNew.setNumber(bgTemplateInfoOld.getNumber());
            bgTemplateInfoNew.setName(bgTemplateInfoOld.getName());
            bgTemplateInfoNew.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bgTemplateInfoNew.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            bgTemplateInfoNew.setRootId(temrootId);
            bgTemplateInfoNew.setTemplateStatus(bgTemplateInfoOld.getTemplateStatus());
            bgTemplateInfoNew.setParent(bgTemplateInfoOld);
            canModify = bgTemplateInfoOld.getCanModify();
            isAllowChange = bgTemplateInfoOld.getIsAllowChange();
            bgTemplateInfoNew.setIsAllowChange(isAllowChange);
            bgTemplateInfoNew.setCanModify(canModify);
            bgTemplateInfoNew.setId(BOSUuid.create((BOSObjectType)bgTemplateInfoOld.getBOSType()));
            this._coverChildBook(ctx, bgTemplateInfoOld, bgTemplateInfoNew, isEnumateForm);
            this.createBgTemEntries(ctx, bgTemplateInfoOld, bgTemplateInfoNew);
            templateNewPK = iBgTemplate.submit((CoreBaseInfo)bgTemplateInfoNew);
            ibgctrl.ctrlAssignTemplate(bgTemplateInfoOld.getId(), BOSUuid.read((String)templateNewPK.toString()));
            iBgExamineNode.schemeExamineUpdate(bgTemplateInfoNew.getId().toString(), examineIds);
        } else if (isUpdateBgTemplate) {
            canModify = bgTemplateInfoOld.getCanModify();
            isAllowChange = bgTemplateInfoOld.getIsAllowChange();
            _bgTemplateInfoNew = iBgTemplate.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(_bgTemplateInfoNew.getId()), this.getTemplageSelectors());
            _bgTemplateInfoNew.setName(bgTemplateInfoOld.getName());
            _bgTemplateInfoNew.setNumber(bgTemplateInfoOld.getNumber());
            _bgTemplateInfoNew.setIsAllowChange(isAllowChange);
            _bgTemplateInfoNew.setCanModify(canModify);
            _bgTemplateInfoNew.setRootId(bgTemplateInfoOld.getRootId());
            _bgTemplateInfoNew.setDefaultMeasureUnit(bgTemplateInfoOld.getDefaultMeasureUnit());
            _bgTemplateInfoNew.setBgType(bgTemplateInfoOld.getBgType());
            _bgTemplateInfoNew.setDescription(bgTemplateInfoOld.getDescription());
            _bgTemplateInfoNew.setTemplateStatus(bgTemplateInfoOld.getTemplateStatus());
            bgTemplateInfoNew = _bgTemplateInfoNew;
            if (isCoverChild) {
                this._coverChildBook(ctx, bgTemplateInfoOld, bgTemplateInfoNew, isEnumateForm);
                templateNewPK = iBgTemplate.submit((CoreBaseInfo)bgTemplateInfoNew);
                ibgctrl.ctrlAssignTemplate(bgTemplateInfoOld.getId(), BOSUuid.read((String)templateNewPK.toString()));
                iBgExamineNode.schemeExamineUpdate(bgTemplateInfoNew.getId().toString(), examineIds);
                if (isUpdateBgForm && !isScript && !isSpecialForm) {
                    this._updateBgFormInfo(ctx, (IObjectValue)bgTemplateInfoNew, bgSchemeInfoNew.getId().toString());
                }
            } else if (_bgTemplateInfoNew.getData() == null) {
                this._coverChildBook(ctx, bgTemplateInfoOld, bgTemplateInfoNew, isEnumateForm);
                templateNewPK = iBgTemplate.submit((CoreBaseInfo)bgTemplateInfoNew);
                ibgctrl.ctrlAssignTemplate(bgTemplateInfoOld.getId(), BOSUuid.read((String)templateNewPK.toString()));
                iBgExamineNode.schemeExamineUpdate(_bgTemplateInfoNew.getId().toString(), examineIds);
                if (isUpdateBgForm) {
                    this._updateBgFormInfo(ctx, (IObjectValue)bgTemplateInfoNew, bgSchemeInfoNew.getId().toString());
                }
            } else {
                this._updateBgTemplateInfoOfSchemeToThisOrg(ctx, bgTemplateInfoOld, bgTemplateInfoNew, isUpdateBgForm, bgSchemeInfoNew.getId().toString());
                iBgExamineNode.schemeExamineUpdate(_bgTemplateInfoNew.getId().toString(), examineIds);
            }
        }
        BgSchemeNodeCollection bgsNodeCol = bgSchemeInfoNew.getBgSchemeNodes();
        boolean templateIsExit = false;
        if (bgsNodeCol != null) {
            int colSize = bgsNodeCol.size();
            for (int j = 0; j < colSize; ++j) {
                if (bgsNodeCol.get(j) == null || bgsNodeCol.get(j).getBgTemplate() == null || bgTemplateInfoNew == null || bgTemplateInfoNew.getId() == null || bgsNodeCol.get(j).getBgTemplate().getId() == null || !bgsNodeCol.get(j).getBgTemplate().getId().toString().equals(bgTemplateInfoNew.getId().toString())) continue;
                templateIsExit = true;
                break;
            }
        }
        if (!templateIsExit) {
            BgSchemeNodeInfo bgSchemeNodeInfo = new BgSchemeNodeInfo();
            bgSchemeNodeInfo.setBgTemplate(bgTemplateInfoNew);
            bgSchemeNodeInfo.setBgScheme(bgSchemeInfoNew);
            if (bgsNodeCol != null) {
                bgsNodeCol.add(bgSchemeNodeInfo);
            }
        }
        iBgScheme.save((CoreBaseInfo)bgSchemeInfoNew);
        boolean isFormalUpdateSuccess = false;
        isFormalUpdateSuccess = bgSchemeInfo.isIsFormal() ? this.schemeInvoke(ctx, bgSchemeInfoNew.getId().toString(), true) : this.schemeInvInvoke(ctx, bgSchemeInfoNew.getId().toString(), true);
        String RESORRCE_TEM = "com.kingdee.eas.ma.budget.TemplateSchemeUpdateResource";
        HashMap<SchemeAssignMsgObj, String> map = new HashMap<SchemeAssignMsgObj, String>();
        Locale local = ctx.getLocale();
        SchemeAssignMsgObj key = new SchemeAssignMsgObj("ORG_ASSIG", ResourceBase.getString((String)RESORRCE_TEM, (String)"assign.org", (Locale)local), 0);
        map.put(key, ((FullOrgUnitInfo)org).getName());
        key = new SchemeAssignMsgObj("BG_Scheme", ResourceBase.getString((String)RESORRCE_TEM, (String)"bgscheme", (Locale)local), -1);
        map.put(key, bgSchemeInfoNew.getName());
        key = new SchemeAssignMsgObj("ASSING_ISFMALE_STATUS", ResourceBase.getString((String)RESORRCE_TEM, (String)"bgscheme.invoke.result", (Locale)local), 1);
        if (isFormalUpdateSuccess) {
            map.put(key, ResourceBase.getString((String)RESORRCE_TEM, (String)"success", (Locale)local));
        } else {
            map.put(key, ResourceBase.getString((String)RESORRCE_TEM, (String)"failFormal", (Locale)local));
        }
        key = new SchemeAssignMsgObj("BG_TEMPLATE", ResourceBase.getString((String)RESORRCE_TEM, (String)"bgtemplate", (Locale)local), 2);
        map.put(key, bgTemplateInfoNew != null ? bgTemplateInfoNew.getName() : "");
        key = new SchemeAssignMsgObj("BG_TEMPLATE_RESULT", ResourceBase.getString((String)RESORRCE_TEM, (String)"bgtemplate.assign.result", (Locale)local), 3);
        map.put(key, ResourceBase.getString((String)RESORRCE_TEM, (String)"success", (Locale)local));
        return map;
    }

    private void upExpressionWithOldTem(Context ctx, Book oldBook, Book newBook) throws Exception {
        int i;
        Map oldAliasMap = new HashMap();
        Sheet sheet = null;
        String rowID = null;
        String colID = null;
        Row row = null;
        Column column = null;
        Map sheetAliasMap = null;
        Integer rIndex = null;
        Integer cIndex = null;
        Cell newCell = null;
        Cell oldCell = null;
        BgNFSHelper.disableCal((Book)oldBook);
        BgNFSHelper.disableUndo((Book)oldBook);
        BgNFSHelper.disableCal((Book)newBook);
        BgNFSHelper.disableUndo((Book)newBook);
        for (i = 0; i < oldBook.getSheetCount(); ++i) {
            sheet = oldBook.getSheet(i);
            oldAliasMap = BgNAssignUpdateUtil.getSuperiorTableInfo((Sheet)sheet, (String)sheet.getID(), oldAliasMap);
        }
        for (i = 0; i < newBook.getSheetCount(); ++i) {
            sheet = newBook.getSheet(i);
            int rowCount = sheet.getMaxRowIndex() + 1;
            int colCount = sheet.getMaxColIndex() + 1;
            sheetAliasMap = (Map)oldAliasMap.get(sheet.getID());
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = sheet.getRow(rowIndex, false);
                if (!BgNFSHelper.checkHasSign((Row)row)) continue;
                rowID = BgNFSHelper.getRowSign((Row)row);
                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                    column = sheet.getColumn(colIndex, false);
                    if (!BgNFSHelper.checkHasSign((Column)column)) continue;
                    colID = BgNFSHelper.getColSign((Column)column);
                    newCell = sheet.getCell(rowIndex, colIndex, false);
                    if (sheetAliasMap == null || sheetAliasMap.get("SIGN_ROW_ID") == null || sheetAliasMap.get("SIGN_COL_ID") == null) {
                        if (!BgNFSHelper.checkHasExpression((Cell)newCell) || BgNFSHelper.isLockOfCell((Cell)newCell) || BgNTemplateHelper.hasForceLock((Cell)newCell)) continue;
                        BgNTemplateHelper.removeDataValue((Cell)newCell, (String)"BG_BUDGET_EXPRESSIONS", (boolean)false);
                        BgNTemplateHelper.removeDataValue((Cell)newCell, (String)"BG_ACTUAL_EXPRESSIONS", (boolean)false);
                        BgNTemplateHelper.removeDataValue((Cell)newCell, (String)"BG_ADD_EXPRESSIONS", (boolean)false);
                        newCell.setFormula(null);
                        continue;
                    }
                    rIndex = (Integer)((Map)sheetAliasMap.get("SIGN_ROW_ID")).get(rowID);
                    cIndex = (Integer)((Map)sheetAliasMap.get("SIGN_COL_ID")).get(colID);
                    if (rIndex != null && cIndex != null) {
                        oldCell = oldBook.getSheetByID(sheet.getID()).getCell(rIndex.intValue(), cIndex.intValue(), true);
                        if (newCell == null || newCell.isLocked() || BgNTemplateHelper.hasForceLock((Cell)newCell)) continue;
                        String[] expr = new String[]{BgNTemplateHelper.getBgDataValue((Cell)oldCell, (String)"BG_BUDGET_EXPRESSIONS"), BgNTemplateHelper.getBgDataValue((Cell)oldCell, (String)"BG_ACTUAL_EXPRESSIONS"), BgNTemplateHelper.getBgDataValue((Cell)oldCell, (String)"BG_ADD_EXPRESSIONS")};
                        if (!(expr[0] != null && expr[0].trim().length() >= 1 || expr[1] != null && expr[1].trim().length() >= 1 || expr[2] != null && expr[2].trim().length() >= 1)) {
                            BgNTemplateHelper.removeDataValue((Cell)newCell, (String)"BG_BUDGET_EXPRESSIONS", (boolean)false);
                            BgNTemplateHelper.removeDataValue((Cell)newCell, (String)"BG_ACTUAL_EXPRESSIONS", (boolean)false);
                            BgNTemplateHelper.removeDataValue((Cell)newCell, (String)"BG_ADD_EXPRESSIONS", (boolean)false);
                            if (!BgNFSHelper.checkHasExpression((Cell)newCell)) continue;
                            newCell.setFormula(null);
                            continue;
                        }
                        if (expr[0] == null || expr[0].trim().length() < 1) {
                            BgNTemplateHelper.removeDataValue((Cell)newCell, (String)"BG_BUDGET_EXPRESSIONS", (boolean)false);
                        } else {
                            BgNTemplateHelper.setBgDataValue((Cell)newCell, (String)"BG_BUDGET_EXPRESSIONS", (Object)expr[0], (boolean)false);
                        }
                        if (expr[1] == null || expr[1].trim().length() < 1) {
                            BgNTemplateHelper.removeDataValue((Cell)newCell, (String)"BG_ACTUAL_EXPRESSIONS", (boolean)false);
                        } else {
                            BgNTemplateHelper.setBgDataValue((Cell)newCell, (String)"BG_ACTUAL_EXPRESSIONS", (Object)expr[1], (boolean)false);
                        }
                        if (expr[2] == null || expr[2].trim().length() < 1) {
                            BgNTemplateHelper.removeDataValue((Cell)newCell, (String)"BG_ADD_EXPRESSIONS", (boolean)false);
                        } else {
                            BgNTemplateHelper.setBgDataValue((Cell)newCell, (String)"BG_ADD_EXPRESSIONS", (Object)expr[2], (boolean)false);
                        }
                        if (expr[0] != null && expr[0].toString().trim().length() > 0) {
                            newCell.setFormula(expr[0]);
                            continue;
                        }
                        if (!BgNFSHelper.checkHasExpression((Cell)newCell)) continue;
                        newCell.setFormula(null);
                        continue;
                    }
                    if ((!BgNFSHelper.checkHasExpression((Cell)newCell) || BgNFSHelper.isLockOfCell((Cell)newCell)) && !BgNTemplateHelper.hasForceLock((Cell)newCell)) continue;
                    BgNTemplateHelper.removeDataValue((Cell)newCell, (String)"BG_BUDGET_EXPRESSIONS", (boolean)false);
                    BgNTemplateHelper.removeDataValue((Cell)newCell, (String)"BG_ACTUAL_EXPRESSIONS", (boolean)false);
                    BgNTemplateHelper.removeDataValue((Cell)newCell, (String)"BG_ADD_EXPRESSIONS", (boolean)false);
                    newCell.setFormula(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getErrorList(Context ctx, String orgUnitId, String bgSchemeId, String[] bgPeriodCollIds) throws BOSException, EASBizException {
        ResultSet rs = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        List finalList = new ArrayList();
        try {
            conn = this.getConnection(ctx);
            Vector<String> temCollVec = new Vector<String>();
            String getTemSQL = "select * from t_bg_bgschemenode where fbgschemeid = ?";
            pstmt = conn.prepareStatement(getTemSQL);
            pstmt.setString(1, bgSchemeId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                temCollVec.add(rs.getString("fbgtemplateid"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            _tmpList.add(orgUnitId);
            _tmpList.add(bgSchemeId);
            _tmpList.addAll(temCollVec);
            if (bgPeriodCollIds != null) {
                int in = bgPeriodCollIds.length;
                for (int i = 0; i < in; ++i) {
                    _tmpList.add(bgPeriodCollIds[i]);
                }
            }
            Vector<String> temp = new Vector<String>();
            StringBuffer sb = new StringBuffer();
            sb.append("select FID from t_bg_bgform where forgunitid = ? ");
            sb.append("and fbgschemeid = ? ");
            if (!temCollVec.isEmpty()) {
                sb.append(" and fbgtemplateid in (");
                sb.append(BgNSQLHelper.getParamSizeString(temCollVec)).append(")");
            }
            if (bgPeriodCollIds != null && bgPeriodCollIds.length > 0) {
                sb.append(" and fbgperiodid in (");
                sb.append(BgNSQLHelper.getParamSizeString((int)bgPeriodCollIds.length)).append(")");
            }
            pstmt = conn.prepareStatement(sb.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                temp.add(rs.getString("fid"));
            }
            finalList = this.dealList(ctx, temp, temCollVec, bgPeriodCollIds);
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
        return finalList;
    }

    private List dealList(Context ctx, Vector bgformId, Vector temCollVec, String[] bgPeriodCollIds) throws Exception {
        Connection conn = null;
        conn = this.getConnection(ctx);
        ArrayList finalList = new ArrayList();
        try {
            IBgTemplate ibgtem = BgTemplateFactory.getLocalInstance(ctx);
            IBgPeriod ibgperiod = BgPeriodFactory.getLocalInstance(ctx);
            IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
            for (int i = 0; i < temCollVec.size(); ++i) {
                for (int j = 0; j < bgPeriodCollIds.length; ++j) {
                    String state;
                    if (bgformId.size() == 0) {
                        Vector<String> vec = new Vector<String>();
                        BgTemplateInfo bgteminfo = ibgtem.getBgTemplateInfo((IObjectPK)new ObjectUuidPK((String)temCollVec.get(i)));
                        BgPeriodInfo bgperiodinfo = ibgperiod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriodCollIds[j]));
                        state = ResourceBase.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"notExist", (Locale)ContextUtils.getLocaleFromEnv());
                        vec.add(bgteminfo.getName());
                        vec.add(bgperiodinfo.getName());
                        vec.add(state);
                        finalList.add(vec);
                        continue;
                    }
                    int seq = this.inFormVec(ctx, bgformId, (String)temCollVec.get(i), bgPeriodCollIds[j]);
                    if (seq >= 0) {
                        String id = (String)bgformId.get(seq);
                        BgFormInfo bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(id));
                        state = bgFormInfo.getState().getAlias();
                        if (state.equals(BgFormStateEnum.Edited.getAlias()) || state.equals(BgFormStateEnum.Approved.getAlias()) || state.equals(BgFormStateEnum.Approving.getAlias()) || state.equals(BgFormStateEnum.REFERRING.getAlias())) continue;
                        Vector<String> vec = new Vector<String>();
                        BgTemplateInfo bgteminfo = ibgtem.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getBgTemplate().getId().toString()));
                        BgPeriodInfo bgperiodinfo = ibgperiod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getBgPeriod().getId().toString()));
                        vec.add(bgteminfo.getName());
                        vec.add(bgperiodinfo.getName());
                        vec.add(state);
                        finalList.add(vec);
                        continue;
                    }
                    Vector<String> vec = new Vector<String>();
                    BgTemplateInfo bgteminfo = ibgtem.getBgTemplateInfo((IObjectPK)new ObjectUuidPK((String)temCollVec.get(i)));
                    BgPeriodInfo bgperiodinfo = ibgperiod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriodCollIds[j]));
                    String state2 = ResourceBase.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"notExist", (Locale)ContextUtils.getLocaleFromEnv());
                    vec.add(bgteminfo.getName());
                    vec.add(bgperiodinfo.getName());
                    vec.add(state2);
                    finalList.add(vec);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int inFormVec(Context ctx, Vector bgFormIdVec, String bgTemplateId, String bgPeriodId) throws Exception {
        int seq = -1;
        BgFormInfo bgFormInfo = null;
        try {
            for (int k = 0; k < bgFormIdVec.size(); ++k) {
                String id = (String)bgFormIdVec.get(k);
                bgFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(id));
                if (!bgFormInfo.getBgTemplate().getId().toString().equalsIgnoreCase(bgTemplateId) || !bgFormInfo.getBgPeriod().getId().toString().equalsIgnoreCase(bgPeriodId)) continue;
                seq = k;
                break;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            if (bgFormInfo != null) {
                bgFormInfo.clear();
            }
        }
        return seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getCorrectFormList(Context ctx, String orgUnitId, String bgSchemeId, String[] bgPeriodCollIds) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        Vector<String> vec = new Vector<String>();
        Vector<String> vecs = new Vector<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        BgFormInfo bgforminfo = null;
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        try {
            conn = this.getConnection(ctx);
            Vector<String> temCollVec = new Vector<String>();
            String getTemSQL = "select fbgtemplateid from t_bg_bgschemenode where fbgschemeid = ?";
            pstmt = conn.prepareStatement(getTemSQL);
            pstmt.setString(1, bgSchemeId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                temCollVec.add(rs.getString("fbgtemplateid"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            _tmpList.add(orgUnitId);
            _tmpList.add(bgSchemeId);
            _tmpList.addAll(temCollVec);
            if (bgPeriodCollIds != null) {
                int in = bgPeriodCollIds.length;
                for (int i = 0; i < in; ++i) {
                    _tmpList.add(bgPeriodCollIds[i]);
                }
            }
            _tmpList.add(new Integer(1));
            _tmpList.add(new Integer(25));
            _tmpList.add(new Integer(102));
            StringBuffer sb = new StringBuffer();
            sb.append("select fid,fstate from t_bg_bgform where forgunitid = ? and fbgschemeid = ? ");
            if (!temCollVec.isEmpty()) {
                sb.append(" and fbgtemplateid in (");
                sb.append(BgNSQLHelper.getParamSizeString((int)temCollVec.size())).append(")");
            }
            if (bgPeriodCollIds != null && bgPeriodCollIds.length > 0) {
                sb.append(" and fbgperiodid in (");
                sb.append(BgNSQLHelper.getParamSizeString((int)bgPeriodCollIds.length)).append(")");
            }
            sb.append(" and fstate in (?,?,?)");
            pstmt = conn.prepareStatement(sb.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getInt("fstate") == BgFormStateEnum.Edited.getValue() || rs.getInt("fstate") == BgFormStateEnum.EditeCompleted.getValue()) {
                    vec.add(rs.getString("fid"));
                    continue;
                }
                vecs.add(rs.getString("fid"));
            }
            if (!vecs.isEmpty()) {
                int i;
                vec.addAll(vecs);
                String[] ids = new String[vecs.size()];
                for (i = 0; i < ids.length; ++i) {
                    ids[i] = (String)vecs.get(i);
                }
                ids = EnactmentServiceFactory.createEnactService((Context)ctx).checkBizObjInWfProcess(ids);
                if (ids != null && ids.length > 0) {
                    for (i = 0; i < ids.length; ++i) {
                        vec.remove(ids[i]);
                    }
                }
            }
            for (int i = 0; i < vec.size(); ++i) {
                IBgForm ibgform = BgFormFactory.getLocalInstance(ctx);
                bgforminfo = ibgform.getBgFormInfo((IObjectPK)new ObjectUuidPK((String)vec.get(i)));
                Vector<Object> temp = new Vector<Object>();
                temp.add(bgforminfo.getId().toString());
                temp.add(bgforminfo.getNumber());
                temp.add((Object)bgforminfo.getState());
                list.add(temp);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
        return list;
    }

    public static List tranVector2String(Vector idVector) {
        if (idVector == null || idVector.size() < 1) {
            return null;
        }
        StringBuffer sqlInner = new StringBuffer();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Iterator iter = idVector.iterator();
        String[] param = new String[500];
        Object[] mapStrParam = new Object[2];
        int i = 0;
        while (iter.hasNext()) {
            if (i >= 500) {
                mapStrParam[0] = sqlInner;
                mapStrParam[1] = param;
                list.add(mapStrParam);
                mapStrParam = new Object[2];
                i = 0;
                param = new String[500];
            }
            if (i == 0) {
                sqlInner.append("?");
            } else {
                sqlInner.append(",?");
            }
            param[i] = (String)iter.next();
            ++i;
        }
        if (i > 0) {
            mapStrParam[0] = sqlInner;
            mapStrParam[1] = param;
            list.add(mapStrParam);
        }
        return list;
    }

    @Override
    protected void _updateBgFormFromNewTempate(Context ctx, String bgtemlateID, String formID, boolean isFromTemplateAssign, Map templateCtrlModeMap, Map defCtrlModeMap) throws BOSException, EASBizException {
        this._updateBgFormFromNewTempate(ctx, bgtemlateID, formID, isFromTemplateAssign, templateCtrlModeMap, defCtrlModeMap, null);
    }

    @Override
    protected void _updateBgFormFromNewTempate(Context ctx, String bgtemlateID, String formID, boolean isFromTemplateAssign, Map templateCtrlModeMap, Map defCtrlModeMap, Map sheetMap) throws BOSException, EASBizException {
        boolean isBySheet = false;
        Set<Object> filterSheet = null;
        if (sheetMap != null && !sheetMap.isEmpty()) {
            isBySheet = true;
            filterSheet = new HashSet();
            filterSheet = sheetMap.keySet();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("formType"));
        sic.add("postils.postilType");
        sic.add("postils.description");
        sic.add("postils.cellName");
        sic.add("postils.reportType");
        sic.add("postils.lastUpdateTime");
        sic.add("postils.createTime");
        sic.add("postils.sheet.sheetID");
        sic.add("defaultMeasureUnit.id");
        BgTemplateInfo bgTempateInfo = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgtemlateID), sic);
        if (bgTempateInfo == null) {
            throw new BOSException("templateIsNull");
        }
        boolean isAdjustFormula = BgCatchUtil.isAdjustFormula(ctx);
        Book bookToInit = null;
        Book bookTo = null;
        Book bookSource = null;
        Sheet template = null;
        Sheet sheet = null;
        Sheet updateAcutal = null;
        Sheet updateActualAdd = null;
        Map superAliasMap = null;
        Map updateAliasMap = null;
        HashMap formulasMap = new HashMap();
        Map[] itemExpressionMap = new HashMap[]{new HashMap(), new HashMap(), new HashMap()};
        Map mapProTectSourse = new HashMap();
        Map mapProTectTo = new HashMap();
        Book[] bookArrayUpdate = new Book[3];
        boolean isEnumateForm = false;
        boolean isSelfDefAnalyseForm = false;
        boolean isTempHasHide = false;
        boolean isChildHasHide = false;
        if (bgTempateInfo.getBgType() != null && "BV/FQwEUEADgABtLwKgSXv9s2OA=".equals(bgTempateInfo.getBgType().getId().toString())) {
            isSelfDefAnalyseForm = true;
        }
        if (bgTempateInfo.getFormType().equals((Object)BgTemFormTypeEnum.ENUMERATEFORM)) {
            isEnumateForm = true;
        }
        try {
            bookSource = bgTempateInfo.getBook();
            Map enumInfo = null;
            if (isEnumateForm) {
                enumInfo = BgNAssignUpdateUtil.getEnumerateMap((Book)bookSource);
            }
            isTempHasHide = BgNFSHelper.isHasHideRowOrCol((Book)bookSource);
            mapProTectSourse = BgNLockProtectHelper.clearChildTemplateBookProAndSheetPro((Book)bookSource);
            BgNFSHelper.disableUndo(bookTo);
            BgNFSHelper.disableCal(bookTo);
            BgFormInfo bgFormInfo = null;
            IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
            if (ibgForm == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(formID), this.getBgFormInfo());
            bgFormInfo.setMeasureUnit(bgTempateInfo.getDefaultMeasureUnit());
            BgFormInfo _bgFormInfo = (BgFormInfo)bgFormInfo.clone();
            if (bgFormInfo != null && bgFormInfo.getZipData() != null && bookSource != null) {
                Sheet _template;
                int index;
                bookToInit = bgFormInfo.getBook();
                isChildHasHide = BgNFSHelper.isHasHideRowOrCol((Book)bookToInit);
                Book _bookToInit = _bgFormInfo.getBook();
                mapProTectTo = BgNLockProtectHelper.clearChildTemplateBookProAndSheetPro((Book)bookToInit);
                BgNFSHelper.disableUndo((Book)bookToInit);
                bookTo = Book.Manager.getNewBook((String)bookToInit.getName(), (int)0);
                bookTo.setCalculate(false);
                BgNFSHelper.disableUndo((Book)bookTo);
                int bookCount = bookToInit.getSheetCount();
                for (int i = 0; i < bookCount; ++i) {
                    bookTo.addSheet(bookToInit.getSheet(i));
                }
                this.copyBookUserObject(bookTo, bookToInit);
                this.updateBookUserObject(bookTo, bookSource);
                for (index = bookTo.getSheetCount() - 1; index >= 0; --index) {
                    template = bookTo.getSheet(index);
                    if (template == null || StringUtils.isEmpty((String)BgNFSHelper.getSheetSign((Sheet)template)) || isBySheet && filterSheet != null && !filterSheet.contains(BgNFSHelper.getSheetSign((Sheet)template))) continue;
                    sheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId((String)BgNFSHelper.getSheetSign((Sheet)template), (Book)bookSource);
                    if (sheet == null) {
                        sheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateSheetID((String)template.getID(), (Book)bookSource);
                    }
                    if (sheet != null) continue;
                    if (bookTo.getSheetCount() == 1) {
                        bookTo = Book.Manager.getNewBook((String)bookToInit.getName(), (int)0);
                        BgNFSHelper.disableUndo((Book)bookTo);
                        continue;
                    }
                    bookTo.removeSheet(template);
                }
                int count = bookSource.getSheetCount();
                for (index = 0; index < count; ++index) {
                    template = bookSource.getSheet(index);
                    if (template == null || isBySheet && filterSheet != null && !filterSheet.contains(BgNFSHelper.getSheetSign((Sheet)template))) continue;
                    sheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId((String)BgNFSHelper.getSheetSign((Sheet)template), (Book)bookTo);
                    if (sheet == null) {
                        sheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateSheetID((String)template.getID(), (Book)bookTo);
                    }
                    if (sheet != null) continue;
                    Sheet sheetNew = new Sheet(bookTo, template.getSheetName());
                    sheetNew = BgNAssignUpdateUtil.CopySheet((Sheet)template, (Sheet)sheetNew);
                    sheetNew.setID(template.getID());
                    BgNFSHelper.setSheetSign((Sheet)sheetNew);
                    BgNTemplateHelper.updateAliasTemplate((Sheet)sheetNew);
                    sheetNew.setUserObject("SIGN_DATA_SOURCE", (Object)"DATA_SOURCE_TEMPLATE");
                    bookTo.insertSheet(index, sheetNew);
                }
                if (isAdjustFormula) {
                    bookArrayUpdate = BgTemplateFacade.synchronizationSeparateFormulaBook((Book)bookTo, filterSheet);
                } else {
                    bookArrayUpdate[0] = bookTo;
                }
                count = bookSource.getSheetCount();
                for (index = 0; index < count; ++index) {
                    PrintSetup src_setting;
                    template = bookSource.getSheet(index);
                    _template = _bookToInit.getSheet(index);
                    if (template == null || isBySheet && filterSheet != null && !filterSheet.contains(BgNFSHelper.getSheetSign((Sheet)template))) continue;
                    sheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId((String)BgNFSHelper.getSheetSign((Sheet)template), (Book)bookTo);
                    if (sheet == null || !template.getID().equals(sheet.getID())) {
                        sheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateSheetID((String)template.getID(), (Book)bookTo);
                    }
                    superAliasMap = BgNAssignUpdateUtil.transSheet((Sheet)template, null, (boolean)false);
                    updateAliasMap = BgNAssignUpdateUtil.transSheet((Sheet)sheet, null, (boolean)false);
                    sheet.setEnableCalculation(false);
                    if (isAdjustFormula) {
                        updateAcutal = bookArrayUpdate[1].getSheetByID(sheet.getID());
                        updateActualAdd = bookArrayUpdate[2].getSheetByID(sheet.getID());
                        updateAcutal.setEnableCalculation(false);
                        updateActualAdd.setEnableCalculation(false);
                    }
                    if (template != null && (src_setting = template.getSheetOption().getPrintSetup(false)) != null) {
                        sheet.getSheetOption().getPrintSetup(true).copyFrom(src_setting);
                    }
                    sheet.setName(template.getSheetName());
                    this.updateTableInfo(ctx, template, sheet, updateAcutal, updateActualAdd, superAliasMap, updateAliasMap, true, true, (IObjectValue)bgFormInfo, formulasMap, itemExpressionMap, true, isFromTemplateAssign, bgTempateInfo.getFormType(), isSelfDefAnalyseForm, enumInfo);
                    if (isTempHasHide || isChildHasHide) {
                        BgNFSHelper.synchronizeHideRowOrCol((Sheet)template, (Sheet)sheet);
                    }
                    if (_template != null) {
                        this.upSheetSplit(sheet, _template);
                    }
                    sheet.clearStyleCache();
                }
                count = bookSource.getSheetCount();
                for (index = 0; index < count; ++index) {
                    template = bookSource.getSheet(index);
                    _template = _bookToInit.getSheet(index);
                    if (template == null || isBySheet && filterSheet != null && !filterSheet.contains(BgNFSHelper.getSheetSign((Sheet)template))) continue;
                    sheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId((String)BgNFSHelper.getSheetSign((Sheet)template), (Book)bookTo);
                    if (sheet == null || !template.getID().equals(sheet.getID())) {
                        sheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateSheetID((String)template.getID(), (Book)bookTo);
                    }
                    superAliasMap = BgNAssignUpdateUtil.transSheet((Sheet)template, null, (boolean)false);
                    updateAliasMap = BgNAssignUpdateUtil.transSheet((Sheet)sheet, null, (boolean)false);
                    sheet.setEnableCalculation(true);
                    if (isAdjustFormula) {
                        updateAcutal = bookArrayUpdate[1].getSheetByID(sheet.getID());
                        updateActualAdd = bookArrayUpdate[2].getSheetByID(sheet.getID());
                        updateAcutal.setEnableCalculation(true);
                        updateActualAdd.setEnableCalculation(true);
                    }
                    sheet.setName(template.getSheetName());
                    this.updateTableInfoValue(ctx, template, sheet, updateAcutal, updateActualAdd, superAliasMap, updateAliasMap, true, true, (IObjectValue)bgFormInfo, formulasMap, itemExpressionMap, true, isFromTemplateAssign, bgTempateInfo.getFormType(), isSelfDefAnalyseForm, enumInfo);
                    sheet.clearStyleCache();
                }
                if (isAdjustFormula) {
                    bookTo = BgTemplateFacade.synchronizationFormulaCombineBook((Book[])bookArrayUpdate, filterSheet);
                }
                this.checkFormulaOfTables(bookTo, ctx);
                BgNLockProtectHelper.reCombinProMap(mapProTectSourse, mapProTectTo);
                Map map = BgNAssignUpdateUtil.getDefaultChildTemFormProMap((Book)bgFormInfo.getBook());
                BgNLockProtectHelper.reCombinProMap((Map)map, mapProTectTo);
                BgNLockProtectHelper.reDoChildTemplateBookProAndSheetPro((Book)bgFormInfo.getBook(), mapProTectTo, (boolean)isEnumateForm);
                this.upEnumeraterArea(ctx, bookSource, bookTo);
                this.upBookWithEnumerate(ctx, bookTo, bgFormInfo.getOrgUnit().getId().toString(), filterSheet);
                BgPeriodNVariableHelper.convertPeriodNvalue(bookTo, bgFormInfo.getBgPeriod().getNumber(), 0, bgFormInfo.getBgPeriod().getPeriodType().getValue(), filterSheet);
                BgNFSHelper.removeBookNullSign((Book)bookTo, filterSheet);
                if (bgTempateInfo.getBgType() != null && "BV/FQwEUEADgABtLwKgSXv9s2OA=".equals(bgTempateInfo.getBgType())) {
                    BgExpressionsItemVariableHelper.batchRebuildExpressions((Book)bookTo, (String)bgFormInfo.getOrgUnit().getId().toString(), (IObjectValue)bgFormInfo, (Context)ctx, filterSheet);
                }
                if (bgTempateInfo.getFormType() == BgTemFormTypeEnum.ENUMERATEFORM) {
                    if (isSelfDefAnalyseForm) {
                        BgExpressionsItemVariableHelper.batchRebuildExpressions((Book)bookTo, (String)bgFormInfo.getOrgUnit().getId().toString(), (IObjectValue)bgFormInfo, (Context)ctx, filterSheet);
                    } else {
                        BgAutoEnurameHelper.batchRebuildExpressions((Book)bookTo, (IObjectValue)bgFormInfo, (String)"bgData", (Context)ctx, filterSheet);
                    }
                }
                Sheet valiSheet = null;
                ValidationList validationList = null;
                ValidationList bgFormValiList = null;
                Validation val = null;
                if (sheet != null) {
                    for (int n = 0; n < bookSource.getSheetCount(); ++n) {
                        int m;
                        SortedCellBlockArray sa;
                        valiSheet = bookSource.getSheet(n);
                        if (isBySheet && filterSheet != null && !filterSheet.contains(BgNFSHelper.getSheetSign((Sheet)valiSheet)) || (validationList = valiSheet.getValidations()) == null || validationList.size() == 0 || (sa = sheet.getSheetOption().getSelection().toSortedBlocks()) == null || sa.isEmpty()) continue;
                        bgFormValiList = bookTo.getSheet(n).getValidations();
                        for (m = 0; m < bgFormValiList.size(); ++m) {
                            bgFormValiList.getValidation(m).setMessagedValidate(null);
                        }
                        bookTo.getSheet(n).getValidations().reduce();
                        for (m = 0; m < validationList.size(); ++m) {
                            val = validationList.getValidation(m);
                            bookTo.getSheet(n).getValidations().addValidation(val);
                        }
                    }
                }
                bgFormInfo.setBook(bookTo);
                if (!isBySheet) {
                    bgFormInfo.setTemplateLastUpdateTime(bgTempateInfo.getLastUpdateTime());
                }
                BgFormInfo infoTem = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(formID), this.getBgFormInfo());
                bgFormInfo.remove("SIGN_DIV_DATA");
                ibgForm.submit(bgFormInfo.getId(), (IObjectValue)bgFormInfo, true);
                this.updatePostil(ctx, bgFormInfo.getId().toString(), bgTempateInfo.getPostils());
                IBgCtrSettingFacade ibgctrl = BgCtrSettingFacadeFactory.getLocalInstance(ctx);
                ibgctrl.ctrlUpdate(BOSUuid.read((String)bgtemlateID), templateCtrlModeMap, defCtrlModeMap, bgFormInfo.getId());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BgException(BgException.OTHERERROR, ex, new String[]{ex.getMessage()});
        }
    }

    private void updatePostil(Context ctx, String formId, BgTemplatePostilCollection postils) throws BOSException {
        if (formId == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            BgFormInfo bgFormInfo = new BgFormInfo();
            bgFormInfo.setId(BOSUuid.read((String)formId));
            HashMap<String, RptSheetParamInfo> sheetParams = new HashMap<String, RptSheetParamInfo>();
            String temId = null;
            if (postils.get(0) != null) {
                temId = postils.get(0).getTemplate().getId().toString();
            }
            String sql2 = "DELETE FROM t_rpt_rptsheetpara WHERE freportid=?";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{formId});
            IRptSheetParam ir = RptSheetParamFactory.getLocalInstance((Context)ctx);
            String sql3 = "Select * FROM t_rpt_rptsheetpara WHERE freportid=?";
            if (temId != null) {
                IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql3, (Object[])new Object[]{temId});
                while (row.next()) {
                    RptSheetParamInfo rpSheetInfo = new RptSheetParamInfo();
                    rpSheetInfo.setReport((VirtualSheetParamInfo)bgFormInfo);
                    rpSheetInfo.setSheetID(row.getString("fsheetid"));
                    rpSheetInfo.setSheetName(row.getString("fsheetname"));
                    rpSheetInfo.setRelaType(ReportTypeEnum.getEnum((int)row.getInt("frelatype")));
                    sheetParams.put(rpSheetInfo.getSheetID(), rpSheetInfo);
                    ir.addnew((CoreBaseInfo)rpSheetInfo);
                }
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("DELETE FROM t_rpt_rptpostil WHERE Freportid = ? ");
            pstmt.setString(1, formId);
            pstmt.executeUpdate();
            if (postils != null) {
                BgTemplatePostilInfo temPostilInfo = null;
                for (int i = 0; i < postils.size(); ++i) {
                    temPostilInfo = postils.get(i);
                    PostilInfo postilInfo = new PostilInfo();
                    postilInfo.setDescription(temPostilInfo.getDescription());
                    postilInfo.setCreateTime(temPostilInfo.getCreateTime());
                    postilInfo.setLastUpdateTime(temPostilInfo.getLastUpdateTime());
                    postilInfo.setCellName(temPostilInfo.getCellName());
                    postilInfo.setItemNumber(temPostilInfo.getItemNumber());
                    postilInfo.setSheet((RptSheetParamInfo)sheetParams.get(temPostilInfo.getSheet().getSheetID()));
                    postilInfo.setPostilType(temPostilInfo.getPostilType());
                    postilInfo.setReportType(temPostilInfo.getReportType());
                    postilInfo.setReport((ReportBaseInfo)bgFormInfo);
                    PostilFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)postilInfo);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _updateBgFormFromNewTempate(Context ctx, String bgtemlateID, String formID, boolean isFromTemplateAssign) throws BOSException, EASBizException {
        this._updateBgFormFromNewTempate(ctx, bgtemlateID, formID, isFromTemplateAssign, null, null);
    }

    private void copyBookUserObject(Book toBook, Book fromBook) {
        SortedUserObjectArray userObjectS = fromBook.getUserObjects();
        if (userObjectS == null || userObjectS.isEmpty()) {
            return;
        }
        int size = userObjectS.size();
        for (int i = 0; i < size; ++i) {
            UserObject userObject = userObjectS.getUserObject(i);
            toBook.setUserObject(userObject.getKey(), userObject.getValue());
        }
        Object _obj = fromBook.getUserObjectValue("VARIABLES");
        if (_obj != null) {
            toBook.setUserObject("VARIABLES", _obj);
        }
        if ((_obj = fromBook.getUserObjectValue("AUTO_CALCULATOR")) != null) {
            toBook.setUserObject("AUTO_CALCULATOR", _obj);
        }
    }

    private void updateTableInfo(Context ctx, Sheet source, Sheet update, Sheet updateAcutal, Sheet updateActualAdd, Map superAliasMap, Map tranAliasMap, boolean isUpdateValue, boolean isCheckFormula, IObjectValue obj, Map formulasMap, Map[] itemExpressionMap, boolean isUpdateForm, boolean isFromSchemeAssign, BgTemFormTypeEnum formType, boolean isSelfDefAnalyseForm, Map enumInfo) throws Exception {
        boolean isEnumateForm = formType.equals((Object)BgTemFormTypeEnum.ENUMERATEFORM);
        if (source == null || update == null || superAliasMap == null || tranAliasMap == null) {
            return;
        }
        update.setHide(source.isHide());
        Map rowAlias = null;
        Map colAlias = null;
        Map upRowAlias = new HashMap();
        Map upColAlias = new HashMap();
        if (superAliasMap.containsKey("row_id_map")) {
            rowAlias = (Map)superAliasMap.get("row_id_map");
        }
        if (superAliasMap.containsKey("col_id_map")) {
            colAlias = (Map)superAliasMap.get("col_id_map");
        }
        upRowAlias = (Map)tranAliasMap.get("row_id_map");
        upColAlias = (Map)tranAliasMap.get("col_id_map");
        Map superEnum = BgNAssignUpdateUtil.getEnumMap(enumInfo == null ? null : (Map)enumInfo.get(source.getID()));
        BgNAssignUpdateUtil.insertCols((Sheet)source, (Sheet)update, (Sheet)updateAcutal, (Sheet)updateActualAdd, upColAlias, (boolean)isUpdateForm);
        BgNAssignUpdateUtil.insertRows((Sheet)source, (Sheet)update, (Sheet)updateAcutal, (Sheet)updateActualAdd, upRowAlias, (Map)superEnum, (boolean)isUpdateForm);
        BgNAssignUpdateUtil.removerCol((Sheet)update, (Sheet)updateAcutal, (Sheet)updateActualAdd, (Map)colAlias, upColAlias);
        BgNAssignUpdateUtil.removerRows((Sheet)update, (Sheet)updateAcutal, (Sheet)updateActualAdd, (Map)rowAlias, upRowAlias);
    }

    private void updateTableInfoValue(Context ctx, Sheet source, Sheet update, Sheet updateAcutal, Sheet updateActualAdd, Map superAliasMap, Map tranAliasMap, boolean isUpdateValue, boolean isCheckFormula, IObjectValue obj, Map formulasMap, Map[] itemExpressionMap, boolean isUpdateForm, boolean isFromSchemeAssign, BgTemFormTypeEnum formType, boolean isSelfDefAnalyseForm, Map enumInfo) throws Exception {
        boolean isEnumateForm = formType.equals((Object)BgTemFormTypeEnum.ENUMERATEFORM);
        if (source == null || update == null || superAliasMap == null || tranAliasMap == null) {
            return;
        }
        update.setHide(source.isHide());
        Map rowAlias = null;
        Map colAlias = null;
        Map upRowAlias = new HashMap();
        Map upColAlias = new HashMap();
        if (superAliasMap.containsKey("row_id_map")) {
            rowAlias = (Map)superAliasMap.get("row_id_map");
        }
        if (superAliasMap.containsKey("col_id_map")) {
            colAlias = (Map)superAliasMap.get("col_id_map");
        }
        upRowAlias = (Map)tranAliasMap.get("row_id_map");
        upColAlias = (Map)tranAliasMap.get("col_id_map");
        Map superEnum = BgNAssignUpdateUtil.getEnumMap(enumInfo == null ? null : (Map)enumInfo.get(source.getID()));
        this.updateSuperiorInfo(ctx, source, update, updateAcutal, updateActualAdd, upRowAlias, upColAlias, isUpdateValue, isCheckFormula, obj, formulasMap, itemExpressionMap, isUpdateForm, isFromSchemeAssign, formType, isSelfDefAnalyseForm);
        if (!isEnumateForm) {
            this.dealMergeManager(update, source);
        }
        this.upSheetSplit(update, source);
    }

    protected void dealMergeManager(Sheet nSheet, Sheet sheet) {
        MergeBlocks mblist;
        if (nSheet == null || sheet == null) {
            return;
        }
        int top = 0;
        int left = 0;
        nSheet.getSheetOption().getMerger(true).clear();
        if (sheet.getMerger(false) != null && (mblist = sheet.getMerger(false)) != null && !mblist.isEmpty()) {
            for (int n = 0; n < mblist.size(); ++n) {
                CellBlock cellBlock = mblist.getBlock(n);
                top = cellBlock.getRow();
                left = cellBlock.getCol();
                sheet.getCell(top, left, true).getStyle();
                nSheet.getCell(top, left, true).setSSA(sheet.getCell(top, left, true).getSSA());
                nSheet.getRange(top, left, cellBlock.getRow2(), cellBlock.getCol2()).merge();
                nSheet.getSheetOption().getMerger(true).insert((Object)cellBlock);
            }
        }
    }

    private void updateSuperiorInfo(Context ctx, Sheet source, Sheet update, Sheet updateAcutal, Sheet updateActualAdd, Map rowAlias, Map colAlias, boolean isUpdateValue, boolean isCheckFormula, IObjectValue obj, Map formulasMap, Map[] itemExpressionMap, boolean isUpdateForm, boolean isFromTemplateAssign, BgTemFormTypeEnum formType, boolean isSelfDefAnalyseForm) throws Exception {
        Row row = null;
        Column column = null;
        String rowId = null;
        String colId = null;
        int rowCount = source.getMaxRowIndex() + 1;
        int colCount = source.getMaxColIndex() + 1;
        int upRowIndex = -1;
        int upColIndex = -1;
        String companyNumber = BgNExpressionHelper.getCompanyNumber((Context)ctx, (IObjectValue)obj);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = source.getRow(rowIndex, false);
            boolean hasItemVariable = BgExpressionsItemVariableHelper.checkRowHasBgItemVariable((Sheet)source, (int)rowIndex);
            if (row == null || BgNFSHelper.getRowSign((Row)row) == null) continue;
            rowId = BgNFSHelper.getRowSign((Row)row);
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                column = source.getColumn(colIndex, false);
                if (column == null || BgNFSHelper.getColSign((Column)column) == null) continue;
                colId = BgNFSHelper.getColSign((Column)column);
                if (!rowAlias.containsKey(rowId) || !colAlias.containsKey(colId)) continue;
                upRowIndex = this.getIndex(rowAlias, rowId);
                upColIndex = this.getIndex(colAlias, colId);
                BgNAssignUpdateUtil.UpdateTemplateNewCellToFormCell((Context)ctx, (int)rowIndex, (int)colIndex, (int)upRowIndex, (int)upColIndex, (Map)formulasMap, (Map[])itemExpressionMap, (boolean)isCheckFormula, (IObjectValue)obj, (boolean)isUpdateForm, (Sheet)source, (Sheet)update, (Sheet)updateAcutal, (Sheet)updateActualAdd, (boolean)isFromTemplateAssign, (BgTemFormTypeEnum)formType, (boolean)isSelfDefAnalyseForm, (boolean)hasItemVariable, (String)companyNumber);
            }
        }
        update.setUserObject("SHEET_CREATER_ID", (Object)((String)source.getUserObjectValue("SHEET_CREATER_ID")));
    }

    private int getIndex(Map aliasMap, String id) {
        if (aliasMap == null || StringUtils.isEmpty((String)id)) {
            return -1;
        }
        if (aliasMap.get(id) instanceof BgRowColIdObject) {
            return ((BgRowColIdObject)aliasMap.get(id)).getCurrIndex();
        }
        return (Integer)aliasMap.get(id);
    }

    protected Map addRows(Sheet superior, Sheet update, Sheet updateAcutal, Sheet updateActualAdd, boolean isUpdateForm, boolean isEnumateForm) {
        Row row = null;
        Row tempRow = null;
        String uuid = null;
        String tempId = null;
        String[] uuids = null;
        HashMap<String, Integer> tempRows = new HashMap<String, Integer>();
        int in = update.getMaxRowIndex() + 1;
        for (int i = 0; i < in; ++i) {
            row = update.getRow(i, false);
            if (BgNFSHelper.getRowSign((Row)row) == null) continue;
            uuid = BgNFSHelper.getRowSign((Row)row);
            tempRows.put(uuid, new Integer(i));
        }
        int rowCount = superior.getMaxRowIndex();
        int jn = rowCount;
        for (int j = 0; j <= jn; ++j) {
            int x;
            row = superior.getRow(j, false);
            if (BgNFSHelper.getRowSign((Row)row) == null || BgNFSHelper.checkHasNullSign((Row)row) && isEnumateForm || tempRows.containsKey(uuid = BgNFSHelper.getRowSign((Row)row))) continue;
            uuids = new String[3];
            uuids[1] = uuid;
            int xn = 0;
            for (x = j - 1; xn <= x; --x) {
                tempRow = superior.getRow(x, false);
                if (BgNFSHelper.getRowSign((Row)tempRow) == null || !tempRows.containsKey(tempId = BgNFSHelper.getRowSign((Row)tempRow))) continue;
                uuids[0] = tempId;
                break;
            }
            xn = rowCount;
            for (x = j + 1; xn >= x; ++x) {
                tempRow = superior.getRow(x, false);
                if (BgNFSHelper.getRowSign((Row)tempRow) == null || !tempRows.containsKey(tempId = BgNFSHelper.getRowSign((Row)tempRow))) continue;
                uuids[2] = tempId;
                break;
            }
            this.insertRow(uuids, update, updateAcutal, updateActualAdd, tempRows, isUpdateForm);
        }
        return tempRows;
    }

    protected Map addCols(Sheet superior, Sheet update, Sheet updateAcutal, Sheet updateActualAdd, boolean isUpdateForm, boolean isEnumateForm) {
        Column column = null;
        Column tempColumn = null;
        String uuid = null;
        String tempId = null;
        String[] uuids = null;
        HashMap<String, Integer> tempCols = new HashMap<String, Integer>();
        int in = update.getMaxColIndex() + 1;
        for (int i = 0; i < in; ++i) {
            column = update.getColumn(i, false);
            if (column == null || !BgNFSHelper.checkHasSign((Column)column)) continue;
            uuid = BgNFSHelper.getColSign((Column)column);
            tempCols.put(uuid, new Integer(i));
        }
        int colCount = superior.getMaxColIndex();
        int jn = colCount;
        for (int j = 0; jn >= j; ++j) {
            int x;
            column = superior.getColumn(j, false);
            if (column == null || !BgNFSHelper.checkHasSign((Column)column) || tempCols.containsKey(uuid = BgNFSHelper.getColSign((Column)column))) continue;
            uuids = new String[3];
            uuids[1] = uuid;
            int xn = 0;
            for (x = j - 1; xn <= x; --x) {
                tempColumn = superior.getColumn(x, false);
                if (tempColumn == null || !BgNFSHelper.checkHasSign((Column)tempColumn) || !tempCols.containsKey(tempId = BgNFSHelper.getColSign((Column)tempColumn))) continue;
                uuids[0] = tempId;
                break;
            }
            xn = colCount;
            for (x = j + 1; xn >= x; ++x) {
                tempColumn = superior.getColumn(x, false);
                if (tempColumn == null || !BgNFSHelper.checkHasSign((Column)tempColumn) || !tempCols.containsKey(tempId = BgNFSHelper.getColSign((Column)tempColumn))) continue;
                uuids[2] = tempId;
                break;
            }
            this.insertCol(uuids, update, updateAcutal, updateActualAdd, tempCols, isUpdateForm);
        }
        return tempCols;
    }

    protected void insertRow(String[] uuids, Sheet update, Sheet updateAcutal, Sheet updateActualAdd, Map rowsAlias, boolean isUpdateForm) {
        int botRowIndex;
        boolean isAdjustFormula = BgCatchUtil.isAdjustFormula(null);
        Row currRow = null;
        int topRowIndex = uuids[0] == null ? -1 : (Integer)rowsAlias.get(uuids[0]);
        int n = botRowIndex = uuids[2] == null ? -1 : (Integer)rowsAlias.get(uuids[2]);
        if (topRowIndex > update.getMaxRowIndex()) {
            topRowIndex = update.getMaxRowIndex() + 1;
        }
        if (botRowIndex > update.getMaxRowIndex()) {
            botRowIndex = update.getMaxRowIndex() + 1;
        }
        if (topRowIndex >= 0 && botRowIndex >= 0) {
            currRow = BgNFSHelper.addRowWithOutMode((Sheet)update, (int)(botRowIndex == 0 ? 0 : botRowIndex));
            if (isAdjustFormula) {
                BgNFSHelper.addRowWithOutMode((Sheet)updateAcutal, (int)(botRowIndex == 0 ? 0 : botRowIndex));
                BgNFSHelper.addRowWithOutMode((Sheet)updateActualAdd, (int)(botRowIndex == 0 ? 0 : botRowIndex));
            }
        } else if (topRowIndex == -1 && botRowIndex >= 0) {
            currRow = BgNFSHelper.addRowWithOutMode((Sheet)update, (int)(botRowIndex == 0 ? 0 : botRowIndex));
            if (isAdjustFormula) {
                BgNFSHelper.addRowWithOutMode((Sheet)updateAcutal, (int)(botRowIndex == 0 ? 0 : botRowIndex));
                BgNFSHelper.addRowWithOutMode((Sheet)updateActualAdd, (int)(botRowIndex == 0 ? 0 : botRowIndex));
            }
        } else if (topRowIndex >= 0 && botRowIndex == -1) {
            currRow = BgNFSHelper.addRowWithOutMode((Sheet)update, (int)(topRowIndex + 1));
            if (isAdjustFormula) {
                BgNFSHelper.addRowWithOutMode((Sheet)updateAcutal, (int)(topRowIndex + 1));
                BgNFSHelper.addRowWithOutMode((Sheet)updateActualAdd, (int)(topRowIndex + 1));
            }
        } else {
            int currRowIndex = update.getMaxRowIndex() == -1 ? 0 : update.getMaxRowIndex();
            currRow = BgNFSHelper.addRowWithOutMode((Sheet)update, (int)currRowIndex);
            if (isAdjustFormula) {
                BgNFSHelper.addRowWithOutMode((Sheet)updateAcutal, (int)(topRowIndex + 1));
                BgNFSHelper.addRowWithOutMode((Sheet)updateActualAdd, (int)(topRowIndex + 1));
            }
        }
        this.addAliasValue(rowsAlias, currRow.getRow());
        BgNFSHelper.setRowSign((Row)currRow, (String)uuids[1]);
        if (isUpdateForm) {
            BgNFSHelper.setRowObject((Row)currRow, (String)"SIGN_DATA_SOURCE", (Object)"DATA_SOURCE_TEMPLATE");
        } else {
            BgNFSHelper.setRowObject((Row)currRow, (String)"SIGN_DATA_SOURCE", (Object)"DATA_SOURCE_SUPERIOR");
        }
        rowsAlias.put(uuids[1], new Integer(currRow.getRow()));
    }

    protected void addAliasValue(Map aliasMap, int aliasValue) {
        if (aliasMap == null || aliasMap.isEmpty()) {
            return;
        }
        String aliasId2 = null;
        Integer value = null;
        for (String aliasId2 : aliasMap.keySet()) {
            value = (Integer)aliasMap.get(aliasId2);
            if (value == null || value < aliasValue) continue;
            value = new Integer(value + 1);
            aliasMap.put(aliasId2, value);
        }
    }

    protected void insertCol(String[] uuids, Sheet update, Sheet updateAcutal, Sheet updateActualAdd, Map colsAlias, boolean isUpdateForm) {
        int rightColIndex;
        Column column = null;
        boolean isAdjustFormula = BgCatchUtil.isAdjustFormula(null);
        int leftColIndex = uuids[0] == null ? -1 : (Integer)colsAlias.get(uuids[0]);
        int n = rightColIndex = uuids[2] == null ? -1 : (Integer)colsAlias.get(uuids[2]);
        if (leftColIndex > update.getMaxColIndex()) {
            leftColIndex = update.getMaxColIndex() + 1;
        }
        if (rightColIndex > update.getMaxColIndex()) {
            rightColIndex = update.getMaxColIndex() + 1;
        }
        if (leftColIndex >= 0 && rightColIndex >= 0) {
            column = BgNFSHelper.addColumnWithOutMode((Sheet)update, (int)(rightColIndex < 0 ? 0 : rightColIndex));
            if (isAdjustFormula) {
                BgNFSHelper.addColumnWithOutMode((Sheet)updateAcutal, (int)(rightColIndex < 0 ? 0 : rightColIndex));
                BgNFSHelper.addColumnWithOutMode((Sheet)updateActualAdd, (int)(rightColIndex < 0 ? 0 : rightColIndex));
            }
        } else if (leftColIndex == -1 && rightColIndex >= 0) {
            column = BgNFSHelper.addColumnWithOutMode((Sheet)update, (int)(rightColIndex < 0 ? 0 : rightColIndex));
            if (isAdjustFormula) {
                BgNFSHelper.addColumnWithOutMode((Sheet)updateAcutal, (int)(rightColIndex < 0 ? 0 : rightColIndex));
                BgNFSHelper.addColumnWithOutMode((Sheet)updateActualAdd, (int)(rightColIndex < 0 ? 0 : rightColIndex));
            }
        } else if (leftColIndex >= 0 && rightColIndex == -1) {
            column = BgNFSHelper.addColumnWithOutMode((Sheet)update, (int)(leftColIndex + 1));
            if (isAdjustFormula) {
                BgNFSHelper.addColumnWithOutMode((Sheet)updateAcutal, (int)(leftColIndex + 1));
                BgNFSHelper.addColumnWithOutMode((Sheet)updateActualAdd, (int)(leftColIndex + 1));
            }
        } else {
            int currentColIndex = update.getMaxColIndex() == -1 ? 0 : update.getMaxColIndex();
            column = BgNFSHelper.addColumnWithOutMode((Sheet)update, (int)currentColIndex);
            if (isAdjustFormula) {
                BgNFSHelper.addColumnWithOutMode((Sheet)updateAcutal, (int)currentColIndex);
                BgNFSHelper.addColumnWithOutMode((Sheet)updateActualAdd, (int)currentColIndex);
            }
        }
        if (column == null) {
            logger.error((Object)"column is null when invoke method insertCol in class BgSchemeFacadeControlBean");
            return;
        }
        this.addAliasValue(colsAlias, column.getCol());
        BgNFSHelper.setColSign((Column)column, (String)uuids[1]);
        if (isUpdateForm) {
            BgNFSHelper.setColObject((Column)column, (String)"SIGN_DATA_SOURCE", (Object)"DATA_SOURCE_TEMPLATE");
        } else {
            BgNFSHelper.setColObject((Column)column, (String)"SIGN_DATA_SOURCE", (Object)"SIGN_DATA_SOURCE");
        }
        colsAlias.put(uuids[1], new Integer(column.getCol()));
    }

    protected void removeRows(Sheet table, Sheet updateAcutal, Sheet updateActualAdd, Map rowAlias, Map upRowAlias, boolean isUpdateForm, boolean isEnumateForm) {
        if (table == null || rowAlias == null || upRowAlias == null) {
            return;
        }
        boolean isAdjustFormula = BgCatchUtil.isAdjustFormula(null);
        Row row = null;
        String uuid = null;
        int rowCount = table.getMaxRowIndex() + 1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = table.getRow(rowIndex, false);
            if (row == null) {
                BgNFSHelper.removeRow((Sheet)table, (int)rowIndex);
                this.subAliasValue(upRowAlias, rowIndex);
                --rowIndex;
                --rowCount;
                continue;
            }
            if (BgNFSHelper.checkHasSign((Row)row)) {
                uuid = BgNFSHelper.getRowSign((Row)row);
                if (isUpdateForm) {
                    if (!BgNTemplateHelper.isDataSourceTemplate((Row)row) && !BgNFSHelper.checkHasEnumerateOfRow((Row)row, (int)table.getMaxColIndex()) || rowAlias.containsKey(uuid)) continue;
                    BgNFSHelper.removeRow((Sheet)table, (int)row.getRow());
                    if (isAdjustFormula) {
                        BgNFSHelper.removeRow((Sheet)updateAcutal, (int)row.getRow());
                        BgNFSHelper.removeRow((Sheet)updateActualAdd, (int)row.getRow());
                    }
                    --rowIndex;
                    --rowCount;
                    upRowAlias.remove(uuid);
                    this.subAliasValue(upRowAlias, row.getRow());
                    continue;
                }
                if (!BgNTemplateHelper.isDataSourceSuperior((Row)row) && !BgNFSHelper.checkHasEnumerateOfRow((Row)row, (int)table.getMaxColIndex()) || rowAlias.containsKey(uuid)) continue;
                BgNFSHelper.removeRow((Sheet)table, (int)row.getRow());
                if (isAdjustFormula) {
                    BgNFSHelper.removeRow((Sheet)updateAcutal, (int)row.getRow());
                    BgNFSHelper.removeRow((Sheet)updateActualAdd, (int)row.getRow());
                }
                --rowIndex;
                --rowCount;
                upRowAlias.remove(uuid);
                this.subAliasValue(upRowAlias, row.getRow());
                continue;
            }
            BgNFSHelper.removeRow((Sheet)table, (int)row.getRow());
            this.subAliasValue(upRowAlias, row.getRow());
            --rowIndex;
            --rowCount;
        }
    }

    protected void removeCols(Sheet table, Sheet updateAcutal, Sheet updateActualAdd, Map colAlias, Map upColAlias, boolean isUpdateForm, boolean isEnumateForm) {
        int colIndex;
        if (table == null || colAlias == null || upColAlias == null) {
            return;
        }
        boolean isAdjustFormula = BgCatchUtil.isAdjustFormula(null);
        Column column = null;
        String uuid = null;
        int colCount = table.getMaxColIndex() + 1;
        for (colIndex = 0; colIndex < colCount; ++colIndex) {
            column = table.getColumn(colIndex, false);
            if (column == null || !BgNFSHelper.checkHasSign((Column)column)) continue;
            uuid = BgNFSHelper.getColSign((Column)column);
        }
        colCount = table.getMaxColIndex() + 1;
        for (colIndex = 0; colIndex < colCount; ++colIndex) {
            column = table.getColumn(colIndex, false);
            if (column == null) {
                BgNFSHelper.removeColumn((Sheet)table, (int)colIndex);
                this.subAliasValue(upColAlias, colIndex);
                --colIndex;
                --colCount;
                continue;
            }
            if (BgNFSHelper.checkHasSign((Column)column)) {
                uuid = BgNFSHelper.getColSign((Column)column);
                if (isUpdateForm) {
                    if (!BgNTemplateHelper.isDataSourceTemplate((Column)column) || colAlias.containsKey(uuid)) continue;
                    BgNFSHelper.removeColumn((Sheet)table, (int)column.getCol());
                    if (isAdjustFormula) {
                        BgNFSHelper.removeColumn((Sheet)updateActualAdd, (int)column.getCol());
                        BgNFSHelper.removeColumn((Sheet)updateAcutal, (int)column.getCol());
                    }
                    --colIndex;
                    --colCount;
                    upColAlias.remove(uuid);
                    this.subAliasValue(upColAlias, column.getCol());
                    continue;
                }
                if (!BgNTemplateHelper.isDataSourceSuperior((Column)column) || colAlias.containsKey(uuid)) continue;
                BgNFSHelper.removeColumn((Sheet)table, (int)column.getCol());
                if (isAdjustFormula) {
                    BgNFSHelper.removeColumn((Sheet)updateActualAdd, (int)column.getCol());
                    BgNFSHelper.removeColumn((Sheet)updateAcutal, (int)column.getCol());
                }
                --colIndex;
                --colCount;
                upColAlias.remove(uuid);
                this.subAliasValue(upColAlias, column.getCol());
                continue;
            }
            BgNFSHelper.removeColumn((Sheet)table, (int)column.getCol());
            this.subAliasValue(upColAlias, column.getCol());
            --colIndex;
            --colCount;
        }
    }

    protected void subAliasValue(Map aliasMap, int aliasValue) {
        if (aliasMap == null || aliasMap.isEmpty()) {
            return;
        }
        String aliasId2 = null;
        Integer value = null;
        for (String aliasId2 : aliasMap.keySet()) {
            value = (Integer)aliasMap.get(aliasId2);
            if (value == null || value < aliasValue) continue;
            value = new Integer(value - 1);
            aliasMap.put(aliasId2, value);
        }
    }

    @Override
    protected Map _getEditedBgFormId_TemplateId_Map_ByBgTemplateIDArray(Context ctx, String[] templateIdArray) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select A.fid id,A.FTemplateLastUpdateTime,A.fname").append(" formName,A.frecord frecord,B.FLastUpdateTime,B.fname").append(" templateName,A.FBgTemplateID fbgtemplateid \n from t_bg_bgform A inner join t_bg_bgtemplate B ").append(" on a.FBgTemplateID = b.Fid ").append("\n\t where ( \r\n\t( B.FLastUpdateTime > A.FTemplateLastUpdateTime and A.FTemplateLastUpdateTime is not null) ").append(" \r\n\t or\t(B.FLastUpdateTime > A.fcreatetime  and A.FTemplateLastUpdateTime is null) \r\n ) and (");
        if (templateIdArray.length < 0) {
            return null;
        }
        int length = templateIdArray.length;
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sql.append("\n\t\t A.FBgTemplateID = '" + templateIdArray[i] + "' ");
                continue;
            }
            sql.append("\n\t\t or A.FBgTemplateID = '" + templateIdArray[i] + "' ");
        }
        sql.append(" ) and A.FState=1");
        logger.debug((Object)("_getEditedBgFormId_TemplateId_Map_ByBgTemplateIDArray sql = " + sql));
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<BgFormInfo, BgTemplateInfo> mapReturn = new HashMap<BgFormInfo, BgTemplateInfo>();
        String formId = null;
        String bgtemplateId = null;
        BgFormInfo forminfo = null;
        BgTemplateInfo templateinfo = null;
        try {
            while (row.next()) {
                if (row.getInt("frecord") != 0) continue;
                formId = row.getString("id");
                bgtemplateId = row.getString("fbgtemplateid");
                forminfo = new BgFormInfo();
                forminfo.setId(BOSUuid.read((String)formId));
                forminfo.setName(row.getString("formName"));
                templateinfo = new BgTemplateInfo();
                templateinfo.setId(BOSUuid.read((String)bgtemplateId));
                templateinfo.setName(row.getString("templateName"));
                mapReturn.put(forminfo, templateinfo);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"", (Throwable)sqle);
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"52_BgSchemeFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return mapReturn;
    }

    @Override
    protected void _updateDownSchemeSubmitWay(Context ctx, boolean isSubmitByScheme, boolean isReportByScheme, String bgSchemeId) throws BOSException, EASBizException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append("update t_bg_bgscheme set fissubmitbyscheme = ?, fisreportbyscheme = ? where fparentschemeid= ? or frootid = ?");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setInt(1, isSubmitByScheme ? 1 : 0);
            ps.setInt(2, isReportByScheme ? 1 : 0);
            ps.setString(3, bgSchemeId);
            ps.setString(4, bgSchemeId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)connection);
    }

    private BgSchemeInfo schemeAssginDetailBgschem(Context ctx, BgSchemeInfo bgSchemeInfo, BgSchemeInfo bgSchemeInfoNew, FullOrgUnitInfo orgUnitInfo, IBgScheme iBgScheme) throws EASBizException, BOSException {
        String orgId = orgUnitInfo.getId().toString();
        if (this.isHasAssignSchemeToThisOrg(ctx, bgSchemeInfo.getId().toString(), bgSchemeInfo.getRootId().toString(), orgId)) {
            BOSUuid schemeRootId = bgSchemeInfo.getRootId();
            bgSchemeInfoNew = iBgScheme.getBgSchemeInfo("select fid where orgUnit.id='" + orgId + "' and rootId = '" + schemeRootId + "'");
            bgSchemeInfoNew = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeInfoNew.getId()), this.getSelectors());
            bgSchemeInfoNew.setName(bgSchemeInfo.getName());
            bgSchemeInfoNew.setNumber(bgSchemeInfo.getNumber());
            bgSchemeInfoNew.setDateFrom(bgSchemeInfo.getDateFrom());
            bgSchemeInfoNew.setDateTo(bgSchemeInfo.getDateTo());
            bgSchemeInfoNew.setPeriod(bgSchemeInfo.getPeriod());
            bgSchemeInfoNew.setIsSubmitByScheme(bgSchemeInfo.isIsSubmitByScheme());
        } else {
            bgSchemeInfoNew = bgSchemeInfo.deepClone();
            bgSchemeInfoNew.setId(BOSUuid.create((BOSObjectType)bgSchemeInfo.getBOSType()));
            bgSchemeInfoNew.setOrgUnit(orgUnitInfo);
            bgSchemeInfoNew.setCU(orgUnitInfo.getCU());
            bgSchemeInfoNew.setNumber(bgSchemeInfo.getNumber());
            bgSchemeInfoNew.setName(bgSchemeInfo.getName());
            bgSchemeInfoNew.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bgSchemeInfoNew.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            bgSchemeInfoNew.setParentScheme(bgSchemeInfo);
            bgSchemeInfoNew.setIsSubmitByScheme(bgSchemeInfo.isIsSubmitByScheme());
            bgSchemeInfoNew.setIsFormal(false);
            bgSchemeInfoNew.setRootId(bgSchemeInfo.getRootId());
        }
        return bgSchemeInfoNew;
    }

    private void updataBgFormUnit(Context ctx, BgTemplateInfo bgTemplateInfoNew) throws BOSException {
        String sql = "update t_bg_bgform set FMeasureUnitID=? where FBgTemplateID=? and FState=?";
        Object[] param = new Object[]{bgTemplateInfoNew.getDefaultMeasureUnit() != null ? bgTemplateInfoNew.getDefaultMeasureUnit().getId().toString() : "", bgTemplateInfoNew.getId().toString(), Integer.valueOf("1")};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
    }

    @Override
    protected boolean _invokeDestroyMethod(Context ctx, Set templateSet) throws BOSException, EASBizException {
        String temId2 = null;
        for (String temId2 : templateSet) {
            if (temId2 == null) continue;
            BgCatchUtil.destroyEXAMPINEIDCatch(temId2);
            BgCatchUtil.destroyKDFCatch(temId2);
            BgCatchUtil.destroyIsAdjustFormula();
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _updateBgFormInfo(Context ctx, IObjectValue model, String bgSchemeId) throws BOSException, EASBizException {
        if (model == null) {
            throw new BgTemplateException(BgTemplateException.ISCANTMODELNULL);
        }
        BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)model;
        if (bgTemplateInfo.getId() == null) {
            throw new BgTemplateException(BgTemplateException.ISCANTIDNULL);
        }
        if (bgTemplateInfo.getZipData() == null) {
            throw new BgTemplateException(BgTemplateException.ISCANTMODELNULL);
        }
        ArrayList<String> formIds = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
            if (ibgForm == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID,FBgSchemeID from T_BG_BgForm where FBgTemplateId = ? and FState = ?  and FRecord=? ");
            pstmt.setString(1, bgTemplateInfo.getId().toString());
            pstmt.setInt(2, 1);
            pstmt.setInt(3, 0);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String schemeid = rst.getString(2);
                if (!bgSchemeId.equals(schemeid)) continue;
                formIds.add(rst.getString(1));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw ex;
                catch (EASBizException ex2) {
                    logger.error((Object)"", (Throwable)ex2);
                    throw ex2;
                }
                catch (SQLException ex3) {
                    logger.error((Object)"", (Throwable)ex3);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
                catch (Exception ex4) {
                    logger.error((Object)"", (Throwable)ex4);
                    throw new BgException(BgException.OTHERERROR, new String[]{ex4.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        if (!formIds.isEmpty()) {
            Map templateCtrlMap = BgCtrSettingFacadeFactory.getLocalInstance(ctx).getTemplateCtrlSetting(bgTemplateInfo.getId(), null);
            try {
                BgCtrlSetHelper.fillNoCtrlRecord(bgTemplateInfo.getBook(), templateCtrlMap);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            templateCtrlMap = (Map)templateCtrlMap.get("ctrlModeMap");
            Hashtable defCtrlMap = BgCtrSettingFacadeFactory.getLocalInstance(ctx).getDefCtrlSetByTemplateID(bgTemplateInfo.getId().toString());
            for (int i = 0; i < formIds.size(); ++i) {
                this._updateBgFormFromNewTempate(ctx, bgTemplateInfo.getId().toString(), formIds.get(i).toString(), true, templateCtrlMap, defCtrlMap);
            }
        }
        return true;
    }

    @Override
    protected boolean _updateBgTemplateInfoOfSchemeToThisOrg(Context ctx, BgTemplateInfo superTemplateInfo, BgTemplateInfo chileTemplateInfo, boolean isUpdateForm, String bgSchemeId) throws BOSException, EASBizException {
        if (superTemplateInfo == null || chileTemplateInfo == null) {
            throw new BgTemplateException(BgTemplateException.ISCANTIDNULL);
        }
        SimpleTimer timer = new SimpleTimer();
        boolean isAdjustFormula = BgCatchUtil.isAdjustFormula(ctx);
        Book bookSource = null;
        Book toBookInit = null;
        int index = 0;
        int count = 0;
        Sheet superior = null;
        Sheet update = null;
        Sheet updateAcutal = null;
        Sheet updateActualAdd = null;
        Map superAliasMap = new HashMap();
        Map updateAliasMap = null;
        Object tempMap = null;
        Object childBgTemplateIdMap = null;
        Connection conn = null;
        HashMap formulaMap = new HashMap();
        Map[] itemExpressionMap = new HashMap[]{new HashMap(), new HashMap(), new HashMap()};
        Map mapProTectSourse = new HashMap();
        Map mapProTectTo = new HashMap();
        Book[] bookArrayUpdate = new Book[3];
        boolean isEnumateForm = false;
        if (superTemplateInfo.getFormType().equals((Object)BgTemFormTypeEnum.ENUMERATEFORM)) {
            isEnumateForm = true;
        }
        boolean isSelfDefAnalyseForm = false;
        if (superTemplateInfo.getBgType() != null && "BV/FQwEUEADgABtLwKgSXv9s2OA=".equals(superTemplateInfo.getBgType().getId().toString())) {
            isSelfDefAnalyseForm = true;
        }
        try {
            IBgTemplate ibgTemplate = BgTemplateFactory.getLocalInstance(ctx);
            boolean childCellIsAllowChange = true;
            if (superTemplateInfo.getIsAllowChange().getValue() == 2) {
                childCellIsAllowChange = false;
            }
            if (superTemplateInfo != null && superTemplateInfo.getZipData() != null) {
                bookSource = BgCatchUtil.getBgKDFCatch(superTemplateInfo);
                Map enumInfo = null;
                if (isEnumateForm) {
                    enumInfo = BgNAssignUpdateUtil.getEnumerateMap((Book)bookSource);
                }
                BgNFSHelper.disableUndo((Book)bookSource);
                BgNFSHelper.disableCal((Book)bookSource);
                mapProTectSourse = BgNLockProtectHelper.clearChildTemplateBookProAndSheetPro((Book)bookSource);
                if (bookSource.getSheetCount() > 0) {
                    if (childCellIsAllowChange) {
                        if (chileTemplateInfo != null && chileTemplateInfo.getData() != null) {
                            toBookInit = chileTemplateInfo.getBook();
                            mapProTectTo = BgNLockProtectHelper.clearChildTemplateBookProAndSheetPro((Book)toBookInit);
                            BgNFSHelper.disableUndo((Book)toBookInit);
                            if (toBookInit != null) {
                                Book toBook = Book.Manager.getNewBook((String)toBookInit.getName(), (int)0);
                                BgNFSHelper.disableUndo((Book)toBook);
                                count = toBookInit.getSheetCount();
                                for (index = 0; index < count; ++index) {
                                    toBook.addSheet(toBookInit.getSheet(index));
                                }
                                toBook.setCalculate(false);
                                this.copyBookUserObject(toBook, bookSource);
                                this.updateBookUserObject(toBook, bookSource);
                                for (index = toBook.getSheetCount() - 1; index > 0; --index) {
                                    superior = toBook.getSheet(index);
                                    if (superior == null || StringUtils.isEmpty((String)BgNFSHelper.getSheetSign((Sheet)superior))) continue;
                                    update = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId((String)BgNFSHelper.getSheetSign((Sheet)superior), (Book)bookSource);
                                    if (update == null) {
                                        update = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateSheetID((String)superior.getID(), (Book)bookSource);
                                    }
                                    if (update != null) continue;
                                    if (toBook.getSheetCount() == 1) {
                                        toBook = Book.Manager.getNewBook((String)toBookInit.getName(), (int)0);
                                        BgNFSHelper.disableUndo((Book)toBook);
                                        continue;
                                    }
                                    toBook.removeSheet(superior);
                                }
                                count = bookSource.getSheetCount();
                                for (index = 0; index < count; ++index) {
                                    superior = bookSource.getSheet(index);
                                    if (superior == null) continue;
                                    update = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId((String)BgNFSHelper.getSheetSign((Sheet)superior), (Book)toBook);
                                    if (update == null) {
                                        update = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateSheetID((String)superior.getID(), (Book)toBook);
                                    }
                                    if (update != null) continue;
                                    Sheet sheet = new Sheet(toBook, superior.getSheetName());
                                    sheet = BgNAssignUpdateUtil.CopySheet((Sheet)superior, (Sheet)sheet);
                                    sheet.setID(superior.getID());
                                    BgNFSHelper.setSheetSign((Sheet)sheet);
                                    BgNTemplateHelper.updateAliasSuperior((Sheet)sheet);
                                    sheet.setUserObject("SIGN_DATA_SOURCE", (Object)"DATA_SOURCE_SUPERIOR");
                                    toBook.addSheet(sheet);
                                }
                                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"53_BgSchemeFacadeControllerBean", (Locale)ctx.getLocale()) + timer.getTime()));
                                if (isAdjustFormula) {
                                    bookArrayUpdate = BgTemplateFacade.synchronizationSeparateFormulaBook((Book)toBook);
                                } else {
                                    bookArrayUpdate[0] = toBook;
                                }
                                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"54_BgSchemeFacadeControllerBean", (Locale)ctx.getLocale()) + timer.getTime()));
                                count = bookSource.getSheetCount();
                                for (index = 0; index < count; ++index) {
                                    superior = bookSource.getSheet(index);
                                    if (superior == null) continue;
                                    update = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId((String)BgNFSHelper.getSheetSign((Sheet)superior), (Book)bookArrayUpdate[0]);
                                    if (update == null) {
                                        update = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateSheetID((String)superior.getID(), (Book)bookArrayUpdate[0]);
                                    }
                                    update.setEnableCalculation(false);
                                    if (isAdjustFormula) {
                                        updateAcutal = bookArrayUpdate[1].getSheetByID(update.getID());
                                        updateActualAdd = bookArrayUpdate[2].getSheetByID(update.getID());
                                        updateAcutal.setEnableCalculation(false);
                                        updateActualAdd.setEnableCalculation(false);
                                    }
                                    superAliasMap = BgNAssignUpdateUtil.transSheet((Sheet)superior, null, (boolean)false);
                                    updateAliasMap = BgNAssignUpdateUtil.transSheet((Sheet)update, null, (boolean)false);
                                    PrintSetup src_setting = superior.getSheetOption().getPrintSetup(false);
                                    if (src_setting != null) {
                                        update.getSheetOption().getPrintSetup(true).copyFrom(src_setting);
                                    }
                                    update.setName(superior.getSheetName());
                                    this.updateTableInfo(ctx, superior, update, updateAcutal, updateActualAdd, superAliasMap, updateAliasMap, true, true, (IObjectValue)chileTemplateInfo, formulaMap, itemExpressionMap, false, true, superTemplateInfo.getFormType(), isSelfDefAnalyseForm, enumInfo);
                                    update.clearStyleCache();
                                }
                                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"55_BgSchemeFacadeControllerBean", (Locale)ctx.getLocale()) + timer.getTime()));
                                if (isAdjustFormula) {
                                    toBook = BgTemplateFacade.synchronizationFormulaCombineBook((Book[])bookArrayUpdate);
                                }
                                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"56_BgSchemeFacadeControllerBean", (Locale)ctx.getLocale()) + timer.getTime()));
                                this.upExpressionWithOldTem(ctx, chileTemplateInfo.getBook(), toBook);
                                this.upEnumeraterArea(ctx, bookSource, toBook);
                                this.upBookWithEnumerate(ctx, toBook, chileTemplateInfo.getOrgUnit().getId().toString(), null);
                                chileTemplateInfo.setBook(toBook);
                            } else {
                                chileTemplateInfo.setBook(null);
                            }
                        } else {
                            this._coverChildBook(ctx, superTemplateInfo, chileTemplateInfo, true);
                        }
                    } else {
                        this._coverChildBook(ctx, superTemplateInfo, chileTemplateInfo, true);
                    }
                    BgNLockProtectHelper.reCombinProMap(mapProTectSourse, mapProTectTo);
                    Book bookTem = chileTemplateInfo.getBook();
                    String orgUnitId = chileTemplateInfo.getOrgUnit().getId().toString();
                    Map map = BgNAssignUpdateUtil.getDefaultChildTemFormProMap((Book)bookTem);
                    BgNLockProtectHelper.reCombinProMap((Map)map, mapProTectTo);
                    BgNLockProtectHelper.reDoChildTemplateBookProAndSheetPro((Book)bookTem, mapProTectTo, (boolean)isEnumateForm);
                    if (superTemplateInfo.getFormType() == BgTemFormTypeEnum.ENUMERATEFORM) {
                        if (superTemplateInfo.getBgType() != null && "BV/FQwEUEADgABtLwKgSXv9s2OA=".equals(superTemplateInfo.getBgType().getId().toString())) {
                            BgExpressionsItemVariableHelper.batchRebuildExpressions((Book)bookTem, (String)orgUnitId, null, (Context)ctx);
                        } else {
                            BgAutoEnurameHelper.batchRebuildExpressions((Book)bookTem, (IObjectValue)chileTemplateInfo, null, (Context)ctx);
                        }
                    }
                    chileTemplateInfo.setBook(bookTem);
                    IObjectPK childTempPK = ibgTemplate.submit((CoreBaseInfo)chileTemplateInfo);
                    IBgCtrSettingFacade ibgctrl = BgCtrSettingFacadeFactory.getLocalInstance(ctx);
                    ibgctrl.ctrlAssignTemplate(superTemplateInfo.getId(), BOSUuid.read((String)childTempPK.toString()));
                    Vector examineIds = null;
                    Object obj = BgCatchUtil.getBgEXAMPINEIDSCatch(superTemplateInfo);
                    if (obj == null) {
                        examineIds = this.getExamineIds(ctx, superTemplateInfo.getId().toString());
                        if (examineIds == null) {
                            BgCatchUtil.putBgEXAMPINEIDCatch(superTemplateInfo.getId().toString(), Boolean.FALSE);
                        } else {
                            BgCatchUtil.putBgEXAMPINEIDCatch(superTemplateInfo.getId().toString(), examineIds);
                        }
                    } else {
                        examineIds = obj instanceof Boolean ? null : (Vector)obj;
                    }
                    BgExamineNodeFactory.getLocalInstance(ctx).schemeExamineUpdate(chileTemplateInfo.getId().toString(), examineIds);
                    if (isUpdateForm) {
                        this._updateBgFormInfo(ctx, (IObjectValue)chileTemplateInfo, bgSchemeId);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Budget:", (Throwable)ex);
            throw new BgException(BgException.OTHERERROR, ex, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(conn);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upBookWithEnumerate(Context ctx, Book toBook, String orgUnitId, Set filterSheet) {
        if (!BgSHelper.isBgItemIsolate(ctx)) {
            orgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        Map enumerArea = null;
        if (toBook == null) {
            return;
        }
        UserObject areaObject = toBook.getUserObject("EnumerAteArea");
        if (areaObject == null) {
            return;
        }
        try {
            byte[] bt = Base64.decode((String)((String)toBook.getUserObject("EnumerAteArea").getValue()));
            enumerArea = (Map)BgAnalyseHelper.getObject(bt);
        }
        catch (Exception e) {
            logger.error((Object)"enmuerate:upBookWithEnumerate", (Throwable)e);
            return;
        }
        Sheet sheet = null;
        Row row = null;
        Column col = null;
        Cell cell = null;
        int maxRow = -1;
        int maxCol = -1;
        String key2 = null;
        Map oneEnum = null;
        BgEnumerateInfo oneEnumInfo = null;
        int itemRB = -1;
        int itemRE = -1;
        int itemCB = -1;
        int itemCE = -1;
        Map itemArea = null;
        String itemSA2 = null;
        String groupAItem = null;
        String[] bgItem = null;
        HashMap canInItem = null;
        BgItemCollection itemColl = null;
        String itemKey = null;
        String isCanSave = "ISCANSAVEWITHENUM";
        Map sheetEnum = null;
        StringBuffer removeCell = new StringBuffer();
        boolean isFilterBySheet = false;
        if (filterSheet != null && !filterSheet.isEmpty()) {
            isFilterBySheet = true;
        }
        try {
            IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
            for (int i = 0; i < toBook.getSheetCount(); ++i) {
                sheet = toBook.getSheet(i);
                if (isFilterBySheet && !filterSheet.contains(BgNFSHelper.getSheetSign((Sheet)sheet))) continue;
                maxRow = sheet.getMaxRowIndex() + 1;
                maxCol = sheet.getMaxColIndex() + 1;
                sheetEnum = (Map)enumerArea.get(sheet.getID());
                if (sheetEnum != null) {
                    for (String key2 : sheetEnum.keySet()) {
                        oneEnum = (Map)sheetEnum.get(key2);
                        oneEnumInfo = new BgEnumerateInfo(oneEnum, sheet, true, true);
                        itemArea = oneEnumInfo.getItemArea();
                        for (String itemSA2 : itemArea.keySet()) {
                            ITableForPrint.IBlock block = BgEnumerateHelper.creatBlock((String)itemSA2);
                            itemRB = block.getRow();
                            itemRE = block.getRow2();
                            itemCB = block.getCol();
                            itemCE = block.getCol2();
                            groupAItem = (String)itemArea.get(itemSA2);
                            if (groupAItem != null) {
                                bgItem = groupAItem.split(":");
                                canInItem = new HashMap();
                                if (bgItem.length == 2) {
                                    bgItem = bgItem[1].split(",");
                                    for (int ia = 0; ia < bgItem.length; ++ia) {
                                        canInItem.put(bgItem[ia], null);
                                    }
                                }
                                if (bgItem.length == 1) {
                                    itemColl = iBgItem.getBgItemCollection("select number where bgItemGroup.number = '" + bgItem[0] + "' and orgUnit.id = '" + orgUnitId + "'");
                                    for (int ic = 0; itemColl != null && ic < itemColl.size(); ++ic) {
                                        canInItem.put(itemColl.get(ic).getNumber(), null);
                                    }
                                }
                            } else {
                                canInItem = null;
                            }
                            for (int rowIndex = itemRB; rowIndex <= itemRE; ++rowIndex) {
                                for (int colIndex = itemCB; colIndex <= itemCE; ++colIndex) {
                                    int clearIndex;
                                    cell = sheet.getCell(rowIndex, colIndex, false);
                                    if (!BgNFSHelper.checkHasBgItemInfo((Cell)cell)) continue;
                                    cell.removeUserObject(isCanSave);
                                    itemKey = BgNFSHelper.getBgItemInfo((Cell)cell)[1];
                                    if (canInItem == null) {
                                        cell.setUserObject(isCanSave, (Object)isCanSave);
                                        for (clearIndex = oneEnumInfo.getColBegin(); clearIndex <= oneEnumInfo.getColEnd(); ++clearIndex) {
                                            cell = sheet.getCell(rowIndex, clearIndex, false);
                                            if (!BgNFSHelper.checkHasItemFormula((Cell)cell)) continue;
                                            cell.setUserObject(isCanSave, (Object)isCanSave);
                                        }
                                        continue;
                                    }
                                    if (canInItem != null && canInItem.containsKey(itemKey)) {
                                        cell.setUserObject(isCanSave, (Object)isCanSave);
                                        for (clearIndex = oneEnumInfo.getColBegin(); clearIndex <= oneEnumInfo.getColEnd(); ++clearIndex) {
                                            cell = sheet.getCell(rowIndex, clearIndex, false);
                                            if (!BgNFSHelper.checkHasItemFormula((Cell)cell)) continue;
                                            cell.setUserObject(isCanSave, (Object)isCanSave);
                                        }
                                        continue;
                                    }
                                    BgNFSHelper.removeBgItemInfo((Cell)cell);
                                    BgNFSHelper.setValue((Cell)cell, null);
                                    removeCell.append("@" + cell.getName(true, true) + "@");
                                    for (clearIndex = oneEnumInfo.getColBegin(); clearIndex <= oneEnumInfo.getColEnd(); ++clearIndex) {
                                        cell = sheet.getCell(rowIndex, clearIndex, false);
                                        if (BgNFSHelper.checkHasBgItemInfo((Cell)cell)) {
                                            BgNFSHelper.removeBgItemInfo((Cell)cell);
                                            BgNFSHelper.setValue((Cell)cell, null);
                                            removeCell.append("#" + cell.getName(true, true) + "#");
                                            continue;
                                        }
                                        if (!BgNFSHelper.checkHasItemFormula((Cell)cell)) continue;
                                        BgNFSHelper.removeItemFormula((Cell)cell);
                                        BgNFSHelper.setBudgetValue((Cell)cell, null);
                                        BgNFSHelper.setValue((Cell)cell, null);
                                        removeCell.append("(" + cell.getName(true, true) + ")");
                                        cell.setFormula(null);
                                    }
                                }
                            }
                        }
                    }
                }
                for (int m = 0; m < maxRow; ++m) {
                    row = sheet.getRow(m, false);
                    if (BgNFSHelper.getRowSign((Row)row) == null) continue;
                    for (int n = 0; n < maxCol; ++n) {
                        col = sheet.getColumn(n, false);
                        if (BgNFSHelper.getColSign((Column)col) == null || (cell = sheet.getCell(m, n, false)) == null || BgNFSHelper.isLockOfCell((Cell)cell) || !BgNFSHelper.checkCanEditFormulaOfCell((Cell)cell)) continue;
                        if (cell.getUserObjectValue(isCanSave) != null) {
                            cell.removeUserObject(isCanSave);
                            continue;
                        }
                        if (BgNFSHelper.checkHasBgItemInfo((Cell)cell)) {
                            BgNFSHelper.removeBgItemInfo((Cell)cell);
                            BgNFSHelper.setValue((Cell)cell, null);
                            removeCell.append("#" + cell.getName(true, true) + "#");
                            continue;
                        }
                        if (!BgNFSHelper.checkHasItemFormula((Cell)cell)) continue;
                        BgNFSHelper.removeItemFormula((Cell)cell);
                        BgNFSHelper.setBudgetValue((Cell)cell, null);
                        BgNFSHelper.setValue((Cell)cell, null);
                        removeCell.append("(" + cell.getName(true, true) + ")");
                        cell.setFormula(null);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"enmuerate:upBookWithEnumerate  2  ", (Throwable)e);
        }
        finally {
            logger.error((Object)(" REMOVE CELL ENUM  " + removeCell.toString()));
        }
    }

    @Override
    protected boolean _schemeInvoke(Context ctx, String schemeId, boolean onlyMe) throws BOSException, EASBizException {
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
        Date dateFrom = schemeInfo.getDateFrom();
        Date dateTo = schemeInfo.getDateTo();
        String orgid = schemeInfo.getOrgUnit().getId().toString();
        Object[] obj = new Object[]{CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(schemeInfo.getOrgUnit().getId())).getLongNumber() + "!%", schemeId, schemeInfo.getRootId().toString()};
        boolean canInvoke = this.isCanSchemeInvoke(ctx, schemeId, dateFrom, dateTo, orgid);
        if (!canInvoke) {
            return false;
        }
        schemeInfo.setIsFormal(true);
        iBgScheme.save((CoreBaseInfo)schemeInfo);
        if (onlyMe) {
            return true;
        }
        StringBuffer oql = new StringBuffer("select A.fid fid from t_Bg_bgscheme A,t_org_costcenter B").append("  where A.FOrgUnitID = B.Fid ").append(" and B.FLongnumber like ? ").append(" and A.FID <> ? ").append(" and A.FROOTID = ? ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])obj);
        try {
            while (row.next()) {
                String childSchemeId = row.getString("fid");
                this.schemeInvoke(ctx, childSchemeId, true);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return true;
    }

    private boolean isCanSchemeInvoke(Context ctx, String schemeId, Date dateFrom, Date dateTo, String orgid) throws BOSException, BgSchemeAssignException {
        StringBuffer sqlBuffer = new StringBuffer("select top 1 fid from t_bg_bgscheme \n").append("\twhere fid <> ? ").append("         and FIsFormal = 1").append("         and FOrgUnitID = ?").append("         and (  ( datediff(day,FDateFrom,TO_DATE('" + dateFrom + "') )>=0 and datediff(day,FDateTo,TO_DATE('" + dateFrom + "') )<=0 ) ").append("                or ( datediff(day,FDateFrom,TO_DATE('" + dateFrom + "') )<=0 and datediff(day,FDateTo,TO_DATE('" + dateTo + "') )>=0 ) ").append("                or ( datediff(day,FDateFrom,TO_DATE('" + dateTo + "') )>=0 and datediff(day,FDateTo,TO_DATE('" + dateTo + "') )<=0 ) ").append("             )");
        Object[] obj = new Object[]{schemeId, orgid};
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])obj);
        try {
            if (row.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return true;
    }

    @Override
    protected boolean _schemeInvInvoke(Context ctx, String schemeId, boolean onlyMe) throws BOSException, EASBizException {
        Object[] obj1;
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo("select id, rootId, orgUnit.id, orgUnit.isCostOrgUnit, orgUnit.isGrouping where id = '" + schemeId + "'");
        StringBuffer sqlBuffer = new StringBuffer("update t_bg_bgscheme set fisFormal  = 0 where fid = ? ");
        Object[] obj = new Object[]{schemeId};
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString(), (Object[])obj);
        if (onlyMe) {
            return true;
        }
        Connection conn = null;
        PreparedStatement temPst = null;
        IRowSet row = null;
        StringBuffer oql = null;
        if (schemeInfo.getOrgUnit().isIsCostOrgUnit()) {
            CostCenterOrgUnitInfo costcenter = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(schemeInfo.getOrgUnit().getId()));
            oql = new StringBuffer("select a.fid fid from t_Bg_bgscheme A,t_org_costcenter B").append(" where A.FOrgUnitID = B.Fid ").append(" and B.FLongnumber like ? ").append(" and A.FID <> ? ").append(" and A.FROOTID = ? ");
            obj1 = new Object[]{costcenter.getLongNumber() + "!%", schemeId, schemeInfo.getRootId().toString()};
            row = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])obj1);
        } else if (schemeInfo.getOrgUnit().isIsGrouping()) {
            OrgStructureInfo structureInfo = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo((IObjectPK)new ObjectUuidPK(schemeInfo.getOrgUnit().getId()));
            oql = new StringBuffer("select a.fid fid from t_Bg_bgscheme A, t_org_structure B").append(" where A.FOrgUnitID = B.FUnitId ").append(" and B.FLongnumber like ? ").append(" and A.FID <> ? ").append(" and A.FROOTID = ? ");
            obj1 = new Object[]{structureInfo.getLongNumber() + "!%", schemeId, schemeInfo.getRootId().toString()};
            row = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])obj1);
        }
        if (row != null) {
            block10: {
                String childSchemeId = null;
                try {
                    conn = this.getConnection(ctx);
                    temPst = conn.prepareStatement(sqlBuffer.toString());
                    boolean isHadChild = false;
                    while (row.next()) {
                        childSchemeId = row.getString("fid");
                        temPst.setString(1, childSchemeId);
                        temPst.addBatch();
                        isHadChild = true;
                    }
                    if (!isHadChild) break block10;
                    temPst.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)"", (Throwable)e);
                        throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(row, temPst, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup(row, (Statement)temPst, (Connection)conn);
        }
        return true;
    }

    @Override
    protected Map _getSchemeIdsChildOrgByIsInvoke(Context ctx, String schemeId, boolean isInvoke) throws BOSException, EASBizException {
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
        CostCenterOrgUnitInfo costcenter = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(schemeInfo.getOrgUnit().getId()));
        StringBuffer oql = new StringBuffer("select distinct a.fid fid,b.fid orgid,b.flongnumber longnumber,b.fname_" + ctx.getLocale() + " orgname from t_Bg_bgscheme A,t_org_costcenter B").append(" where A.FOrgUnitID = B.Fid ").append(" and B.FLongnumber like ? ").append(" and A.fid <> ? ").append(" and A.FROOTID = ? ");
        if (isInvoke) {
            oql.append(" and a.FIsFormal = 1");
        } else {
            oql.append(" and a.FIsFormal = 0");
        }
        Object[] obj = new Object[]{costcenter.getLongNumber() + "!%", schemeId, schemeInfo.getRootId().toString()};
        HashMap<String, CostCenterOrgUnitInfo> map = new HashMap<String, CostCenterOrgUnitInfo>();
        if (isInvoke) {
            map.put(schemeId, costcenter);
        }
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])obj);
        try {
            String childSchemeId = null;
            String childOrgId = null;
            String childOrgName = null;
            String longnumber = null;
            CostCenterOrgUnitInfo org = null;
            while (row.next()) {
                org = new CostCenterOrgUnitInfo();
                childSchemeId = row.getString("fid");
                childOrgId = row.getString("orgid");
                childOrgName = row.getString("orgname");
                longnumber = row.getString("longnumber");
                org.setId(BOSUuid.read((String)childOrgId));
                org.setName(childOrgName);
                org.setLongNumber(longnumber);
                map.put(childSchemeId, org);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return map;
    }

    private void updateBookUserObject(Book book, Book sourceBook) {
        Object _obj;
        if (sourceBook.getUserObjectValue("VARIABLES") != null) {
            book.setUserObject("VARIABLES", sourceBook.getUserObjectValue("VARIABLES"));
        }
        if (sourceBook.getUserObjectValue("ZEROREPLACER") != null) {
            book.setUserObject("ZEROREPLACER", sourceBook.getUserObjectValue("ZEROREPLACER"));
        }
        if (sourceBook.getUserObjectValue("ERRORHANDLER") != null) {
            book.setUserObject("ERRORHANDLER", sourceBook.getUserObjectValue("ERRORHANDLER"));
        }
        if (sourceBook.getUserObjectValue("sheetParameters") != null) {
            book.setUserObject("sheetParameters", sourceBook.getUserObjectValue("sheetParameters"));
        }
        if (sourceBook.getUserObjectValue("multiCalculateQueue") != null) {
            book.setUserObject("multiCalculateQueue", sourceBook.getUserObjectValue("multiCalculateQueue"));
        }
        if (sourceBook.getUserObjectValue("operationSchemas") != null) {
            book.setUserObject("operationSchemas", sourceBook.getUserObjectValue("operationSchemas"));
        }
        if (sourceBook.getUserObjectValue("VARIABLES") != null) {
            book.setUserObject("VARIABLES", sourceBook.getUserObjectValue("VARIABLES"));
        }
        if (sourceBook.getUserObjectValue("PARAMINFO") != null) {
            book.setUserObject("PARAMINFO", sourceBook.getUserObjectValue("PARAMINFO"));
        }
        if ((_obj = sourceBook.getUserObjectValue("VARIABLES")) != null) {
            book.setUserObject("VARIABLES", _obj);
        }
        if ((_obj = sourceBook.getUserObjectValue("AUTO_CALCULATOR")) != null) {
            book.setUserObject("AUTO_CALCULATOR", _obj);
        }
    }

    @Override
    protected void _updateBgActualAdd_from_BgForm(Context ctx, IObjectValue org, IObjectValue tem, IObjectValue scheme) throws BOSException, EASBizException {
        if (org == null || scheme == null || tem == null) {
            return;
        }
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)org;
        BgTemplateInfo bgTemplateInfoOld = (BgTemplateInfo)tem;
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)scheme;
        String orgid = orgUnitInfo.getId().toString();
        String temID = bgTemplateInfoOld.getId().toString();
        String schemeid = bgSchemeInfo.getId().toString();
        String sql = "select fid id,FBgTemplateID temID form t_bg_bgform where FBgTemplateID = ? and FBgSchemeID = ? and FOrgUnitID=? and FState=2";
        Object[] param = new String[]{temID, orgid, schemeid};
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            while (row.next()) {
            }
        }
        catch (SQLException sqle) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, sqle);
        }
    }

    @Override
    protected Map _getUpdateBgTem_formVectorMap_For_OnlyUpdataActAdd(Context ctx, Map temmap, String schemeID) throws BOSException, EASBizException {
        String orgId = null;
        StringBuffer sqlTemPlate = new StringBuffer("select fid,frootid from t_bg_bgtemplate ");
        HashMap<String, String> mapRootToId = new HashMap<String, String>();
        HashMap<String, String> mapIdToRoot = new HashMap<String, String>();
        ArrayList<String> listTem = new ArrayList<String>();
        String temid = null;
        String rootId = null;
        for (Object key : temmap.keySet()) {
            if (key == null || key.toString().trim().length() < 1) continue;
            orgId = (String)key;
            Vector vec = (Vector)temmap.get(key);
            for (int k = 0; k < vec.size(); ++k) {
                temid = (String)vec.get(k);
                if (listTem.contains(temid)) continue;
                if (listTem.isEmpty()) {
                    sqlTemPlate.append(" where fid = ? ");
                } else {
                    sqlTemPlate.append(" or fid = ? ");
                }
                listTem.add(temid);
            }
        }
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sqlTemPlate.toString(), (Object[])listTem.toArray());
        try {
            while (row.next()) {
                temid = row.getString("fid");
                rootId = row.getString("frootid");
                mapRootToId.put(rootId, temid);
                mapIdToRoot.put(temid, rootId);
            }
        }
        catch (SQLException sqle) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, sqle);
        }
        String sqlTem = "select bgform.fid id,bgform.FBgTemplateID temID,bgtemplate.frootid temRootId,bgform.fname formname,bgform.fnumber formnumber,bgform.FOrgUnitID orgunitid,bgtemplate.fname temName,costcenter.fname_" + ctx.getLocale() + " orgname";
        sqlTem = sqlTem + "\n\r from t_bg_bgform bgform inner join t_bg_bgtemplate bgtemplate ";
        sqlTem = sqlTem + "\n\r\t on bgform.FBgTemplateID = bgtemplate.fid inner join t_org_costcenter costcenter ";
        sqlTem = sqlTem + "\n\r\t on bgform.FOrgUnitID = costcenter.fid ";
        sqlTem = sqlTem + "\n\r\t where bgform.fbgschemeid in (select distinct fid from t_Bg_Bgscheme scheme where ";
        sqlTem = sqlTem + "\n\r\t \t scheme.frootid in (select distinct t_Bg_bgscheme.frootid from t_Bg_bgscheme where ";
        sqlTem = sqlTem + "\n\r\t \t t_Bg_bgscheme.FID =? )) ";
        StringBuffer sql2 = null;
        int MAX = 250;
        int i = 0;
        HashMap<BgTemplateInfo, Vector> returnMap = new HashMap<BgTemplateInfo, Vector>();
        HashMap<StringBuffer, List<String>> mapSql = new HashMap<StringBuffer, List<String>>();
        List<String> listParam = new ArrayList();
        for (Object key : temmap.keySet()) {
            if (key == null || key.toString().trim().length() < 1) continue;
            orgId = (String)key;
            Vector vec = (Vector)temmap.get(key);
            for (int k = 0; k < vec.size(); ++k) {
                temid = (String)vec.get(k);
                if (StringUtils.isEmpty((String)((String)mapIdToRoot.get(temid)))) continue;
                rootId = (String)mapIdToRoot.get(temid);
                if (i == 0) {
                    sql2 = new StringBuffer(sqlTem);
                    listParam = new ArrayList();
                    listParam.add(schemeID);
                    listParam.add(temid);
                    listParam.add(orgId);
                    sql2.append("\n\r\t and ( ( bgtemplate.FRootID  =? and bgform.FOrgUnitID=? and bgform.FState=2) ");
                } else if (sql2 != null) {
                    if (i == MAX) {
                        i = 0;
                        mapSql.put(sql2.append(" ) "), listParam);
                        sql2 = new StringBuffer(sqlTem);
                        listParam = new ArrayList();
                        listParam.add(schemeID);
                        listParam.add(temid);
                        listParam.add(orgId);
                        sql2.append("\n\r\t and ( ( bgtemplate.FRootID  =?  and bgform.FOrgUnitID=? and bgform.FState=2) ");
                    } else {
                        listParam.add(temid);
                        listParam.add(orgId);
                        sql2.append("\n\r\t or ( bgtemplate.FRootID  =?  and bgform.FOrgUnitID=? and bgform.FState=2) ");
                    }
                }
                ++i;
            }
        }
        if (i > 0 && sql2 != null && sql2.length() > 0) {
            mapSql.put(sql2.append(" ) "), listParam);
        }
        String formid = null;
        String orgid = null;
        String formnumber = null;
        String formname = null;
        String temname = null;
        String orgname = null;
        BgTemplateInfo bgtem = null;
        BgFormInfo bgform = null;
        FullOrgUnitInfo fullOrg = null;
        for (StringBuffer sql2 : mapSql.keySet()) {
            listParam = (List)mapSql.get(sql2);
            row = DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])listParam.toArray());
            Vector vec = null;
            try {
                while (row.next()) {
                    formid = row.getString("id");
                    temid = row.getString("temID");
                    rootId = row.getString("temRootID");
                    if (StringUtils.isEmpty((String)((String)mapRootToId.get(rootId)))) continue;
                    temid = (String)mapRootToId.get(rootId);
                    formname = row.getString("formname");
                    formnumber = row.getString("formnumber");
                    orgid = row.getString("orgunitid");
                    vec = (Vector)temmap.get(orgid);
                    temname = row.getString("temName");
                    orgname = row.getString("orgname");
                    bgtem = new BgTemplateInfo();
                    bgtem.setId(BOSUuid.read((String)temid));
                    bgtem.setName(temname);
                    bgform = new BgFormInfo();
                    bgform.setId(BOSUuid.read((String)formid));
                    bgform.setName(formname);
                    bgform.setNumber(formnumber);
                    fullOrg = new FullOrgUnitInfo();
                    fullOrg.setName(orgname);
                    fullOrg.setId(BOSUuid.read((String)orgid));
                    bgform.setOrgUnit(fullOrg);
                    if (returnMap.containsKey(bgtem)) {
                        vec = (Vector)returnMap.get(bgtem);
                        vec.add(bgform);
                        continue;
                    }
                    vec = new Vector();
                    vec.add(bgform);
                    returnMap.put(bgtem, vec);
                }
            }
            catch (SQLException sqle) {
                throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, sqle);
            }
        }
        return returnMap;
    }

    @Override
    protected Map _updateBgFormOnlyActualADD(Context ctx, IObjectValue tem, IObjectValue form) throws BOSException, EASBizException {
        IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance(ctx);
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        SelectorItemCollection secCol = new SelectorItemCollection();
        secCol.add(new SelectorItemInfo("id"));
        secCol.add(new SelectorItemInfo("number"));
        secCol.add(new SelectorItemInfo("name"));
        secCol.add(new SelectorItemInfo("data"));
        BgTemplateInfo bgTemplateInfo = iBgTemplate.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(((BgTemplateInfo)tem).getId()), secCol);
        secCol.add(new SelectorItemInfo("orgunit.id"));
        secCol.add(new SelectorItemInfo("orgunit.name"));
        secCol.add(new SelectorItemInfo("orgunit.number"));
        secCol.add(new SelectorItemInfo("bgScheme.id"));
        secCol.add(new SelectorItemInfo("bgScheme.name"));
        secCol.add(new SelectorItemInfo("bgScheme.number"));
        secCol.add(new SelectorItemInfo("bgPeriod.id"));
        secCol.add(new SelectorItemInfo("bgPeriod.name"));
        secCol.add(new SelectorItemInfo("bgPeriod.number"));
        secCol.add(new SelectorItemInfo("currency.id"));
        secCol.add(new SelectorItemInfo("currency.name"));
        secCol.add(new SelectorItemInfo("currency.number"));
        BgFormInfo bgforminfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(((BgFormInfo)form).getId()), secCol);
        Book bookTem = null;
        Book bookForm = null;
        try {
            bookTem = bgTemplateInfo.getData() == null ? null : bgTemplateInfo.getBook();
            if (bgforminfo.getData() != null) {
                bookForm = bgforminfo.getBook();
            } else if (bookTem != null) {
                bookForm = Book.Manager.getNewBook((String)bookTem.getName(), (int)bookTem.getSheetCount());
            }
        }
        catch (Exception ex) {
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, ex);
        }
        String companyNumber = BgNExpressionHelper.getCompanyNumber((Context)ctx, (IObjectValue)bgforminfo);
        Map[] itemExpMap = new HashMap[]{new HashMap()};
        bookForm = BgNAssignUpdateUtil.updateBookActualAddFormulaByFormat((Book)bookTem, (Book)bookForm, (boolean)false, (IObjectValue)bgforminfo, (Map[])itemExpMap, (String)companyNumber);
        try {
            bgforminfo.setBook(bookForm);
        }
        catch (Exception ex) {
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, ex);
        }
        iBgForm.updateValue((IObjectValue)bgforminfo);
        List listAcutalRecordIds = this.getActualRecordIdByBgFormID(ctx, bgforminfo.getId().toString());
        secCol = new SelectorItemCollection();
        secCol.add(new SelectorItemInfo("id"));
        secCol.add(new SelectorItemInfo("number"));
        secCol.add(new SelectorItemInfo("name"));
        secCol.add(new SelectorItemInfo("data"));
        secCol.add(new SelectorItemInfo("bgForm.orgunit.id"));
        secCol.add(new SelectorItemInfo("bgForm.orgunit.name"));
        secCol.add(new SelectorItemInfo("bgForm.orgunit.number"));
        secCol.add(new SelectorItemInfo("bgForm.bgScheme.id"));
        secCol.add(new SelectorItemInfo("bgForm.bgScheme.name"));
        secCol.add(new SelectorItemInfo("bgForm.bgScheme.number"));
        secCol.add(new SelectorItemInfo("bgPeriod.id"));
        secCol.add(new SelectorItemInfo("bgPeriod.name"));
        secCol.add(new SelectorItemInfo("bgPeriod.number"));
        secCol.add(new SelectorItemInfo("bgForm.currency.id"));
        secCol.add(new SelectorItemInfo("bgForm.currency.name"));
        secCol.add(new SelectorItemInfo("bgForm.currency.number"));
        if (listAcutalRecordIds != null && !listAcutalRecordIds.isEmpty()) {
            BgActualRecordInfo recordinfo = null;
            IBgActualRecord iBgAct = BgActualRecordFactory.getLocalInstance(ctx);
            int size = listAcutalRecordIds.size();
            for (int i = 0; i < size; ++i) {
                recordinfo = (BgActualRecordInfo)iBgAct.getValue((IObjectPK)new ObjectUuidPK((String)listAcutalRecordIds.get(i)), secCol);
                Book bookRecord = null;
                try {
                    bookRecord = recordinfo.getData() == null ? Book.Manager.getNewBook((String)bookForm.getName(), (int)bookForm.getSheetCount()) : recordinfo.getBook();
                }
                catch (Exception ex) {
                    throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR);
                }
                itemExpMap = new HashMap[]{new HashMap()};
                bookRecord = BgNAssignUpdateUtil.updateBookActualAddFormulaByFormat((Book)bookTem, (Book)bookRecord, (boolean)true, (IObjectValue)recordinfo, (Map[])itemExpMap, (String)companyNumber);
                try {
                    recordinfo.setBook(bookRecord);
                    BgNAssignUpdateUtil.insertMapData((Context)ctx, (String)recordinfo.getId().toString(), (byte[])recordinfo.getData(), (String)"t_bg_Bgactualrecord");
                    continue;
                }
                catch (Exception ex) {
                    throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, ex);
                }
            }
        }
        String RESORRCE_TEM = "com.kingdee.eas.ma.budget.TemplateSchemeUpdateResource";
        HashMap<SchemeAssignMsgObj, String> map = new HashMap<SchemeAssignMsgObj, String>();
        Locale local = ctx.getLocale();
        SchemeAssignMsgObj key = new SchemeAssignMsgObj("ORG_ASSIG", ResourceBase.getString((String)RESORRCE_TEM, (String)"assign.org", (Locale)local), 0);
        map.put(key, bgforminfo.getOrgUnit().getName());
        key = new SchemeAssignMsgObj("BG_Scheme", ResourceBase.getString((String)RESORRCE_TEM, (String)"bgscheme", (Locale)local), -1);
        map.put(key, bgforminfo.getBgScheme().getName());
        key = new SchemeAssignMsgObj("BG_BGFORM", ResourceBase.getString((String)RESORRCE_TEM, (String)"actualRecordForm", (Locale)local), 2);
        map.put(key, ResourceBase.getString((String)RESORRCE_TEM, (String)"bgform", (Locale)local) + "\"" + bgforminfo.getName() + "\"" + ResourceBase.getString((String)RESORRCE_TEM, (String)"of.actualRecordFormByForm", (Locale)local));
        key = new SchemeAssignMsgObj("BG_TEMPLATE", ResourceBase.getString((String)RESORRCE_TEM, (String)"bgtemplate", (Locale)local), 1);
        map.put(key, bgTemplateInfo.getName());
        key = new SchemeAssignMsgObj("BG_TEMPLATE_RESULT", ResourceBase.getString((String)RESORRCE_TEM, (String)"bgtemplate.assign.result", (Locale)local), 3);
        map.put(key, ResourceBase.getString((String)RESORRCE_TEM, (String)"success", (Locale)local));
        return map;
    }

    private List getActualRecordIdByBgFormID(Context ctx, String bgformid) throws BOSException, EASBizException {
        String sql = "select fid from t_bg_Bgactualrecord where fbgformid = ? and FState=?";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bgformid, Integer.valueOf("1")});
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (row.next()) {
                list.add(row.getString("fid"));
            }
        }
        catch (SQLException sqle) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR);
        }
        return list;
    }

    @Override
    protected Map _newInvokeMethod(Context ctx, IObjectValue org, IObjectValue tem, IObjectValue scheme, boolean isUpdateBgTemplate, boolean isUpdateBgForm, boolean isCoverChild, Map allTemplateIdSet, Map upProperty) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _upOnlyEnumArea(Context ctx, Map params) throws BOSException, EASBizException {
        FullOrgUnitInfo org = (FullOrgUnitInfo)params.get("ORG");
        BgSchemeInfo scheme = (BgSchemeInfo)params.get("BGSCHEME");
        BgTemplateInfo tem = (BgTemplateInfo)params.get("BGTEMPLATE");
        if (org == null || tem == null || scheme == null) {
            return null;
        }
        IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance(ctx);
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId()));
        BgTemplateInfo bgTemplateInfoOld = iBgTemplate.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(tem.getId()));
        BgSchemeInfo bgSchemeInfo = scheme;
        String orgId = orgUnitInfo.getId().toString();
        if (!bgTemplateInfoOld.getFormType().equals((Object)BgTemFormTypeEnum.ENUMERATEFORM)) {
            return null;
        }
        if (!this.isHasAssignSchemeToThisOrg(ctx, bgSchemeInfo.getId().toString(), bgSchemeInfo.getRootId().toString(), orgId)) {
            return null;
        }
        BgSchemeInfo bgSchemeInfoNew = null;
        BOSUuid schemeRootId = bgSchemeInfo.getRootId();
        bgSchemeInfoNew = iBgScheme.getBgSchemeInfo("select fid where orgUnit.id='" + orgId + "' and rootId = '" + schemeRootId + "'");
        bgSchemeInfoNew = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeInfoNew.getId()), this.getSelectors());
        bgSchemeInfoNew.setName(bgSchemeInfo.getName());
        bgSchemeInfoNew.setNumber(bgSchemeInfo.getNumber());
        bgSchemeInfoNew.setDateFrom(bgSchemeInfo.getDateFrom());
        bgSchemeInfoNew.setDateTo(bgSchemeInfo.getDateTo());
        bgSchemeInfoNew.setPeriod(bgSchemeInfo.getPeriod());
        bgSchemeInfoNew.setIsSubmitByScheme(bgSchemeInfo.isIsSubmitByScheme());
        bgSchemeInfoNew.setIsFormal(false);
        BOSUuid temrootId = bgTemplateInfoOld.getRootId();
        String rootIdString = temrootId == null ? "" : temrootId.toString();
        BgTemplateInfo bgTemplateInfoNew = null;
        BgTemplateInfo _bgTemplateInfoNew = this.getBgTemplateInfo(ctx, orgId, rootIdString);
        if (_bgTemplateInfoNew == null) {
            return null;
        }
        SelectorItemCollection sic = this.getTemplageSelectors();
        BgTemModifyEnum canModify = bgTemplateInfoOld.getCanModify();
        BgTemModifyEnum isAllowChange = bgTemplateInfoOld.getIsAllowChange();
        _bgTemplateInfoNew = iBgTemplate.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(_bgTemplateInfoNew.getId()), sic);
        _bgTemplateInfoNew.setName(bgTemplateInfoOld.getName());
        _bgTemplateInfoNew.setNumber(bgTemplateInfoOld.getNumber());
        _bgTemplateInfoNew.setIsAllowChange(isAllowChange);
        _bgTemplateInfoNew.setCanModify(canModify);
        _bgTemplateInfoNew.setRootId(bgTemplateInfoOld.getRootId());
        _bgTemplateInfoNew.setDefaultMeasureUnit(bgTemplateInfoOld.getDefaultMeasureUnit());
        _bgTemplateInfoNew.setBgType(bgTemplateInfoOld.getBgType());
        _bgTemplateInfoNew.setDescription(bgTemplateInfoOld.getDescription());
        _bgTemplateInfoNew.setTemplateStatus(bgTemplateInfoOld.getTemplateStatus());
        bgTemplateInfoNew = _bgTemplateInfoNew;
        this.updateBgTemplateInfoOfSchemeToThisOrgToEnumArea(ctx, bgTemplateInfoOld, bgTemplateInfoNew, bgSchemeInfoNew.getId().toString());
        iBgTemplate.submit((CoreBaseInfo)bgTemplateInfoNew);
        String RESORRCE_TEM = "com.kingdee.eas.ma.budget.TemplateSchemeUpdateResource";
        HashMap<SchemeAssignMsgObj, String> map = new HashMap<SchemeAssignMsgObj, String>();
        Locale local = ctx.getLocale();
        SchemeAssignMsgObj key = new SchemeAssignMsgObj("ORG_ASSIG", ResourceBase.getString((String)RESORRCE_TEM, (String)"assign.org", (Locale)local), 0);
        map.put(key, org.getName());
        key = new SchemeAssignMsgObj("BG_Scheme", ResourceBase.getString((String)RESORRCE_TEM, (String)"bgscheme", (Locale)local), -1);
        map.put(key, bgSchemeInfoNew.getName());
        key = new SchemeAssignMsgObj("ASSING_ISFMALE_STATUS", ResourceBase.getString((String)RESORRCE_TEM, (String)"bgscheme.invoke.result", (Locale)local), 1);
        map.put(key, ResourceBase.getString((String)RESORRCE_TEM, (String)"success", (Locale)local));
        key = new SchemeAssignMsgObj("BG_TEMPLATE", ResourceBase.getString((String)RESORRCE_TEM, (String)"bgtemplate", (Locale)local), 2);
        map.put(key, bgTemplateInfoNew.getName());
        key = new SchemeAssignMsgObj("BG_TEMPLATE_RESULT", ResourceBase.getString((String)RESORRCE_TEM, (String)"bgtemplate.assign.result", (Locale)local), 3);
        map.put(key, ResourceBase.getString((String)RESORRCE_TEM, (String)"success", (Locale)local));
        return map;
    }

    private boolean updateBgTemplateInfoOfSchemeToThisOrgToEnumArea(Context ctx, BgTemplateInfo superTemplateInfo, BgTemplateInfo chileTemplateInfo, String bgSchemeId) throws EASBizException {
        if (superTemplateInfo == null || chileTemplateInfo == null) {
            throw new BgTemplateException(BgTemplateException.ISCANTIDNULL);
        }
        Book bookSource = null;
        Book toBookInit = null;
        int index = 0;
        int count = 0;
        Sheet superior = null;
        Sheet update = null;
        Sheet updateAcutal = null;
        Sheet updateActualAdd = null;
        Map aliasMap = new HashMap();
        Object tempMap = null;
        Object childBgTemplateIdMap = null;
        Connection conn = null;
        HashMap formulaMap = new HashMap();
        Map mapProTectSourse = new HashMap();
        Map mapProTectTo = new HashMap();
        try {
            if (superTemplateInfo.getId().equals((Object)chileTemplateInfo.getId())) {
                this.updateBgFormInfoEnumArea(ctx, chileTemplateInfo, bgSchemeId);
            } else if (superTemplateInfo != null && superTemplateInfo.getZipData() != null) {
                bookSource = BgCatchUtil.getBgKDFCatch(superTemplateInfo);
                BgNFSHelper.disableUndo((Book)bookSource);
                BgNFSHelper.disableCal((Book)bookSource);
                mapProTectSourse = BgNLockProtectHelper.clearChildTemplateBookProAndSheetPro((Book)bookSource);
                toBookInit = chileTemplateInfo.getBook();
                BgNFSHelper.disableUndo((Book)toBookInit);
                BgNFSHelper.disableCal((Book)toBookInit);
                if (bookSource.getSheetCount() > 0) {
                    count = bookSource.getSheetCount();
                    for (index = 0; index < count; ++index) {
                        superior = bookSource.getSheet(index);
                        if (superior == null) continue;
                        aliasMap = BgNAssignUpdateUtil.getSuperiorTableInfo((Sheet)superior, (String)superior.getID(), aliasMap);
                        update = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId((String)BgNFSHelper.getSheetSign((Sheet)superior), (Book)toBookInit);
                        if (update == null) continue;
                        update.setEnableCalculation(false);
                        this.updateTableInfoToRowAndCol(ctx, superior, update, updateAcutal, updateActualAdd, aliasMap, false);
                        update.clearStyleCache();
                    }
                    mapProTectTo = BgNLockProtectHelper.clearChildTemplateBookProAndSheetPro((Book)toBookInit);
                    this.upEnumeraterArea(ctx, bookSource, toBookInit);
                    chileTemplateInfo.setBook(toBookInit);
                    this.updateBgFormInfoEnumArea(ctx, chileTemplateInfo, bgSchemeId);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Budget:", (Throwable)ex);
            throw new BgException(BgException.OTHERERROR, ex, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(conn);
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateBgFormInfoEnumArea(Context ctx, BgTemplateInfo model, String bgSchemeId) throws EASBizException, BOSException {
        if (model == null) {
            throw new BgTemplateException(BgTemplateException.ISCANTMODELNULL);
        }
        BgTemplateInfo bgTemplateInfo = model;
        if (bgTemplateInfo.getId() == null) {
            throw new BgTemplateException(BgTemplateException.ISCANTIDNULL);
        }
        if (bgTemplateInfo.getZipData() == null) {
            throw new BgTemplateException(BgTemplateException.ISCANTMODELNULL);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
            if (ibgForm == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID,FBgSchemeID from T_BG_BgForm where FBgTemplateId = ? and fstate != 15");
            pstmt.setString(1, bgTemplateInfo.getId().toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String schemeid = rst.getString(2);
                if (!bgSchemeId.equals(schemeid)) continue;
                String formid = rst.getString(1);
                this.updateBgFormFromNewTempateToEnumArea(ctx, bgTemplateInfo, formid, true);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw ex;
                catch (EASBizException ex2) {
                    logger.error((Object)"", (Throwable)ex2);
                    throw ex2;
                }
                catch (SQLException ex3) {
                    logger.error((Object)"", (Throwable)ex3);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
                catch (Exception ex4) {
                    logger.error((Object)"", (Throwable)ex4);
                    throw new BgException(BgException.OTHERERROR, new String[]{ex4.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return true;
    }

    private void updateTableInfoToRowAndCol(Context ctx, Sheet source, Sheet update, Sheet updateAcutal, Sheet updateActualAdd, Map aliasMap, boolean isUpdateForm) {
        if (source == null || update == null || aliasMap == null || !aliasMap.containsKey(source.getID())) {
            return;
        }
        update.setHide(source.isHide());
        Map tableMap = null;
        Map rowAlias = null;
        Map colAlias = null;
        Map upRowAlias = null;
        Map upColAlias = null;
        tableMap = (Map)aliasMap.get(source.getID());
        if (tableMap.containsKey("SIGN_ROW_ID")) {
            rowAlias = (Map)tableMap.get("SIGN_ROW_ID");
        }
        if (tableMap.containsKey("SIGN_COL_ID")) {
            colAlias = (Map)tableMap.get("SIGN_COL_ID");
        }
        upRowAlias = this.addRows(source, update, updateAcutal, updateActualAdd, isUpdateForm, true);
        upColAlias = this.addCols(source, update, updateAcutal, updateActualAdd, isUpdateForm, true);
        Row row = null;
        Column column = null;
        String rowId = null;
        String colId = null;
        int rowCount = source.getMaxRowIndex() + 1;
        int colCount = source.getMaxColIndex() + 1;
        int upRowIndex = -1;
        int upColIndex = -1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = source.getRow(rowIndex, false);
            if (row == null || BgNFSHelper.getRowSign((Row)row) == null) continue;
            rowId = BgNFSHelper.getRowSign((Row)row);
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                column = source.getColumn(colIndex, false);
                if (column == null || BgNFSHelper.getColSign((Column)column) == null) continue;
                colId = BgNFSHelper.getColSign((Column)column);
                if (!upRowAlias.containsKey(rowId) || !upColAlias.containsKey(colId)) continue;
                upRowIndex = (Integer)upRowAlias.get(rowId);
                upColIndex = (Integer)upColAlias.get(colId);
                Cell cell = null;
                Cell upCell = null;
                cell = source.getMergeBlock(rowIndex, colIndex) != null ? source.getCell(rowIndex, colIndex, false) : source.getCell(rowIndex, colIndex, false);
                BgNFSHelper.setColSign((Column)update.getColumn(upColIndex, true), (String)colId);
                BgNFSHelper.setRowSign((Row)update.getRow(upRowIndex, true), (String)rowId);
                upCell = update.getCell(upRowIndex, upColIndex, true);
                if (cell == null) {
                    upCell.removeUserObject("BeginCell");
                    upCell.removeUserObject("EndCell");
                    upCell.removeUserObject("CollBeginCell");
                    upCell.removeUserObject("CollEndCell");
                    upCell.removeUserObject("ItemBeginCell");
                    upCell.removeUserObject("ItemEndCell");
                    continue;
                }
                BgNAssignUpdateUtil.updateUserObject((Cell)cell, (Cell)upCell);
            }
        }
    }

    protected void updateBgFormFromNewTempateToEnumArea(Context ctx, BgTemplateInfo bgTempateInfo, String formID, boolean isFromTemplateAssign) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        if (bgTempateInfo == null) {
            throw new BOSException("templateIsNull");
        }
        Book bookToInit = null;
        Book bookSource = null;
        Sheet template = null;
        Sheet sheet = null;
        Sheet updateAcutal = null;
        Sheet updateActualAdd = null;
        Map aliasMap = null;
        HashMap formulasMap = new HashMap();
        Map mapProTectSourse = new HashMap();
        Map mapProTectTo = new HashMap();
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            bookSource = bgTempateInfo.getBook();
            mapProTectSourse = BgNLockProtectHelper.clearChildTemplateBookProAndSheetPro((Book)bookSource);
            BgNFSHelper.disableUndo((Book)bookSource);
            BgNFSHelper.disableCal((Book)bookSource);
            BgFormInfo bgFormInfo = null;
            IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
            if (ibgForm == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgFormInfo = ibgForm.getValue(BOSUuid.read((String)formID), true);
            if (bgFormInfo != null && bgFormInfo.getZipData() != null) {
                bookToInit = bgFormInfo.getBook();
                mapProTectTo = BgNLockProtectHelper.clearChildTemplateBookProAndSheetPro((Book)bookToInit);
                BgNFSHelper.disableUndo((Book)bookToInit);
                BgNFSHelper.disableCal((Book)bookToInit);
                int count = bookSource.getSheetCount();
                for (int index = 0; index < count; ++index) {
                    template = bookSource.getSheet(index);
                    if (template == null) continue;
                    aliasMap = BgNAssignUpdateUtil.getSuperiorTableInfo((Sheet)template, (String)template.getID(), aliasMap);
                    sheet = BgNAssignUpdateUtil.getUpdateTableOfBgTemplateBySignId((String)BgNFSHelper.getSheetSign((Sheet)template), (Book)bookToInit);
                    if (sheet == null) continue;
                    this.updateTableInfoToRowAndCol(ctx, template, sheet, updateAcutal, updateActualAdd, aliasMap, true);
                    sheet.clearStyleCache();
                }
                this.upEnumeraterArea(ctx, bookSource, bookToInit);
                bgFormInfo.setBook(bookToInit);
                byte[] bytes = bgFormInfo.getData();
                if (bytes != null) {
                    conn = this.getConnection(ctx);
                    pst = conn.prepareStatement("update T_BG_BgForm set FData=? where FID=?");
                    pst.setBinaryStream(1, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                    pst.setString(2, bgFormInfo.getId().toString());
                    pst.executeUpdate();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BgException(BgException.OTHERERROR, ex, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(pst, conn);
        }
    }

    @Override
    protected String _getSchemeId(Context ctx, String OrgUnitId, String SchemeNumber) throws BOSException, BgException {
        String SchemeId = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        conn = this.getConnection(ctx);
        try {
            pstmt = conn.prepareStatement("select fid from t_bg_bgscheme where ForgunitId=? and Fnumber=?");
            pstmt.setString(1, OrgUnitId);
            pstmt.setString(2, SchemeNumber);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                SchemeId = rst.getString(1);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        return SchemeId;
    }

    @Override
    protected Map _getVerifyCtrlMsg(Context ctx, Map params) throws BOSException, EASBizException {
        if (params == null || params.get("ORGID") == null || params.get("BGSCHEMEID") == null) {
            return null;
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String orgId = (String)params.get("ORGID");
        String bgSchemeId = (String)params.get("BGSCHEMEID");
        String bgSchemeNum = (String)params.get("BGSCHEMENUM");
        String bgSchemeName = (String)params.get("BGSCHEMENAME");
        Boolean isFormal = (Boolean)params.get("ISFORMAL");
        if (isFormal.booleanValue()) {
            returnMap.put("FORMAL", bgSchemeNum + " , " + bgSchemeName + " " + ResourceBase.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"ctrl5", (Locale)ContextUtils.getLocaleFromEnv()));
        } else {
            returnMap.put("FORMAL", bgSchemeNum + " , " + bgSchemeName + " " + ResourceBase.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"ctrl6", (Locale)ContextUtils.getLocaleFromEnv()));
        }
        Map ctrlMap = new HashMap();
        ctrlMap = this.getCtrlMap(ctx, orgId);
        returnMap.put("CTRL", ctrlMap);
        String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(orgId), (String)"GL_029");
        if (paramValue == null || paramValue.trim().equals("")) {
            returnMap.put("ISCTRL", ParamManager.getParamByNumber((Context)ctx, (String)"GL_029").getLogInfo() + " " + ResourceBase.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"ctrl26", (Locale)ContextUtils.getLocaleFromEnv()));
        } else if (Boolean.valueOf(paramValue).booleanValue()) {
            returnMap.put("ISCTRL", ParamManager.getParamByNumber((Context)ctx, (String)"GL_029").getLogInfo() + " " + ResourceBase.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"ctrl5", (Locale)ContextUtils.getLocaleFromEnv()));
        } else {
            returnMap.put("ISCTRL", ParamManager.getParamByNumber((Context)ctx, (String)"GL_029").getLogInfo() + " " + ResourceBase.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"ctrl26", (Locale)ContextUtils.getLocaleFromEnv()));
        }
        Map formMap = new HashMap();
        formMap = this.getFormMap(ctx, orgId, bgSchemeId);
        returnMap.put("FORM", formMap);
        Map itemMap = new HashMap();
        if (formMap == null) {
            returnMap.put("ITEM", null);
        } else {
            itemMap = this.getItemMap(ctx, orgId, bgSchemeId, formMap);
            returnMap.put("ITEM", itemMap);
        }
        return returnMap;
    }

    private Map getItemMap(Context ctx, String orgId, String bgSchemeId, Map formMap) throws BOSException {
        HashMap<String, Cloneable> itemMap = new HashMap<String, Cloneable>();
        Map valueMap = null;
        String formId2 = null;
        Hashtable ctrlModeMap = null;
        Vector itemAndElement = null;
        Hashtable ctrlModeMap1 = null;
        Vector itemAndElement1 = null;
        IBgCtrSettingFacade iBgCtrl = BgCtrSettingFacadeFactory.getLocalInstance(ctx);
        try {
            for (String formId2 : formMap.keySet()) {
                valueMap = iBgCtrl.getBgFormCtrlSetting(BOSUuid.read((String)formId2), null, false);
                if (valueMap == null || valueMap.isEmpty()) continue;
                ctrlModeMap1 = (Hashtable)valueMap.get("ctrlModeMap");
                itemAndElement1 = (Vector)valueMap.get("itemAndElement");
                ctrlModeMap = (Hashtable)itemMap.get("ctrlModeMap");
                itemAndElement = (Vector)itemMap.get("itemAndElement");
                if (ctrlModeMap == null) {
                    itemMap.put("ctrlModeMap", ctrlModeMap1);
                } else {
                    ctrlModeMap.putAll(ctrlModeMap1);
                    itemMap.put("ctrlModeMap", ctrlModeMap);
                }
                if (itemAndElement == null) {
                    itemMap.put("itemAndElement", itemAndElement1);
                    continue;
                }
                itemAndElement.addAll(itemAndElement1);
                itemMap.put("itemAndElement", itemAndElement);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        if (itemMap.isEmpty()) {
            return null;
        }
        return itemMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getFormMap(Context ctx, String orgId, String bgSchemeId) throws BOSException, EASBizException {
        StringBuffer schemeKSql = new StringBuffer();
        schemeKSql.append(" select FId,");
        schemeKSql.append("        FNumber,");
        schemeKSql.append("        FName,");
        schemeKSql.append("        fstate");
        schemeKSql.append("   from T_BG_BgForm");
        schemeKSql.append("  where FbgSchemeid = ?");
        schemeKSql.append("  and fstate <> 15");
        Connection conn = null;
        PreparedStatement formSta = null;
        ResultSet formRst = null;
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            formSta = conn.prepareStatement(schemeKSql.toString());
            formSta.setString(1, bgSchemeId);
            formRst = formSta.executeQuery();
            while (formRst.next()) {
                if (formRst.getInt("Fstate") == 2) {
                    returnMap.put(formRst.getString("fid"), formRst.getString("FNumber") + " " + formRst.getString("FName") + " " + ResourceBase.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"ctrl16", (Locale)ContextUtils.getLocaleFromEnv()));
                    continue;
                }
                returnMap.put(formRst.getString("fid"), formRst.getString("FNumber") + " " + formRst.getString("FName") + " " + ResourceBase.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"ctrl17", (Locale)ContextUtils.getLocaleFromEnv()));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(formRst);
                SQLUtils.cleanup(formSta);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)formRst);
        SQLUtils.cleanup((Statement)formSta);
        SQLUtils.cleanup((Connection)conn);
        if (!returnMap.isEmpty()) {
            return returnMap;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getCtrlMap(Context ctx, String orgId) throws BOSException, EASBizException {
        String locale = ctx.getLocale().toString();
        StringBuffer schemeKSql = new StringBuffer();
        String colName = "FName_" + locale;
        String colBoalias = "FBoalias_" + locale;
        String colSubSys = "FSubSystemalias_" + locale;
        schemeKSql.append(" select FId,");
        schemeKSql.append("        FNumber,");
        schemeKSql.append("        " + colName + ",");
        schemeKSql.append("        " + colBoalias + ",");
        schemeKSql.append("        " + colSubSys + "");
        schemeKSql.append("   from T_BG_BgControlScheme");
        schemeKSql.append("  where FCostCenterId = ?");
        schemeKSql.append("    and FIsValid = 1");
        schemeKSql.append("    and FIsSysDefault = 0");
        BgControlSchemeInfo ctrlSchemeInfo = null;
        Connection conn = null;
        PreparedStatement schemeSta = null;
        ResultSet schemeRst = null;
        HashMap<String, BgControlSchemeInfo> returnMap = new HashMap<String, BgControlSchemeInfo>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            schemeSta = conn.prepareStatement(schemeKSql.toString());
            schemeSta.setString(1, orgId);
            schemeRst = schemeSta.executeQuery();
            while (schemeRst.next()) {
                ctrlSchemeInfo = new BgControlSchemeInfo();
                ctrlSchemeInfo.setNumber(schemeRst.getString("FNumber"));
                ctrlSchemeInfo.setName(schemeRst.getString(colName));
                ctrlSchemeInfo.setBoAlias(schemeRst.getString(colBoalias));
                ctrlSchemeInfo.setSubSystemAlias(schemeRst.getString(colSubSys));
                returnMap.put(schemeRst.getString("FNumber"), ctrlSchemeInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(schemeRst);
                SQLUtils.cleanup(schemeSta);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)schemeRst);
        SQLUtils.cleanup((Statement)schemeSta);
        SQLUtils.cleanup((Connection)conn);
        if (!returnMap.isEmpty()) {
            return returnMap;
        }
        return null;
    }

    @Override
    protected boolean _doUnFiling(Context ctx, String schemeId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sqlScheme = new StringBuffer();
        String schemeNum = "";
        String schemeName = "";
        ArrayList<String> _tmpList = new ArrayList<String>();
        boolean result = true;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select fnumber,fname_l2 from t_bg_bgscheme where fid=?");
            pstmt.setString(1, schemeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                schemeNum = rst.getString(1);
                schemeName = rst.getString(2);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            String logName = schemeNum + " " + schemeName;
            IObjectPK Loginpk = LogUtil.beginLog((Context)ctx, (String)"_doUnFiling", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgScheme_unFiling");
            pstmt = conn.prepareStatement("select fid from t_bg_bgscheme where  frootid=(select frootid from t_bg_bgscheme where fid=?)");
            pstmt.setString(1, schemeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                sqlScheme.append("?,");
                _tmpList.add(rst.getString(1));
            }
            if (sqlScheme.length() > 0) {
                sqlScheme.delete(sqlScheme.length() - 1, sqlScheme.length());
            } else {
                sqlScheme.append("'#'");
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement("update t_bg_bgscheme set fisfiling = 0 WHERE fid in (" + sqlScheme.toString() + ") ");
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("update t_bg_bgform set frecord = 0 WHERE fbgschemeid in (" + sqlScheme.toString() + ") ");
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            pstmt.executeUpdate();
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            LogUtil.afterLog((Context)ctx, (IObjectPK)Loginpk);
        }
        catch (SQLException ex) {
            try {
                result = false;
                logger.error((Object)"_doUnFiling: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    @Override
    protected Map _getFilingMsg(Context ctx, String schemeId) throws BOSException, EASBizException {
        HashMap msgMap = new HashMap();
        HashMap<String, String> orgMap = new HashMap<String, String>();
        boolean isApproved = true;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String locale = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        ArrayList<String> bgSchemeIdArr = new ArrayList<String>();
        String orgName = "FName_" + locale;
        String schemeNum = "";
        String schemeName = "";
        try {
            ArrayList<String> formList;
            HashMap innerMap;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select fnumber,fname_l2 from t_bg_bgscheme where  fid='" + schemeId + "'");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                schemeNum = rst.getString(1);
                schemeName = rst.getString(2);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            String logName = schemeNum + " " + schemeName;
            IObjectPK Loginpk = LogUtil.beginLog((Context)ctx, (String)"_getFilingMsg", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgScheme_filing");
            pstmt = conn.prepareStatement("select fid from t_bg_bgscheme where  frootid=(select frootid from t_bg_bgscheme where fid='" + schemeId + "')");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgSchemeIdArr.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            String[] schemeIdArray = bgSchemeIdArr.toArray(new String[0]);
            String tranArray2String4Pre = BgHelper.tranArray2String4Pre(schemeIdArray);
            sql.append(" select a.fnumber,a.fname,b.fnumber,");
            sql.append("b." + orgName);
            sql.append(" from t_bg_bgform a left join t_org_baseunit b ");
            sql.append(" on a.forgunitid = b.fid ");
            sql.append(" where a.fstate <>2 and a.fstate <>15 ");
            if (!BgNSHelper.isStartBasisApproved((Map)BgNSHelper.getAllParamValue((Context)ctx))) {
                sql.append(" and a.fstate <>3 ");
            }
            sql.append(" and ((a.FBgTypeID <> 'BV/FQwEUEADgABtLwKgSXv9s2OA=') OR (a.FBgTypeID IS NULL))");
            sql.append(" and a.fbgschemeid IN " + tranArray2String4Pre);
            pstmt = conn.prepareStatement(sql.toString());
            BgHelper.setParamString4Pre(0, schemeIdArray, pstmt);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                isApproved = false;
                if (msgMap.containsKey(rst.getString(3))) {
                    innerMap = (HashMap)msgMap.get(rst.getString(3));
                    if (innerMap.containsKey("Form")) {
                        formList = (ArrayList<String>)innerMap.get("Form");
                        formList.add(rst.getString(1) + "-" + rst.getString(2));
                        continue;
                    }
                    formList = new ArrayList();
                    formList.add(rst.getString(1) + "-" + rst.getString(2));
                    innerMap.put("Form", formList);
                    continue;
                }
                innerMap = new HashMap();
                formList = new ArrayList<String>();
                formList.add(rst.getString(1) + "-" + rst.getString(2));
                innerMap.put("Form", formList);
                msgMap.put(rst.getString(3), innerMap);
                orgMap.put(rst.getString(3), rst.getString(4));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            sql = new StringBuffer();
            sql.append(" select a.fnumber,b.fnumber,");
            sql.append("b." + orgName);
            sql.append(" from t_bg_bgadjustbill a left join t_org_baseunit b ");
            sql.append(" on a.forgunitid = b.fid ");
            sql.append(" where a.fstate !=9 ");
            sql.append(" and a.fbgschemeid IN " + tranArray2String4Pre);
            pstmt = conn.prepareStatement(sql.toString());
            BgHelper.setParamString4Pre(0, schemeIdArray, pstmt);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                isApproved = false;
                if (msgMap.containsKey(rst.getString(2))) {
                    ArrayList adjustBillList;
                    innerMap = (HashMap)msgMap.get(rst.getString(2));
                    if (innerMap.containsKey("AdjustBill")) {
                        adjustBillList = (ArrayList)innerMap.get("AdjustBill");
                        adjustBillList.add(rst.getString(1));
                        continue;
                    }
                    adjustBillList = new ArrayList();
                    adjustBillList.add(rst.getString(1));
                    innerMap.put("AdjustBill", adjustBillList);
                    continue;
                }
                innerMap = new HashMap();
                formList = new ArrayList<String>();
                formList.add(rst.getString(1));
                innerMap.put("AdjustBill", formList);
                msgMap.put(rst.getString(2), innerMap);
                orgMap.put(rst.getString(2), rst.getString(3));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            sql = new StringBuffer();
            sql.append(" select a.fnumber,a.fname,c.fnumber,");
            sql.append("c." + orgName);
            sql.append(" from t_bg_bgactualrecord a left join t_bg_bgform b on a.fbgformid = b.fid ");
            sql.append(" left join t_org_baseunit c on b.forgunitid = c.fid ");
            sql.append(" where a.fstate !=2 ");
            sql.append(" and b.fbgschemeid IN " + tranArray2String4Pre);
            pstmt = conn.prepareStatement(sql.toString());
            BgHelper.setParamString4Pre(0, schemeIdArray, pstmt);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                isApproved = false;
                if (msgMap.containsKey(rst.getString(3))) {
                    ArrayList actualRecordList;
                    innerMap = (HashMap)msgMap.get(rst.getString(3));
                    if (innerMap.containsKey("ActualRecord")) {
                        actualRecordList = (ArrayList)innerMap.get("ActualRecord");
                        actualRecordList.add(rst.getString(1) + "-" + rst.getString(2));
                        continue;
                    }
                    actualRecordList = new ArrayList();
                    actualRecordList.add(rst.getString(1) + "-" + rst.getString(2));
                    innerMap.put("ActualRecord", actualRecordList);
                    continue;
                }
                innerMap = new HashMap();
                formList = new ArrayList();
                formList.add(rst.getString(1) + "-" + rst.getString(2));
                innerMap.put("ActualRecord", formList);
                msgMap.put(rst.getString(3), innerMap);
                orgMap.put(rst.getString(3), rst.getString(4));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (isApproved) {
                sql = new StringBuffer();
                sql.append(" select b.fnumber,");
                sql.append("b." + orgName);
                sql.append(" from t_bg_bgform a left join t_org_baseunit b ");
                sql.append(" on a.forgunitid = b.fid ");
                sql.append(" where a.fstate = 2 ");
                sql.append(" and a.fbgschemeid IN " + tranArray2String4Pre);
                sql.append(" and ((a.FBgTypeID <> 'BV/FQwEUEADgABtLwKgSXv9s2OA=') OR (a.FBgTypeID IS NULL))");
                pstmt = conn.prepareStatement(sql.toString());
                BgHelper.setParamString4Pre(0, schemeIdArray, pstmt);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (orgMap.containsKey(rst.getString(1))) continue;
                    orgMap.put(rst.getString(1), rst.getString(2));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                sql = new StringBuffer();
                sql.append(" select b.fnumber,");
                sql.append("b." + orgName);
                sql.append(" from t_bg_bgadjustbill a left join t_org_baseunit b ");
                sql.append(" on a.forgunitid = b.fid ");
                sql.append(" where a.fstate = 9 ");
                sql.append(" and a.fbgschemeid IN " + tranArray2String4Pre);
                pstmt = conn.prepareStatement(sql.toString());
                rst = pstmt.executeQuery();
                BgHelper.setParamString4Pre(0, schemeIdArray, pstmt);
                while (rst.next()) {
                    if (orgMap.containsKey(rst.getString(1))) continue;
                    orgMap.put(rst.getString(1), rst.getString(2));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                sql = new StringBuffer();
                sql.append(" select c.fnumber,");
                sql.append("c." + orgName);
                sql.append(" from t_bg_bgactualrecord a left join t_bg_bgform b ");
                sql.append(" on a.fbgformid = b.fid ");
                sql.append(" left join t_org_baseunit c ");
                sql.append(" on b.forgunitid = c.fid ");
                sql.append(" where a.fstate = 2 ");
                sql.append(" and b.fbgschemeid IN " + tranArray2String4Pre);
                pstmt = conn.prepareStatement(sql.toString());
                BgHelper.setParamString4Pre(0, schemeIdArray, pstmt);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (orgMap.containsKey(rst.getString(1))) continue;
                    orgMap.put(rst.getString(1), rst.getString(2));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                pstmt = conn.prepareStatement("update t_bg_bgscheme set fisfiling = 1, fisformal = 0 WHERE fid in " + tranArray2String4Pre);
                pstmt.executeUpdate();
                pstmt = conn.prepareStatement("update t_bg_bgform set frecord = 1 WHERE fbgschemeid in " + tranArray2String4Pre);
                pstmt.executeUpdate();
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
            msgMap.put("Org", orgMap);
            LogUtil.afterLog((Context)ctx, (IObjectPK)Loginpk);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"_getFilingMsg: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return msgMap;
    }
}

