/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgTendencyAnalysisObjInfo;
import com.kingdee.eas.ma.budget.BgTendencyFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.util.AnalysisColumnTool;
import com.kingdee.eas.ma.budget.app.AbstractBgTendencyAnalysisFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgTendencyAnalysisFacadeControllerBean
extends AbstractBgTendencyAnalysisFacadeControllerBean {
    private static final long serialVersionUID = 4215682811760598391L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgTendencyAnalysisFacadeControllerBean");
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String date_pattern = "yyyy-MM-dd HH:mm:ss";

    @Override
    protected List _getBgItemNumber(Context ctx, BgPeriodInfo sInfo, BgPeriodInfo eInfo) throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        if (sInfo.getNumber().equals(eInfo.getNumber())) {
            list.add(sInfo.getNumber());
            return list;
        }
        int periodtype = sInfo.getPeriodType().getValue();
        Date sDate = sInfo.getBeginDate();
        Date newSDate = new Date(sDate.getYear(), sDate.getMonth(), sDate.getDate(), 0, 0, 0);
        Date eDate = eInfo.getEndDate();
        Date newEDate = new Date(eDate.getYear(), eDate.getMonth(), eDate.getDate(), 23, 59, 59);
        String sql = "select fnumber from t_bg_bgperiod  where fbegindate >= to_date('" + this.dateToStr(newSDate) + "')  and fenddate <= to_date('" + this.dateToStr(newEDate) + "')  and fperiodtype = " + periodtype + " order by fnumber";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String bgItemNumer = rs.getString("fnumber");
                list.add(bgItemNumer);
            }
        }
        catch (SQLDataException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return list;
    }

    private String dateToStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(date_pattern);
        return sdf.format(date);
    }

    private String commonSql(BgTendencyFilterParam filterParam) {
        String bgSchemeID = filterParam.getBgSchemeInfo().getId().toString();
        String bgFormID = filterParam.getBgFormID();
        CostCenterOrgUnitInfo[] lazyLoadDataOrgUnitInfoAry = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        StringBuffer sql = new StringBuffer(" select fbgvalue ,FBizActual,forgunitid, fformula from t_bg_bgdata ");
        sql.append(" where");
        sql.append(" fbgtemplateid in (select fid from t_bg_bgtemplate where frootid = (select frootid from t_bg_bgtemplate where fid in (select fbgtemplateid from t_bg_bgform where fid = '" + bgFormID + "')))");
        sql.append(" and fbgschemeid in (select fid from t_bg_bgscheme where frootid = (select frootid from t_bg_bgscheme where fid = '" + bgSchemeID + "'))");
        sql.append(" and forgunitid in " + this.constructOrgUnitSql(lazyLoadDataOrgUnitInfoAry));
        return sql.toString();
    }

    private String constructOrgUnitSql(CostCenterOrgUnitInfo[] orgAry) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = orgAry.length;
        for (int i = 0; i < num; ++i) {
            String tempOrgId = orgAry[i].getId().toString();
            sb.append(tempOrgId);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private String constructBgItemSql(List bgItemList) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = bgItemList.size();
        for (int i = 0; i < num; ++i) {
            String bgItem = bgItemList.get(i).toString();
            sb.append(bgItem);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private Map getAllBgItemListForBaseData(List selectedBgItemList, List periodNumList) {
        HashMap<String, String> map = new HashMap<String, String>();
        String baseBgItem = "";
        int iNum = selectedBgItemList.size();
        for (int i = 0; i < iNum; ++i) {
            String bgItem = selectedBgItemList.get(i).toString();
            String[] params = BgFillHelper.parseStrFormulaToArray(bgItem);
            int jNum = periodNumList.size();
            for (int j = 0; j < jNum; ++j) {
                String periodNum;
                if (j == 0) {
                    periodNum = periodNumList.get(j).toString();
                    baseBgItem = AnalysisColumnTool.rebuildFormulaWithPeriodParam(params, periodNum);
                    map.put(baseBgItem, baseBgItem);
                    continue;
                }
                periodNum = periodNumList.get(j).toString();
                String newBgItem = AnalysisColumnTool.rebuildFormulaWithPeriodParam(params, periodNum);
                map.put(newBgItem, baseBgItem);
            }
        }
        return map;
    }

    private Map getAllBgItemListForCircleData(List selectedBgItemList, List periodNumList) {
        HashMap<String, String> map = new HashMap<String, String>();
        String theLastBgItem = "";
        int iNum = selectedBgItemList.size();
        for (int i = 0; i < iNum; ++i) {
            String bgItem = selectedBgItemList.get(i).toString();
            String[] params = BgFillHelper.parseStrFormulaToArray(bgItem);
            int jNum = periodNumList.size();
            for (int j = 0; j < jNum; ++j) {
                String periodNum = periodNumList.get(j).toString();
                String newBgItem = AnalysisColumnTool.rebuildFormulaWithPeriodParam(params, periodNum);
                map.put(newBgItem, theLastBgItem);
                theLastBgItem = newBgItem;
            }
        }
        return map;
    }

    @Override
    protected Map _getBaseData(Context ctx, BgTendencyFilterParam filterParam) throws BOSException {
        HashMap<String, BgTendencyAnalysisObjInfo> map = new HashMap<String, BgTendencyAnalysisObjInfo>();
        List selectedBgItemList = filterParam.getBgItemList();
        Map allBgItemMap = this.getAllBgItemListForBaseData(selectedBgItemList, filterParam.getPeriodNumList());
        String sql = this.commonSql(filterParam);
        sql = sql + " and fformula in " + this.constructBgItemSql(new ArrayList(allBgItemMap.keySet()));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String formula = rs.getString("fformula");
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("fbizactual");
                String orgUnitId = rs.getString("forgunitid");
                if (map.keySet().contains(formula)) {
                    BgTendencyAnalysisObjInfo info = (BgTendencyAnalysisObjInfo)map.get(formula);
                    info.addData(budget, actual, orgUnitId);
                    continue;
                }
                map.put(formula, new BgTendencyAnalysisObjInfo(orgUnitId, budget, actual, allBgItemMap.get(formula).toString(), new HashMap()));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        this.makeReturnMapIntegrity(map, allBgItemMap, filterParam);
        return map;
    }

    @Override
    protected Map _getCircleData(Context ctx, BgTendencyFilterParam filterParam) throws BOSException {
        HashMap<String, BgTendencyAnalysisObjInfo> map = new HashMap<String, BgTendencyAnalysisObjInfo>();
        List selectedBgItemList = filterParam.getBgItemList();
        Map allBgItemMap = this.getAllBgItemListForCircleData(selectedBgItemList, filterParam.getPeriodNumList());
        String sql = this.commonSql(filterParam);
        sql = sql + " and fformula in " + this.constructBgItemSql(new ArrayList(allBgItemMap.keySet()));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String formula = rs.getString("fformula");
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("fbizactual");
                String orgUnitId = rs.getString("forgunitid");
                if (map.keySet().contains(formula)) {
                    BgTendencyAnalysisObjInfo info = (BgTendencyAnalysisObjInfo)map.get(formula);
                    info.addData(budget, actual, orgUnitId);
                    continue;
                }
                map.put(formula, new BgTendencyAnalysisObjInfo(orgUnitId, budget, actual, allBgItemMap.get(formula).toString(), new HashMap()));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        this.makeReturnMapIntegrity(map, allBgItemMap, filterParam);
        return map;
    }

    private void makeReturnMapIntegrity(Map rtnMap, Map allBgItemMap, BgTendencyFilterParam filterParam) {
        CostCenterOrgUnitInfo[] costOrgInfoAry = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        ArrayList allBgItemList = new ArrayList(allBgItemMap.keySet());
        Set rtnSet = rtnMap.keySet();
        int iNum = costOrgInfoAry.length;
        for (int i = 0; i < iNum; ++i) {
            String orgID = costOrgInfoAry[i].getId().toString();
            int jNum = allBgItemList.size();
            for (int j = 0; j < jNum; ++j) {
                String formula = allBgItemList.get(j).toString();
                if (rtnSet.contains(formula)) continue;
                rtnMap.put(formula, new BgTendencyAnalysisObjInfo(orgID, ZERO, ZERO, allBgItemMap.get(formula).toString(), new HashMap()));
            }
        }
    }
}

