/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.lcm.ILCMConsumeBill;
import com.kingdee.eas.fi.lcm.LCMConsumeBillFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeBillInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.ActualTypeEnum;
import com.kingdee.eas.ma.budget.BgActualDetailInfo;
import com.kingdee.eas.ma.budget.BgAvlBalDetailInfo;
import com.kingdee.eas.ma.budget.BgControlItemMapCollection;
import com.kingdee.eas.ma.budget.BgControlItemMapInfo;
import com.kingdee.eas.ma.budget.BgControlMultiRuleCollection;
import com.kingdee.eas.ma.budget.BgControlMultiRuleInfo;
import com.kingdee.eas.ma.budget.BgControlRuleCollection;
import com.kingdee.eas.ma.budget.BgControlRuleInfo;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.BgCtrlBizParamFactory;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgCtrlMRCtrlRuleEnum;
import com.kingdee.eas.ma.budget.BgCtrlMRCtrlValueEnum;
import com.kingdee.eas.ma.budget.BgCtrlMultiRuleEntryCollection;
import com.kingdee.eas.ma.budget.BgCtrlMultiRuleEntryInfo;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.BgCtrlRecordCollection;
import com.kingdee.eas.ma.budget.BgCtrlRecordInfo;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgCtrlTypeEnum;
import com.kingdee.eas.ma.budget.BgDBUtils;
import com.kingdee.eas.ma.budget.BgDataFactory;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgMultiRuleCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgOverspendInfo;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTraceFindBudgetMsg;
import com.kingdee.eas.ma.budget.BgTraceTypeEnum;
import com.kingdee.eas.ma.budget.BudgetCtrlConstants;
import com.kingdee.eas.ma.budget.BudgetCtrlFacadeFactory;
import com.kingdee.eas.ma.budget.BudgetCtrlState;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.BudgetRequestCategory;
import com.kingdee.eas.ma.budget.BudgetRequestType;
import com.kingdee.eas.ma.budget.IBgData;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBudgetCtrlFacade;
import com.kingdee.eas.ma.budget.app.AbstractBudgetCtrlFacadeControllerBean;
import com.kingdee.eas.ma.budget.app.BgBalCalculator;
import com.kingdee.eas.ma.budget.app.BgCtrlMonitorInfo;
import com.kingdee.eas.ma.budget.app.BgDbBatchUtil;
import com.kingdee.eas.ma.budget.app.BudgetCtrlCacheHelper;
import com.kingdee.eas.ma.budget.app.BudgetCtrlHelper;
import com.kingdee.eas.ma.budget.app.BudgetCtrlLogger;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillInfo;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlBalCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlFormulaInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BudgetCtrlFacadeControllerBean
extends AbstractBudgetCtrlFacadeControllerBean {
    private static final long serialVersionUID = -7264115487494722480L;
    private static Logger logger = Logger.getLogger(BudgetCtrlFacadeControllerBean.class);
    private static final int DEFAULT_LEVEL = 1;
    private static final String CONTROL_LEVEL = "C0001";

    @Override
    protected boolean _requestBudgetLocal(Context ctx, BOSUuid boId) throws BOSException, BgCtrlException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.LOCAL_APPROVE);
        return this.requestBudget(ctx, state, boId, true);
    }

    @Override
    protected boolean _requestBudgetWF(Context ctx, BOSUuid boId) throws BOSException, BgCtrlException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.WF_APPROVE);
        return this.requestBudget(ctx, state, boId, true);
    }

    @Override
    protected void _specialApprove(Context ctx, BOSUuid boId) throws BOSException, BgCtrlException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.SPECIAL_APPROVE);
        this.requestBudget(ctx, state, boId, false);
    }

    private boolean requestBudget(Context ctx, BudgetCtrlState state, BOSUuid boId, boolean isCheckBalance) throws BOSException, BgCtrlException, EASBizException {
        boolean isBackgroundCollect;
        BgCtrlMonitorInfo bgCtrlMonitor = new BgCtrlMonitorInfo();
        bgCtrlMonitor.setBillID(boId.toString());
        bgCtrlMonitor.setCreateTime(new Date(System.currentTimeMillis()));
        if (state == null) {
            state = new BudgetCtrlState(BudgetRequestType.LOCAL_APPROVE);
        }
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        boolean isNeedLog = false;
        String boName = BudgetCtrlHelper.getBOName(ctx, boId);
        bgCtrlMonitor.setBoName(boName);
        if (BudgetCtrlHelper.isCPBCBill(boName)) {
            isNeedLog = true;
        }
        String ouid = BudgetCtrlHelper.getBillOUID(ctx, boId.toString(), boName);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, ouid);
        if (isNeedLog) {
            logger.info((Object)("---requestBudgetLog---\nboId = " + boId.toString() + ", ouId = " + ouid));
        }
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            throw new BgCtrlException(BgCtrlException.NOCTRLSCHEME);
        }
        bgCtrlMonitor.setCtrlSchemeID(ctrlScheme.getId().toString());
        boolean isPass = false;
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, boId.toString(), boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        this.recordCtrlParam(ctrlParamCol, bgCtrlMonitor);
        IBudgetCtrlFacade iCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
        iCtrl.lockCostCentersTransaction(ctrlParamCol);
        ctrlResultCol = state.isNeedHint() ? this.getBgCtrlResultColBal(ctx, ctrlParamCol, ctrlResultCol) : this.getBgCtrlResultCol(ctx, state, ctrlParamCol, ctrlResultCol);
        if (!BudgetCtrlHelper.hasScheme(ctx, boName, boId)) {
            ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        }
        Map returnData = this.getReturnBudget(ctx, boId.toString(), boName);
        ctrlResultCol = this.mergeReturnBudget(ctx, ctrlResultCol, returnData);
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        isPass = isCheckBalance ? BudgetCtrlHelper.checkBudget(ctx, state, ctrlResultCol, ctrlParamCol, ctrlScheme) : true;
        bgCtrlMonitor.setPass(isPass);
        if (!isPass) {
            if (BgNSHelper.isMonitorBgCtrl((Context)ctx)) {
                this.saveBgCtrlMonitorInfo(ctx, bgCtrlMonitor);
            }
            return false;
        }
        ctrlResultCol = BudgetCtrlHelper.getSuperiorItemCtrlData(ctx, ctrlResultCol);
        this.recordBgDataInfo(ctrlResultCol, bgCtrlMonitor);
        Map bgDataMap = BudgetCtrlHelper.getBgDataMap(ctx, ctrlResultCol, returnData);
        iCtrl.writeCtrlData(boId.toString(), boName, ctrlResultCol, bgDataMap);
        if (isNeedLog) {
            BudgetCtrlLogger.logRequestBudget(ctx, state.getRequestType(), ctrlResultCol);
        }
        if (!(isBackgroundCollect = BgNSHelper.getBG028_queueBgCtrl((Context)ctx))) {
            this.collectCtrlDataImmediately(ctx, state, ctrlResultCol);
        }
        BudgetCtrlHelper.updateBizActual(ctx, boId.toString());
        if (BgNSHelper.isMonitorBgCtrl((Context)ctx)) {
            this.saveBgCtrlMonitorInfo(ctx, bgCtrlMonitor);
        }
        return isPass;
    }

    private boolean isCtrl(Context ctx, String boName, String ouid) throws EASBizException, BOSException {
        return BgCtrlBizParamFactory.getLocalInstance(ctx).isCtrl(ouid, boName);
    }

    @Override
    protected void _writeCtrlData(Context ctx, String boId, String boName, BgCtrlResultCollection ctrlResultCol, Map bgDataMap) throws BOSException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.WF_APPROVE);
        BudgetCtrlHelper.deleteReturnCtrlRecord(ctx, boId, boName);
        BudgetCtrlHelper.insertCtrlRecord(ctx, state, ctrlResultCol);
    }

    private BgCtrlResultCollection getBgCtrlResultCol(Context ctx, BudgetCtrlState state, BgCtrlParamCollection ctrlParamCol, BgCtrlResultCollection ctrlResultCol) throws BOSException, EASBizException {
        if (ctrlParamCol != null && ctrlParamCol.size() > 0) {
            for (int i = 0; i < ctrlParamCol.size(); ++i) {
                BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
                BgCtrlResultInfo ctrlResultInfo = null;
                String orgUnitId = ctrlParamInfo.getOrgUnitId();
                String bgSchemeId = ctrlParamInfo.getBgSchemeId();
                String formula = ctrlParamInfo.getItemFormula();
                String BOName = "";
                if (ctrlParamInfo.getString("BOName") != null) {
                    BOName = ctrlParamInfo.getString("BOName");
                }
                if (!BudgetCtrlState.isNeedCalBalance(state)) {
                    BgDataInfo bgDataInfo = null;
                    bgDataInfo = BOName.equals("com.kingdee.eas.ma.nbudget.app.BudgetRequestBill") ? BgBalCalculator.getBgData1(ctx, orgUnitId, bgSchemeId, formula, true) : BgBalCalculator.getBgData(ctx, orgUnitId, bgSchemeId, formula, true);
                    ctrlResultInfo = new BgCtrlResultInfo();
                    ctrlResultInfo.setBgPeriodType(ctrlParamInfo.getPeriodType().getValue());
                    ctrlResultInfo = BudgetCtrlHelper.fillCtrlParam2CtrlResult(ctrlParamInfo, ctrlResultInfo);
                    if (BudgetCtrlUtil.isEmpty(bgDataInfo) || BudgetCtrlHelper.isEmptyBgData(ctx, bgDataInfo)) {
                        ctrlResultInfo.setBgDataId(null);
                        ctrlResultInfo.setBalance(null);
                    } else {
                        ctrlResultInfo.setBgDataId(bgDataInfo.getId().toString());
                        ctrlResultInfo.setBgValue(bgDataInfo.getBgValue());
                        ctrlResultInfo.setBizActual(bgDataInfo.getBizActual());
                        ctrlResultInfo.setCtrlType(bgDataInfo.getCtrlType());
                        ctrlResultInfo.setIsAllowAccess(bgDataInfo.isIsAllowAccess());
                        ctrlResultInfo.setIsBalanced(true);
                    }
                    ctrlResultCol.add(ctrlResultInfo);
                    continue;
                }
                if (state.isNeedHint()) {
                    BgCtrlResultCollection ctrlCol = null;
                    ctrlCol = BgBalCalculator.calcuBalCol(ctx, ctrlParamInfo, true, BgGetPeriodTypeForGetBlanceEnum.Is_Control);
                    ctrlResultCol.addCollection(ctrlCol);
                    continue;
                }
                ctrlResultInfo = BgBalCalculator.calcuBal(ctx, ctrlParamInfo, true, BgGetPeriodTypeForGetBlanceEnum.Is_Control);
                ctrlResultCol.add(ctrlResultInfo);
            }
        }
        return ctrlResultCol;
    }

    private BgCtrlParamCollection buildCtrlParamCol(Context ctx, BudgetCtrlState state, String boId, String boName, BgControlSchemeInfo ctrlScheme) throws BOSException, EASBizException {
        logger.info((Object)"-----------kingdee logger by budget BgCtrlParamCollection.buildCtrlParamCol()----------");
        BgCtrlParamCollection ctrlParamCol = new BgCtrlParamCollection();
        HashMap checkDumpParam = new HashMap();
        String boAlias = ctrlScheme.getBoAlias();
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        for (int i = 0; i < ruleCol.size(); ++i) {
            BgControlRuleInfo rule = ruleCol.get(i);
            String oqlOrgUnit = rule.getOqlOrgUnit();
            String oqlItemCombination = rule.getOqlItemCombination();
            String aliasItemCombination = rule.getAliasItemCombination();
            String oqlCurrency = rule.getOqlCurrency();
            BgPeriodEnum periodType = rule.getPeriodCycle();
            String customBgPeriodNumber = rule.getCustomBgPeriodNumber();
            String elementNumber = rule.getElementNumber();
            String oqlBizDate = rule.getOqlBizDate();
            String oqlRequest = rule.getOqlRequest();
            String oqlRequestExp = rule.getOqlRequestExtendExpression();
            String oqlRuleCondition = rule.getOqlRuleCondition();
            ArrayList<String> billItemFields = new ArrayList<String>();
            String[] tpp = oqlItemCombination.split("\\@");
            for (int x = 0; x < tpp.length; ++x) {
                String[] subTpp = tpp[x].split("\\|");
                billItemFields.add(subTpp[0]);
            }
            logger.info((Object)"---------sql params-------");
            logger.info((Object)("boId = " + boId));
            logger.info((Object)("boName = " + boName));
            logger.info((Object)("oqlOrgUnit = " + oqlOrgUnit));
            logger.info((Object)("oqlItemCombination = " + oqlItemCombination));
            logger.info((Object)("oqlCurrency = " + oqlCurrency));
            logger.info((Object)("oqlBizDate = " + oqlBizDate));
            logger.info((Object)("oqlRequest = " + oqlRequest));
            logger.info((Object)("oqlRequestExp = " + oqlRequestExp));
            logger.info((Object)("oqlRuleCondition = " + oqlRuleCondition));
            List oqlList = BudgetCtrlHelper.getQueryBillOQL(ctx, boId, boName, oqlOrgUnit, oqlItemCombination, oqlCurrency, oqlBizDate, oqlRequest, oqlRequestExp, oqlRuleCondition);
            String queryBillOQL = (String)oqlList.get(0);
            int itemFieldCount = (Integer)oqlList.get(1);
            int oqlRequestExpTempCount = (Integer)oqlList.get(2);
            if ("com.kingdee.eas.fi.gl.app.Voucher".equals(boName)) {
                queryBillOQL = queryBillOQL + " and isMgCtrl = 1 ";
            }
            IDataProvider dataProvider = EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(boName));
            dataProvider.setObjectView(queryBillOQL);
            String queryBillSQL = dataProvider.getSQL();
            if (!BudgetCtrlUtil.isEmpty(oqlRuleCondition)) {
                queryBillSQL = queryBillSQL.replaceAll("INNER JOIN", "LEFT OUTER JOIN");
                if ("com.kingdee.eas.fi.gl.app.Voucher".equals(boName)) {
                    queryBillSQL = queryBillSQL.replaceAll("SELECT ", "SELECT DISTINCT ");
                }
            }
            IRowSet rst = null;
            try {
                rst = DbUtil.executeQuery((Context)ctx, (String)queryBillSQL);
                logger.info((Object)queryBillSQL);
                while (rst.next()) {
                    String reqElementNumber;
                    BgCtrlParamInfo ctrlParamInfo = new BgCtrlParamInfo();
                    String _orgUnitNumber = BudgetCtrlUtil.replaceNULL(rst.getString(2), "");
                    if (BudgetCtrlUtil.isEmpty(_orgUnitNumber)) continue;
                    String _orgUnitName = BudgetCtrlUtil.replaceNULL(rst.getString(3), _orgUnitNumber);
                    CostCenterOrgUnitInfo orgInfo = BudgetCtrlCacheHelper.getCostCenter(ctx, _orgUnitNumber);
                    if (orgInfo == null) continue;
                    String _orgUnitId = orgInfo.getId().toString();
                    ctrlParamInfo.setBillSourceOrgUnitId(_orgUnitId);
                    ctrlParamInfo.setOrgUnitId(_orgUnitId);
                    ctrlParamInfo.setOrgUnitName(_orgUnitName);
                    String _billItemNumber = "";
                    String _billItemFieldAndNumber = "";
                    String _billItemName = "";
                    String _itemCombinNumber = "";
                    boolean isInvalidate = false;
                    for (int j = 1; j <= itemFieldCount; ++j) {
                        String tempBillItemNumber = rst.getString(2 + 2 * j);
                        String tempBillItemName = rst.getString(2 + 2 * j + 1);
                        if (BudgetCtrlUtil.isEmpty(tempBillItemNumber)) {
                            isInvalidate = true;
                            break;
                        }
                        _billItemNumber = _billItemNumber + tempBillItemNumber + ",";
                        _billItemName = _billItemName + tempBillItemName + "_";
                        _billItemFieldAndNumber = _billItemFieldAndNumber + billItemFields.get(j - 1) + ":" + tempBillItemNumber + "|";
                    }
                    if (isInvalidate) continue;
                    _billItemNumber = BudgetCtrlUtil.deleteStrTail(_billItemNumber);
                    _billItemFieldAndNumber = BudgetCtrlUtil.deleteStrTail(_billItemFieldAndNumber);
                    _billItemName = BudgetCtrlUtil.deleteStrTail(_billItemName);
                    String mappedItemNumber = BudgetCtrlHelper.mappingBgItem(ctx, _billItemFieldAndNumber, ctrlScheme, _orgUnitId);
                    if (mappedItemNumber != null) {
                        _itemCombinNumber = mappedItemNumber;
                    } else {
                        if (!StringUtils.isEmpty((String)oqlItemCombination) && !StringUtils.isEmpty((String)_billItemNumber) && oqlItemCombination.indexOf("entries.assistRecords.assGrp.generalAssActType") != -1) {
                            _billItemNumber = _billItemNumber.replaceAll("\\!", "\\.");
                        }
                        _itemCombinNumber = _billItemNumber;
                    }
                    ctrlParamInfo.setItemCombinNumber(_itemCombinNumber);
                    ctrlParamInfo.setItemCombinName(_billItemName);
                    ctrlParamInfo.setBillItemNumber(_billItemNumber);
                    ctrlParamInfo.setBillItemName(_billItemName);
                    ctrlParamInfo.setBillItemAlias(aliasItemCombination);
                    ctrlParamInfo.setBillItemOql(oqlItemCombination);
                    String _currencyNumber = rst.getString(4 + 2 * itemFieldCount);
                    ctrlParamInfo.setCurrencyNumber(_currencyNumber);
                    if ("com.kingdee.eas.ma.nbudget.app.BudgetRequestBill".equals(boName) && !elementNumber.equals(reqElementNumber = rst.getString(7 + 2 * itemFieldCount + oqlRequestExpTempCount))) continue;
                    ctrlParamInfo.setElementNumber(elementNumber);
                    BgElementInfo elementInfo = BudgetCtrlCacheHelper.getBgElement(ctx, elementNumber);
                    ctrlParamInfo.setElementName(elementInfo.getName());
                    java.sql.Date _bizDate = rst.getDate(5 + 2 * itemFieldCount);
                    ctrlParamInfo.setBizDate(_bizDate);
                    BigDecimal requestValue = rst.getBigDecimal(6 + 2 * itemFieldCount);
                    requestValue = BudgetCtrlHelper.calcuRequestAmount(requestValue, oqlRequest, oqlRequestExp, rst, itemFieldCount);
                    ctrlParamInfo.setAmount(requestValue);
                    BgPeriodInfo bgPeriodInfo = null;
                    bgPeriodInfo = BudgetCtrlHelper.mappingBgPeriod(ctx, (Date)_bizDate, ctrlScheme, periodType.getValue(), customBgPeriodNumber);
                    if (bgPeriodInfo == null || bgPeriodInfo.getId() == null) continue;
                    String _periodId = bgPeriodInfo.getId().toString();
                    String _periodNumber = bgPeriodInfo.getNumber();
                    String _periodName = bgPeriodInfo.getName();
                    ctrlParamInfo.setPeriodId(_periodId);
                    ctrlParamInfo.setPeriodNumber(_periodNumber);
                    ctrlParamInfo.setPeriodName(_periodName);
                    ctrlParamInfo.setPeriodType(periodType);
                    String _srcBillNumber = BudgetCtrlUtil.replaceNULL(rst.getString(1), "");
                    ctrlParamInfo.setSrcBillId(boId);
                    ctrlParamInfo.setSrcBillNumber(_srcBillNumber);
                    ctrlParamInfo.setBillType(boAlias);
                    ctrlParamInfo.put("BOName", BudgetCtrlHelper.getBOName(ctx, boId));
                    String _bgSchemeId = BudgetCtrlHelper.getActivedBgSchemeID(ctx, ctrlParamInfo, _bizDate, boName, boId);
                    if (BudgetCtrlUtil.isEmpty(_bgSchemeId)) {
                        BudgetCtrlHelper.mergeSameCtrlParam(ctrlParamInfo, ctrlParamCol, checkDumpParam);
                        continue;
                    }
                    ctrlParamInfo.setBgSchemeId(_bgSchemeId);
                    if (BudgetRequestType.GET_BUDGET == state.getRequestType()) {
                        BudgetCtrlHelper.mergeSameCtrlParam(ctrlParamInfo, ctrlParamCol, checkDumpParam);
                        continue;
                    }
                    BgCtrlParamInfo temp = (BgCtrlParamInfo)ctrlParamInfo.clone();
                    temp.setBillSourceOrgUnitId(ctrlParamInfo.getBillSourceOrgUnitId());
                    ctrlParamCol.add(temp);
                }
                continue;
            }
            catch (BOSException ex) {
                logger.error((Object)"error", (Throwable)ex);
                throw ex;
            }
            catch (SQLException ex) {
                logger.error((Object)"error", (Throwable)ex);
                throw new BgException(BgException.CTRLSHEMEERROR);
            }
            catch (EASBizException ex) {
                logger.error((Object)"error", (Throwable)ex);
                throw ex;
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        ctrlParamCol = BudgetCtrlHelper.processItemCombination(ctx, ctrlParamCol);
        checkDumpParam.clear();
        return ctrlParamCol;
    }

    private BgCtrlParamCollection buildCtrlParamCol(Context ctx, BudgetCtrlState state, IObjectValue billInfo, String boName, BgControlSchemeInfo ctrlScheme) throws BOSException, EASBizException {
        BgCtrlParamCollection ctrlParamCol = new BgCtrlParamCollection();
        HashMap checkDumpParam = new HashMap();
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        IObjectValue filterInfo = null;
        String oqlOrgUnit = null;
        String oqlItemCombination = null;
        String aliasItemCombination = null;
        String oqlOqlCurrency = null;
        String oqlOqlBizDate = null;
        String oqlRequest = null;
        String oqlExtendExpr = null;
        BgPeriodEnum periodType = null;
        String customBgPeriodNumber = null;
        String oqlRuleCondition = null;
        String[] fields = null;
        List fieldValues = null;
        Map fieldValueMap = null;
        Object obj = null;
        String value_orgUnit = null;
        String value_currency = null;
        CurrencyInfo currency = null;
        String value_element = null;
        BgElementInfo elementInfo = null;
        Date value_bizDate = null;
        BigDecimal value_request = null;
        BgPeriodInfo bgPeriodInfo = null;
        String boNumber = null;
        String bgSchemeId = null;
        String boAlias = ctrlScheme.getBoAlias();
        for (int i = 0; i < ruleCol.size(); ++i) {
            BgControlRuleInfo rule = ruleCol.get(i);
            oqlRuleCondition = rule.getOqlRuleCondition();
            if (oqlRuleCondition != null && oqlRuleCondition.trim().length() > 0) {
                try {
                    EntityViewInfo fi;
                    String oql = "where " + oqlRuleCondition;
                    if ("com.kingdee.eas.fi.gl.app.Voucher".equals(boName) || "com.kingdee.eas.cp.bc.app.BizAccountBill".equals(boName)) {
                        fi = new EntityViewInfo(oql);
                        FilterItemCollection filters = fi.getFilter().getFilterItems();
                        HashMap<String, Object> filterMap = new HashMap<String, Object>();
                        if (filters != null && filters.size() > 0) {
                            String key = null;
                            Object value = null;
                            for (int m = 0; m < filters.size(); ++m) {
                                key = filters.get(m).getPropertyName();
                                key = key.toLowerCase();
                                value = filters.get(m).getCompareValue();
                                filterMap.put(key, value);
                            }
                            if (!filterMap.isEmpty()) {
                                Enumeration enums = billInfo.keys();
                                String key1 = null;
                                while (enums.hasMoreElements()) {
                                    key1 = (String)enums.nextElement();
                                    if (!filterMap.containsKey(key1 = key1.toLowerCase()) || (obj = billInfo.get(key1)) == null || !(obj instanceof java.sql.Date)) continue;
                                    java.sql.Date oldDate = (java.sql.Date)obj;
                                    Date date = new Date(oldDate.getTime());
                                    billInfo.setDate(key1, date);
                                }
                            }
                        }
                    }
                    fi = new EntityViewInfo(oql);
                    FilterItemCollection coll = fi.getFilter().getFilterItems();
                    for (int k = 0; k < coll.size(); ++k) {
                        FilterItemInfo info = coll.get(k);
                        if (!(info.getCompareValue() instanceof Timestamp)) continue;
                        Date date = new Date(((Timestamp)info.getCompareValue()).getTime());
                        info.setCompareValue((Object)date);
                    }
                    filterInfo = Utils.filteObjectValue((IObjectValue)billInfo, (EntityViewInfo)fi, (boolean)true);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            } else {
                filterInfo = billInfo;
            }
            if (filterInfo == null) continue;
            oqlOrgUnit = rule.getOqlOrgUnit();
            oqlItemCombination = rule.getOqlItemCombination();
            aliasItemCombination = rule.getAliasItemCombination();
            oqlOqlCurrency = rule.getOqlCurrency();
            oqlOqlBizDate = rule.getOqlBizDate();
            oqlRequest = rule.getOqlRequest();
            oqlExtendExpr = rule.getOqlRequestExtendExpression();
            periodType = rule.getPeriodCycle();
            customBgPeriodNumber = rule.getCustomBgPeriodNumber();
            oqlRuleCondition = rule.getOqlRuleCondition();
            HashMap specialValMap = new HashMap();
            BudgetCtrlHelper.processSpecialValue(oqlOrgUnit, specialValMap);
            BudgetCtrlHelper.processItemCombinSpecialValue(oqlItemCombination, specialValMap);
            BudgetCtrlHelper.processSpecialValue(oqlOqlCurrency, specialValMap);
            BudgetCtrlHelper.processSpecialValue(oqlOqlBizDate, specialValMap);
            fields = BudgetCtrlHelper.getOQLFields(rule);
            fieldValues = Utils.objectValueToMap((IObjectValue)filterInfo, (String[])fields);
            BudgetCtrlHelper.filterSpecialValue(fieldValues, specialValMap);
            for (int j = 0; j < fieldValues.size(); ++j) {
                String mappedItemNumber;
                CostCenterOrgUnitInfo costCenter;
                BgCtrlParamInfo ctrlParamInfo = new BgCtrlParamInfo();
                ctrlParamInfo.setBillType(boAlias);
                ctrlParamInfo.put("BOName", BudgetCtrlHelper.getBOName(ctx, billInfo));
                fieldValueMap = (Map)fieldValues.get(j);
                obj = fieldValueMap.get(fields[0]);
                String string = value_orgUnit = obj != null ? obj.toString() : "";
                if (BudgetCtrlUtil.isEmpty(value_orgUnit) || (costCenter = BudgetCtrlCacheHelper.getCostCenter(ctx, value_orgUnit)) == null) continue;
                ctrlParamInfo.setOrgUnitId(costCenter.getId().toString());
                ctrlParamInfo.setOrgUnitName(costCenter.getName());
                ctrlParamInfo.setBillSourceOrgUnitId(costCenter.getId().toString());
                value_currency = (String)fieldValueMap.get(fields[1]);
                if (BudgetCtrlUtil.isEmpty(value_currency) || (currency = BudgetCtrlCacheHelper.getCurrency(ctx, value_currency)) == null) continue;
                ctrlParamInfo.setCurrencyId(currency.getId().toString());
                ctrlParamInfo.setCurrencyNumber(currency.getNumber());
                value_bizDate = (Date)fieldValueMap.get(fields[2]);
                if (value_bizDate == null) continue;
                ctrlParamInfo.setBizDate(value_bizDate);
                bgPeriodInfo = BudgetCtrlHelper.mappingBgPeriod(ctx, value_bizDate, ctrlScheme, periodType.getValue(), customBgPeriodNumber);
                if (bgPeriodInfo == null || bgPeriodInfo.getId() == null) continue;
                ctrlParamInfo.setPeriodId(bgPeriodInfo.getId().toString());
                ctrlParamInfo.setPeriodNumber(bgPeriodInfo.getNumber());
                ctrlParamInfo.setPeriodName(bgPeriodInfo.getName());
                ctrlParamInfo.setPeriodType(periodType);
                value_element = rule.getElementNumber();
                if ("com.kingdee.eas.ma.nbudget.app.BudgetRequestBill".equals(boName)) {
                    BudgetRequestBillInfo rBInfo = (BudgetRequestBillInfo)billInfo;
                    if (rBInfo.getBgEnties().get(j).getBgElement() == null) continue;
                    value_element = rBInfo.getBgEnties().get(j).getBgElement().getNumber();
                } else {
                    value_element = rule.getElementNumber();
                }
                if (BudgetCtrlUtil.isEmpty(value_element)) continue;
                ctrlParamInfo.setElementNumber(value_element);
                elementInfo = BudgetCtrlCacheHelper.getBgElement(ctx, value_element);
                ctrlParamInfo.setElementName(elementInfo.getName());
                value_request = (BigDecimal)fieldValueMap.get(fields[3]);
                if (value_request != null) {
                    value_request = BudgetCtrlHelper.calcuRequestAmount(value_request, oqlRequest, fieldValueMap, oqlExtendExpr);
                }
                ctrlParamInfo.setAmount(value_request);
                String[] oqlItemCombinationTemp = oqlItemCombination.split("\\@");
                String billItemNumber = "";
                String billItemName = "";
                String itemField = null;
                String nameField = null;
                String itemValue = null;
                String nameValue = null;
                String itemCombinationAndPropNumber = "";
                for (int k = 0; k < oqlItemCombinationTemp.length; ++k) {
                    String[] oqlItemCombinationTempSub = oqlItemCombinationTemp[k].split("\\|");
                    itemField = oqlItemCombinationTempSub[0];
                    nameField = BudgetCtrlHelper.generateNameFiled(itemField);
                    itemValue = fieldValueMap.get(itemField) == null ? "#" : (String)fieldValueMap.get(itemField);
                    String string2 = nameValue = fieldValueMap.get(nameField) == null ? "" : (String)fieldValueMap.get(nameField);
                    if (itemField.indexOf("entries.assistRecords.assGrp.generalAssActType") != -1 && itemField.indexOf("longNumber") != -1) {
                        billItemNumber = billItemNumber + itemValue.replaceAll("\\.", "\\!") + ",";
                        itemCombinationAndPropNumber = itemCombinationAndPropNumber + itemField + ":" + itemValue.replaceAll("\\.", "\\!") + "|";
                    } else {
                        billItemNumber = billItemNumber + itemValue + ",";
                        itemCombinationAndPropNumber = itemCombinationAndPropNumber + itemField + ":" + itemValue + "|";
                    }
                    billItemName = billItemName + nameValue + ",";
                }
                billItemNumber = BudgetCtrlUtil.replaceNULL(billItemNumber, "");
                billItemName = BudgetCtrlUtil.replaceNULL(billItemName, "");
                if (billItemNumber.lastIndexOf(",") != -1) {
                    billItemNumber = BudgetCtrlUtil.deleteStrTail(billItemNumber);
                }
                if (billItemName.lastIndexOf(",") != -1) {
                    billItemName = BudgetCtrlUtil.deleteStrTail(billItemName);
                }
                ctrlParamInfo.setBillItemNumber(billItemNumber);
                ctrlParamInfo.setBillItemName(billItemName);
                ctrlParamInfo.setBillItemAlias(aliasItemCombination);
                ctrlParamInfo.setBillItemOql(oqlItemCombination);
                if (itemCombinationAndPropNumber.lastIndexOf("|") != -1) {
                    itemCombinationAndPropNumber = BudgetCtrlUtil.deleteStrTail(itemCombinationAndPropNumber);
                }
                if ((mappedItemNumber = BudgetCtrlHelper.mappingBgItem(ctx, itemCombinationAndPropNumber, ctrlScheme, costCenter.getId().toString())) != null) {
                    ctrlParamInfo.setItemCombinNumber(mappedItemNumber);
                } else {
                    if (!StringUtils.isEmpty((String)oqlItemCombination) && !StringUtils.isEmpty((String)billItemNumber) && oqlItemCombination.indexOf("entries.assistRecords.assGrp.generalAssActType") != -1) {
                        billItemNumber = billItemNumber.replaceAll("\\!", "\\.");
                    }
                    ctrlParamInfo.setItemCombinNumber(billItemNumber);
                }
                ctrlParamInfo.setItemCombinName(billItemName);
                boNumber = BudgetCtrlUtil.replaceNULL(filterInfo.get("number"), (Object)"");
                ctrlParamInfo.setSrcBillNumber(boNumber);
                bgSchemeId = BudgetCtrlHelper.getActivedBgSchemeID(ctx, ctrlParamInfo, value_bizDate, billInfo);
                ctrlParamInfo.setBgSchemeId(bgSchemeId);
                BudgetCtrlHelper.mergeSameCtrlParam(ctrlParamInfo, ctrlParamCol, checkDumpParam);
            }
        }
        ctrlParamCol = BudgetCtrlHelper.processItemCombination(ctx, ctrlParamCol);
        checkDumpParam.clear();
        return ctrlParamCol;
    }

    private BgCtrlResultCollection requestSuperiorOrgBudget(Context ctx, BudgetCtrlState state, BgControlSchemeInfo ctrlScheme, BgCtrlParamCollection ctrlParamCol, BgCtrlResultCollection bgCtrlResultCol) throws BOSException, EASBizException {
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        if (ruleCol == null || ruleCol.isEmpty()) {
            return bgCtrlResultCol;
        }
        boolean isFindUpperOrg = ctrlScheme.isIsFindUpperOrg();
        if (!isFindUpperOrg) {
            return bgCtrlResultCol;
        }
        int maxLevel = ctrlScheme.getFindUpperOrgMaxLevel();
        if (maxLevel < 1) {
            return bgCtrlResultCol;
        }
        HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (ctrlParamCol.get(i).getOrgUnitId() == null) continue;
            orgUnitMap.put(ctrlParamCol.get(i).getOrgUnitId(), null);
        }
        Map orgUnitParentMap = BudgetCtrlHelper.getParentOrgUnitMap(ctx, orgUnitMap, isFindUpperOrg, maxLevel);
        this.recursionSuperiorOrg(ctx, state, ctrlParamCol, bgCtrlResultCol, orgUnitParentMap);
        return bgCtrlResultCol;
    }

    private void recursionSuperiorOrg(Context ctx, BudgetCtrlState state, BgCtrlParamCollection ctrlParamCol, BgCtrlResultCollection ctrlResultCol, Map orgUnitParentMap) throws BOSException, EASBizException {
        BgCtrlResultInfo ctrlResultInfo;
        int i;
        BgCtrlParamCollection _ctrlParamCol = new BgCtrlParamCollection();
        BgCtrlResultCollection _ctrlResultCol = new BgCtrlResultCollection();
        for (i = ctrlResultCol.size() - 1; i >= 0; --i) {
            ctrlResultInfo = ctrlResultCol.get(i);
            if (ctrlResultInfo.getBgDataId() != null) continue;
            BgCtrlParamInfo newCtrlParamInfo = (BgCtrlParamInfo)ctrlParamCol.get(i).clone();
            newCtrlParamInfo.setBillSourceOrgUnitId(ctrlResultInfo.getBillSourceOrgunitID());
            if (!orgUnitParentMap.containsKey(newCtrlParamInfo.getOrgUnitId())) continue;
            CostCenterOrgUnitInfo parentOrg = (CostCenterOrgUnitInfo)orgUnitParentMap.get(newCtrlParamInfo.getOrgUnitId());
            String newCCID = parentOrg.getId().toString();
            String newCCName = parentOrg.getName();
            newCtrlParamInfo.setOrgUnitId(newCCID);
            newCtrlParamInfo.setOrgUnitName(newCCName);
            String activeBgSchemeId = BudgetCtrlHelper.getActivedBgSchemeID(ctx, newCtrlParamInfo, newCtrlParamInfo.getBizDate());
            newCtrlParamInfo.setBgSchemeId(activeBgSchemeId);
            newCtrlParamInfo.put("index", new Integer(i));
            _ctrlParamCol.add(newCtrlParamInfo);
        }
        if (_ctrlParamCol != null && _ctrlParamCol.size() > 0) {
            _ctrlResultCol = this.getBgCtrlResultCol(ctx, state, _ctrlParamCol, new BgCtrlResultCollection());
            for (i = 0; _ctrlResultCol != null && !_ctrlResultCol.isEmpty() && i < _ctrlResultCol.size(); ++i) {
                ctrlResultInfo = _ctrlResultCol.get(i);
                if (ctrlResultInfo.getBgDataId() != null) {
                    if (_ctrlParamCol.get(i) == null) {
                        ctrlResultCol.add((BgCtrlResultInfo)ctrlResultInfo.clone());
                    } else {
                        ctrlResultCol.set((Integer)_ctrlParamCol.get(i).get("index"), (BgCtrlResultInfo)ctrlResultInfo.clone());
                    }
                }
                if (_ctrlParamCol.get(i) == null) continue;
                ctrlParamCol.set((Integer)_ctrlParamCol.get(i).get("index"), (BgCtrlParamInfo)_ctrlParamCol.get(i).clone());
            }
            for (i = ctrlResultCol.size() - 1; i >= 0; --i) {
                if (ctrlResultCol.get(i).getBgDataId() != null) continue;
                this.recursionSuperiorOrg(ctx, state, ctrlParamCol, ctrlResultCol, orgUnitParentMap);
                break;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectCtrlDataImmediately(Context ctx, BudgetCtrlState state, BgCtrlResultCollection ctrlResultCol) throws EASBizException, BOSException {
        PreparedStatement deleteCtrlRecordSta;
        PreparedStatement updateCtrlRecordSta;
        PreparedStatement insertCtrlRecordSta;
        PreparedStatement updateBgDataSta;
        IRowSet rst;
        Connection conn;
        HashMap org2parentOrgSchemeMap;
        block25: {
            if (ctrlResultCol == null || ctrlResultCol.isEmpty()) {
                return;
            }
            HashSet<String> orgIdSet = new HashSet<String>();
            HashSet<String> billIdSet = new HashSet<String>();
            HashMap<String, String> orgId2schemeIdMap = new HashMap<String, String>();
            for (int i = 0; i < ctrlResultCol.size(); ++i) {
                BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
                if (!BudgetCtrlHelper.isCanCollect(ctrlResultInfo)) continue;
                String orgUnitId = ctrlResultInfo.getOrgUnitId();
                String bgSchemeId = ctrlResultInfo.getBgSchemeId();
                String billId = ctrlResultInfo.getBillId();
                orgId2schemeIdMap.put(orgUnitId, bgSchemeId);
                orgIdSet.add(orgUnitId);
                billIdSet.add(billId);
            }
            if (BudgetCtrlUtil.isEmpty(orgIdSet) || BudgetCtrlUtil.isEmpty(orgId2schemeIdMap)) {
                orgIdSet.clear();
                orgId2schemeIdMap.clear();
                return;
            }
            Map orgId2parentOrgMap = BudgetCtrlHelper.getAllParentOrgMap(ctx, orgIdSet);
            if (BudgetCtrlUtil.isEmpty(orgId2parentOrgMap)) {
                return;
            }
            org2parentOrgSchemeMap = new HashMap();
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            String userId = user != null ? user.getId().toString() : "";
            java.sql.Date time = new java.sql.Date(System.currentTimeMillis());
            conn = null;
            rst = null;
            updateBgDataSta = null;
            insertCtrlRecordSta = null;
            updateCtrlRecordSta = null;
            deleteCtrlRecordSta = null;
            try {
                for (int i = 0; i < ctrlResultCol.size(); ++i) {
                    String parentOrgId;
                    List parents;
                    BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
                    if (!BudgetCtrlHelper.isCanCollect(ctrlResultInfo)) continue;
                    Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
                    boolean isRequestBudget = true;
                    if (obj instanceof Boolean) {
                        isRequestBudget = (Boolean)obj;
                    }
                    if (!isRequestBudget) continue;
                    String orgUnitId = ctrlResultInfo.getOrgUnitId();
                    String schemeId = (String)orgId2schemeIdMap.get(orgUnitId);
                    if (org2parentOrgSchemeMap.containsKey(orgUnitId) || BudgetCtrlUtil.isEmpty(parents = (List)orgId2parentOrgMap.get(orgUnitId))) continue;
                    StringBuffer parentOrgIds = new StringBuffer("(");
                    for (int j = 0; j < parents.size(); ++j) {
                        CostCenterOrgUnitInfo parent = (CostCenterOrgUnitInfo)parents.get(j);
                        parentOrgId = parent.getId().toString();
                        if (j == 0) {
                            parentOrgIds.append("'").append(parentOrgId).append("'");
                            continue;
                        }
                        parentOrgIds.append(",'").append(parentOrgId).append("'");
                    }
                    parentOrgIds.append(")");
                    StringBuffer kSQL = new StringBuffer();
                    kSQL.append(" select FOrgUnitId,");
                    kSQL.append("        FId");
                    kSQL.append("   from T_BG_BgScheme");
                    kSQL.append("  where FOrgUnitId in " + parentOrgIds.toString());
                    kSQL.append("    and frootid = (select FRootId from T_BG_BgScheme where FId = ?)");
                    kSQL.append("    and FId <> ?");
                    rst = DbUtil.executeQuery((Context)ctx, (String)kSQL.toString(), (Object[])new String[]{schemeId, schemeId});
                    HashMap<String, String> parentOrg2SchemeMap = new HashMap<String, String>();
                    while (rst.next()) {
                        parentOrgId = rst.getString("FOrgUnitId");
                        String parentSchemeId = rst.getString("FId");
                        parentOrg2SchemeMap.put(parentOrgId, parentSchemeId);
                    }
                    org2parentOrgSchemeMap.put(orgUnitId, parentOrg2SchemeMap);
                }
                conn = this.getConnection(ctx);
                StringBuffer updateBgDataSQL = new StringBuffer();
                updateBgDataSQL.append(" update T_BG_BgData ");
                updateBgDataSQL.append("    set FBizActual = FBizActual + ?");
                updateBgDataSQL.append("  where FOrgUnitId= ?");
                updateBgDataSQL.append("    and FBgSchemeId = ?");
                updateBgDataSQL.append("    and FFormula = ?");
                updateBgDataSta = conn.prepareStatement(updateBgDataSQL.toString());
                StringBuffer insertCtrlRecordSQL = new StringBuffer();
                insertCtrlRecordSQL.append(" insert into T_BG_BgCtrlRecord");
                insertCtrlRecordSQL.append("   (FId,");
                insertCtrlRecordSQL.append("    FCreatorId,");
                insertCtrlRecordSQL.append("    FCreateTime,");
                insertCtrlRecordSQL.append("    FLastUpdateUserId,");
                insertCtrlRecordSQL.append("    FLastUpdateTime,");
                insertCtrlRecordSQL.append("    FControlUnitId,");
                insertCtrlRecordSQL.append("    FBgDataId,");
                insertCtrlRecordSQL.append("    FBillId,");
                insertCtrlRecordSQL.append("    FBillName,");
                insertCtrlRecordSQL.append("    FBillNumber,");
                insertCtrlRecordSQL.append("    FBillAlias,");
                insertCtrlRecordSQL.append("    FBillType,");
                insertCtrlRecordSQL.append("    FBizDate,");
                insertCtrlRecordSQL.append("    FActualAmount,");
                insertCtrlRecordSQL.append("    FBillOperate,");
                insertCtrlRecordSQL.append("    FBgPeriodId,");
                insertCtrlRecordSQL.append("    FItemName,");
                insertCtrlRecordSQL.append("    FBgTraceType,");
                insertCtrlRecordSQL.append("    FOrgUnitId,");
                insertCtrlRecordSQL.append("    FBgSchemeId,");
                insertCtrlRecordSQL.append("    FItemFormula,");
                insertCtrlRecordSQL.append("    FPayState,");
                insertCtrlRecordSQL.append("    FISCollected,");
                insertCtrlRecordSQL.append("    FDayDate,");
                insertCtrlRecordSQL.append("    FActualType,");
                insertCtrlRecordSQL.append("    FBillSourceOrgunitID ) ");
                insertCtrlRecordSQL.append(" values (newbosid('FF6153C2'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                insertCtrlRecordSta = conn.prepareStatement(insertCtrlRecordSQL.toString());
                StringBuffer updateCtrlRecordSQL = new StringBuffer();
                updateCtrlRecordSQL.append(" update T_BG_BgCtrlRecord");
                updateCtrlRecordSQL.append("    set FBgDataId = (select FId");
                updateCtrlRecordSQL.append("                         from T_BG_BgData");
                updateCtrlRecordSQL.append("                        where FOrgUnitId = ?");
                updateCtrlRecordSQL.append("                          and FBgSchemeId = ?");
                updateCtrlRecordSQL.append("                          and FFormula = ?");
                updateCtrlRecordSQL.append("                        )");
                updateCtrlRecordSQL.append("  where FBillId = ?");
                updateCtrlRecordSQL.append("    and FOrgUnitId = ?");
                updateCtrlRecordSQL.append("    and FBgSchemeId = ?");
                updateCtrlRecordSQL.append("    and FItemFormula = ?");
                updateCtrlRecordSta = conn.prepareStatement(updateCtrlRecordSQL.toString());
                StringBuffer deleteKSQL = new StringBuffer();
                deleteKSQL.append(" delete T_BG_BgCtrlRecord where FBillId = ? and FBgDataId is null ");
                deleteCtrlRecordSta = conn.prepareStatement(deleteKSQL.toString());
                BgCtrlRecordCollection ctrlRecordCol = new BgCtrlRecordCollection();
                int batchCounter = 0;
                boolean isRunUpdate = false;
                for (int i2 = 0; i2 < ctrlResultCol.size(); ++i2) {
                    String orgUnitId;
                    Map parentOrg2SchemeMap;
                    BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i2);
                    if (!BudgetCtrlHelper.isCanCollect(ctrlResultInfo) || ctrlResultInfo.getReqAmount() != null && ctrlResultInfo.getReqAmount().compareTo(BgNConstants.ZERO) == 0) continue;
                    Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
                    boolean isRequestBudget = true;
                    if (obj instanceof Boolean) {
                        isRequestBudget = (Boolean)obj;
                    }
                    if (!isRequestBudget || BudgetCtrlUtil.isEmpty(parentOrg2SchemeMap = (Map)org2parentOrgSchemeMap.get(orgUnitId = ctrlResultInfo.getOrgUnitId()))) continue;
                    String formula = ctrlResultInfo.getBgItemFormula();
                    BigDecimal actualValue = ctrlResultInfo.getReqAmount();
                    Set leagalBgDataCol = this.isLeagalStateToRequestBudget(ctx, new HashSet(parentOrg2SchemeMap.keySet()), new HashSet(parentOrg2SchemeMap.values()), formula);
                    for (String orgId : parentOrg2SchemeMap.keySet()) {
                        String schemeId = (String)parentOrg2SchemeMap.get(orgId);
                        String key = orgId + "-" + schemeId + "-" + formula;
                        if (!leagalBgDataCol.contains(key)) continue;
                        updateBgDataSta.setBigDecimal(1, actualValue);
                        updateBgDataSta.setString(2, orgId);
                        updateBgDataSta.setString(3, schemeId);
                        updateBgDataSta.setString(4, formula);
                        updateBgDataSta.addBatch();
                        BgCtrlRecordInfo ctrlRecordInfo = new BgCtrlRecordInfo();
                        ctrlRecordInfo.setBgDataId(null);
                        ctrlRecordInfo.setBillId(ctrlResultInfo.getBillId());
                        ctrlRecordInfo.setBillNumber(ctrlResultInfo.getBillNumber());
                        ctrlRecordInfo.setBillName(ctrlResultInfo.getBillNumber());
                        ctrlRecordInfo.setBillAlias(ctrlResultInfo.getBillType());
                        ctrlRecordInfo.setBillType(BudgetCtrlHelper.getTypeAllias(ctrlResultInfo.getBillType(), BgTraceTypeEnum.SumFromLower));
                        ctrlRecordInfo.setBizDate(ctrlResultInfo.getBizDate());
                        ctrlRecordInfo.setActualAmount(ctrlResultInfo.getReqAmount());
                        ctrlRecordInfo.setItemName(ctrlResultInfo.getItemCombinName());
                        ctrlRecordInfo.setBgPeriodId(ctrlResultInfo.getBgPeriodNumber());
                        ctrlRecordInfo.setOrgUnitId(orgId);
                        ctrlRecordInfo.setBgSchemeId(schemeId);
                        ctrlRecordInfo.setItemFormula(formula);
                        ctrlRecordInfo.setBgTraceType(BgTraceTypeEnum.SumFromLower);
                        ctrlRecordInfo.setIsCollected(true);
                        ctrlRecordInfo.setActualType(ctrlResultInfo.getActualType());
                        ctrlRecordInfo.setBillSourceOrgunitID(ctrlResultInfo.getBillSourceOrgunitID());
                        ctrlRecordCol.add(ctrlRecordInfo);
                        insertCtrlRecordSta.setString(1, userId);
                        insertCtrlRecordSta.setDate(2, time);
                        insertCtrlRecordSta.setString(3, userId);
                        insertCtrlRecordSta.setDate(4, time);
                        insertCtrlRecordSta.setString(5, ctrlRecordInfo.getOrgUnitId());
                        insertCtrlRecordSta.setString(6, ctrlRecordInfo.getBgDataId());
                        insertCtrlRecordSta.setString(7, ctrlRecordInfo.getBillId());
                        insertCtrlRecordSta.setString(8, ctrlRecordInfo.getBillName());
                        insertCtrlRecordSta.setString(9, ctrlRecordInfo.getBillNumber());
                        insertCtrlRecordSta.setString(10, ctrlRecordInfo.getBillAlias());
                        insertCtrlRecordSta.setString(11, ctrlRecordInfo.getBillType());
                        insertCtrlRecordSta.setDate(12, ctrlRecordInfo.getBizDate() != null ? new java.sql.Date(ctrlRecordInfo.getBizDate().getTime()) : null);
                        insertCtrlRecordSta.setBigDecimal(13, ctrlRecordInfo.getActualAmount());
                        insertCtrlRecordSta.setString(14, ctrlRecordInfo.getBillOperate());
                        insertCtrlRecordSta.setString(15, ctrlRecordInfo.getBgPeriodId());
                        insertCtrlRecordSta.setString(16, ctrlRecordInfo.getItemName());
                        insertCtrlRecordSta.setInt(17, ctrlRecordInfo.getBgTraceType().getValue());
                        insertCtrlRecordSta.setString(18, ctrlRecordInfo.getOrgUnitId());
                        insertCtrlRecordSta.setString(19, ctrlRecordInfo.getBgSchemeId());
                        insertCtrlRecordSta.setString(20, ctrlRecordInfo.getItemFormula());
                        insertCtrlRecordSta.setInt(21, 0);
                        insertCtrlRecordSta.setInt(22, ctrlRecordInfo.isIsCollected() ? 1 : 0);
                        insertCtrlRecordSta.setDate(23, ctrlRecordInfo.getBizDate() != null ? new java.sql.Date(ctrlRecordInfo.getBizDate().getTime()) : null);
                        if (BudgetCtrlState.isOccupation(state)) {
                            insertCtrlRecordSta.setInt(24, 10);
                        } else if (ctrlRecordInfo.getActualType() != null) {
                            insertCtrlRecordSta.setInt(24, ctrlRecordInfo.getActualType().getValue());
                        } else {
                            insertCtrlRecordSta.setInt(24, 20);
                        }
                        insertCtrlRecordSta.setString(25, ctrlRecordInfo.getBillSourceOrgunitID());
                        insertCtrlRecordSta.addBatch();
                        updateCtrlRecordSta.setString(1, orgId);
                        updateCtrlRecordSta.setString(2, schemeId);
                        updateCtrlRecordSta.setString(3, formula);
                        updateCtrlRecordSta.setString(4, ctrlResultInfo.getBillId());
                        updateCtrlRecordSta.setString(5, orgId);
                        updateCtrlRecordSta.setString(6, schemeId);
                        updateCtrlRecordSta.setString(7, formula);
                        updateCtrlRecordSta.addBatch();
                        if (!isRunUpdate) {
                            isRunUpdate = true;
                        }
                        if (++batchCounter < 200) continue;
                        updateBgDataSta.executeBatch();
                        insertCtrlRecordSta.executeBatch();
                        updateCtrlRecordSta.executeBatch();
                        batchCounter = 0;
                    }
                }
                if (!isRunUpdate) break block25;
                if (batchCounter != 0) {
                    updateBgDataSta.executeBatch();
                    insertCtrlRecordSta.executeBatch();
                    updateCtrlRecordSta.executeBatch();
                }
                batchCounter = 0;
                for (String billId : billIdSet) {
                    deleteCtrlRecordSta.setString(1, billId);
                    deleteCtrlRecordSta.addBatch();
                    if (++batchCounter < 200) continue;
                    deleteCtrlRecordSta.executeBatch();
                    batchCounter = 0;
                }
                if (batchCounter != 0) {
                    deleteCtrlRecordSta.executeBatch();
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, ex);
                    catch (Exception ex2) {
                        logger.error((Object)ex2.getMessage());
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    SQLUtils.cleanup(updateBgDataSta);
                    SQLUtils.cleanup(insertCtrlRecordSta);
                    SQLUtils.cleanup(updateCtrlRecordSta);
                    SQLUtils.cleanup(deleteCtrlRecordSta);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Statement)updateBgDataSta);
        SQLUtils.cleanup((Statement)insertCtrlRecordSta);
        SQLUtils.cleanup((Statement)updateCtrlRecordSta);
        SQLUtils.cleanup((Statement)deleteCtrlRecordSta);
        SQLUtils.cleanup((Connection)conn);
        this.updateUpperOrgUpperItemCtrlData(ctx, state, ctrlResultCol, org2parentOrgSchemeMap);
    }

    private Set isLeagalStateToRequestBudget(Context ctx, Set parentOrgIds, Set parentSchemeIds, String formula) throws BOSException {
        HashSet<String> res = new HashSet<String>();
        if (parentOrgIds == null || parentOrgIds.isEmpty()) {
            return res;
        }
        if (parentSchemeIds == null || parentSchemeIds.isEmpty()) {
            return res;
        }
        if (formula == null) {
            return res;
        }
        IBgData iBgData = BgDataFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)parentOrgIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)parentSchemeIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("formula", (Object)formula, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dataState", (Object)9, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("orgUnit.id");
        sic.add("bgScheme.id");
        sic.add("formula");
        CoreBaseCollection col = iBgData.getCollection(view);
        if (col != null) {
            BgDataInfo data = null;
            String key = null;
            for (int i = 0; i < col.size(); ++i) {
                data = (BgDataInfo)col.get(i);
                key = data.getOrgUnit().getId().toString() + "-" + data.getBgScheme().getId().toString() + "-" + data.getFormula();
                if (res.contains(key)) continue;
                res.add(key);
            }
        }
        return res;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateNeverAudit(Context ctx, String billId) throws EASBizException, BOSException {
        ResultSet rst;
        PreparedStatement pstup;
        PreparedStatement pstmt;
        Connection conn;
        block15: {
            StringBuffer upSQL;
            ArrayList<String> bgDataIds;
            block14: {
                conn = null;
                pstmt = null;
                pstup = null;
                rst = null;
                bgDataIds = new ArrayList<String>();
                StringBuffer kSQL = new StringBuffer();
                String sql = "select fbgdataid from T_BG_BgCtrlRecord where FBillId = ?";
                String[] dataids = null;
                IRowSet rs = null;
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
                    dataids = new String[rs.size()];
                    int index = 0;
                    while (rs.next()) {
                        dataids[index] = rs.getString("fbgdataid");
                        ++index;
                    }
                }
                catch (Exception e) {
                    SQLUtils.cleanup(rs);
                }
                if (dataids == null) return;
                if (dataids.length == 0) {
                    return;
                }
                kSQL.append(" select fid ");
                kSQL.append(" from T_BG_BgData ");
                kSQL.append(" where fdatastate <> 9 ");
                kSQL.append(" and fid in (");
                for (int i = 0; i < dataids.length; ++i) {
                    if (i == 0) {
                        kSQL.append("'").append(dataids[i]).append("'");
                        continue;
                    }
                    kSQL.append(",").append("'").append(dataids[i]).append("'");
                }
                kSQL.append(")");
                upSQL = new StringBuffer();
                upSQL.append(" update T_BG_BgCtrlRecord set FBgDataId = null ");
                upSQL.append("  where FBillId = ? ");
                upSQL.append("  and FBgDataId = ? ");
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(kSQL.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgDataIds.add(rst.getString("fid"));
                }
                if (!bgDataIds.isEmpty()) break block14;
                SQLUtils.cleanup((ResultSet)rst);
                SQLUtils.cleanup((Statement)pstmt);
                SQLUtils.cleanup(pstup);
                SQLUtils.cleanup((Connection)conn);
                return;
            }
            try {
                int index = 0;
                int batchSize = 100;
                pstup = conn.prepareStatement(upSQL.toString());
                int jn = bgDataIds.size();
                for (int j = 0; j < jn; ++j) {
                    pstup.setString(1, billId);
                    pstup.setString(2, (String)bgDataIds.get(j));
                    pstup.addBatch();
                    if (++index <= batchSize) continue;
                    pstup.executeBatch();
                    index = 0;
                }
                if (index == 0) break block15;
                pstup.executeBatch();
                index = 0;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, ex);
                    catch (Exception ex2) {
                        logger.error((Object)ex2.getMessage());
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    SQLUtils.cleanup(pstmt);
                    SQLUtils.cleanup(pstup);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)pstup);
        SQLUtils.cleanup((Connection)conn);
        return;
    }

    private void updateUpperOrgUpperItemCtrlData(Context ctx, BudgetCtrlState state, BgCtrlResultCollection ctrlResultCol, Map org2parentOrgSchemeMap) throws BOSException, EASBizException {
        if (ctrlResultCol == null || ctrlResultCol.size() == 0) {
            return;
        }
        IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            if (!BudgetCtrlHelper.isCanCollect(ctrlResultInfo)) continue;
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (!isRequestBudget) continue;
            BigDecimal actualValue = ctrlResultInfo.getReqAmount();
            String formula = ctrlResultInfo.getBgItemFormula();
            String orgUnitId = ctrlResultInfo.getOrgUnitId();
            Map parentOrg2SchemeMap = (Map)org2parentOrgSchemeMap.get(orgUnitId);
            if (BudgetCtrlUtil.isEmpty(parentOrg2SchemeMap)) continue;
            Set leagalBgDataCol = this.isLeagalStateToRequestBudget(ctx, new HashSet(parentOrg2SchemeMap.keySet()), new HashSet(parentOrg2SchemeMap.values()), formula);
            for (String orgId : parentOrg2SchemeMap.keySet()) {
                String schemeId = (String)parentOrg2SchemeMap.get(orgId);
                String key = orgId + "-" + schemeId + "-" + formula;
                iBgItem.updateBgItemSuperiorValue(BOSUuid.read((String)orgId), BOSUuid.read((String)schemeId), formula, actualValue);
                iBgItem.updateBgItemSuperiorCtrlRecord(BOSUuid.read((String)orgId), BOSUuid.read((String)schemeId), formula, ctrlResultInfo, state == null ? null : state.getCategory());
            }
        }
    }

    @Override
    protected synchronized void _collectCtrlData(Context ctx) throws BOSException, EASBizException {
        boolean isNeededUpgradeCtrlRecord = BudgetCtrlHelper.isNeededUpgradeCtrlRecord(ctx);
        if (isNeededUpgradeCtrlRecord) {
            this._upgradeCtrlDataToEAS600(ctx);
        }
        List billIds = this.getNeedCollectBillIds(ctx);
        BgCtrlResultCollection ctrlResultCol = this.getCtrlResultCol(ctx, billIds, "FBillID", false);
        this.setCtrlResultOtherInfo(ctx, ctrlResultCol);
        this.collectCtrlResultCol(ctx, ctrlResultCol);
    }

    @Override
    protected BgCtrlResultCollection _getBudget(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        String boName = BudgetCtrlHelper.getBOName(ctx, billInfo);
        if (billInfo instanceof LCMConsumeBillInfo && "com.kingdee.eas.fi.lcm.app.LCMConsumeBill".equals(boName)) {
            LCMConsumeBillInfo _billInfo = (LCMConsumeBillInfo)((LCMConsumeBillInfo)billInfo).clone();
            _billInfo.remove("id");
            _billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            _billInfo.setFiVouchered(false);
            for (int i = 0; i < _billInfo.getEntry().size(); ++i) {
                _billInfo.getEntry().get(i).remove("id");
            }
            ILCMConsumeBill iBill = LCMConsumeBillFactory.getLocalInstance((Context)ctx);
            IObjectPK pk = iBill.addnew((CoreBaseInfo)_billInfo);
            IBudgetCtrlFacade iCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
            BgCtrlResultCollection ctrlResultCol = iCtrl.getBudget(pk.toString());
            iBill.delete(pk);
            return ctrlResultCol;
        }
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        String OUID = BudgetCtrlHelper.getBillOUID(ctx, boName, billInfo);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID);
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return ctrlResultCol;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, billInfo, boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        ctrlResultCol = this.getBgCtrlResultCol(ctx, state, ctrlParamCol, ctrlResultCol);
        if (!BudgetCtrlHelper.hasScheme(ctx, boName, billInfo)) {
            ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        }
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        BudgetCtrlHelper.processCurrencyPrecision(ctx, ctrlParamCol, ctrlResultCol);
        for (int i = ctrlResultCol.size() - 1; i >= 0; --i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            ctrlResultInfo.setSchemeAllowAccess(ctrlScheme.isIsAllowExcess());
            ctrlResultInfo.setCanControlWithoutBudget(ctrlScheme.isIsCanControlWithoutBudget());
            if (ctrlResultInfo.getBgDataId() == null || !StringUtils.isEmpty((String)ctrlResultInfo.getItemCombinName())) continue;
            String itemCombinName = BudgetCtrlCacheHelper.getBgItemCombinationName(ctx, ctrlResultInfo.getItemCombinNumber(), ctrlResultInfo.getOrgUnitId());
            ctrlResultInfo.setItemCombinName(itemCombinName);
        }
        return ctrlResultCol;
    }

    @Override
    protected BgCtrlResultCollection _getBudget(Context ctx, String boId) throws BOSException, EASBizException {
        String OUID;
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        String boName = BudgetCtrlHelper.getBOName(ctx, boId);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID = BudgetCtrlHelper.getBillOUID(ctx, boId.toString(), boName));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return ctrlResultCol;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, boId.toString(), boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        ctrlResultCol = this.getBgCtrlResultCol(ctx, state, ctrlParamCol, ctrlResultCol);
        if (!BudgetCtrlHelper.hasScheme(ctx, boName, BOSUuid.read((String)boId))) {
            ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        }
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        BudgetCtrlHelper.processCurrencyPrecision(ctx, ctrlParamCol, ctrlResultCol);
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            ctrlResultInfo.setSchemeAllowAccess(ctrlScheme.isIsAllowExcess());
            ctrlResultInfo.setCanControlWithoutBudget(ctrlScheme.isIsCanControlWithoutBudget());
        }
        return ctrlResultCol;
    }

    @Override
    protected void _returnBudget(Context ctx, BOSUuid boId) throws BOSException, EASBizException {
        this.cancelRequestBudget(ctx, boId);
    }

    @Override
    protected void _returnBudgetLocal(Context ctx, BOSUuid boId) throws BOSException, EASBizException {
        this.cancelRequestBudget(ctx, boId);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancelRequestBudget(Context ctx, BOSUuid boId) throws BOSException, EASBizException {
        BigDecimal reqAmount;
        ResultSet rst;
        PreparedStatement statement;
        Connection conn;
        ArrayList<String> costCenterIds;
        HashMap<String, BigDecimal> bgDataMap;
        StringBuffer deleteCtrlRecord;
        StringBuffer updateBgData;
        String billId;
        block18: {
            if (boId == null) return;
            if (boId.toString().length() == 0) {
                return;
            }
            billId = boId.toString();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select distinct FBgDataId from T_BG_BgCtrlRecord where FBillId = ?", (Object[])new String[]{billId});
            HashSet<String> bgDataIds = new HashSet<String>();
            try {
                while (rowSet.next()) {
                    bgDataIds.add(rowSet.getString("FBgDataId"));
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, ex);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rowSet);
            }
            if (bgDataIds.isEmpty()) {
                return;
            }
            StringBuffer queryCtrlRecord = new StringBuffer(512);
            queryCtrlRecord.append(" select cr.FBgDataId,");
            queryCtrlRecord.append("        cr.FActualAmount,");
            queryCtrlRecord.append("        cc.Fid");
            queryCtrlRecord.append("   from T_BG_BgCtrlRecord cr,");
            queryCtrlRecord.append("        T_BG_BgData d,");
            queryCtrlRecord.append("        T_ORG_CostCenter cc");
            queryCtrlRecord.append("  where cr.FBgDataId = d.FId");
            queryCtrlRecord.append("    and d.FOrgUnitId = cc.FId");
            queryCtrlRecord.append("    and cr.FBillId = ?");
            queryCtrlRecord.append("    and d.FId in " + BgHelper.tranSet2String(bgDataIds));
            queryCtrlRecord.append("  order by cc.FLongNumber desc");
            updateBgData = new StringBuffer(512);
            updateBgData.append(" update T_BG_BgData");
            updateBgData.append("    set FBizActual = FBizActual - ?");
            updateBgData.append("  where FId = ?");
            deleteCtrlRecord = new StringBuffer(512);
            deleteCtrlRecord.append(" delete T_Bg_BgCtrlRecord");
            deleteCtrlRecord.append("  where FBillId = ?");
            BudgetCtrlLogger.logReturnBudget(ctx, null, billId);
            bgDataMap = new HashMap<String, BigDecimal>();
            costCenterIds = new ArrayList<String>();
            conn = null;
            statement = null;
            rst = null;
            conn = this.getConnection(ctx);
            statement = conn.prepareStatement(queryCtrlRecord.toString());
            statement.setString(1, billId);
            rst = statement.executeQuery();
            while (rst.next()) {
                String ccid = rst.getString("Fid");
                String bgDataId = rst.getString("FBgDataId");
                reqAmount = rst.getBigDecimal("FActualAmount");
                costCenterIds.add(ccid);
                if (bgDataMap.containsKey(bgDataId)) {
                    BigDecimal val = (BigDecimal)bgDataMap.get(bgDataId);
                    bgDataMap.put(bgDataId, reqAmount.add(val));
                    continue;
                }
                bgDataMap.put(bgDataId, reqAmount);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)statement);
            if (!BudgetCtrlUtil.isEmpty(bgDataMap)) break block18;
            SQLUtils.cleanup((ResultSet)rst, (Statement)statement, (Connection)conn);
            return;
        }
        try {
            BudgetCtrlHelper.lockCostCenterTransaction(ctx, costCenterIds);
            statement = conn.prepareStatement(updateBgData.toString());
            for (String bgDataId : bgDataMap.keySet()) {
                reqAmount = (BigDecimal)bgDataMap.get(bgDataId);
                statement.setBigDecimal(1, reqAmount);
                statement.setString(2, bgDataId);
                statement.addBatch();
            }
            statement.executeBatch();
            SQLUtils.cleanup((ResultSet)rst, (Statement)statement);
            statement = conn.prepareStatement(deleteCtrlRecord.toString());
            statement.setString(1, billId);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)ex2.getMessage());
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)statement, (Connection)conn);
        return;
    }

    private Map getReturnBudget(Context ctx, String boId, String boName) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> returnDataMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> groupActualMap = new HashMap<String, BigDecimal>();
        HashMap groupDataIdMap = new HashMap();
        if (BudgetCtrlHelper.isCPBCBill(boName)) {
            return returnDataMap;
        }
        StringBuffer sql = new StringBuffer(512);
        sql.append(" select A.FBgDataId,");
        sql.append("        A.FActualAmount, B.FIsGroupCtrl, B.FGroupNo ");
        sql.append("   from T_Bg_BgCtrlRecord A inner join t_bg_bgdata B on A.fbgdataid=B.fid ");
        sql.append("   where A.FBillId = ?");
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{boId});
        try {
            HashSet<String> dataIdSet;
            String groupNo;
            while (rst.next()) {
                String bgDataId = rst.getString("FBgDataId");
                BigDecimal actualAmount = rst.getBigDecimal("FActualAmount");
                if (rst.getInt("FIsGroupCtrl") == 1) {
                    groupNo = rst.getString("FGroupNo");
                    if (groupActualMap.containsKey(groupNo) && groupActualMap.get(groupNo) instanceof BigDecimal) {
                        BigDecimal _sumAmt = (BigDecimal)groupActualMap.get(groupNo);
                        groupActualMap.put(groupNo, _sumAmt.add(actualAmount));
                        HashSet dataIdSet2 = (HashSet)groupDataIdMap.get(groupNo);
                        dataIdSet2.add(bgDataId);
                        continue;
                    }
                    groupActualMap.put(groupNo, actualAmount);
                    dataIdSet = new HashSet<String>();
                    dataIdSet.add(bgDataId);
                    groupDataIdMap.put(groupNo, dataIdSet);
                    continue;
                }
                if (actualAmount == null) {
                    actualAmount = BudgetCtrlConstants.ZERO_AMOUNT;
                }
                if (returnDataMap.containsKey(bgDataId)) {
                    BigDecimal val = (BigDecimal)returnDataMap.get(bgDataId);
                    returnDataMap.put(bgDataId, actualAmount.add(val));
                    continue;
                }
                returnDataMap.put(bgDataId, actualAmount);
            }
            if (groupDataIdMap.size() > 0) {
                for (Map.Entry entry : groupDataIdMap.entrySet()) {
                    groupNo = (String)entry.getKey();
                    dataIdSet = (HashSet<String>)entry.getValue();
                    Iterator it = dataIdSet.iterator();
                    while (it.hasNext()) {
                        returnDataMap.put((String)it.next(), (BigDecimal)groupActualMap.get(groupNo));
                    }
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage());
            throw new BgException(BgException.DATABASEERROR, ex);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return returnDataMap;
    }

    private BgCtrlResultCollection mergeReturnBudget(Context ctx, BgCtrlResultCollection ctrlResultCol, Map returnData) throws BOSException, EASBizException {
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol) || BudgetCtrlUtil.isEmpty(returnData)) {
            return ctrlResultCol;
        }
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal balance = ctrlResultInfo.getBalance();
            if (bgDataId == null || balance == null || !returnData.containsKey(bgDataId)) continue;
            BigDecimal returnVal = (BigDecimal)returnData.get(bgDataId);
            ctrlResultInfo.setBalance(balance.add(returnVal));
        }
        return ctrlResultCol;
    }

    @Override
    protected boolean _checkBudget(Context ctx, IObjectValue billInfo) throws BOSException, BgCtrlException, EASBizException {
        return this.returnCheckBudget(ctx, billInfo);
    }

    @Override
    protected boolean _checkBudgetLocal(Context ctx, IObjectValue billInfo) throws BOSException, BgCtrlException, EASBizException {
        return this.returnCheckBudget(ctx, billInfo);
    }

    private boolean returnCheckBudget(Context ctx, IObjectValue billInfo) throws BOSException, BgCtrlException, EASBizException {
        Map returnDataMap;
        String OUID;
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        String boName = BudgetCtrlHelper.getBOName(ctx, billInfo);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID = BudgetCtrlHelper.getBillOUID(ctx, boName, billInfo));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return true;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, billInfo, boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        BgCtrlResultCollection ctrlResultCol = this.getBudget(ctx, billInfo);
        if ("com.kingdee.eas.fi.gl.app.Voucher".equals(boName) && billInfo.get("id") != null && (returnDataMap = this.getReturnBudget(ctx, ((BOSUuid)billInfo.get("id")).toString(), boName)) != null && !returnDataMap.isEmpty() && ctrlResultCol != null && !ctrlResultCol.isEmpty()) {
            BgCtrlResultInfo ctrlResultInfo = null;
            String bgDataId = null;
            BigDecimal actualAmount = null;
            for (int i = 0; i < ctrlResultCol.size(); ++i) {
                ctrlResultInfo = ctrlResultCol.get(i);
                bgDataId = ctrlResultInfo.getBgDataId();
                if (!returnDataMap.containsKey(bgDataId)) continue;
                actualAmount = (BigDecimal)returnDataMap.get(bgDataId);
                ctrlResultInfo.setBizActual(ctrlResultInfo.getBizActual().add(actualAmount.multiply(BudgetCtrlConstants.NEG_ONE_AMOUNT)));
                ctrlResultInfo.setBalance(ctrlResultInfo.getBalance().add(actualAmount));
            }
        }
        return BudgetCtrlHelper.checkBudget(ctx, state, ctrlResultCol, ctrlParamCol, ctrlScheme);
    }

    @Override
    protected void _checkBillInfo(Context ctx, IObjectValue billInfo) throws BOSException, BgCtrlException, EASBizException {
        String OUID;
        String boName = BudgetCtrlHelper.getBOName(ctx, billInfo);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID = BudgetCtrlHelper.getBillOUID(ctx, boName, billInfo));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return;
        }
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)billInfo.getBOSType());
        Map allNeededFields = BudgetCtrlHelper.getBgCtrlNeededFields(ctx, entity, ctrlScheme.getRules());
        this.checkBizUnitInfo(ctx, ctrlScheme, billInfo);
    }

    @Override
    protected void _checkBillInfo(Context ctx, String billId) throws BOSException, BgCtrlException, EASBizException {
        String OUID;
        String boName = BudgetCtrlHelper.getBOName(ctx, billId);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID = BudgetCtrlHelper.getBillOUID(ctx, billId, boName));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return;
        }
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
        Map allNeededFields = BudgetCtrlHelper.getBgCtrlNeededFields(ctx, entity, ctrlScheme.getRules());
        IObjectValue billInfo = this.getBillInfo(ctx, billId, allNeededFields);
        this.checkBizUnitInfo(ctx, ctrlScheme, billInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectValue getBillInfo(Context ctx, String billId, Map allNeededFields) throws BOSException, BgCtrlException, EASBizException {
        if (StringUtils.isEmpty((String)billId) || allNeededFields == null || allNeededFields.isEmpty()) {
            return null;
        }
        IObjectValue value = null;
        Connection conn = null;
        ObjectStringPK pk = new ObjectStringPK(billId);
        try {
            conn = this.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)BOSUuid.getBOSObjectType((String)billId, (boolean)false), (Context)ctx, (Connection)conn);
            if (dao.exists((IObjectPK)pk)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("number");
                Object field2 = null;
                for (Object field2 : allNeededFields.keySet()) {
                    if (!(field2 instanceof String)) continue;
                    sic.add((String)field2);
                }
                value = dao.getValue((IObjectPK)pk, sic);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return value;
    }

    private void checkBizUnitInfo(Context ctx, BgControlSchemeInfo controlScheme, IObjectValue model) throws EASBizException {
        if (controlScheme == null || model == null) {
            return;
        }
        IObjectValue filter = null;
        BgControlRuleInfo rule = null;
        String proptxt = null;
        String[] tmpStrs = null;
        String[] tmpAlias = null;
        Vector<String> props = new Vector<String>();
        Vector<String> propAlias = new Vector<String>();
        HashSet<String> checkProps = new HashSet<String>();
        ArrayList checkPropAlias = new ArrayList();
        int in = controlScheme.getRules().size();
        for (int i = 0; i < in; ++i) {
            List values;
            rule = controlScheme.getRules().get(i);
            if (!StringUtils.isEmpty((String)rule.getOqlRuleCondition())) {
                try {
                    filter = Utils.filteObjectValue((IObjectValue)model, (String)("where " + rule.getOqlRuleCondition()), (boolean)true);
                }
                catch (BOSException ex) {
                    logger.error((Object)"filter ObjectValue Error:", (Throwable)ex);
                }
            } else {
                filter = model;
            }
            if (filter == null) continue;
            props.clear();
            propAlias.clear();
            if (!model.getClass().getName().equals("com.kingdee.eas.fm.nt.EndorsementBillInfo")) {
                props.add("number");
            }
            propAlias.addAll(props);
            if (rule.getOqlOrgUnit().indexOf("|") > 0) {
                props.add(rule.getOqlOrgUnit().split("\\|")[0]);
                propAlias.add(rule.getAliasOrgUnit().split("\\|")[0]);
            } else {
                props.add(rule.getOqlOrgUnit());
                propAlias.add(rule.getAliasOrgUnit());
            }
            String[] dims = rule.getOqlItemCombination().split("\\@");
            String[] dimAlias = rule.getAliasItemCombination().split("\\@");
            int jn = dims.length;
            for (int j = 0; j < jn; ++j) {
                tmpStrs = dims[j].split("\\|");
                tmpAlias = dimAlias[j].split("\\|");
                props.add(tmpStrs[0]);
                propAlias.add(tmpAlias[0]);
            }
            props.add(rule.getOqlCurrency());
            propAlias.add(rule.getAliasCurrency());
            props.add(rule.getOqlBizDate());
            propAlias.add(rule.getAliasBizDate());
            props.add(rule.getOqlRequest().split("\\|")[0]);
            propAlias.add(rule.getAliasRequest());
            if (!StringUtils.isEmpty((String)rule.getOqlRequestExtendExpression())) {
                String[] exts = rule.getOqlRequestExtendExpression().split(",");
                for (int e = 0; e < exts.length; ++e) {
                    props.add(exts[e]);
                    propAlias.add("RequestExpression");
                }
            }
            if ((values = Utils.objectValueToMap((IObjectValue)filter, (String[])props.toArray(new String[props.size()]))) == null) continue;
            Map valueMap = null;
            int jn2 = values.size();
            for (int j = 0; j < jn2; ++j) {
                valueMap = (Map)values.get(j);
                if (valueMap == null) continue;
                int xn = props.size();
                for (int x = 0; x < xn; ++x) {
                    proptxt = (String)props.get(x);
                    if (valueMap.get(proptxt) != null || checkProps.contains(proptxt)) continue;
                    checkProps.add(proptxt);
                    checkPropAlias.add(propAlias.get(x));
                }
            }
        }
        if (!checkPropAlias.isEmpty()) {
            StringBuffer str = new StringBuffer();
            int in2 = checkPropAlias.size();
            for (int i = 0; i < in2; ++i) {
                str.append((String)checkPropAlias.get(i) + ",");
            }
            str = str.delete(str.length() - 1, str.length());
            throw new BgCtrlException(BgCtrlException.MUSTINPUT, new String[]{str.toString()});
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected BgAvlBalDetailInfo _processBalDetailView(Context ctx, String bgDataId, boolean isCtrl, BgGetPeriodTypeForGetBlanceEnum balTypeEnum) throws BOSException, EASBizException {
        if (bgDataId == null) {
            return null;
        }
        BgAvlBalDetailInfo detailInfo = new BgAvlBalDetailInfo();
        HashMap calcuItems = new HashMap();
        detailInfo.setCalcuItems(calcuItems);
        BgDataInfo bgDataInfo = (BgDataInfo)BgDataFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bgDataId));
        String orgUnitId = bgDataInfo.getOrgUnit().getId().toString();
        String bgSchemeId = bgDataInfo.getBgScheme().getId().toString();
        String itemCombId = bgDataInfo.getBgItemCombinId();
        String bgPeriodId = bgDataInfo.getBgPeriod().getId().toString();
        String bgElementId = bgDataInfo.getBgElement().getId().toString();
        String currencyId = bgDataInfo.getCurrency().getId().toString();
        BgCtrlTypeEnum ctrlType = bgDataInfo.getCtrlType();
        if (ctrlType == null) {
            ctrlType = BgCtrlTypeEnum.NoCtrl;
        }
        boolean isFlexible = bgDataInfo.isIsFlexible();
        boolean isGroupCtrl = bgDataInfo.isIsGroupCtrl();
        String groupNo = isGroupCtrl ? bgDataInfo.getGroupNo() : null;
        detailInfo.setBgItemCombId(itemCombId);
        detailInfo.setCtrlType(ctrlType);
        detailInfo.setFlexible(isFlexible);
        detailInfo.setGroupCtrl(isGroupCtrl);
        detailInfo.setOrgUnitId(orgUnitId);
        List bgValPeriodIds = null;
        List actValPeriodIds = null;
        HashMap allPeriodMap = null;
        IRowSet rst = null;
        try {
            bgValPeriodIds = BgBalCalculator.getBgValPeriodIds(ctx, bgSchemeId, bgPeriodId, ctrlType, balTypeEnum);
            actValPeriodIds = BgBalCalculator.getActValPeriodIds(ctx, bgSchemeId, bgPeriodId, ctrlType, balTypeEnum);
            allPeriodMap = new HashMap();
            for (int i = 0; i < bgValPeriodIds.size(); ++i) {
                allPeriodMap.put(bgValPeriodIds.get(i), null);
            }
            for (int j = 0; j < actValPeriodIds.size(); ++j) {
                allPeriodMap.put(actValPeriodIds.get(j), null);
            }
            StringBuffer SQL = new StringBuffer(2048);
            SQL.append(" select d.FBgValue,");
            SQL.append("        d.FIsFlexible,");
            SQL.append("        d.FFlexParam,");
            SQL.append("        d.FBizActual,");
            SQL.append("        d.FId,");
            SQL.append("        d.FBgPeriodId,");
            SQL.append("        p.FNumber,");
            SQL.append("        p.FName_" + ctx.getLocale() + " as periodName,");
            SQL.append("        i.FKey");
            SQL.append("   from T_BG_BgData d,");
            SQL.append("        T_BG_BgForm f,");
            SQL.append("        T_BG_BgPeriod p,");
            SQL.append("        T_Bg_BgItemCombination i");
            SQL.append("  where d.FBgFormId = f.FId");
            SQL.append("    and d.FBgPeriodId = p.FId");
            SQL.append("    and d.FBgItemCombinId = i.FId");
            SQL.append("    and d.FOrgUnitId = ?");
            SQL.append("    and d.FBgSchemeId = ?");
            if (!isGroupCtrl) {
                SQL.append("    and d.FBgElementId = ?");
            }
            SQL.append("    and d.FCurrencyId = ?");
            SQL.append("    and d.FBgPeriodId in " + BgHelper.tranSet2String(allPeriodMap.keySet()));
            SQL.append("    and d.FDataState =9");
            if (!isGroupCtrl) {
                SQL.append("    and d.FBgItemCombinId = ?");
                SQL.append("    order by i.FKey asc, p.FNumber asc");
                rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString(), (Object[])new String[]{orgUnitId, bgSchemeId, bgElementId, currencyId, itemCombId});
            } else {
                SQL.append("    and d.FGroupNo = ?");
                SQL.append("    order by i.FKey asc, p.FNumber asc");
                rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString(), (Object[])new String[]{orgUnitId, bgSchemeId, currencyId, groupNo});
            }
            BigDecimal sumBgVal = BudgetCtrlConstants.ZERO_AMOUNT;
            BigDecimal sumBizActual = BudgetCtrlConstants.ZERO_AMOUNT;
            BigDecimal avlBalance = BudgetCtrlConstants.ZERO_AMOUNT;
            while (rst.next()) {
                String _periodId = rst.getString("FBgPeriodId");
                String _periodName = rst.getString("periodName");
                String _itemCombNumber = rst.getString("FKey");
                String _bgDataId = rst.getString("FId");
                List blockList = null;
                if (calcuItems.containsKey(_itemCombNumber)) {
                    blockList = (List)calcuItems.get(_itemCombNumber);
                } else {
                    blockList = new ArrayList();
                    calcuItems.put(_itemCombNumber, blockList);
                }
                ArrayList<Object> rowList = new ArrayList<Object>();
                rowList.add(_periodName);
                if (bgValPeriodIds.contains(_periodId)) {
                    BigDecimal _bgValue = rst.getBigDecimal("FBgValue");
                    BigDecimal _flexParam = rst.getBoolean("FIsFlexible") ? rst.getBigDecimal("FFlexParam") : BudgetCtrlConstants.ONE_AMOUNT;
                    sumBgVal = sumBgVal.add(_bgValue.multiply(_flexParam));
                    rowList.add(_bgValue);
                    rowList.add(_flexParam);
                } else {
                    rowList.add(null);
                    rowList.add(null);
                }
                if (actValPeriodIds.contains(_periodId)) {
                    BigDecimal _bizActual = rst.getBigDecimal("FBizActual");
                    sumBizActual = sumBizActual.add(_bizActual);
                    rowList.add(_bizActual);
                } else {
                    rowList.add(null);
                }
                if (bgDataId.equals(_bgDataId)) {
                    detailInfo.setBgItemCombNumber(_itemCombNumber);
                }
                blockList.add(rowList);
            }
            avlBalance = sumBgVal.subtract(sumBizActual);
            detailInfo.setAvlBal(avlBalance);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)ex2.getMessage());
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return detailInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _processActualDetailView(Context ctx, String bgDataId) throws BOSException, EASBizException {
        String currencyName;
        ArrayList<Object[]> bgDataIds;
        ResultSet ctrlRecordRst;
        Statement queryCtrlRecordSta;
        ResultSet bgDataRst;
        PreparedStatement queryBgDataSta;
        Connection conn;
        StringBuffer queryCtrlRecordKSql;
        Object[] actDetails;
        block9: {
            Object[] id;
            actDetails = new ArrayList();
            StringBuffer queryBgDataKSql = new StringBuffer();
            queryBgDataKSql.append(" select c.FName_" + ctx.getLocale() + " as currencyName,");
            queryBgDataKSql.append("        td.Fid as bgDataId");
            queryBgDataKSql.append("   from T_BG_BgData   cd,");
            queryBgDataKSql.append("        T_BG_BgData   td,");
            queryBgDataKSql.append("        T_BG_BgScheme s,");
            queryBgDataKSql.append("        T_BG_BgPeriod cp,");
            queryBgDataKSql.append("        T_BG_BgPeriod tp,");
            queryBgDataKSql.append("        T_BD_Currency c");
            queryBgDataKSql.append("  where cd.FCurrencyId = c.FId");
            queryBgDataKSql.append("    and cd.FOrgUnitId = td.FOrgUnitId");
            queryBgDataKSql.append("    and cd.FBgSchemeId = td.FBgSchemeId");
            queryBgDataKSql.append("    and cd.FBgItemCombinId = td.FBgItemCombinId");
            queryBgDataKSql.append("    and cd.FBgElementId = td.FBgElementId");
            queryBgDataKSql.append("    and cd.FCurrencyId = td.FCurrencyId");
            queryBgDataKSql.append("    and cd.FBgSchemeId = s.FId");
            queryBgDataKSql.append("    and cd.FBgPeriodId = cp.FId");
            queryBgDataKSql.append("    and td.FBgPeriodId = tp.FId");
            queryBgDataKSql.append("    and tp.FEndDate >= s.FdateFrom");
            queryBgDataKSql.append("    and tp.FBeginDate <= cp.FEndDate");
            queryBgDataKSql.append("    and cd.FId = ?");
            queryCtrlRecordKSql = new StringBuffer();
            queryCtrlRecordKSql.append(" select c.FBillId,");
            queryCtrlRecordKSql.append("        c.FBillNumber,");
            queryCtrlRecordKSql.append("        c.FBillType,");
            queryCtrlRecordKSql.append("        c.FBgTraceType,");
            queryCtrlRecordKSql.append("        c.FActualAmount,");
            queryCtrlRecordKSql.append("        c.FBizDate,");
            queryCtrlRecordKSql.append("        c.FCreateTime,");
            queryCtrlRecordKSql.append("        p.FNumber periodNum,");
            queryCtrlRecordKSql.append("        p.FName_" + ctx.getLocale() + " periodName");
            queryCtrlRecordKSql.append("   from T_BG_BgCtrlRecord c,");
            queryCtrlRecordKSql.append("        T_BG_BgPeriod p");
            queryCtrlRecordKSql.append("  where c.FBgPeriodId = p.FNumber");
            queryCtrlRecordKSql.append("    and ");
            for (int i = 0; i < 200; ++i) {
                if (i == 0) {
                    queryCtrlRecordKSql.append(" (c.FBgDataId = ? ");
                    continue;
                }
                queryCtrlRecordKSql.append(" or c.FBgDataId = ? ");
            }
            queryCtrlRecordKSql.append(" )");
            queryCtrlRecordKSql.append("   order by c.FBgPeriodId asc,c.FCreateTime desc,c.FBizDate desc");
            conn = null;
            queryBgDataSta = null;
            bgDataRst = null;
            queryCtrlRecordSta = null;
            ctrlRecordRst = null;
            conn = this.getConnection(ctx);
            queryBgDataSta = conn.prepareStatement(queryBgDataKSql.toString());
            queryBgDataSta.setString(1, bgDataId);
            bgDataRst = queryBgDataSta.executeQuery();
            bgDataIds = new ArrayList<Object[]>();
            currencyName = "";
            while (bgDataRst.next()) {
                currencyName = bgDataRst.getString("currencyName");
                id = new Object[]{bgDataRst.getString("bgDataId")};
                bgDataIds.add(id);
            }
            if (!bgDataIds.isEmpty()) break block9;
            id = actDetails;
            SQLUtils.cleanup((Statement)queryBgDataSta);
            SQLUtils.cleanup((ResultSet)bgDataRst);
            SQLUtils.cleanup(queryCtrlRecordSta);
            SQLUtils.cleanup(ctrlRecordRst);
            SQLUtils.cleanup((Connection)conn);
            return id;
        }
        try {
            final String _currecyName = currencyName;
            BgDbBatchUtil.batchExecuteQuery(ctx, queryCtrlRecordKSql.toString(), bgDataIds, new BgDbBatchUtil.CallbackHandler((List)actDetails){
                final /* synthetic */ List val$actDetails;
                {
                    this.val$actDetails = list;
                }

                @Override
                public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                    return 0;
                }

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    BgActualDetailInfo detailInfo = new BgActualDetailInfo();
                    String billId = rs.getString("FBillId");
                    String billNumber = rs.getString("FBillNumber");
                    String billType = rs.getString("FBillType");
                    int bgTraceType = rs.getInt("FBgTraceType");
                    BigDecimal bizActual = rs.getBigDecimal("FActualAmount");
                    java.sql.Date bizDate = rs.getDate("FBizDate");
                    java.sql.Date createTime = rs.getDate("FCreateTime");
                    String periodName = rs.getString("periodName");
                    String periodNum = rs.getString("periodNum");
                    detailInfo.setBillId(billId);
                    detailInfo.setBillNumber(billNumber);
                    detailInfo.setBillType(billType);
                    detailInfo.setBgTraceType(bgTraceType);
                    detailInfo.setBizAcutal(bizActual);
                    detailInfo.setBizDate(bizDate);
                    detailInfo.setCreateTime(createTime);
                    detailInfo.setCurrecyName(_currecyName);
                    detailInfo.setPeriodName(periodName);
                    detailInfo.setPeriodNumber(periodNum);
                    this.val$actDetails.add(detailInfo);
                }
            });
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)ex2.getMessage());
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(queryBgDataSta);
                SQLUtils.cleanup(bgDataRst);
                SQLUtils.cleanup(queryCtrlRecordSta);
                SQLUtils.cleanup(ctrlRecordRst);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)queryBgDataSta);
        SQLUtils.cleanup((ResultSet)bgDataRst);
        SQLUtils.cleanup(queryCtrlRecordSta);
        SQLUtils.cleanup(ctrlRecordRst);
        SQLUtils.cleanup((Connection)conn);
        return actDetails;
    }

    @Override
    protected Map _processTraceFindBudget(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        String OUID;
        HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>();
        ArrayList<BgTraceFindBudgetMsg> traceFindBudgetMsgList = new ArrayList<BgTraceFindBudgetMsg>();
        String boName = BudgetCtrlHelper.getBOName(ctx, billInfo);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID = BudgetCtrlHelper.getBillOUID(ctx, boName, billInfo));
        if (ctrlScheme == null) {
            return returnMap;
        }
        returnMap.put("bgControlScheme", ctrlScheme);
        returnMap.put("traceFindBudgetMsg", traceFindBudgetMsgList);
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        IObjectValue filterInfo = null;
        String oqlOrgUnit = null;
        String oqlItemCombination = null;
        String aliasItemCombination = null;
        String oqlOqlCurrency = null;
        String oqlOqlBizDate = null;
        BgPeriodEnum periodType = null;
        String customBgPeriodNumber = null;
        String oqlRuleCondition = null;
        String[] fields = null;
        List fieldValues = null;
        Map fieldValueMap = null;
        Object value_orgUnit = null;
        Object value_currency = null;
        CurrencyInfo currency = null;
        String value_element = null;
        BgElementInfo elementInfo = null;
        Date value_bizDate = null;
        BgPeriodInfo bgPeriodInfo = null;
        for (int i = 0; i < ruleCol.size(); ++i) {
            BgControlRuleInfo rule = ruleCol.get(i);
            oqlRuleCondition = rule.getOqlRuleCondition();
            filterInfo = oqlRuleCondition != null && oqlRuleCondition.length() > 0 ? Utils.filteObjectValue((IObjectValue)billInfo, (String)("where " + oqlRuleCondition), (boolean)true) : billInfo;
            if (filterInfo == null) {
                BgTraceFindBudgetMsg traceFindBudgetMsg = new BgTraceFindBudgetMsg();
                traceFindBudgetMsgList.add(traceFindBudgetMsg);
                traceFindBudgetMsg.setBgControlRuleInfo(rule);
                traceFindBudgetMsg.setBgControlRuleIndex(i);
                traceFindBudgetMsg.setMsg(new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"60_BudgetCtrlFacadeControllerBean", (Locale)ctx.getLocale())}).getMessage());
                continue;
            }
            oqlOrgUnit = rule.getOqlOrgUnit();
            oqlItemCombination = rule.getOqlItemCombination();
            aliasItemCombination = rule.getAliasItemCombination();
            oqlOqlCurrency = rule.getOqlCurrency();
            oqlOqlBizDate = rule.getOqlBizDate();
            periodType = rule.getPeriodCycle();
            customBgPeriodNumber = rule.getCustomBgPeriodNumber();
            oqlRuleCondition = rule.getOqlRuleCondition();
            HashMap specialValMap = new HashMap();
            BudgetCtrlHelper.processSpecialValue(oqlOrgUnit, specialValMap);
            BudgetCtrlHelper.processItemCombinSpecialValue(oqlItemCombination, specialValMap);
            BudgetCtrlHelper.processSpecialValue(oqlOqlCurrency, specialValMap);
            BudgetCtrlHelper.processSpecialValue(oqlOqlBizDate, specialValMap);
            fields = BudgetCtrlHelper.getOQLFields(rule);
            fieldValues = Utils.objectValueToMap((IObjectValue)filterInfo, (String[])fields);
            BudgetCtrlHelper.filterSpecialValue(fieldValues, specialValMap);
            if (fieldValues == null || fieldValues.size() == 0) {
                BgTraceFindBudgetMsg traceFindBudgetMsg = new BgTraceFindBudgetMsg();
                traceFindBudgetMsgList.add(traceFindBudgetMsg);
                traceFindBudgetMsg.setBgControlRuleInfo(rule);
                traceFindBudgetMsg.setBgControlRuleIndex(i);
                traceFindBudgetMsg.setMsg(new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"61_BudgetCtrlFacadeControllerBean", (Locale)ctx.getLocale())}).getMessage());
                continue;
            }
            for (int j = 0; j < fieldValues.size(); ++j) {
                String mappedItemNumber;
                BgTraceFindBudgetMsg traceFindBudgetMsg = new BgTraceFindBudgetMsg();
                traceFindBudgetMsgList.add(traceFindBudgetMsg);
                traceFindBudgetMsg.setBgControlRuleInfo(rule);
                traceFindBudgetMsg.setBgControlRuleIndex(i);
                fieldValueMap = (Map)fieldValues.get(j);
                value_orgUnit = fieldValueMap.get(fields[0]);
                if (!(value_orgUnit instanceof String) || BudgetCtrlUtil.isEmpty(value_orgUnit)) {
                    traceFindBudgetMsg.setMsg(new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"62_BudgetCtrlFacadeControllerBean", (Locale)ctx.getLocale())}).getMessage());
                    continue;
                }
                CostCenterOrgUnitInfo costCenter = BudgetCtrlCacheHelper.getCostCenter(ctx, value_orgUnit);
                if (costCenter == null) {
                    traceFindBudgetMsg.setMsg(new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"39_BgItemFacadeControllerBean", (Locale)ctx.getLocale()) + value_orgUnit + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"63_BudgetCtrlFacadeControllerBean", (Locale)ctx.getLocale())}).getMessage());
                    continue;
                }
                traceFindBudgetMsg.setOrgUnitNumber(costCenter.getNumber());
                traceFindBudgetMsg.setOrgUnitName(costCenter.getName());
                value_currency = fieldValueMap.get(fields[1]);
                if (!(value_currency instanceof String) || BudgetCtrlUtil.isEmpty(value_currency)) {
                    traceFindBudgetMsg.setMsg(new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"64_BudgetCtrlFacadeControllerBean", (Locale)ctx.getLocale())}).getMessage());
                    continue;
                }
                currency = BudgetCtrlCacheHelper.getCurrency(ctx, value_currency);
                if (currency == null) {
                    traceFindBudgetMsg.setMsg(new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"64_BudgetCtrlFacadeControllerBean", (Locale)ctx.getLocale())}).getMessage());
                    continue;
                }
                traceFindBudgetMsg.setCurrencyNumber(currency.getNumber());
                traceFindBudgetMsg.setCurrencyName(currency.getName());
                value_bizDate = (Date)fieldValueMap.get(fields[2]);
                if (value_bizDate == null) {
                    traceFindBudgetMsg.setMsg(new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"65_BudgetCtrlFacadeControllerBean", (Locale)ctx.getLocale())}).getMessage());
                    continue;
                }
                traceFindBudgetMsg.setBizDate(value_bizDate);
                bgPeriodInfo = BudgetCtrlHelper.mappingBgPeriod(ctx, value_bizDate, ctrlScheme, periodType.getValue(), customBgPeriodNumber);
                if (bgPeriodInfo == null || bgPeriodInfo.getId() == null) {
                    traceFindBudgetMsg.setMsg(new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"66_BudgetCtrlFacadeControllerBean", (Locale)ctx.getLocale())}).getMessage());
                    continue;
                }
                traceFindBudgetMsg.setBgPeriodNumber(bgPeriodInfo.getNumber());
                traceFindBudgetMsg.setBgPeriodName(bgPeriodInfo.getName());
                value_element = rule.getElementNumber();
                if (BudgetCtrlUtil.isEmpty(value_element)) {
                    traceFindBudgetMsg.setMsg(new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"67_BudgetCtrlFacadeControllerBean", (Locale)ctx.getLocale())}).getMessage());
                    continue;
                }
                elementInfo = BudgetCtrlCacheHelper.getBgElement(ctx, value_element);
                traceFindBudgetMsg.setBgElementNumber(value_element);
                traceFindBudgetMsg.setBgElementName(elementInfo.getName());
                String[] oqlItemCombinationTemp = oqlItemCombination.split("\\@");
                String billItemNumber = "";
                String billItemName = "";
                String itemField = null;
                String nameField = null;
                String itemValue = null;
                String nameValue = null;
                String itemCombinationAndPropNumber = "";
                for (int k = 0; k < oqlItemCombinationTemp.length; ++k) {
                    String[] oqlItemCombinationTempSub = oqlItemCombinationTemp[k].split("\\|");
                    itemField = oqlItemCombinationTempSub[0];
                    nameField = BudgetCtrlHelper.generateNameFiled(itemField);
                    itemValue = fieldValueMap.get(itemField) == null ? "" : (String)fieldValueMap.get(itemField);
                    String string = nameValue = fieldValueMap.get(nameField) == null ? "" : (String)fieldValueMap.get(nameField);
                    if (itemField.indexOf("entries.assistRecords.assGrp.generalAssActType") != -1 && itemField.indexOf("longNumber") != -1) {
                        billItemNumber = billItemNumber + itemValue.replaceAll("\\.", "\\!") + ",";
                        itemCombinationAndPropNumber = itemCombinationAndPropNumber + itemField + ":" + itemValue.replaceAll("\\.", "\\!") + "|";
                    } else {
                        billItemNumber = billItemNumber + itemValue + ",";
                        itemCombinationAndPropNumber = itemCombinationAndPropNumber + itemField + ":" + itemValue + "|";
                    }
                    billItemName = billItemName + nameValue + ",";
                }
                billItemNumber = BudgetCtrlUtil.replaceNULL(billItemNumber, "");
                billItemName = BudgetCtrlUtil.replaceNULL(billItemName, "");
                if (billItemNumber.lastIndexOf(",") != -1) {
                    billItemNumber = BudgetCtrlUtil.deleteStrTail(billItemNumber);
                }
                if (billItemName.lastIndexOf(",") != -1) {
                    billItemName = BudgetCtrlUtil.deleteStrTail(billItemName);
                }
                if (StringUtils.isEmpty((String)billItemNumber)) {
                    traceFindBudgetMsg.setMsg(new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"68_BudgetCtrlFacadeControllerBean", (Locale)ctx.getLocale())}).getMessage());
                    continue;
                }
                traceFindBudgetMsg.setBizItemNumber(billItemNumber);
                traceFindBudgetMsg.setBizItemName(billItemName);
                if (itemCombinationAndPropNumber.lastIndexOf("|") != -1) {
                    itemCombinationAndPropNumber = BudgetCtrlUtil.deleteStrTail(itemCombinationAndPropNumber);
                }
                if ((mappedItemNumber = BudgetCtrlHelper.mappingBgItem(ctx, itemCombinationAndPropNumber, ctrlScheme, costCenter.getId().toString())) != null) {
                    traceFindBudgetMsg.setBgItemNumber(mappedItemNumber);
                } else {
                    traceFindBudgetMsg.setBgItemNumber(billItemNumber);
                }
                traceFindBudgetMsg.setBgItemName(billItemName);
                if (traceFindBudgetMsg.getBgItemNumber() == null || traceFindBudgetMsg.getBgItemNumber().indexOf("_") <= 0) continue;
                String itemCombinNumber = BudgetCtrlCacheHelper.getBgItemCombinationKey(ctx, traceFindBudgetMsg.getBgItemNumber(), OUID);
                traceFindBudgetMsg.setBgItemNumber(itemCombinNumber);
                String itemCombinName = BudgetCtrlCacheHelper.getBgItemCombinationName(ctx, itemCombinNumber, OUID);
                traceFindBudgetMsg.setBgItemName(itemCombinName);
            }
        }
        return returnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _lockCostCentersTransaction(Context ctx, BgCtrlParamCollection ctrlParamCol) throws BOSException, EASBizException {
        ArrayList<String> costCenterIds = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            costCenterIds.addAll(this.getConcurrentOrgUnitId(conn, this.getRequestOrgUnitId(ctrlParamCol)));
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        BudgetCtrlHelper.lockCostCenterTransaction(ctx, costCenterIds);
    }

    protected Set<String> getRequestOrgUnitId(BgCtrlParamCollection ctrlParamCol) {
        HashSet<String> orgUnitIds = new HashSet<String>();
        if (ctrlParamCol == null) {
            return orgUnitIds;
        }
        BgCtrlParamInfo param = null;
        int in = ctrlParamCol.size();
        for (int i = 0; i < in; ++i) {
            param = ctrlParamCol.get(i);
            orgUnitIds.add(param.getOrgUnitId());
        }
        return orgUnitIds;
    }

    protected Set<String> getConcurrentOrgUnitId(Connection conn, Set<String> orgUnitIds) throws BOSException, EASBizException {
        HashSet<String> querySet = new HashSet<String>();
        if (conn == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            querySet.add(this.getGlobalLockId());
        } else {
            int level = this.getControlLevel(conn);
            if (level <= 1) {
                querySet.add(this.getGlobalLockId());
            } else {
                Set<String> tmpSet = this.getConcurrentOrgUnitId(conn, orgUnitIds, level);
                if (tmpSet != null) {
                    querySet.addAll(tmpSet);
                }
                if (querySet.isEmpty()) {
                    querySet.add(this.getGlobalLockId());
                }
            }
        }
        return querySet;
    }

    protected String getGlobalLockId() {
        return "99999999999999999999";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getControlLevel(Connection conn) {
        int level = 1;
        if (conn == null) {
            return level;
        }
        IRowSet rst = null;
        try {
            String tmpStr;
            rst = BgDBUtils.executeQuery(conn, "select FValue from T_BG_BgParam where FKey = ?", new Object[]{CONTROL_LEVEL});
            if (rst != null && rst.next() && (tmpStr = rst.getString("FValue")) != null) {
                level = new Integer(tmpStr.trim());
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (Exception ex) {
            logger.error((Object)"query Control Level Error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getConcurrentOrgUnitId(Connection conn, Set<String> orgUnitIds, int level) throws BOSException, EASBizException {
        if (conn == null || orgUnitIds == null) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        ArrayList<String> tmpList = new ArrayList<String>();
        tmpList.addAll(orgUnitIds);
        int size = tmpList.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select FLongNumber from T_ORG_CostCenter where FID IN (");
        for (int i = 1; i < 50; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        StringBuffer query = new StringBuffer();
        query.append("select FID from T_ORG_CostCenter where FNumber IN (");
        for (int i = 1; i < 50; ++i) {
            query.append("?,");
        }
        query.append("?) and FLevel = ?");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String longnumber = null;
        String[] numbers = null;
        HashSet<String> numberSet = new HashSet<String>();
        try {
            int x;
            int index;
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                x = 1;
                while (x <= 50) {
                    if (pos < size) {
                        pstmt.setString(x, (String)tmpList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        longnumber = rst.getString(1);
                        numbers = longnumber.split("!");
                        if (numbers == null) continue;
                        int zn = numbers.length;
                        for (int z = 0; z < zn; ++z) {
                            numberSet.add(numbers[z]);
                        }
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            if (!numberSet.isEmpty()) {
                tmpList.clear();
                tmpList.addAll(numberSet);
                size = tmpList.size();
                count = (size - 1) / 50 + 1;
                pos = 0;
                pstmt = conn.prepareStatement(query.toString());
                for (index = 0; index < count; ++index) {
                    x = 1;
                    while (x <= 50) {
                        if (pos < size) {
                            pstmt.setString(x, (String)tmpList.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    pstmt.setInt(51, level);
                    try {
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            idSet.add(rst.getString("FID"));
                        }
                        continue;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)sql.toString());
                logger.error((Object)"Budget Control Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return idSet;
    }

    @Override
    protected BigDecimal _getMaxExecuteRatio(Context ctx, BOSUuid boId) throws BOSException, EASBizException {
        BigDecimal ratio = BudgetCtrlConstants.MIN_AMOUNT;
        BigDecimal ratioTmp = null;
        BgCtrlResultCollection ctrlResultCol = this.getBudget(ctx, boId.toString());
        if (ctrlResultCol == null || ctrlResultCol.isEmpty()) {
            return ratio;
        }
        BigDecimal bgValue = null;
        BigDecimal bizActual = null;
        BigDecimal reqAmount = null;
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            if (ctrlResultInfo.getBgDataId() == null) continue;
            bgValue = ctrlResultInfo.getBgValue();
            bizActual = ctrlResultInfo.getBizActual();
            reqAmount = ctrlResultInfo.getReqAmount();
            if (bgValue == null || bgValue == BudgetCtrlConstants.ZERO_AMOUNT || bizActual == null || reqAmount == null || (ratioTmp = bizActual.add(reqAmount).divide(bgValue, 2)).compareTo(ratio) < 0) continue;
            ratio = ratioTmp;
        }
        return ratio;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BgCtrlResultCollection processMultiRule(Context ctx, BgCtrlParamCollection ctrlParamCol, BgCtrlResultCollection ctrlResultCol, BgControlSchemeInfo ctrlScheme) throws EASBizException, BOSException {
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return ctrlResultCol;
        }
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            return ctrlResultCol;
        }
        if (BudgetCtrlUtil.isEmpty((Object)ctrlParamCol) || BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return ctrlResultCol;
        }
        Map multiRuleMap = BudgetCtrlHelper.processMultiRuleCol(multiRuleCol);
        HashMap groupCheckMap = new HashMap();
        Map<String, BgControlMultiRuleInfo> groupitem = null;
        for (int i = 0; i < multiRuleCol.size(); ++i) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            String ctrlItemCombinId = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ctrlItemCombinId)) {
                groupitem = (Map)groupCheckMap.get(ctrlItemCombinId);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem = new HashMap();
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ctrlItemCombinId, groupitem);
        }
        HashMap<String, BgCtrlResultInfo> ctrlResultInfoCache = new HashMap<String, BgCtrlResultInfo>();
        HashMap<String, String> bgDataBgFormCache = new HashMap<String, String>();
        HashMap<String, BgFormInfo> bgFormInfoCache = new HashMap<String, BgFormInfo>();
        HashMap<String, CostCenterOrgUnitInfo> orgUnitCache = new HashMap<String, CostCenterOrgUnitInfo>();
        HashMap<String, BgSchemeInfo> bgSchemeCache = new HashMap<String, BgSchemeInfo>();
        int i = 0;
        while (true) {
            block46: {
                BigDecimal groupItemBal;
                BigDecimal bizItemSumActVal;
                BigDecimal bizItemSumBgVal;
                BigDecimal ctrlItemSumExeVal;
                BigDecimal ctrlItemSumActVal;
                BigDecimal ctrlItemSumBgVal;
                BigDecimal compareValue;
                BgCtrlMRCtrlRuleEnum ctrlRule;
                BigDecimal coe;
                BgCtrlMRCtrlValueEnum ctrlValue;
                BgMultiRuleCtrlResultInfo multiRuleCtrlResult;
                BgControlMultiRuleInfo multiRuleInfo;
                BigDecimal bizItemBal;
                BgCtrlResultInfo bizItemCtrlRusultInfo;
                block49: {
                    String BgFormId;
                    ReportCalculateErrorProvider errorProvider;
                    ReportVariables variables;
                    BgRptReportPropertyAdapter adapter;
                    ReportCalculateContext context;
                    String CtrlItemID;
                    BigDecimal decvalue;
                    BigDecimal groupBgVal;
                    String bizItemCombNumber;
                    BgCtrlParamInfo ctrlParamInfo;
                    block50: {
                        IRowSet rst;
                        BgControlMultiRuleInfo groupMultiRuleInfo;
                        BgCtrlResultInfo ctrlItemCtrlResultInfo;
                        String ctrlItemCombNumber;
                        block48: {
                            block47: {
                                block45: {
                                    if (i >= ctrlResultCol.size()) {
                                        ctrlResultInfoCache.clear();
                                        bgDataBgFormCache.clear();
                                        bgFormInfoCache.clear();
                                        orgUnitCache.clear();
                                        bgSchemeCache.clear();
                                        return ctrlResultCol;
                                    }
                                    bizItemCtrlRusultInfo = ctrlResultCol.get(i);
                                    String bizItemBgDataId = bizItemCtrlRusultInfo.getBgDataId();
                                    if (bizItemBgDataId != null) break block45;
                                    bizItemCtrlRusultInfo.setIsMultiRuleCtrl(false);
                                    bizItemCtrlRusultInfo.setMultiRuleCtrlResult(null);
                                    break block46;
                                }
                                bizItemBal = bizItemCtrlRusultInfo.getBalance();
                                ctrlParamInfo = ctrlParamCol.get(i);
                                if (ctrlParamInfo == null) break block46;
                                bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
                                if (multiRuleMap.containsKey(bizItemCombNumber)) break block47;
                                bizItemCtrlRusultInfo.setIsMultiRuleCtrl(false);
                                bizItemCtrlRusultInfo.setMultiRuleCtrlResult(null);
                                break block46;
                            }
                            String periodNumber = ctrlParamInfo.getPeriodNumber();
                            String currencyNumber = ctrlParamInfo.getCurrencyNumber();
                            String elementNumber = ctrlParamInfo.getElementNumber();
                            multiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber);
                            ctrlItemCombNumber = multiRuleInfo.getCtrlItemCombinNumber();
                            String ctrlItemFormula = BudgetCtrlUtil.buildItemFormula(ctrlItemCombNumber.replaceAll("_", ","), periodNumber, elementNumber, currencyNumber);
                            ctrlItemCtrlResultInfo = null;
                            String ctrlResultInfoCacheKey = ctrlParamInfo.getOrgUnitId() + "@" + ctrlParamInfo.getBgSchemeId() + "@" + ctrlItemFormula;
                            if (!ctrlResultInfoCache.containsKey(ctrlResultInfoCacheKey)) {
                                BgCtrlParamInfo cloneCtrlParamInfo = (BgCtrlParamInfo)ctrlParamInfo.clone();
                                cloneCtrlParamInfo.setItemFormula(ctrlItemFormula);
                                cloneCtrlParamInfo.setItemCombinNumber(ctrlItemCombNumber);
                                ctrlItemCtrlResultInfo = BgBalCalculator.calcuBal(ctx, cloneCtrlParamInfo, true, BgGetPeriodTypeForGetBlanceEnum.Is_Control);
                                ctrlResultInfoCache.put(ctrlResultInfoCacheKey, ctrlItemCtrlResultInfo);
                            } else {
                                ctrlItemCtrlResultInfo = (BgCtrlResultInfo)ctrlResultInfoCache.get(ctrlResultInfoCacheKey);
                            }
                            if (ctrlItemCtrlResultInfo != null && ctrlItemCtrlResultInfo.getBgDataId() != null) break block48;
                            bizItemCtrlRusultInfo.setIsMultiRuleCtrl(false);
                            bizItemCtrlRusultInfo.setMultiRuleCtrlResult(null);
                            break block46;
                        }
                        bizItemCtrlRusultInfo.setIsMultiRuleCtrl(true);
                        String ctrlItemBgDataId = ctrlItemCtrlResultInfo.getBgDataId();
                        BigDecimal ctrlItemBgVal = ctrlItemCtrlResultInfo.getBgValue();
                        BigDecimal ctrlItemActVal = ctrlItemCtrlResultInfo.getBizActual();
                        String ctrlItemCombName = multiRuleInfo.getCtrlItemCombinAlias().replaceAll(",", "_");
                        multiRuleCtrlResult = new BgMultiRuleCtrlResultInfo();
                        multiRuleCtrlResult.setBgDataId(ctrlItemBgDataId);
                        multiRuleCtrlResult.setItemCombinNumber(ctrlItemCombNumber);
                        multiRuleCtrlResult.setItemCombinName(ctrlItemCombName);
                        multiRuleCtrlResult.setBgValue(ctrlItemBgVal);
                        multiRuleCtrlResult.setBizActual(ctrlItemActVal);
                        bizItemCtrlRusultInfo.setMultiRuleCtrlResult(multiRuleCtrlResult);
                        ctrlValue = multiRuleInfo.getCtrlValue();
                        coe = multiRuleInfo.getCtrlCoe();
                        ctrlRule = multiRuleInfo.getCtrlRule();
                        compareValue = BgNConstants.ZERO;
                        ctrlItemSumBgVal = (BigDecimal)ctrlItemCtrlResultInfo.get("sumBudgetValue");
                        ctrlItemSumActVal = (BigDecimal)ctrlItemCtrlResultInfo.get("sumActualValue");
                        ctrlItemSumExeVal = ctrlItemSumBgVal.compareTo(BudgetCtrlConstants.ZERO_AMOUNT) == 0 ? BudgetCtrlConstants.ZERO_AMOUNT : ctrlItemSumActVal.divide(ctrlItemSumBgVal, 8, 4);
                        bizItemSumBgVal = (BigDecimal)bizItemCtrlRusultInfo.get("sumBudgetValue");
                        bizItemSumActVal = (BigDecimal)bizItemCtrlRusultInfo.get("sumActualValue");
                        bizItemSumBgVal = bizItemSumBgVal == null ? BgNConstants.ZERO : bizItemSumBgVal;
                        groupItemBal = bizItemSumActVal = bizItemSumActVal == null ? BgNConstants.ZERO : bizItemSumActVal;
                        groupBgVal = bizItemSumBgVal;
                        if (multiRuleMap == null || multiRuleMap.size() == 0 || groupCheckMap.isEmpty() || groupCheckMap.size() == 0) break block49;
                        decvalue = BgNConstants.ZERO;
                        if (!multiRuleMap.containsKey(bizItemCombNumber) || !groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) || !groupMultiRuleInfo.isIsGroupCheck()) break block49;
                        context = null;
                        adapter = null;
                        variables = new ReportVariables();
                        errorProvider = new ReportCalculateErrorProvider();
                        BgFormId = null;
                        if (bgDataBgFormCache.containsKey(ctrlItemBgDataId)) {
                            BgFormId = (String)bgDataBgFormCache.get(ctrlItemBgDataId);
                        } else {
                            block44: {
                                StringBuffer SQL = new StringBuffer(2048);
                                SQL.append(" select t.fbgformid from t_bg_bgdata t where t.fid= ?");
                                rst = null;
                                rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString(), (Object[])new String[]{ctrlItemBgDataId});
                                if (rst.next()) break block44;
                                BgCtrlResultCollection bgCtrlResultCollection = null;
                                SQLUtils.cleanup((ResultSet)rst);
                                return bgCtrlResultCollection;
                            }
                            BgFormId = rst.getString("FBgFormId");
                            bgDataBgFormCache.put(ctrlItemBgDataId, BgFormId);
                            SQLUtils.cleanup((ResultSet)rst);
                        }
                        break block50;
                        catch (SQLException ex) {
                            try {
                                logger.error((Object)ex.getMessage());
                                throw new BgException(BgException.DATABASEERROR, new Object[]{ex.getMessage()});
                                catch (Exception ex2) {
                                    logger.error((Object)ex2.getMessage());
                                    throw new BOSException((Throwable)ex2);
                                }
                            }
                            catch (Throwable throwable) {
                                SQLUtils.cleanup(rst);
                                throw throwable;
                            }
                        }
                    }
                    BgFormInfo bgForm = null;
                    if (bgFormInfoCache.containsKey(BgFormId)) {
                        bgForm = (BgFormInfo)bgFormInfoCache.get(BgFormId);
                    } else {
                        ObjectUuidPK BgFormpk = new ObjectUuidPK(BOSUuid.read((String)BgFormId));
                        bgForm = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)BgFormpk, BudgetCtrlFacadeControllerBean.getBgFormSelectors());
                        bgFormInfoCache.put(BgFormId, bgForm);
                    }
                    String _ctrlOrgid = ctrlParamInfo.getOrgUnitId();
                    String _ctrlOrgnum = null;
                    if (orgUnitCache.containsKey(_ctrlOrgid)) {
                        _ctrlOrgnum = ((CostCenterOrgUnitInfo)orgUnitCache.get(_ctrlOrgid)).getNumber();
                    } else {
                        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)_ctrlOrgid));
                        CostCenterOrgUnitInfo orgUnitInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)pk);
                        _ctrlOrgnum = orgUnitInfo.getNumber();
                        orgUnitCache.put(_ctrlOrgid, orgUnitInfo);
                    }
                    String _bgSchemeId = ctrlParamInfo.getBgSchemeId();
                    String _bgSchemeNumber = null;
                    if (bgSchemeCache.containsKey(_bgSchemeId)) {
                        _bgSchemeNumber = ((BgSchemeInfo)bgSchemeCache.get(_bgSchemeId)).getNumber();
                    } else {
                        ObjectUuidPK apk = new ObjectUuidPK(BOSUuid.read((String)_bgSchemeId));
                        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)apk);
                        _bgSchemeNumber = bgSchemeInfo.getNumber();
                        bgSchemeCache.put(_bgSchemeId, bgSchemeInfo);
                    }
                    Map group = (Map)groupCheckMap.get(CtrlItemID);
                    Iterator it = group.entrySet().iterator();
                    adapter = new BgRptReportPropertyAdapter(bgForm);
                    context = new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, variables, (IErrorProvider)errorProvider, null);
                    BgAvlBalCalculator bgAvlBal = new BgAvlBalCalculator((ICalculateContextProvider)context, ctx);
                    SortedParameterArray params = new SortedParameterArray();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        String bizitem = (String)entry.getKey();
                        BgControlMultiRuleInfo value = (BgControlMultiRuleInfo)entry.getValue();
                        if (bizitem.equals(bizItemCombNumber)) continue;
                        String _bgElementNumber = ctrlParamInfo.getElementNumber();
                        String _bgItemNumber = bizitem.replaceAll("_", ",");
                        String _currencyNumber = ctrlParamInfo.getCurrencyNumber();
                        String _PeriodNumber = ctrlParamInfo.getPeriodNumber();
                        Object[] obj = new Object[]{new Variant((Object)_ctrlOrgnum), new Variant((Object)_bgSchemeNumber), new Variant((Object)_bgElementNumber), new Variant((Object)_bgItemNumber), new Variant((Object)_currencyNumber), new Variant((Object)_PeriodNumber)};
                        Parameter tmp = new Parameter(obj, "", false);
                        params.append((Object)tmp);
                    }
                    bgAvlBal.execute(params);
                    List formulailist = bgAvlBal.getCalDataList();
                    if (formulailist == null || formulailist.size() == 0) {
                        decvalue = BgNConstants.ZERO;
                    } else {
                        BgAvlFormulaInfo bgFormula = null;
                        String bgItemNumber = null;
                        for (int bizItemIdx = 0; bizItemIdx < formulailist.size(); ++bizItemIdx) {
                            bgFormula = (BgAvlFormulaInfo)formulailist.get(bizItemIdx);
                            bgItemNumber = bgFormula.getBgItemNumber().replaceAll(",", "_");
                            if (bgFormula.getActualValue() != null) {
                                groupItemBal = groupItemBal.add(bgFormula.getActualValue());
                            }
                            if (group.get(bgItemNumber) == null || !((BgControlMultiRuleInfo)group.get(bgItemNumber)).getCtrlValue().equals((Object)BgCtrlMRCtrlValueEnum.EXERATIO)) continue;
                            groupBgVal = groupBgVal.add(bgFormula.getBudgetValue());
                        }
                    }
                    groupItemBal = groupItemBal.add(decvalue);
                    bizItemSumBgVal = groupBgVal;
                }
                BigDecimal bigDecimal = bizItemSumActVal = (bizItemSumActVal = groupItemBal) == null ? BgNConstants.ZERO : bizItemSumActVal;
                if (ctrlValue.getValue() == 1) {
                    compareValue = ctrlItemSumBgVal.multiply(coe).subtract(bizItemSumActVal);
                } else if (ctrlValue.getValue() == 2) {
                    compareValue = ctrlItemSumActVal.multiply(coe).subtract(bizItemSumActVal);
                } else if (ctrlValue.getValue() == 3) {
                    compareValue = bizItemSumBgVal.multiply(ctrlItemSumExeVal).subtract(bizItemSumActVal);
                } else if (ctrlValue.getValue() == 4) {
                    BgCtrlMultiRuleEntryCollection bgCtrlMultiRuleEntryCol = multiRuleInfo.getEntry();
                    boolean isCalulated = false;
                    if (bgCtrlMultiRuleEntryCol.size() > 0) {
                        for (int j = 0; j < bgCtrlMultiRuleEntryCol.size(); ++j) {
                            BgCtrlMultiRuleEntryInfo multiRuleEntryInfo = bgCtrlMultiRuleEntryCol.get(j);
                            String controllProcess = multiRuleEntryInfo.getControllProcess();
                            if (StringUtils.isEmpty((String)controllProcess) || !this.compareControllProcess(ctrlItemSumExeVal, controllProcess)) continue;
                            compareValue = bizItemSumBgVal.multiply(multiRuleEntryInfo.getCtrlCoe()).subtract(bizItemSumActVal);
                            isCalulated = true;
                            break;
                        }
                    }
                    if (!isCalulated) {
                        compareValue = bizItemSumBgVal.multiply(coe).subtract(bizItemSumActVal);
                    }
                }
                bizItemBal = bizItemBal != null ? bizItemBal : BgNConstants.ZERO;
                BigDecimal bigDecimal2 = compareValue = compareValue != null ? compareValue : BgNConstants.ZERO;
                if (ctrlRule.getValue() == 1) {
                    bizItemCtrlRusultInfo.setBalance(compareValue);
                } else if (ctrlRule.getValue() == 2) {
                    bizItemCtrlRusultInfo.setBalance(bizItemBal.compareTo(compareValue) > 0 ? bizItemBal : compareValue);
                } else if (ctrlRule.getValue() == 3) {
                    bizItemCtrlRusultInfo.setBalance(bizItemBal.compareTo(compareValue) > 0 ? compareValue : bizItemBal);
                }
                multiRuleCtrlResult.setBalance(bizItemBal);
            }
            ++i;
        }
    }

    private boolean compareControllProcess(BigDecimal ctrlItemSumExeVal, String controllProcess) {
        boolean flag = false;
        boolean isDoubleCom = false;
        for (int i = 0; i < 2; ++i) {
            if (!Character.isDigit(controllProcess.charAt(i))) continue;
            isDoubleCom = true;
        }
        if (isDoubleCom) {
            BigDecimal pro = new BigDecimal(controllProcess.substring(1));
            String dig = String.valueOf(controllProcess.charAt(0));
            if (dig.equals(">")) {
                if (ctrlItemSumExeVal.compareTo(pro) == 1) {
                    flag = true;
                }
            } else if (dig.equals("<")) {
                if (ctrlItemSumExeVal.compareTo(pro) == -1) {
                    flag = true;
                }
            } else if (dig.equals("=") && ctrlItemSumExeVal.compareTo(pro) == 0) {
                flag = true;
            }
        } else {
            BigDecimal pro = new BigDecimal(controllProcess.substring(2));
            if (controllProcess.substring(0, 2).equals(">=") && (ctrlItemSumExeVal.compareTo(pro) == 1 || ctrlItemSumExeVal.compareTo(pro) == 0)) {
                flag = true;
            }
            if (controllProcess.substring(0, 2).equals("<=") && (ctrlItemSumExeVal.compareTo(pro) == -1 || ctrlItemSumExeVal.compareTo(pro) == 0)) {
                flag = true;
            }
        }
        return flag;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _upgradeCtrlDataToEAS600(Context ctx) throws BOSException, EASBizException {
        int tempState = 9;
        StringBuffer insertKSQL = new StringBuffer();
        insertKSQL.append(" insert into T_BG_BgCtrlRecord");
        insertKSQL.append("   (FId,");
        insertKSQL.append("    FCreatorId,");
        insertKSQL.append("    FCreateTime,");
        insertKSQL.append("    FLastUpdateUserId,");
        insertKSQL.append("    FLastUpdateTime,");
        insertKSQL.append("    FControlUnitId,");
        insertKSQL.append("    FBgDataId,");
        insertKSQL.append("    FBillId,");
        insertKSQL.append("    FBillName,");
        insertKSQL.append("    FBillNumber,");
        insertKSQL.append("    FBillAlias,");
        insertKSQL.append("    FBillType,");
        insertKSQL.append("    FBizDate,");
        insertKSQL.append("    FActualAmount,");
        insertKSQL.append("    FBillOperate,");
        insertKSQL.append("    FBgPeriodId,");
        insertKSQL.append("    FItemName,");
        insertKSQL.append("    FBgTraceType,");
        insertKSQL.append("    FOrgUnitId,");
        insertKSQL.append("    FBgSchemeId,");
        insertKSQL.append("    FItemFormula,");
        insertKSQL.append("    FPayState,");
        insertKSQL.append("    FISCollected,");
        insertKSQL.append("    FActualType)");
        insertKSQL.append("   select newbosid('FF6153C2'),");
        insertKSQL.append("          cr.FCreatorId,");
        insertKSQL.append("          cr.FCreateTime,");
        insertKSQL.append("          cr.FLastUpdateUserId,");
        insertKSQL.append("          cr.FLastUpdateTime,");
        insertKSQL.append("          cr.FControlUnitId,");
        insertKSQL.append("          cr.FBgDataId,");
        insertKSQL.append("          crsd.FBillId,");
        insertKSQL.append("          cr.FBillName,");
        insertKSQL.append("          cr.FBillNumber,");
        insertKSQL.append("          cr.FBillAlias,");
        insertKSQL.append("          cr.FBillType,");
        insertKSQL.append("          cr.FBizDate,");
        insertKSQL.append("          crsd.FActualAmount,");
        insertKSQL.append("          cr.FBillOperate,");
        insertKSQL.append("          cr.FBgPeriodId,");
        insertKSQL.append("          cr.FItemName,");
        insertKSQL.append("          cr.FbgTraceType,");
        insertKSQL.append("          cr.FOrgUnitId,");
        insertKSQL.append("          cr.FBgSchemeId,");
        insertKSQL.append("          cr.FItemFormula,");
        insertKSQL.append("          cr.FPayState,");
        insertKSQL.append("          " + tempState + ",");
        insertKSQL.append("          20");
        insertKSQL.append("     from T_BG_BgCtrlRecord cr, ");
        insertKSQL.append("          T_BG_BgCtrlRecordSumDetail crsd");
        insertKSQL.append("    where cr.FId = crsd.FBgCtrlRecordId");
        insertKSQL.append("      and (");
        insertKSQL.append("            cr.FBgTraceType = 4");
        insertKSQL.append("           or");
        insertKSQL.append("            cr.FBgTraceType = 7");
        insertKSQL.append("           )");
        insertKSQL.append("      and crsd.FId is not null");
        StringBuffer queryKSQL = new StringBuffer();
        queryKSQL.append(" select Fid,");
        queryKSQL.append("        FBillId,");
        queryKSQL.append("        FBillType");
        queryKSQL.append("   from T_Bg_BgCtrlRecord");
        queryKSQL.append("  where FISCollected = " + tempState);
        StringBuffer updateKSQL = new StringBuffer();
        updateKSQL.append(" update T_Bg_BgCtrlRecord");
        updateKSQL.append("    set FBillType = ?,");
        updateKSQL.append("        FBillAlias = ?,");
        updateKSQL.append("        FBillName = ?,");
        updateKSQL.append("        FBillNumber = ?,");
        updateKSQL.append("        FISCollected = ?");
        updateKSQL.append("  where FId = ?");
        StringBuffer deleteSumSQL = new StringBuffer();
        deleteSumSQL.append(" delete T_BG_BgCtrlRecord");
        deleteSumSQL.append("  where (");
        deleteSumSQL.append("           FBgTraceType = 4");
        deleteSumSQL.append("          or");
        deleteSumSQL.append("           FBgTraceType = 7");
        deleteSumSQL.append("         )");
        Connection conn = null;
        ResultSet resultSet = null;
        IRowSet rowSet = null;
        PreparedStatement insertSta = null;
        PreparedStatement querySta = null;
        PreparedStatement updateSta = null;
        PreparedStatement deleteSumSta = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            insertSta = conn.prepareStatement(insertKSQL.toString());
            querySta = conn.prepareStatement(queryKSQL.toString());
            updateSta = conn.prepareStatement(updateKSQL.toString());
            deleteSumSta = conn.prepareStatement(deleteSumSQL.toString());
            insertSta.execute();
            resultSet = querySta.executeQuery();
            int batchCounter = 0;
            boolean isRunUpdate = false;
            while (resultSet.next()) {
                String bgCtrlRecordId = resultSet.getString("FId");
                String billId = resultSet.getString("FBillId");
                String sumTypeAlias = resultSet.getString("FBillType");
                BgTraceTypeEnum traceTypeEnum = null;
                traceTypeEnum = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"37_BgItemControllerBean", (Locale)ctx.getLocale()).equals(sumTypeAlias) ? BgTraceTypeEnum.lowerOrgItemCollect : BgTraceTypeEnum.SumFromLower;
                String billNumber = null;
                String boAlias = BudgetCtrlHelper.getBOAlias(ctx, billId);
                String billType = BudgetCtrlHelper.getTypeAllias(boAlias, traceTypeEnum);
                String boName = BudgetCtrlHelper.getBOName(ctx, billId);
                IDataProvider dataProvider = EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(boName));
                dataProvider.setObjectView(" select number where id = '" + billId + "'");
                String queryBillNumberSQL = dataProvider.getSQL();
                rowSet = DbUtil.executeQuery((Context)ctx, (String)queryBillNumberSQL);
                if (rowSet.next()) {
                    billNumber = rowSet.getString(1);
                }
                updateSta.setString(1, billType);
                updateSta.setString(2, boAlias);
                updateSta.setString(3, billNumber);
                updateSta.setString(4, billNumber);
                updateSta.setInt(5, 1);
                updateSta.setString(6, bgCtrlRecordId);
                updateSta.addBatch();
                isRunUpdate = true;
                if (++batchCounter < 200) continue;
                updateSta.executeBatch();
                batchCounter = 0;
            }
            if (isRunUpdate) {
                if (batchCounter != 0) {
                    updateSta.executeBatch();
                }
                deleteSumSta.execute();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertSta);
                SQLUtils.cleanup(querySta);
                SQLUtils.cleanup(updateSta);
                SQLUtils.cleanup(deleteSumSta);
                SQLUtils.cleanup(resultSet);
                SQLUtils.cleanup(rowSet);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertSta);
        SQLUtils.cleanup((Statement)querySta);
        SQLUtils.cleanup((Statement)updateSta);
        SQLUtils.cleanup((Statement)deleteSumSta);
        SQLUtils.cleanup((ResultSet)resultSet);
        SQLUtils.cleanup(rowSet);
        SQLUtils.cleanup((Connection)conn);
    }

    @Override
    protected List _batchWriteCtrlData(Context ctx, String boName, Map ccId2csIdMap, Date beginDate, Date endDate) throws BOSException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.BATCH_REPAIR);
        state.setSchemeCtrlRequestActual(true);
        ArrayList<Object[]> batchCtrlRstList = new ArrayList<Object[]>();
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"_batchCtrlBizBills", (BOSObjectType)this.getBOSType(), null, (String)ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"69_BudgetCtrlFacadeControllerBean", (Locale)ctx.getLocale()));
        if (BudgetCtrlUtil.isEmpty(ccId2csIdMap)) {
            return batchCtrlRstList;
        }
        Iterator itr = ccId2csIdMap.keySet().iterator();
        while (itr.hasNext()) {
            String ouid = itr.next().toString();
            Object[] result = new Object[4];
            result[0] = ouid;
            BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, ouid);
            if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) continue;
            List billIds = BudgetCtrlHelper.queryBizBills(ctx, ctrlScheme, ouid, beginDate, endDate);
            result[1] = new Integer(billIds.size());
            int successCount = 0;
            for (int i = 0; i < billIds.size(); ++i) {
                BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
                String boId = billIds.get(i).toString();
                BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, boId.toString(), boName, ctrlScheme);
                this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
                ctrlResultCol = this.getBgCtrlResultCol(ctx, state, ctrlParamCol, ctrlResultCol);
                if (!BudgetCtrlHelper.hasScheme(ctx, boName, BOSUuid.read((String)boId))) {
                    ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
                }
                Map returnData = this.getReturnBudget(ctx, boId.toString(), boName);
                ctrlResultCol = this.mergeReturnBudget(ctx, ctrlResultCol, returnData);
                ctrlResultCol = BudgetCtrlHelper.getSuperiorItemCtrlData(ctx, ctrlResultCol);
                Map bgDataMap = BudgetCtrlHelper.getBgDataMap(ctx, ctrlResultCol, returnData);
                this.writeCtrlData1(ctx, boId.toString(), boName, ctrlResultCol, bgDataMap);
                if (!BudgetCtrlHelper.hasBudget(ctrlResultCol)) continue;
                ++successCount;
            }
            result[2] = new Integer(successCount);
            result[3] = new Integer(billIds.size() - successCount);
            batchCtrlRstList.add(result);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return batchCtrlRstList;
    }

    private void writeCtrlData1(Context ctx, String boId, String boName, BgCtrlResultCollection ctrlResultCol, Map bgDataMap) throws BOSException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.WF_APPROVE);
        state.setSchemeCtrlRequestActual(true);
        BudgetCtrlHelper.addBizActual(ctx, bgDataMap);
        BudgetCtrlHelper.deleteReturnCtrlRecord(ctx, boId, boName);
        BudgetCtrlHelper.insertCtrlRecord(ctx, state, ctrlResultCol);
    }

    @Override
    protected List _batchClearCtrlData(Context ctx, String boName, Map ccId2csIdMap, Date beginDate, Date endDate) throws BOSException, EASBizException {
        ArrayList<Object[]> batchCtrlRstList = new ArrayList<Object[]>();
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"_batchCancelCtrlBizBills", (BOSObjectType)this.getBOSType(), null, (String)ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"70_BudgetCtrlFacadeControllerBean", (Locale)ctx.getLocale()));
        if (BudgetCtrlUtil.isEmpty(ccId2csIdMap)) {
            return batchCtrlRstList;
        }
        Iterator itr = ccId2csIdMap.keySet().iterator();
        while (itr.hasNext()) {
            String ouid = itr.next().toString();
            Object[] result = new Object[4];
            result[0] = ouid;
            BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, ouid);
            if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) continue;
            List billIds = BudgetCtrlHelper.queryBizBills(ctx, ctrlScheme, ouid, beginDate, endDate);
            result[1] = new Integer(billIds.size());
            int successCount = 0;
            for (int i = 0; i < billIds.size(); ++i) {
                String boId = billIds.get(i).toString();
                this._returnBudget(ctx, BOSUuid.read((String)boId));
                ++successCount;
            }
            result[2] = new Integer(successCount);
            result[3] = new Integer(billIds.size() - successCount);
            batchCtrlRstList.add(result);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return batchCtrlRstList;
    }

    @Override
    protected Map _getBillsCountOnOU(Context ctx, String boName, Set ccIds, Date beginDate, Date endDate) throws BOSException, EASBizException {
        HashMap<String, Integer> retMap = new HashMap<String, Integer>();
        if (ccIds == null || ccIds.isEmpty()) {
            return retMap;
        }
        Iterator itr = ccIds.iterator();
        while (itr.hasNext()) {
            String ouid = itr.next().toString();
            BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, ouid);
            List billIds = BudgetCtrlHelper.queryBizBills(ctx, ctrlScheme, ouid, beginDate, endDate);
            retMap.put(ouid, new Integer(billIds.size()));
        }
        return retMap;
    }

    @Override
    protected boolean _isOverspendBudget(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        String ouid;
        if (id == null) {
            return false;
        }
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.WF_APPROVE);
        String billId = id.toString();
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        String boName = BudgetCtrlHelper.getBOName(ctx, billId);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, ouid = BudgetCtrlHelper.getBillOUID(ctx, billId, boName));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return false;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, billId, boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        ctrlResultCol = this.getBgCtrlResultCol(ctx, state, ctrlParamCol, ctrlResultCol);
        if (!BudgetCtrlHelper.hasScheme(ctx, boName, id)) {
            ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        }
        Map returnData = this.getReturnBudget(ctx, billId, boName);
        ctrlResultCol = this.mergeReturnBudget(ctx, ctrlResultCol, returnData);
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        boolean isOver = false;
        try {
            isOver = !BudgetCtrlUtil.checkCtrlResultCol(ctx, ctrlScheme.isIsCanControlWithoutBudget(), false, true, ctrlResultCol);
        }
        catch (Exception e) {
            return true;
        }
        return isOver;
    }

    public static SelectorItemCollection getBgFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("CU.id");
        sic.add("CU.name");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.period");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.isFormal");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.canModify");
        sic.add("bgTemplate.parent.id");
        sic.add("bgTemplate.rootId");
        sic.add("bgTemplate.formType");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("periodType");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        return sic;
    }

    @Override
    protected boolean _requestBudgetLocalForOccupation(Context ctx, BOSUuid boId, boolean isHint) throws BOSException, BgCtrlException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.LOCAL_APPROVE);
        state.setNeedHint(isHint);
        state.setCategory(BudgetRequestCategory.CATEGORY_OCCUPATION);
        return this.requestBudget(ctx, state, boId, true);
    }

    @Override
    protected boolean _requestBudgetWFForOccupation(Context ctx, BOSUuid boId, boolean isHint) throws BOSException, BgCtrlException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.WF_APPROVE);
        state.setNeedHint(isHint);
        state.setCategory(BudgetRequestCategory.CATEGORY_OCCUPATION);
        return this.requestBudget(ctx, state, boId, true);
    }

    @Override
    protected boolean _specialApproveForOccupation(Context ctx, BOSUuid boId) throws BOSException, BgCtrlException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.SPECIAL_APPROVE);
        state.setCategory(BudgetRequestCategory.CATEGORY_OCCUPATION);
        return this.requestBudget(ctx, state, boId, false);
    }

    @Override
    protected boolean _specialApproveLocalForOccupation(Context ctx, BOSUuid boId) throws BOSException, BgCtrlException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.SPECIAL_APPROVE);
        state.setCategory(BudgetRequestCategory.CATEGORY_OCCUPATION);
        return this.requestBudget(ctx, state, boId, false);
    }

    @Override
    protected boolean _requestBudgetWFWithHint(Context ctx, BOSUuid boId) throws BOSException, BgCtrlException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.LOCAL_APPROVE);
        state.setNeedHint(true);
        state.setCategory(BudgetRequestCategory.CATEGORY_EXECUTION);
        return this.requestBudget(ctx, state, boId, true);
    }

    @Override
    protected boolean _requestBudgetLocalWithHint(Context ctx, BOSUuid boId) throws BOSException, BgCtrlException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.WF_APPROVE);
        state.setCategory(BudgetRequestCategory.CATEGORY_EXECUTION);
        state.setNeedHint(true);
        return this.requestBudget(ctx, state, boId, true);
    }

    private BgCtrlResultCollection getBgCtrlResultColBal(Context ctx, BgCtrlParamCollection ctrlParamCol, BgCtrlResultCollection ctrlResultCol) throws BOSException, EASBizException {
        BgCtrlResultCollection ctrlCol = null;
        if (ctrlParamCol != null && ctrlParamCol.size() > 0) {
            for (int i = 0; i < ctrlParamCol.size(); ++i) {
                BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
                ctrlCol = BgBalCalculator.calcuBalCol(ctx, ctrlParamInfo, true, BgGetPeriodTypeForGetBlanceEnum.Is_Control);
                ctrlResultCol.addCollection(ctrlCol);
            }
        }
        return ctrlResultCol;
    }

    @Override
    protected BgCtrlResultCollection _getUpOrgBudget(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        String boName = BudgetCtrlHelper.getBOName(ctx, billInfo);
        if (billInfo instanceof LCMConsumeBillInfo && "com.kingdee.eas.fi.lcm.app.LCMConsumeBill".equals(boName)) {
            LCMConsumeBillInfo _billInfo = (LCMConsumeBillInfo)((LCMConsumeBillInfo)billInfo).clone();
            _billInfo.remove("id");
            _billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            _billInfo.setFiVouchered(false);
            for (int i = 0; i < _billInfo.getEntry().size(); ++i) {
                _billInfo.getEntry().get(i).remove("id");
            }
            ILCMConsumeBill iBill = LCMConsumeBillFactory.getLocalInstance((Context)ctx);
            IObjectPK pk = iBill.addnew((CoreBaseInfo)_billInfo);
            IBudgetCtrlFacade iCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
            BgCtrlResultCollection ctrlResultCol = iCtrl.getUpOrgBudget(pk.toString());
            iBill.delete(pk);
            return ctrlResultCol;
        }
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        String OUID = BudgetCtrlHelper.getBillOUID(ctx, boName, billInfo);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID);
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return ctrlResultCol;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, billInfo, boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        ctrlResultCol = this.getBgCtrlResultCol(ctx, state, ctrlParamCol, ctrlResultCol);
        if (!BudgetCtrlHelper.hasScheme(ctx, boName, billInfo)) {
            ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        }
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        BudgetCtrlHelper.processCurrencyPrecision(ctx, ctrlParamCol, ctrlResultCol);
        BgCtrlResultCollection result = new BgCtrlResultCollection();
        HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (ctrlParamCol.get(i).getOrgUnitId() == null) continue;
            orgUnitMap.put(ctrlParamCol.get(i).getOrgUnitId(), null);
        }
        Map orgUnitParentMap = BudgetCtrlHelper.getParentOrgUnitMap(ctx, orgUnitMap, true, 1000);
        IPermission iPermisstion = PermissionFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            String ouid;
            Iterator it = orgUnitParentMap.keySet().iterator();
            while (it.hasNext() && orgUnitParentMap.containsKey(ouid = ctrlParamCol.get(i).getOrgUnitId())) {
                ctrlParamCol.get(i).setOrgUnitId(((CostCenterOrgUnitInfo)orgUnitParentMap.get(ouid)).getId().toString());
                ctrlParamCol.get(i).setOrgUnitName(((CostCenterOrgUnitInfo)orgUnitParentMap.get(ouid)).getName());
                try {
                    iPermisstion.checkFunctionPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()), (IObjectPK)new ObjectUuidPK(((CostCenterOrgUnitInfo)orgUnitParentMap.get(ouid)).getId().toString()), "bg_ctrlSet009_checkBudget");
                }
                catch (Exception ex) {
                    continue;
                }
                String activeBgSchemeId = BudgetCtrlHelper.getActivedBgSchemeID(ctx, ctrlParamCol.get(i), ctrlParamCol.get(i).getBizDate(), billInfo);
                if (activeBgSchemeId == null) continue;
                ctrlParamCol.get(i).setBgSchemeId(activeBgSchemeId);
                BgCtrlParamCollection upctrlParamCol = new BgCtrlParamCollection();
                upctrlParamCol.add(ctrlParamCol.get(i));
                BgCtrlResultCollection ctrlResult = new BgCtrlResultCollection();
                ctrlResult = this.getBgCtrlResultCol(ctx, state, upctrlParamCol, ctrlResult);
                if (!BudgetCtrlHelper.hasScheme(ctx, boName, billInfo)) {
                    ctrlResult = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, upctrlParamCol, ctrlResult);
                }
                ctrlResult = this.processMultiRule(ctx, upctrlParamCol, ctrlResult, ctrlScheme);
                BudgetCtrlHelper.processCurrencyPrecision(ctx, upctrlParamCol, ctrlResult);
                for (int j = ctrlResult.size() - 1; j >= 0; --j) {
                    BgCtrlResultInfo ctrlResultInfo = ctrlResult.get(j);
                    if (ctrlResultInfo.getBgDataId() == null || !StringUtils.isEmpty((String)ctrlResultInfo.getItemCombinName())) continue;
                    String itemCombinName = BudgetCtrlCacheHelper.getBgItemCombinationName(ctx, ctrlResultInfo.getItemCombinNumber(), ctrlResultInfo.getOrgUnitId());
                    ctrlResultInfo.setItemCombinName(itemCombinName);
                }
                result.addCollection(ctrlResult);
                it.next();
            }
        }
        return result;
    }

    protected BgCtrlResultCollection _getUpOrgBudget(Context ctx, IObjectValue billInfo, String orgId) throws BOSException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        String boName = BudgetCtrlHelper.getBOName(ctx, billInfo);
        if (billInfo instanceof LCMConsumeBillInfo && "com.kingdee.eas.fi.lcm.app.LCMConsumeBill".equals(boName)) {
            LCMConsumeBillInfo _billInfo = (LCMConsumeBillInfo)((LCMConsumeBillInfo)billInfo).clone();
            _billInfo.remove("id");
            _billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            _billInfo.setFiVouchered(false);
            for (int i = 0; i < _billInfo.getEntry().size(); ++i) {
                _billInfo.getEntry().get(i).remove("id");
            }
            ILCMConsumeBill iBill = LCMConsumeBillFactory.getLocalInstance((Context)ctx);
            IObjectPK pk = iBill.addnew((CoreBaseInfo)_billInfo);
            BgCtrlResultCollection ctrlResultCol = this._getUpOrgBudget(ctx, pk.toString(), orgId);
            iBill.delete(pk);
            return ctrlResultCol;
        }
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        String OUID = BudgetCtrlHelper.getBillOUID(ctx, boName, billInfo);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID);
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return ctrlResultCol;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, billInfo, boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        ctrlResultCol = this.getBgCtrlResultCol(ctx, state, ctrlParamCol, ctrlResultCol);
        if (!BudgetCtrlHelper.hasScheme(ctx, boName, billInfo)) {
            ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        }
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        BudgetCtrlHelper.processCurrencyPrecision(ctx, ctrlParamCol, ctrlResultCol);
        BgCtrlResultCollection result = new BgCtrlResultCollection();
        HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (ctrlParamCol.get(i).getOrgUnitId() == null) continue;
            orgUnitMap.put(ctrlParamCol.get(i).getOrgUnitId(), null);
        }
        Map orgUnitParentMap = BudgetCtrlHelper.getParentOrgUnitMap(ctx, orgUnitMap, true, 1000);
        IPermission iPermisstion = PermissionFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (!orgUnitParentMap.containsKey(orgId)) continue;
            ctrlParamCol.get(i).setOrgUnitId(orgId);
            String activeBgSchemeId = BudgetCtrlHelper.getActivedBgSchemeID(ctx, ctrlParamCol.get(i), ctrlParamCol.get(i).getBizDate(), billInfo);
            if (activeBgSchemeId == null) continue;
            ctrlParamCol.get(i).setBgSchemeId(activeBgSchemeId);
            BgCtrlParamCollection upctrlParamCol = new BgCtrlParamCollection();
            upctrlParamCol.add(ctrlParamCol.get(i));
            BgCtrlResultCollection ctrlResult = new BgCtrlResultCollection();
            ctrlResult = this.getBgCtrlResultCol(ctx, state, upctrlParamCol, ctrlResult);
            if (!BudgetCtrlHelper.hasScheme(ctx, boName, billInfo)) {
                ctrlResult = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, upctrlParamCol, ctrlResult);
            }
            ctrlResult = this.processMultiRule(ctx, upctrlParamCol, ctrlResult, ctrlScheme);
            BudgetCtrlHelper.processCurrencyPrecision(ctx, upctrlParamCol, ctrlResult);
            result.addCollection(ctrlResult);
        }
        return result;
    }

    protected BgCtrlResultCollection _getUpOrgBudget(Context ctx, BOSUuid boID, String orgId) throws BOSException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        String boName = BudgetCtrlHelper.getBOName(ctx, boID);
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        String OUID = BudgetCtrlHelper.getBillOUID(ctx, boID.toString(), boName);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID);
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return ctrlResultCol;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, boID.toString(), boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        ctrlResultCol = this.getBgCtrlResultCol(ctx, state, ctrlParamCol, ctrlResultCol);
        if (!BudgetCtrlHelper.hasScheme(ctx, boName, boID)) {
            ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        }
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        BudgetCtrlHelper.processCurrencyPrecision(ctx, ctrlParamCol, ctrlResultCol);
        BgCtrlResultCollection result = new BgCtrlResultCollection();
        HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (ctrlParamCol.get(i).getOrgUnitId() == null) continue;
            orgUnitMap.put(ctrlParamCol.get(i).getOrgUnitId(), null);
        }
        Map orgUnitParentMap = BudgetCtrlHelper.getParentOrgUnitMap(ctx, orgUnitMap, true, 1000);
        IPermission iPermisstion = PermissionFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (!orgUnitParentMap.containsKey(orgId)) continue;
            ctrlParamCol.get(i).setOrgUnitId(orgId);
            String activeBgSchemeId = BudgetCtrlHelper.getActivedBgSchemeID(ctx, ctrlParamCol.get(i), ctrlParamCol.get(i).getBizDate(), boName, boID.toString());
            if (activeBgSchemeId == null) continue;
            ctrlParamCol.get(i).setBgSchemeId(activeBgSchemeId);
            BgCtrlParamCollection upctrlParamCol = new BgCtrlParamCollection();
            upctrlParamCol.add(ctrlParamCol.get(i));
            BgCtrlResultCollection ctrlResult = new BgCtrlResultCollection();
            ctrlResult = this.getBgCtrlResultCol(ctx, state, upctrlParamCol, ctrlResult);
            if (!BudgetCtrlHelper.hasScheme(ctx, boName, boID)) {
                ctrlResult = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, upctrlParamCol, ctrlResult);
            }
            ctrlResult = this.processMultiRule(ctx, upctrlParamCol, ctrlResult, ctrlScheme);
            BudgetCtrlHelper.processCurrencyPrecision(ctx, upctrlParamCol, ctrlResult);
            result.addCollection(ctrlResult);
        }
        return result;
    }

    protected BgCtrlResultCollection _getUpOrgBudget(Context ctx, String boId, String orgID) throws BOSException, EASBizException {
        String OUID;
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        String boName = BudgetCtrlHelper.getBOName(ctx, boId);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID = BudgetCtrlHelper.getBillOUID(ctx, boId.toString(), boName));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return ctrlResultCol;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, boId.toString(), boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        if (!BudgetCtrlHelper.hasScheme(ctx, boName, BOSUuid.read((String)boId))) {
            ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        }
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        BudgetCtrlHelper.processCurrencyPrecision(ctx, ctrlParamCol, ctrlResultCol);
        BgCtrlResultCollection result = new BgCtrlResultCollection();
        HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (ctrlParamCol.get(i).getOrgUnitId() == null) continue;
            orgUnitMap.put(ctrlParamCol.get(i).getOrgUnitId(), null);
        }
        Map orgUnitParentMap = BudgetCtrlHelper.getParentOrgUnitMap(ctx, orgUnitMap, true, 1000);
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (!orgUnitParentMap.containsKey(orgID)) continue;
            ctrlParamCol.get(i).setOrgUnitId(orgID);
            String activeBgSchemeId = BudgetCtrlHelper.getActivedBgSchemeID(ctx, ctrlParamCol.get(i), ctrlParamCol.get(i).getBizDate(), boName, boId);
            if (activeBgSchemeId == null) continue;
            ctrlParamCol.get(i).setBgSchemeId(activeBgSchemeId);
            BgCtrlParamCollection upctrlParamCol = new BgCtrlParamCollection();
            upctrlParamCol.add(ctrlParamCol.get(i));
            BgCtrlResultCollection ctrlResult = new BgCtrlResultCollection();
            ctrlResult = this.getBgCtrlResultCol(ctx, state, upctrlParamCol, ctrlResult);
            if (!BudgetCtrlHelper.hasScheme(ctx, boName, BOSUuid.read((String)boId))) {
                ctrlResult = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, upctrlParamCol, ctrlResult);
            }
            ctrlResult = this.processMultiRule(ctx, upctrlParamCol, ctrlResult, ctrlScheme);
            BudgetCtrlHelper.processCurrencyPrecision(ctx, upctrlParamCol, ctrlResult);
            result.addCollection(ctrlResult);
        }
        return result;
    }

    @Override
    protected BgCtrlResultCollection _getUpOrgBudget(Context ctx, String boId) throws BOSException, EASBizException {
        String OUID;
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        String boName = BudgetCtrlHelper.getBOName(ctx, boId);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID = BudgetCtrlHelper.getBillOUID(ctx, boId.toString(), boName));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return ctrlResultCol;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, boId.toString(), boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        if (!BudgetCtrlHelper.hasScheme(ctx, boName, BOSUuid.read((String)boId))) {
            ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        }
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        BudgetCtrlHelper.processCurrencyPrecision(ctx, ctrlParamCol, ctrlResultCol);
        BgCtrlResultCollection result = new BgCtrlResultCollection();
        HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (ctrlParamCol.get(i).getOrgUnitId() == null) continue;
            orgUnitMap.put(ctrlParamCol.get(i).getOrgUnitId(), null);
        }
        Map orgUnitParentMap = BudgetCtrlHelper.getParentOrgUnitMap(ctx, orgUnitMap, true, 1000);
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            String ouid;
            Iterator it = orgUnitParentMap.keySet().iterator();
            while (it.hasNext() && orgUnitParentMap.containsKey(ouid = ctrlParamCol.get(i).getOrgUnitId())) {
                ctrlParamCol.get(i).setOrgUnitId(((CostCenterOrgUnitInfo)orgUnitParentMap.get(ouid)).getId().toString());
                ctrlParamCol.get(i).setOrgUnitName(((CostCenterOrgUnitInfo)orgUnitParentMap.get(ouid)).getName());
                String activeBgSchemeId = BudgetCtrlHelper.getActivedBgSchemeID(ctx, ctrlParamCol.get(i), ctrlParamCol.get(i).getBizDate(), boName, boId);
                if (activeBgSchemeId == null) continue;
                ctrlParamCol.get(i).setBgSchemeId(activeBgSchemeId);
                BgCtrlParamCollection upctrlParamCol = new BgCtrlParamCollection();
                upctrlParamCol.add(ctrlParamCol.get(i));
                BgCtrlResultCollection ctrlResult = new BgCtrlResultCollection();
                ctrlResult = this.getBgCtrlResultCol(ctx, state, upctrlParamCol, ctrlResult);
                if (!BudgetCtrlHelper.hasScheme(ctx, boName, BOSUuid.read((String)boId))) {
                    ctrlResult = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, upctrlParamCol, ctrlResult);
                }
                ctrlResult = this.processMultiRule(ctx, upctrlParamCol, ctrlResult, ctrlScheme);
                BudgetCtrlHelper.processCurrencyPrecision(ctx, upctrlParamCol, ctrlResult);
                result.addCollection(ctrlResult);
                it.next();
            }
        }
        return result;
    }

    @Override
    protected Map _checkBudget(Context ctx, IObjectValue billInfo, String org) throws BOSException, BgCtrlException, EASBizException {
        Map returnDataMap;
        HashMap result = new HashMap();
        result.put("result", "1");
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        String boName = BudgetCtrlHelper.getBOName(ctx, billInfo);
        String OUID = BudgetCtrlHelper.getBillOUID(ctx, boName, billInfo);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID);
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return result;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, billInfo, boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        HashMap<String, BigDecimal> checkmap = new HashMap<String, BigDecimal>();
        HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (ctrlParamCol.get(i).getOrgUnitId() == null) continue;
            orgUnitMap.put(ctrlParamCol.get(i).getOrgUnitId(), null);
        }
        Map orgUnitParentMap = BudgetCtrlHelper.getParentOrgUnitMap(ctx, orgUnitMap, true, 1000);
        if (!(org.equals("") || org == null || orgUnitParentMap != null && orgUnitParentMap.size() >= 1)) {
            result.put("result", "-3");
        }
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            Iterator it = orgUnitParentMap.keySet().iterator();
            while (it.hasNext()) {
                String ouid = ctrlParamCol.get(i).getOrgUnitId();
                if (orgUnitParentMap.containsKey(ouid)) {
                    ouid = ((CostCenterOrgUnitInfo)orgUnitParentMap.get(ouid)).getId().toString();
                    continue;
                }
                checkmap.put(ouid, new BigDecimal("0"));
            }
        }
        if (checkmap.size() > 1) {
            result.put(result, "-1");
            return result;
        }
        BgCtrlResultCollection ctrlResultCol = org.equals("") || org == null ? this._getBudget(ctx, billInfo) : this._getUpOrgBudget(ctx, billInfo, org);
        if ("com.kingdee.eas.fi.gl.app.Voucher".equals(boName) && billInfo.get("id") != null && (returnDataMap = this.getReturnBudget(ctx, ((BOSUuid)billInfo.get("id")).toString(), boName)) != null && !returnDataMap.isEmpty() && ctrlResultCol != null && !ctrlResultCol.isEmpty()) {
            BgCtrlResultInfo ctrlResultInfo = null;
            String bgDataId = null;
            BigDecimal actualAmount = null;
            for (int i = 0; i < ctrlResultCol.size(); ++i) {
                ctrlResultInfo = ctrlResultCol.get(i);
                bgDataId = ctrlResultInfo.getBgDataId();
                if (!returnDataMap.containsKey(bgDataId)) continue;
                actualAmount = (BigDecimal)returnDataMap.get(bgDataId);
                ctrlResultInfo.setBizActual(ctrlResultInfo.getBizActual().add(actualAmount.multiply(BudgetCtrlConstants.NEG_ONE_AMOUNT)));
                ctrlResultInfo.setBalance(ctrlResultInfo.getBalance().add(actualAmount));
            }
        }
        result = (HashMap)BudgetCtrlHelper.checkBudgetValue(ctx, state, ctrlResultCol, ctrlParamCol, ctrlScheme, org);
        String upOrgId = "";
        upOrgId = !org.equals("") && org != null ? ctrlParamCol.get(0).getOrgUnitId() : org;
        if (orgUnitParentMap.containsKey(upOrgId)) {
            upOrgId = ((CostCenterOrgUnitInfo)orgUnitParentMap.get(upOrgId)).getId().toString();
        }
        result.put("uporg", upOrgId);
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            result.put(result, "-5");
        }
        return result;
    }

    @Override
    protected Map _checkBudget(Context ctx, BOSUuid boId, String orgId) throws BOSException, BgCtrlException, EASBizException {
        Map returnDataMap;
        if (orgId == null) {
            orgId = "";
        }
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        HashMap result = new HashMap();
        result.put("result", "1");
        String boName = BudgetCtrlHelper.getBOName(ctx, boId);
        String OUID = BudgetCtrlHelper.getBillOUID(ctx, boId.toString(), boName);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID);
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return result;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, boId.toString(), boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        HashMap<String, BigDecimal> checkmap = new HashMap<String, BigDecimal>();
        HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (ctrlParamCol.get(i).getOrgUnitId() == null) continue;
            orgUnitMap.put(ctrlParamCol.get(i).getOrgUnitId(), null);
        }
        Map orgUnitParentMap = BudgetCtrlHelper.getParentOrgUnitMap(ctx, orgUnitMap, true, 1000);
        if (!(orgId.equals("") || orgId == null || orgUnitParentMap != null && orgUnitParentMap.size() >= 1)) {
            result.put("result", "-3");
        }
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            Iterator it = orgUnitParentMap.keySet().iterator();
            while (it.hasNext()) {
                String ouid = ctrlParamCol.get(i).getOrgUnitId();
                if (orgUnitParentMap.containsKey(ouid)) {
                    ouid = ((CostCenterOrgUnitInfo)orgUnitParentMap.get(ouid)).getId().toString();
                } else {
                    checkmap.put(ouid, new BigDecimal("0"));
                }
                it.next();
            }
        }
        if (checkmap.size() > 1) {
            result.put(result, "-1");
            return result;
        }
        BgCtrlResultCollection ctrlResultCol = orgId.equals("") || orgId == null ? this._getBudget(ctx, boId) : this._getUpOrgBudget(ctx, boId, orgId);
        state.setNeedHint(true);
        if ("com.kingdee.eas.fi.gl.app.Voucher".equals(boName) && boId.toString() != null && (returnDataMap = this.getReturnBudget(ctx, boId.toString(), boName)) != null && !returnDataMap.isEmpty() && ctrlResultCol != null && !ctrlResultCol.isEmpty()) {
            BgCtrlResultInfo ctrlResultInfo = null;
            String bgDataId = null;
            BigDecimal actualAmount = null;
            for (int i = 0; i < ctrlResultCol.size(); ++i) {
                ctrlResultInfo = ctrlResultCol.get(i);
                bgDataId = ctrlResultInfo.getBgDataId();
                if (!returnDataMap.containsKey(bgDataId)) continue;
                actualAmount = (BigDecimal)returnDataMap.get(bgDataId);
                ctrlResultInfo.setBizActual(ctrlResultInfo.getBizActual().add(actualAmount.multiply(BudgetCtrlConstants.NEG_ONE_AMOUNT)));
                ctrlResultInfo.setBalance(ctrlResultInfo.getBalance().add(actualAmount));
            }
        }
        result = (HashMap)BudgetCtrlHelper.checkBudgetValue(ctx, state, ctrlResultCol, ctrlParamCol, ctrlScheme, orgId);
        String upOrgId = "";
        if (orgId == null || orgId.equals("")) {
            BgCtrlParamInfo paramInfo = ctrlParamCol != null ? ctrlParamCol.get(0) : null;
            upOrgId = paramInfo != null ? paramInfo.getOrgUnitId() : "";
        } else {
            upOrgId = orgId;
        }
        if (orgUnitParentMap != null && orgUnitParentMap.containsKey(upOrgId)) {
            CostCenterOrgUnitInfo cco = (CostCenterOrgUnitInfo)orgUnitParentMap.get(upOrgId);
            upOrgId = cco.getId() != null ? cco.getId().toString() : "";
        }
        result.put("uporg", upOrgId);
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            result.put("result", "-5");
        }
        return result;
    }

    protected BgCtrlResultCollection _getBudget(Context ctx, BOSUuid boId) throws BOSException, EASBizException {
        String OUID;
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        String boName = BudgetCtrlHelper.getBOName(ctx, boId);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID = BudgetCtrlHelper.getBillOUID(ctx, boId.toString(), boName));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return ctrlResultCol;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, boId.toString(), boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        ctrlResultCol = this.getBgCtrlResultCol(ctx, state, ctrlParamCol, ctrlResultCol);
        if (!BudgetCtrlHelper.hasScheme(ctx, boName, boId)) {
            ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        }
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        BudgetCtrlHelper.processCurrencyPrecision(ctx, ctrlParamCol, ctrlResultCol);
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            ctrlResultInfo.setSchemeAllowAccess(ctrlScheme.isIsAllowExcess());
            ctrlResultInfo.setCanControlWithoutBudget(ctrlScheme.isIsCanControlWithoutBudget());
        }
        return ctrlResultCol;
    }

    protected BgCtrlResultCollection _getUpOrgBudget(Context ctx, BOSUuid boId) throws BOSException, EASBizException {
        String OUID;
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        String boName = BudgetCtrlHelper.getBOName(ctx, boId);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID = BudgetCtrlHelper.getBillOUID(ctx, boId.toString(), boName));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return ctrlResultCol;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, boId.toString(), boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        if (!BudgetCtrlHelper.hasScheme(ctx, boName, boId)) {
            ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        }
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        BudgetCtrlHelper.processCurrencyPrecision(ctx, ctrlParamCol, ctrlResultCol);
        BgCtrlResultCollection result = new BgCtrlResultCollection();
        HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (ctrlParamCol.get(i).getOrgUnitId() == null) continue;
            orgUnitMap.put(ctrlParamCol.get(i).getOrgUnitId(), null);
        }
        Map orgUnitParentMap = BudgetCtrlHelper.getParentOrgUnitMap(ctx, orgUnitMap, true, 1000);
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            String ouid;
            Iterator it = orgUnitParentMap.keySet().iterator();
            while (it.hasNext() && orgUnitParentMap.containsKey(ouid = ctrlParamCol.get(i).getOrgUnitId())) {
                ctrlParamCol.get(i).setOrgUnitId(((CostCenterOrgUnitInfo)orgUnitParentMap.get(ouid)).getId().toString());
                ctrlParamCol.get(i).setOrgUnitName(((CostCenterOrgUnitInfo)orgUnitParentMap.get(ouid)).getName());
                String activeBgSchemeId = BudgetCtrlHelper.getActivedBgSchemeID(ctx, ctrlParamCol.get(i), ctrlParamCol.get(i).getBizDate(), boName, boId.toString());
                if (activeBgSchemeId == null) continue;
                ctrlParamCol.get(i).setBgSchemeId(activeBgSchemeId);
                BgCtrlParamCollection upctrlParamCol = new BgCtrlParamCollection();
                upctrlParamCol.add(ctrlParamCol.get(i));
                BgCtrlResultCollection ctrlResult = new BgCtrlResultCollection();
                ctrlResult = this.getBgCtrlResultCol(ctx, state, upctrlParamCol, ctrlResult);
                if (!BudgetCtrlHelper.hasScheme(ctx, boName, boId)) {
                    ctrlResult = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, upctrlParamCol, ctrlResult);
                }
                ctrlResult = this.processMultiRule(ctx, upctrlParamCol, ctrlResult, ctrlScheme);
                BudgetCtrlHelper.processCurrencyPrecision(ctx, upctrlParamCol, ctrlResult);
                result.addCollection(ctrlResult);
            }
        }
        return result;
    }

    @Override
    protected Map _checkBudgetAccess(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        Map returnDataMap;
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.GET_BUDGET);
        BgControlCaller call = new BgControlCaller();
        call.checkBudget(ctx, billInfo);
        Map<String, Boolean> resMap = new HashMap<String, Boolean>();
        String boName = BudgetCtrlHelper.getBOName(ctx, billInfo);
        String OUID = BudgetCtrlHelper.getBillOUID(ctx, boName, billInfo);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID);
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            resMap.put("hasControlScheme", Boolean.FALSE);
            return resMap;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, billInfo, boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        BgCtrlResultCollection ctrlResultCol = this.getBudget(ctx, billInfo);
        if ("com.kingdee.eas.fi.gl.app.Voucher".equals(boName) && billInfo.get("id") != null && (returnDataMap = this.getReturnBudget(ctx, ((BOSUuid)billInfo.get("id")).toString(), boName)) != null && !returnDataMap.isEmpty() && ctrlResultCol != null && !ctrlResultCol.isEmpty()) {
            BgCtrlResultInfo ctrlResultInfo = null;
            String bgDataId = null;
            BigDecimal actualAmount = null;
            for (int i = 0; i < ctrlResultCol.size(); ++i) {
                ctrlResultInfo = ctrlResultCol.get(i);
                bgDataId = ctrlResultInfo.getBgDataId();
                if (!returnDataMap.containsKey(bgDataId)) continue;
                actualAmount = (BigDecimal)returnDataMap.get(bgDataId);
                ctrlResultInfo.setBizActual(ctrlResultInfo.getBizActual().add(actualAmount.multiply(BudgetCtrlConstants.NEG_ONE_AMOUNT)));
                ctrlResultInfo.setBalance(ctrlResultInfo.getBalance().add(actualAmount));
            }
        }
        resMap = BudgetCtrlHelper.checkBudgetAccess(ctx, state, ctrlResultCol, ctrlParamCol, ctrlScheme);
        resMap.put("hasControlScheme", Boolean.TRUE);
        return resMap;
    }

    @Override
    protected void _specialApproveLocal(Context ctx, BOSUuid boId) throws BOSException, BgCtrlException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.SPECIAL_APPROVE);
        state.setCategory(BudgetRequestCategory.CATEGORY_EXECUTION);
        this.requestBudget(ctx, state, boId, false);
    }

    @Override
    protected void _collectCtrlResult(Context ctx, List ctrlRecordIds) throws BOSException, EASBizException {
        if (ctrlRecordIds == null || ctrlRecordIds.isEmpty()) {
            return;
        }
        BgCtrlResultCollection col = this.getCtrlResultCol(ctx, ctrlRecordIds, "FID", false);
        this.setCtrlResultOtherInfo(ctx, col);
        this.collectCtrlResultCol(ctx, col);
    }

    private void collectCtrlResultCol(Context ctx, BgCtrlResultCollection col) throws BOSException, EASBizException {
        if (col == null || col.isEmpty()) {
            return;
        }
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.WF_APPROVE);
        List ctrlRecordIds = this.getCtrlRecordIds(col);
        this.setCollectedFlag(ctx, ctrlRecordIds);
        this.collectCtrlDataImmediately(ctx, state, col);
    }

    private void setCollectedFlag(Context ctx, List ctrlRecordIds) throws BOSException {
        int index = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgCtrlRecord set FIsCollected = 1 where FId = ? ");
            int jn = ctrlRecordIds.size();
            for (int j = 0; j < jn; ++j) {
                pstmt.setString(1, (String)ctrlRecordIds.get(j));
                pstmt.addBatch();
                if (++index <= 200) continue;
                pstmt.executeBatch();
                index = 0;
            }
            if (index != 0) {
                pstmt.executeBatch();
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"error", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private List getCtrlRecordIds(BgCtrlResultCollection col) {
        if (col == null || col.isEmpty()) {
            return null;
        }
        ArrayList<String> ctrlRecordIds = new ArrayList<String>();
        for (int i = 0; i < col.size(); ++i) {
            ctrlRecordIds.add(col.get(i).getId().toString());
            col.get(i).setId(null);
        }
        return ctrlRecordIds;
    }

    @Override
    protected List _getNeedCollectCtrlRecords(Context ctx) throws BOSException, EASBizException {
        List billIds = this.getNeedCollectBillIds(ctx);
        BgCtrlResultCollection col = this.getCtrlResultCol(ctx, billIds, "FBillID", true);
        return this.getCtrlRecordIds(col);
    }

    private List getNeedCollectBillIds(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> billIds = new ArrayList<String>();
        String queryBill = "select FBillID from T_BG_BgCtrlRecord where FBgTraceType = 3 and FIsCollected = 0 group by FBillID";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(queryBill);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                billIds.add(rst.getString("FBillID"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return billIds;
    }

    private void setCtrlResultOtherInfo(Context ctx, BgCtrlResultCollection col) throws BOSException, EASBizException {
        if (col == null || col.isEmpty()) {
            return;
        }
        HashSet<String> bgDataIds = new HashSet<String>();
        for (int i = 0; i < col.size(); ++i) {
            bgDataIds.add(col.get(i).getBgDataId());
        }
        String[] bgFormula = null;
        HashMap<String, String[]> bgDataIdMap = new HashMap<String, String[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FOrgUnitId, FBgSchemeId, FFormula from T_BG_BgData where FID IN (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Object[] params = bgDataIds.toArray();
        int batchCount = (params.length - 1) / 200 + 1;
        conn = this.getConnection(ctx);
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < batchCount; ++i) {
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)i, (int)200, (Object[])params);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgFormula = new String[]{rst.getString("FID"), rst.getString("FOrgUnitId"), rst.getString("FBgSchemeId"), rst.getString("FFormula")};
                    bgDataIdMap.put(bgFormula[0], bgFormula);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
            bgDataIds.clear();
        }
        BgCtrlResultInfo ctrlResultInfo = null;
        int in = col.size();
        for (int i = 0; i < in; ++i) {
            ctrlResultInfo = col.get(i);
            if (!bgDataIdMap.containsKey(col.get(i).getBgDataId())) continue;
            bgFormula = (String[])bgDataIdMap.get(ctrlResultInfo.getBgDataId());
            ctrlResultInfo.setOrgUnitId(bgFormula[1]);
            ctrlResultInfo.setBgSchemeId(bgFormula[2]);
            ctrlResultInfo.setBgItemFormula(bgFormula[3]);
        }
        bgDataIdMap.clear();
    }

    private BgCtrlResultCollection getCtrlResultCol(Context ctx, List param, String fieldName, boolean isOnlyId) throws BOSException, EASBizException {
        if (param == null || param.isEmpty()) {
            return null;
        }
        BgCtrlResultCollection col = new BgCtrlResultCollection();
        BgCtrlResultInfo ctrlResultInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select cr.FId           AS bgCtrlRecordId");
        if (!isOnlyId) {
            sql.append(",        cr.FBgDataId     AS bgDataId");
            sql.append(",        cr.FBillId       AS billId");
            sql.append(",        cr.FBillNumber   AS billNumber");
            sql.append(",        cr.FActualAmount AS requestAmt");
            sql.append(",        cr.FBillType     AS billType");
            sql.append(",        cr.FBizDate      AS bizDate");
            sql.append(",        cr.FItemName     AS itemName");
            sql.append(",        cr.FActualType   AS actualType");
            sql.append(",        cr.FBillSourceOrgunitID   AS billSourceOrgunitID,");
            sql.append(" cr.FBgPeriodId AS bgPeriodId");
        }
        sql.append(" from T_BG_BgCtrlRecord cr ");
        sql.append(" where cr.FIsCollected = 0 and cr.FBgTraceType = ").append(3);
        sql.append(" and cr." + fieldName + " IN (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            Object[] params = param.toArray();
            int batchCount = (params.length - 1) / 200 + 1;
            for (int i = 0; i < batchCount; ++i) {
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)i, (int)200, (Object[])params);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    ctrlResultInfo = new BgCtrlResultInfo();
                    ctrlResultInfo.setId(BOSUuid.read((String)rst.getString("bgCtrlRecordId")));
                    if (!isOnlyId) {
                        ctrlResultInfo.setBgDataId(rst.getString("bgDataId"));
                        ctrlResultInfo.setBillId(rst.getString("billId"));
                        ctrlResultInfo.setBillNumber(rst.getString("billNumber"));
                        ctrlResultInfo.setReqAmount(rst.getBigDecimal("requestAmt"));
                        ctrlResultInfo.setBillType(rst.getString("billType"));
                        ctrlResultInfo.setBizDate(rst.getTimestamp("bizDate"));
                        ctrlResultInfo.setItemName(rst.getString("itemName"));
                        ctrlResultInfo.setActualType(ActualTypeEnum.getEnum(rst.getInt("actualType")));
                        ctrlResultInfo.setBillSourceOrgunitID(rst.getString("billSourceOrgunitID"));
                        ctrlResultInfo.setBgPeriodNumber(rst.getString("bgPeriodId"));
                    }
                    col.add(ctrlResultInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return col;
    }

    @Override
    protected List _requestBudgetWFWithMessage(Context ctx, BOSUuid boId) throws BOSException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.WF_APPROVE);
        return this.requestBudgetWithMessage(ctx, state, boId, true);
    }

    private List requestBudgetWithMessage(Context ctx, BudgetCtrlState state, BOSUuid boId, boolean isCheckBalance) throws BOSException, EASBizException {
        boolean isBackgroundCollect;
        BgCtrlMonitorInfo bgCtrlMonitor = new BgCtrlMonitorInfo();
        bgCtrlMonitor.setBillID(boId.toString());
        bgCtrlMonitor.setCreateTime(new Date(System.currentTimeMillis()));
        ArrayList<BgOverspendInfo> overspendList = new ArrayList<BgOverspendInfo>();
        BgOverspendInfo bgOverspend = new BgOverspendInfo();
        bgOverspend.setIsAudit("true");
        overspendList.add(bgOverspend);
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        boolean isNeedLog = false;
        String boName = BudgetCtrlHelper.getBOName(ctx, boId);
        bgCtrlMonitor.setBoName(boName);
        if (BudgetCtrlHelper.isCPBCBill(boName)) {
            isNeedLog = true;
        }
        String ouid = BudgetCtrlHelper.getBillOUID(ctx, boId.toString(), boName);
        bgCtrlMonitor.setBillOrgID(ouid);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, ouid);
        if (isNeedLog) {
            logger.info((Object)("---requestBudgetLog---\nboId = " + boId.toString() + ", ouId = " + ouid));
        }
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            throw new BgCtrlException(BgCtrlException.NOCTRLSCHEME);
        }
        bgCtrlMonitor.setCtrlSchemeID(ctrlScheme.getId().toString());
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, boId.toString(), boName, ctrlScheme);
        this.transCentralizedOrgUnitId(ctx, ctrlParamCol);
        this.recordCtrlParam(ctrlParamCol, bgCtrlMonitor);
        IBudgetCtrlFacade iCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
        iCtrl.lockCostCentersTransaction(ctrlParamCol);
        ctrlResultCol = "yes".equals(ctx.get((Object)"hint")) ? this.getBgCtrlResultColBal(ctx, ctrlParamCol, ctrlResultCol) : this.getBgCtrlResultCol(ctx, state, ctrlParamCol, ctrlResultCol);
        if (!BudgetCtrlHelper.hasScheme(ctx, boName, boId)) {
            ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        }
        Map returnData = this.getReturnBudget(ctx, boId.toString(), boName);
        ctrlResultCol = this.mergeReturnBudget(ctx, ctrlResultCol, returnData);
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        List<BgOverspendInfo> list = overspendList = isCheckBalance ? BudgetCtrlHelper.checkBudgetWihtMessage(ctx, ctrlResultCol, ctrlParamCol, ctrlScheme) : overspendList;
        if (!"true".equals(((BgOverspendInfo)overspendList.get(0)).getIsAudit())) {
            bgCtrlMonitor.setPass(false);
            if (BgNSHelper.isMonitorBgCtrl((Context)ctx)) {
                this.saveBgCtrlMonitorInfo(ctx, bgCtrlMonitor);
            }
            return overspendList;
        }
        bgCtrlMonitor.setPass(true);
        ctrlResultCol = BudgetCtrlHelper.getSuperiorItemCtrlData(ctx, ctrlResultCol);
        this.recordBgDataInfo(ctrlResultCol, bgCtrlMonitor);
        Map bgDataMap = BudgetCtrlHelper.getBgDataMap(ctx, ctrlResultCol, returnData);
        iCtrl.writeCtrlData(boId.toString(), boName, ctrlResultCol, bgDataMap);
        if (isNeedLog) {
            BudgetCtrlLogger.logRequestBudget(ctx, state == null ? BudgetRequestType.WF_APPROVE : state.getRequestType(), ctrlResultCol);
        }
        if (!(isBackgroundCollect = BgNSHelper.getBG028_queueBgCtrl((Context)ctx))) {
            this.collectCtrlDataImmediately(ctx, state, ctrlResultCol);
        }
        if (BgNSHelper.isMonitorBgCtrl((Context)ctx)) {
            this.saveBgCtrlMonitorInfo(ctx, bgCtrlMonitor);
        }
        return overspendList;
    }

    private void recordCtrlParam(BgCtrlParamCollection ctrlParamCol, BgCtrlMonitorInfo bgCtrlMonitor) {
        if (ctrlParamCol != null && ctrlParamCol.size() > 0) {
            StringBuffer sb = new StringBuffer();
            BgCtrlParamInfo info = null;
            for (int i = 0; i < ctrlParamCol.size(); ++i) {
                info = ctrlParamCol.get(i);
                sb.append(info.getOrgUnitId() + "|");
                sb.append(info.getBgSchemeId() + "|");
                sb.append(info.getItemFormula() + "|");
                sb.append(info.getAmount().doubleValue());
                if (i == ctrlParamCol.size() - 1) continue;
                sb.append(",");
            }
            bgCtrlMonitor.setRequestInfo(sb.toString());
        }
    }

    private void recordBgDataInfo(BgCtrlResultCollection ctrlResultCol, BgCtrlMonitorInfo bgCtrlMonitor) {
        try {
            if (ctrlResultCol != null && ctrlResultCol.size() > 0) {
                StringBuffer sb = new StringBuffer();
                BgCtrlResultInfo info = null;
                for (int i = 0; i < ctrlResultCol.size(); ++i) {
                    info = ctrlResultCol.get(i);
                    if (info.getBgDataId() == null) {
                        sb.append(info.getBgDataId() + "|");
                        sb.append(info.getBgItemFormula());
                        if (i == ctrlResultCol.size() - 1) continue;
                        sb.append(",");
                        continue;
                    }
                    sb.append(info.getBgDataId() + "|");
                    sb.append(info.getBgItemFormula() + "|");
                    if (info.getBizActual() != null) {
                        sb.append(info.getBizActual().divide(new BigDecimal("1.0000"), 4, 1) + "|");
                    }
                    sb.append(this.getBgBalance(info));
                    if (i == ctrlResultCol.size() - 1) continue;
                    sb.append(",");
                }
                bgCtrlMonitor.setBgDataInfo(sb.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getBgBalance(BgCtrlResultInfo info) {
        String msg = null;
        try {
            if (info.isIsMultiRuleCtrl()) {
                String showBalance;
                BigDecimal realBalance = info.getMultiRuleCtrlResult().getBalance().divide(new BigDecimal("1.0000"), 4, 1);
                BigDecimal multiRuleBalance = info.getBalance().divide(new BigDecimal("1.0000"), 4, 1);
                msg = showBalance = String.valueOf(realBalance) + "(" + String.valueOf(multiRuleBalance) + ")";
            } else {
                msg = info.getBalance().divide(new BigDecimal("1.0000"), 4, 1).doubleValue() + "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveBgCtrlMonitorInfo(Context ctx, BgCtrlMonitorInfo info) {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into T_BG_BgCtrlMonitor(FID,FBillID,FBillOrgID,FBoName,FCreateTime,FCtrlSchemeID,FRequestInfo,FBgDataInfo,FIsPass)");
        sb.append(" values(?,?,?,?,?,?,?,?,?)");
        int maxLen = 3000;
        Connection conn = null;
        PreparedStatement ps = null;
        String reqInfo = null;
        String bgDataInfo = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sb.toString());
            ps.setString(1, info.getID());
            ps.setString(2, info.getBillID());
            ps.setString(3, info.getBillOrgID());
            ps.setString(4, info.getBoName());
            ps.setTimestamp(5, new Timestamp(info.getCreateTime().getTime()));
            ps.setString(6, info.getCtrlSchemeID());
            reqInfo = info.getRequestInfo();
            if (reqInfo != null && reqInfo.length() > maxLen) {
                reqInfo = reqInfo.substring(0, maxLen - 1);
            }
            ps.setString(7, reqInfo);
            bgDataInfo = info.getBgDataInfo();
            if (bgDataInfo != null && bgDataInfo.length() > maxLen) {
                bgDataInfo = bgDataInfo.substring(0, maxLen - 1);
            }
            ps.setString(8, bgDataInfo);
            ps.setInt(9, info.isPass() ? 1 : 0);
            ps.execute();
        }
        catch (Exception exception) {
            SQLUtils.cleanup(ps, (Connection)conn);
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected Map _getCombinItems(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        String OUID;
        if (ctx == null || billId == null) {
            return null;
        }
        String _billId = billId.toString();
        String boName = BudgetCtrlHelper.getBOName(ctx, billId);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID = BudgetCtrlHelper.getBillOUID(ctx, _billId, boName));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return null;
        }
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.LOCAL_APPROVE);
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, _billId, boName, ctrlScheme);
        return this.getCombinItems(ctx, ctrlScheme, ctrlParamCol);
    }

    @Override
    protected Map _getCombinItems(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String OUID;
        if (ctx == null || model == null) {
            return null;
        }
        String boName = BudgetCtrlHelper.getBOName(ctx, model);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, OUID = BudgetCtrlHelper.getBillOUID(ctx, boName, model));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return null;
        }
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.LOCAL_APPROVE);
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, state, model, boName, ctrlScheme);
        return this.getCombinItems(ctx, ctrlScheme, ctrlParamCol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Set<String[]>> getCombinItems(Context ctx, BgControlSchemeInfo ctrlScheme, BgCtrlParamCollection ctrlParamCol) throws BOSException, EASBizException {
        if (ctx == null) return null;
        if (ctrlScheme == null) return null;
        if (ctrlParamCol == null) return null;
        if (ctrlParamCol.isEmpty()) {
            return null;
        }
        BgControlItemMapInfo mapInfo = null;
        BgControlItemMapCollection mapCol = ctrlScheme.getItemMap();
        HashMap mapping = new HashMap();
        List<BgControlItemMapInfo> mapList = null;
        int in = mapCol.size();
        for (int i = 0; i < in; ++i) {
            mapInfo = mapCol.get(i);
            if (mapping.containsKey(mapInfo.getBgItemCombinKey())) {
                mapList = (List)mapping.get(mapInfo.getBgItemCombinKey());
            } else {
                mapList = new ArrayList();
                mapping.put(mapInfo.getBgItemCombinKey(), mapList);
            }
            mapList.add(mapInfo);
        }
        String tmpKey = null;
        String orgUnitId = null;
        String bgSchemeId = null;
        String itemNumber = null;
        String _itemNumber = null;
        String[] tmpStrs = null;
        BgCtrlParamInfo ctrlParam = null;
        HashMap formulaMap = new HashMap();
        HashMap<String, String> ctrlMap = new HashMap<String, String>();
        Set<String> formulaSet = null;
        int in2 = ctrlParamCol.size();
        for (int i = 0; i < in2; ++i) {
            ctrlParam = ctrlParamCol.get(i);
            ctrlMap.put(ctrlParam.getItemFormula(), ctrlParam.getBillItemOql());
            tmpKey = ctrlParam.getOrgUnitId() + "_" + ctrlParam.getBgSchemeId();
            if (formulaMap.containsKey(tmpKey)) {
                formulaSet = (Set)formulaMap.get(tmpKey);
            } else {
                formulaSet = new HashSet();
                formulaMap.put(tmpKey, formulaSet);
            }
            formulaSet.add(ctrlParam.getItemFormula());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FFormula, FIsGroupCtrl, FGroupNo from T_BG_BgData where FOrgUnitId = ? and FBgSchemeId = ? and FFormula IN (");
        for (int i = 1; i < 50; ++i) {
            sql.append("?,");
        }
        sql.append("?) and FIsGroupCtrl = 1");
        StringBuffer query = new StringBuffer();
        query.append("select FFormula from T_BG_BgData where FOrgUnitId = ? and FBgSchemeId = ? and FGroupNo = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        IRowSet tmpRst = null;
        Map.Entry entry2 = null;
        ArrayList<String> tmpList = new ArrayList<String>();
        String formula = null;
        String formulaStr = null;
        boolean isGroupCtrl = false;
        String groupNo = null;
        HashMap<String, Set<String[]>> result = new HashMap<String, Set<String[]>>();
        HashSet<String> groupSet = new HashSet<String>();
        Set<String[]> combinItems = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (Map.Entry entry2 : formulaMap.entrySet()) {
                tmpKey = (String)entry2.getKey();
                formulaSet = (Set)entry2.getValue();
                tmpStrs = tmpKey.split("_");
                orgUnitId = tmpStrs[0];
                bgSchemeId = tmpStrs[1];
                tmpList.clear();
                tmpList.addAll(formulaSet);
                groupSet.clear();
                int size = tmpList.size();
                int count = (size - 1) / 50 + 1;
                int pos = 0;
                pstmt.setString(1, orgUnitId);
                pstmt.setString(2, bgSchemeId);
                for (int index = 0; index < count; ++index) {
                    for (int x = 1; x <= 50; ++x, ++pos) {
                        if (pos < size) {
                            pstmt.setString(x + 2, (String)tmpList.get(pos));
                            continue;
                        }
                        pstmt.setString(x + 2, "#");
                    }
                    try {
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            formulaStr = rst.getString("FFormula");
                            groupNo = rst.getString("FGroupNo");
                            if (StringUtils.isEmpty((String)groupNo) || groupSet.contains(groupNo)) continue;
                            groupSet.add(groupNo);
                            tmpKey = orgUnitId + "_" + groupNo;
                            if (result.containsKey(tmpKey)) {
                                combinItems = (Set)result.get(tmpKey);
                            } else {
                                combinItems = new HashSet();
                                result.put(tmpKey, combinItems);
                            }
                            try {
                                tmpRst = BgDBUtils.executeQuery(conn, query.toString(), new Object[]{orgUnitId, bgSchemeId, groupNo});
                                while (tmpRst.next()) {
                                    formula = rst.getString("FFormula");
                                    tmpStrs = BgNFSHelper.parseFormulaPara((String)formula);
                                    itemNumber = tmpStrs[0];
                                    _itemNumber = itemNumber.replaceAll(",", "_");
                                    if (mapping.containsKey(_itemNumber)) {
                                        mapList = (List)mapping.get(_itemNumber);
                                        int jn = mapList.size();
                                        for (int j = 0; j < jn; ++j) {
                                            mapInfo = (BgControlItemMapInfo)mapList.get(j);
                                            tmpStrs = new String[]{mapInfo.getBillFieldCombinValue(), mapInfo.getBillItemCombinValue()};
                                            tmpStrs[2] = itemNumber;
                                            combinItems.add(tmpStrs);
                                        }
                                        continue;
                                    }
                                    tmpStrs = new String[]{(String)ctrlMap.get(formulaStr), itemNumber, itemNumber};
                                    combinItems.add(tmpStrs);
                                }
                            }
                            catch (Throwable throwable) {
                                SQLUtils.cleanup(tmpRst);
                                throw throwable;
                            }
                            SQLUtils.cleanup((ResultSet)tmpRst);
                        }
                        continue;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"getCombinItems SQL Error:", (Throwable)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    protected void transCentralizedOrgUnitId(Context ctx, BgCtrlParamCollection ctrlParams) throws BOSException, EASBizException {
        if (ctx == null || ctrlParams == null || ctrlParams.isEmpty()) {
            return;
        }
        BgCtrlParamInfo ctrlParam = null;
        HashSet<String> orgUnitSets = new HashSet<String>();
        int in = ctrlParams.size();
        for (int i = 0; i < in; ++i) {
            ctrlParam = ctrlParams.get(i);
            orgUnitSets.add(ctrlParam.getOrgUnitId());
        }
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        orgUnitIds.addAll(orgUnitSets);
        int batchSize = 50;
        int size = orgUnitIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FOrgUnitId, t.FCenOrgUnitId, c.FName_" + ctx.getLocale() + " from T_BG_BgCentralizedOrg t join T_ORG_CostCenter c on t.FCenOrgUnitId = c.FID where t.FOrgUnitId IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        HashMap<String, String[]> cenOrgUnitIds = new HashMap<String, String[]>();
        String[] cenOrgUnits = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)orgUnitIds.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    cenOrgUnits = new String[]{rst.getString(2), rst.getString(3)};
                    cenOrgUnitIds.put(rst.getString(1), cenOrgUnits);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)"sql error:", (Throwable)exc);
                throw new BgException(BgException.DATABASEERROR, new String[]{exc.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        int in2 = ctrlParams.size();
        for (int i = 0; i < in2; ++i) {
            ctrlParam = ctrlParams.get(i);
            if (ctrlParam.getBizDate() == null || !cenOrgUnitIds.containsKey(ctrlParam.getOrgUnitId())) continue;
            cenOrgUnits = (String[])cenOrgUnitIds.get(ctrlParam.getOrgUnitId());
            ctrlParam.setOrgUnitId(cenOrgUnits[0]);
            ctrlParam.setOrgUnitName(cenOrgUnits[1]);
            ctrlParam.setBgSchemeId(BudgetCtrlHelper.getActivedBgSchemeID(ctx, ctrlParam, ctrlParam.getBizDate()));
        }
    }
}

