/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.ActualTypeEnum;
import com.kingdee.eas.ma.budget.BgCommonException;
import com.kingdee.eas.ma.budget.BgControlException;
import com.kingdee.eas.ma.budget.BgControlItemMapCollection;
import com.kingdee.eas.ma.budget.BgControlItemMapInfo;
import com.kingdee.eas.ma.budget.BgControlMultiRuleCollection;
import com.kingdee.eas.ma.budget.BgControlMultiRuleInfo;
import com.kingdee.eas.ma.budget.BgControlPeriodMapCollection;
import com.kingdee.eas.ma.budget.BgControlPeriodMapFactory;
import com.kingdee.eas.ma.budget.BgControlPeriodMapInfo;
import com.kingdee.eas.ma.budget.BgControlRuleCollection;
import com.kingdee.eas.ma.budget.BgControlRuleInfo;
import com.kingdee.eas.ma.budget.BgControlSchemeCollection;
import com.kingdee.eas.ma.budget.BgControlSchemeFactory;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgCtrlMRCtrlRuleEnum;
import com.kingdee.eas.ma.budget.BgCtrlMRCtrlValueEnum;
import com.kingdee.eas.ma.budget.BgCtrlManualDecisionException;
import com.kingdee.eas.ma.budget.BgCtrlMultiRuleEntryInfo;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.BgCtrlRecordCollection;
import com.kingdee.eas.ma.budget.BgCtrlRecordFactory;
import com.kingdee.eas.ma.budget.BgCtrlRecordInfo;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgOverspendInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodException;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTraceTypeEnum;
import com.kingdee.eas.ma.budget.BudgetCtrlConstants;
import com.kingdee.eas.ma.budget.BudgetCtrlState;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.BudgetCtrlWithHintUtil;
import com.kingdee.eas.ma.budget.BudgetRequestType;
import com.kingdee.eas.ma.budget.IBgControlPeriodMap;
import com.kingdee.eas.ma.budget.IBgControlScheme;
import com.kingdee.eas.ma.budget.IBgCtrlRecord;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.MateUtils;
import com.kingdee.eas.ma.budget.app.BudgetCtrlCacheHelper;
import com.kingdee.eas.ma.budget.app.BudgetSupportBillLoader;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BudgetCtrlHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BudgetCtrlHelper");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static BgControlSchemeInfo getCtrlScheme(Context ctx, String boName, String orgUnitId) throws BOSException, EASBizException {
        if (BudgetCtrlUtil.isEmpty(orgUnitId)) {
            return null;
        }
        if (BudgetCtrlUtil.isEmpty(boName)) {
            return null;
        }
        String locale = ctx.getLocale().toString();
        String colName = "FName_" + locale;
        String colBoAlias = "FBoAlias_" + locale;
        StringBuffer schemeKSql = new StringBuffer();
        schemeKSql.append(" select FId,");
        schemeKSql.append("        FNumber,");
        schemeKSql.append("        " + colName + ",");
        schemeKSql.append("        FBoName,");
        schemeKSql.append("        " + colBoAlias + ",");
        schemeKSql.append("        FIsAllowAccess,");
        schemeKSql.append("        FIsFindUpperOrg,");
        schemeKSql.append("        FFindUpperOrgMaxLevel,");
        schemeKSql.append("        FIsCanControlWithoutBudget,");
        schemeKSql.append("        FIsAutoCreateBgAdjustBill,");
        schemeKSql.append("        FLastUpdateTime,");
        schemeKSql.append("        FCostCenterid");
        schemeKSql.append("   from T_BG_BgControlScheme");
        schemeKSql.append("  where FBoName = ?");
        schemeKSql.append("    and FCostCenterId = ?");
        schemeKSql.append("    and FIsValid = 1");
        schemeKSql.append("    and FIsSysDefault = 0");
        BgControlSchemeInfo ctrlSchemeInfo = null;
        String ctrlSchemeId = null;
        Connection conn = null;
        PreparedStatement schemeSta = null;
        PreparedStatement ruleSta = null;
        PreparedStatement itemMapSta = null;
        PreparedStatement periodMapSta = null;
        PreparedStatement multiRuleSta = null;
        ResultSet schemeRst = null;
        ResultSet ruleRst = null;
        ResultSet itemMapRst = null;
        ResultSet periodMapRst = null;
        ResultSet multiRuleRst = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            schemeSta = conn.prepareStatement(schemeKSql.toString());
            schemeSta.setString(1, boName);
            schemeSta.setString(2, orgUnitId);
            schemeRst = schemeSta.executeQuery();
            if (schemeRst.next()) {
                ctrlSchemeInfo = new BgControlSchemeInfo();
                ctrlSchemeId = schemeRst.getString("FId");
                ctrlSchemeInfo.setId(BOSUuid.read((String)ctrlSchemeId));
                ctrlSchemeInfo.setNumber(schemeRst.getString("FNumber"));
                ctrlSchemeInfo.setName(schemeRst.getString(colName));
                ctrlSchemeInfo.setBoName(schemeRst.getString("FBoName"));
                ctrlSchemeInfo.setBoAlias(schemeRst.getString(colBoAlias));
                ctrlSchemeInfo.setIsAllowExcess(schemeRst.getInt("FIsAllowAccess") == 1);
                ctrlSchemeInfo.setIsFindUpperOrg(schemeRst.getInt("FIsFindUpperOrg") == 1);
                ctrlSchemeInfo.setFindUpperOrgMaxLevel(schemeRst.getInt("FFindUpperOrgMaxLevel"));
                ctrlSchemeInfo.setIsCanControlWithoutBudget(schemeRst.getInt("FIsCanControlWithoutBudget") == 1);
                ctrlSchemeInfo.setIsAutoCreateBgAdjustBill(schemeRst.getInt("FIsAutoCreateBgAdjustBill") == 1);
                ctrlSchemeInfo.setLastUpdateTime(null);
                FullOrgUnitInfo costCenter = new FullOrgUnitInfo();
                costCenter.setId(BOSUuid.read((String)schemeRst.getString("FCostCenterid")));
                ctrlSchemeInfo.setCostCenter(costCenter);
                StringBuffer ruleKSql = new StringBuffer();
                ruleKSql.append(" select FOqlOrgUnit,");
                ruleKSql.append("        FAliasOrgUnit,");
                ruleKSql.append("        FOqlItemCombination,");
                ruleKSql.append("        FAliasItemCombination,");
                ruleKSql.append("        FOqlPeriod,");
                ruleKSql.append("        FAliasPeriod,");
                ruleKSql.append("        FOqlCurrency,");
                ruleKSql.append("        FAliasCurrency,");
                ruleKSql.append("        FElementNumber,");
                ruleKSql.append("        FPeriodCycle,");
                ruleKSql.append("        FOqlBizDate,");
                ruleKSql.append("        FAliasBizDate,");
                ruleKSql.append("        FOqlRequest,");
                ruleKSql.append("        FAliasRequest,");
                ruleKSql.append("        FOqlRequestExtExp,");
                ruleKSql.append("        FCusBgPeriodNum,");
                ruleKSql.append("        FOqlRuleCondition,");
                ruleKSql.append("        FAliasRuleCondition");
                ruleKSql.append("   from T_BG_BgControlRule");
                ruleKSql.append("  where fbgctrlschemeid = ?");
                ruleSta = conn.prepareStatement(ruleKSql.toString());
                ruleSta.setString(1, ctrlSchemeId);
                ruleRst = ruleSta.executeQuery();
                BgControlRuleCollection ruleCol = new BgControlRuleCollection();
                while (ruleRst.next()) {
                    BgControlRuleInfo ruleInfo = new BgControlRuleInfo();
                    ruleInfo.setOqlOrgUnit(ruleRst.getString("FOqlOrgUnit"));
                    ruleInfo.setAliasOrgUnit(ruleRst.getString("FAliasOrgUnit"));
                    ruleInfo.setOqlItemCombination(ruleRst.getString("FOqlItemCombination"));
                    ruleInfo.setAliasItemCombination(ruleRst.getString("FAliasItemCombination"));
                    ruleInfo.setOqlPeriod(ruleRst.getString("FOqlPeriod"));
                    ruleInfo.setAliasPeriod(ruleRst.getString("FAliasPeriod"));
                    ruleInfo.setOqlCurrency(ruleRst.getString("FOqlCurrency"));
                    ruleInfo.setAliasCurrency(ruleRst.getString("FAliasCurrency"));
                    ruleInfo.setElementNumber(ruleRst.getString("FElementNumber"));
                    ruleInfo.setPeriodCycle(BgPeriodEnum.getEnum(ruleRst.getInt("FPeriodCycle")));
                    ruleInfo.setOqlBizDate(ruleRst.getString("FOqlBizDate"));
                    ruleInfo.setAliasBizDate(ruleRst.getString("FAliasBizDate"));
                    ruleInfo.setOqlRequest(ruleRst.getString("FOqlRequest"));
                    ruleInfo.setAliasRequest(ruleRst.getString("FAliasRequest"));
                    ruleInfo.setOqlRequestExtendExpression(ruleRst.getString("FOqlRequestExtExp"));
                    ruleInfo.setCustomBgPeriodNumber(ruleRst.getString("FCusBgPeriodNum"));
                    ruleInfo.setOqlRuleCondition(ruleRst.getString("FOqlRuleCondition"));
                    ruleInfo.setAliasRuleCondition(ruleRst.getString("FAliasRuleCondition"));
                    ruleCol.add(ruleInfo);
                }
                ctrlSchemeInfo.put("rules", (Object)ruleCol);
                StringBuffer itemMapKSql = new StringBuffer();
                itemMapKSql.append(" select FBillFieldCombinValue,");
                itemMapKSql.append("        FBillFieldCombinAlias,");
                itemMapKSql.append("        FBillItemCombinValue,");
                itemMapKSql.append("        FBillItemCombinAlias,");
                itemMapKSql.append("        FBgItemCombinID,");
                itemMapKSql.append(" \t\tFBgItemCombinKey,");
                itemMapKSql.append(" \t\tFBgItemCombinAlias");
                itemMapKSql.append("   from T_BG_BgControlItemMap");
                itemMapKSql.append("  where FBgCtrlSchemeId = ?");
                itemMapSta = conn.prepareStatement(itemMapKSql.toString());
                itemMapSta.setString(1, ctrlSchemeId);
                itemMapRst = itemMapSta.executeQuery();
                BgControlItemMapCollection mapCol = new BgControlItemMapCollection();
                while (itemMapRst.next()) {
                    BgControlItemMapInfo mapInfo = new BgControlItemMapInfo();
                    mapInfo.setBillFieldCombinValue(itemMapRst.getString("FBillFieldCombinValue"));
                    mapInfo.setBillFieldCombinAlias(itemMapRst.getString("FBillFieldCombinAlias"));
                    mapInfo.setBillItemCombinValue(itemMapRst.getString("FBillItemCombinValue"));
                    mapInfo.setBillItemCombinAlias(itemMapRst.getString("FBillItemCombinAlias"));
                    mapInfo.setBgItemCombinID(itemMapRst.getString("FBgItemCombinID"));
                    mapInfo.setBgItemCombinKey(itemMapRst.getString("FBgItemCombinKey"));
                    mapInfo.setBgItemCombinAlias(itemMapRst.getString("FBgItemCombinAlias"));
                    mapCol.add(mapInfo);
                }
                ctrlSchemeInfo.put("itemMap", (Object)mapCol);
                StringBuffer periodMapKSql = new StringBuffer();
                periodMapKSql.append(" select FBizBeginPeriod,");
                periodMapKSql.append("        FBizEndPeriod,");
                periodMapKSql.append("        FBgPeriod");
                periodMapKSql.append("   from T_BG_BgControlPeriodMap");
                periodMapKSql.append("  where FBgCtrlSchemeId = ?");
                periodMapSta = conn.prepareStatement(periodMapKSql.toString());
                periodMapSta.setString(1, ctrlSchemeId);
                periodMapRst = periodMapSta.executeQuery();
                BgControlPeriodMapCollection periodMapCol = new BgControlPeriodMapCollection();
                while (periodMapRst.next()) {
                    BgControlPeriodMapInfo periodMapInfo = new BgControlPeriodMapInfo();
                    periodMapInfo.setBizBeginPeriod(periodMapRst.getString("FBizBeginPeriod"));
                    periodMapInfo.setBizEndPeriod(periodMapRst.getString("FBizEndPeriod"));
                    periodMapInfo.setBgPeriod(periodMapRst.getString("FBgPeriod"));
                    periodMapCol.add(periodMapInfo);
                }
                ctrlSchemeInfo.put("periodMap", (Object)periodMapCol);
                ctrlSchemeInfo.getMultiRule().clear();
                StringBuffer multiRuleKSql = new StringBuffer();
                multiRuleKSql.append(" select multiRule.FID m_FID,multiRule.FBizItemCombinId m_FBizItemCombinId,").append(" multiRule.FBizItemCombinNumber m_FBizItemCombinNumber,multiRule.FBizItemCombinAlias m_FBizItemCombinAlias,").append(" multiRule.FCtrlItemCombinId m_FCtrlItemCombinId,multiRule.FCtrlItemCombinNumber m_FCtrlItemCombinNumber,").append(" multiRule.FCtrlItemCombinAlias m_FCtrlItemCombinAlias,multiRule.FCtrlCoe m_FCtrlCoe,").append(" multiRule.FCtrlValue m_FCtrlValue,multiRule.FCtrlRule m_FCtrlRule,multiRule.FisGroupCheck m_FisGroupCheck,").append(" entry.FID e_FID,entry.FCtrlCoe e_FCtrlCoe,entry.FControllProcess e_FControllProcess").append(" from T_BG_BgControlMultiRule multiRule").append(" LEFT JOIN T_BG_BgCtrlMultiRuleEntry entry ON multiRule.FID=entry.FParentID").append(" where multiRule.FBgCtrlSchemeId = ? ORDER BY multiRule.FID,entry.FSeq");
                multiRuleSta = conn.prepareStatement(multiRuleKSql.toString());
                multiRuleSta.setString(1, ctrlSchemeId);
                multiRuleRst = multiRuleSta.executeQuery();
                BgControlMultiRuleInfo multiRuleInfo = null;
                BgCtrlMultiRuleEntryInfo entry = null;
                String mFid = null;
                String eFid = null;
                while (multiRuleRst.next()) {
                    mFid = multiRuleRst.getString("m_FID");
                    if (mFid == null) continue;
                    if (multiRuleInfo == null || !multiRuleInfo.getId().toString().equals(mFid)) {
                        multiRuleInfo = new BgControlMultiRuleInfo();
                        ctrlSchemeInfo.getMultiRule().add(multiRuleInfo);
                        multiRuleInfo.setId(BOSUuid.read((String)mFid));
                        multiRuleInfo.setBizItemCombinId(multiRuleRst.getString("m_FBizItemCombinId"));
                        multiRuleInfo.setBizItemCombinNumber(multiRuleRst.getString("m_FBizItemCombinNumber"));
                        multiRuleInfo.setBizItemCombinAlias(multiRuleRst.getString("m_FBizItemCombinAlias"));
                        multiRuleInfo.setCtrlItemCombinId(multiRuleRst.getString("m_FCtrlItemCombinId"));
                        multiRuleInfo.setCtrlItemCombinNumber(multiRuleRst.getString("m_FCtrlItemCombinNumber"));
                        multiRuleInfo.setCtrlItemCombinAlias(multiRuleRst.getString("m_FCtrlItemCombinAlias"));
                        multiRuleInfo.setCtrlCoe(multiRuleRst.getBigDecimal("m_FCtrlCoe"));
                        multiRuleInfo.setCtrlValue(BgCtrlMRCtrlValueEnum.getEnum(multiRuleRst.getInt("m_FCtrlValue")));
                        multiRuleInfo.setCtrlRule(BgCtrlMRCtrlRuleEnum.getEnum(multiRuleRst.getInt("m_FCtrlRule")));
                        multiRuleInfo.setIsGroupCheck(multiRuleRst.getBoolean("m_FisGroupCheck"));
                    }
                    if (StringUtils.isEmpty((String)(eFid = multiRuleRst.getString("e_FID")))) continue;
                    entry = new BgCtrlMultiRuleEntryInfo();
                    entry.setId(BOSUuid.read((String)eFid));
                    entry.setCtrlCoe(multiRuleRst.getBigDecimal("e_FCtrlCoe"));
                    entry.setControllProcess(multiRuleRst.getString("e_FControllProcess"));
                    multiRuleInfo.getEntry().add(entry);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(schemeRst);
                SQLUtils.cleanup(ruleRst);
                SQLUtils.cleanup(itemMapRst);
                SQLUtils.cleanup(periodMapRst);
                SQLUtils.cleanup(multiRuleRst);
                SQLUtils.cleanup((Statement)schemeSta);
                SQLUtils.cleanup(ruleSta);
                SQLUtils.cleanup(itemMapSta);
                SQLUtils.cleanup(periodMapSta);
                SQLUtils.cleanup(multiRuleSta);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)schemeRst);
        SQLUtils.cleanup(ruleRst);
        SQLUtils.cleanup(itemMapRst);
        SQLUtils.cleanup(periodMapRst);
        SQLUtils.cleanup(multiRuleRst);
        SQLUtils.cleanup((Statement)schemeSta);
        SQLUtils.cleanup(ruleSta);
        SQLUtils.cleanup(itemMapSta);
        SQLUtils.cleanup(periodMapSta);
        SQLUtils.cleanup(multiRuleSta);
        SQLUtils.cleanup((Connection)conn);
        if (BudgetCtrlUtil.isEmpty(ctrlSchemeInfo)) return null;
        return BudgetCtrlHelper.repairErrorData(ctrlSchemeInfo);
    }

    static List checkBudgetWihtMessage(Context ctx, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) throws BgCtrlManualDecisionException {
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        if (BudgetCtrlUtil.isEmpty((Object)ruleCol)) {
            ArrayList<BgOverspendInfo> overspendList = new ArrayList<BgOverspendInfo>();
            BgOverspendInfo bgOverspend = new BgOverspendInfo();
            bgOverspend.setIsAudit("true");
            overspendList.add(bgOverspend);
            return overspendList;
        }
        boolean isWorkFlow = ctx.get((Object)"requestBudgetType") != null && ctx.get((Object)"requestBudgetType") == BudgetRequestType.WF_APPROVE;
        boolean isCanControlWithoutBudget = ctrlScheme.isIsCanControlWithoutBudget();
        boolean isAllowAccess = ctrlScheme.isIsAllowExcess();
        if ("yes".equals(ctx.get((Object)"hint"))) {
            return BudgetCtrlWithHintUtil.checkCtrlResultColWithMessage(ctx, isCanControlWithoutBudget, isAllowAccess, isWorkFlow, ctrlResultCol, ctrlParamCol, ctrlScheme);
        }
        return BudgetCtrlUtil.checkCtrlResultColWithMessage(ctx, isCanControlWithoutBudget, isAllowAccess, isWorkFlow, ctrlResultCol, ctrlParamCol, ctrlScheme);
    }

    static BgControlSchemeInfo getCtrlSchemeByORM(Context ctx, String boName, String orgUnitId) throws BOSException, EASBizException {
        if (BudgetCtrlUtil.isEmpty(orgUnitId)) {
            return null;
        }
        if (BudgetCtrlUtil.isEmpty(boName)) {
            return null;
        }
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boName", (Object)boName, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("costCenter.id", (Object)orgUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isValid", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSysDefault", (Object)new Integer(0), CompareType.EQUALS));
        entityView.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("boName"));
        selector.add(new SelectorItemInfo("boAlias"));
        selector.add(new SelectorItemInfo("isAllowExcess"));
        selector.add(new SelectorItemInfo("isFindUpperOrg"));
        selector.add(new SelectorItemInfo("findUpperOrgMaxLevel"));
        selector.add(new SelectorItemInfo("isCanControlWithoutBudget"));
        selector.add(new SelectorItemInfo("lastUpdateTime"));
        selector.add(new SelectorItemInfo("costCenter.id"));
        selector.add(new SelectorItemInfo("rules.oqlOrgUnit"));
        selector.add(new SelectorItemInfo("rules.aliasOrgUnit"));
        selector.add(new SelectorItemInfo("rules.oqlItemCombination"));
        selector.add(new SelectorItemInfo("rules.aliasItemCombination"));
        selector.add(new SelectorItemInfo("rules.oqlPeriod"));
        selector.add(new SelectorItemInfo("rules.aliasPeriod"));
        selector.add(new SelectorItemInfo("rules.oqlCurrency"));
        selector.add(new SelectorItemInfo("rules.aliasCurrency"));
        selector.add(new SelectorItemInfo("rules.elementNumber"));
        selector.add(new SelectorItemInfo("rules.periodCycle"));
        selector.add(new SelectorItemInfo("rules.oqlBizDate"));
        selector.add(new SelectorItemInfo("rules.aliasBizDate"));
        selector.add(new SelectorItemInfo("rules.oqlRequest"));
        selector.add(new SelectorItemInfo("rules.aliasRequest"));
        selector.add(new SelectorItemInfo("rules.oqlRequestExtendExpression"));
        selector.add(new SelectorItemInfo("rules.customBgPeriodNumber"));
        selector.add(new SelectorItemInfo("rules.oqlRuleCondition"));
        selector.add(new SelectorItemInfo("rules.aliasRuleCondition"));
        selector.add(new SelectorItemInfo("itemMap.billFieldCombinValue"));
        selector.add(new SelectorItemInfo("itemMap.billFieldCombinAlias"));
        selector.add(new SelectorItemInfo("itemMap.billItemCombinValue"));
        selector.add(new SelectorItemInfo("itemMap.billItemCombinAlias"));
        selector.add(new SelectorItemInfo("itemMap.bgItemCombinID"));
        selector.add(new SelectorItemInfo("itemMap.bgItemCombinKey"));
        selector.add(new SelectorItemInfo("itemMap.bgItemCombinAlias"));
        selector.add(new SelectorItemInfo("periodMap.bizBeginPeriod"));
        selector.add(new SelectorItemInfo("periodMap.bizEndPeriod"));
        selector.add(new SelectorItemInfo("periodMap.bgPeriod"));
        selector.add(new SelectorItemInfo("multiRule.bizItemCombinId"));
        selector.add(new SelectorItemInfo("multiRule.bizItemCombinNumber"));
        selector.add(new SelectorItemInfo("multiRule.bizItemCombinAlias"));
        selector.add(new SelectorItemInfo("multiRule.ctrlItemCombinId"));
        selector.add(new SelectorItemInfo("multiRule.ctrlItemCombinNumber"));
        selector.add(new SelectorItemInfo("multiRule.ctrlItemCombinAlias"));
        selector.add(new SelectorItemInfo("multiRule.ctrlCoe"));
        selector.add(new SelectorItemInfo("multiRule.ctrlValue"));
        selector.add(new SelectorItemInfo("multiRule.ctrlRule"));
        entityView.setSelector(selector);
        IBgControlScheme iCtrlScheme = BgControlSchemeFactory.getLocalInstance(ctx);
        BgControlSchemeCollection ctrlSchemeCol = null;
        try {
            ctrlSchemeCol = iCtrlScheme.getBgControlSchemeCollection(entityView);
        }
        catch (ObjectNotFoundException ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        if (BudgetCtrlUtil.isEmpty((Object)ctrlSchemeCol)) {
            return null;
        }
        if (ctrlSchemeCol.size() > 1) {
            throw new BgException(BgException.ILLEGALARGUMENT, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"71_BudgetCtrlHelper", (Locale)ctx.getLocale())});
        }
        BgControlSchemeInfo scheme = ctrlSchemeCol.get(0);
        scheme = BudgetCtrlHelper.repairErrorData(scheme);
        return scheme;
    }

    static String getBillOUID(Context ctx, String boId, String boName) throws BOSException, EASBizException {
        String queryOUOQL = BudgetCtrlHelper.getQueryOUOQL(boId, boName);
        IDataProvider dataProvider = EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(boName));
        dataProvider.setObjectView(queryOUOQL);
        String queryOUSQL = dataProvider.getSQL();
        IRowSet rst = null;
        try {
            rst = DbUtil.executeQuery((Context)ctx, (String)queryOUSQL);
            if (rst.next()) {
                String string = rst.getString(1);
                return string;
            }
            try {
                throw new BgException(BgException.ILLEGALARGUMENT, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"72_BudgetCtrlHelper", (Locale)ctx.getLocale()) + queryOUSQL});
            }
            catch (SQLException ex) {
                logger.error((Object)"error:", (Throwable)ex);
                logger.error((Object)queryOUOQL);
                throw new BgException(BgException.DATABASEERROR, ex);
            }
            catch (Exception ex) {
                logger.error((Object)"error:", (Throwable)ex);
                logger.error((Object)queryOUOQL);
                throw new BOSException((Throwable)ex);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
    }

    static String getQueryOUOQL(String boID, String boName) throws BOSException {
        String OUFieldOQL = BudgetCtrlHelper.getBillOUFieldOQL(boName);
        String queryOUOQL = "select " + OUFieldOQL + " where id = '" + boID + "'";
        return queryOUOQL;
    }

    static String getBillOUID(Context ctx, String boName, IObjectValue billInfo) throws BOSException, EASBizException {
        String OUOQLField = BudgetCtrlHelper.getBillOUFieldOQL(boName);
        Vector OUFieldValues = BudgetCtrlUtil.getFieldValue(billInfo, OUOQLField.split("\\."));
        if (BudgetCtrlUtil.isEmpty(OUFieldValues)) {
            return null;
        }
        return OUFieldValues.get(0).toString();
    }

    static String getBOName(Context ctx, String id) {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)id, (boolean)false);
        return MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)bosType).getFullName();
    }

    static String getBOName(Context ctx, BOSUuid id) {
        return BudgetCtrlHelper.getBOName(ctx, id.toString());
    }

    static String getBOName(Context ctx, IObjectValue billInfo) {
        return MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)billInfo.getBOSType()).getFullName();
    }

    static String getBOAlias(Context ctx, String id) {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)id, (boolean)false);
        return MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)bosType).getAlias();
    }

    static String getBillOUFieldOQL(String boName) throws BOSException {
        return BudgetSupportBillLoader.getIntance().getBillOUFieldOQL(boName);
    }

    static String getCostCenterId(Context ctx, String OUID) throws EASBizException, BOSException {
        if (BudgetCtrlUtil.isEmpty(OUID)) {
            return null;
        }
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("isCostOrgUnit"));
        sic.add(new SelectorItemInfo("parent.id"));
        OrgUnitInfo org = null;
        try {
            org = iFullOrgUnit.getOrgUnitInfo((IObjectPK)new ObjectUuidPK(OUID), sic);
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (org == null) {
            return null;
        }
        if (org.isIsCostOrgUnit()) {
            return OUID;
        }
        Object parent = org.get("parent");
        if (BudgetCtrlUtil.isEmpty(parent) || BudgetCtrlUtil.isEmpty(((OrgUnitInfo)parent).getId())) {
            return null;
        }
        return BudgetCtrlHelper.getCostCenterId(ctx, ((OrgUnitInfo)parent).getId().toString());
    }

    static boolean checkBudget(Context ctx, BudgetCtrlState state, BgCtrlResultCollection ctrlResultCol, BgControlSchemeInfo ctrlScheme) throws BgCtrlException {
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        if (BudgetCtrlUtil.isEmpty((Object)ruleCol)) {
            return true;
        }
        boolean isWorkFlow = state != null && state.getRequestType() == BudgetRequestType.WF_APPROVE;
        boolean isCanControlWithoutBudget = ctrlScheme.isIsCanControlWithoutBudget();
        boolean isAllowAccess = ctrlScheme.isIsAllowExcess();
        return BudgetCtrlUtil.checkCtrlResultCol(ctx, isCanControlWithoutBudget, isAllowAccess, isWorkFlow, ctrlResultCol);
    }

    static boolean checkBudget(Context ctx, BudgetCtrlState state, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) throws BgCtrlException, BgCtrlManualDecisionException {
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        if (BudgetCtrlUtil.isEmpty((Object)ruleCol)) {
            return true;
        }
        boolean isWorkFlow = state != null && state.getRequestType() == BudgetRequestType.WF_APPROVE;
        boolean isCanControlWithoutBudget = ctrlScheme.isIsCanControlWithoutBudget();
        boolean isAllowAccess = ctrlScheme.isIsAllowExcess();
        if (state != null && state.isNeedHint()) {
            return BudgetCtrlWithHintUtil.checkCtrlResultCol(ctx, isCanControlWithoutBudget, isAllowAccess, isWorkFlow, ctrlResultCol, ctrlParamCol, ctrlScheme);
        }
        return BudgetCtrlUtil.checkCtrlResultCol(ctx, isCanControlWithoutBudget, isAllowAccess, isWorkFlow, ctrlResultCol, ctrlParamCol, ctrlScheme);
    }

    static Map checkBudgetAccess(Context ctx, BudgetCtrlState state, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) throws BgCtrlException, BgCtrlManualDecisionException {
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        if (BudgetCtrlUtil.isEmpty((Object)ruleCol)) {
            return new HashMap();
        }
        boolean isWorkFlow = state != null && state.getRequestType() == BudgetRequestType.WF_APPROVE;
        boolean isCanControlWithoutBudget = ctrlScheme.isIsCanControlWithoutBudget();
        boolean isAllowAccess = ctrlScheme.isIsAllowExcess();
        return BudgetCtrlWithHintUtil.checkCtrlResultColAccess(ctx, isCanControlWithoutBudget, isAllowAccess, isWorkFlow, ctrlResultCol, ctrlParamCol, ctrlScheme);
    }

    static Map checkBudgetValue(Context ctx, BudgetCtrlState state, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme, String org) throws BgCtrlException, BgCtrlManualDecisionException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("result", "1");
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        if (BudgetCtrlUtil.isEmpty((Object)ruleCol)) {
            return result;
        }
        boolean isWorkFlow = state != null && state.getRequestType() == BudgetRequestType.WF_APPROVE;
        boolean isCanControlWithoutBudget = ctrlScheme.isIsCanControlWithoutBudget();
        boolean isAllowAccess = ctrlScheme.isIsAllowExcess();
        if (state != null && state.isNeedHint()) {
            return BudgetCtrlWithHintUtil.checkCtrlResultColValue(ctx, isCanControlWithoutBudget, isAllowAccess, isWorkFlow, ctrlResultCol, ctrlParamCol, ctrlScheme);
        }
        return BudgetCtrlUtil.checkCtrlResultColValue(ctx, isCanControlWithoutBudget, isAllowAccess, isWorkFlow, ctrlResultCol, ctrlParamCol, ctrlScheme);
    }

    static void addBizActual(Context ctx, Map bgDataMap) throws BOSException, EASBizException {
        BudgetCtrlHelper.updateBizActual(ctx, bgDataMap, true);
    }

    static void subtractBizActual(Context ctx, Map bgDataMap) throws BOSException, EASBizException {
        BudgetCtrlHelper.updateBizActual(ctx, bgDataMap, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void updateBizActual(Context ctx, String billID) throws BOSException, EASBizException {
        if (billID == null) return;
        if (billID.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            HashSet<String> bgDataIDSet = new HashSet<String>();
            String query = "select FBgDataID from t_bg_bgctrlrecord where fbillid = '" + billID + "'";
            ps = conn.prepareStatement(query);
            rs = ps.executeQuery();
            while (rs.next()) {
                bgDataIDSet.add(rs.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            if (!bgDataIDSet.isEmpty()) {
                StringBuffer update = new StringBuffer();
                update.append("update t_bg_bgdata set fbizactual = (select sum(factualamount) from t_bg_bgctrlrecord where t_bg_bgctrlrecord.fbgdataid = t_bg_bgdata.fid)");
                update.append(" where fid in (");
                for (int i = 0; i < bgDataIDSet.size(); ++i) {
                    if (i != bgDataIDSet.size() - 1) {
                        update.append("?,");
                        continue;
                    }
                    update.append("?)");
                }
                ps = conn.prepareStatement(update.toString());
                int index = 1;
                for (String bgDataId : bgDataIDSet) {
                    ps.setString(index, bgDataId);
                    ++index;
                }
                ps.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateBizActual(Context ctx, Map bgDataMap, boolean isAdd) throws BOSException, EASBizException {
        if (BudgetCtrlUtil.isEmpty(bgDataMap)) {
            return;
        }
        StringBuffer SQL = new StringBuffer(1024);
        SQL.append(" update T_BG_BgData");
        SQL.append("    set FBizActual = FBizActual + ?");
        SQL.append("  where FId = ?");
        BigDecimal coe = isAdd ? BudgetCtrlConstants.ONE_AMOUNT : BudgetCtrlConstants.NEG_ONE_AMOUNT;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rst = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(SQL.toString());
            for (String bgDataId : bgDataMap.keySet()) {
                BigDecimal amount = (BigDecimal)bgDataMap.get(bgDataId);
                ps.setBigDecimal(1, coe.multiply(amount));
                ps.setString(2, bgDataId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)ps, (Connection)con);
    }

    static BgCtrlResultCollection addBizActual(Context ctx, BgCtrlResultCollection ctrlResultCol) throws BOSException, EASBizException {
        return BudgetCtrlHelper.updateBizActual(ctx, ctrlResultCol, true);
    }

    static BgCtrlResultCollection subtractBizActual(Context ctx, BgCtrlResultCollection ctrlResultCol) throws BOSException, EASBizException {
        return BudgetCtrlHelper.updateBizActual(ctx, ctrlResultCol, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BgCtrlResultCollection updateBizActual(Context ctx, BgCtrlResultCollection ctrlResultCol, boolean isAdd) throws BOSException, EASBizException {
        StringBuffer SQL = new StringBuffer(1024);
        SQL.append(" update T_BG_BgData");
        SQL.append("    set FBizActual = FBizActual + ?");
        SQL.append("  where FId = ?");
        BigDecimal coe = isAdd ? BudgetCtrlConstants.ONE_AMOUNT : BudgetCtrlConstants.NEG_ONE_AMOUNT;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rst = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(SQL.toString());
            for (int i = 0; i < ctrlResultCol.size(); ++i) {
                BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
                if (ctrlResultInfo.getBgDataId() == null) continue;
                ps.setBigDecimal(1, coe.multiply(ctrlResultInfo.getReqAmount()));
                ps.setString(2, ctrlResultInfo.getBgDataId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)ps, (Connection)con);
        return ctrlResultCol;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void deleteReturnCtrlRecord(Context ctx, String boId, String boName) throws BOSException, EASBizException {
        if (BudgetCtrlHelper.isCPBCBill(boName)) {
            return;
        }
        StringBuffer SQL = new StringBuffer(1024);
        SQL.append(" delete T_BG_BgCtrlRecord");
        SQL.append("  where FBillId = ?");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rst = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(SQL.toString());
            ps.setString(1, boId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)ps, (Connection)con);
    }

    static void insertCtrlRecord(Context ctx, BudgetCtrlState state, BgCtrlResultCollection ctrlResultCol) throws BOSException, EASBizException {
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return;
        }
        BgCtrlRecordCollection ctrlRecordCol = new BgCtrlRecordCollection();
        boolean isBackgroundCollect = BgNSHelper.getBG028_queueBgCtrl((Context)ctx);
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (!isRequestBudget || BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) || BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBillId()) || ctrlResultInfo.getReqAmount() != null && ctrlResultInfo.getReqAmount().compareTo(BgNConstants.ZERO) == 0) continue;
            BgCtrlRecordInfo ctrlRecordInfo = new BgCtrlRecordInfo();
            ctrlRecordInfo.setBgDataId(ctrlResultInfo.getBgDataId());
            ctrlRecordInfo.setBillId(ctrlResultInfo.getBillId());
            ctrlRecordInfo.setBillName(ctrlResultInfo.getBillNumber());
            ctrlRecordInfo.setBillNumber(ctrlResultInfo.getBillNumber());
            ctrlRecordInfo.setBillType(BudgetCtrlHelper.getTypeAllias(ctrlResultInfo.getBillType(), BgTraceTypeEnum.Bill));
            ctrlRecordInfo.setBillAlias(ctrlResultInfo.getBillType());
            ctrlRecordInfo.setActualAmount(ctrlResultInfo.getReqAmount());
            ctrlRecordInfo.setBizDate(ctrlResultInfo.getBizDate());
            ctrlRecordInfo.setBgPeriodId(ctrlResultInfo.getBgPeriodNumber());
            ctrlRecordInfo.setItemName(ctrlResultInfo.getItemCombinName());
            ctrlRecordInfo.setBgTraceType(BgTraceTypeEnum.Bill);
            ctrlRecordInfo.setDayDate(ctrlResultInfo.getBizDate());
            ctrlRecordInfo.setBillSourceOrgunitID(ctrlResultInfo.getBillSourceOrgunitID());
            if (BudgetCtrlState.isOccupation(state)) {
                ctrlRecordInfo.setActualType(ActualTypeEnum.occupation);
            } else {
                ctrlRecordInfo.setActualType(ActualTypeEnum.execution);
            }
            if (BudgetCtrlState.isOccupation(state)) {
                ctrlRecordInfo.setIsCollected(false);
            } else if (state.isSchemeCtrlRequestActual()) {
                ctrlRecordInfo.setIsCollected(false);
            } else if (!isBackgroundCollect) {
                ctrlRecordInfo.setIsCollected(true);
            } else {
                ctrlRecordInfo.setIsCollected(false);
            }
            ctrlRecordCol.add(ctrlRecordInfo);
            BgCtrlResultCollection superItemCtrlResultCol = (BgCtrlResultCollection)((Object)ctrlResultInfo.get("superiorItemCtrlResultCol"));
            if (superItemCtrlResultCol == null) continue;
            for (int j = 0; j < superItemCtrlResultCol.size(); ++j) {
                BgCtrlResultInfo superItemCtrlResultInfo = superItemCtrlResultCol.get(j);
                if (superItemCtrlResultInfo.getReqAmount() != null && superItemCtrlResultInfo.getReqAmount().floatValue() == 0.0f) continue;
                BgCtrlRecordInfo superItemCtrlRecordInfo = new BgCtrlRecordInfo();
                superItemCtrlRecordInfo.setBgDataId(superItemCtrlResultInfo.getBgDataId());
                superItemCtrlRecordInfo.setBillId(superItemCtrlResultInfo.getBillId());
                superItemCtrlRecordInfo.setBillName(superItemCtrlResultInfo.getBillNumber());
                superItemCtrlRecordInfo.setBillNumber(superItemCtrlResultInfo.getBillNumber());
                superItemCtrlRecordInfo.setBillAlias(superItemCtrlResultInfo.getBillType());
                superItemCtrlRecordInfo.setBillType(BudgetCtrlHelper.getTypeAllias(superItemCtrlResultInfo.getBillType(), BgTraceTypeEnum.lowerItemCollect));
                superItemCtrlRecordInfo.setActualAmount(superItemCtrlResultInfo.getReqAmount());
                superItemCtrlRecordInfo.setBizDate(superItemCtrlResultInfo.getBizDate());
                superItemCtrlRecordInfo.setBgPeriodId(superItemCtrlResultInfo.getBgPeriodNumber());
                superItemCtrlRecordInfo.setItemName(superItemCtrlResultInfo.getItemCombinName());
                superItemCtrlRecordInfo.setBgTraceType(BgTraceTypeEnum.lowerItemCollect);
                superItemCtrlRecordInfo.setDayDate(superItemCtrlResultInfo.getBizDate());
                if (!isBackgroundCollect) {
                    superItemCtrlRecordInfo.setIsCollected(true);
                } else {
                    superItemCtrlRecordInfo.setIsCollected(false);
                }
                if (BudgetCtrlState.isOccupation(state)) {
                    superItemCtrlRecordInfo.setActualType(ActualTypeEnum.occupation);
                } else {
                    superItemCtrlRecordInfo.setActualType(ActualTypeEnum.execution);
                }
                superItemCtrlRecordInfo.setBillSourceOrgunitID(superItemCtrlResultInfo.getBillSourceOrgunitID());
                ctrlRecordCol.add(superItemCtrlRecordInfo);
            }
        }
        if (ctrlRecordCol != null) {
            BudgetCtrlHelper.addNewCtrlRecord(ctx, ctrlRecordCol);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addNewCtrlRecord(Context ctx, BgCtrlRecordCollection ctrlRecordCol) throws BOSException, EASBizException {
        StringBuffer kSql = new StringBuffer();
        kSql.append(" insert into T_BG_BgCtrlRecord");
        kSql.append("   (FId,");
        kSql.append("    FCreatorId,");
        kSql.append("    FCreateTime,");
        kSql.append("    FLastUpdateUserId,");
        kSql.append("    FLastUpdateTime,");
        kSql.append("    FControlUnitId,");
        kSql.append("    FBgDataId,");
        kSql.append("    FBillId,");
        kSql.append("    FBillName,");
        kSql.append("    FBillNumber,");
        kSql.append("    FBillAlias,");
        kSql.append("    FBillType,");
        kSql.append("    FBizDate,");
        kSql.append("    FActualAmount,");
        kSql.append("    FBillOperate,");
        kSql.append("    FBgPeriodId,");
        kSql.append("    FItemName,");
        kSql.append("    FBgTraceType,");
        kSql.append("    FOrgUnitId,");
        kSql.append("    FBgSchemeId,");
        kSql.append("    FItemFormula,");
        kSql.append("    FPayState,");
        kSql.append("    FISCollected,");
        kSql.append("    FDayDate,");
        kSql.append("    FActualType,");
        kSql.append("    FBillSourceOrgunitID ) ");
        kSql.append(" values (newbosid('FF6153C2'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? )");
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx) != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : "";
        java.sql.Date time = new java.sql.Date(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(kSql.toString());
            int batchCounter = 0;
            boolean isRun = false;
            for (int i = 0; i < ctrlRecordCol.size(); ++i) {
                BgCtrlRecordInfo info = ctrlRecordCol.get(i);
                statement.setString(1, userId);
                statement.setDate(2, time);
                statement.setString(3, userId);
                statement.setDate(4, time);
                statement.setString(5, info.getOrgUnitId());
                statement.setString(6, info.getBgDataId());
                statement.setString(7, info.getBillId());
                statement.setString(8, info.getBillName());
                statement.setString(9, info.getBillNumber());
                statement.setString(10, info.getBillAlias());
                statement.setString(11, info.getBillType());
                statement.setDate(12, info.getBizDate() != null ? new java.sql.Date(info.getBizDate().getTime()) : null);
                statement.setBigDecimal(13, info.getActualAmount());
                statement.setString(14, info.getBillOperate());
                statement.setString(15, info.getBgPeriodId());
                statement.setString(16, info.getItemName());
                statement.setInt(17, info.getBgTraceType().getValue());
                statement.setString(18, info.getOrgUnitId());
                statement.setString(19, info.getBgSchemeId());
                statement.setString(20, info.getItemFormula());
                statement.setInt(21, 0);
                statement.setInt(22, info.isIsCollected() ? 1 : 0);
                statement.setDate(23, info.getDayDate() != null ? new java.sql.Date(info.getDayDate().getTime()) : null);
                statement.setInt(24, info.getActualType().getValue());
                statement.setString(25, info.getBillSourceOrgunitID());
                statement.addBatch();
                isRun = true;
                if (++batchCounter < 200) continue;
                statement.executeBatch();
                batchCounter = 0;
            }
            if (isRun && batchCounter != 0) {
                statement.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    static void insertCtrlRecord(Context ctx, BgCtrlRecordCollection ctrlRecordCol) throws BOSException, EASBizException {
        if (BudgetCtrlUtil.isEmpty((Object)ctrlRecordCol)) {
            return;
        }
        IBgCtrlRecord iBgCtrlRecord = BgCtrlRecordFactory.getLocalInstance(ctx);
        for (int i = 0; i < ctrlRecordCol.size(); ++i) {
            BgCtrlRecordInfo ctrlRecordInfo = ctrlRecordCol.get(i);
            if (BudgetCtrlUtil.isEmpty(ctrlRecordInfo.getBillId()) || ctrlRecordInfo.getActualAmount() != null && ctrlRecordInfo.getActualAmount().floatValue() == 0.0f) continue;
            iBgCtrlRecord.addnew((CoreBaseInfo)ctrlRecordInfo);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void lockCostCenterTransaction(Context ctx, List costCenterIds) throws BOSException, EASBizException {
        if (BudgetCtrlUtil.isEmpty(costCenterIds)) {
            return;
        }
        Timestamp now = new Timestamp(new Date().getTime());
        StringBuffer query = new StringBuffer(512);
        query.append(" select FUpdateTime,");
        query.append("        FTimeCount");
        query.append("   from T_BG_BgTransaction");
        query.append("  where FSysType = 6");
        query.append("    and FNumber = 'requestBudget'");
        query.append("    and FId = ?");
        StringBuffer update = new StringBuffer(512);
        update.append(" update T_BG_BgTransaction");
        update.append("    set FUpdateTime = ?, ");
        update.append("        FTimeCount = FTimeCount + 1");
        update.append("  where FSysType = 6");
        update.append("    and FNumber = 'requestBudget'");
        update.append("    and FId = ?");
        StringBuffer insert = new StringBuffer(512);
        insert.append(" insert into T_BG_BgTransaction ");
        insert.append(" values (?, 6, 'requestBudget', getDate(), 0)");
        Connection con = null;
        PreparedStatement querySta = null;
        PreparedStatement insertSta = null;
        PreparedStatement updateSta = null;
        ResultSet queryRst = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            querySta = con.prepareStatement(query.toString());
            insertSta = con.prepareStatement(insert.toString());
            updateSta = con.prepareStatement(update.toString());
            int batchCounter = 0;
            for (int i = 0; i < costCenterIds.size(); ++i) {
                String ccid = (String)costCenterIds.get(i);
                querySta.setString(1, ccid);
                queryRst = querySta.executeQuery();
                if (queryRst == null || !queryRst.next()) {
                    insertSta.setString(1, ccid);
                    insertSta.executeUpdate();
                }
                updateSta.setTimestamp(1, now);
                updateSta.setString(2, ccid);
                updateSta.addBatch();
                if (++batchCounter < 200) continue;
                updateSta.executeBatch();
                batchCounter = 0;
            }
            if (batchCounter != 0) {
                updateSta.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(queryRst);
                SQLUtils.cleanup(querySta);
                SQLUtils.cleanup(insertSta);
                SQLUtils.cleanup(updateSta);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(queryRst);
        SQLUtils.cleanup((Statement)querySta);
        SQLUtils.cleanup((Statement)insertSta);
        SQLUtils.cleanup((Statement)updateSta);
        SQLUtils.cleanup((Connection)con);
    }

    static Map getBgDataMap(Context ctx, BgCtrlResultCollection ctrlResultCol, Map returnData) throws EASBizException, BOSException {
        HashMap<String, BigDecimal> bgDataMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (!isRequestBudget) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (bgDataId == null || reqAmount == null) continue;
            if (bgDataMap.containsKey(bgDataId)) {
                BigDecimal val = (BigDecimal)bgDataMap.get(bgDataId);
                bgDataMap.put(bgDataId, reqAmount.add(val));
            } else {
                bgDataMap.put(bgDataId, reqAmount);
            }
            BgCtrlResultCollection tempCol = (BgCtrlResultCollection)((Object)ctrlResultInfo.get("superiorItemCtrlResultCol"));
            if (tempCol == null || tempCol.isEmpty()) continue;
            for (int j = 0; j < tempCol.size(); ++j) {
                BgCtrlResultInfo tmpInfo = tempCol.get(j);
                String tmpBgDataId = tmpInfo.getBgDataId();
                BigDecimal tmpReqAmt = tmpInfo.getReqAmount();
                if (tmpBgDataId == null || tmpReqAmt == null) continue;
                if (bgDataMap.containsKey(tmpBgDataId)) {
                    BigDecimal val = (BigDecimal)bgDataMap.get(tmpBgDataId);
                    bgDataMap.put(tmpBgDataId, tmpReqAmt.add(val));
                    continue;
                }
                bgDataMap.put(tmpBgDataId, tmpReqAmt);
            }
        }
        if (!BudgetCtrlUtil.isEmpty(returnData)) {
            for (String bgDataId : returnData.keySet()) {
                BigDecimal returnVal = (BigDecimal)returnData.get(bgDataId);
                if (bgDataMap.containsKey(bgDataId)) {
                    BigDecimal val = (BigDecimal)bgDataMap.get(bgDataId);
                    bgDataMap.put(bgDataId, val.subtract(returnVal));
                    continue;
                }
                bgDataMap.put(bgDataId, returnVal.multiply(BudgetCtrlConstants.NEG_ONE_AMOUNT));
            }
        }
        return bgDataMap;
    }

    static BgCtrlResultCollection getSuperiorItemCtrlData(Context ctx, BgCtrlResultCollection ctrlResultCol) throws EASBizException, BOSException {
        IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
        return iBgItem.getSuperiorItemCtrlData(ctrlResultCol);
    }

    static Map processMultiRuleCol(BgControlMultiRuleCollection multiRuleCol) {
        HashMap<String, BgControlMultiRuleInfo> retMap = new HashMap<String, BgControlMultiRuleInfo>();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            return retMap;
        }
        for (int i = 0; i < multiRuleCol.size(); ++i) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i);
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (!StringUtils.isEmpty((String)bizItemCombNumber)) {
                bizItemCombNumber = bizItemCombNumber.replaceAll(",", "_");
            }
            retMap.put(bizItemCombNumber, multiRule);
        }
        return retMap;
    }

    static BigDecimal calcuRequestAmount(BigDecimal requestValue, String oqlRequest, Map fieldValueMap, String oqlExtendExpr) throws EASBizException, BOSException {
        String[] extendExpr;
        BigDecimal result = requestValue;
        String[] oqlRequestSplited = oqlRequest.split("\\|");
        if (oqlRequestSplited.length < 2) {
            return result;
        }
        String oqlRequestExp = oqlRequestSplited[1];
        HashMap paramValMap = new HashMap();
        String expression = oqlRequestExp.replaceAll("\\.", "\\_");
        Object resultVal = null;
        if (!StringUtils.isEmpty((String)oqlExtendExpr) && (extendExpr = oqlExtendExpr.split("\\,")) != null && extendExpr.length > 0) {
            for (int j = 0; j < extendExpr.length; ++j) {
                if (StringUtils.isEmpty((String)extendExpr[j]) || fieldValueMap.get(extendExpr[j]) == null) continue;
                paramValMap.put(extendExpr[j].replaceAll("\\.", "\\_"), fieldValueMap.get(extendExpr[j]));
            }
        }
        if (!BudgetCtrlUtil.isEmpty(resultVal = new Interpreter().evalExpr(expression, paramValMap)) && (resultVal instanceof BigDecimal || resultVal instanceof Number)) {
            if (resultVal instanceof Number) {
                resultVal = new BigDecimal(resultVal.toString());
            }
            result = requestValue.multiply((BigDecimal)resultVal);
        }
        return result;
    }

    static BigDecimal calcuRequestAmount(BigDecimal requestValue, String oqlRequest, String oqlRequestExp, IRowSet rst, int itemFieldCount) throws EASBizException, BOSException, SQLException {
        BigDecimal result = requestValue;
        String[] request = oqlRequest.split("\\|");
        if (BudgetCtrlUtil.isEmpty(request) || request.length != 2 || BudgetCtrlUtil.isEmpty(request[1])) {
            return result;
        }
        HashMap<String, BigDecimal> paramValMap = new HashMap<String, BigDecimal>();
        String expression = request[1].replaceAll("\\.", "\\_");
        Object resultVal = null;
        if (BudgetCtrlUtil.isEmpty(oqlRequestExp)) {
            resultVal = new Interpreter().evalExpr(expression, paramValMap);
        } else {
            String[] fields = oqlRequestExp.split("\\,");
            for (int j = 0; j < fields.length; ++j) {
                String fieldKey = fields[j].replaceAll("\\.", "\\_");
                BigDecimal fieldVal = rst.getBigDecimal(6 + 2 * itemFieldCount + j + 1);
                paramValMap.put(fieldKey, fieldVal);
            }
            resultVal = new Interpreter().evalExpr(expression, paramValMap);
        }
        if (!BudgetCtrlUtil.isEmpty(resultVal) && (resultVal instanceof BigDecimal || resultVal instanceof Integer || resultVal instanceof Double)) {
            result = resultVal instanceof BigDecimal ? requestValue.multiply((BigDecimal)resultVal) : requestValue.multiply(new BigDecimal(resultVal.toString()));
        }
        return result;
    }

    static boolean hasScheme(Context ctx, String boName, BOSUuid boId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)boName) || boId == null) {
            return false;
        }
        if ("com.kingdee.eas.ma.nbudget.app.BudgetRequestBill".equalsIgnoreCase(boName)) {
            ICoreBase iInterface = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)boId.getType());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("bgScheme");
            CoreBaseInfo _model = iInterface.getValue((IObjectPK)new ObjectUuidPK(boId), sic);
            if (_model != null && !StringUtils.isEmpty((String)_model.getString("bgScheme.id"))) {
                return true;
            }
        }
        return false;
    }

    static boolean hasScheme(Context ctx, String boName, IObjectValue model) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)boName) || model == null) {
            return false;
        }
        return "com.kingdee.eas.ma.nbudget.app.BudgetRequestBill".equalsIgnoreCase(boName) && model != null && !StringUtils.isEmpty((String)model.getString("bgScheme.id"));
    }

    static String getActivedBgSchemeID(Context ctx, BgCtrlParamInfo ctrlParamInfo, Date bizDate, String boName, String boId) throws EASBizException, BOSException {
        if ("com.kingdee.eas.ma.nbudget.app.BudgetRequestBill".equalsIgnoreCase(boName)) {
            if (StringUtils.isEmpty((String)boId)) {
                logger.error((Object)"budget Control Error:boId is null!");
            } else {
                ICoreBase iInterface = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)boId).getType());
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("bgScheme");
                CoreBaseInfo _model = iInterface.getValue((IObjectPK)new ObjectUuidPK(boId), sic);
                if (((BudgetRequestBillInfo)_model).getBgScheme() != null && ((BudgetRequestBillInfo)_model).getBgScheme().getId() != null) {
                    return ((BudgetRequestBillInfo)_model).getBgScheme().getId().toString();
                }
            }
        }
        return BudgetCtrlHelper.getActivedBgSchemeID(ctx, ctrlParamInfo, bizDate);
    }

    static String getActivedBgSchemeID(Context ctx, BgCtrlParamInfo ctrlParamInfo, Date bizDate, IObjectValue model) throws EASBizException, BOSException {
        if (model instanceof BudgetRequestBillInfo && ((BudgetRequestBillInfo)model).getBgScheme() != null && ((BudgetRequestBillInfo)model).getBgScheme().getId() != null) {
            return ((BudgetRequestBillInfo)model).getBgScheme().getId().toString();
        }
        return BudgetCtrlHelper.getActivedBgSchemeID(ctx, ctrlParamInfo, bizDate);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getActivedBgSchemeID(Context ctx, BgCtrlParamInfo ctrlParamInfo, Date bizDate) throws EASBizException, BOSException {
        ResultSet rst;
        PreparedStatement statement;
        Connection conn;
        block5: {
            String string;
            conn = null;
            statement = null;
            rst = null;
            StringBuffer kSql = new StringBuffer();
            kSql.append(" select FId");
            kSql.append("   from T_BG_BgScheme");
            kSql.append("  where FOrgUnitId = ?");
            kSql.append("    and FDateFrom <= ?");
            kSql.append("    and FDateTo >= ?");
            kSql.append("    and FIsFormal = 1");
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                statement = conn.prepareStatement(kSql.toString());
                java.sql.Date sqlDate = new java.sql.Date(bizDate.getTime());
                statement.setString(1, ctrlParamInfo.getOrgUnitId());
                statement.setDate(2, sqlDate);
                statement.setDate(3, sqlDate);
                rst = statement.executeQuery();
                if (!rst.next()) break block5;
                string = rst.getString(1);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, ex);
                    catch (Exception ex2) {
                        logger.error((Object)"error:", (Throwable)ex2);
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, statement, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)statement, (Connection)conn);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)statement, (Connection)conn);
        return null;
    }

    static BgPeriodInfo mappingBgPeriod(Context ctx, Date bizDate, BgControlSchemeInfo ctrlScheme, int periodType, String customBgPeriodNumber) throws EASBizException, BOSException {
        if (bizDate == null) {
            return null;
        }
        BgPeriodCollection bgPeriodCol = null;
        BgPeriodInfo bgPeriodInfo = null;
        BgControlPeriodMapCollection periodMap = ctrlScheme.getPeriodMap();
        if (periodMap != null && periodMap.size() > 0) {
            try {
                IBgControlPeriodMap bgControlPeriodMap = BgControlPeriodMapFactory.getLocalInstance(ctx);
                bgPeriodInfo = (BgPeriodInfo)bgControlPeriodMap.queryBgPeriod(ctrlScheme.getId().toString(), bizDate, BgPeriodEnum.getEnum(periodType));
            }
            catch (EASBizException ex) {
                logger.info((Object)ex.getMessage());
            }
        }
        if (bgPeriodInfo != null) {
            return bgPeriodInfo;
        }
        if (periodType == 8 && !BudgetCtrlUtil.isEmpty(customBgPeriodNumber)) {
            bgPeriodInfo = BudgetCtrlHelper.getBgPeriod(ctx, customBgPeriodNumber.trim());
        } else {
            try {
                bgPeriodCol = BgHelper.getBgPeriodCollOnDateBySQL(ctx, periodType, bizDate);
            }
            catch (Exception e) {
                logger.error((Object)("Ctrl Not Find BgPeriodInfo:" + periodType + "|" + (bizDate == null ? "bizDate is null" : new SimpleDateFormat("yyyy-MM-dd").format(bizDate))));
                throw new BgPeriodException(BgPeriodException.NOEXIST);
            }
            if (bgPeriodCol != null && bgPeriodCol.size() > 0) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
            if (bgPeriodInfo == null) {
                logger.error((Object)("Ctrl Not Find BgPeriodInfo:" + periodType + "|" + new SimpleDateFormat("yyyy-MM-dd").format(bizDate)));
                throw new BgPeriodException(BgPeriodException.NOEXIST);
            }
        }
        return bgPeriodInfo;
    }

    static BgPeriodInfo mappingBgPeriod(Context ctx, Date bizDate, String bgCtrlSchemeId, int periodType, String customBgPeriodNumber) throws EASBizException, BOSException {
        BgPeriodCollection bgPeriodCol = null;
        BgPeriodInfo bgPeriodInfo = null;
        IBgControlPeriodMap bgControlPeriodMap = BgControlPeriodMapFactory.getLocalInstance(ctx);
        IObjectValue bgPeriod = null;
        boolean isNotDefineMapPeriod = false;
        boolean isNotFindMapPeriod = false;
        try {
            bgPeriod = bgControlPeriodMap.queryBgPeriod(bgCtrlSchemeId, bizDate, BgPeriodEnum.getEnum(periodType));
        }
        catch (EASBizException ex) {
            if (ex instanceof BgControlException) {
                if (ex.getSubCode().equals(BgControlException.NOTDEFINDMAPPERIOD.getCode())) {
                    isNotDefineMapPeriod = true;
                }
                if (ex.getSubCode().equals(BgControlException.NOTFOUNDMAPPERIOD.getCode())) {
                    isNotFindMapPeriod = true;
                }
                throw ex;
            }
            throw ex;
        }
        if (!isNotDefineMapPeriod) {
            if (!isNotFindMapPeriod && bgPeriod != null) {
                bgPeriodInfo = (BgPeriodInfo)bgPeriod;
            } else if (isNotFindMapPeriod || bgPeriod == null) {
                return null;
            }
        } else {
            if (periodType == 8 && !BudgetCtrlUtil.isEmpty(customBgPeriodNumber)) {
                try {
                    IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance(ctx);
                    bgPeriodInfo = iBgPeriod.getBgPeriodInfo("select id,number where number = '" + customBgPeriodNumber.trim() + "'");
                }
                catch (ObjectNotFoundException ex) {
                    throw new BgCtrlException(BgCtrlException.NOBGPERIOD);
                }
            }
            try {
                bgPeriodCol = BgHelper.getBgPeriodCollOnDate(ctx, periodType, bizDate);
            }
            catch (Exception e) {
                logger.error((Object)("Ctrl Not Find BgPeriodInfo:" + periodType + "|" + new SimpleDateFormat("yyyy-MM-dd").format(bizDate)));
                throw new BgPeriodException(BgPeriodException.NOEXIST);
            }
            if (bgPeriodCol != null && bgPeriodCol.size() > 0) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
            if (bgPeriodInfo == null) {
                logger.error((Object)("Ctrl Not Find BgPeriodInfo:" + periodType + "|" + new SimpleDateFormat("yyyy-MM-dd").format(bizDate)));
                throw new BgPeriodException(BgPeriodException.NOEXIST);
            }
        }
        return bgPeriodInfo;
    }

    static String mappingBgItem(Context ctx, String billItemExp, BgControlSchemeInfo ctrlScheme, String orgUnitId) throws EASBizException, BOSException {
        String bgItemCombinNumber = null;
        BgControlItemMapCollection mapCol = ctrlScheme.getItemMap();
        if (mapCol == null || mapCol.size() == 0) {
            return bgItemCombinNumber;
        }
        for (int i = 0; i < mapCol.size(); ++i) {
            String[] paramKeys;
            String[] dbKeys;
            BgControlItemMapInfo mapInfo = mapCol.get(i);
            String key = mapInfo.getBillItemCombinValue();
            if (key.equals(billItemExp)) {
                bgItemCombinNumber = mapInfo.getBgItemCombinKey();
                break;
            }
            if (key.indexOf("%") < 0 || (dbKeys = key.split("\\|")).length != (paramKeys = billItemExp.split("\\|")).length) continue;
            boolean notHit = false;
            StringBuffer numbers = new StringBuffer();
            for (int j = 0; j < dbKeys.length; ++j) {
                String paramKey;
                String dbKey = dbKeys[j];
                if (BudgetCtrlHelper.isGeneralAssActType(dbKey)) {
                    dbKey = dbKey.replaceAll("!", ".");
                }
                if (BudgetCtrlHelper.isGeneralAssActType(paramKey = paramKeys[j])) {
                    paramKey = paramKey.replaceAll("!", ".");
                }
                if (dbKey.indexOf("%") < 0) {
                    if (dbKey.equals(paramKey)) continue;
                    notHit = true;
                    break;
                }
                String temp = dbKey.replaceAll("\\%", "");
                if (!paramKey.startsWith(temp)) {
                    notHit = true;
                    break;
                }
                if (!temp.endsWith(":")) continue;
                numbers.append(",").append(paramKey.substring(paramKey.indexOf(58) + 1));
            }
            if (notHit) continue;
            bgItemCombinNumber = mapInfo.getBgItemCombinKey();
            if (numbers.length() <= 0) break;
            try {
                bgItemCombinNumber = BgFormulaFacadeFactory.getLocalInstance(ctx).parseBgItemCombi_ctrl(bgItemCombinNumber + numbers, orgUnitId);
            }
            catch (BgCommonException bgCommonException) {}
            break;
        }
        return bgItemCombinNumber;
    }

    private static Map getItemMap(String itemKey) {
        LinkedHashMap<String, String> resMap = new LinkedHashMap<String, String>();
        if (!StringUtils.isEmpty((String)itemKey)) {
            String[] dbKeys = itemKey.split("\\|");
            for (int i = 0; i < dbKeys.length; ++i) {
                String[] sub = dbKeys[i].split(":");
                if (sub.length > 1) {
                    resMap.put(sub[0], sub[1]);
                    continue;
                }
                resMap.put(sub[1], null);
            }
        }
        return resMap;
    }

    static boolean checkRuleCondition(Context ctx, IObjectValue info, String boName, BgControlRuleInfo rule, String oqlOrgUnit, String orgUnitValue, String oqlItemCombination, String itemCombinationValue, String oqlCurrency, String oqlBizDate, String oqlRequest, String oqlRequestExp, String oqlRuleCondition) throws BOSException, EASBizException {
        if (info.get("id") == null) {
            throw new BgCtrlException(BgCtrlException.BILLNOTSTORE);
        }
        String boID = info.get("id").toString();
        String oql = BudgetCtrlHelper.getEntityOQL(ctx, boID, oqlOrgUnit, orgUnitValue, oqlItemCombination, itemCombinationValue, oqlCurrency, oqlBizDate, oqlRequest, oqlRequestExp, oqlRuleCondition);
        if (oql == null || oql.length() == 0) {
            return true;
        }
        IDataProvider dp = EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(boName));
        dp.setObjectView(oql);
        String tmpsql = dp.getSQL();
        tmpsql = tmpsql.replaceAll("INNER JOIN", "LEFT OUTER JOIN");
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)tmpsql);
        try {
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, ex);
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return false;
    }

    private static String getEntityOQL(Context ctx, String boID, String oqlOrgUnit, String orgUnitValue, String oqlItemCombination, String itemCombinationValue, String oqlCurrency, String oqlBizDate, String oqlRequest, String oqlRequestExp, String oqlRuleCondition) {
        int i;
        String[] oqlOrgTmp = oqlOrgUnit.split("\\|");
        String oqlOrgField = oqlOrgTmp[0];
        String[] oqlItemCombinationTmp = oqlItemCombination.split("\\@");
        String[] oqlItemCombinationField = new String[oqlItemCombinationTmp.length];
        for (int i2 = 0; i2 < oqlItemCombinationTmp.length; ++i2) {
            String[] oqlItemCombinationTmpSub = oqlItemCombinationTmp[i2].split("\\|");
            oqlItemCombinationField[i2] = oqlItemCombinationTmpSub[0];
        }
        String[] oqlCurrencyTmp = oqlCurrency.split("\\|");
        String oqlCurrencyField = oqlCurrencyTmp[0];
        String[] oqlBizDateTmp = oqlBizDate.split("\\|");
        String oqlBizDateField = oqlBizDateTmp[0];
        String[] oqlRequestTmp = oqlRequest.split("\\|");
        String oqlRequestField = oqlRequestTmp[0];
        String[] oqlRequestExpTmp = null;
        if (oqlRequestExp != null && !oqlRequestExp.trim().equals("")) {
            oqlRequestExpTmp = oqlRequestExp.split(",");
        }
        String oqlSelect = "select number ," + oqlOrgField + ",";
        for (i = 0; i < oqlItemCombinationField.length; ++i) {
            oqlSelect = oqlSelect + oqlItemCombinationField[i] + ",";
        }
        oqlSelect = oqlSelect + oqlCurrencyField + "," + oqlBizDateField + "," + oqlRequestField;
        for (i = 0; oqlRequestExpTmp != null && i < oqlRequestExpTmp.length; ++i) {
            oqlSelect = oqlSelect + "," + oqlRequestExpTmp[i];
        }
        String oqlWhere = " where id = '" + boID + "'";
        oqlWhere = oqlWhere + " and ( " + oqlOrgField + " ='" + orgUnitValue + "') ";
        String[] _ss = itemCombinationValue.split("\\,");
        if (_ss.length != oqlItemCombinationField.length) {
            return null;
        }
        int x = 0;
        for (int j = 0; j < _ss.length; ++j) {
            oqlWhere = x == 0 ? oqlWhere + " and ( " + oqlItemCombinationField[j] + " ='" + _ss[j] + "' " : oqlWhere + " and " + oqlItemCombinationField[j] + " ='" + _ss[j] + "' ";
            ++x;
        }
        if (x >= 1) {
            oqlWhere = oqlWhere + " ) ";
        }
        String oql = oqlSelect + oqlWhere;
        if (oqlRuleCondition != null && oqlRuleCondition.length() > 0) {
            oql = oql + " and (" + oqlRuleCondition + ") ";
        }
        return oql;
    }

    static List getQueryBillOQL(Context ctx, String boID, String boName, String oqlOrgUnit, String oqlItemCombination, String oqlCurrency, String oqlBizDate, String oqlRequest, String oqlRequestExp, String oqlRuleCondition) {
        int i;
        String oqlOrgNameFiled;
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)ctx, (IMetaDataPK)new MetaDataPK(boName));
        String[] oqlOrgTemp = oqlOrgUnit.split("\\|");
        String oqlOrgField = oqlOrgTemp[0];
        String[] oqlOrgFieldWhere = null;
        if (oqlOrgTemp.length == 2) {
            oqlOrgFieldWhere = oqlOrgTemp[1].split("\\,");
        }
        if ((oqlOrgNameFiled = oqlOrgTemp[0]).toLowerCase(Locale.ENGLISH).endsWith(".number")) {
            oqlOrgNameFiled = oqlOrgNameFiled.replaceAll(".number", ".name");
        } else if (oqlOrgNameFiled.toLowerCase(Locale.ENGLISH).endsWith(".id")) {
            oqlOrgNameFiled = oqlOrgNameFiled.replaceAll(".id", ".name");
        }
        String[] oqlItemCombinationTemp = oqlItemCombination.split("\\@");
        String[] oqlItemCombinationField = new String[oqlItemCombinationTemp.length];
        String[][] oqlItemCombinationFieldWhere = new String[oqlItemCombinationTemp.length][];
        String[] aliasItemCombinationFiled = new String[oqlItemCombinationTemp.length];
        for (int i2 = 0; i2 < oqlItemCombinationTemp.length; ++i2) {
            String[] oqlItemCombinationTmpSub = oqlItemCombinationTemp[i2].split("\\|");
            oqlItemCombinationField[i2] = oqlItemCombinationTmpSub[0];
            if (oqlItemCombinationTmpSub[0].toLowerCase(Locale.ENGLISH).endsWith(".number")) {
                oqlItemCombinationTmpSub[0] = oqlItemCombinationTmpSub[0].replaceAll(".number", ".name");
            } else if (oqlItemCombinationTmpSub[0].toLowerCase(Locale.ENGLISH).endsWith(".id")) {
                oqlItemCombinationTmpSub[0] = oqlItemCombinationTmpSub[0].replaceAll(".id", ".name");
            } else if (oqlItemCombinationTmpSub[0].toLowerCase(Locale.ENGLISH).endsWith(".longnumber")) {
                oqlItemCombinationTmpSub[0] = oqlItemCombinationTmpSub[0].replaceAll(".longNumber", ".name");
            } else if (oqlItemCombinationTmpSub[0].toLowerCase(Locale.ENGLISH).endsWith(".bgitemnumber")) {
                oqlItemCombinationTmpSub[0] = oqlItemCombinationTmpSub[0].replaceAll(".bgItemNumber", ".bgItemName");
            } else if (oqlItemCombinationTmpSub[0].toLowerCase(Locale.ENGLISH).endsWith(".outbgitemnumber")) {
                oqlItemCombinationTmpSub[0] = oqlItemCombinationTmpSub[0].replaceAll(".outBgItemNumber", ".outBgItemName");
            } else if (oqlItemCombinationTmpSub[0].toLowerCase(Locale.ENGLISH).endsWith("number")) {
                if (entity != null && entity.getObjectValueClass() != null) {
                    try {
                        Class<?> infoClass = Class.forName(entity.getObjectValueClass());
                        if (Class.forName("com.kingdee.eas.fm.common.IFMBgUsed").isAssignableFrom(infoClass)) {
                            if (oqlItemCombinationTmpSub[0].endsWith("number")) {
                                oqlItemCombinationTmpSub[0] = oqlItemCombinationTmpSub[0].replaceAll("number", "name");
                            } else if (oqlItemCombinationTmpSub[0].endsWith("Number")) {
                                oqlItemCombinationTmpSub[0] = oqlItemCombinationTmpSub[0].replaceAll("Number", "Name");
                            }
                        }
                    }
                    catch (ClassNotFoundException infoClass) {}
                }
            } else if (oqlItemCombinationTmpSub[0].lastIndexOf(".") > -1) {
                oqlItemCombinationTmpSub[0] = oqlItemCombinationTmpSub[0].substring(0, oqlItemCombinationTmpSub[0].lastIndexOf(".")) + ".name";
            }
            aliasItemCombinationFiled[i2] = oqlItemCombinationTmpSub[0];
            if (oqlItemCombinationTmpSub.length != 2) continue;
            oqlItemCombinationFieldWhere[i2] = oqlItemCombinationTmpSub[1].split("\\,");
        }
        String[] oqlCurrencyTemp = oqlCurrency.split("\\|");
        String oqlCurrencyField = oqlCurrencyTemp[0];
        String[] oqlBizDateTemp = oqlBizDate.split("\\|");
        String oqlBizDateField = oqlBizDateTemp[0];
        String[] oqlRequestTemp = oqlRequest.split("\\|");
        String oqlRequestField = oqlRequestTemp[0];
        String[] oqlRequestExpTemp = null;
        if (!BudgetCtrlUtil.isEmpty(oqlRequestExp)) {
            oqlRequestExpTemp = oqlRequestExp.split("\\,");
        }
        String oqlSelect = "select number ," + oqlOrgField + "," + oqlOrgNameFiled + ",";
        for (i = 0; i < oqlItemCombinationField.length; ++i) {
            oqlSelect = oqlSelect + oqlItemCombinationField[i] + "," + aliasItemCombinationFiled[i] + ",";
        }
        oqlSelect = oqlSelect + oqlCurrencyField + "," + oqlBizDateField + "," + oqlRequestField;
        for (i = 0; oqlRequestExpTemp != null && i < oqlRequestExpTemp.length; ++i) {
            oqlSelect = oqlSelect + "," + oqlRequestExpTemp[i];
        }
        if ("com.kingdee.eas.fi.gl.app.Voucher".equalsIgnoreCase(boName)) {
            if (!StringUtils.isEmpty((String)oqlRequestTemp[0])) {
                if (oqlRequestTemp[0].indexOf("entries.assistRecords.") >= 0) {
                    oqlSelect = oqlSelect + ", entries.assistRecords.id";
                } else if (oqlRequestTemp[0].indexOf("entries.cashflowEntry.") >= 0) {
                    oqlSelect = oqlSelect + ", entries.cashflowEntry.id";
                } else if (oqlRequestTemp[0].indexOf("entries.") >= 0) {
                    oqlSelect = oqlSelect + ", entries.id";
                }
            }
        } else if ("com.kingdee.eas.ma.nbudget.app.BudgetRequestBill".equals(boName)) {
            oqlSelect = oqlSelect + ", bgEnties.bgElement.number";
        }
        String oqlWhere = " where id = '" + boID + "'";
        String subOqlEntryWhere = "";
        int x = 0;
        int y = 0;
        for (int j = 0; oqlOrgFieldWhere != null && j < oqlOrgFieldWhere.length; ++j) {
            boolean isComposion = BudgetCtrlHelper.isComposion(entity, oqlOrgField);
            if (isComposion) {
                subOqlEntryWhere = x == 0 ? subOqlEntryWhere + " ( " + oqlOrgField + " ='" + oqlOrgFieldWhere[j] + "' " : subOqlEntryWhere + " or " + oqlOrgField + " ='" + oqlOrgFieldWhere[j] + "' ";
                ++x;
            } else {
                oqlWhere = y == 0 ? oqlWhere + " and ( " + oqlOrgField + " ='" + oqlOrgFieldWhere[j] + "' " : oqlWhere + " or " + oqlOrgField + " ='" + oqlOrgFieldWhere[j] + "' ";
                ++y;
            }
            if (x >= 1 && j == oqlOrgFieldWhere.length - 1) {
                subOqlEntryWhere = subOqlEntryWhere + " ) ";
            }
            if (y < 1 || j != oqlOrgFieldWhere.length - 1) continue;
            oqlWhere = oqlWhere + " ) ";
        }
        for (int i3 = 0; i3 < oqlItemCombinationField.length; ++i3) {
            x = 0;
            y = 0;
            for (int j = 0; oqlItemCombinationFieldWhere[i3] != null && j < oqlItemCombinationFieldWhere[i3].length; ++j) {
                boolean isComposion = BudgetCtrlHelper.isComposion(entity, oqlItemCombinationField[i3]);
                if (isComposion) {
                    subOqlEntryWhere = x == 0 ? (subOqlEntryWhere.trim().equals("") ? subOqlEntryWhere + " ( " + oqlItemCombinationField[i3] + " ='" + oqlItemCombinationFieldWhere[i3][j] + "' " : subOqlEntryWhere + " and ( " + oqlItemCombinationField[i3] + " ='" + oqlItemCombinationFieldWhere[i3][j] + "' ") : subOqlEntryWhere + " or " + oqlItemCombinationField[i3] + " ='" + oqlItemCombinationFieldWhere[i3][j] + "' ";
                    ++x;
                } else {
                    oqlWhere = y == 0 ? oqlWhere + " and ( " + oqlItemCombinationField[i3] + " ='" + oqlItemCombinationFieldWhere[i3][j] + "' " : oqlWhere + " or " + oqlItemCombinationField[i3] + " ='" + oqlItemCombinationFieldWhere[i3][j] + "' ";
                    ++y;
                }
                if (x >= 1 && j == oqlItemCombinationFieldWhere[i3].length - 1) {
                    subOqlEntryWhere = subOqlEntryWhere + " ) ";
                }
                if (y < 1 || j != oqlItemCombinationFieldWhere[i3].length - 1) continue;
                oqlWhere = oqlWhere + " ) ";
            }
        }
        String oql = oqlSelect + oqlWhere;
        if (subOqlEntryWhere != null && !subOqlEntryWhere.trim().equals("")) {
            oql = oql + " and ( " + subOqlEntryWhere + " )";
        }
        if (oqlRuleCondition != null && oqlRuleCondition.length() > 0) {
            oql = oql + " and (" + oqlRuleCondition + ") ";
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(oql);
        result.add(new Integer(oqlItemCombinationField.length));
        result.add(new Integer(oqlRequestExpTemp == null ? 0 : oqlRequestExpTemp.length));
        return result;
    }

    static boolean isComposion(EntityObjectInfo entity, String oqlField) {
        LinkPropertyInfo linkPro;
        CardinalityType cType;
        PropertyInfo prop;
        boolean isComposion = false;
        String[] temp = oqlField.split("\\.");
        if (temp != null && temp.length >= 1 && (prop = entity.getPropertyByName(temp[0])) instanceof LinkPropertyInfo && ((cType = (linkPro = (LinkPropertyInfo)prop).getRelationship().getSupplierCardinality()).getName().equals(CardinalityType.ONE_TO_UNBOUNDED.getName()) || cType.getName().equals(CardinalityType.ZERO_TO_UNBOUNDED.getName()))) {
            isComposion = true;
        }
        return isComposion;
    }

    static void mergeSameCtrlParam(BgCtrlParamInfo ctrlParamInfo, BgCtrlParamCollection ctrlParamCol, Map checkDumpParam) {
        String theKey = ctrlParamInfo.getOrgUnitId().toString() + "\\#" + ctrlParamInfo.getItemCombinNumber() + "\\#" + ctrlParamInfo.getCurrencyNumber() + "\\#" + ctrlParamInfo.getPeriodNumber() + "\\#" + ctrlParamInfo.getElementNumber();
        if (checkDumpParam.containsKey(theKey)) {
            for (int j = 0; j < ctrlParamCol.size(); ++j) {
                BgCtrlParamInfo tmpCtrl = ctrlParamCol.get(j);
                String tmpKey = tmpCtrl.getOrgUnitId().toString() + "\\#" + tmpCtrl.getItemCombinNumber() + "\\#" + tmpCtrl.getCurrencyNumber() + "\\#" + tmpCtrl.getPeriodNumber() + "\\#" + tmpCtrl.getElementNumber();
                if (!tmpKey.equals(theKey)) continue;
                tmpCtrl.setAmount(tmpCtrl.getAmount() == null ? ctrlParamInfo.getAmount() : tmpCtrl.getAmount().add(ctrlParamInfo.getAmount()));
            }
        } else {
            BgCtrlParamInfo temp = (BgCtrlParamInfo)ctrlParamInfo.clone();
            temp.setBillSourceOrgUnitId(ctrlParamInfo.getBillSourceOrgUnitId());
            ctrlParamCol.add(temp);
            checkDumpParam.put(theKey, null);
        }
    }

    static BgCtrlResultInfo fillCtrlParam2CtrlResult(BgCtrlParamInfo ctrlParamInfo, BgCtrlResultInfo ctrlResultInfo) throws BOSException, EASBizException {
        String orgUnitId = ctrlParamInfo.getOrgUnitId();
        String orgUnitName = ctrlParamInfo.getOrgUnitName();
        String bgSchemeId = ctrlParamInfo.getBgSchemeId();
        String itemCombinNumber = ctrlParamInfo.getItemCombinNumber();
        String itemCombinName = ctrlParamInfo.getItemCombinName();
        String periodNumber = ctrlParamInfo.getPeriodNumber();
        String formula = ctrlParamInfo.getItemFormula();
        String billType = ctrlParamInfo.getBillType();
        String billId = ctrlParamInfo.getSrcBillId();
        String billNumber = ctrlParamInfo.getSrcBillNumber();
        String billItemAlias = ctrlParamInfo.getBillItemAlias();
        String billItemNumber = ctrlParamInfo.getBillItemNumber();
        String billItemName = ctrlParamInfo.getBillItemName();
        String periodName = ctrlParamInfo.getPeriodName();
        String elementName = ctrlParamInfo.getElementName();
        Date bizDate = ctrlParamInfo.getBizDate();
        BigDecimal reqAmount = ctrlParamInfo.getAmount();
        ctrlResultInfo.setOrgUnitId(orgUnitId);
        ctrlResultInfo.setOrgUnitName(orgUnitName);
        ctrlResultInfo.setBgSchemeId(bgSchemeId);
        ctrlResultInfo.setBgItemFormula(formula);
        ctrlResultInfo.setReqAmount(reqAmount);
        ctrlResultInfo.setBillType(billType);
        ctrlResultInfo.setBillId(billId);
        ctrlResultInfo.setBillNumber(billNumber);
        ctrlResultInfo.setBizDate(bizDate);
        ctrlResultInfo.setItemCombinNumber(itemCombinNumber);
        ctrlResultInfo.setItemCombinName(itemCombinName);
        ctrlResultInfo.setBillItemAlias(billItemAlias);
        ctrlResultInfo.setBillItemNumber(billItemNumber);
        ctrlResultInfo.setBillItemName(billItemName);
        ctrlResultInfo.setPeriodName(periodName);
        ctrlResultInfo.setElementName(elementName);
        ctrlResultInfo.setBgPeriodNumber(periodNumber);
        if (ctrlParamInfo.getPeriodType() != null) {
            ctrlResultInfo.setBgPeriodType(ctrlParamInfo.getPeriodType().getValue());
        }
        ctrlResultInfo.setBillSourceOrgunitID(ctrlParamInfo.getBillSourceOrgUnitId());
        return ctrlResultInfo;
    }

    static BgCtrlParamCollection processItemCombination(Context ctx, BgCtrlParamCollection ctrlParamCol) throws BOSException, EASBizException {
        for (int j = 0; j < ctrlParamCol.size(); ++j) {
            BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(j);
            String itemCombinNumber = ctrlParamInfo.getItemCombinNumber();
            if (itemCombinNumber != null && (itemCombinNumber.indexOf("_") > 0 || itemCombinNumber.indexOf(",") > 0)) {
                itemCombinNumber = BudgetCtrlCacheHelper.getBgItemCombinationKey(ctx, itemCombinNumber, ctrlParamInfo.getOrgUnitId());
                ctrlParamInfo.setItemCombinNumber(itemCombinNumber);
            }
            String itemCombinName = BudgetCtrlCacheHelper.getBgItemCombinationName(ctx, itemCombinNumber, ctrlParamInfo.getOrgUnitId());
            ctrlParamInfo.setItemCombinName(itemCombinName);
            String fromula = BudgetCtrlUtil.buildItemFormula(ctrlParamInfo.getItemCombinNumber(), ctrlParamInfo.getPeriodNumber(), ctrlParamInfo.getElementNumber(), ctrlParamInfo.getCurrencyNumber());
            ctrlParamInfo.setItemFormula(fromula);
        }
        return ctrlParamCol;
    }

    static String getItemCombinName(Context ctx, String itemCombinNumber, String orgUnitId) throws BOSException {
        String sql = " select fname_" + ctx.getLocale() + " from t_bg_bgitem where fnumber = ? and forgUnitId = ?";
        String[] keys = itemCombinNumber.replaceAll("\\,", "\\_").split("\\_");
        String itemCombinName = "";
        IRowSet rs = null;
        try {
            for (int i = 0; i < keys.length; ++i) {
                String name = "";
                String number = keys[i];
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{number, BgSHelper.getIsolateOrg(ctx, orgUnitId)});
                if (rs.next()) {
                    name = rs.getString(1);
                }
                itemCombinName = itemCombinName + name + "_";
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        itemCombinName = itemCombinName.substring(0, itemCombinName.length() - 1);
        return itemCombinName;
    }

    public static void processCurrencyPrecision(Context ctx, BgCtrlParamCollection ctrlParamCol, BgCtrlResultCollection ctrlResultCol) throws BOSException {
        int i;
        HashSet<String> currentSet = new HashSet<String>();
        for (int i2 = 0; i2 < ctrlParamCol.size(); ++i2) {
            if (ctrlParamCol.get(i2).getCurrencyNumber() == null) continue;
            currentSet.add(ctrlParamCol.get(i2).getCurrencyNumber());
        }
        if (currentSet.isEmpty()) {
            return;
        }
        ICurrency iCurr = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", currentSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("precision"));
        CurrencyCollection currencyColl = iCurr.getCurrencyCollection(view);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (i = 0; i < currencyColl.size(); ++i) {
            map.put(currencyColl.get(i).getNumber(), new Integer(currencyColl.get(i).getPrecision()));
        }
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            if (ctrlResultCol.get(i).getBalance() == null || ctrlParamCol == null || i >= ctrlParamCol.size() || !map.containsKey(ctrlParamCol.get(i).getCurrencyNumber())) continue;
            int precision = (Integer)map.get(ctrlParamCol.get(i).getCurrencyNumber());
            ctrlResultCol.get(i).setBalance(ctrlResultCol.get(i).getBalance().divide(new BigDecimal("1.00"), precision, 6));
        }
    }

    static void processSpecialValue(String oql, HashMap whereMap) {
        String[] oqlTemp = oql.split("\\|");
        String oqlField = oqlTemp[0];
        String[] oqlFieldWhere = null;
        HashMap<String, String> valueMap = new HashMap<String, String>();
        if (oqlTemp.length == 2) {
            oqlFieldWhere = oqlTemp[1].split("\\,");
            for (int i = 0; i < oqlFieldWhere.length; ++i) {
                valueMap.put(oqlFieldWhere[i], oqlFieldWhere[i]);
            }
        }
        whereMap.put(oqlField, valueMap);
    }

    static void filterSpecialValue(List fieldValues, HashMap whereMap) {
        if (whereMap == null || whereMap.size() == 0) {
            return;
        }
        Map fieldValueMap = null;
        String key2 = null;
        Map specialValue = null;
        for (String key2 : whereMap.keySet()) {
            specialValue = (Map)whereMap.get(key2);
            if (specialValue == null || specialValue.isEmpty()) continue;
            int size = fieldValues.size();
            for (int i = size - 1; i >= 0; --i) {
                fieldValueMap = (Map)fieldValues.get(i);
                if (!fieldValueMap.containsKey(key2) || specialValue.containsKey(fieldValueMap.get(key2))) continue;
                fieldValues.remove(i);
            }
        }
    }

    static void processItemCombinSpecialValue(String oqlItemCombination, HashMap whereMap) {
        String[] oqlItemCombinationTemp = oqlItemCombination.split("\\@");
        String[] oqlItemCombinationField = new String[oqlItemCombinationTemp.length];
        String[][] oqlItemCombinationFieldWhere = new String[oqlItemCombinationTemp.length][];
        for (int i = 0; i < oqlItemCombinationTemp.length; ++i) {
            String[] oqlItemCombinationTempSub = oqlItemCombinationTemp[i].split("\\|");
            oqlItemCombinationField[i] = oqlItemCombinationTempSub[0];
            HashMap<String, String> valueMap = new HashMap<String, String>();
            if (oqlItemCombinationTempSub.length == 2) {
                oqlItemCombinationFieldWhere[i] = oqlItemCombinationTempSub[1].split("\\,");
                for (int j = 0; j < oqlItemCombinationFieldWhere[i].length; ++j) {
                    valueMap.put(oqlItemCombinationFieldWhere[i][j], oqlItemCombinationFieldWhere[i][j]);
                }
            }
            whereMap.put(oqlItemCombinationField[i], valueMap);
        }
    }

    static Vector getOQLFieldsAndICLength(BgControlRuleInfo rule) {
        Vector<Serializable> result = new Vector<Serializable>();
        Vector<String> fields = new Vector<String>();
        String oqlOrgUnit = rule.getOqlOrgUnit();
        String oqlItemCombination = rule.getOqlItemCombination();
        String oqlCurrency = rule.getOqlCurrency();
        String oqlBizDate = rule.getOqlBizDate();
        String oqlRequest = rule.getOqlRequest();
        String[] oqlOrgTemp = oqlOrgUnit.split("\\|");
        String oqlOrgField = oqlOrgTemp[0];
        fields.add(oqlOrgField);
        String[] oqlItemCombinationTemp = oqlItemCombination.split("\\@");
        String[] oqlItemCombinationField = new String[oqlItemCombinationTemp.length];
        for (int i = 0; i < oqlItemCombinationTemp.length; ++i) {
            String[] oqlItemCombinationTempSub = oqlItemCombinationTemp[i].split("\\|");
            oqlItemCombinationField[i] = oqlItemCombinationTempSub[0];
            fields.add(oqlItemCombinationField[i]);
        }
        String[] oqlCurrencyTemp = oqlCurrency.split("\\|");
        String oqlCurrencyField = oqlCurrencyTemp[0];
        fields.add(oqlCurrencyField);
        String[] oqlBizDateTemp = oqlBizDate.split("\\|");
        String oqlBizDateField = oqlBizDateTemp[0];
        fields.add(oqlBizDateField);
        String[] oqlRequestTemp = oqlRequest.split("\\|");
        String oqlRequestField = oqlRequestTemp[0];
        fields.add(oqlRequestField);
        result.add(fields);
        result.add(new Integer(oqlItemCombinationField.length));
        return result;
    }

    static String[] getOQLFields(BgControlRuleInfo rule) {
        int j;
        String[] extendExpr;
        if (rule == null) {
            return null;
        }
        String oqlOrgUnit = rule.getOqlOrgUnit();
        String oqlItemCombination = rule.getOqlItemCombination();
        String oqlCurrency = rule.getOqlCurrency();
        String oqlBizDate = rule.getOqlBizDate();
        String oqlRequest = rule.getOqlRequest();
        String[] oqlItemCombinationTemp = oqlItemCombination.split("\\@");
        HashMap oqlItems = new HashMap();
        for (int i = 0; i < oqlItemCombinationTemp.length; ++i) {
            String[] oqlItemCombinationTempSub = oqlItemCombinationTemp[i].split("\\|");
            oqlItems.put(oqlItemCombinationTempSub[0], null);
        }
        ArrayList<String> fields = new ArrayList<String>();
        String[] oqlOrgTemp = oqlOrgUnit.split("\\|");
        String oqlOrgField = oqlOrgTemp[0];
        fields.add(oqlOrgField);
        String[] oqlCurrencyTemp = oqlCurrency.split("\\|");
        String oqlCurrencyField = oqlCurrencyTemp[0];
        fields.add(oqlCurrencyField);
        String[] oqlBizDateTemp = oqlBizDate.split("\\|");
        String oqlBizDateField = oqlBizDateTemp[0];
        fields.add(oqlBizDateField);
        String[] oqlRequestTemp = oqlRequest.split("\\|");
        String oqlRequestField = oqlRequestTemp[0];
        fields.add(oqlRequestField);
        fields.add("");
        int i = 5;
        String itemNumber2 = null;
        String itemName = null;
        for (String itemNumber2 : oqlItems.keySet()) {
            if (!StringUtils.isEmpty((String)itemNumber2)) {
                fields.add(itemNumber2);
                ++i;
            } else {
                fields.add("");
                ++i;
            }
            itemName = BudgetCtrlHelper.generateNameFiled(itemNumber2);
            if (!StringUtils.isEmpty((String)itemName)) {
                fields.add(itemName);
                ++i;
                continue;
            }
            fields.add("");
            ++i;
        }
        if (!StringUtils.isEmpty((String)rule.getOqlRequestExtendExpression()) && (extendExpr = rule.getOqlRequestExtendExpression().split("\\,")) != null && extendExpr.length > 0) {
            for (j = 0; j < extendExpr.length; ++j) {
                if (StringUtils.isEmpty((String)extendExpr[j])) continue;
                fields.add(extendExpr[j]);
            }
        }
        String[] result = new String[fields.size()];
        for (j = 0; j < fields.size(); ++j) {
            result[j] = (String)fields.get(j);
        }
        return result;
    }

    static void generateNameFileds(String[] subNameFields) {
        if (BudgetCtrlUtil.isEmpty(subNameFields)) {
            return;
        }
        if (subNameFields.length > 1 && (subNameFields[subNameFields.length - 1].equalsIgnoreCase("number") || subNameFields[subNameFields.length - 1].equalsIgnoreCase("id"))) {
            subNameFields[subNameFields.length - 1] = "name";
        }
    }

    static String generateNameFiled(String subNameField) {
        if (BudgetCtrlUtil.isEmpty(subNameField)) {
            return null;
        }
        String oqlNameField = null;
        if (subNameField.indexOf(".id") != -1) {
            oqlNameField = subNameField.replaceAll(".id", ".name");
        } else if (subNameField.indexOf(".number") != -1) {
            oqlNameField = subNameField.replaceAll(".number", ".name");
        } else if (subNameField.indexOf(".longNumber") != -1) {
            oqlNameField = subNameField.replaceAll(".longNumber", ".name");
        } else if (subNameField.endsWith("number")) {
            oqlNameField = subNameField.replaceAll("number", "name");
        } else if (subNameField.endsWith("Number")) {
            oqlNameField = subNameField.replaceAll("Number", "Name");
        }
        return oqlNameField;
    }

    static Vector combinationItemVal(Vector[] valuesVec) {
        int i;
        Vector rstVec = new Vector();
        if (valuesVec.length == 1) {
            for (i = 0; i < valuesVec[0].size(); ++i) {
                rstVec.add(valuesVec[0].get(i));
            }
        }
        if (valuesVec.length == 2) {
            rstVec = BudgetCtrlHelper.subCombinationItemValue(valuesVec[0], valuesVec[1]);
        }
        if (valuesVec.length > 2) {
            rstVec = BudgetCtrlHelper.subCombinationItemValue(valuesVec[0], valuesVec[1]);
            for (i = 2; i < valuesVec.length; ++i) {
                rstVec = BudgetCtrlHelper.subCombinationItemValue(rstVec, valuesVec[i]);
            }
        }
        return rstVec;
    }

    private static Vector subCombinationItemValue(Vector one, Vector two) {
        Vector<String> rstVec = new Vector<String>();
        for (int i = 0; i < one.size(); ++i) {
            for (int j = 0; j < two.size(); ++j) {
                rstVec.add(one.get(i) + "," + two.get(j));
            }
        }
        return rstVec;
    }

    static boolean isCanCollect(BgCtrlResultInfo ctrlResultInfo) {
        if (ctrlResultInfo == null) {
            return false;
        }
        return ctrlResultInfo.getOrgUnitId() != null && ctrlResultInfo.getBgSchemeId() != null && ctrlResultInfo.getBgDataId() != null;
    }

    static Map getParentOrgUnitMap(Context ctx, Map orgUnitMap, boolean isFindUpperOrg, int findMaxLevel) throws EASBizException, BOSException {
        HashMap<String, CostCenterOrgUnitInfo> orgId2parentOrgMap = new HashMap<String, CostCenterOrgUnitInfo>();
        if (findMaxLevel <= 0 || orgUnitMap.isEmpty() || !isFindUpperOrg) {
            return orgId2parentOrgMap;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("isCU"));
        Map paramValue = BgNSHelper.getBgParamValue((Context)ctx);
        boolean isCtrlOverstepControlUnit = BgNSHelper.isCtrlOverstepControlUnit((Map)paramValue);
        block2: for (String orgUnitId : orgUnitMap.keySet()) {
            int index = 1;
            while (index <= findMaxLevel) {
                String realId;
                CostCenterOrgUnitInfo org = null;
                try {
                    org = (CostCenterOrgUnitInfo)NewOrgUnitHelper.getTypedOrgUnit((Context)ctx, (String)orgUnitId, (SelectorItemCollection)sic, (OrgType)OrgType.CostCenter);
                }
                catch (ObjectNotFoundException ex) {
                    logger.error((Object)"error:", (Throwable)ex);
                }
                if (org == null || org.get("parent") == null) continue block2;
                if (isCtrlOverstepControlUnit) {
                    realId = new String(orgUnitId);
                    orgId2parentOrgMap.put(realId, org.getParent());
                    orgUnitId = ((CostCenterOrgUnitInfo)org.get("parent")).getId().toString();
                    ++index;
                    continue;
                }
                if (org.isIsCU()) continue block2;
                realId = new String(orgUnitId);
                orgId2parentOrgMap.put(realId, org.getParent());
                orgUnitId = ((CostCenterOrgUnitInfo)org.get("parent")).getId().toString();
                ++index;
            }
        }
        return orgId2parentOrgMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map getAllParentOrgMap(Context ctx, Map orgUnitMap) throws EASBizException, BOSException {
        HashMap orgId2parentOrgMap = new HashMap();
        if (BudgetCtrlUtil.isEmpty(orgUnitMap)) {
            return orgId2parentOrgMap;
        }
        Set orgUnitSet = orgUnitMap.keySet();
        StringBuffer kSQL = new StringBuffer();
        kSQL.append("select a.FId as costCenterId,");
        kSQL.append("       b.FId as parentId,");
        kSQL.append("       b.FNumber as parentNumber,");
        kSQL.append("       b.FName_" + ctx.getLocale() + " as parentName");
        kSQL.append("  from T_ORG_CostCenter a,");
        kSQL.append("       T_ORG_CostCenter b");
        kSQL.append(" where a.FID in " + BgHelper.tranSet2String(orgUnitSet));
        kSQL.append("   and (SUBSTRING(a.FLongNumber, 0,LENGTH(b.FLongNumber) + 1) = b.FLongNumber || '!' AND b.FLevel < a.FLevel) ");
        kSQL.append(" order by a.FLongNumber desc, b.flongnumber desc");
        IRowSet rst = null;
        try {
            for (String orgUnitId : orgUnitSet) {
                orgId2parentOrgMap.put(orgUnitId, new ArrayList());
            }
            rst = DbUtil.executeQuery((Context)ctx, (String)kSQL.toString());
            while (rst.next()) {
                String ccid = rst.getString("costCenterId");
                String parentId = rst.getString("parentId");
                String parentNumber = rst.getString("parentNumber");
                String parentName = rst.getString("parentName");
                CostCenterOrgUnitInfo ccInfo = new CostCenterOrgUnitInfo();
                ccInfo.setId(BOSUuid.read((String)parentId));
                ccInfo.setNumber(parentNumber);
                ccInfo.setName(parentName);
                List tmp = (List)orgId2parentOrgMap.get(ccid);
                tmp.add(ccInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return orgId2parentOrgMap;
    }

    static boolean isSpecificallyOrg(Context ctx, String boName, IObjectValue billInfo, BgControlRuleCollection ruleCol) throws BOSException, EASBizException {
        Iterator iterator = ruleCol.iterator();
        while (iterator.hasNext()) {
            BgControlRuleInfo rule = (BgControlRuleInfo)iterator.next();
            String oqlOrgUnit = rule.getOqlOrgUnit();
            String[] oqlOrgTmp = oqlOrgUnit.split("\\|");
            if (oqlOrgTmp.length != 2) {
                return true;
            }
            String orgFiled = oqlOrgTmp[0];
            String[] SpecificallyOrgs = oqlOrgTmp[1].split("\\,");
            Vector fieldValues = BudgetCtrlUtil.getFieldValue(billInfo, orgFiled.split("\\."));
            for (int i = 0; i < SpecificallyOrgs.length; ++i) {
                String theSpecificallyOrg = SpecificallyOrgs[i];
                if (!theSpecificallyOrg.equals(fieldValues.get(0))) continue;
                return true;
            }
        }
        return false;
    }

    static Map getBgCtrlNeededFields(Context ctx, EntityObjectInfo entity, BgControlRuleCollection ruleCol) throws BOSException, EASBizException {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        if (ctx == null || entity == null || BudgetCtrlUtil.isEmpty((Object)ruleCol)) {
            return fieldsMap;
        }
        Iterator iterator = ruleCol.iterator();
        while (iterator.hasNext()) {
            BgControlRuleInfo rule = (BgControlRuleInfo)iterator.next();
            String oqlItemCombination = rule.getOqlItemCombination();
            String aliasItemCombination = rule.getAliasItemCombination();
            String[] tempField = oqlItemCombination.split("\\@");
            String[] tempAlias = aliasItemCombination.split("\\@");
            for (int i = 0; i < tempField.length; ++i) {
                String[] _tempField = tempField[i].split("\\|");
                String[] _tempAlias = tempAlias[i].split("\\|");
                fieldsMap.put(_tempField[0], _tempAlias[0]);
            }
            String oqlOrgUnit = rule.getOqlOrgUnit();
            String aliasOrgUnit = rule.getAliasOrgUnit();
            fieldsMap.put(oqlOrgUnit.split("\\|")[0], aliasOrgUnit.split("\\|")[0]);
            String oqlCurrency = rule.getOqlCurrency();
            String aliasCurrency = rule.getAliasCurrency();
            fieldsMap.put(oqlCurrency, aliasCurrency);
            String oqlBizDate = rule.getOqlBizDate();
            String aliasBizDate = rule.getAliasBizDate();
            fieldsMap.put(oqlBizDate, aliasBizDate);
            String oqlRequest = rule.getOqlRequest();
            String aliasRequest = rule.getAliasRequest();
            fieldsMap.put(oqlRequest.split("\\|")[0], aliasRequest.split("\\|")[0]);
            if (!StringUtils.isEmpty((String)rule.getOqlRequestExtendExpression())) {
                String oqlRequestExp = rule.getOqlRequestExtendExpression();
                String aliasRequestExp = MateUtils.getEntityPropertyAlias(entity, oqlRequestExp);
                fieldsMap.put(oqlRequestExp, oqlRequestExp);
            }
            if (StringUtils.isEmpty((String)rule.getOqlRuleCondition())) continue;
            try {
                FilterInfo filter = new FilterInfo(rule.getOqlRuleCondition());
                int in = filter.getFilterItems().size();
                for (int i = 0; i < in; ++i) {
                    FilterItemInfo item = filter.getFilterItems().get(i);
                    String property = item.getPropertyName();
                    String propertyAlias = MateUtils.getEntityPropertyAlias(entity, property);
                    fieldsMap.put(property, propertyAlias);
                }
            }
            catch (ParserException parserException) {
            }
        }
        return fieldsMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isNeededUpgradeCtrlRecord(Context ctx) throws EASBizException, BOSException {
        StringBuffer kSQL = new StringBuffer();
        kSQL.append(" select count(distinct fid)");
        kSQL.append("   from T_BG_BgCtrlRecord");
        kSQL.append("  where (");
        kSQL.append("         FBgTraceType = 4");
        kSQL.append("         or");
        kSQL.append("         FBgTraceType = 7");
        kSQL.append("         )");
        kSQL.append("    and exists (select *");
        kSQL.append("                  from T_BG_BgCtrlRecordSumDetail");
        kSQL.append("                 where FBgCtrlRecordid = T_BG_BgCtrlRecord.Fid");
        kSQL.append("                   and FBgCtrlRecordid is not null");
        kSQL.append("                )");
        int count = 0;
        IRowSet rst = null;
        try {
            rst = DbUtil.executeQuery((Context)ctx, (String)kSQL.toString());
            if (rst.next()) {
                count = rst.getInt(1);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (count > 0) return true;
        return false;
    }

    static String getTypeAllias(String billType, BgTraceTypeEnum traceType) {
        if (BudgetCtrlUtil.isEmpty(billType)) {
            return "";
        }
        if (traceType == null) {
            return billType;
        }
        if (traceType == BgTraceTypeEnum.Bill) {
            return billType;
        }
        return billType + "\uff08" + traceType.getAlias() + "\uff09";
    }

    static boolean isCPBCBill(String boName) {
        if (BudgetCtrlUtil.isEmpty(boName)) {
            return false;
        }
        return boName.toLowerCase(Locale.ENGLISH).startsWith("com.kingdee.eas.cp.bc") || boName.toLowerCase(Locale.ENGLISH).equals("com.kingdee.eas.ma.nbudget.app.budgetrequestbill");
    }

    static List queryBizBills(Context ctx, BgControlSchemeInfo scheme, String costCenterId, Date beginDate, Date endDate) throws BOSException, EASBizException {
        ArrayList<String> bizBillIds = new ArrayList<String>();
        if (scheme == null || costCenterId == null || beginDate == null || endDate == null) {
            return bizBillIds;
        }
        String boName = scheme.getBoName();
        String billOUField = BudgetCtrlHelper.getBillOUFieldOQL(boName);
        StringBuffer OQL = null;
        OQL = boName != null && boName.startsWith("com.kingdee.eas.cp.bc.app") ? new StringBuffer("select id, bizReqDate where " + billOUField + " = '" + costCenterId + "'") : new StringBuffer("select id, bizDate where " + billOUField + " = '" + costCenterId + "'");
        IDataProvider dataProvider = EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(boName));
        dataProvider.setObjectView(OQL.toString());
        String SQL = dataProvider.getSQL();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SQL);
        try {
            while (rs.next()) {
                java.sql.Date billBizDate = rs.getDate(2);
                if (billBizDate != null && (billBizDate.before(beginDate) || billBizDate.after(endDate))) continue;
                bizBillIds.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, ex);
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return bizBillIds;
    }

    static boolean hasBudget(BgCtrlResultCollection ctrlResultCol) {
        if (ctrlResultCol == null || ctrlResultCol.isEmpty()) {
            return false;
        }
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo resultInfo = ctrlResultCol.get(i);
            if (resultInfo.getBgDataId() == null) continue;
            return true;
        }
        return false;
    }

    static BgControlSchemeInfo repairErrorData(BgControlSchemeInfo scheme) {
        BgControlRuleCollection ruleCol = scheme.getRules();
        if (ruleCol == null || ruleCol.size() == 0) {
            return scheme;
        }
        for (int i = 0; i < ruleCol.size(); ++i) {
            String oqlReqExp;
            BgControlRuleInfo rule = ruleCol.get(i);
            String[] oqlRequest = rule.getOqlRequest().split("\\|");
            if (oqlRequest.length != 2 || !BudgetCtrlUtil.isEmpty(oqlReqExp = rule.getOqlRequestExtendExpression())) continue;
            if (oqlRequest[1].indexOf("entries.entryDC") > -1) {
                rule.setOqlRequestExtendExpression("entries.entryDC");
                continue;
            }
            if (oqlRequest[1].indexOf("endorseAmt-fee") <= -1) continue;
            rule.setOqlRequestExtendExpression("endorseAmt,fee");
        }
        return scheme;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static BgPeriodInfo getBgPeriod(Context ctx, String bgPeriodNumber) throws EASBizException {
        BgPeriodInfo bgPeriod = null;
        if (BudgetCtrlUtil.isEmpty(bgPeriodNumber)) {
            return bgPeriod;
        }
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rst = null;
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FId,");
        kSql.append("        FNumber,");
        kSql.append("        FName_" + ctx.getLocale());
        kSql.append("   from T_BG_BgPeriod");
        kSql.append("  where FNumber = ?");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(kSql.toString());
            statement.setString(1, bgPeriodNumber);
            rst = statement.executeQuery();
            if (rst.next()) {
                bgPeriod = new BgPeriodInfo();
                bgPeriod.setId(BOSUuid.read((String)rst.getString(1)));
                bgPeriod.setNumber(rst.getString(2));
                bgPeriod.setName(rst.getString(3));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BgException(BgException.OTHERERROR, ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)statement, (Connection)conn);
        return bgPeriod;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static BgElementInfo getBgElement(Context ctx, String bgElementNumber) throws EASBizException {
        BgElementInfo bgElement = null;
        if (BudgetCtrlUtil.isEmpty(bgElementNumber)) {
            return bgElement;
        }
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rst = null;
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FId,");
        kSql.append("        FNumber,");
        kSql.append("        FName_" + ctx.getLocale());
        kSql.append("   from T_BG_BgElement");
        kSql.append("  where FNumber = ?");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(kSql.toString());
            statement.setString(1, bgElementNumber);
            rst = statement.executeQuery();
            if (rst.next()) {
                bgElement = new BgElementInfo();
                bgElement.setId(BOSUuid.read((String)rst.getString(1)));
                bgElement.setNumber(rst.getString(2));
                bgElement.setName(rst.getString(3));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BgException(BgException.OTHERERROR, ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)statement, (Connection)conn);
        return bgElement;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static CurrencyInfo getCurrency(Context ctx, String currencyNumber) throws EASBizException {
        CurrencyInfo currency = null;
        if (BudgetCtrlUtil.isEmpty(currencyNumber)) {
            return currency;
        }
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rst = null;
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FId,");
        kSql.append("        FNumber,");
        kSql.append("        FName_" + ctx.getLocale());
        kSql.append("   from T_BD_Currency");
        kSql.append("  where FNumber = ?");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(kSql.toString());
            statement.setString(1, currencyNumber);
            rst = statement.executeQuery();
            if (rst.next()) {
                currency = new CurrencyInfo();
                currency.setId(BOSUuid.read((String)rst.getString(1)));
                currency.setNumber(rst.getString(2));
                currency.setName(rst.getString(3));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BgException(BgException.OTHERERROR, ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)statement, (Connection)conn);
        return currency;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static CostCenterOrgUnitInfo getCostCenterOrgUnit(Context ctx, String orgUnitNumber) throws EASBizException {
        CostCenterOrgUnitInfo costCenter = null;
        if (BudgetCtrlUtil.isEmpty(orgUnitNumber)) {
            return costCenter;
        }
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rst = null;
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FId,");
        kSql.append("        FNumber,");
        kSql.append("        FName_" + ctx.getLocale());
        kSql.append("   from T_ORG_CostCenter");
        kSql.append("  where FNumber = ?");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(kSql.toString());
            statement.setString(1, orgUnitNumber);
            rst = statement.executeQuery();
            if (rst.next()) {
                costCenter = new CostCenterOrgUnitInfo();
                costCenter.setId(BOSUuid.read((String)rst.getString(1)));
                costCenter.setNumber(rst.getString(2));
                costCenter.setName(rst.getString(3));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BgException(BgException.OTHERERROR, ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)statement, (Connection)conn);
        return costCenter;
    }

    public static boolean isEmptyBgData(Context ctx, BgDataInfo bgData) {
        if (bgData == null) {
            return true;
        }
        return BgNSHelper.isZeroDealtoNull((Context)ctx) && (bgData.getBgValue() == null || new BigDecimal("0.00").compareTo(bgData.getBgValue()) == 0);
    }

    public static boolean isGeneralAssActType(String oqlItemCombin) {
        return oqlItemCombin != null && oqlItemCombin.startsWith("entries.assistRecords.assGrp.generalAssActType");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map getAllParentOrgMap(Context ctx, Set orgIdSet) throws EASBizException, BOSException {
        HashMap orgId2parentOrgMap = new HashMap();
        if (BudgetCtrlUtil.isEmpty(orgIdSet)) {
            return orgId2parentOrgMap;
        }
        HashSet orgUnitSet = new HashSet();
        orgUnitSet.addAll(orgIdSet);
        StringBuffer kSQL = new StringBuffer();
        kSQL.append("select a.FId as costCenterId,");
        kSQL.append("       b.FId as parentId,");
        kSQL.append("       b.FNumber as parentNumber,");
        kSQL.append("       b.FName_" + ctx.getLocale() + " as parentName");
        kSQL.append("  from T_ORG_CostCenter a,");
        kSQL.append("       T_ORG_CostCenter b");
        kSQL.append(" where a.FID in " + BgHelper.tranSet2String(orgUnitSet));
        kSQL.append("   and (SUBSTRING(a.FLongNumber, 0,LENGTH(b.FLongNumber) + 1) = b.FLongNumber || '!' AND b.FLevel < a.FLevel) ");
        kSQL.append(" order by a.FLongNumber desc, b.flongnumber desc");
        IRowSet rst = null;
        try {
            for (String orgUnitId : orgUnitSet) {
                orgId2parentOrgMap.put(orgUnitId, new ArrayList());
            }
            rst = DbUtil.executeQuery((Context)ctx, (String)kSQL.toString());
            while (rst.next()) {
                String ccid = rst.getString("costCenterId");
                String parentId = rst.getString("parentId");
                String parentNumber = rst.getString("parentNumber");
                String parentName = rst.getString("parentName");
                CostCenterOrgUnitInfo ccInfo = new CostCenterOrgUnitInfo();
                ccInfo.setId(BOSUuid.read((String)parentId));
                ccInfo.setNumber(parentNumber);
                ccInfo.setName(parentName);
                List tmp = (List)orgId2parentOrgMap.get(ccid);
                tmp.add(ccInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return orgId2parentOrgMap;
    }
}

