/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.budget.BgCompareAndAnalysisDoForBook;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgIOHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.NumberExpandInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.DataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.RatePopoInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.FetchAndDealDataAnalysisSystemFacade;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.FetchStandardDataForBgFormulaFactory;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.StandardDataByBgItemDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.StandardDataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.util.AnalysisColumnTool;
import com.kingdee.eas.ma.budget.analysiscolumn.util.BgFormulaHelper;
import com.kingdee.eas.ma.budget.app.AbstractNewBgCompareAndAnalysisFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNLockProtectHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgCalculatorProcess;
import com.kingdee.eas.util.ResourceBase;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class NewBgCompareAndAnalysisFacadeControllerBean
extends AbstractNewBgCompareAndAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.NewBgCompareAndAnalysisFacadeControllerBean");
    protected static final String NEW_ANALYSIS_COL_KEY = "AnalysisColKey";
    public static final String ANALYSIS_FLAG = "analysis_col";
    protected static final String ADD_ROW_FLAG = "add_row_flag";
    protected static final String COL_KEY = "bgCompareAndAnalysisColKey";
    protected static final String TITLE_FLAG = "title_col";
    protected static final BigDecimal ONE = new BigDecimal("1.00");

    @Override
    protected Object _getBookWithParams(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Param, NewBgCompareAndAnalysisFilterParam filter2Param, boolean isDisplayZero, boolean isNeedToFetchTheLastData) throws BOSException, EASBizException {
        FetchAndDealDataAnalysisSystemFacade fetchAndDealDataFacade = new FetchAndDealDataAnalysisSystemFacade();
        Book book = null;
        HashMap itemParam = new HashMap();
        String formId = filter1Param.getBgFormID();
        try {
            if (isNeedToFetchTheLastData) {
                fetchAndDealDataFacade.initDataDealCenter(this.getDataDealCenter(filter1Param));
            }
            BgFormInfo formInfo = this.addAndInitTable(ctx, filter1Param);
            CurrencyInfo currrency = formInfo.getCurrency();
            BgIOHelper bih = new BgIOHelper();
            bih.setIDoForBook(new BgCompareAndAnalysisDoForBook());
            book = bih.getBook(formInfo.getData());
            book.setCalculate(false);
            BgCalculatorProcess process = null;
            ReportCalculateContext context = null;
            BgRptReportPropertyAdapter adapter = null;
            ReportVariables variables = new ReportVariables();
            ReportCalculateErrorProvider errorProvider = new ReportCalculateErrorProvider();
            SortedParameterArray params = new SortedParameterArray();
            process = new BgCalculatorProcess();
            adapter = new BgRptReportPropertyAdapter(formInfo);
            context = new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, variables, (IErrorProvider)errorProvider, null);
            List<Integer> notAllowOperation = Arrays.asList(Integer.valueOf("65536"));
            int sheetNum = book.getSheetCount();
            for (int i = 0; i < sheetNum && isNeedToFetchTheLastData; ++i) {
                Sheet sheet = book.getSheet(i);
                int addRowIndex = this.constructSheet(ctx, filter1Param, filter2Param.getAnalysisElement(), sheet, fetchAndDealDataFacade);
                this.rebuildFilter1Params(filter1Param, new CostCenterOrgUnitInfo[]{filter1Param.getCostCenterOrgUnitInfoAry()[0]});
                try {
                    fetchAndDealDataFacade.getDataDealCenter().getFetchDataFactory().initDataFactory(ctx, filter1Param, filter2Param);
                    this.fillDataToTable(ctx, sheet, filter1Param, filter2Param, addRowIndex, fetchAndDealDataFacade, itemParam, params, currrency);
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (BOSException e) {
                    throw e;
                }
                this.delBgItemWithAllAnalysisDataEqualZero(isDisplayZero, sheet, addRowIndex, filter2Param);
                BgNLockProtectHelper.setSheetLockedAndProtection((Sheet)sheet, (boolean)true, notAllowOperation);
            }
            process.initialize("bgformula", (ICalculateContextProvider)context, ctx, params);
            process.process();
            Parameter _parameter = null;
            HashMap<String, Object> newData = new HashMap<String, Object>();
            String bgFormula = null;
            int in = params.size();
            for (int i = 0; i < in; ++i) {
                _parameter = params.getParameter(i);
                if (_parameter.getValue() instanceof BigDecimal) {
                    bgFormula = _parameter.getSheetName();
                    newData.put(bgFormula, (BigDecimal)_parameter.getValue());
                    continue;
                }
                if (!(_parameter.getValue() instanceof String)) continue;
                bgFormula = _parameter.getSheetName();
                newData.put(bgFormula, (String)_parameter.getValue());
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        byte[] bookByte = null;
        try {
            bookByte = IOHelper.packBook((Book)book);
        }
        catch (IOException e) {
            logger.error((Object)"Book pack Exception:", (Throwable)e);
            throw new BOSException(e.toString());
        }
        return bookByte;
    }

    protected DataDealCenter getDataDealCenter(NewBgCompareAndAnalysisFilterParam filter1Params) throws ClassNotFoundException {
        BgPeriodInfo sPeriodInfo = filter1Params.getBeginPeriod();
        if (sPeriodInfo != null) {
            return new StandardDataDealCenter();
        }
        return new StandardDataByBgItemDealCenter();
    }

    protected void delBgItemWithAllAnalysisDataEqualZero(boolean isDelete, Sheet sheet, int addRowIndex, NewBgCompareAndAnalysisFilterParam filter2Params) {
        if (isDelete) {
            this.delRow(sheet, addRowIndex, filter2Params);
        }
    }

    private void delRow(Sheet sheet, int addRowIndex, NewBgCompareAndAnalysisFilterParam filter2Params) {
        List analysisColIndexList = this.getAnalysisColIndexList(sheet);
        List analysisElementList = filter2Params.getAnalysisElement();
        for (int rowIndex = sheet.getMaxRowIndex() + 1; rowIndex > addRowIndex; --rowIndex) {
            if (!this.isDeleteRow(sheet, rowIndex, analysisColIndexList, analysisElementList)) continue;
            BgNFSHelper.removeRow((Sheet)sheet, (int)rowIndex);
        }
    }

    private boolean isDeleteRow(Sheet sheet, int rowIndex, List analysisColIndexList, List analysisElementList) {
        int colNum = analysisColIndexList.size();
        for (int k = 0; k < colNum; ++k) {
            int analysisColIndex = Integer.valueOf(analysisColIndexList.get(k).toString());
            int num = analysisElementList.size();
            for (int i = 0; i < num; ++i) {
                String variantStr;
                Variant variant;
                Cell cell = sheet.getCell(rowIndex, analysisColIndex + i, false);
                if (cell == null || (variant = cell.getValue()) == null || DataDealCenter.ZIROSTR_LIST.contains(variantStr = variant.toString().trim())) continue;
                return false;
            }
        }
        return true;
    }

    protected final List getAnalysisColIndexList(Sheet sheet) {
        ArrayList<Integer> analysisColIndexList = new ArrayList<Integer>();
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            String colKey;
            Column col = sheet.getColumn(i, false);
            Object obj = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (!(obj instanceof String) || !ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            analysisColIndexList.add(new Integer(i));
        }
        return analysisColIndexList;
    }

    protected BgFormInfo addAndInitTable(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Params) throws Exception {
        String bgFormID = filter1Params.getBgFormID();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bgFormID));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("data"));
        selector.add(new SelectorItemInfo("orgUnit.*"));
        selector.add(new SelectorItemInfo("bgScheme.*"));
        selector.add(new SelectorItemInfo("bgTemplate.*"));
        selector.add(new SelectorItemInfo("currency.*"));
        selector.add(new SelectorItemInfo("currency.precision"));
        selector.add(new SelectorItemInfo("sheetParam.*"));
        selector.add(new SelectorItemInfo("bgPeriod.*"));
        selector.add(new SelectorItemInfo("state"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        BgFormInfo formInfo = null;
        formInfo = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(viewInfo).get(0);
        if (formInfo == null) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"81_NewBgCompareAndAnalysisFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return formInfo;
    }

    protected int constructSheet(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Param, List analysisElementList, Sheet sheet, FetchAndDealDataAnalysisSystemFacade fetchAndDealDataFacade) throws Exception {
        Map analysisColsMap = filter1Param.getAnalysisColsMap();
        String sheetID = sheet.getID();
        String sheetName = sheet.getSheetName();
        String key = sheetID + "&" + sheetName;
        List analysisColsList = (List)analysisColsMap.get(key);
        if (analysisColsList == null) {
            return 0;
        }
        Map titleColsMap = filter1Param.getTitleColsMap();
        List titleColsList = null;
        if (titleColsMap != null) {
            titleColsList = (List)titleColsMap.get(key);
        }
        if (titleColsList != null && titleColsList.size() != 0) {
            this.removeUnRequiredCols(titleColsList, analysisColsList, sheet);
        } else {
            this.removeUnRequiredCols(analysisColsList, sheet);
        }
        int rowIndex = this.locateAddedNewRowIndex(sheet);
        Row addRow = BgNFSHelper.addRow((Sheet)sheet, (int)rowIndex);
        addRow.setUserObject(ADD_ROW_FLAG, (Object)"addRow");
        this.addAnalysisCols(analysisElementList, rowIndex, sheet, fetchAndDealDataFacade);
        this.removeOldColumns(sheet);
        this.accessorizeNewTable(analysisElementList.size(), rowIndex, sheet);
        this.addOrgUnitByCol(ctx, filter1Param, rowIndex + 1, sheet);
        return rowIndex;
    }

    private void removeOldColumns(Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            Column oldCol = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject((Column)oldCol, (String)COL_KEY);
            Row row = null;
            if (colKey == null || !ANALYSIS_FLAG.equals(colKey)) continue;
            int newAnalysisColIndex = i + 1;
            Column newAnalysisCol = sheet.getColumn(newAnalysisColIndex, false);
            BgNFSHelper.setColObject((Column)newAnalysisCol, (String)NEW_ANALYSIS_COL_KEY, (Object)ANALYSIS_FLAG);
            int num = sheet.getMaxRowIndex() + 1;
            for (int j = 0; j < num; ++j) {
                Cell newCell;
                Cell cell;
                row = sheet.getRow(j, false);
                if (row != null && row.getUserObjectValue(ADD_ROW_FLAG) != null && row.getUserObjectValue(ADD_ROW_FLAG).toString().equals("addRow") || (cell = sheet.getCell(j, i, false)) == null) continue;
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                String bgFormula = BgNFSHelper.getExpression((Cell)cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    newCell = sheet.getCell(j, newAnalysisColIndex, true);
                    BgNFSHelper.setFormulaOfCell((Cell)newCell, (String)bgItem, (boolean)true);
                } else if (BgNFSHelper.checkHasExpression((Cell)cell)) {
                    newCell = sheet.getCell(j, newAnalysisColIndex, true);
                    BgNFSHelper.setExpression((Cell)newCell, (String)bgFormula);
                }
                Object txtCellObj = BgNFSHelper.getValue((Cell)cell);
                if (txtCellObj == null) continue;
                Cell newCell2 = sheet.getCell(j, newAnalysisColIndex, true);
                BgNFSHelper.setValue((Cell)newCell2, (Object)txtCellObj);
            }
            boolean isDelete = BgNFSHelper.removeColumn((Sheet)sheet, (int)i);
            if (isDelete) continue;
            BgNFSHelper.setSheetProtection((Sheet)sheet, (boolean)false);
            BgNFSHelper.removeColumn((Sheet)sheet, (int)i);
        }
    }

    private void addOrgUnitByCol(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Param, int beginRow, Sheet sheet) {
        CostCenterOrgUnitInfo[] orgInfoAry = filter1Param.getCostCenterOrgUnitInfoAry();
        int num = orgInfoAry.length;
        String[] companyIds = new String[num];
        for (int i = 0; i < num; ++i) {
            companyIds[i] = orgInfoAry[i].getId().toString();
        }
        if (companyIds != null && companyIds.length != 0) {
            FullOrgUnitInfo baseOrgUnit = null;
            try {
                baseOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyIds[0]))).castToFullOrgUnitInfo();
            }
            catch (Exception e) {
                logger.error((Object)"CostCenter is null", (Throwable)e);
            }
            Column column = BgNFSHelper.addColumn((Sheet)sheet, (int)0);
            int colIndex = column.getCol();
            sheet.getColRange(colIndex, colIndex).setColumnWidth(200);
            int rowCount = sheet.getMaxRowIndex() + 1;
            int colCount = sheet.getMaxColIndex() + 1;
            MergeBlocks blocks = sheet.getMerger(false);
            CellBlock block = null;
            Cell firstCell = null;
            for (int rowIndex = beginRow; rowIndex < rowCount; ++rowIndex) {
                if (!this.checkHasBgItem(sheet, rowIndex)) continue;
                if (blocks != null && !blocks.isEmpty()) {
                    for (int i = 0; i < colCount; ++i) {
                        if (sheet.getCell(rowIndex, i, false) == null || (block = sheet.getCell(rowIndex, i, false).getMerge(false)) == null || (firstCell = sheet.getCell(block.getRow(), block.getCol(), false)) == null) continue;
                        sheet.getMerger(false).remove(sheet.getCell(rowIndex, i, false).getMerge(false));
                        int n = block.getRow2();
                        for (int ii = block.getRow(); ii <= n; ++ii) {
                            BgNFSHelper.setValue((Cell)sheet.getCell(ii, block.getCol(), true), (Object)BgNFSHelper.getValue((Cell)firstCell));
                        }
                    }
                }
                this.addExpandInfo(sheet.getCell(rowIndex, column.getCol(), true), baseOrgUnit, companyIds.length);
            }
        }
    }

    protected void addExpandInfo(Cell cell, FullOrgUnitInfo orgUnitInfo, int orgNum) {
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(orgUnitInfo.getId().toString());
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
        expandInfo.setLevel(0);
        expandInfo.setExpandStatus(false);
        expandInfo.setLeaf(false);
        if (orgNum == 1) {
            BgNFSHelper.setValue((Cell)cell, (Object)orgUnitInfo.getName());
            cell.setUserObject("orgUnitId", (Object)expandInfo.getId());
            cell.setUserObject("orgUnitNumber", (Object)expandInfo.getNumber());
            cell.setUserObject("orgUnitName", (Object)expandInfo.getName());
        } else {
            BgNFSHelper.setNumberExpandInfo((Cell)cell, (NumberExpandInfo)expandInfo);
        }
    }

    private boolean checkHasBgItem(Sheet sheet, int rowIndex) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int colIndex = colNum - 1; colIndex >= 0; --colIndex) {
            Column col = sheet.getColumn(colIndex, false);
            Object colKey = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (colKey == null || !ANALYSIS_FLAG.equals(colKey)) continue;
            Cell cell = sheet.getCell(rowIndex, colIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String bgFormula = BgNFSHelper.getExpression((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                return true;
            }
            if (bgFormula == null || "".equals(bgFormula) || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
            return true;
        }
        return false;
    }

    private void accessorizeNewTable(int mergeColNum, int rowIndex, Sheet sheet) {
        int num = sheet.getMaxColIndex();
        for (int i = num - 1; i >= 0; --i) {
            String colKey;
            Column col = sheet.getColumn(i, false);
            Object obj = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (!(obj instanceof String) || !ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            for (int j = rowIndex - 1; j >= 0; --j) {
                Cell cell = sheet.getCell(j, i, false);
                if (cell == null || !BgNFSHelper.checkHasCurrencyInfo((Cell)cell) && !BgNFSHelper.checkHasBgElementInfo((Cell)cell) && !BgNFSHelper.checkHasBgItemInfo((Cell)cell) && !BgNFSHelper.checkHasBgPeriodInfo((Cell)cell)) continue;
                sheet.getRange(j, i, j, mergeColNum + i - 1).merge();
            }
        }
    }

    private void addAnalysisCols(List analysisElementList, int rowIndex, Sheet sheet, FetchAndDealDataAnalysisSystemFacade fetchAndDealDataFacade) throws Exception {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            Column col = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject((Column)col, (String)COL_KEY);
            if (!ANALYSIS_FLAG.equals(colKey)) continue;
            if (!this.isRealAnalysisCol(col, sheet)) {
                BgNFSHelper.setColObject((Column)col, (String)COL_KEY, null);
                continue;
            }
            int num = analysisElementList.size();
            for (int j = 0; j < num; ++j) {
                int colIndex = i + j + 1;
                Column column = BgNFSHelper.addColumn((Sheet)sheet, (int)colIndex, (boolean)true);
                String proName = analysisElementList.get(j).toString();
                BgNFSHelper.setColObject((Column)column, (String)COL_KEY, (Object)proName);
                try {
                    BgNFSHelper.setValue((Cell)sheet.getCell(rowIndex, colIndex, true), (Object)AnalysisColumnTool.getProValByProName(proName, fetchAndDealDataFacade.getDataDealCenter().getFetchDataFactory().getAnalysisEleClass()));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (IllegalAccessException e) {
                    throw e;
                }
                catch (ClassNotFoundException e) {
                    throw e;
                }
            }
        }
    }

    private boolean isRealAnalysisCol(Column column, Sheet sheet) {
        int colIndex = column.getCol();
        int num = sheet.getMaxColIndex() + 11;
        for (int i = 0; i < num; ++i) {
            String tempBgItem;
            Cell cell = sheet.getCell(i, colIndex, false);
            if (cell == null) continue;
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String bgFormula = BgNFSHelper.getExpression((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                return true;
            }
            if (bgFormula == null || bgFormula.equals("") || !BgFormulaHelper.isSingleBgFormula(bgFormula) || "".equals(tempBgItem = AnalysisColumnTool.changeBgFormulaToBgItem(bgFormula))) continue;
            return true;
        }
        return false;
    }

    private int locateAddedNewRowIndex(Sheet sheet) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        boolean continueFlag = true;
        int rowIndex = 0;
        block0: for (int i = 0; i < rowCount && continueFlag; ++i) {
            for (int j = 0; j < colCount && continueFlag; ++j) {
                Cell cell = sheet.getCell(i, j, false);
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                String bgFormula = BgNFSHelper.getExpression((Cell)cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    rowIndex = cell.getRow();
                    continueFlag = false;
                    continue block0;
                }
                if (bgFormula == null || "".equals(bgFormula) || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
                rowIndex = cell.getRow();
                continueFlag = false;
                continue block0;
            }
        }
        return rowIndex;
    }

    private void removeUnRequiredCols(List titleList, List analysisList, Sheet sheet) throws Exception {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            if (titleList.contains(new Integer(i))) {
                BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)COL_KEY, (Object)TITLE_FLAG);
                continue;
            }
            if (analysisList.contains(new Integer(i))) {
                BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)COL_KEY, (Object)ANALYSIS_FLAG);
                continue;
            }
            BgNFSHelper.removeColumn((Sheet)sheet, (int)i);
            continue;
        }
    }

    private void removeUnRequiredCols(List analysisList, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            if (analysisList.contains(new Integer(i))) {
                BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)COL_KEY, (Object)ANALYSIS_FLAG);
                continue;
            }
            BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)COL_KEY, (Object)TITLE_FLAG);
        }
    }

    void rebuildFilter1Params(NewBgCompareAndAnalysisFilterParam filter1Params, Object[] ary) {
        filter1Params.setLazyLoadDataCostCenterOrgUnitInfoAry((CostCenterOrgUnitInfo[])ary);
    }

    protected void fillDataToTable(Context ctx, Sheet sheet, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params, int addRowIndex, FetchAndDealDataAnalysisSystemFacade fetchAndDealDataFacade, Map itemParam, SortedParameterArray params, CurrencyInfo currrency) throws Exception {
        CostCenterOrgUnitInfo[] orgUnitAry = filter1Params.getCostCenterOrgUnitInfoAry();
        String rootOrgUnitId = orgUnitAry[0].getId().toString();
        Map amountUnitMap = filter1Params.getMeasureUnitInfoMap();
        List list = filter2Params.getAnalysisElement();
        this.fillDataToTable(ctx, sheet, list, addRowIndex + 1, rootOrgUnitId, amountUnitMap, filter1Params, filter2Params, fetchAndDealDataFacade, itemParam, params, currrency);
    }

    protected void fillDataToTable(Context ctx, Sheet sheet, List analysisColsList, int initRowIndex, String orgUnitId, Map amountUnitMap, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params, FetchAndDealDataAnalysisSystemFacade fetchAndDealDataFacade, Map itemParam, SortedParameterArray params, CurrencyInfo currrency) throws Exception {
        FetchStandardDataForBgFormulaFactory fSDFBFF = new FetchStandardDataForBgFormulaFactory();
        List analysisColIndexList = this.getAnalysisColIndexList(sheet);
        int rowCount = sheet.getMaxRowIndex() + 1;
        BigDecimal amountUnit = ONE;
        StyleAttributes cellSa = Styles.getEmptySA();
        cellSa.setLocked(true);
        cellSa.setNumberFormat("#,##0." + NewBgCompareAndAnalysisFacadeControllerBean.getNumberFormat("0", currrency.getPrecision()));
        for (int rowIndex = initRowIndex; rowIndex < rowCount; ++rowIndex) {
            int colNum = analysisColIndexList.size();
            for (int k = 0; k < colNum; ++k) {
                int analysisColIndex = Integer.valueOf(analysisColIndexList.get(k).toString());
                Cell cell = sheet.getCell(rowIndex, analysisColIndex, false);
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                String bgFormula = BgNFSHelper.getExpression((Cell)cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    String[] formulaParamArray = null;
                    if (itemParam.containsKey(bgItem)) {
                        formulaParamArray = (String[])itemParam.get(bgItem);
                    } else {
                        formulaParamArray = BgFillHelper.parseStrFormulaToArray(bgItem);
                        itemParam.put(bgItem, formulaParamArray);
                    }
                    amountUnit = this.reSetAmountUnit(formulaParamArray[2], amountUnitMap);
                    int num = analysisColsList.size();
                    for (int j = 0; j < num; ++j) {
                        int addedColIndex = analysisColIndex + j;
                        Column col = sheet.getColumn(addedColIndex, false);
                        Object colKey = BgNFSHelper.getColObject((Column)col, (String)COL_KEY);
                        if (!(colKey instanceof String)) continue;
                        Object val = null;
                        try {
                            val = fetchAndDealDataFacade.getDataDealCenter().getDataFactory(bgItem, colKey.toString(), orgUnitId, amountUnit);
                        }
                        catch (SecurityException e) {
                            throw e;
                        }
                        catch (IllegalArgumentException e) {
                            throw e;
                        }
                        catch (NoSuchMethodException e) {
                        }
                        catch (IllegalAccessException e) {
                            throw e;
                        }
                        catch (InvocationTargetException e) {
                            throw e;
                        }
                        this.setCellValue(sheet, rowIndex, addedColIndex, val, currrency);
                    }
                    continue;
                }
                if (bgFormula != null && !bgFormula.equals("")) {
                    if (!BgNFSHelper.checkHasTextOfCell((Cell)cell) && BgNFSHelper.checkIsNumericOfCell((Cell)cell)) {
                        cell.getSheet().getRange(cell).setStyle(cellSa, Styles.getEmptySA());
                    }
                    if (!BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
                    String currentOrgNum = this.getOrgUnitNumber(ctx, orgUnitId);
                    String[] bgFormulaAry = null;
                    if (itemParam.containsKey(bgFormula)) {
                        bgFormulaAry = (String[])itemParam.get(bgFormula);
                    } else {
                        bgFormulaAry = BgFillHelper.parseStrFormulaToArray(bgFormula);
                        itemParam.put(bgFormula, bgFormulaAry);
                    }
                    if (currentOrgNum.equals(bgFormulaAry[0])) {
                        this.initBgFormulaDataFactory(ctx, bgFormula, filter1Params, filter2Params, fSDFBFF);
                    } else {
                        BgNFSHelper.setExpression((Cell)cell, (String)BgFormulaHelper.rebulidBgFormula(bgFormulaAry));
                    }
                    amountUnit = this.reSetAmountUnit(bgFormulaAry[2], amountUnitMap);
                    int num = analysisColsList.size();
                    for (int j = 0; j < num; ++j) {
                        int addedColIndex = analysisColIndex + j;
                        Column col = sheet.getColumn(addedColIndex, false);
                        Object colKey = BgNFSHelper.getColObject((Column)col, (String)COL_KEY);
                        if (!(colKey instanceof String)) continue;
                        Object val = fSDFBFF.getDataFactory(bgFormula, colKey.toString(), orgUnitId, amountUnit);
                        this.setCellValue(sheet, rowIndex, addedColIndex, val, currrency);
                    }
                    continue;
                }
                if (BgNFSHelper.checkHasTextOfCell((Cell)cell) || !BgNFSHelper.checkIsNumericOfCell((Cell)cell)) continue;
                cell.getSheet().getRange(cell).setStyle(cellSa, Styles.getEmptySA());
            }
            this.fillDataToEntireTbl(sheet, rowIndex, orgUnitId, amountUnitMap, 0, filter1Params, filter2Params, fetchAndDealDataFacade, itemParam, currrency);
        }
    }

    protected void fillDataToEntireTbl(Sheet sheet, int rowIndex, String orgUnitId, Map amountUnitMap, int difRowNum, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params, FetchAndDealDataAnalysisSystemFacade fetchAndDealDataFacade, Map itemParam, CurrencyInfo currency) throws Exception {
        int colCount = sheet.getMaxColIndex() + 1;
        BigDecimal amountUnit = ONE;
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            String upBgItem;
            String colKey;
            Column col = sheet.getColumn(colIndex, false);
            Object obj = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (obj instanceof String && ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            Cell cell = sheet.getCell(rowIndex, colIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                String[] formulaParamArray = null;
                if (itemParam.containsKey(bgItem)) {
                    formulaParamArray = (String[])itemParam.get(bgItem);
                } else {
                    formulaParamArray = BgFillHelper.parseStrFormulaToArray(bgItem);
                    itemParam.put(bgItem, formulaParamArray);
                }
                amountUnit = this.reSetAmountUnit(formulaParamArray[2], amountUnitMap);
                Object val = null;
                try {
                    val = fetchAndDealDataFacade.getDataDealCenter().getDataFactory(bgItem, "col4", orgUnitId, amountUnit);
                }
                catch (SecurityException e) {
                    throw e;
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (NoSuchMethodException e) {
                    throw e;
                }
                catch (IllegalAccessException e) {
                    throw e;
                }
                catch (InvocationTargetException e) {
                    throw e;
                }
                this.setCellValue(sheet, rowIndex, colIndex, val, currency);
                continue;
            }
            if (bgItem != null || (upBgItem = this.findBgItem(sheet, rowIndex, colIndex, difRowNum)) == null || "".equals(upBgItem)) continue;
            BgNFSHelper.setFormulaOfCell((Cell)sheet.getCell(rowIndex, colIndex, true), (String)upBgItem, (boolean)true);
            String[] formulaParamArray = null;
            if (itemParam.containsKey(upBgItem)) {
                formulaParamArray = (String[])itemParam.get(upBgItem);
            } else {
                formulaParamArray = BgFillHelper.parseStrFormulaToArray(upBgItem);
                itemParam.put(upBgItem, formulaParamArray);
            }
            amountUnit = this.reSetAmountUnit(formulaParamArray[2], amountUnitMap);
            Object val = null;
            try {
                val = fetchAndDealDataFacade.getDataDealCenter().getDataFactory(upBgItem, "col4", orgUnitId, amountUnit);
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (NoSuchMethodException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw e;
            }
            this.setCellValue(sheet, rowIndex, colIndex, val, currency);
        }
    }

    private String findBgItem(Sheet sheet, int rowIndex, int colIndex, int difRowNum) {
        if (difRowNum == 0) {
            return null;
        }
        Cell cell = sheet.getCell(rowIndex - difRowNum, colIndex, false);
        String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
        if (bgItem != null && !"".equals(bgItem)) {
            return bgItem;
        }
        return null;
    }

    private BigDecimal reSetAmountUnit(String element, Map amountUnitMap) {
        if (amountUnitMap == null || amountUnitMap.size() == 0) {
            return ONE;
        }
        for (BgElementInfo elementInfo : amountUnitMap.keySet()) {
            if (!elementInfo.getNumber().equals(element)) continue;
            MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)amountUnitMap.get(elementInfo);
            return measureUnitInfo.getCoefficient();
        }
        return ONE;
    }

    private String getOrgUnitNumber(Context ctx, String orgUnitId) throws Exception {
        FullOrgUnitInfo orgUnitInfo = null;
        try {
            orgUnitInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId)).castToFullOrgUnitInfo();
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return orgUnitInfo.getNumber();
    }

    private void initBgFormulaDataFactory(Context ctx, List formulaS, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params, FetchStandardDataForBgFormulaFactory fSDFBFF) throws EASBizException, BOSException {
        fSDFBFF.initDataFactory(ctx, formulaS, filter1Params, filter2Params);
    }

    private void initBgFormulaDataFactory(Context ctx, String formula, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params, FetchStandardDataForBgFormulaFactory fSDFBFF) throws EASBizException, BOSException {
        fSDFBFF.initDataFactory(ctx, formula, filter1Params, filter2Params);
    }

    public static String getNumberFormat(String str, int number) {
        if (str == null || number <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    private String getNumberFormat(CurrencyInfo currency) {
        int prec = 2;
        if (currency != null) {
            prec = currency.getPrecision();
        }
        StringBuffer sb = new StringBuffer("#,##0.");
        for (int i = 0; i < prec; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }

    public void setCellValue(Sheet sheet, int rowIndex, int colIndex, Object value, CurrencyInfo currency) {
        if (sheet == null || rowIndex < 0 || colIndex < 0 || value == null) {
            return;
        }
        Cell cell = sheet.getCell(rowIndex, colIndex, true);
        cell.setValue(new Variant(value));
        if (value instanceof BigDecimal) {
            StyleAttributes numSsa = Styles.getEmptySA();
            sheet.getRange(cell).getStyle(numSsa, Styles.getEmptySA());
            numSsa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            numSsa.setNumberFormat(this.getNumberFormat(currency));
            cell.setSSA((ShareStyleAttributes)numSsa);
            sheet.getRange(cell).setStyle(numSsa, Styles.getEmptySA());
        } else if (value instanceof RatePopoInfo) {
            RatePopoInfo rpi = (RatePopoInfo)value;
            if (!rpi.isReInitInfo()) {
                rpi.initReuslt();
            }
            if (!rpi.isFenmuZero()) {
                StyleAttributes numSsa = Styles.getEmptySA();
                sheet.getRange(cell).getStyle(numSsa, Styles.getEmptySA());
                numSsa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                numSsa.setNumberFormat(rpi.getNumberFormat(currency));
                cell.setValue(new Variant((Object)rpi.getResult1()));
                sheet.getRange(cell).setStyle(numSsa, Styles.getEmptySA());
            }
        }
    }
}

