/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.RecalculateObjInfo;
import com.kingdee.eas.ma.budget.app.AbstractReCalculateFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ReCalculateFacadeControllerBean
extends AbstractReCalculateFacadeControllerBean {
    private static final long serialVersionUID = -6940664857619727732L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.ReCalculateFacadeControllerBean");
    private static final String date_pattern = "yyyy-MM-dd";

    @Override
    protected List _getTemplateBySchemeID(Context ctx, String bgSchemeID) throws BOSException {
        String sql = "select b.fid , b.fname,b.fnumber , b.fformType from T_BG_BgSchemeNode a ,T_BG_BgTemplate b where a.FBgTemplateId = b.FID and a.FBgSchemeId = ? and (b.FBgTypeId <> 'BV/FQwEUEADgABtLwKgSXv9s2OA=' or b.FBgTypeId is NULL) and b.fformType <> 4 ";
        ArrayList<BgTemplateInfo> rtnList = new ArrayList<BgTemplateInfo>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bgSchemeID});
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                String name = rs.getString("fname");
                String number = rs.getString("fnumber");
                BgTemplateInfo info = new BgTemplateInfo();
                info.setName(name);
                info.setNumber(number);
                info.setId(BOSUuid.read((String)id));
                rtnList.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return rtnList;
    }

    @Override
    protected List _getPeriodsBySchemeDate(Context ctx, java.util.Date beginDate, java.util.Date endDate) throws BOSException {
        String sql = "select fid , FPeriodType , FBeginDate ,FEndDate , fname_l2 ,fnumber from t_bg_bgperiod   where fbegindate >= to_date('" + this.dateToStr(beginDate) + " ') and fenddate <= to_date('" + this.dateToStr(endDate) + "') order by fnumber";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<BgPeriodInfo> rtnList = new ArrayList<BgPeriodInfo>();
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                int type = rs.getInt("FPeriodType");
                Date begin = rs.getDate("FBeginDate");
                Date end = rs.getDate("fendDate");
                String name = rs.getString("fname_l2");
                String number = rs.getString("fnumber");
                BgPeriodInfo info = new BgPeriodInfo();
                info.setName(name);
                info.setId(BOSUuid.read((String)id));
                info.setPeriodType(BgPeriodEnum.getEnum(type));
                info.setBeginDate(begin);
                info.setEndDate(end);
                info.setNumber(number);
                rtnList.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return rtnList;
    }

    private String dateToStr(java.util.Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(date_pattern);
        return sdf.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getBgForm(Context ctx, String currencyID, String schemeID, BgPeriodInfo[] bgPeriodInfoAry, List templateInfoList) throws BOSException {
        String sql = "select  fid from t_bg_bgform  where  fbgschemeid = ? and fbgtemplateid = ? and fcurrencyid = ? and FBgPeriodID = ? and fstate not in (2,5,15) ";
        ArrayList<RecalculateObjInfo> rtnList = new ArrayList<RecalculateObjInfo>();
        IBgPeriod period = BgPeriodFactory.getLocalInstance(ctx);
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        Connection con = this.getConnection(ctx);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            int num = bgPeriodInfoAry.length;
            for (int i = 0; i < num; ++i) {
                String periodID = bgPeriodInfoAry[i].getId().toString();
                BgPeriodInfo periodInfo = null;
                periodInfo = (BgPeriodInfo)period.getValue((IObjectPK)new ObjectUuidPK(periodID));
                int _num = templateInfoList.size();
                for (int j = 0; j < _num; ++j) {
                    BgTemplateInfo templateInfo = (BgTemplateInfo)templateInfoList.get(j);
                    String templateID = templateInfo.getId().toString();
                    pstmt = con.prepareStatement(sql);
                    pstmt.setString(1, schemeID);
                    pstmt.setString(2, templateID);
                    pstmt.setString(4, periodID);
                    pstmt.setString(3, currencyID);
                    rs = pstmt.executeQuery();
                    boolean hasForm = false;
                    while (rs.next()) {
                        hasForm = true;
                        String id = rs.getString("fid");
                        BgFormInfo bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), BgNFSHelper.getSelectors());
                        bgFormInfo.setBgPeriod(periodInfo);
                        String state = bgFormInfo.getState().getAlias();
                        if (!(state.equals(BgFormStateEnum.Edited.getAlias()) || state.equals(BgFormStateEnum.Adjusted.getAlias()) || state.equals(BgFormStateEnum.Back.getAlias()))) {
                            rtnList.add(new RecalculateObjInfo(bgPeriodInfoAry[i], "stateError", templateInfo, bgFormInfo));
                            continue;
                        }
                        rtnList.add(new RecalculateObjInfo(bgPeriodInfoAry[i], "cancel", templateInfo, bgFormInfo));
                    }
                    if (hasForm) continue;
                    rtnList.add(new RecalculateObjInfo(bgPeriodInfoAry[i], "noBgForm", templateInfo, null));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)con);
        }
        return rtnList;
    }

    @Override
    protected boolean _isTemplateHasBgForm(Context ctx, String templateID, String bgSchemeID) throws BOSException {
        String sql = "select fid from t_bg_bgform where fbgschemeid = '" + bgSchemeID + "' and fbgtemplateid = '" + templateID + "' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getAduitBgForm(Context ctx, String currencyID, String bgSchemeID, String periodID, List templateIDs) throws BOSException {
        String sql = "select fid from t_bg_bgform  where fbgschemeid = ?  and  FState <> ? or Fstate <> ? and fbgtemplateid = ? ";
        if (periodID != null) {
            sql = sql + " and FBgPeriodID = ? ";
        }
        if (currencyID != null) {
            sql = sql + " and fcurrencyid = ? ";
        }
        Connection con = this.getConnection(ctx);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            int num = templateIDs.size();
            for (int i = 0; i < num; ++i) {
                String templateID = templateIDs.get(i).toString();
                pstmt = con.prepareStatement(sql);
                pstmt.setString(1, bgSchemeID);
                pstmt.setInt(2, 1);
                pstmt.setInt(3, 4);
                pstmt.setString(4, templateID);
                if (periodID != null && currencyID != null) {
                    pstmt.setString(5, periodID);
                    pstmt.setString(6, currencyID);
                } else if (periodID == null && currencyID != null) {
                    pstmt.setString(5, currencyID);
                } else if (periodID != null && currencyID == null) {
                    pstmt.setString(5, periodID);
                }
                rs = pstmt.executeQuery();
                if (!rs.next()) continue;
                list.add(templateID);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)con);
        }
        return list;
    }
}

