/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCollectException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.RefBgDecFormCollection;
import com.kingdee.eas.ma.budget.RefBgDecFormInfo;
import com.kingdee.eas.ma.budget.app.AbstractRefBgDecFormControllerBean;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class RefBgDecFormControllerBean
extends AbstractRefBgDecFormControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.RefBgDecFormControllerBean");

    @Override
    protected IObjectCollection _loadRefBgFormDecByBgForm(Context ctx, IObjectValue bgFormInfo, List ouIdList) throws BOSException, EASBizException {
        RefBgDecFormCollection refBgFormCols = new RefBgDecFormCollection();
        if (ouIdList == null || ouIdList.size() == 0) {
            throw new BgCollectException(BgCollectException.HASNOOUSELECTED);
        }
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        HashSet<Integer> bgFormStateSet = new HashSet<Integer>();
        bgFormStateSet.add(new Integer(1));
        bgFormStateSet.add(new Integer(41));
        SelectorItemCollection bgSic = new SelectorItemCollection();
        bgSic.add("bgTemplate.rootId");
        bgSic.add("bgScheme.rootId");
        bgSic.add("bgPeriod.number");
        bgSic.add("currency.number");
        BgFormInfo selectedBgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.get("id").toString()), bgSic);
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("orgUnit");
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.rootId", (Object)selectedBgFormInfo.getBgTemplate().getRootId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.rootId", (Object)selectedBgFormInfo.getBgScheme().getRootId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.number", (Object)selectedBgFormInfo.getBgPeriod().getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("currency.number", (Object)selectedBgFormInfo.getCurrency().getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("state", bgFormStateSet, CompareType.INCLUDE));
        HashSet ouIdSet = new HashSet(ouIdList);
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", ouIdSet, CompareType.INCLUDE));
        BgFormCollection bgFormCols = iBgForm.getBgFormCollection(evi);
        if (bgFormCols == null || bgFormCols.size() != ouIdSet.size()) {
            return null;
        }
        int size = bgFormCols.size();
        for (int i = 0; i < size; ++i) {
            RefBgDecFormInfo child = null;
            try {
                child = new RefBgDecFormInfo();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            child.setBgForm(bgFormCols.get(i));
            refBgFormCols.add(child);
        }
        return refBgFormCols;
    }

    @Override
    protected List _getCommentByBgForm(Context ctx, IObjectPK bgFormPK, boolean isDecForm) throws BOSException, EASBizException {
        ArrayList<String> commentList = new ArrayList<String>();
        StringBuffer sqlToGetComment = new StringBuffer("SELECT ORG.FName_l2 AS FORGNAME, REFBGFORM.FCOMMENT AS FCOMMENT FROM T_BG_RefBgForm REFBGFORM");
        sqlToGetComment.append(" LEFT OUTER JOIN T_BG_BgForm BGFORM ON REFBGFORM.FBgFormID = BGFORM.FID ");
        sqlToGetComment.append(" LEFT OUTER JOIN T_ORG_BaseUnit ORG ON ORG.FID = BGFORM.FOrgUnitID ");
        if (isDecForm) {
            sqlToGetComment.append(" where REFBGFORM.FBgCollectID = ?");
        } else {
            sqlToGetComment.append(" where REFBGFORM.FID = ?");
        }
        IRowSet rsToGetComment = DbUtil.executeQuery((Context)ctx, (String)sqlToGetComment.toString(), (Object[])new Object[]{bgFormPK.toString()});
        try {
            while (rsToGetComment.next()) {
                if (rsToGetComment.getObject("FCOMMENT") == null) continue;
                commentList.add(rsToGetComment.getString("FORGNAME") + "    " + rsToGetComment.getString("FCOMMENT"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return commentList;
    }

    @Override
    protected void _addCommentByBgForm(Context ctx, IObjectPK bgFormPK, String comment) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String commentStr = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FCOMMENT from T_BG_REFBGFORM where FBGFORMID=?");
            pstmt.setString(1, bgFormPK.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                commentStr = rst.getString(1);
                comment = commentStr == null || commentStr.equals("") ? comment : commentStr + "\r\n" + comment;
            }
            pstmt.close();
            pstmt = conn.prepareStatement("UPDATE T_BG_REFBGFORM SET FCOMMENT = ? where FBGFORMID = ?");
            pstmt.setString(1, comment);
            pstmt.setString(2, bgFormPK.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] _getKdf(Context ctx, BOSUuid bgDecFormId, BOSUuid refBgDecFormId, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgDecFormId == null) return null;
        if (refBgDecFormId == null) return null;
        if (bgFormId == null) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FKdtData from T_BG_RefBgDecForm where FBgDecomposerID = ? and FID = ? and FBgFormID = ?");
        byte[] data = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgDecFormId.toString());
            pstmt.setString(2, refBgDecFormId.toString());
            pstmt.setString(3, bgFormId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                data = BgInfoHelper.getBytes((ResultSet)rst, (int)1);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (IOException ex3) {
                    logger.error((Object)ex3);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return data;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _submitKdf(Context ctx, BOSUuid bgDecId, BOSUuid refBgDecId, BOSUuid bgFormId, IObjectValue model) throws BOSException, EASBizException {
        if (bgDecId == null) return;
        if (refBgDecId == null) return;
        if (bgFormId == null) return;
        if (model == null) {
            return;
        }
        RefBgDecFormInfo refBgDecFormInfo = (RefBgDecFormInfo)model;
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_RefBgDecForm set FKdtData = ? where FBgDecomposerID = ? and FID = ? and FBgFormID = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setBytes(1, refBgDecFormInfo.getKdtData());
            pstmt.setString(2, bgDecId.toString());
            pstmt.setString(3, refBgDecId.toString());
            pstmt.setString(4, bgFormId.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

