/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCollectException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.RefBgFormCollection;
import com.kingdee.eas.ma.budget.RefBgFormInfo;
import com.kingdee.eas.ma.budget.app.AbstractRefBgFormControllerBean;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RefBgFormControllerBean
extends AbstractRefBgFormControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.RefBgFormControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _loadRefBgFormCollectionByBgForm(Context ctx, IObjectValue bgFormInfo, List ouIdList) throws BOSException, EASBizException {
        RefBgFormCollection refBgFormCols = new RefBgFormCollection();
        if (ouIdList == null) throw new BgCollectException(BgCollectException.HASNOOUSELECTED);
        if (ouIdList.size() == 0) {
            throw new BgCollectException(BgCollectException.HASNOOUSELECTED);
        }
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        SelectorItemCollection bgSic = new SelectorItemCollection();
        bgSic.add("bgTemplate.rootId");
        bgSic.add("bgScheme.rootId");
        bgSic.add("bgPeriod.id");
        bgSic.add("currency.id");
        BgFormInfo selectedBgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.get("id").toString()), bgSic);
        int batchNum = 500;
        int size = ouIdList.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fid,t1.fnumber,t1.fname,t1.forgunitid from t_bg_bgform t1 ");
        sql.append("inner join t_bg_bgtemplate t2 on t1.fbgtemplateid=t2.fid ");
        sql.append("inner join t_bg_bgscheme t3 on t1.fbgschemeid=t3.fid ");
        sql.append("where t2.frootid = '").append(selectedBgFormInfo.getBgTemplate().getRootId().toString()).append("' ");
        sql.append("and t3.frootid = '").append(selectedBgFormInfo.getBgScheme().getRootId().toString()).append("' ");
        sql.append("and t1.fcurrencyid = '").append(selectedBgFormInfo.getCurrency().getId().toString()).append("' ");
        sql.append("and t1.fbgperiodid = '").append(selectedBgFormInfo.getBgPeriod().getId().toString()).append("' ");
        sql.append("and t1.fstate = 2 ");
        sql.append("and t1.forgunitid in (");
        for (int i = 0; i < batchNum; ++i) {
            if (i != batchNum - 1) {
                sql.append("?,");
                continue;
            }
            sql.append("?)");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgFormInfo _bgFormInfo = null;
            RefBgFormInfo child = null;
            FullOrgUnitInfo orgUnitInfo = null;
            for (int index = 0; index < count; ++index) {
                for (int k = 1; k <= batchNum; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k, (String)ouIdList.get(pos));
                        continue;
                    }
                    pstmt.setString(k, "#");
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    _bgFormInfo = new BgFormInfo();
                    _bgFormInfo.setId(BOSUuid.read((String)rs.getString(1)));
                    _bgFormInfo.setNumber(rs.getString(2));
                    _bgFormInfo.setName(rs.getString(3));
                    orgUnitInfo = new FullOrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)rs.getString(4)));
                    _bgFormInfo.setOrgUnit(orgUnitInfo);
                    child = new RefBgFormInfo();
                    child.setBgForm(_bgFormInfo);
                    refBgFormCols.add(child);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (IOException e2) {
                    throw new BOSException((Throwable)e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new BOSException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
        return refBgFormCols;
    }

    @Override
    protected List _getCommentByBgForm(Context ctx, IObjectPK bgFormPK, boolean isCollectForm) throws BOSException, BgCollectException {
        ArrayList<String> commentList = new ArrayList<String>();
        StringBuffer sqlToGetComment = new StringBuffer("SELECT ORG.FName_l2 AS FORGNAME, REFBGFORM.FCOMMENT AS FCOMMENT FROM T_BG_RefBgForm REFBGFORM");
        sqlToGetComment.append(" LEFT OUTER JOIN T_BG_BgForm BGFORM ON REFBGFORM.FBgFormID = BGFORM.FID ");
        sqlToGetComment.append(" LEFT OUTER JOIN T_ORG_BaseUnit ORG ON ORG.FID = BGFORM.FOrgUnitID ");
        if (isCollectForm) {
            sqlToGetComment.append(" where REFBGFORM.FBgCollectID = ?");
        } else {
            sqlToGetComment.append(" where REFBGFORM.FID = ?");
        }
        IRowSet rsToGetComment = DbUtil.executeQuery((Context)ctx, (String)sqlToGetComment.toString(), (Object[])new Object[]{bgFormPK.toString()});
        try {
            while (rsToGetComment.next()) {
                if (rsToGetComment.getObject("FCOMMENT") == null) continue;
                commentList.add(rsToGetComment.getString("FORGNAME") + "    " + rsToGetComment.getString("FCOMMENT"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return commentList;
    }

    @Override
    protected void _addCommentByBgForm(Context ctx, IObjectPK bgFormPK, String comment) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String commentStr = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FCOMMENT from T_BG_REFBGFORM where FBGFORMID=?");
            pstmt.setString(1, bgFormPK.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                commentStr = rst.getString(1);
                comment = commentStr == null || commentStr.equals("") ? comment : commentStr + "\r\n" + comment;
            }
            pstmt.close();
            pstmt = conn.prepareStatement("UPDATE T_BG_REFBGFORM SET FCOMMENT = ? where FBGFORMID = ?");
            pstmt.setString(1, comment);
            pstmt.setString(2, bgFormPK.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] _getKdf(Context ctx, BOSUuid bgCollectId, BOSUuid refBgFormId, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgCollectId == null && refBgFormId != null && bgFormId == null) {
            return this.getKdfFromID(ctx, refBgFormId);
        }
        if (bgCollectId == null) return null;
        if (refBgFormId == null) return null;
        if (bgFormId == null) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FKdtData from T_BG_RefBgForm where FBgCollectID = ? and FID = ? and FBgFormID = ?");
        byte[] data = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgCollectId.toString());
            pstmt.setString(2, refBgFormId.toString());
            pstmt.setString(3, bgFormId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                data = BgInfoHelper.getBytes((ResultSet)rst, (int)1);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (IOException ex3) {
                    logger.error((Object)ex3);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return data;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getKdfFromID(Context ctx, BOSUuid refBgFormId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FKdtData from T_BG_RefBgForm where  FID = ? ");
        byte[] data = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, refBgFormId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                data = BgInfoHelper.getBytes((ResultSet)rst, (int)1);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (IOException ex3) {
                    logger.error((Object)ex3);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return data;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _submitKdf(Context ctx, BOSUuid bgCollectId, BOSUuid refBgFormId, BOSUuid bgFormId, IObjectValue model) throws BOSException, EASBizException {
        if (bgCollectId == null) return;
        if (refBgFormId == null) return;
        if (bgFormId == null) return;
        if (model == null) {
            return;
        }
        RefBgFormInfo refBgFormInfo = (RefBgFormInfo)model;
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_RefBgForm set FKdtData = ? where FBgCollectID = ? and FID = ? and FBgFormID = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setBytes(1, refBgFormInfo.getKdtData());
            pstmt.setString(2, bgCollectId.toString());
            pstmt.setString(3, refBgFormId.toString());
            pstmt.setString(4, bgFormId.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

