/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.ma.cal.IInvAccountBill;
import com.kingdee.eas.ma.cal.InvAccountBillCollection;
import com.kingdee.eas.ma.cal.InvAccountBillFactory;
import com.kingdee.eas.ma.cal.InvAccountBillInfo;
import com.kingdee.eas.ma.cal.app.AbstractInvAccountBillControllerBean;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class InvAccountBillControllerBean
extends AbstractInvAccountBillControllerBean {
    private static final long serialVersionUID = -4162543257576620418L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.cal.app.InvAccountBillControllerBean");

    @Override
    protected void _batchUpdatePartial(Context ctx, InvAccountBillCollection col, SelectorItemCollection sic) throws BOSException, EASBizException {
        IInvAccountBill iInvAccountBill = InvAccountBillFactory.getLocalInstance(ctx);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            InvAccountBillInfo info = col.get(i);
            iInvAccountBill.updatePartial((CoreBaseInfo)info, sic);
        }
    }

    @Override
    protected int _standardCost(Context ctx, String queryPK, String filterItems) throws BOSException, EASBizException {
        String filter = this.structureFilter(ctx, filterItems, queryPK);
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_CAL_InvAccountBill as invbill ");
        sql.append(" set (FUnitCost,FCost) = (");
        sql.append(" select round(mc.FStandardCost,material.FPricePrecision), ");
        sql.append(" round(inv.FBaseQty*mc.FStandardCost,cur.FPrecision) ");
        sql.append(" from T_CAL_InvAccountBill as inv ");
        sql.append(" inner join T_BD_Material material on inv.FMaterialID = material.FID ");
        sql.append(" inner join T_BD_MaterialCompanyInfo mc on inv.FMaterialID = mc.FMaterialID and inv.FCompanyID = mc.FCompanyID and mc.fstatus = 1");
        sql.append(" inner join T_BD_Currency  cur on inv.FCurrencyID = cur.FID");
        sql.append(" inner join T_ORG_ProfitCenter c on inv.FProfitCenterID = c.fid");
        sql.append(" inner join T_BD_SystemStatusCtrol sc on c.FID = sc.FProfitCenterID  ");
        sql.append(" inner join t_bd_period period on period.fid = sc.FCurrentPeriodID and period.fid = inv.fperiodid");
        sql.append(" inner join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID and s.FName = ").append(1007);
        sql.append(" where inv.FID = invbill.FID and mc.FStandardCost <> 0");
        sql.append(" ) ");
        sql.append(" where invbill.FID in ( ").append(filter).append(" ) ");
        sql.append(" and invbill.FUnitCost = 0");
        sql.append(" and invbill.FSourceBillTypeID != '").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        sql.append(" and ((invbill.foutOrInWareHouse=20 and invbill.fisPresent !=1) or invbill.foutOrInWareHouse=10)");
        int count = SQLUtils.execute((Context)ctx, (String)sql.toString());
        return count;
    }

    @Override
    protected int _newInpourCost(Context ctx, String queryPK, String filterItems) throws BOSException, EASBizException {
        String filter = this.structureFilter(ctx, filterItems, queryPK);
        String sql = this.updateNewCost(filter, true);
        int count = SQLUtils.execute((Context)ctx, (String)sql.toString());
        return count;
    }

    @Override
    protected int _newPayoutCost(Context ctx, String queryPK, String filterItems) throws BOSException, EASBizException {
        String filter = this.structureFilter(ctx, filterItems, queryPK);
        String sql = this.updateNewCost(filter, false);
        int count = SQLUtils.execute((Context)ctx, (String)sql.toString());
        return count;
    }

    private String updateNewCost(String filter, boolean isInpour) {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_CAL_InvAccountBill as invAccountBill ");
        sql.append(" set (FUnitCost,FCost) = (select ");
        sql.append(" round(newcostbill.unitCost,material.FPricePrecision) , ");
        sql.append(" round(inv.FBaseQty*newcostbill.unitCost,cur.FPrecision)");
        sql.append(" from T_CAL_InvAccountBill inv ");
        sql.append(" inner join T_ORG_ProfitCenter c on inv.FProfitCenterID = c.fid");
        sql.append(" inner join T_BD_SystemStatusCtrol sc on c.FID = sc.FProfitCenterID  ");
        sql.append(" inner join t_bd_period period on period.fid = sc.FCurrentPeriodID and period.fid = inv.fperiodid");
        sql.append(" inner join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID and s.FName = ").append(1007);
        sql.append(" inner join T_BD_Currency  cur on inv.FCurrencyID = cur.FID");
        sql.append(" inner join T_BD_Material material on inv.FMaterialID = material.FID ");
        sql.append(" inner join (");
        sql.append("   select max(costbill.FUnitCost) as unitCost ,").append(this.getSelectOrGroupBySql("costbill"));
        sql.append("   from T_CAL_InvAccountBill as costbill ");
        sql.append("   inner join ( ");
        sql.append("     select max(audittimebill.FAuditTime) as maxAuditTime,").append(this.getSelectOrGroupBySql("audittimebill"));
        sql.append("     from T_CAL_InvAccountBill as audittimebill ");
        sql.append("     inner join (");
        sql.append("               select max(billdatebill.FBilldate) as maxbillDate,").append(this.getSelectOrGroupBySql("billdatebill"));
        sql.append("               from T_CAL_InvAccountBill as billdatebill");
        sql.append("               where billdatebill.FUnitCost> 0");
        if (isInpour) {
            sql.append("           and billdatebill.FOutorinwareHouse = 20 ");
        } else {
            sql.append("           and billdatebill.FOutorinwareHouse = 10 ");
        }
        sql.append("               group by ").append(this.getSelectOrGroupBySql("billdatebill"));
        sql.append("              ) as maxbilldatebill ");
        sql.append("            on ").append(this.getDimJoinSql("audittimebill", "maxbilldatebill")).append(" and audittimebill.fbillDate = maxbilldatebill.maxBillDate");
        sql.append("            group by ").append(this.getSelectOrGroupBySql("audittimebill"));
        sql.append("        ) as maxaudittimebill");
        sql.append("      on ").append(this.getDimJoinSql("costbill", "maxaudittimebill")).append("and costbill.faudittime = maxaudittimebill.maxaudittime");
        sql.append("     group by ").append(this.getSelectOrGroupBySql("costbill"));
        sql.append("  ) as newcostbill");
        sql.append(" on   ").append(this.getDimJoinSql("inv", "newcostbill"));
        sql.append(" where inv.FID = invAccountBill.FID )");
        sql.append(" where invAccountBill.FUnitCost = 0 and invAccountBill.FID in ( ").append(filter).append(" ) ");
        sql.append(" and invAccountBill.FUnitCost = 0");
        sql.append(" and invAccountBill.FSourceBillTypeID != '").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        sql.append(" and ((invAccountBill.foutOrInWareHouse=20 and invAccountBill.fisPresent !=1) or invAccountBill.foutOrInWareHouse=10)");
        return sql.toString();
    }

    private String getSelectOrGroupBySql(String tableAlias) {
        StringBuffer select = new StringBuffer();
        if (tableAlias == null) {
            select.append("  FProfitCenterID,FMaterialID,FLot,FAssistPropertyID,FProjectID,FTrackNumberID");
        } else {
            select.append(" ").append(tableAlias).append(".FProfitCenterID,").append(tableAlias).append(".FMaterialID,").append(tableAlias).append(".FLot,").append(tableAlias).append(".FAssistPropertyID,").append(tableAlias).append(".FProjectID,").append(tableAlias).append(".FTrackNumberID ");
        }
        return select.toString();
    }

    private String getDimJoinSql(String fromTable, String toTable) {
        StringBuffer sql = new StringBuffer();
        sql.append(" ").append(fromTable).append(".FProfitCenterID = ").append(toTable).append(".FProfitCenterID");
        sql.append(" and  ").append(fromTable).append(".FMaterialID =").append(toTable).append(".FMaterialID");
        sql.append(" and ((").append(fromTable).append(".FLot is null and ").append(toTable).append(".FLot is null) or (").append(fromTable).append(".FLot =  ").append(toTable).append(".FLot))");
        sql.append(" and ((").append(fromTable).append(".FAssistPropertyID is null and ").append(toTable).append(".FAssistPropertyID is null) or (").append(fromTable).append(".FAssistPropertyID =  ").append(toTable).append(".FAssistPropertyID))");
        sql.append(" and ((").append(fromTable).append(".FProjectID is null and ").append(toTable).append(".FProjectID is null) or (").append(fromTable).append(".FProjectID =  ").append(toTable).append(".FProjectID))");
        sql.append(" and ((").append(fromTable).append(".FTrackNumberID is null and ").append(toTable).append(".FTrackNumberID is null) or (").append(fromTable).append(".FTrackNumberID =  ").append(toTable).append(".FTrackNumberID)) ");
        return sql.toString();
    }

    @Override
    protected int _beginCost(Context ctx, String queryPK, String filterItems) throws BOSException, EASBizException {
        String filter = this.structureFilter(ctx, filterItems, queryPK);
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_cal_invAccountbill invbill set (funitcost,fcost) = (");
        sql.append(" select round(temp.unitCost,material.FPricePrecision),round(temp.unitCost*inv.FBaseQty,cur.FPrecision) from T_CAL_InvAccountBill inv");
        sql.append(" inner join T_ORG_ProfitCenter c on inv.FProfitCenterID = c.fid");
        sql.append(" inner join T_BD_SystemStatusCtrol sc on c.FID = sc.FProfitCenterID  ");
        sql.append(" inner join t_bd_period period on period.fid = sc.FCurrentPeriodID and period.fid = inv.fperiodid");
        sql.append(" inner join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID and s.FName = ").append(1007);
        sql.append(" inner join (");
        sql.append(" select sum(abs(balance.FPeriodBeginBalance))/sum(abs(balance.FPeriodBeginQty)) as unitCost, ");
        sql.append(" balance.FProfitCenterID,Fyear,FPeriod,FMaterialID,FLot,FAssistPropertyID,FProjectID,FTrackNumberID");
        sql.append(" from T_CAL_InventoryBalance  balance ");
        sql.append(" inner join T_ORG_ProfitCenter c on c.FID = balance.FProfitCenterID");
        sql.append(" inner join t_bd_period period on  balance.Fyear = period.FPeriodYear  and balance.FPeriod = period.FPeriodNumber");
        sql.append(" inner join T_BD_SystemStatusCtrol sc on c.FID = sc.FProfitCenterID  and period.fid = sc.FCurrentPeriodID");
        sql.append(" inner join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID and s.FName = ").append(1007);
        sql.append(" where balance.FPeriodBeginQty <> 0");
        sql.append(" group by balance.FProfitCenterID,Fyear,FPeriod,FMaterialID,FLot,FAssistPropertyID,FProjectID,FTrackNumberID ) temp");
        sql.append(" on temp.FProfitCenterID = inv.FProfitCenterID ");
        sql.append(" and temp.FMaterialID = inv.FMaterialID ");
        sql.append(" and ((temp.FLot is null and inv.FLot is null) or ( temp.FLot =  inv.FLot)) ");
        sql.append(" and ((temp.FAssistPropertyID is null and inv.FAssistPropertyID is null) or ( temp.FAssistPropertyID =  inv.FAssistPropertyID)) ");
        sql.append(" and ((temp.FProjectID is null and inv.FProjectID is null) or ( temp.FProjectID =  inv.FProjectID)) ");
        sql.append(" and ((temp.FTrackNumberID is null and inv.FTrackNumberID is null) or ( temp.FTrackNumberID =  inv.FTrackNumberID))");
        sql.append(" inner join T_BD_Material material on inv.FMaterialID = material.FID ");
        sql.append(" inner join T_ORG_Company  company  on inv.FCompanyID = company.fid");
        sql.append(" inner join T_BD_Currency  cur on company.FBaseCurrencyID= cur.FID");
        sql.append(" where invbill.fid = inv.fid )");
        sql.append(" where invbill.FID in ( ").append(filter).append(" ) ");
        sql.append(" and invbill.FUnitCost = 0");
        sql.append(" and invbill.FSourceBillTypeID != '").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        sql.append(" and ((invbill.FoutOrInWareHouse=20 and invbill.fisPresent !=1) or invbill.FoutOrInWareHouse=10)");
        int count = SQLUtils.execute((Context)ctx, (String)sql.toString());
        return count;
    }

    @Override
    protected int _queryCostIsZero(Context ctx, String queryPK, String filterItems) throws BOSException {
        String filter = this.structureFilter(ctx, filterItems, queryPK);
        StringBuffer sql = new StringBuffer("select count(*) count from T_CAL_InvAccountBill invbill");
        sql.append(" inner join T_ORG_ProfitCenter c on invbill.FProfitCenterID = c.fid");
        sql.append(" inner join T_BD_SystemStatusCtrol sc on c.FID = sc.FProfitCenterID  ");
        sql.append(" inner join t_bd_period period on period.fid = sc.FCurrentPeriodID and period.fid = invbill.fperiodid");
        sql.append(" inner join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID and s.FName = ").append(1007);
        sql.append(" where invbill.FID in ( ").append(filter).append(" )");
        sql.append(" and invbill.FUnitCost = 0");
        sql.append(" and invbill.FSourceBillTypeID != '").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        sql.append(" and ((invbill.FoutOrInWareHouse=20 and invbill.fisPresent !=1) or invbill.FoutOrInWareHouse=10)");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        int row = 0;
        try {
            while (rs.next()) {
                row = rs.getInt("count");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return row;
    }

    private String structureFilter(Context ctx, String filterItems, String queryPK) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        if (filterItems != null && filterItems.length() > 0) {
            try {
                view.setFilter(new FilterInfo(filterItems));
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        exec.setObjectView(view);
        String sql = exec.getSQL();
        return sql;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        if (new PcVoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            CoreBillBaseCollection srcBillVOs = new CoreBillBaseCollection();
            srcBillVOs.addObject(srcBillVO);
            BOTRelationCollection botRelationInfos = new BOTRelationCollection();
            botRelationInfos.add(botRelation);
            this._batchReverseSave(ctx, new IObjectPK[]{srcBillPK}, srcBillVOs, bOTBillOperStateEnum, botRelationInfos);
        }
    }

    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("bOTRelationInfos.length:" + bOTRelationInfos.size()));
        if (bOTRelationInfos.size() < 1) {
            return;
        }
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        logger.debug((Object)("botRelation.destEntityId:" + botRelation.getDestEntityID()));
        logger.debug((Object)("botRelation.srcEntityId:" + botRelation.getSrcEntityID()));
        if (!new PcVoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            return;
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)botRelation.getSrcEntityID()));
        String tableName = entity.getTable().getName();
        try {
            String fvoucherid;
            String string = fvoucherid = "t_fa_facurcard".equals(tableName.toLowerCase(Locale.ENGLISH)) ? "fvoucher" : "fvoucherid";
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                StringBuffer sql = new StringBuffer();
                StringBuffer sqlin = new StringBuffer();
                int size = bOTRelationInfos.size();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        sqlin.append(",");
                    }
                    sqlin.append("'").append(bOTRelationInfos.get(i).getSrcObjectID()).append("'");
                }
                sql.append("update ").append(tableName).append(" set ").append(fvoucherid).append(" = null,FFiVouchered = 0 ").append("where ").append("fid in (").append(sqlin).append(")");
                String sqlStr = sql.toString();
                DbUtil.execute((Context)ctx, (String)sqlStr);
            } else {
                HashMap<String, StringBuffer> destSrcIDMap = new HashMap<String, StringBuffer>();
                int size = bOTRelationInfos.size();
                for (int i = 0; i < size; ++i) {
                    String destBillId = bOTRelationInfos.get(i).getDestObjectID();
                    String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                    if (destSrcIDMap.containsKey(destBillId)) {
                        ((StringBuffer)destSrcIDMap.get(destBillId)).append(",'").append(srcBillId).append("'");
                        continue;
                    }
                    destSrcIDMap.put(destBillId, new StringBuffer("'" + srcBillId + "'"));
                }
                Iterator it = destSrcIDMap.keySet().iterator();
                String[] sqls = new String[destSrcIDMap.keySet().size()];
                StringBuffer sql = new StringBuffer();
                int cnt = 0;
                String destID = null;
                while (it.hasNext()) {
                    sql.setLength(0);
                    destID = (String)it.next();
                    sql.append("update ").append(tableName).append(" set ").append(fvoucherid).append(" = '").append(destID).append("',").append("FFiVouchered =  1 ").append("where ").append("fid in (").append(destSrcIDMap.get(destID)).append(")");
                    sqls[cnt] = sql.toString();
                    ++cnt;
                }
                DBUtil.executeBatch((Context)ctx, (String[])sqls);
            }
        }
        catch (BOSException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        logger.debug((Object)("batchReverseSave spent:" + (System.currentTimeMillis() - t1) + "ms"));
    }
}

