/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.app.AbstractIssueCalculateFacadeControllerBean;
import com.kingdee.eas.ma.cal.app.issueCalculate.BillChecker;
import com.kingdee.eas.ma.cal.app.issueCalculate.Calculater;
import com.kingdee.eas.ma.cal.app.issueCalculate.ProfitCenterData;
import com.kingdee.eas.ma.cal.app.utils.CalUtils;
import com.kingdee.eas.ma.scmcommon.ITaskProgressFacade;
import com.kingdee.eas.ma.scmcommon.TaskProgressFacadeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class IssueCalculateFacadeControllerBean
extends AbstractIssueCalculateFacadeControllerBean {
    private static final long serialVersionUID = -3271127095664086979L;

    @Override
    protected void _calculate(Context ctx, Map params) throws BOSException, EASBizException {
        Calculater cal = new Calculater(ctx);
        String taskId = (String)params.get("taskId");
        cal.setTaskID(taskId);
        cal.execute(params);
    }

    @Override
    protected Map _checkBill(Context ctx, Map params) throws BOSException, EASBizException {
        boolean checkUnAuditBill;
        boolean checkVoucherBill;
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        boolean checkZeroBill = (Boolean)params.get("checkZeroBill");
        if (checkZeroBill) {
            int zeroBill = BillChecker.checkZeroBill(ctx, params);
            result.put("ZeroBill", zeroBill);
        }
        if (checkVoucherBill = ((Boolean)params.get("checkVoucherBill")).booleanValue()) {
            int voucherBill = BillChecker.checkVoucherBill(ctx, params);
            result.put("VoucherBill", voucherBill);
        }
        if (checkUnAuditBill = ((Boolean)params.get("checkUnAuditBill")).booleanValue()) {
            int unAuditBill = BillChecker.checkUnAuditBill(ctx, params);
            result.put("unAuditBill", unAuditBill);
        }
        return result;
    }

    @Override
    protected List _getCustMaterialDims(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getProfitCenterData(Context ctx, Map params) throws BOSException, EASBizException {
        ProfitCenterData data = new ProfitCenterData(ctx, params);
        return data.getProfitCenterData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _autoCalculate(Context ctx, String profixCenterNumbers, String costItems, String checkItems, String calculateItems) throws BOSException, EASBizException {
        String[] profixCenterNumbersArr = profixCenterNumbers.split(",");
        HashMap<String, String> dataParams = new HashMap<String, String>();
        dataParams.put("filter", null);
        dataParams.put("permission", "ma_cal_CloseAccount_View");
        Map result = new ProfitCenterData(ctx, dataParams).getProfitCenterData();
        List orgs = (List)result.get("rows");
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        Map org = null;
        HashSet idSet = new HashSet();
        int size = orgs.size();
        for (int i = 0; i < size; ++i) {
            org = (Map)orgs.get(i);
            idSet.add(org.get("orgId"));
        }
        HashSet<String> numberSet = new HashSet<String>();
        int size2 = profixCenterNumbersArr.length;
        for (int i = 0; i < size2; ++i) {
            numberSet.add(profixCenterNumbersArr[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        view.setFilter(filter);
        ProfitCenterOrgUnitCollection coll = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitCollection(view);
        if (coll.size() == 0) {
            return null;
        }
        String[] profixCenterIdsArr = new String[coll.size()];
        ArrayList rows = new ArrayList();
        HashMap<String, String> row = null;
        int size3 = coll.size();
        for (int i = 0; i < size3; ++i) {
            row = new HashMap<String, String>();
            profixCenterIdsArr[i] = coll.get(i).getId().toString();
            row.put("orgId", coll.get(i).getId().toString());
            rows.add(row);
        }
        Map<String, Object> params = this.getCalculateParams(costItems, checkItems, calculateItems);
        if (params == null) {
            return null;
        }
        Map<String, PeriodInfo> periodMap = CalUtils.getPeriod(ctx, profixCenterIdsArr, 1007);
        String catalog = "issuecalculate";
        String parentTaskid = null;
        ITaskProgressFacade iTask = TaskProgressFacadeFactory.getLocalInstance((Context)ctx);
        try {
            HashMap<String, Object> taskparams = new HashMap<String, Object>();
            taskparams.put("catalog", catalog);
            taskparams.put("rows", rows);
            Map taskMap = TaskProgressFacadeFactory.getLocalInstance((Context)ctx).batchCreateTask(taskparams);
            parentTaskid = (String)taskMap.get("parenttaskid");
            List tasklist = (List)taskMap.get("tasklist");
            int size4 = tasklist.size();
            if (size4 == 0) {
                Map map = null;
                return map;
            }
            Map checkResult = null;
            String profixCenterId = null;
            String taskid = null;
            String periodId = null;
            PeriodInfo periodInfo = null;
            Map task = null;
            for (int i = 0; i < size4; ++i) {
                task = (Map)tasklist.get(i);
                profixCenterId = (String)task.get("orgid");
                taskid = (String)task.get("taskid");
                periodInfo = periodMap.get(profixCenterId);
                if (periodInfo == null) continue;
                periodId = periodInfo.getId().toString();
                task = (Map)tasklist.get(i);
                params.put("taskId", taskid);
                params.put("profitCenterOrgId", profixCenterId);
                params.put("periodId", periodId);
                checkResult = this._checkBill(ctx, params);
                int zeroBill = 0;
                int voucherBill = 0;
                int unAuditBill = 0;
                if (checkResult.get("ZeroBill") != null) {
                    zeroBill = Integer.parseInt(checkResult.get("ZeroBill").toString());
                }
                if (checkResult.get("VoucherBill") != null) {
                    voucherBill = Integer.parseInt(checkResult.get("VoucherBill").toString());
                }
                if (checkResult.get("unAuditBill") != null) {
                    unAuditBill = Integer.parseInt(checkResult.get("unAuditBill").toString());
                }
                HashMap<String, Object> updateMap = new HashMap<String, Object>();
                updateMap.put("TaskID", taskid);
                updateMap.put("Complete", 100);
                if (zeroBill > 0 || voucherBill > 0 || unAuditBill > 0) {
                    String statusStr = (zeroBill > 0 ? "1" : "0") + (voucherBill > 0 ? "1" : "0") + (unAuditBill > 0 ? "1" : "0") + "0";
                    int status = -Integer.parseInt(statusStr, 2);
                    updateMap.put("Status", status);
                    iTask.updateProgress(updateMap);
                    continue;
                }
                try {
                    this._calculate(ctx, params);
                    updateMap.put("Status", 9);
                    iTask.updateProgress(updateMap);
                    continue;
                }
                catch (Exception e) {
                    updateMap.put("Status", -1);
                    updateMap.put("Description", EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"calculate_fail", (Locale)ctx.getOriginLocale()));
                    iTask.updateProgress(updateMap);
                    this.setRollbackOnly();
                }
            }
        }
        finally {
            if (parentTaskid != null) {
                HashMap<String, Object> updateMap = new HashMap<String, Object>();
                updateMap.put("TaskID", parentTaskid);
                updateMap.put("Status", 9);
                updateMap.put("Complete", 100);
                iTask.updateProgress(updateMap);
            }
        }
        return null;
    }

    private Map<String, Object> getCalculateParams(String costItems, String checkItems, String calculateItems) {
        String[] costItemsArr = costItems.split(",");
        String[] checkItemsArr = checkItems.split(",");
        String[] calculateItemsArr = calculateItems.split(",");
        String trueNum = "1";
        if (costItemsArr.length < 2 || checkItemsArr.length < 3 || calculateItemsArr.length < 2) {
            return null;
        }
        boolean addAverage = costItemsArr[0].equals(trueNum);
        boolean specialAcct = false;
        boolean moveAverage = costItemsArr[1].equals(trueNum);
        boolean checkZeroBill = checkItemsArr[0].equals(trueNum);
        boolean checkVoucherBill = checkItemsArr[1].equals(trueNum);
        boolean checkUnAuditBill = checkItemsArr[2].equals(trueNum);
        boolean isWriteReport = calculateItemsArr[0].equals(trueNum);
        boolean onlyReportError = calculateItemsArr[1].equals(trueNum);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("checkZeroBill", checkZeroBill);
        params.put("checkVoucherBill", checkVoucherBill);
        params.put("checkUnAuditBill", checkUnAuditBill);
        params.put("isWriteReport", isWriteReport);
        params.put("onlyReportError", onlyReportError);
        ArrayList<AccountType> accountTypeList = new ArrayList<AccountType>();
        if (addAverage) {
            accountTypeList.add(AccountType.ADD_AVERAGE);
        }
        if (specialAcct) {
            accountTypeList.add(AccountType.SPECIAL_ACCT);
        }
        if (moveAverage) {
            accountTypeList.add(AccountType.MOVE_WEIGHTED_AVERAGE);
        }
        AccountType[] accountType = new AccountType[accountTypeList.size()];
        int size = accountTypeList.size();
        for (int i = 0; i < size; ++i) {
            accountType[i] = (AccountType)accountTypeList.get(i);
        }
        params.put("accountType", accountType);
        return params;
    }

    private Map createTask(Context ctx, String tasklog, int size) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ITaskProgressFacade taskFacade = TaskProgressFacadeFactory.getLocalInstance((Context)ctx);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("catalog", tasklog);
        String parenttaskid = taskFacade.createTask(params);
        params.put("parentId", parenttaskid);
        ArrayList<String> tasklist = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            params.put("seq", i + "");
            tasklist.add(taskFacade.createTask(params));
        }
        result.put("parenttaskid", parenttaskid);
        result.put("taskids", tasklist);
        return result;
    }
}

