/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.issueCalculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.app.issueCalculate.CalculateCommon;
import com.kingdee.eas.ma.cal.app.issueCalculate.Calculater;
import com.kingdee.eas.ma.cal.app.issueCalculate.IAccountTypeCalculate;
import com.kingdee.eas.ma.cal.app.issueCalculate.MaterialDimension;
import com.kingdee.eas.ma.cal.app.issueCalculate.model.RecentCostInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MoveAverageCalculater
implements IAccountTypeCalculate {
    private static final int MAXROWS = 500;
    private Calculater pCmd = null;
    private String materialId = null;
    private MaterialDimension dim = null;
    private AccountType accountType = null;
    private CalculateCommon calCommon = null;
    private String mainTempTable = null;
    Map<String, BigDecimal[]> beginDataMap = null;
    BigDecimal lastIncomeUnitCost = null;
    private int pricePrecision = 8;
    private int qtyPrecision = 8;
    private Map<String, Object> retMap = null;

    public MoveAverageCalculater(Map<String, Object> params) {
        this.pCmd = (Calculater)((Object)params.get("bizCommand"));
        this.dim = (MaterialDimension)params.get("materialDemension");
        this.materialId = (String)params.get("materialId");
        this.pricePrecision = (Integer)params.get("pricePrecision");
        this.qtyPrecision = (Integer)params.get("qtyPrecision");
        this.accountType = (AccountType)params.get("accountType");
        this.retMap = (Map)params.get("retMap");
        this.calCommon = new CalculateCommon(this.pCmd, this.materialId, this.dim, this.accountType);
    }

    @Override
    public void calculate() throws Exception {
        this.beginDataMap = this.calCommon.sumBalance();
        this.prepareData();
        try {
            this.calculateOutCost();
        }
        finally {
            CalculateCommon.releaseTemptable(this.pCmd.getContext(), this.mainTempTable);
        }
    }

    private String prepareData() throws BOSException, EASBizException {
        StringBuffer sbSql = new StringBuffer(200);
        sbSql.append("Create Table vtkkkkbbb ( ").append("KSQL_SEQ INT IDENTITY (1, 1) NOT NULL primary key,").append("FID VARCHAR(44),").append("FSourcebillnumber NVARCHAR(80),").append(this.dim.getTableFields(1)).append("FOutOrInWareHouse INT,").append("FBaseQty Numeric(21,8), ").append("FCost Numeric(17,4), ").append("FUnitCost Numeric(21,8),").append("FResult varchar(200) )");
        this.mainTempTable = CalculateCommon.createTempTable(this.pCmd.getContext(), sbSql.toString());
        String cols = this.dim.getSelect(null, 1);
        sbSql.setLength(0);
        sbSql.append("insert ").append(this.mainTempTable).append(" (KSQL_SEQ,FID,FSourcebillnumber,").append(cols).append(",FOutOrInWareHouse,FBaseQty,FCost,FUnitCost)").append(" select FID,FSourcebillnumber,").append(cols).append(",FOutOrInWareHouse,FBaseQty,FCost,FUnitCost ").append(" from T_CAL_InvAccountBill").append(" where FProfitCenterID = ? ").append(" and FPeriodID = ? ").append(" and FMaterialID = ?").append(" order by ").append(cols).append(",FBizDate,FAuditTime ");
        ArrayList<String> sqlParams = new ArrayList<String>();
        sqlParams.add(this.pCmd.profitCenterOrgId);
        sqlParams.add(this.pCmd.periodId);
        sqlParams.add(this.materialId);
        this.pCmd.execute(sbSql.toString(), sqlParams.toArray());
        return this.mainTempTable;
    }

    private BigDecimal[] getBeginData(String key) {
        BigDecimal[] data = this.beginDataMap.get(key);
        if (data == null) {
            data = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        } else {
            BigDecimal unitCost;
            data[2] = data[1].compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : (unitCost = data[0].divide(data[1], 8, 4));
        }
        return data;
    }

    private void calculateOutCost() throws Exception {
        StringBuffer sbSql = new StringBuffer();
        String cols = this.dim.getSelect(null, 1);
        sbSql.append("select KSQL_SEQ,FID,FSourcebillnumber,").append(cols).append(",FOutOrInWareHouse,FBaseQty,FCost,FUnitCost ").append("from ").append(this.mainTempTable).append(" where KSQL_SEQ between ? and ? order by KSQL_SEQ ");
        int fromRow = 1;
        int toRow = 500;
        IRowSet rs = this.pCmd.executeQuery(sbSql.toString(), new Object[]{fromRow, toRow});
        Map dimListMap = null;
        String dimkey2 = null;
        List dimList = null;
        Iterator iter = null;
        try {
            while (rs.size() > 0) {
                dimListMap = this.getDimListMap(rs);
                for (String dimkey2 : dimListMap.keySet()) {
                    dimList = (List)dimListMap.get(dimkey2);
                    this.calculateOutCostByDim(dimkey2, dimList);
                }
                fromRow = toRow + 1;
                rs = this.pCmd.executeQuery(sbSql.toString(), new Object[]{fromRow, toRow += 500});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void calculateOutCostByDim(String dimkey, List dimList) throws Exception {
        if (dimkey == null || dimList == null || dimList.size() == 0) {
            return;
        }
        String reportId = this.calCommon.reportHead(dimkey, true, "");
        BigDecimal[] beginData = this.getBeginData(dimkey);
        this.lastIncomeUnitCost = beginData[2];
        this.reportPeriodStart(dimkey, beginData, reportId);
        BigDecimal[] preData = beginData;
        RecentCostInfo recentCostInfo = null;
        int size = dimList.size();
        for (int i = 0; i < size; ++i) {
            recentCostInfo = (RecentCostInfo)dimList.get(i);
            preData = this.calRowCost(dimkey, recentCostInfo, preData);
            this.reportPeriodDetail(recentCostInfo, preData, reportId);
            if (preData[1].compareTo(BigDecimal.ZERO) >= 0) continue;
            this.updateReportFail(reportId);
            break;
        }
    }

    private void reportPeriodStart(String key, BigDecimal[] beginData, String reportId) throws EASBizException, BOSException {
        StringBuffer sbReport = new StringBuffer();
        String entryId = BOSUuid.create((String)"98AE2674").toString();
        BigDecimal beginQty = beginData[0];
        BigDecimal beginCost = beginData[1];
        if (beginQty == null) {
            beginQty = BigDecimal.ZERO;
        }
        if (beginCost == null) {
            beginCost = BigDecimal.ZERO;
        }
        BigDecimal beginUnitCost = null;
        beginUnitCost = beginQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : beginCost.divide(beginQty, 8, 4);
        String periodStart = EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"periodStart");
        sbReport.append("insert T_CAL_IssueCalRepDetail (").append("FID,FSEQ,FBillNumber,FProfitCenOrgId,FPeriodId,FParentID,FBalance) ").append("values ('").append(entryId).append("',0,'").append(periodStart).append("','").append(this.pCmd.profitCenterOrgId).append("','").append(this.pCmd.periodId).append("','").append(reportId).append("','").append(beginQty.setScale(this.qtyPrecision, 4)).append(" * ").append(beginUnitCost.setScale(this.pricePrecision, 4).toPlainString()).append(" = ").append(beginCost.setScale(this.pCmd.currencyPrecision, 4).toPlainString()).append("')");
        this.pCmd.execute(sbReport.toString());
    }

    private void reportPeriodDetail(RecentCostInfo recentCostInfo, BigDecimal[] data, String reportId) throws EASBizException, BOSException {
        if (!this.pCmd.isReport() || reportId == null) {
            return;
        }
        StringBuffer sbReport = new StringBuffer();
        String entryId = BOSUuid.create((String)"98AE2674").toString();
        BigDecimal endQty = data[0];
        BigDecimal endCost = data[1];
        if (endQty == null) {
            endQty = BigDecimal.ZERO;
        }
        if (endCost == null) {
            endCost = BigDecimal.ZERO;
        }
        BigDecimal endUnitCost = null;
        endUnitCost = endQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : endCost.divide(endQty, 8, 4);
        sbReport.append("insert T_CAL_IssueCalRepDetail (");
        sbReport.append("FID,FSEQ,FBillNumber,FProfitCenOrgId,FPeriodId,FParentID,FBillId,FIncome,FIssue,FBalance) ");
        sbReport.append("values ('").append(entryId).append("',1,'").append(recentCostInfo.getBillNumber()).append("','").append(this.pCmd.profitCenterOrgId).append("','");
        sbReport.append(this.pCmd.periodId).append("','").append(reportId).append("','").append(recentCostInfo.getBillId()).append("',");
        if (recentCostInfo.getOutOrInWareHouse() == 20) {
            sbReport.append(this.getBanlanceDesc(recentCostInfo.getBaseQty(), recentCostInfo.getUnitCost(), recentCostInfo.getCost()));
            sbReport.append(",'',");
        } else {
            sbReport.append("'',");
            sbReport.append(this.getBanlanceDesc(recentCostInfo.getBaseQty(), recentCostInfo.getUnitCost(), recentCostInfo.getCost()));
            sbReport.append(",");
        }
        if (recentCostInfo.isPriceExcep()) {
            String negativeBalance = EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"NegativeBalance");
            sbReport.append("'");
            sbReport.append(negativeBalance);
            sbReport.append("')");
        } else {
            sbReport.append(this.getBanlanceDesc(endQty, endUnitCost, endCost));
            sbReport.append(")");
        }
        this.pCmd.execute(sbReport.toString());
    }

    private String getBanlanceDesc(BigDecimal baseQty, BigDecimal unitCost, BigDecimal cost) {
        StringBuffer banlanceDesc = new StringBuffer();
        banlanceDesc.append("'").append(baseQty.setScale(this.qtyPrecision, 4)).append(" * ");
        banlanceDesc.append(unitCost.setScale(this.pricePrecision, 4).toPlainString()).append(" = ");
        banlanceDesc.append(cost.setScale(this.pCmd.currencyPrecision, 4).toPlainString());
        banlanceDesc.append("'");
        return banlanceDesc.toString();
    }

    private BigDecimal[] calRowCost(String key, RecentCostInfo recentCostInfo, BigDecimal[] preData) throws Exception {
        BigDecimal[] retData = new BigDecimal[3];
        int outOrIn = recentCostInfo.getOutOrInWareHouse();
        BigDecimal baseQty = recentCostInfo.getBaseQty();
        BigDecimal cost = recentCostInfo.getCost();
        String billId = recentCostInfo.getBillId();
        if (outOrIn == 10) {
            BigDecimal unitCost = this.lastIncomeUnitCost;
            cost = baseQty.multiply(unitCost);
            recentCostInfo.setCost(cost);
            recentCostInfo.setUnitCost(unitCost);
            retData[0] = preData[0].subtract(baseQty);
            retData[1] = preData[1].subtract(cost);
            this.updateRowData(unitCost, cost, billId);
        } else {
            retData[0] = preData[0].add(baseQty);
            retData[1] = preData[1].add(cost);
            if (retData[1].compareTo(BigDecimal.ZERO) < 0) {
                recentCostInfo.setPriceExcep(true);
            } else {
                this.lastIncomeUnitCost = retData[0].compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : retData[1].divide(retData[0], 8, 4);
            }
        }
        return retData;
    }

    private Map getDimListMap(IRowSet rs) throws SQLException, Exception {
        HashMap dimListMap = new HashMap();
        ArrayList<RecentCostInfo> dimList = null;
        RecentCostInfo recentCostInfo = null;
        String dimkey = null;
        while (rs.next()) {
            dimkey = this.dim.buildKey(rs, 1);
            dimList = (ArrayList<RecentCostInfo>)dimListMap.get(dimkey);
            if (dimList == null) {
                dimList = new ArrayList<RecentCostInfo>();
                recentCostInfo = this.getRecentCostInfo(rs, dimkey);
                dimList.add(recentCostInfo);
                dimListMap.put(dimkey, dimList);
                continue;
            }
            recentCostInfo = this.getRecentCostInfo(rs, dimkey);
            dimList.add(recentCostInfo);
        }
        return dimListMap;
    }

    private RecentCostInfo getRecentCostInfo(IRowSet rs, String dimkey) throws SQLException {
        RecentCostInfo recentCostInfo = new RecentCostInfo();
        recentCostInfo.setOutOrInWareHouse(rs.getInt("FOutOrInWareHouse"));
        recentCostInfo.setBaseQty(rs.getBigDecimal("FBaseQty"));
        recentCostInfo.setCost(rs.getBigDecimal("FCost"));
        recentCostInfo.setBillId(rs.getString("Fid"));
        recentCostInfo.setBillNumber(rs.getString("FSourcebillnumber"));
        recentCostInfo.setUnitCost(rs.getBigDecimal("FUnitCost"));
        recentCostInfo.setDimkey(dimkey);
        return recentCostInfo;
    }

    private void updateRowData(BigDecimal unitCost, BigDecimal cost, String id) throws SQLException, EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_CAL_InvAccountBill set funitcost = ? ,fcost = ? ");
        sql.append(" where fid  = ?");
        unitCost = unitCost.setScale(this.pricePrecision, 4);
        cost = cost.setScale(this.pCmd.currencyPrecision, 4);
        this.pCmd.execute(sql.toString(), new Object[]{unitCost, cost, id});
    }

    private void updateReportFail(String reportId) throws EASBizException, BOSException {
        if (reportId == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CAL_IssueCalculateReport set FStatus = ? where fid = ?");
        this.pCmd.execute(sql.toString(), new Object[]{20, reportId});
    }
}

