/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.issueCalculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.ws.ca.utils.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;

public class ProfitCenterData {
    private Context ctx;
    private String filter = null;
    private String permission = null;

    public ProfitCenterData(Context ctx, Map params) {
        this.ctx = ctx;
        this.init(params);
    }

    private void init(Map params) {
        this.filter = (String)params.get("filter");
        this.permission = (String)params.get("permission");
    }

    public Map getProfitCenterData() throws BOSException, EASBizException {
        HashMap result = new HashMap();
        LinkedList data = new LinkedList();
        result.put("rows", data);
        String loc = this.ctx.getLocale().toString();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)this.ctx);
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId();
        FullOrgUnitCollection orgs = iPermission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), OrgType.ProfitCenter, null, this.getPermission());
        if (orgs == null || orgs.size() == 0) {
            return result;
        }
        StringBuffer orgFilter = new StringBuffer();
        orgFilter.append("(");
        int length = orgs.size();
        for (int i = 0; i < length; ++i) {
            orgFilter.append("'" + orgs.get(i).getId() + "',");
        }
        orgFilter.deleteCharAt(orgFilter.length() - 1);
        orgFilter.append(")");
        String filter = this.getFilter();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    sc.FID, \n");
        sql.append("    c.FID FOrgID, c.FNumber FOrgNumber, c.FName_" + loc + " FOrgName, \n");
        sql.append("    p.FID FPeriodID, p.FPeriodYear, p.FPeriodNumber FPeriodMonth \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_ORG_ProfitCenter c on c.FID = sc.FProfitCenterID \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("join T_BD_Period p on p.FID = sc.FCurrentPeriodID \n");
        sql.append("where c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
        sql.append(" and sc.fisstart = 1");
        sql.append("    and s.FName =  ").append(1007);
        if (filter != null && !StringUtils.isEmpty((String)filter)) {
            sql.append(" and (").append(filter).append(") ");
        }
        sql.append("    and c.FID in " + orgFilter + " \n");
        sql.append("\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String id = rowSet.getString("FID");
                String orgId = rowSet.getString("FOrgID");
                String orgName = rowSet.getString("FOrgName");
                String orgNumber = rowSet.getString("FOrgNumber");
                String periodId = rowSet.getString("FPeriodID");
                String periodMonth = rowSet.getString("FPeriodMonth");
                String periodYear = rowSet.getString("FPeriodYear");
                if (periodMonth != null && periodMonth.toString().length() == 1) {
                    periodMonth = "0" + periodMonth;
                }
                String periodName = this.getStrResource("periodName", new String[]{periodYear, periodMonth});
                map.put("id", id);
                map.put("orgId", orgId);
                map.put("orgName", orgName);
                map.put("orgNumber", orgNumber);
                map.put("periodId", periodId);
                map.put("periodName", periodName);
                data.add(map);
            }
            result.put("rows", data);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private String getStrResource(String resKey, String[] params) {
        String s = this.getStrResource(resKey);
        MessageFormat mf = new MessageFormat(s);
        String result = mf.format(params);
        return result;
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)resKey, (Locale)this.ctx.getOriginLocale());
    }

    public String getPermission() {
        return this.permission;
    }

    public String getFilter() {
        return this.filter;
    }
}

