/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.transferbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.BillTransferConstant;
import com.kingdee.eas.ma.cal.BillTransferFacadeFactory;
import com.kingdee.eas.ma.cal.app.transferbill.TransferRuleSqlBuilder;
import java.util.HashMap;
import java.util.Map;

public class TransferBillSQLBuilder {
    private StringBuffer insertSql = new StringBuffer();
    private StringBuffer selectSql = new StringBuffer();
    private StringBuffer wheresql = new StringBuffer();
    private StringBuffer fromsql = new StringBuffer();
    private Context ctx = null;
    private TransferRuleSqlBuilder sqlBuilder = null;
    private String sourcebilltypeid = null;
    private String profitCenterid = null;
    private String cuid = null;
    private String baseCurrencyID = null;
    private String storageOrgIds = null;
    private String beginDate = null;
    private String endDate = null;
    private String periodID = null;
    private String billId = null;
    private String transferType = null;

    public TransferBillSQLBuilder(Context ctx, Map<String, Object> sqlBuilderParams) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.sqlBuilder = (TransferRuleSqlBuilder)sqlBuilderParams.get("ruleSql");
        this.sourcebilltypeid = (String)sqlBuilderParams.get("sourcebilltypeid");
        this.profitCenterid = (String)sqlBuilderParams.get("profitCenterid");
        this.cuid = (String)sqlBuilderParams.get("cuid");
        this.baseCurrencyID = (String)sqlBuilderParams.get("baseCurrencyID");
        this.storageOrgIds = (String)sqlBuilderParams.get("storageOrgIds");
        this.beginDate = (String)sqlBuilderParams.get("beginData");
        this.endDate = (String)sqlBuilderParams.get("endData");
        this.periodID = (String)sqlBuilderParams.get("periodID");
        this.billId = (String)sqlBuilderParams.get("billId");
        this.transferType = (String)sqlBuilderParams.get("transferType");
        this.init();
    }

    private void init() throws EASBizException, BOSException {
        String creatorId = this.ctx.getCaller().toString();
        this.insertSql.append(this.sqlBuilder.getInsertsql()).append(" fid,fcreatetime,FCreatorID,FCreateType,FCurrencyID ");
        this.insertSql.append(" ,FProfitCenterID,FControlUnitID,FPeriodID ");
        this.selectSql.append(this.sqlBuilder.getSelectsql());
        this.selectSql.append(" newbosid('FF6F42C5') as fid , now() as fcreatetime,'").append(creatorId).append("' as fcreatorid, 20 as FCreateType ");
        this.selectSql.append(",'").append(this.baseCurrencyID).append("' ,'").append(this.profitCenterid).append("','").append(this.cuid).append("' ");
        this.selectSql.append(",'").append(this.periodID).append("' as FPeriodID  ");
        this.fromsql.append(this.sqlBuilder.getFromsql());
        if (BillTransferConstant.BILLTYPE_BOSTYPE_MAP.containsKey(this.sourcebilltypeid)) {
            String sameProfitFilter;
            this.wheresql.append(" bill.fbaseStatus in (4,90").append(")");
            this.wheresql.append(" and bill.FStorageOrgUnitID in (").append(this.storageOrgIds).append(")");
            this.wheresql.append(" and bill.fbizDate >= to_date('").append(this.beginDate).append("')");
            this.wheresql.append(" and bill.fbizDate < to_date('").append(this.endDate).append("')");
            if (this.sqlBuilder.getWheresql() != null) {
                this.wheresql.append(this.sqlBuilder.getWheresql());
            }
            if ((sameProfitFilter = this.sameProfitFilter()) != null) {
                this.wheresql.append(sameProfitFilter);
            }
        }
    }

    private String sameProfitFilter() {
        if (!BillTransferConstant.SAMEPROFIT_BILLTYPE_LIST.contains(this.sourcebilltypeid)) {
            return null;
        }
        String souField = null;
        if ("50957179-0105-1000-e000-016ec0a812fd463ED552".equals(this.sourcebilltypeid)) {
            souField = "freceiptStorageOrgUnitid";
        } else if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(this.sourcebilltypeid)) {
            souField = "fsupplyStoreOrgUnitid";
        } else if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(this.sourcebilltypeid)) {
            souField = "fissueStorageOrgUnitid";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" and bill.fid not in (select tn.fid from ").append(this.sqlBuilder.getTableName()).append(" as tn");
        sql.append(" inner join T_ORG_UnitRelation unitRelation1 on tn.").append(souField).append("= unitRelation1.FFromUnitID");
        sql.append(" inner join T_ORG_UnitRelation unitRelation2 on tn.FStorageOrgUnitID = unitRelation2.FFromUnitID");
        sql.append(" inner join T_ORG_TypeRelation typeRelation on unitRelation1.FTypeRelationID =typeRelation.fid and unitRelation2.FTypeRelationID = typeRelation.fid");
        sql.append(" where typeRelation.ffromType = ").append(4);
        sql.append("  and typeRelation.ftoType = ").append(6);
        sql.append("  and unitRelation1.ftoUnitId = unitRelation2.ftounitId ");
        sql.append("  and unitRelation1.ftoUnitId = '").append(this.profitCenterid).append("'");
        sql.append("  and bill.fid = tn.fid )");
        return sql.toString();
    }

    public String getImportIssueBillSQL() throws EASBizException, BOSException {
        Map map = this.setImportIssueBillSQL(this.transferType);
        StringBuffer sql = this.buildSQL(map);
        return sql.toString();
    }

    private Map setImportIssueBillSQL(String transferType) throws BOSException, EASBizException {
        StringBuffer wheresql = new StringBuffer(this.wheresql.toString());
        StringBuffer fromsql = new StringBuffer(this.fromsql.toString());
        StringBuffer insertSql = new StringBuffer(this.insertSql.toString()).append(",FOutOrInWareHouse ");
        StringBuffer selectSql = new StringBuffer(this.selectSql.toString()).append(" ,  10");
        if ("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(this.sourcebilltypeid)) {
            insertSql.append(",FSourceCreateType,FStoreTypeID ");
            selectSql.append(" , bill.FCreateType,entry.FStoreTypeID ");
            wheresql.append(" and bill.FCalculateKind = 1 ");
        } else if (BillTransferConstant.OUT_BILLTYPE_LIST.contains(this.sourcebilltypeid) || BillTransferConstant.IN_BILLTYPE_LIST.contains(this.sourcebilltypeid)) {
            insertSql.append(",FStoreTypeID ");
            selectSql.append(" ,storeType.fid ");
            fromsql.append(" left join T_SCM_TransactionType as transactionType on transactionType.fid = bill.FTransactionTypeID");
            fromsql.append(" left join T_IM_RecIssueType as recIssueType on recIssueType.fid = transactionType.FRITypeID");
            wheresql.append(" and ((recIssueType.FRI= -1  and recIssueType.FBizDirection = 1 )");
            if (this.sqlBuilder.getRuleInfo().getReturnBizDirection() != null && this.sqlBuilder.getRuleInfo().getReturnBizDirection().getValue() == -1) {
                wheresql.append(" or (recIssueType.FRI=  1 and recIssueType.FBizDirection= -1 ))");
            } else {
                wheresql.append(" or (recIssueType.FRI= -1 and recIssueType.FBizDirection= -1 ))");
            }
            fromsql.append(" left join T_IM_InvUpdateType as invUpdateType on invUpdateType.fid = entry.FInvUpdateTypeID ");
            if (BillTransferConstant.OUT_BILLTYPE_LIST.contains(this.sourcebilltypeid)) {
                fromsql.append(" left join T_IM_STORETYPE as storeType on storeType.fid = invUpdateType.FStoreTypePreID ");
                wheresql.append("  and ( (invUpdateType.FExistingQtyPre = 1  and storeType.FIsForwardAmt = 1 ) ");
                wheresql.append(" or invUpdateType.FIsNotUpdateInv =1  )");
            } else if (BillTransferConstant.IN_BILLTYPE_LIST.contains(this.sourcebilltypeid)) {
                fromsql.append(" left join T_IM_STORETYPE as storeType on storeType.fid = invUpdateType.FStoreTypeID ");
                wheresql.append("  and ( (invUpdateType.fexistingQty = 1  and storeType.FIsForwardAmt = 1 ) ");
                wheresql.append(" or invUpdateType.FIsNotUpdateInv =1  )");
            } else {
                wheresql.append(")");
            }
        }
        if ("bill".equals(transferType) && this.billId != null) {
            wheresql.append(" and bill.fid ='").append(this.billId).append("'");
        }
        wheresql.append(" and ( ").append(this.sqlBuilder.getEntryAliasName()).append(".FIsGenCalFlag = 0");
        wheresql.append(" or ").append(this.sqlBuilder.getEntryAliasName()).append(".FIsGenCalFlag is null )");
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        sqlMap.put("insertSql", insertSql.toString());
        sqlMap.put("selectSql", selectSql.toString());
        sqlMap.put("fromsql", fromsql.toString());
        sqlMap.put("wheresql", wheresql.toString());
        sqlMap.put("sourcebilltypeid", this.sourcebilltypeid);
        sqlMap.put("profitCenterid", this.profitCenterid);
        sqlMap.put("type", "issueBill");
        Map map = BillTransferFacadeFactory.getLocalInstance(this.ctx).extendQuery(sqlMap);
        return map;
    }

    public String getImportInWarehsBillSQL() throws EASBizException, BOSException {
        Map map = this.setImportInWarehsBillSQL(this.transferType);
        StringBuffer sql = this.buildSQL(map);
        return sql.toString();
    }

    private Map setImportInWarehsBillSQL(String transferType) throws BOSException, EASBizException {
        StringBuffer wheresql = new StringBuffer(this.wheresql.toString());
        StringBuffer fromsql = new StringBuffer(this.fromsql.toString());
        StringBuffer insertSql = new StringBuffer(this.insertSql.toString()).append(",FOutOrInWareHouse ");
        StringBuffer selectSql = new StringBuffer(this.selectSql.toString()).append(" ,  20");
        if ("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(this.sourcebilltypeid)) {
            insertSql.append(",FSourceCreateType,FStoreTypeID ");
            selectSql.append(" , bill.FCreateType,entry.FStoreTypeID ");
            wheresql.append(" and bill.FCalculateKind = 0 ");
        } else if (BillTransferConstant.IN_BILLTYPE_LIST.contains(this.sourcebilltypeid) || BillTransferConstant.OUT_BILLTYPE_LIST.contains(this.sourcebilltypeid)) {
            insertSql.append(",FStoreTypeID ");
            selectSql.append(" ,storeType.fid ");
            fromsql.append(" left join T_SCM_TransactionType as transactionType on transactionType.fid = bill.FTransactionTypeID");
            fromsql.append(" left join T_IM_RecIssueType as recIssueType on recIssueType.fid = transactionType.FRITypeID");
            wheresql.append(" and ((recIssueType.FRI= 1  and recIssueType.FBizDirection = 1 )");
            if (this.sqlBuilder.getRuleInfo().getReturnBizDirection() != null && this.sqlBuilder.getRuleInfo().getReturnBizDirection().getValue() == -1) {
                wheresql.append(" or (recIssueType.FRI= -1 and recIssueType.FBizDirection= -1 ))");
            } else {
                wheresql.append(" or (recIssueType.FRI= 1 and recIssueType.FBizDirection= -1 ))");
            }
            fromsql.append(" left join T_IM_InvUpdateType as invUpdateType on invUpdateType.fid = entry.FInvUpdateTypeID ");
            if (BillTransferConstant.OUT_BILLTYPE_LIST.contains(this.sourcebilltypeid)) {
                fromsql.append(" left join T_IM_STORETYPE as storeType on storeType.fid = invUpdateType.FStoreTypePreID ");
                wheresql.append("  and ( (invUpdateType.FExistingQtyPre = 1  and storeType.FIsForwardAmt = 1 ) ");
                wheresql.append(" or invUpdateType.FIsNotUpdateInv =1  )");
            } else if (BillTransferConstant.IN_BILLTYPE_LIST.contains(this.sourcebilltypeid)) {
                fromsql.append(" left join T_IM_STORETYPE as storeType on storeType.fid = invUpdateType.FStoreTypeID ");
                wheresql.append("  and ( (invUpdateType.fexistingQty = 1  and storeType.FIsForwardAmt = 1 ) ");
                wheresql.append(" or invUpdateType.FIsNotUpdateInv =1  )");
            } else {
                wheresql.append(")");
            }
        }
        if ("bill".equals(transferType) && this.billId != null) {
            wheresql.append(" and bill.fid ='").append(this.billId).append("'");
        }
        wheresql.append(" and (").append(this.sqlBuilder.getEntryAliasName()).append(".FIsGenCalFlag = 0");
        wheresql.append(" or ").append(this.sqlBuilder.getEntryAliasName()).append(".FIsGenCalFlag is null )");
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        sqlMap.put("insertSql", insertSql.toString());
        sqlMap.put("selectSql", selectSql.toString());
        sqlMap.put("fromsql", fromsql.toString());
        sqlMap.put("wheresql", wheresql.toString());
        sqlMap.put("sourcebilltypeid", this.sourcebilltypeid);
        sqlMap.put("profitCenterid", this.profitCenterid);
        sqlMap.put("type", "inWarehsBill");
        Map map = BillTransferFacadeFactory.getLocalInstance(this.ctx).extendQuery(sqlMap);
        return map;
    }

    private StringBuffer buildSQL(Map map) {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_CAL_InvAccountBill (").append(map.get("insertSql")).append(")");
        sql.append("( select ").append(map.get("selectSql"));
        sql.append(" from ").append(map.get("fromsql"));
        sql.append(" where ").append(map.get("wheresql")).append(" )");
        return sql;
    }

    public String getDeleteNotIncludeSQL() throws EASBizException, BOSException {
        Map map = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_CAL_InvAccountBill invbill where FProfitCenterID = ? and FSourceBillTypeID = ? ");
        sql.append(" and fbizDate >= to_date(?) and fbizDate < to_date(?) and FFiVouchered = 0");
        map = this.setImportIssueBillSQL("remove");
        sql.append(" and not exists( ");
        sql.append(" select 1 ");
        sql.append(" from ").append(map.get("fromsql"));
        sql.append(" where ").append(map.get("wheresql"));
        sql.append(" and invbill.FSourceBillId = bill.fid");
        sql.append(" )");
        map = this.setImportInWarehsBillSQL("remove");
        sql.append(" and not exists( ");
        sql.append(" select 1 ");
        sql.append(" from ").append(map.get("fromsql"));
        sql.append(" where ").append(map.get("wheresql"));
        sql.append(" and invbill.FSourceBillId = bill.fid");
        sql.append(" )");
        return sql.toString();
    }

    public String getDeleteIncludeSQL() throws EASBizException, BOSException {
        Map map = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_CAL_InvAccountBill invbill where FProfitCenterID = ? and FSourceBillTypeID = ? ");
        sql.append(" and fbizDate >= to_date(?) and fbizDate < to_date(?) and FFiVouchered = 0");
        map = this.setImportIssueBillSQL("increment");
        sql.append(" and ( exists( ");
        sql.append(" select 1 ");
        sql.append(" from ").append(map.get("fromsql"));
        sql.append(" where ").append(map.get("wheresql"));
        sql.append(" and invbill.FSourceBillId = bill.fid");
        sql.append(" )");
        map = this.setImportInWarehsBillSQL("increment");
        sql.append(" or  exists( ");
        sql.append(" select 1 ");
        sql.append(" from ").append(map.get("fromsql"));
        sql.append(" where ").append(map.get("wheresql"));
        sql.append(" and invbill.FSourceBillId = bill.fid");
        sql.append(" ) )");
        return sql.toString();
    }

    public String getUpdateCostSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update  T_CAL_InvAccountBill invbill set (").append(this.sqlBuilder.getUpdateColumn()).append(") = (");
        sql.append(" select ").append(this.sqlBuilder.getUpdateSelectColumn()).append(" from T_CAL_InvAccountBill inv");
        sql.append(" inner join ").append(this.sqlBuilder.getEntryTableName()).append(" ").append(this.sqlBuilder.getEntryAliasName()).append(" on inv.FSourceBillEntryID = ").append(this.sqlBuilder.getEntryAliasName()).append(".fid");
        sql.append(" where invbill.fid = inv.fid ");
        sql.append(" )");
        sql.append(" where invbill.FProfitCenterID = ? and invbill.FSourceBillTypeID = ? and invbill.fbizDate >= to_date(?) and invbill.fbizDate < to_date(?) and invbill.FFiVouchered = 0");
        return sql.toString();
    }

    public String getUpdateFlagSQL() throws EASBizException, BOSException {
        Map map = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" update  ").append(this.sqlBuilder.getEntryTableName()).append(" T set FIsGenCalFlag = 1");
        map = this.setImportIssueBillSQL("increment");
        sql.append(" where exists( ");
        sql.append(" select 1 ");
        sql.append(" from ").append(map.get("fromsql"));
        sql.append(" where ").append(map.get("wheresql"));
        sql.append(" and T.FID =").append(this.sqlBuilder.getEntryAliasName()).append(".fid");
        sql.append(" )");
        map = this.setImportInWarehsBillSQL("increment");
        sql.append(" or  exists( ");
        sql.append(" select 1 ");
        sql.append(" from ").append(map.get("fromsql"));
        sql.append(" where ").append(map.get("wheresql"));
        sql.append(" and T.FID = ").append(this.sqlBuilder.getEntryAliasName()).append(".fid");
        sql.append(" ) ");
        return sql.toString();
    }

    public String getDeleteSQL() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_CAL_InvAccountBill where FProfitCenterID = ? and  FSourceBillTypeID = ?");
        sql.append(" and fbizDate >= to_date(?) and fbizDate < to_date(?);");
        return sql.toString();
    }
}

