/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.BillTransferConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CalUtils {
    public static SelectorItemCollection getProfitCenterSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("isGrouping"));
        sic.add(new SelectorItemInfo("isGroup"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("isSealUp"));
        sic.add(new SelectorItemInfo("isCompanyOrgUnit"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("isAssistantOrg"));
        sic.add(new SelectorItemInfo("mainOrg.id"));
        sic.add(new SelectorItemInfo("mainOrg.name"));
        sic.add(new SelectorItemInfo("mainOrg.number"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.name"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.number"));
        sic.add(new SelectorItemInfo("accountScheme.id"));
        sic.add(new SelectorItemInfo("accountScheme.name"));
        sic.add(new SelectorItemInfo("accountScheme.number"));
        sic.add(new SelectorItemInfo("SimpleName"));
        sic.add(new SelectorItemInfo("orgTypeStr"));
        return sic;
    }

    public static SelectorItemCollection getCompanySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("isGrouping"));
        sic.add(new SelectorItemInfo("isGroup"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("isSealUp"));
        sic.add(new SelectorItemInfo("isCompanyOrgUnit"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("isAssistantOrg"));
        sic.add(new SelectorItemInfo("mainOrg.id"));
        sic.add(new SelectorItemInfo("mainOrg.name"));
        sic.add(new SelectorItemInfo("mainOrg.number"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.name"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.number"));
        sic.add(new SelectorItemInfo("accountScheme.id"));
        sic.add(new SelectorItemInfo("accountScheme.name"));
        sic.add(new SelectorItemInfo("accountScheme.number"));
        sic.add(new SelectorItemInfo("SimpleName"));
        sic.add(new SelectorItemInfo("orgTypeStr"));
        return sic;
    }

    public static String getRelatedCompanyId(Context ctx, String profitCenterId) throws BOSException {
        if (profitCenterId == null || profitCenterId.length() <= 0) {
            return "";
        }
        HashSet<String> idSet = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        idSet.add(profitCenterId);
        Set<String> companyIds = CalUtils.getRelatedCompanyIds(ctx, idSet);
        Object companyId = null;
        Iterator<String> it = companyIds.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return "";
    }

    public static Set<String> getRelatedCompanyIds(Context ctx, Set<String> profitCenterIds) throws BOSException {
        if (profitCenterIds == null || profitCenterIds.size() <= 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select rel.ftounitid  fcompanyid from T_ORG_UnitRelation rel ");
        sql.append(" inner join t_org_typerelation typeRel on typeRel.fid = rel.ftyperelationid ");
        sql.append(" and rel.ffromunitid in (").append(CalUtils.getSqlIDs(profitCenterIds)).append(")");
        sql.append(" and typeRel.ftotype = ").append(1);
        sql.append(" and typeRel.ffromtype = ").append(6);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String companyID = rs.getString("fcompanyid");
                set.add(companyID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return set;
    }

    public static String getSqlIDs(String[] pks) {
        StringBuilder sb = new StringBuilder();
        if (pks == null || "".equals(pks)) {
            return "";
        }
        for (String pk : pks) {
            if (sb.length() > 0) {
                sb.append(",'").append(pk).append("'");
                continue;
            }
            sb.append("'").append(pk).append("'");
        }
        return sb.toString();
    }

    public static String getSqlID(String pk) {
        return "'" + pk + "'";
    }

    public static String getSqlIDs(Set<String> idSet) {
        StringBuilder sb = new StringBuilder();
        if (idSet == null || idSet.size() == 0) {
            return "";
        }
        for (String pk : idSet) {
            if (sb.length() > 0) {
                sb.append(",'").append(pk).append("'");
                continue;
            }
            sb.append("'").append(pk).append("'");
        }
        return sb.toString();
    }

    public static String getSqlIDs(List coll) {
        StringBuilder sb = new StringBuilder();
        if (coll == null || coll.size() == 0) {
            return null;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(",'").append(((Map)coll.get(i)).get("id").toString()).append("'");
                continue;
            }
            sb.append("'").append(((Map)coll.get(i)).get("id").toString()).append("'");
        }
        return sb.toString();
    }

    public static String arrayToString(Object[] ids) {
        StringBuffer idstring = new StringBuffer();
        idstring.append("'");
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            idstring.append(ids[i].toString()).append("','");
        }
        idstring.append("'");
        return idstring.toString();
    }

    public static Date getDate(Date oldDate, int day) throws BOSException, EASBizException {
        Date date = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(oldDate);
        cal.add(5, day);
        date = cal.getTime();
        return date;
    }

    public static Map<String, PeriodInfo> getPeriod(Context ctx, String[] orgids, int systemEnum) throws BOSException, EASBizException {
        String profitCenterid2 = null;
        PeriodInfo periodInfo = null;
        HashMap<String, PeriodInfo> periodMap = new HashMap<String, PeriodInfo>();
        ISystemStatusCtrol iSystemStatusCtrol = null;
        iSystemStatusCtrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        for (String profitCenterid2 : orgids) {
            if (StringUtils.isEmpty((String)profitCenterid2)) continue;
            periodInfo = iSystemStatusCtrol.getProfitCurrentPeriod(systemEnum, profitCenterid2);
            periodMap.put(profitCenterid2, periodInfo);
        }
        return periodMap;
    }

    public static PeriodInfo getPeriod(Context ctx, String periodTypeId, int year, int period) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)year, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)period, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodTypeId, CompareType.EQUALS));
        view.setFilter(filter);
        PeriodCollection periodColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
        if (periodColl != null && periodColl.size() > 0) {
            return periodColl.get(0);
        }
        return null;
    }

    public static Map getStorageOrgUnits(Context ctx, String[] profitCenterids) throws EASBizException, BOSException {
        HashMap storageOrgUnitsMap = new HashMap();
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = null;
        String orgid2 = null;
        for (String orgid2 : profitCenterids) {
            orgCol = iUnitRel.getFromUnit(orgid2, 6, 4);
            HashSet<String> orgidSet = new HashSet<String>();
            int size = orgCol.size();
            for (int i = 0; i < size; ++i) {
                orgidSet.add(orgCol.get(i).getId().toString());
            }
            storageOrgUnitsMap.put(orgid2, orgidSet);
        }
        return storageOrgUnitsMap;
    }

    public static Map getProfitCenterids(Context ctx, String[] storageOrgUnitids) throws EASBizException, BOSException {
        HashMap<String, String> profitCenteridsMap = new HashMap<String, String>();
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = null;
        String orgid2 = null;
        for (String orgid2 : storageOrgUnitids) {
            orgCol = iUnitRel.getToUnit(orgid2, 4, 6);
            String profitCenterid = null;
            if (orgCol.size() <= 0) continue;
            profitCenterid = orgCol.get(0).getId().toString();
            profitCenteridsMap.put(orgid2, profitCenterid);
        }
        return profitCenteridsMap;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, String orgid, int orgType) throws EASBizException, BOSException {
        if (orgid == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(orgid, orgType, 1);
        if (orgCol.size() > 0) {
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgCol.get(0).getId()));
            return companyOrgUnitInfo;
        }
        return null;
    }

    public static String getCUID(Context ctx, ProfitCenterOrgUnitInfo profitCenter) throws EASBizException, BOSException {
        if (profitCenter.getParent() == null) {
            profitCenter = CalUtils.getProfitCenter(ctx, profitCenter.getId().toString(), new String[]{"id", "parent", "isCU"});
        }
        ProfitCenterOrgUnitInfo parentOrg = profitCenter.getParent();
        parentOrg = CalUtils.getProfitCenter(ctx, parentOrg.getId().toString(), new String[]{"id", "parent", "isCU"});
        while (!parentOrg.isIsCU()) {
            parentOrg = parentOrg.getParent();
            parentOrg = CalUtils.getProfitCenter(ctx, parentOrg.getId().toString(), new String[]{"id", "parent", "isCU"});
        }
        return parentOrg.getId().toString();
    }

    public static ProfitCenterOrgUnitInfo getProfitCenter(Context ctx, String id, String[] fields) throws EASBizException, BOSException {
        ProfitCenterOrgUnitInfo info = null;
        if (id != null && id.length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            for (String field : fields) {
                sic.add(new SelectorItemInfo(field));
            }
            IProfitCenterOrgUnit iProfitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            info = iProfitCenter.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        return info;
    }

    public static String getEntityQueryPK(Context ctx, String bosType) throws BOSException {
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String queryPK = null;
        EntityObjectInfo srcEntityInfo = loader.getEntity(BOSObjectType.create((String)bosType));
        queryPK = srcEntityInfo.getExtendedProperty("defaultF7Query") == null ? BillTransferConstant.QUERYPK_BOSTYPE_MAP.get(bosType) : srcEntityInfo.getExtendedProperty("defaultF7Query");
        return queryPK;
    }

    public static Boolean isNull(String fieldValue) {
        if (fieldValue == null || fieldValue.equals("null") || fieldValue.equals("")) {
            return true;
        }
        return false;
    }

    public static String structureFilter(Context ctx, String filterItems, String queryPK) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        if (filterItems != null && filterItems.length() > 0) {
            try {
                view.setFilter(new FilterInfo(filterItems));
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        exec.setObjectView(view);
        String sql = exec.getSQL();
        return sql;
    }

    public static OrgUnitCollection getPermissionOrgList(Context ctx, OrgType orgType, String permItem) throws BOSException, EASBizException {
        IPermission iPerm = null;
        iPerm = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg(ctx.getCaller(), orgType, null, permItem);
        OrgUnitCollection orgColl = new OrgUnitCollection();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < fullCompanyColl.size(); ++i) {
            idSet.add(fullCompanyColl.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Boolean(false), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isOUSealup", (Object)new Boolean(false), CompareType.EQUALS));
        }
        view.setFilter(filter);
        orgColl = CalUtils.getOrgUnitCollForOrgType(ctx, orgType, view);
        return orgColl;
    }

    private static OrgUnitCollection getOrgUnitCollForOrgType(Context ctx, OrgType orgType, EntityViewInfo view) throws BOSException, EASBizException {
        OrgUnitCollection orgUnitColl = new OrgUnitCollection();
        switch (orgType.getValue()) {
            case 0: {
                IAdminOrgUnit iAdmin = null;
                iAdmin = ctx == null ? AdminOrgUnitFactory.getRemoteInstance() : AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
            case 1: {
                ICompanyOrgUnit iCompany = null;
                iCompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
            case 2: {
                ISaleOrgUnit iSale = null;
                iSale = ctx == null ? SaleOrgUnitFactory.getRemoteInstance() : SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
            case 3: {
                IPurchaseOrgUnit iPurchase = null;
                iPurchase = ctx == null ? PurchaseOrgUnitFactory.getRemoteInstance() : PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
            case 4: {
                IStorageOrgUnit iStorage = null;
                iStorage = ctx == null ? StorageOrgUnitFactory.getRemoteInstance() : StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
            case 24: {
                ITransportOrgUnit iTransport = null;
                iTransport = ctx == null ? TransportOrgUnitFactory.getRemoteInstance() : TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
            case 6: {
                IProfitCenterOrgUnit iProfitCenter = null;
                iProfitCenter = ctx == null ? ProfitCenterOrgUnitFactory.getRemoteInstance() : ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
                ProfitCenterOrgUnitCollection collection = iProfitCenter.getProfitCenterOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
        }
        return null;
    }
}

