/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgLocaleHelper;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlIsomerCollection;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionFactory;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionInfo;
import com.kingdee.eas.ma.control.BgControlIsomerException;
import com.kingdee.eas.ma.control.BgControlIsomerFactory;
import com.kingdee.eas.ma.control.app.AbstractBgControlIsomerConnectionControllerBean;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BgControlIsomerConnectionControllerBean
extends AbstractBgControlIsomerConnectionControllerBean {
    private static final long serialVersionUID = -935514449439190919L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.BgControlIsomerConnectionControllerBean");

    @Override
    protected boolean _canModifyConnection(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            BgControlIsomerConnectionInfo connInfo = (BgControlIsomerConnectionInfo)model;
            IObjectPK pk = CommonUtil.convert2PK((String)connInfo.getId().toString());
            String actionModify = ResourceBase.getString((String)"com.kingdee.eas.ma.control.BgCtrlIsomerResource", (String)"update", (Locale)ctx.getLocale());
            boolean hasBeanUsed = this.checkRelation(ctx, pk, actionModify);
            return !hasBeanUsed;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)("EIP:Check Connection Modify error:" + ex.getMessage()));
            return false;
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk;
        boolean isModify = false;
        BgControlIsomerConnectionInfo oldInfo = null;
        BgControlIsomerConnectionInfo connInfo = (BgControlIsomerConnectionInfo)model;
        if (model.get("id") != null) {
            isModify = true;
            this.checkCanModify(ctx, model);
            pk = CommonUtil.convert2PK((String)connInfo.getId().toString());
            oldInfo = this.getBgControlIsomerConnectionInfo(ctx, pk);
        }
        pk = super._submit(ctx, model);
        this.updateBgControlData(ctx, connInfo);
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBgControlData(Context ctx, BgControlIsomerConnectionInfo info) throws BOSException, EASBizException {
        Connection conn = null;
        String name = "";
        for (int i = 0; i < BgLocaleHelper.locales.length; ++i) {
            name = "FBizSystemAlias_" + BgLocaleHelper.locales[i].getLanguage() + " = '" + info.getName(BgLocaleHelper.locales[i]) + "' ," + name;
        }
        name = name.substring(0, name.length() - 1);
        String bizFieldSql = "UPDATE T_MBG_BGCONTROLDATA set " + name + " where FBizSystem = '" + info.getId() + "' and FISOMER = 1 ";
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            BgDBUtils.executeUpdate((Connection)conn, (String)bizFieldSql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void checkCanModify(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        BgControlIsomerConnectionInfo connInfo = (BgControlIsomerConnectionInfo)model;
        IObjectPK pk = CommonUtil.convert2PK((String)connInfo.getId().toString());
        String actionModify = ResourceBase.getString((String)"com.kingdee.eas.ma.control.BgCtrlIsomerResource", (String)"update", (Locale)ctx.getLocale());
        boolean hasBeanUsed = this.checkRelation(ctx, pk, actionModify);
        if (hasBeanUsed) {
            BgControlIsomerConnectionInfo savedInfo = BgControlIsomerConnectionFactory.getLocalInstance(ctx).getBgControlIsomerConnectionInfo((IObjectPK)new ObjectUuidPK(connInfo.getId()));
            if (!StringUtils.equals((String)connInfo.getIP(), (String)savedInfo.getIP()) || connInfo.getPort() != savedInfo.getPort() || !StringUtils.equals((String)connInfo.getInstance(), (String)savedInfo.getInstance())) {
                throw new BOSException(EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"connectIsUsed", (Object[])new Object[]{connInfo.getNumber()}));
            }
        }
    }

    private boolean checkRelation(Context ctx, IObjectPK pk, String actionType) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo baseFilter = new FilterInfo();
        baseFilter.getFilterItems().add(new FilterItemInfo("connection.id", (Object)pk.toString(), CompareType.EQUALS));
        view.setFilter(baseFilter);
        BgControlIsomerCollection coll = BgControlIsomerFactory.getLocalInstance(ctx).getBgControlIsomerCollection(view);
        return !coll.isEmpty();
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String actionDelete = ResourceBase.getString((String)"com.kingdee.eas.ma.control.BgCtrlIsomerResource", (String)"delete", (Locale)ctx.getLocale());
        if (this.checkRelation(ctx, pk, actionDelete)) {
            throw new BgControlException(BgControlIsomerException.CONNECTEXIST);
        }
        super.delete(ctx, pk);
    }
}

