/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlItemMapEntryCollection;
import com.kingdee.eas.ma.control.BgControlItemMapEntryInfo;
import com.kingdee.eas.ma.control.BgControlItemMapInfo;
import com.kingdee.eas.ma.control.app.AbstractBgControlItemMapControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class BgControlItemMapControllerBean
extends AbstractBgControlItemMapControllerBean {
    private static final long serialVersionUID = -2323624218906095545L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.BgControlItemMapControllerBean");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateBatchData(Context ctx, BOSUuid bgControlSchemeId, IObjectCollection bizItemMap) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        long beginTime;
        block10: {
            if (ctx == null || bgControlSchemeId == null || bizItemMap == null || bizItemMap.isEmpty()) {
                return;
            }
            beginTime = System.currentTimeMillis();
            logger.debug((Object)"invoke begin update Control bizItems!");
            int batchIndex = 0;
            String tmpTableName = null;
            String _bgControlSchemeId = bgControlSchemeId.toString();
            String _itemMapId = null;
            BgControlItemMapInfo itemMap = null;
            BgControlItemMapEntryInfo bizItem = null;
            BgControlItemMapEntryCollection bizItems = null;
            conn = null;
            pstmt = null;
            TempTablePool pool = null;
            try {
                conn = this.getConnection(ctx);
                BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgControlItemMapEntry where FMapID IN (select FID from T_MBG_BgControlItemMap where FControlSchemeID = ?)", (Object[])new Object[]{_bgControlSchemeId});
                BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgControlItemMap where FControlSchemeID = ?", (Object[])new Object[]{_bgControlSchemeId});
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTableName = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44) DEFAULT '' NOT NULL, FMapID VARCHAR(44) DEFAULT '' NOT NULL, FBizItemValue NVARCHAR(256) DEFAULT '' NOT NULL, FBizItemAlias NVARCHAR(256), FMbgItemValue NVARCHAR(256) DEFAULT '' NOT NULL, FMbgItemAlias NVARCHAR(256), FIsMatching INT DEFAULT 0 NOT NULL)");
                pstmt = conn.prepareStatement("Insert Into " + tmpTableName + " (FID,FMapID,FBizItemValue,FBizItemAlias,FMbgItemValue,FMbgItemAlias,FIsMatching) values (?,?,?,?,?,?,?)");
                int in = bizItemMap.size();
                for (int i = 0; i < in; ++i) {
                    itemMap = (BgControlItemMapInfo)bizItemMap.getObject(i);
                    if (itemMap.getEntry() == null || itemMap.getEntry().isEmpty()) continue;
                    if (itemMap.getId() == null) {
                        itemMap.setId(BOSUuid.create((BOSObjectType)itemMap.getBOSType()));
                    }
                    _itemMapId = itemMap.getId().toString();
                    BgDBUtils.executeUpdate((Connection)conn, (String)"Insert Into T_MBG_BgControlItemMap (FID, FControlSchemeID, FBizProp, FDimensionGroup) values (?,?,?,?)", (Object[])new Object[]{_itemMapId, _bgControlSchemeId, itemMap.getBizProp(), itemMap.getDimensionGroup()});
                    bizItems = itemMap.getEntry();
                    int jn = bizItems.size();
                    for (int j = 0; j < jn; ++j) {
                        bizItem = bizItems.get(j);
                        if (bizItem.getId() == null) {
                            bizItem.setId(BOSUuid.create((BOSObjectType)bizItem.getBOSType()));
                        }
                        pstmt.setString(1, bizItem.getId().toString());
                        pstmt.setString(2, _itemMapId);
                        pstmt.setString(3, bizItem.getBizItemValue());
                        pstmt.setString(4, bizItem.getBizItemAlias());
                        pstmt.setString(5, bizItem.getMbgItemValue());
                        pstmt.setString(6, bizItem.getMbgItemAlias());
                        pstmt.setBoolean(7, bizItem.isMatching());
                        pstmt.addBatch();
                        if (++batchIndex < 100) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex <= 0) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into T_MBG_BgControlItemMapEntry(FID,FMapID,FBizItemValue,FBizItemAlias,FMbgItemValue,FMbgItemAlias,FIsMatching) Select FID,FMapID,FBizItemValue,FBizItemAlias,FMbgItemValue,FMbgItemAlias,FIsMatching from " + tmpTableName));
                if (pool == null) break block10;
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"updateBatchData sql error:", (Throwable)ex);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        pool.releaseTable(tmpTableName);
                    }
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTableName);
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        logger.debug((Object)"invoke end update Control bizItems!");
        logger.debug((Object)("invoke interface process allUse = " + (System.currentTimeMillis() - beginTime) + " ms;"));
    }
}

