/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.control.BgControlLogCollection;
import com.kingdee.eas.ma.control.BgControlLogInfo;
import com.kingdee.eas.ma.control.BgControlLogRuleInfo;
import com.kingdee.eas.ma.control.BgControlLogTypeEnum;
import com.kingdee.eas.ma.control.app.AbstractBgControlLogControllerBean;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgControlLogControllerBean
extends AbstractBgControlLogControllerBean {
    private static final long serialVersionUID = 497043422067405745L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.BgControlLogControllerBean");

    @Override
    public BgControlLogCollection getBgControlLogCollection(Context ctx, EntityViewInfo view) throws BOSException {
        BgControlLogCollection colls = super.getBgControlLogCollection(ctx, view);
        if (colls != null && !colls.isEmpty()) {
            BgControlLogInfo logInfo = null;
            BOSObjectType bosType = null;
            HashMap billIdMap = new HashMap();
            HashMap<BOSUuid, String> billMap = new HashMap<BOSUuid, String>();
            Set<String> billIdSet = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                logInfo = colls.get(i);
                bosType = logInfo.getBillId().getType();
                if (billIdMap.containsKey(bosType)) {
                    billIdSet = (Set)billIdMap.get(bosType);
                } else {
                    billIdSet = new HashSet();
                    billIdMap.put(bosType, billIdSet);
                }
                billIdSet.add(logInfo.getBillId().toString());
            }
            Map.Entry entry2 = null;
            ICoreBase _face = null;
            CoreBaseCollection _colls = null;
            CoreBaseInfo _base = null;
            EntityViewInfo _view = null;
            FilterInfo _filter = null;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            for (Map.Entry entry2 : billIdMap.entrySet()) {
                _face = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)((BOSObjectType)entry2.getKey()));
                if (_face == null) continue;
                _view = new EntityViewInfo();
                _filter = new FilterInfo();
                _filter.getFilterItems().add(new FilterItemInfo("id", entry2.getValue(), CompareType.INCLUDE));
                _view.setFilter(_filter);
                _view.getSelector().addObjectCollection((IObjectCollection)sic);
                _colls = _face.getCollection(_view);
                if (_colls == null) continue;
                int in2 = _colls.size();
                for (int i = 0; i < in2; ++i) {
                    _base = _colls.get(i);
                    if (_base.getString("number") != null) {
                        billMap.put(_base.getId(), _base.getString("number"));
                        continue;
                    }
                    billMap.put(_base.getId(), _base.getString("name"));
                }
            }
            int in3 = colls.size();
            for (int i = 0; i < in3; ++i) {
                logInfo = colls.get(i);
                logInfo.setBillAlias((String)billMap.get(logInfo.getBillId()));
            }
        }
        return colls;
    }

    @Override
    protected BgControlLogCollection _getCollectionByIsomer(Context ctx, String billid, Timestamp begin, Timestamp end) throws BOSException, EASBizException {
        BgControlLogCollection colls = new BgControlLogCollection();
        BgControlLogInfo info = null;
        BgControlLogRuleInfo rule = null;
        Connection conn = null;
        PreparedStatement psmt = null;
        ResultSet result = null;
        conn = this.getConnection(ctx);
        String x = StringUtils.isEmpty((String)billid) ? "" : " AND c.FBillId='" + billid + "'";
        String sql = " select c.FID,c.FBillId,c.FOperTime,c.FOperType,c.FOperResult,r.FID from T_MBG_BgControlLog c left join T_MBG_BgControlLogRule r on r.FID = c.FRuleID where c.FOperTime > ? AND c.FOperTime < ? AND c.Fisomer = ? " + x;
        try {
            psmt = conn.prepareStatement(sql);
            psmt.setTimestamp(1, begin);
            psmt.setTimestamp(2, end);
            psmt.setInt(3, 1);
            result = psmt.executeQuery();
            while (result.next()) {
                info = new BgControlLogInfo();
                info.setBillId(BOSUuid.read((String)result.getString(2)));
                info.setOperTime(result.getTimestamp(3));
                info.setOperType(BgControlLogTypeEnum.getEnum(result.getInt(4)));
                info.setOperResult(result.getInt(5));
                info.setBillAlias(result.getString(2));
                if (!StringUtils.isEmpty((String)result.getString(6))) {
                    rule = new BgControlLogRuleInfo();
                    rule.setId(BOSUuid.read((String)result.getString(6)));
                    info.setRule(rule);
                }
                colls.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(result, (Statement)psmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)result, (Statement)psmt, (Connection)conn);
        return colls;
    }
}

