/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.control.BgControlBaseInfo;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlItemMapEntryInfo;
import com.kingdee.eas.ma.control.BgControlItemMapInfo;
import com.kingdee.eas.ma.control.BgControlRuleCollection;
import com.kingdee.eas.ma.control.BgControlRuleInfo;
import com.kingdee.eas.ma.control.BgControlSchemeCollection;
import com.kingdee.eas.ma.control.BgControlSchemeDistParameter;
import com.kingdee.eas.ma.control.BgControlSchemeException;
import com.kingdee.eas.ma.control.BgControlSchemeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.BgCtrlLimitValueEnum;
import com.kingdee.eas.ma.control.IBgControlScheme;
import com.kingdee.eas.ma.control.app.AbstractBgControlSchemeFacadeControllerBean;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.control.utils.BizDataObject;
import com.kingdee.eas.ma.control.utils.BizUnitUtils;
import com.kingdee.eas.ma.control.utils.ControlSchemeUtils;
import com.kingdee.eas.ma.mbg.BgSchemeTypeInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgControlSchemeFacadeControllerBean
extends AbstractBgControlSchemeFacadeControllerBean {
    private static final long serialVersionUID = -2572525649411429303L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.BgControlSchemeFacadeControllerBean");
    private static String DEF_FIELD = "FNumber";

    protected IBgControlScheme getInterface(Context ctx) throws BOSException {
        return BgControlSchemeFactory.getLocalInstance(ctx);
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("bizSystem");
        sic.add("bizSystemAlias");
        sic.add("bizUnit");
        sic.add("bizUnitAlias");
        sic.add("isValid");
        sic.add("beginDate");
        sic.add("endDate");
        sic.add("isSysDefault");
        sic.add("parentID");
        sic.add("rootID");
        sic.add("creator");
        sic.add("lastUpdateUser");
        sic.add("base.id");
        sic.add("base.isAllowAccess");
        sic.add("base.isCtrlOfEmpty");
        sic.add("base.nullBudget");
        sic.add("base.notNullBudget");
        sic.add("rule.id");
        sic.add("rule.createTime");
        sic.add("rule.lastUpdateTime");
        sic.add("rule.seq");
        sic.add("rule.orgUnit");
        sic.add("rule.orgUnitAlias");
        sic.add("rule.dimItem");
        sic.add("rule.dimItemAlias");
        sic.add("rule.currency");
        sic.add("rule.currencyAlias");
        sic.add("rule.periodType");
        sic.add("rule.realPeriodType");
        sic.add("rule.bizDate");
        sic.add("rule.bizDateAlias");
        sic.add("rule.bgElementNumber");
        sic.add("rule.bgScenarioNumber");
        sic.add("rule.acScenarioNumber");
        sic.add("rule.requestAmount");
        sic.add("rule.requestAmountAlias");
        sic.add("rule.requestAmountEx");
        sic.add("rule.ruleCondition");
        sic.add("rule.ruleConditionAlias");
        sic.add("rule.maskString");
        sic.add("rule.description");
        sic.add("rule.limitValue");
        sic.add("rule.bgSchemeType");
        sic.add("rule.bgSchemeType.id");
        sic.add("rule.bgSchemeType.number");
        sic.add("rule.bgSchemeType.name");
        sic.add("rule.bgPeriodType.id");
        sic.add("rule.bgPeriodType.number");
        sic.add("rule.bgPeriodType.name");
        sic.add("rule.dimensionGroup");
        sic.add("bgCtrlExpendRule.id");
        sic.add("bgCtrlExpendRule.bgReqAccNum");
        sic.add("bgCtrlExpendRule.bgReqAccName");
        sic.add("bgCtrlExpendRule.bgCtrlAccNum");
        sic.add("bgCtrlExpendRule.bgCtrlAccName");
        sic.add("bgCtrlExpendRule.bgCtrlValue");
        sic.add("bgCtrlExpendRule.bgCtrlParam");
        sic.add("bgCtrlExpendRule.bgReqRule");
        sic.add("bgCtrlExpendRule.isGroup");
        sic.add("bgCtrlExpendRule.seq");
        sic.add("bgCtrlExpendRule.entry.id");
        sic.add("bgCtrlExpendRule.entry.bgCtrlValue");
        sic.add("bgCtrlExpendRule.entry.bgCtrlRange");
        sic.add("bgCtrlExpendRule.entry.bgCtrlParam");
        sic.add("bgCtrlExpendRule.entry.seq");
        return sic;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String bgControlSchemeID) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)bgControlSchemeID)) {
            return this.getInterface(ctx).getBgControlSchemeInfo((IObjectPK)new ObjectUuidPK(bgControlSchemeID), this.getSelector());
        }
        return null;
    }

    @Override
    protected void _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof BgControlSchemeInfo) {
            this.getInterface(ctx).addnew((BgControlSchemeInfo)model);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof BgControlSchemeInfo) {
            BgControlSchemeInfo value = (BgControlSchemeInfo)model;
            this.getInterface(ctx).update((IObjectPK)new ObjectUuidPK(value.getId()), value);
        }
    }

    @Override
    protected void _delete(Context ctx, String bgControlSchemeID) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)bgControlSchemeID)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("isValid");
            BgControlSchemeInfo model = this.getInterface(ctx).getBgControlSchemeInfo((IObjectPK)new ObjectUuidPK(bgControlSchemeID), sic);
            if (model.isIsValid()) {
                throw new BgControlException(BgControlException.ISCANTDELETEOFVALID);
            }
            this.getInterface(ctx).delete((IObjectPK)new ObjectUuidPK(bgControlSchemeID));
        }
    }

    @Override
    @Deprecated
    protected Object _startup(Context ctx, String bgControlSchemeID) throws BOSException, EASBizException {
        throw new BOSException("Deprecated");
    }

    protected boolean verifyData(Context ctx, BgControlSchemeInfo model, boolean isIncludeDistributed, String rootId) throws BOSException {
        BgControlSchemeCollection col = new BgControlSchemeCollection();
        col.add(model);
        Set<String> result = this.getHasValidIds(ctx, col, isIncludeDistributed, rootId);
        return result.isEmpty();
    }

    protected Set<String> getHasValidIds(Context ctx, BgControlSchemeCollection schemeCol, boolean isIncludeDistributed, String rootId) throws BOSException {
        HashSet<String> result = new HashSet<String>();
        if (ctx == null || schemeCol == null || schemeCol.isEmpty()) {
            return result;
        }
        if (rootId == null) {
            rootId = "000000000000000000000000000=";
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tmpTable = null;
        try {
            tmpTable = pool.createTempTable("Create Table T_MBG_ControlVerify(FID Varchar(44) NOT NULL PRIMARY KEY, FOrgUnitId Varchar(44) NOT NULL, FBeginDate DateTime NOT NULL, FEndDate DateTime NOT NULL, FBizUnit Varchar(200) NOT NULL, FExists INT NOT NULL)");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            BgControlSchemeInfo info = null;
            for (int i = 0; i < schemeCol.size(); ++i) {
                info = schemeCol.get(i);
                paramList.add(new Object[]{info.getId() == null ? BOSUuid.create((BOSObjectType)info.getBOSType()) : info.getId().toString(), info.getOrgUnit().getId().toString(), info.getBeginDate(), info.getEndDate(), info.getBizUnit(), 0});
            }
            DbUtil.executeBatch((Context)ctx, (String)("Insert Into " + tmpTable + "(FID, FOrgUnitId, FBeginDate, FEndDate, FBizUnit, FExists) Values(?, ?, ?, ?, ?, ?)"), paramList);
            DbUtil.execute((Context)ctx, (String)("Update " + tmpTable + " t0 Set FExists = 1 Where Exists(Select FID FROM T_MBG_BgControlScheme t1 Where t0.FID <> t1.FID AND t0.FOrgUnitId = t1.FOrgUnitID AND FIsValid = 1 AND t0.FBizUnit = t1.FBizUnit AND ((t1.FBeginDate >= t0.FBeginDate AND t1.FBeginDate <= t0.FEndDate) OR (t1.FEndDate >= t0.FBeginDate AND t1.FEndDate <= t0.FEndDate)) AND t1.FRootId <> ?)"), (Object[])new Object[]{rootId});
            IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)("Select FID FROM " + tmpTable + " Where FExists = 1"));
            while (rst.next()) {
                result.add(rst.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            pool.releaseTable(tmpTable);
        }
        return result;
    }

    @Override
    @Deprecated
    protected Object _disable(Context ctx, String bgControlSchemeID) throws BOSException, EASBizException {
        throw new BOSException("Deprecated");
    }

    @Override
    protected Object _distribution(Context ctx, Object parameter) throws BOSException, EASBizException {
        if (ctx == null || !(parameter instanceof BgControlSchemeDistParameter)) {
            throw new BgControlException(BgControlException.ISCANTDISTOFPARAMETER);
        }
        BgControlSchemeInfo model = null;
        BgControlSchemeInfo clone = null;
        BgControlSchemeInfo tmpValue = null;
        CoreBaseCollection addnew = new CoreBaseCollection();
        CoreBaseCollection update = new CoreBaseCollection();
        String orgUnitId = null;
        BgControlSchemeDistParameter distParam = (BgControlSchemeDistParameter)parameter;
        model = this.getInterface(ctx).getBgControlSchemeInfo((IObjectPK)new ObjectUuidPK(distParam.getBgControlSchemeId()), this.getSelector());
        if (model == null) {
            return null;
        }
        Map<String, BgControlSchemeInfo> scheme = this.queryBgControlSchemeInfo(ctx, model, distParam);
        boolean isUpdate = distParam.isUpate();
        boolean isModify = distParam.isModifyState();
        boolean isShareBizItem = BgParamNHelper.isShareBizItem((Context)ctx);
        ArrayList rsList = new ArrayList();
        HashMap<String, String> tem = null;
        ICostCenterOrgUnit iOrg = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        CostCenterOrgUnitInfo orgInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        Connection conn = null;
        Timestamp time = new Timestamp(System.currentTimeMillis());
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            int in = distParam.getDistOrgUnits().size();
            for (int i = 0; i < in; ++i) {
                orgUnitId = distParam.getDistOrgUnits().get(i);
                if (scheme.containsKey(orgUnitId)) {
                    tmpValue = scheme.get(orgUnitId);
                    clone = model.merge(tmpValue);
                    if (model.isIsValid() && !this.verifyData(ctx, clone, false, model.getRootID().toString())) {
                        orgInfo = iOrg.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId), sic);
                        tem = new HashMap<String, String>();
                        tem.put("number", clone.getNumber());
                        tem.put("orgName", orgInfo.getName());
                        tem.put("reason", "dateError");
                        rsList.add(tem);
                        continue;
                    }
                    clone.remove("itemMaps");
                    update.add((CoreBaseInfo)clone);
                } else {
                    clone = model.deepClone();
                    clone.setIsValid(false);
                    clone.setOrgUnit(new CostCenterOrgUnitInfo());
                    clone.getOrgUnit().setId(BOSUuid.read((String)orgUnitId));
                    try {
                        this.getInterface(ctx).checkNumberDup(clone);
                    }
                    catch (Exception e) {
                        if (distParam.isCoverage()) {
                            FilterInfo filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("number", (Object)clone.getNumber(), CompareType.EQUALS));
                            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
                            this.getInterface(ctx).delete(filter);
                        }
                        orgInfo = iOrg.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId), sic);
                        tem = new HashMap();
                        tem.put("number", clone.getNumber());
                        tem.put("orgName", orgInfo.getName());
                        tem.put("reason", "numberDup");
                        rsList.add(tem);
                        continue;
                    }
                    if (model.isIsValid() && !this.verifyData(ctx, clone, true, clone.getRootID().toString())) {
                        orgInfo = iOrg.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId), sic);
                        tem = new HashMap();
                        tem.put("number", clone.getNumber());
                        tem.put("orgName", orgInfo.getName());
                        tem.put("reason", "dateError");
                        rsList.add(tem);
                        continue;
                    }
                    clone.remove("itemMaps");
                    addnew.add((CoreBaseInfo)clone);
                }
                clone.setIsValid(model.isIsValid());
                clone.setUpdate(isUpdate);
                clone.setIsModifyState(isModify);
                clone.setLastUpdateTime(time);
                if (distParam.getUserId() != null) {
                    clone.setLastUpdateUser(new UserInfo());
                    clone.getLastUpdateUser().setId(BOSUuid.read((String)distParam.getUserId()));
                }
                clone.setParentID(model.getId());
                if (model.getRootID() != null) {
                    clone.setRootID(model.getRootID());
                    continue;
                }
                clone.setRootID(model.getId());
            }
            if (!addnew.isEmpty()) {
                IObjectPK[] pks = this.getInterface(ctx).addnewBatchData(addnew);
                this.dispatchBizItemData(ctx, model.getId(), pks, isShareBizItem);
                CoreBaseCollection colls = new CoreBaseCollection();
                colls.addObject((IObjectValue)model);
                this.addLog(ctx, (IObjectCollection)colls, "mbg_control_scheme_distribution");
            }
            if (!update.isEmpty()) {
                IObjectPK[] pks = this.getInterface(ctx).updateBatchData(update);
                this.dispatchBizItemData(ctx, model.getId(), pks, isShareBizItem);
                CoreBaseCollection colls = new CoreBaseCollection();
                colls.addObject((IObjectValue)model);
                this.addLog(ctx, (IObjectCollection)colls, "mbg_control_scheme_distribution");
            }
            if (isShareBizItem) {
                BgDBUtils.executeUpdate((Connection)conn, (String)"update T_BAS_ParamItem set FIsModify = 1 where FID = '0iwAAAAJ7wDtKpea'");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return rsList;
    }

    private void dispatchBizItemData(Context ctx, BOSUuid bgControlId, IObjectPK[] dispIds, boolean isShareBizItem) throws BOSException, EASBizException {
        if (ctx == null || bgControlId == null || dispIds == null) {
            return;
        }
        Connection conn = null;
        IRowSet rst = null;
        HashMap<String, String> bizPropIds = new HashMap<String, String>();
        String sBgControlId = bgControlId.toString();
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID, FBizProp, FDimensionGroup from T_MBG_BgControlItemMap where FControlSchemeID = ?", (Object[])new Object[]{sBgControlId});
            while (rst.next()) {
                bizPropIds.put(BgControlItemMapInfo.getBizPropKey(rst.getString("FBizProp"), rst.getInt("FDimensionGroup")), rst.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rst);
            String dBgControlId = null;
            String bizMapId = null;
            StringBuffer query = new StringBuffer();
            query.append("select FID, FControlSchemeID from T_MBG_BgControlItemMap where FControlSchemeID IN (");
            for (int i = 1; i < 50; ++i) {
                query.append("?,");
            }
            query.append("?)");
            String delEntry = "delete from T_MBG_BgControlItemMapEntry where FMapID = ?";
            String delMap = "delete from T_MBG_BgControlItemMap where FControlSchemeID = ?";
            ArrayList<String> billIds = new ArrayList<String>();
            for (IObjectPK pk : dispIds) {
                billIds.add(pk.toString());
            }
            ArrayList<Object[]> controlIds = new ArrayList<Object[]>();
            ArrayList<Object[]> bizMapIds = new ArrayList<Object[]>();
            List objs = BgDBUtils.executeBatchQuery((Connection)conn, (String)query.toString(), billIds);
            if (objs != null && !objs.isEmpty()) {
                for (Object[] obj : objs) {
                    bizMapId = (String)obj[0];
                    dBgControlId = (String)obj[1];
                    bizMapIds.add(new Object[]{bizMapId});
                    controlIds.add(new Object[]{dBgControlId});
                }
                BgDBUtils.executeBatch((Connection)conn, (String)delEntry, bizMapIds);
                BgDBUtils.executeBatch((Connection)conn, (String)delMap, controlIds);
            }
            if (!isShareBizItem && !bizPropIds.isEmpty()) {
                BgControlItemMapInfo bizItem = new BgControlItemMapInfo();
                String insSql = "Insert Into T_MBG_BgControlItemMap (FID, FControlSchemeID, FBizProp, FDimensionGroup) select newbosid('" + bizItem.getBOSType() + "'), ?, FBizProp, FDimensionGroup from T_MBG_BgControlItemMap where FControlSchemeID = ?";
                controlIds.clear();
                for (IObjectPK pk : dispIds) {
                    controlIds.add(new Object[]{pk.toString(), sBgControlId});
                }
                BgDBUtils.executeBatch((Connection)conn, (String)insSql, controlIds);
                HashMap bizItemMap = new HashMap();
                List tmpList = null;
                query = new StringBuffer();
                query.append("select FID, FBizProp, FDimensionGroup from T_MBG_BgControlItemMap where FControlSchemeID IN (");
                for (int i = 1; i < 50; ++i) {
                    query.append("?,");
                }
                query.append("?)");
                BgControlItemMapEntryInfo bizEntry = new BgControlItemMapEntryInfo();
                String dataSql = "Insert Into T_MBG_BgControlItemMapEntry (FID, FMapID, FBizItemValue, FBizItemAlias, FMbgItemValue, FMbgItemAlias, FIsMatching) select newbosid('" + bizEntry.getBOSType() + "'), ?, FBizItemValue, FBizItemAlias, FMbgItemValue, FMbgItemAlias, FIsMatching from T_MBG_BgControlItemMapEntry where FMapID = ?";
                objs = BgDBUtils.executeBatchQuery((Connection)conn, (String)query.toString(), billIds);
                for (Object[] obj : objs) {
                    String propKey = obj[1] + "_" + obj[2];
                    if (bizItemMap.containsKey(propKey)) {
                        tmpList = (List)bizItemMap.get(propKey);
                    } else {
                        tmpList = new ArrayList();
                        bizItemMap.put(propKey, tmpList);
                    }
                    tmpList.add((String)obj[0]);
                }
                Map.Entry entry2 = null;
                for (Map.Entry entry2 : bizPropIds.entrySet()) {
                    String bizProp = (String)entry2.getKey();
                    String srcMapId = (String)entry2.getValue();
                    if (!bizItemMap.containsKey(bizProp)) continue;
                    tmpList = (List)bizItemMap.get(bizProp);
                    bizMapIds.clear();
                    for (String distMapId : tmpList) {
                        bizMapIds.add(new Object[]{distMapId, srcMapId});
                    }
                    BgDBUtils.executeBatch((Connection)conn, (String)dataSql, bizMapIds);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, BgControlSchemeInfo> queryBgControlSchemeInfo(Context ctx, BgControlSchemeInfo model, BgControlSchemeDistParameter distParam) throws BOSException, EASBizException {
        HashMap<String, BgControlSchemeInfo> controlScheme = new HashMap<String, BgControlSchemeInfo>();
        if (ctx == null) return controlScheme;
        if (distParam == null) {
            return controlScheme;
        }
        int batchNum = 50;
        int size = distParam.getDistOrgUnits().size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        String rootId = model.getRootID().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID, t.FOrgUnitID, base.FID as BID, r.FID as RID, r.FSeq as RSeq, t.FPARENTID as parentId,t.FROOTID as rootId  from T_MBG_BgControlScheme t join T_MBG_BgControlBase base on t.FBaseID = base.FID join T_MBG_BgControlRule r on t.FID = r.FSchemeID where t.FOrgUnitID IN (");
        for (int i = 1; i < batchNum; ++i) {
            sql.append("?,");
        }
        sql.append("?) and FRootID = '" + rootId + "' order by r.FSeq");
        HashMap<String, BgControlSchemeInfo> billIds = new HashMap<String, BgControlSchemeInfo>();
        BgControlSchemeInfo value = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < count; ++i) {
                for (int x = 1; x <= batchNum; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, distParam.getDistOrgUnits().get(pos));
                        continue;
                    }
                    pstmt.setString(x, BgControlConstants.noFindStr);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!billIds.containsKey(rst.getString("FID"))) {
                        value = new BgControlSchemeInfo();
                        value.setId(BOSUuid.read((String)rst.getString("FID")));
                        value.setOrgUnit(new CostCenterOrgUnitInfo());
                        value.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                        value.setBase(new BgControlBaseInfo());
                        value.getBase().setId(BOSUuid.read((String)rst.getString("BID")));
                        value.setParentID(BOSUuid.read((String)rst.getString("parentId")));
                        value.setRootID(BOSUuid.read((String)rst.getString("rootId")));
                        BgControlRuleInfo rule = new BgControlRuleInfo();
                        rule.setId(BOSUuid.read((String)rst.getString("RID")));
                        rule.setSeq(rst.getInt("RSeq"));
                        value.getRule().add(rule);
                        billIds.put(rst.getString("FID"), value);
                        controlScheme.put(value.getOrgUnit().getId().toString(), value);
                        continue;
                    }
                    value = (BgControlSchemeInfo)billIds.get(rst.getString("FID"));
                    BgControlRuleInfo rule = new BgControlRuleInfo();
                    rule.setId(BOSUuid.read((String)rst.getString("RID")));
                    rule.setSeq(rst.getInt("RSeq"));
                    value.getRule().add(rule);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return controlScheme;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _getBizSys(Context ctx) throws BOSException, EASBizException {
        ArrayList<String[]> bizSystems = new ArrayList<String[]>();
        if (ctx == null) {
            return bizSystems;
        }
        String[] bizSys = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select distinct FBizSystem, FBizSystemAlias_" + ctx.getLocale() + ", FIsomer from T_MBG_BgControlData order by FBizSystem");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bizSys = new String[]{rst.getString(1), rst.getString(2), String.valueOf(rst.getBoolean(3))};
                bizSystems.add(bizSys);
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"getBizSys SQL Error:", (Throwable)ex2);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bizSystems;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _getBizUnit(Context ctx, String bizSys) throws BOSException, EASBizException {
        ArrayList<String[]> bizUnits = new ArrayList<String[]>();
        if (ctx == null) return bizUnits;
        if (StringUtils.isEmpty((String)bizSys)) {
            return bizUnits;
        }
        String[] bizUnit = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select distinct FBizUnit, FBizUnitAlias_" + ctx.getLocale() + ", FIsomer from T_MBG_BgControlData where FBizSystem = ? order by FBizUnit");
            pstmt.setString(1, bizSys);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bizUnit = new String[]{rst.getString(1), rst.getString(2), String.valueOf(rst.getBoolean(3))};
                bizUnits.add(bizUnit);
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"getBizUnit SQL Error:", (Throwable)ex2);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bizUnits;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _getBiz(Context ctx, String bizSys, String bizUnit, int bizType) throws BOSException, EASBizException {
        ArrayList<String[]> bizs = new ArrayList<String[]>();
        if (ctx == null) return bizs;
        if (StringUtils.isEmpty((String)bizSys)) {
            return bizs;
        }
        String[] biz = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FBiz, FBizAlias_" + ctx.getLocale() + ", FIsDefault, FIsomer from T_MBG_BgControlData where FBizSystem = ? and FBizUnit = ? and FBizType = ? order by FBiz");
            pstmt.setString(1, bizSys);
            pstmt.setString(2, bizUnit);
            pstmt.setInt(3, bizType);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                biz = new String[]{rst.getString(1), rst.getString(2), String.valueOf(rst.getInt(3)), String.valueOf(rst.getBoolean(4))};
                bizs.add(biz);
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"getBiz SQL Error:", (Throwable)ex2);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bizs;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _getDefaultBizUnit(Context ctx, String bizUnit, int bizType) throws BOSException, EASBizException {
        if (ctx == null) return null;
        if (StringUtils.isEmpty((String)bizUnit)) {
            return null;
        }
        String biz = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FBiz from T_MBG_BgControlData where FBizUnit = ? and FBizType = ? and FIsDefault = 1 order by FBiz");
            pstmt.setString(1, bizUnit);
            pstmt.setInt(2, bizType);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                biz = rst.getString("FBiz");
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"getBiz SQL Error:", (Throwable)ex2);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return biz;
    }

    @Override
    protected List _getMbgDim(Context ctx, boolean isOnlyBgIndex, BOSUuid orgUnitId) throws BOSException, EASBizException {
        BizDataObject bizData = null;
        ArrayList<BizDataObject> bizDims = new ArrayList<BizDataObject>();
        bizData = new BizDataObject();
        bizData.setDisplay(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)DimensionConstants.DEF_ACCOUNT_NUMBER, (Locale)ctx.getLocale()));
        bizData.setValue(DimensionBaseConstants.DEF_INDEX_SRCNUMBER);
        bizDims.add(bizData);
        if (!isOnlyBgIndex) {
            MbgDimInfo mbgDim = null;
            MbgDimCollection mbgDims = null;
            if (orgUnitId != null) {
                HashSet<String> orgUnitIds = new HashSet<String>();
                ICostCenterOrgUnit iccOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
                CostCenterOrgUnitInfo orgUnit = iccOrgUnit.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
                if (orgUnit != null) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", new HashSet(Arrays.asList((Object[])orgUnit.getLongNumber().split("!"))), CompareType.INCLUDE));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("id");
                    view.setSelector(sic);
                    CostCenterOrgUnitCollection colls = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(view);
                    int in = colls.size();
                    for (int i = 0; i < in; ++i) {
                        orgUnitIds.add(colls.get(i).getId().toString());
                    }
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgUnitIds, CompareType.INCLUDE));
                    view.setFilter(filter);
                    sic = new SelectorItemCollection();
                    sic.add("id");
                    sic.add("name");
                    sic.add("number");
                    sic.add("srcNumber");
                    sic.add("refField");
                    view.setSelector(sic);
                    mbgDims = MbgDimFactory.getLocalInstance((Context)ctx).getMbgDimCollection(view);
                }
            }
            if (mbgDims == null) {
                mbgDims = DimUtils.getDimensionColls((Context)ctx);
            }
            mbgDims.sort("number");
            int jn = mbgDims.size();
            for (int j = 0; j < jn; ++j) {
                mbgDim = mbgDims.get(j);
                if (DimUtils.checkBaseDimension((String)mbgDim.getNumber()) || DimensionBaseConstants.DEF_INDEX_NUMBER.equals(mbgDim.getNumber())) continue;
                bizData = new BizDataObject();
                bizData.setDisplay(mbgDim.getName());
                bizData.setValue(mbgDim.getSrcNumber());
                bizDims.add(bizData);
            }
        }
        return bizDims;
    }

    @Override
    protected boolean _checkDistirbuteNumber(Context ctx, BgControlSchemeDistParameter param) throws BOSException, EASBizException {
        if (param == null) {
            return false;
        }
        List<String> orgs = param.getDistOrgUnits();
        Set numbers = param.getNumbers();
        List idList = param.getBgControlSchemeList();
        if (orgs == null || orgs.size() == 0 || numbers == null || numbers.isEmpty() || idList == null || idList.isEmpty()) {
            return false;
        }
        HashSet oldIds = new HashSet();
        for (int index = 0; index < idList.size(); ++index) {
            oldIds.add(idList.get(index));
        }
        IBgControlScheme iBgControlScheme = BgControlSchemeFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("rootID");
        sic.add("orgUnit.id");
        view.setFilter(new FilterInfo());
        view.setBaseOnSelector(true);
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", oldIds, CompareType.INCLUDE));
        view.setSelector(sic);
        String orgId = null;
        BgControlSchemeCollection colls = iBgControlScheme.getBgControlSchemeCollection(view);
        if (colls == null || colls.isEmpty()) {
            return false;
        }
        HashSet<String> rootIdSet = new HashSet<String>();
        for (int index = 0; index < colls.size(); ++index) {
            rootIdSet.add(colls.get(index).getRootID().toString());
        }
        for (int i = 0; i < orgs.size(); ++i) {
            orgId = orgs.get(i);
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)numbers, CompareType.INCLUDE));
            view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
            colls = iBgControlScheme.getBgControlSchemeCollection(view);
            if (colls == null || colls.isEmpty()) continue;
            for (int c = 0; c < colls.size(); ++c) {
                if (rootIdSet.contains(colls.get(c).getRootID().toString())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected List _batchStartup(Context ctx, List ids) throws BOSException, EASBizException {
        return this.stateChange(ctx, ids, true);
    }

    @Override
    protected List _batchDisable(Context ctx, List ids) throws BOSException, EASBizException {
        return this.stateChange(ctx, ids, false);
    }

    private List stateChange(Context ctx, List ids, boolean isValid) throws BOSException, EASBizException {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        ArrayList<String> rs = new ArrayList<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isValid");
        sic.add("beginDate");
        sic.add("endDate");
        sic.add("bizUnit");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("rule.bgPeriodType.id");
        IBgControlScheme iBgControlScheme = BgControlSchemeFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.setBaseOnSelector(true);
        view.setSelector(sic);
        Set<String> checkSet = null;
        HashSet<String> validSet = new HashSet<String>();
        CoreBaseCollection coll = new CoreBaseCollection();
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            BgControlSchemeInfo info = iBgControlScheme.getBgControlSchemeInfo((IObjectPK)new ObjectUuidPK(id), sic);
            coll.addObject((IObjectValue)info);
            try {
                iBgControlScheme.verifyCanModifyState(BOSUuid.read((String)id));
                BgControlSchemeCollection colls = new BgControlSchemeCollection();
                colls.add(info);
                if (isValid && !(checkSet = this.getHasValidIds(ctx, colls, true, null)).isEmpty()) {
                    Object[] msg = new String[]{info.getOrgUnit().getName(), info.getNumber()};
                    rs.add(new BgControlSchemeException(BgControlSchemeException.SCHEMEDATEDUP, msg).getMessage());
                    continue;
                }
                validSet.add(id);
                view.setFilter(new FilterInfo());
                view.getFilter().getFilterItems().add(new FilterItemInfo("rootID", (Object)id, CompareType.EQUALS));
                view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
                colls = iBgControlScheme.getBgControlSchemeCollection(view);
                if (colls == null || colls.isEmpty()) continue;
                checkSet = this.getHasValidIds(ctx, colls, true, null);
                for (int index = 0; index < colls.size(); ++index) {
                    try {
                        info = colls.get(index);
                        if (isValid && checkSet.contains(info.getId().toString())) {
                            Object[] msg = new String[]{info.getOrgUnit().getName(), info.getNumber()};
                            rs.add(new BgControlSchemeException(BgControlSchemeException.SCHEMEDATEDUP, msg).getMessage());
                            continue;
                        }
                        validSet.add(info.getId().toString());
                        continue;
                    }
                    catch (Exception e) {
                        rs.add(e.getMessage());
                    }
                }
                continue;
            }
            catch (Exception e) {
                rs.add(e.getMessage());
            }
        }
        if (!validSet.isEmpty()) {
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgControlScheme Set FIsValid = " + (isValid ? 1 : 0) + " Where FID = ?"), new ArrayList(validSet));
                this.addLog(ctx, (IObjectCollection)coll, isValid ? "mbg_control_scheme_enable" : "mbg_control_scheme_disEnable");
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return rs;
    }

    private void printLog(Context ctx, DataBaseInfo info, String logItem) {
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"updateInfo", (BOSObjectType)new BgControlSchemeInfo().getBOSType(), null, (String)logName, (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
    }

    private void addLog(Context ctx, IObjectCollection colls, String logItem) {
        if (colls == null || colls.isEmpty()) {
            return;
        }
        DataBaseInfo info = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            info = (DataBaseInfo)colls.getObject(i);
            this.printLog(ctx, info, logItem);
        }
    }

    @Override
    protected Map _checkNumberRepeat(Context ctx, String orgId, String[] numbers) throws BOSException, EASBizException {
        HashMap<String, String> repeatMap = new HashMap<String, String>();
        if (orgId == null || numbers == null || numbers.length == 0) {
            return repeatMap;
        }
        StringBuffer querySql = new StringBuffer("SELECT \t\tFId, \t\tFNumber FROM\t\tT_mbg_BgControlScheme Where \tFOrgUnitId = ? AND \tFIsSysDefault = 0 AND \tFNumber IN(");
        Object[] conditions = new String[numbers.length + 1];
        conditions[0] = orgId;
        int size = numbers.length;
        for (int i = 0; i < size; ++i) {
            conditions[i + 1] = numbers[i];
            if (i == size - 1) {
                querySql.append("?)");
                continue;
            }
            querySql.append("?,");
        }
        IRowSet rs = null;
        try {
            String id = null;
            String number = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])conditions);
            while (rs.next()) {
                id = rs.getString(1);
                number = rs.getString(2);
                repeatMap.put(number, id);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"budget error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return repeatMap;
    }

    @Override
    protected String _importData(Context ctx, String orgId, Map importMap, Map repeatMap, String defaultSchemeType) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        IBgControlScheme iBgCtrl = BgControlSchemeFactory.getLocalInstance(ctx);
        String SOURCE_STR = "com.kingdee.eas.ma.control.BgControlSchemeImportResource";
        String thenumber = ResourceBase.getString((String)SOURCE_STR, (String)"number", (Locale)ContextUtils.getLocaleFromEnv());
        String lost = ResourceBase.getString((String)SOURCE_STR, (String)"lost", (Locale)ContextUtils.getLocaleFromEnv());
        String success = ResourceBase.getString((String)SOURCE_STR, (String)"success", (Locale)ContextUtils.getLocaleFromEnv());
        if (repeatMap != null && !repeatMap.isEmpty()) {
            String number2 = null;
            String id = null;
            ObjectUuidPK pk = null;
            for (String number2 : repeatMap.keySet()) {
                id = (String)repeatMap.get(number2);
                pk = new ObjectUuidPK(id);
                try {
                    this.checkCanUpdate(ctx, id);
                    iBgCtrl.delete((IObjectPK)pk);
                }
                catch (EASBizException e) {
                    if (e instanceof BgControlSchemeException) {
                        BgControlSchemeException ex = (BgControlSchemeException)e;
                        if (BgControlSchemeException.SCHEMEISVALIDOFDELETE.getCode().equals(ex.getSubCode())) {
                            errorMsg.append(thenumber + number2 + lost + ex.getMessage() + "\n");
                            importMap.remove(number2);
                            continue;
                        }
                        if (!BgControlSchemeException.NOTMODIFYSCHEME.getCode().equals(ex.getSubCode()) && !BgControlSchemeException.NOTMODIFYSCHEMEBY030.getCode().equals(ex.getSubCode())) continue;
                        errorMsg.append(thenumber + number2 + lost + ex.getMessage() + "\n");
                        importMap.remove(number2);
                        continue;
                    }
                    errorMsg.append(thenumber + number2 + lost + e.getMessage(ctx.getLocale()) + "\n");
                    importMap.remove(number2);
                }
                catch (BOSException e) {
                    errorMsg.append(thenumber + number2 + lost + e.getMessage() + "\n");
                    importMap.remove(number2);
                }
            }
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("rule.*"));
        CostCenterOrgUnitInfo costInfo = new CostCenterOrgUnitInfo();
        costInfo.setId(BOSUuid.read((String)orgId));
        BgControlSchemeInfo info = null;
        BgControlRuleInfo ruleInfo = null;
        String elementNumber = (String)importMap.get("elementNumber");
        CalendarHelper helper = new CalendarHelper();
        int year = helper.getCurrentlyYear();
        Timestamp begin = new Timestamp(helper.getFirstDayOfYear(year).getTime());
        Timestamp end = new Timestamp(helper.getLastDayOfYear(year).getTime());
        HashMap controlFieldAlias = new HashMap();
        Map subMap = null;
        StringBuffer newAlias = new StringBuffer();
        String[] subItem = null;
        String[] combItem = null;
        HashMap<String, String> mbgDim = new HashMap<String, String>();
        IRowSet rst = null;
        for (String number : importMap.keySet()) {
            block38: {
                if ("elementNumber".equals(number)) continue;
                String id = ((BOSUuid)importMap.get(number)).toString();
                if (id != null) {
                    try {
                        info = (BgControlSchemeInfo)iBgCtrl.getValue((IObjectPK)new ObjectUuidPK(id), sic);
                        if (info == null || !info.getBizSystem().equals("com.kingdee.eas.fi.gl")) break block38;
                        for (int i = 0; i < info.getRule().size(); ++i) {
                            info.getRule().get(i).setLimitValue(BgCtrlLimitValueEnum.Subject);
                        }
                    }
                    catch (EASBizException e) {
                        logger.error((Object)"", (Throwable)e);
                        errorMsg.append(thenumber + number + lost + e.getMessage(ctx.getLocale()) + "\n");
                        continue;
                    }
                    catch (BOSException e) {
                        logger.error((Object)"", (Throwable)e);
                        errorMsg.append(thenumber + number + lost + e.getMessage() + "\n");
                        continue;
                    }
                }
            }
            BgControlSchemeInfo cloneInfo = this.deepClone(info, elementNumber, defaultSchemeType);
            if (ctx.getLocale().equals(LocaleUtils.locale_L1)) {
                if (!controlFieldAlias.containsKey(cloneInfo.getBizUnit())) {
                    controlFieldAlias.put(cloneInfo.getBizUnit(), new HashMap());
                }
                subMap = (Map)controlFieldAlias.get(cloneInfo.getBizUnit());
                for (int i = 0; i < cloneInfo.getRule().size(); ++i) {
                    ruleInfo = cloneInfo.getRule().get(i);
                    newAlias.setLength(0);
                    subItem = ruleInfo.getDimItem().split("@");
                    for (int s = 0; s < subItem.length; ++s) {
                        combItem = subItem[s].split("\\|");
                        if (s > 0) {
                            newAlias.append("@");
                        }
                        if (!subMap.containsKey(combItem[0])) {
                            rst = DbUtil.executeQuery((Context)ctx, (String)("SELECT FBIZALIAS_" + ctx.getLocale() + " FROM T_MBG_BGCONTROLDATA Where FBIZTYPE = " + 2 + " AND FBIZUNIT = ? AND FBIZ = ?"), (Object[])new Object[]{cloneInfo.getBizUnit(), combItem[0]});
                            try {
                                if (rst.next()) {
                                    subMap.put(combItem[0], rst.getString(1));
                                }
                            }
                            catch (SQLException e) {
                                throw new BOSException((Throwable)e);
                            }
                            finally {
                                SQLUtils.cleanup((ResultSet)rst);
                            }
                        }
                        newAlias.append((String)subMap.get(combItem[0]));
                        newAlias.append("|");
                        if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(combItem[1])) {
                            newAlias.append(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)DimensionConstants.DEF_ACCOUNT_NUMBER, (Locale)ctx.getLocale()));
                            continue;
                        }
                        if (!mbgDim.containsKey(combItem[1])) {
                            rst = DbUtil.executeQuery((Context)ctx, (String)("SELECT FName_" + ctx.getLocale() + " FROM T_MBG_MBGDIM Where FSRCNUMBER = ?"), (Object[])new Object[]{combItem[1]});
                            try {
                                if (rst.next()) {
                                    mbgDim.put(combItem[1], rst.getString(1));
                                }
                            }
                            catch (SQLException e) {
                                throw new BOSException((Throwable)e);
                            }
                            finally {
                                SQLUtils.cleanup((ResultSet)rst);
                            }
                        }
                        newAlias.append((String)mbgDim.get(combItem[1]));
                    }
                    ruleInfo.setDimItemAlias(newAlias.toString());
                }
            }
            cloneInfo.setOrgUnit(costInfo);
            cloneInfo.setRootID(cloneInfo.getId());
            cloneInfo.setParentID(cloneInfo.getId());
            cloneInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            cloneInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
            cloneInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            cloneInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            cloneInfo.setIsSysDefault(false);
            cloneInfo.setBeginDate(begin);
            cloneInfo.setEndDate(end);
            try {
                iBgCtrl.addnew(cloneInfo);
                errorMsg.append(thenumber + number + success + "\n");
            }
            catch (BOSException e) {
                errorMsg.append(thenumber + number + lost);
                if (e.getCause() instanceof EASBizException) {
                    errorMsg.append(e.getCause().getMessage());
                } else {
                    errorMsg.append(e.getMessage());
                }
                errorMsg.append("\n");
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                errorMsg.append(thenumber + number + lost + e.getMessage(ctx.getLocale()) + "\n");
                logger.error((Object)e);
            }
        }
        return errorMsg.toString();
    }

    protected void checkCanUpdate(Context ctx, String id) throws BOSException, EASBizException {
        IBgControlScheme iBgCtrl = BgControlSchemeFactory.getLocalInstance(ctx);
        BgControlSchemeInfo bgCtrlSchemeInfo = (BgControlSchemeInfo)iBgCtrl.getValue((IObjectPK)new ObjectUuidPK(id));
        if (!bgCtrlSchemeInfo.isUpdate()) {
            throw ControlSchemeUtils.getControlModifyMsg(ctx, false);
        }
    }

    public BgControlSchemeInfo deepClone(BgControlSchemeInfo info, String elementNumber, String defaultSchemeType) {
        BgSchemeTypeInfo defaultInfo = new BgSchemeTypeInfo();
        if (defaultSchemeType != null) {
            defaultInfo.setId(BOSUuid.read((String)defaultSchemeType));
        }
        BgPeriodTypeInfo bgPeriodTypeInfo = new BgPeriodTypeInfo();
        bgPeriodTypeInfo.setId(BOSUuid.read((String)BgControlConstants.DEFAULT_BGPERIODTYPE_ID));
        BgControlSchemeInfo clone = new BgControlSchemeInfo();
        clone.putAll((IObjectValue)info);
        clone.setId(BOSUuid.create((BOSObjectType)clone.getBOSType()));
        BgControlBaseInfo base = new BgControlBaseInfo();
        base.putAll((IObjectValue)info.getBase());
        base.setId(BOSUuid.create((BOSObjectType)base.getBOSType()));
        clone.setBase(base);
        BgControlRuleCollection ruleColls = new BgControlRuleCollection();
        Iterator iter = info.getRule().iterator();
        while (iter.hasNext()) {
            BgControlRuleInfo rule = new BgControlRuleInfo();
            BgControlRuleInfo ruleInfo = (BgControlRuleInfo)iter.next();
            rule.putAll((IObjectValue)ruleInfo);
            rule.setId(BOSUuid.create((BOSObjectType)rule.getBOSType()));
            if (elementNumber == null) {
                rule.setBgElementNumber(ruleInfo.getBgElementNumber());
            } else {
                rule.setBgElementNumber(elementNumber);
            }
            if (defaultSchemeType != null) {
                rule.setBgSchemeType(defaultInfo);
            }
            rule.setBgPeriodType(bgPeriodTypeInfo);
            rule.setCreateTime(new Timestamp(System.currentTimeMillis()));
            rule.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            ruleColls.add(rule);
        }
        clone.put("rule", (Object)ruleColls);
        return clone;
    }

    @Override
    protected Map _checkBizItem(Context ctx, BizDataObject bizUnit, Map bizItemMap) throws BOSException, EASBizException {
        HashMap<String, Map<String, String[]>> checkMap = new HashMap<String, Map<String, String[]>>();
        if (bizUnit == null || StringUtils.isEmpty((String)bizUnit.getValue()) || bizItemMap == null || bizItemMap.isEmpty()) {
            return checkMap;
        }
        String bizProp = null;
        Map.Entry entry2 = null;
        Set itemNums = null;
        Map<String, String[]> checkNums = null;
        MbgDimInfo mbgDim = null;
        Map mbgMap = DimUtils.getDimInfoMap((Context)ctx);
        for (Map.Entry entry2 : bizItemMap.entrySet()) {
            bizProp = (String)entry2.getKey();
            itemNums = (Set)entry2.getValue();
            if (bizProp == null || itemNums.isEmpty()) continue;
            if (mbgMap.containsKey(bizProp) && bizProp.length() == BgBaseConstants.DIMSRC_LENGTH) {
                mbgDim = (MbgDimInfo)mbgMap.get(bizProp);
                checkNums = this.checkMbgItemNums(ctx, mbgDim, itemNums);
            } else {
                checkNums = this.checkBizItemNums(ctx, bizUnit, bizProp, itemNums);
            }
            checkMap.put(bizProp, checkNums);
        }
        return checkMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String[]> checkBizItemNums(Context ctx, BizDataObject bizUnit, String bizProp, Set<String> itemNums) throws BOSException, EASBizException {
        HashMap<String, String[]> checkNums = new HashMap<String, String[]>();
        if (ctx == null || bizUnit == null || StringUtils.isEmpty((String)bizUnit.getValue()) || StringUtils.isEmpty((String)bizProp) || itemNums == null) {
            return checkNums;
        }
        ArrayList<String> tmpList = new ArrayList<String>();
        StringBuffer sql = null;
        String[] tmpStrs = null;
        EntityObjectInfo entity = null;
        DataTableInfo table = null;
        LinkPropertyInfo numProp = null;
        PropertyInfo nameProp = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        if (!bizUnit.isIsomer()) {
            numProp = BizUnitUtils.lastLinkProperty(bizUnit.getValue(), bizProp, new HashMap());
        }
        if (numProp != null) {
            if (numProp instanceof LinkPropertyInfo) {
                entity = ((LinkPropertyInfo)numProp).getRelationship().getSupplierObject();
            }
            if (entity != null) {
                table = entity.getTable();
                numProp = BizUnitUtils.getProperty(bizUnit.getValue(), bizProp);
                nameProp = BizUnitUtils.getProperty(bizUnit.getValue(), BgControlUtils.getFieldName(bizProp));
                if (numProp != null) {
                    tmpList.clear();
                    tmpList.addAll(this.filterBizNum(itemNums));
                    int size = tmpList.size();
                    int count = (size - 1) / 100 + 1;
                    int pos = 0;
                    String numField = this.getPropFieldName((PropertyInfo)numProp);
                    String nameField = this.getPropFieldName(nameProp);
                    if (nameProp.getMappingField().isMultilingual()) {
                        nameField = nameField + "_" + ctx.getLocale();
                    }
                    sql = new StringBuffer("select " + numField + (nameField != null ? "," + nameField : "") + " from " + table.getName() + " where " + numField + " IN (");
                    for (int i = 1; i < 100; ++i) {
                        sql.append("?,");
                    }
                    sql.append("?)");
                    try {
                        conn = this.getConnection(ctx);
                        pstmt = conn.prepareStatement(sql.toString());
                        for (int index = 0; index < count; ++index) {
                            for (int x = 1; x <= 100; ++x, ++pos) {
                                if (pos < size) {
                                    pstmt.setString(x, (String)tmpList.get(pos));
                                    continue;
                                }
                                pstmt.setString(x, BgBaseConstants.noFindStr);
                            }
                            rst = pstmt.executeQuery();
                            while (rst.next()) {
                                tmpStrs = new String[]{rst.getString(1), rst.getString(2)};
                                checkNums.put(tmpStrs[0], tmpStrs);
                            }
                            SQLUtils.cleanup((ResultSet)rst);
                        }
                    }
                    catch (SQLDataException ex) {
                        try {
                            throw new BOSException((Throwable)ex);
                            catch (SQLException ex2) {
                                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                            }
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
                }
            }
        }
        Iterator<String> iterator = itemNums.iterator();
        while (iterator.hasNext()) {
            String bizNumber = iterator.next();
            if (checkNums.containsKey(bizNumber)) continue;
            tmpStrs = new String[]{bizNumber, bizNumber};
            checkNums.put(tmpStrs[0], tmpStrs);
        }
        return checkNums;
    }

    private String getPropFieldName(PropertyInfo prop) {
        if (prop == null || prop.getMappingField() == null) {
            return DEF_FIELD;
        }
        return prop.getMappingField().getName();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String[]> checkMbgItemNums(Context ctx, MbgDimInfo mbgDim, Set<String> itemNums) throws BOSException, EASBizException {
        HashMap<String, String[]> checkNums = new HashMap<String, String[]>();
        if (ctx == null) return checkNums;
        if (mbgDim == null) return checkNums;
        if (itemNums == null) {
            return checkNums;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FNumber, FName_" + ctx.getLocale() + " from " + (mbgDim.getNumber().equals(DimensionBaseConstants.DEF_ACCOUNT_NUMBER) ? "T_MBG_BgAccount" : "T_MBG_MbgMember") + " where FNumber IN (");
        for (int i = 1; i < 100; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        String[] tmpStrs = null;
        ArrayList<String> tmpList = new ArrayList<String>(this.filterBizNum(itemNums));
        int size = tmpList.size();
        int count = (size - 1) / 100 + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                for (int x = 1; x <= 100; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)tmpList.get(pos));
                        continue;
                    }
                    pstmt.setString(x, BgBaseConstants.noFindStr);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    tmpStrs = new String[]{rst.getString(1), rst.getString(2)};
                    checkNums.put(tmpStrs[0], tmpStrs);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return checkNums;
    }

    private Set<String> filterBizNum(Set<String> itemNums) {
        HashSet<String> filterSet = new HashSet<String>();
        for (String tmpStr : itemNums) {
            if (tmpStr.endsWith("%")) {
                tmpStr = tmpStr.substring(0, tmpStr.length() - 1);
            }
            filterSet.add(tmpStr);
        }
        return filterSet;
    }
}

