/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.IMbgMember;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.control.BgControlDataCollection;
import com.kingdee.eas.ma.control.BgControlDataFactory;
import com.kingdee.eas.ma.control.BgControlDataInfo;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlSetSchemeFactory;
import com.kingdee.eas.ma.control.BgControlSetSchemeInfo;
import com.kingdee.eas.ma.control.BgControlSettingCollection;
import com.kingdee.eas.ma.control.BgControlSettingFactory;
import com.kingdee.eas.ma.control.app.AbstractBgControlSetFacadeControllerBean;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberFactory;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgControlSetFacadeControllerBean
extends AbstractBgControlSetFacadeControllerBean {
    private static final long serialVersionUID = 3714335708566298158L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.BgControlSetFacadeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _checkIsUse(Context ctx, String setSchemeId, List setIds) throws BOSException, EASBizException {
        CoreBaseCollection colls = new CoreBaseCollection();
        if (StringUtils.isEmpty((String)setSchemeId) || setIds == null || setIds.isEmpty()) {
            return colls;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("beginDate");
        sic.add("endDate");
        BgControlSetSchemeInfo setSchemeInfo = BgControlSetSchemeFactory.getLocalInstance(ctx).getBgControlSetSchemeInfo((IObjectPK)new ObjectUuidPK(setSchemeId), sic);
        if (setSchemeInfo == null) {
            return colls;
        }
        ArrayList<String> cubes = new ArrayList<String>();
        HashSet<String> useIds = new HashSet<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FRefCube from T_MBG_BgScheme where frefcube is not null and ((Year(FDateFrom) <= ? and Year(FDateTo) >= ?) or (Year(FDateFrom) <= ? and Year(FDateTo) >= ?))");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setInt(1, setSchemeInfo.getBeginDate());
            pstmt.setInt(2, setSchemeInfo.getBeginDate());
            pstmt.setInt(3, setSchemeInfo.getEndDate());
            pstmt.setInt(4, setSchemeInfo.getEndDate());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                cubes.add(rst.getString("FRefCube"));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!cubes.isEmpty()) {
                int batchSize = 50;
                int size = setIds.size();
                int count = (size - 1) / batchSize + 1;
                String cubeName = null;
                int in = cubes.size();
                for (int i = 0; i < in; ++i) {
                    int index;
                    int pos = 0;
                    cubeName = BgCubeUtils.getControlCubeName((String)((String)cubes.get(i)));
                    sql = new StringBuffer();
                    sql.append("select distinct FBgSettingID from " + cubeName + " where FBgSettingID IN (");
                    for (index = 1; index < batchSize; ++index) {
                        sql.append("?,");
                    }
                    sql.append("?)");
                    pstmt = conn.prepareStatement(sql.toString());
                    for (index = 0; index < count; ++index) {
                        for (int x = 1; x <= batchSize; ++x, ++pos) {
                            if (pos < size) {
                                pstmt.setString(x, (String)setIds.get(pos));
                                continue;
                            }
                            pstmt.setString(x, BgControlConstants.noFindStr);
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            useIds.add(rst.getString("FBgSettingID"));
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"checkIsUse Error:", (Throwable)ex2);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        if (!useIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", useIds, CompareType.INCLUDE));
            view.setFilter(filter);
            sic = new SelectorItemCollection();
            sic.add("bgIndexName");
            sic.add("bgDimName");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            view.getSorter().add(new SorterItemInfo("bgIndexNumber"));
            BgControlSettingCollection _colls = BgControlSettingFactory.getLocalInstance(ctx).getBgControlSettingCollection(view);
            if (_colls != null) {
                colls.addObjectCollection((IObjectCollection)_colls);
            }
        }
        return colls;
    }

    @Override
    protected Object _getBizSystem(Context ctx) throws BOSException, EASBizException {
        String l = ctx.getLocale().getDisplayName();
        String sql = "SELECT FBIZSYSTEM,MAX(FBIZSYSTEMALIAS_L1) FBIZSYSTEMALIAS_L1,MAX(FBIZSYSTEMALIAS_L2) FBIZSYSTEMALIAS_L2,MAX(FBIZSYSTEMALIAS_L3) FBIZSYSTEMALIAS_L3, FBIZUNIT, MAX(FBIZUNITALIAS_L1) FBIZUNITALIAS_L1, MAX(FBIZUNITALIAS_L2) FBIZUNITALIAS_L2, MAX(FBIZUNITALIAS_L3) FBIZUNITALIAS_L3, MAX(FISSYSTEMDEFAULT) FISSYSTEMDEFAULT, MAX(FISOMER) FISOMER FROM T_MBG_BGCONTROLDATA GROUP BY FBIZSYSTEM,FBIZUNIT ORDER BY FBIZSYSTEM";
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        BgControlDataCollection colls = new BgControlDataCollection();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement(sql);
            rs = pmst.executeQuery();
            while (rs.next()) {
                BgControlDataInfo info = new BgControlDataInfo();
                info.setBizSystem(rs.getString("FBIZSYSTEM"));
                info.setBizSystemAlias(rs.getString("FBIZSYSTEMALIAS_L1"), LocaleUtils.locale_l1);
                info.setBizSystemAlias(rs.getString("FBIZSYSTEMALIAS_L2"), LocaleUtils.locale_l2);
                info.setBizSystemAlias(rs.getString("FBIZSYSTEMALIAS_L3"), LocaleUtils.locale_l3);
                info.setBizUnit(rs.getString("FBIZUNIT"));
                info.setBizUnitAlias(rs.getString("FBIZUNITALIAS_L1"), LocaleUtils.locale_l1);
                info.setBizUnitAlias(rs.getString("FBIZUNITALIAS_L2"), LocaleUtils.locale_l2);
                info.setBizUnitAlias(rs.getString("FBIZUNITALIAS_L3"), LocaleUtils.locale_l3);
                info.setIsSystemDefault(rs.getBoolean("FISSYSTEMDEFAULT"));
                info.setIsomer(rs.getBoolean("FISOMER"));
                colls.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return colls;
    }

    @Override
    protected Object _getBizUnitBill(Context ctx, String bizSystemNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bizSystemNumber)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bizSystem");
        sic.add("bizSystemAlias");
        sic.add("bizUnit");
        sic.add("bizUnitAlias");
        sic.add("bizType");
        sic.add("biz");
        sic.add("bizAlias");
        sic.add("isDefault");
        sic.add("isSystemDefault");
        sic.add("isomer");
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("bizUnit", (Object)bizSystemNumber, CompareType.EQUALS));
        SorterItemCollection so = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("bizType");
        so.add(sort);
        view.setSorter(so);
        return BgControlDataFactory.getLocalInstance(ctx).getBgControlDataCollection(view);
    }

    @Override
    protected Object _addBizUnit(Context ctx, Object bizUnits) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Object _deleteBizUnit(Context ctx, Object deleteUnitNumbers) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Object _deleteBatch(Context ctx, Object colls) throws BOSException, EASBizException {
        if (!(colls instanceof BgControlDataCollection)) {
            return null;
        }
        BgControlDataCollection cantDelete = new BgControlDataCollection();
        BgControlDataCollection coll = (BgControlDataCollection)((Object)colls);
        if (coll.isEmpty()) {
            return null;
        }
        for (int index = coll.size() - 1; index >= 0; --index) {
            if (!this.isSystemDefault(ctx, coll.get(index))) continue;
            cantDelete.add(coll.get(index));
            coll.remove(coll.get(index));
        }
        if (coll.isEmpty()) {
            return cantDelete;
        }
        String bizUnit = coll.get(0).getBizUnit();
        String sql = "SELECT FORGUNIT,FDIMITEM,FCURRENCY,FBIZDATE,FREQUESTAMOUNT,FRULECONDITION FROM T_MBG_BGCONTROLRULE WHERE FSCHEMEID IN (SELECT FID FROM T_MBG_BGCONTROLSCHEME WHERE FBIZUNIT=?)";
        HashSet<String> orgNumbers = new HashSet<String>();
        HashSet<String> itemDimNumbers = new HashSet<String>();
        HashSet<String> currencyNumbers = new HashSet<String>();
        HashSet<String> bizDateNumbers = new HashSet<String>();
        HashSet<String> reuqestAmountNumbers = new HashSet<String>();
        HashSet<String> ruleConditionNumbers = new HashSet<String>();
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement(sql);
            pmst.setString(1, bizUnit);
            rs = pmst.executeQuery();
            while (rs.next()) {
                String org = rs.getString("FORGUNIT");
                String item = rs.getString("FDIMITEM");
                String curr = rs.getString("FCURRENCY");
                String bizDate = rs.getString("FBIZDATE");
                String request = rs.getString("FREQUESTAMOUNT");
                String condition = rs.getString("FRULECONDITION");
                if (!StringUtils.isEmpty((String)org)) {
                    orgNumbers.add(org);
                }
                if (!StringUtils.isEmpty((String)item)) {
                    itemDimNumbers.add(item);
                }
                if (!StringUtils.isEmpty((String)curr)) {
                    currencyNumbers.add(curr);
                }
                if (!StringUtils.isEmpty((String)bizDate)) {
                    bizDateNumbers.add(bizDate);
                }
                if (!StringUtils.isEmpty((String)request)) {
                    reuqestAmountNumbers.add(request);
                }
                if (StringUtils.isEmpty((String)condition)) continue;
                ruleConditionNumbers.add(condition);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        for (int index = coll.size() - 1; index >= 0; --index) {
            BgControlDataInfo info = coll.get(index);
            int type = info.getBizType().getValue();
            if (type == 1) {
                if (!this.isInclude(orgNumbers, info.getBiz())) continue;
                cantDelete.add(info);
                coll.remove(info);
                continue;
            }
            if (type == 2) {
                if (!this.isIncludeItemDim(itemDimNumbers, info.getBiz())) continue;
                cantDelete.add(info);
                coll.remove(info);
                continue;
            }
            if (type == 3) {
                if (!this.isInclude(currencyNumbers, info.getBiz())) continue;
                cantDelete.add(info);
                coll.remove(info);
                continue;
            }
            if (type == 4) {
                if (!this.isInclude(bizDateNumbers, info.getBiz())) continue;
                cantDelete.add(info);
                coll.remove(info);
                continue;
            }
            if (type == 5) {
                if (!this.isInclude(reuqestAmountNumbers, info.getBiz())) continue;
                cantDelete.add(info);
                coll.remove(info);
                continue;
            }
            if (type != 6 || !this.isInclude(ruleConditionNumbers, info.getBiz())) continue;
            cantDelete.add(info);
            coll.remove(info);
        }
        if (!coll.isEmpty()) {
            ObjectUuidPK[] pks = new ObjectUuidPK[coll.size()];
            for (int index = 0; index < coll.size(); ++index) {
                pks[index] = new ObjectUuidPK(coll.get(index).getId());
            }
            BgControlDataFactory.getLocalInstance(ctx).deleteBatchData((IObjectPK[])pks);
        }
        return cantDelete;
    }

    private boolean isIncludeItemDim(Set<String> set, String value) {
        if (set == null || set.isEmpty() || StringUtils.isEmpty((String)value)) {
            return false;
        }
        for (String str : set) {
            if (str.indexOf(value) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean isInclude(Set<String> set, String value) {
        if (set == null || set.isEmpty() || StringUtils.isEmpty((String)value)) {
            return false;
        }
        for (String str : set) {
            if (!str.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object _setDefault(Context ctx, Object obj) throws BOSException, EASBizException {
        if (!(obj instanceof BgControlDataInfo)) {
            return null;
        }
        BgControlDataInfo info = (BgControlDataInfo)obj;
        int type = info.getBizType().getValue();
        String bizUnit = info.getBizUnit();
        String updateID = info.getId().toString();
        String sql_updateAll = "UPDATE T_MBG_BGCONTROLDATA SET FISDEFAULT=0 WHERE FBIZUNIT=? AND FBIZTYPE=?";
        String sql_updateSet = "UPDATE T_MBG_BGCONTROLDATA SET FISDEFAULT=1 WHERE FID=?;";
        Connection conn = null;
        PreparedStatement pmstAll = null;
        PreparedStatement pmstSet = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmstAll = conn.prepareStatement(sql_updateAll);
            pmstAll.setString(1, bizUnit);
            pmstAll.setInt(2, type);
            pmstAll.executeUpdate();
            pmstSet = conn.prepareStatement(sql_updateSet);
            pmstSet.setString(1, updateID);
            pmstSet.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pmstSet);
                SQLUtils.cleanup((Statement)pmstAll, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pmstSet);
        SQLUtils.cleanup((Statement)pmstAll, (Connection)conn);
        return null;
    }

    @Override
    protected boolean _checkCanDelete(Context ctx, Object colls) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pmst;
        Connection conn;
        block6: {
            boolean bl;
            if (!(colls instanceof BgControlDataInfo)) {
                return false;
            }
            BgControlDataInfo info = (BgControlDataInfo)colls;
            if (this.isSystemDefault(ctx, info)) {
                return false;
            }
            String sql = "SELECT FID FROM T_MBG_BGCONTROLSCHEME WHERE FBIZUNIT=?";
            conn = null;
            pmst = null;
            rs = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pmst = conn.prepareStatement(sql);
                pmst.setString(1, info.getBizUnit());
                rs = pmst.executeQuery();
                if (!rs.next()) break block6;
                bl = false;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pmst, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return true;
    }

    private boolean isSystemDefault(Context ctx, BgControlDataInfo info) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pmst;
        Connection conn;
        block6: {
            boolean bl;
            block7: {
                if (info == null) {
                    return false;
                }
                conn = null;
                pmst = null;
                rs = null;
                conn = EJBFactory.getConnection((Context)ctx);
                pmst = conn.prepareStatement("SELECT FIsSystemDefault FROM T_MBG_BGCONTROLDATA WHERE FBIZUNIT=? AND FBIZ=? AND FBIZTYPE=?");
                pmst.setString(1, info.getBizUnit());
                pmst.setString(2, info.getBiz());
                pmst.setInt(3, info.getBizType().getValue());
                rs = pmst.executeQuery();
                if (!rs.next()) break block6;
                if (!rs.getBoolean("FIsSystemDefault")) break block7;
                boolean bl2 = true;
                SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
                return bl2;
            }
            try {
                bl = false;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pmst, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return false;
    }

    @Override
    protected boolean _checkCanDelateField(Context ctx, Object obj) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected Object _getCantDeleteColls(Context ctx, Object parameter) throws BOSException, EASBizException {
        if (!(parameter instanceof BgControlDataCollection)) {
            return null;
        }
        BgControlDataCollection cantDelete = new BgControlDataCollection();
        BgControlDataCollection coll = (BgControlDataCollection)((Object)parameter);
        if (coll.isEmpty()) {
            return null;
        }
        for (int index = coll.size() - 1; index >= 0; --index) {
            if (!this.isSystemDefault(ctx, coll.get(index))) continue;
            cantDelete.add(coll.get(index));
            coll.remove(coll.get(index));
        }
        if (coll.isEmpty()) {
            return cantDelete;
        }
        String bizUnit = coll.get(0).getBizUnit();
        String sql = "SELECT FORGUNIT,FDIMITEM,FCURRENCY,FBIZDATE,FREQUESTAMOUNT,FRULECONDITION FROM T_MBG_BGCONTROLRULE WHERE FSCHEMEID IN (SELECT FID FROM T_MBG_BGCONTROLSCHEME WHERE FBIZUNIT=?)";
        HashSet<String> orgNumbers = new HashSet<String>();
        HashSet<String> itemDimNumbers = new HashSet<String>();
        HashSet<String> currencyNumbers = new HashSet<String>();
        HashSet<String> bizDateNumbers = new HashSet<String>();
        HashSet<String> reuqestAmountNumbers = new HashSet<String>();
        HashSet<String> ruleConditionNumbers = new HashSet<String>();
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement(sql);
            pmst.setString(1, bizUnit);
            rs = pmst.executeQuery();
            while (rs.next()) {
                String org = rs.getString("FORGUNIT");
                String item = rs.getString("FDIMITEM");
                String curr = rs.getString("FCURRENCY");
                String bizDate = rs.getString("FBIZDATE");
                String request = rs.getString("FREQUESTAMOUNT");
                String condition = rs.getString("FRULECONDITION");
                if (!StringUtils.isEmpty((String)org)) {
                    orgNumbers.add(org);
                }
                if (!StringUtils.isEmpty((String)item)) {
                    itemDimNumbers.add(item);
                }
                if (!StringUtils.isEmpty((String)curr)) {
                    currencyNumbers.add(curr);
                }
                if (!StringUtils.isEmpty((String)bizDate)) {
                    bizDateNumbers.add(bizDate);
                }
                if (!StringUtils.isEmpty((String)request)) {
                    reuqestAmountNumbers.add(request);
                }
                if (StringUtils.isEmpty((String)condition)) continue;
                ruleConditionNumbers.add(condition);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        for (int index = coll.size() - 1; index >= 0; --index) {
            BgControlDataInfo info = coll.get(index);
            int type = info.getBizType().getValue();
            if (type == 1) {
                if (!this.isInclude(orgNumbers, info.getBiz())) continue;
                cantDelete.add(info);
                coll.remove(info);
                continue;
            }
            if (type == 2) {
                if (!this.isIncludeItemDim(itemDimNumbers, info.getBiz())) continue;
                cantDelete.add(info);
                coll.remove(info);
                continue;
            }
            if (type == 3) {
                if (!this.isInclude(currencyNumbers, info.getBiz())) continue;
                cantDelete.add(info);
                coll.remove(info);
                continue;
            }
            if (type == 4) {
                if (!this.isInclude(bizDateNumbers, info.getBiz())) continue;
                cantDelete.add(info);
                coll.remove(info);
                continue;
            }
            if (type == 5) {
                if (!this.isInclude(reuqestAmountNumbers, info.getBiz())) continue;
                cantDelete.add(info);
                coll.remove(info);
                continue;
            }
            if (type != 6 || !this.isInclude(ruleConditionNumbers, info.getBiz())) continue;
            cantDelete.add(info);
            coll.remove(info);
        }
        return cantDelete;
    }

    @Override
    protected Map _checkDimenbers(Context ctx, String orgUnitId, List indexAndDimStrLst) throws BOSException, EASBizException {
        HashMap<String, HashSet<String>> resultMap = new HashMap<String, HashSet<String>>();
        if (orgUnitId == null || indexAndDimStrLst == null || indexAndDimStrLst.isEmpty()) {
            return null;
        }
        int size = indexAndDimStrLst.size();
        String indexAndDimNum = null;
        HashMap<String, HashMap<String, Object>> memberMap = this.getLongNumberMap(ctx, orgUnitId, indexAndDimStrLst);
        HashMap<String, String> dimMemberSrcMap = new HashMap<String, String>();
        for (String s : memberMap.keySet()) {
            HashMap<String, Object> vMap = memberMap.get(s);
            for (String d : vMap.keySet()) {
                dimMemberSrcMap.put(((CoreBaseInfo)vMap.get(d)).getId().toString(), s);
            }
        }
        HashMap sMap = new HashMap();
        HashMap<String, Cloneable> tMap = null;
        HashMap<String, Object> mMap = null;
        String INDEX_C = "Index";
        String DIM_C = "Dim";
        for (int i = 0; i < size; ++i) {
            tMap = new HashMap<String, Cloneable>();
            indexAndDimNum = (String)indexAndDimStrLst.get(i);
            String[] arrStr = indexAndDimNum.split(";");
            String index = arrStr[1];
            String dim = arrStr[2];
            if (index != null && index.contains(":")) {
                String srcNum = index.split(":")[0];
                String indNum = index.split(":")[1];
                String k2 = null;
                for (String k2 : memberMap.get(srcNum).keySet()) {
                    if (!indNum.equals(k2)) continue;
                    mMap = new HashMap<String, Object>();
                    mMap.put(k2, memberMap.get(srcNum).get(k2));
                    tMap.put("Index", mMap);
                }
            }
            ArrayList lst = null;
            if (dim != null) {
                lst = new ArrayList();
                if (dim.contains(",")) {
                    String[] dimArr = dim.split(",");
                    for (int j = 0; j < dimArr.length; ++j) {
                        String dimN = dimArr[j];
                        if (!dimN.contains(":")) continue;
                        String srcNum = dimN.split(":")[0];
                        String dinMum = dimN.split(":")[1];
                        String k3 = null;
                        for (String k3 : memberMap.get(srcNum).keySet()) {
                            if (!dinMum.equals(k3)) continue;
                            mMap = new HashMap();
                            mMap.put(k3, memberMap.get(srcNum).get(k3));
                            lst.add(mMap);
                        }
                    }
                } else if (dim.contains(":")) {
                    String srcNum = dim.split(":")[0];
                    String dinMum = dim.split(":")[1];
                    String k4 = null;
                    for (String k4 : memberMap.get(srcNum).keySet()) {
                        if (!dinMum.equals(k4)) continue;
                        mMap = new HashMap();
                        mMap.put(k4, memberMap.get(srcNum).get(k4));
                        lst.add(mMap);
                    }
                }
                tMap.put("Dim", lst);
            }
            sMap.put(indexAndDimNum, tMap);
        }
        HashMap indexMemberSortMap = new HashMap();
        HashMap dimMemberSortMap = new HashMap();
        if (!sMap.isEmpty()) {
            HashMap srcValue;
            String keyNum2 = null;
            Map valueMap = null;
            for (String keyNum2 : sMap.keySet()) {
                valueMap = (Map)sMap.get(keyNum2);
                Map indexMap = (Map)valueMap.get("Index");
                if (indexMap == null || indexMap.values() == null) continue;
                for (BgAccountInfo accMember : indexMap.values()) {
                    if (accMember.getLongNumber() == null) continue;
                    String srcNu = DimensionBaseConstants.DEF_INDEX_SRCNUMBER;
                    if (indexMemberSortMap.containsKey(srcNu)) {
                        ((HashMap)indexMemberSortMap.get(srcNu)).put(keyNum2, accMember.getLongNumber());
                        continue;
                    }
                    HashMap<String, String> ttmap = new HashMap<String, String>();
                    ttmap.put(keyNum2, accMember.getLongNumber());
                    indexMemberSortMap.put(srcNu, ttmap);
                }
                List dimList = (List)valueMap.get("Dim");
                for (Map dimMap : dimList) {
                    for (MbgMemberInfo dimMember : dimMap.values()) {
                        if (dimMember.getLongNumber() == null || dimMemberSrcMap.isEmpty() || !dimMemberSrcMap.containsKey(dimMember.getId().toString())) continue;
                        String srcNu = (String)dimMemberSrcMap.get(dimMember.getId().toString());
                        if (dimMemberSortMap.containsKey(srcNu)) {
                            ((HashMap)dimMemberSortMap.get(srcNu)).put(keyNum2, dimMember.getLongNumber());
                            continue;
                        }
                        HashMap<String, String> ttmap = new HashMap<String, String>();
                        ttmap.put(keyNum2, dimMember.getLongNumber());
                        dimMemberSortMap.put(srcNu, ttmap);
                    }
                }
            }
            if (!indexMemberSortMap.isEmpty()) {
                HashSet<String> indxKeyNums = new HashSet<String>();
                for (String srcKey : indexMemberSortMap.keySet()) {
                    srcValue = (HashMap)indexMemberSortMap.get(srcKey);
                    if (srcValue.isEmpty()) continue;
                    this.checkIsLeaf(srcValue, indxKeyNums);
                }
                resultMap.put("Index", indxKeyNums);
            }
            if (!dimMemberSortMap.isEmpty()) {
                HashSet<String> dimKeyNums = new HashSet<String>();
                for (String srcKey : dimMemberSortMap.keySet()) {
                    srcValue = (HashMap)dimMemberSortMap.get(srcKey);
                    if (srcValue.isEmpty()) continue;
                    this.checkIsLeaf(srcValue, dimKeyNums);
                }
                resultMap.put("Dim", dimKeyNums);
            }
        }
        return resultMap;
    }

    private HashMap<String, HashMap<String, Object>> getLongNumberMap(Context ctx, String orgUnitId, List indexAndDimStrLst) throws EASBizException, BOSException {
        HashMap<String, HashMap<String, Object>> resultMap = new HashMap<String, HashMap<String, Object>>();
        String indexAndDimStr = null;
        HashMap numberSet = new HashMap();
        String bgSchemeId = indexAndDimStrLst.get(0).toString().split(";")[0];
        HashMap<String, String> viewMap = this.getIndexAndDimViewBySchemeId(ctx, orgUnitId, bgSchemeId);
        for (int i = 0; i < indexAndDimStrLst.size(); ++i) {
            indexAndDimStr = indexAndDimStrLst.get(i).toString();
            String indexNum = indexAndDimStr.split(";")[1];
            String dimNum = indexAndDimStr.split(";")[2];
            if (indexNum != null && indexNum.contains(":")) {
                String srcNum = indexNum.split(":")[0];
                String indNum = indexNum.split(":")[1];
                if (!numberSet.containsKey(srcNum)) {
                    numberSet.put(srcNum, new HashSet());
                }
                ((HashSet)numberSet.get(srcNum)).add(indNum);
            }
            if (StringUtils.isEmpty((String)dimNum) || "null".equals(dimNum)) continue;
            if (dimNum.contains(",")) {
                String[] dimArray = dimNum.split(",");
                for (int j = 0; j < dimArray.length; ++j) {
                    String dimSrc = dimArray[j].split(":")[0];
                    if (dimArray[j].split(":").length <= 1) continue;
                    String dimMemberNum = dimArray[j].split(":")[1];
                    if (!numberSet.containsKey(dimSrc)) {
                        numberSet.put(dimSrc, new HashSet());
                    }
                    ((HashSet)numberSet.get(dimSrc)).add(dimMemberNum);
                }
                continue;
            }
            if (dimNum.indexOf(":") < 1) continue;
            String dimSrc = dimNum.split(":")[0];
            String dimMemberNum = dimNum.split(":")[1];
            if (!numberSet.containsKey(dimSrc)) {
                numberSet.put(dimSrc, new HashSet());
            }
            ((HashSet)numberSet.get(dimSrc)).add(dimMemberNum);
        }
        HashSet memberSet = null;
        IBgAccount iBgAccount = BgAccountFactory.getLocalInstance((Context)ctx);
        IMbgMember iMbgMember = MbgMemberFactory.getLocalInstance((Context)ctx);
        BgAccountCollection bgAccountColls = null;
        MbgMemberCollection mbgMemberColls = null;
        EntityViewInfo evi = null;
        FilterInfo filter = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        HashMap<String, Object> memberMap = null;
        if (!numberSet.isEmpty()) {
            for (String srcNum : numberSet.keySet()) {
                int i;
                memberSet = (HashSet)numberSet.get(srcNum);
                evi = new EntityViewInfo();
                filter = new FilterInfo();
                evi.setFilter(filter);
                evi.setSelector(sic);
                if (srcNum.equals(DimensionBaseConstants.DEF_INDEX_SRCNUMBER)) {
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)memberSet, CompareType.INCLUDE));
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("bgaccountview.id", (Object)viewMap.get(srcNum), CompareType.EQUALS));
                    bgAccountColls = iBgAccount.getBgAccountCollection(evi);
                    memberMap = new HashMap<String, Object>();
                    for (i = 0; i < bgAccountColls.size(); ++i) {
                        memberMap.put(bgAccountColls.get(i).getNumber(), bgAccountColls.get(i));
                    }
                    if (resultMap.containsKey(srcNum)) continue;
                    resultMap.put(srcNum, memberMap);
                    continue;
                }
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)memberSet, CompareType.INCLUDE));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("viewid", (Object)viewMap.get(srcNum), CompareType.EQUALS));
                mbgMemberColls = iMbgMember.getMbgMemberCollection(evi);
                memberMap = new HashMap();
                for (i = 0; i < mbgMemberColls.size(); ++i) {
                    memberMap.put(mbgMemberColls.get(i).getNumber(), mbgMemberColls.get(i));
                }
                if (resultMap.containsKey(srcNum)) continue;
                resultMap.put(srcNum, memberMap);
            }
        }
        return resultMap;
    }

    private HashMap<String, String> getIndexAndDimViewBySchemeId(Context ctx, String orgUnitId, String bgSchemeId) throws EASBizException, BOSException {
        int i;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (ctx == null || StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)bgSchemeId)) {
            return resultMap;
        }
        BgDimSettingsCollection settings = BgDimSettingsFactory.getLocalInstance((Context)ctx).getBgDimSettingsCollection("select id ,dimNumber where bgscheme.id = '" + bgSchemeId + "' and dimNumber not in('BG_Scenario','BG_Currency','BG_Version','BG_Element','BG_Organization','BG_Period')");
        HashMap<String, String> settingsMap = new HashMap<String, String>();
        HashSet<String> settingsIds = new HashSet<String>();
        BgDimSettingsInfo settingsInfo = null;
        String settingsId = null;
        String memberId = null;
        MbgDimCollection mbgDimColls = MbgDimFactory.getLocalInstance((Context)ctx).getMbgDimCollection("select ID, Name , Number, SrcNumber");
        HashMap<String, String> dimNumberMap = new HashMap<String, String>();
        for (i = 0; i < mbgDimColls.size(); ++i) {
            dimNumberMap.put(mbgDimColls.get(i).getNumber(), mbgDimColls.get(i).getSrcNumber());
        }
        for (i = 0; i < settings.size(); ++i) {
            settingsInfo = settings.get(i);
            if (settingsInfo.getDimNumber().equals(DimensionBaseConstants.DEF_ACCOUNT_NUMBER)) {
                settingsMap.put(settingsInfo.getId().toString(), DimensionBaseConstants.DEF_INDEX_SRCNUMBER);
            } else {
                settingsMap.put(settingsInfo.getId().toString(), (String)dimNumberMap.get(settingsInfo.getDimNumber()));
            }
            settingsIds.add(settingsInfo.getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgdimsettings.id");
        sic.add("memberid");
        filter.getFilterItems().add(new FilterItemInfo("bgdimsettings.id", settingsIds, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        BgDimSettingsMemberCollection settingMemberColls = BgDimSettingsMemberFactory.getLocalInstance((Context)ctx).getBgDimSettingsMemberCollection(evi);
        for (int i2 = 0; i2 < settingMemberColls.size(); ++i2) {
            settingsId = settingMemberColls.get(i2).getBgDimSettings().getId().toString();
            memberId = settingMemberColls.get(i2).getMemberID().toString();
            if (settingsMap.containsKey(settingsId) && ((String)settingsMap.get(settingsId)).equals("BG_Account")) {
                resultMap.put(DimensionBaseConstants.DEF_INDEX_SRCNUMBER, memberId);
                continue;
            }
            resultMap.put((String)settingsMap.get(settingsId), memberId);
        }
        return resultMap;
    }

    private void checkIsLeaf(HashMap<String, String> srcMap, HashSet<String> indxKeyNums) {
        if (srcMap.isEmpty()) {
            return;
        }
        HashMap<String, String> srcTempMap = new HashMap<String, String>(srcMap);
        for (String key : srcMap.keySet()) {
            String value = srcMap.get(key);
            for (String tempKey : srcTempMap.keySet()) {
                String tempValue = srcTempMap.get(tempKey);
                if (!tempValue.startsWith(value + "!")) continue;
                indxKeyNums.add(key + "#" + tempKey);
            }
        }
    }

    @Override
    protected String _getMaxGroupNo(Context ctx, String orgUnitId, String bgCtrlSchemeId) throws BOSException, EASBizException {
        String maxNo = "0";
        if (StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)bgCtrlSchemeId)) {
            return maxNo;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String sql = "Select Max(FGROUPNO) FROM T_MBG_BgControlSetting where FSchemeID = '" + bgCtrlSchemeId + "' And FOrgUnitID = '" + orgUnitId + "'";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                maxNo = rst.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return maxNo;
    }
}

