/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodSumEnum;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgUpperGatherEnum;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodDispHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.control.BgControlRecordObj;
import com.kingdee.eas.ma.control.app.AbstractMBgAnalyseFacadeControllerBean;
import com.kingdee.eas.ma.control.query.ExeFilterParam;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.MetaUtils;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.query.BgAnalyseConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MBgAnalyseFacadeControllerBean
extends AbstractMBgAnalyseFacadeControllerBean {
    private static final long serialVersionUID = -6706616573651362844L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.MBgAnalyseFacadeControllerBean");

    @Override
    protected List _getAnalyseMember(Context ctx, String bgSchemeId, BOSUuid orgUnitId, Collection dimMember) throws BOSException, EASBizException {
        ArrayList<AnalyseMember> members = new ArrayList<AnalyseMember>();
        if (orgUnitId == null || dimMember == null || dimMember.isEmpty()) {
            return members;
        }
        Map result = DimensionFormulaFacadeFactory.getLocalInstance((Context)ctx).getDimensionCombName(bgSchemeId, dimMember, orgUnitId.toString(), false);
        if (result != null) {
            String dimNumber2 = null;
            Object dimName = null;
            String srcNumber = null;
            String number = null;
            String refField = null;
            String[] tmpNums = null;
            String[] tmpStrs = null;
            List dimNameList = null;
            AnalyseMember member = null;
            BgDimensionMember bgMember = null;
            BgSchemeDimensionHelper bgSchemeDimensionHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
            Map dimensionByRefField = bgSchemeDimensionHelper.getDimensionByRefField();
            Map sourceMap = DimUtils.getDimSourceMap((Context)ctx);
            for (String dimNumber2 : dimMember) {
                dimNameList = (List)result.get(dimNumber2);
                member = new AnalyseMember();
                tmpNums = dimNumber2.split(",");
                if (tmpNums != null && dimNameList != null && tmpNums.length == dimNameList.size()) {
                    int in = tmpNums.length;
                    for (int i = 0; i < in; ++i) {
                        tmpStrs = tmpNums[i].split(":");
                        srcNumber = tmpStrs[0];
                        number = tmpStrs[1];
                        refField = (String)sourceMap.get(srcNumber);
                        if (DimensionConstants.DEF_BGINDEX_FIELD.equals(refField)) {
                            bgMember = new BgDimensionMember(DimensionBaseConstants.DEF_ACCOUNT_NUMBER, refField, (String)dimNameList.get(i), number);
                            bgMember.setSrcNumber(srcNumber);
                            member.setBgIndex(bgMember);
                            continue;
                        }
                        if (member.getDimMember() == null) {
                            bgMember = new BgDimensionMember(((BgDimensionInfo)dimensionByRefField.get(refField)).getType(), refField, (String)dimNameList.get(i), number);
                            bgMember.setSrcNumber(srcNumber);
                            member.setDimMember(bgMember);
                            continue;
                        }
                        bgMember = member.getDimMember();
                        bgMember.setAttribute(bgMember.getAttribute() + "," + refField);
                        bgMember.setSrcNumber(bgMember.getSrcNumber() + "," + srcNumber);
                        bgMember.setNumber(bgMember.getNumber() + "," + number);
                        bgMember.setName(bgMember.getName() + "," + (String)dimNameList.get(i));
                        String type = dimensionByRefField.get(refField) == null ? number : ((BgDimensionInfo)dimensionByRefField.get(refField)).getType();
                        bgMember.setType(bgMember.getType() + "," + type);
                    }
                }
                members.add(member);
            }
            Collections.sort(members, new Comparator<AnalyseMember>(){

                @Override
                public int compare(AnalyseMember m1, AnalyseMember m2) {
                    String dimNumber1 = m1.getBgIndex().getSrcNumber() + ":" + m1.getBgIndex().getNumber();
                    String dimNumber2 = m2.getBgIndex().getSrcNumber() + ":" + m2.getBgIndex().getNumber();
                    return dimNumber1.compareTo(dimNumber2);
                }
            });
        }
        return members;
    }

    @Override
    protected List _queryExecute(Context ctx, List paramList) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        if (paramList == null || paramList.isEmpty()) {
            return paramList;
        }
        BgActualRecordInfo actualRecord = new BgActualRecordInfo();
        EntityObjectInfo enObj = MetaUtils.getEntity((Context)ctx, (BOSObjectType)actualRecord.getBOSType());
        for (Object param : paramList) {
            ExeFilterParam filterParam = (ExeFilterParam)((Object)param);
            List list = this._queryExecute(ctx, (FilterParam)filterParam);
            if (list == null) continue;
            if (filterParam.isOnlyAddActual() && paramList.size() > 1) {
                for (Object obj : list) {
                    Object[] query = (Object[])obj;
                    if (query[BgAnalyseConstants.ANALYSE_BILL_NUMBER] != null) continue;
                    query[BgAnalyseConstants.ANALYSE_BILL_TYPE] = enObj.getAlias();
                }
            }
            result.addAll(list);
        }
        return result;
    }

    @Override
    protected List _queryExecute(Context ctx, FilterParam param) throws BOSException, EASBizException {
        Map result;
        HashSet<String> numberSet;
        Object[] objs;
        String[] tmpStrs;
        String number;
        String srcNumber;
        IRowSet rst;
        Connection conn;
        BgPeriodCollection colls;
        HashSet<String> periodNumbers;
        String[] srcNumbers;
        String accountViewId;
        String bgOrgViewId;
        BgSchemeDimensionHelper schemeHelper;
        BgSchemeInfo rootScheme;
        String tmpBgIndexName;
        String tmpPeriodName;
        String tmpOrgUnitName;
        TempTablePool pool;
        ExeFilterParam _param;
        ArrayList<Object[]> querys;
        block96: {
            BgPeriodInfo beginPeriod;
            BgPeriodTypeInfo bgPeriodTypeInfo;
            boolean onlySelfDefinedPeriod;
            querys = new ArrayList<Object[]>();
            if (!(param instanceof ExeFilterParam)) {
                return querys;
            }
            _param = (ExeFilterParam)param;
            ArrayList<Object> sqlParams = new ArrayList<Object>();
            ArrayList<String> sqlKeys = new ArrayList<String>();
            pool = TempTablePool.getInstance((Context)ctx);
            tmpOrgUnitName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FLongNumber NVarchar(1024))");
            tmpPeriodName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FLongNumber NVarchar(512))");
            tmpBgIndexName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FBgIndexNum NVARCHAR(80), FNumber NVarchar(80), FLongNumber NVarchar(1024))");
            rootScheme = BgViewServerHelper.getBgSchemeCubeInfo((Context)ctx, (BOSUuid)_param.getBgScheme().getId());
            schemeHelper = new BgSchemeDimensionHelper(ctx, _param.getBgScheme().getId().toString());
            bgOrgViewId = schemeHelper.getBgOrgViewId();
            accountViewId = schemeHelper.getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId();
            List accAndOther = schemeHelper.getAccAndOtherDim(false);
            srcNumbers = new String[accAndOther.size()];
            for (int i = 0; i < accAndOther.size(); ++i) {
                srcNumbers[i] = schemeHelper.getSrcNumber((String)accAndOther.get(i));
            }
            periodNumbers = new HashSet<String>();
            colls = new BgPeriodCollection();
            if (_param.getBgPeriods() instanceof BgPeriodInfo[]) {
                for (int i = 0; i < _param.getBgPeriods().length; ++i) {
                    colls.add(_param.getBgPeriods()[i]);
                    periodNumbers.add(_param.getBgPeriods()[i].getNumber());
                }
            } else if (_param.getBeginPeriod() != null && _param.getEndPeriod() != null) {
                colls = BgPeriodDispHelper.getPeriodColls((Context)ctx, (BOSUuid)_param.getBgPeriodType().getId(), (int)_param.getBeginPeriod().getPeriodType().getValue(), (Date)_param.getBeginPeriod().getBeginDate(), (Date)_param.getEndPeriod().getEndDate());
            } else if (_param.getStart() != null && _param.getBeover() != null) {
                colls = BgPeriodDispHelper.getPeriodColls((Context)ctx, (BOSUuid)_param.getBgPeriodType().getId(), null, (Date)_param.getStart(), (Date)_param.getBeover());
            }
            if (_param.getBgPeriodType() != null && (onlySelfDefinedPeriod = BgNPeriodHelper.isOnlySelfDefinedPeriod((BgPeriodTypeInfo)(bgPeriodTypeInfo = BgPeriodDispHelper.getBgPeriodTypeInfo((Context)ctx, (BOSUuid)_param.getBgPeriodType().getId())))) && _param.getBeginPeriod() != null && (beginPeriod = _param.getBeginPeriod()).isIsLeaf()) {
                Iterator iterator = colls.iterator();
                while (iterator.hasNext()) {
                    BgPeriodInfo periodInfo = (BgPeriodInfo)iterator.next();
                    if (periodInfo.isIsLeaf()) continue;
                    iterator.remove();
                }
            }
            String controlCube = BgCubeUtils.getControlCubeName((String)rootScheme.getRefCube());
            String dimNumber = null;
            List dimList = null;
            HashSet<String> dimSet = null;
            HashMap bgIndexMap = new HashMap();
            for (AnalyseMember member : _param.getMembers()) {
                dimNumber = member.getBgIndex().getSrcNumber() + ":" + member.getBgIndex().getNumber();
                if (bgIndexMap.containsKey(dimNumber)) {
                    dimList = (List)bgIndexMap.get(dimNumber);
                } else {
                    dimList = new ArrayList();
                    bgIndexMap.put(dimNumber, dimList);
                }
                dimSet = new HashSet<String>();
                if (member.getDimMember() != null) {
                    if (member.getDimMember().getAttribute().indexOf(",") > 0) {
                        String[] srcStrs = member.getDimMember().getSrcNumber().split(",");
                        String[] numStrs = member.getDimMember().getNumber().split(",");
                        if (srcStrs != null && numStrs != null && srcStrs.length == numStrs.length) {
                            int in = srcStrs.length;
                            for (int i = 0; i < in; ++i) {
                                dimNumber = srcStrs[i] + ":" + numStrs[i];
                                dimSet.add(dimNumber);
                            }
                        }
                    } else {
                        dimNumber = member.getDimMember().getSrcNumber() + ":" + member.getDimMember().getNumber();
                        dimSet.add(dimNumber);
                    }
                }
                dimList.add(dimSet);
            }
            BgControlRecordObj bgControl = new BgControlRecordObj();
            StringBuffer sql = new StringBuffer();
            sql.append("select t.FID, t.FBillID, t.FBillNumber, t.FBillType, t.FBizOrgUnitID, u.FName_" + ctx.getLocale() + " AS FBizOrgUnitName, t.FReqOrgUnitID, uu.FName_" + ctx.getLocale() + " AS FReqOrgUnitName, t.FBizDate, t.FCreateTime, t.FBgIndexNum, t.FItemExtNumber, t.FActaulAmount, t.FBgPeriodID, p.FNumber AS PNumber, p.FName_" + ctx.getLocale() + " AS PName, t.FCurrencyID, c.FNumber AS CNumber, c.FName_" + ctx.getLocale() + " AS CName, t.FScenario, s.FNumber AS SNumber, s.FName_" + ctx.getLocale() + " AS SName, t.Fversion, v.FNumber AS VNumber, v.FName_" + ctx.getLocale() + " AS VName, t.FBgElementID, e.FNumber AS ENumber, e.FName_" + ctx.getLocale() + " AS EName, m.FName_" + ctx.getLocale() + " AS MName, n.FName_" + ctx.getLocale() + " AS NName from " + controlCube + " t left join T_MBG_BgControlIsomerConnect n on t.FConnectionID = n.FID left join T_MBG_BgControlIsomer m on t.FIsomerID = m.FID left join T_ORG_BaseUnit u on t.FBizOrgUnitID = u.FID left join T_ORG_BaseUnit uu on t.FReqOrgUnitID = uu.FID left join T_MBG_BgPeriod p on t.FBgPeriodID = p.FID left join T_BD_Currency c on t.FCurrencyID = c.FID left join T_MBG_Bgscenario s on t.FScenario = s.FscenarioID left join T_MBG_BgVersion v on t.FVersion = v.FVersionID left join T_MBG_BgElement e on t.FBgElementID = e.FID where t.FBizOrgUnitID IN (select FID from " + tmpOrgUnitName + ") ");
            if (_param.isOnlyAddActual()) {
                sql.append("and t.FBillType = '" + bgControl.getBOSType() + "'");
            }
            if (!_param.getMembers().isEmpty()) {
                sql.append("and t.FBgIndexNum IN (select FBgIndexNum from " + tmpBgIndexName + ") ");
            }
            sql.append("and t.FBgPeriodID IN (select FID FROM " + tmpPeriodName + ") ");
            if (_param.getCurrency() != null) {
                sql.append(" and t.FCurrencyID = ?");
                sqlParams.add(_param.getCurrency().getId().toString());
            }
            if (_param.getBgElement() != null) {
                sql.append(" and t.FBgElementID = ?");
                sqlParams.add(_param.getBgElement().getId().toString());
            }
            if (_param.getBgScenario() != null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("scenarioId");
                BgScenarioInfo bgScenarioInfo = BgScenarioFactory.getLocalInstance((Context)ctx).getBgScenarioInfo((IObjectPK)new ObjectSingleKey((Object)_param.getBgScenario().getId().toString()), selector);
                sql.append(" and t.FSCENARIO = ?");
                sqlParams.add(bgScenarioInfo.getScenarioId());
            }
            sql.append(" and t.FActaulAmount <> 0 ");
            sql.append(" order by u.FLongNumber, t.FBgIndexNum, s.FNumber, p.FNumber, e.FNumber, c.FNumber, t.FItemExtNumber, t.FBizDate");
            conn = null;
            rst = null;
            boolean include = false;
            String tmpStr = null;
            srcNumber = null;
            number = null;
            String isomerName = null;
            tmpStrs = null;
            objs = null;
            HashMap<String, EntityObjectInfo> billTypeMap = new HashMap<String, EntityObjectInfo>();
            HashMap<String, String> companyMap = new HashMap<String, String>();
            numberSet = new HashSet<String>();
            HashMap memberMap = new HashMap();
            conn = this.getConnection(ctx);
            BgCubeUtils.checkIsomerField((Connection)conn, (String)controlCube);
            BgOrgUnitCollection orgCol = BgOrgUnitFactory.getLocalInstance((Context)ctx).getBgOrgUnitCollection("select id, orgUnitId, number, longNumber, isVirtual, parent.id where viewId = '" + bgOrgViewId + "'");
            Map bgOrgUnitMap = BgCommHelper.transeToMap((IObjectCollection)orgCol);
            HashMap<String, BgOrgUnitInfo> orgUnitMap = new HashMap<String, BgOrgUnitInfo>();
            HashMap<String, Set<String>> childMap = new HashMap<String, Set<String>>();
            Set orgDataPerIds = MbgPermissionFactory.getLocalInstance((Context)ctx).getBgOrgUnitPermission(null, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), rootScheme.getId().toString());
            for (int i = 0; i < orgCol.size(); ++i) {
                BgOrgUnitInfo info = orgCol.get(i);
                if (!info.isIsVirtual()) {
                    orgUnitMap.put(info.getOrgUnitID(), info);
                }
                if (info.getParent() == null || info.getParent().getId().equals((Object)info.getId())) continue;
                String parentOrgId = ((BgOrgUnitInfo)bgOrgUnitMap.get(info.getParent().getId().toString())).getOrgUnitID();
                if (!childMap.containsKey(parentOrgId)) {
                    childMap.put(parentOrgId, new HashSet());
                }
                ((Set)childMap.get(parentOrgId)).add(info.getOrgUnitID());
            }
            ArrayList<Object[]> orgParams = new ArrayList<Object[]>();
            if (_param.getBgOrgUnits() != null && _param.getBgOrgUnits().length > 0) {
                _param.getOrgUnits().clear();
                for (int i = 0; i < _param.getBgOrgUnits().length; ++i) {
                    if (orgDataPerIds != null && !orgDataPerIds.isEmpty() && !orgDataPerIds.contains(_param.getBgOrgUnits()[i].getOrgUnitID())) continue;
                    _param.getOrgUnits().add(_param.getBgOrgUnits()[i].castToFullOrgUnitInfo());
                }
            }
            for (OrgUnitInfo orgUnit : _param.getOrgUnits()) {
                String orgId = orgUnit.getId().toString();
                BgOrgUnitInfo bgOrgUnit = (BgOrgUnitInfo)orgUnitMap.get(orgId);
                orgParams.add(new Object[]{bgOrgUnit.getOrgUnitID(), bgOrgUnit.getLongNumber()});
                this.addChild(orgParams, childMap, orgId, bgOrgUnit.getLongNumber(), orgUnitMap);
            }
            BgDBUtils.executeBatch((Connection)conn, (String)("Insert Into " + tmpOrgUnitName + "(FID, FLongNumber) Values(?, ?)"), orgParams);
            sqlKeys.clear();
            if (!_param.getMembers().isEmpty()) {
                for (AnalyseMember member : _param.getMembers()) {
                    tmpStr = member.getBgIndex().getNumber();
                    sqlKeys.add(tmpStr);
                }
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpBgIndexName + " (FNumber) values (?)"), sqlKeys);
                BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpBgIndexName + " t0 Set FLongNumber = (Select FLongNumber || '!' FROM T_MBG_BgAccount Where FNumber = t0.FNumber AND FBgAccountViewID = ?)"), (Object[])new Object[]{accountViewId});
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpBgIndexName + "(FNumber, FLongNumber) Select cAcc.FNumber, cAcc.FLongNumber FROM T_MBG_BgAccount cAcc, " + tmpBgIndexName + " pAcc Where cAcc.FBgAccountViewID = ? AND CHARINDEX(pAcc.FLongNumber, cAcc.FLongNumber) = 1"), (Object[])new Object[]{accountViewId});
                BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpBgIndexName + " Set FBgIndexNum = '" + DimensionConstants.DEF_INDEX_SRCNUMBER + ":" + "' || FNumber"));
            }
            sqlKeys.clear();
            if (colls != null) {
                BgPeriodInfo bgPeriodInfo = null;
                int in = colls.size();
                for (int i = 0; i < in; ++i) {
                    bgPeriodInfo = colls.get(i);
                    sqlKeys.add(bgPeriodInfo.getId().toString());
                }
            } else {
                sqlKeys.add(_param.getBeginPeriod().getId().toString());
                sqlKeys.add(_param.getEndPeriod().getId().toString());
            }
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpPeriodName + " (FID) values (?)"), sqlKeys);
            BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpPeriodName + " t0 Set FLongNumber = (Select FLongNumber || '!' FROM T_MBG_BgPeriod Where FID = t0.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpPeriodName + "(FID, FLongNumber) Select cPeriod.FID, cPeriod.FLongNumber FROM T_MBG_BgPeriod cPeriod, " + tmpPeriodName + " pPeriod Where CHARINDEX(pPeriod.FLongNumber, cPeriod.FLongNumber) = 1"));
            dimSet = new HashSet();
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), sqlParams);
            boolean isomer = false;
            while (rst.next()) {
                include = false;
                objs = new Object[33];
                objs[BgAnalyseConstants.ANALYSE_ID] = rst.getString("FID");
                objs[BgAnalyseConstants.ANALYSE_BILL_ID] = rst.getString("FBillID");
                objs[BgAnalyseConstants.ANALYSE_BILL_NUMBER] = rst.getString("FBillNumber");
                tmpStr = rst.getString("FBillType");
                isomerName = rst.getString("MName");
                if (StringUtils.isEmpty((String)isomerName)) {
                    if (!billTypeMap.containsKey(tmpStr)) {
                        EntityObjectInfo enObj = null;
                        BOSObjectType type = BOSObjectType.create((String)tmpStr);
                        if (type.equals((Object)bgControl.getBOSType())) {
                            BgActualRecordInfo actualRecord = new BgActualRecordInfo();
                            enObj = MetaUtils.getEntity((Context)ctx, (BOSObjectType)actualRecord.getBOSType());
                        } else {
                            enObj = MetaUtils.getEntity((Context)ctx, (BOSObjectType)type);
                        }
                        billTypeMap.put(tmpStr, enObj);
                    }
                    objs[BgAnalyseConstants.ANALYSE_BILL_ENTITY] = ((EntityObjectInfo)billTypeMap.get(tmpStr)).getFullName();
                    objs[BgAnalyseConstants.ANALYSE_BILL_TYPE] = ((EntityObjectInfo)billTypeMap.get(tmpStr)).getAlias();
                    objs[BgAnalyseConstants.ANALYSE_ISOMER_CONNAME] = null;
                } else {
                    objs[BgAnalyseConstants.ANALYSE_BILL_TYPE] = isomerName;
                    objs[BgAnalyseConstants.ANALYSE_ISOMER_CONNAME] = rst.getString("NName");
                    objs[BgAnalyseConstants.ANALYSE_BILL_NUMBER] = "";
                    isomer = true;
                }
                objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID] = rst.getString("FBizOrgUnitID");
                if (companyMap.containsKey(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID])) {
                    objs[BgAnalyseConstants.ANALYSE_COMAPNY_ID] = companyMap.get(objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID]);
                } else {
                    String companyId = null;
                    try {
                        CompanyOrgUnitInfo company = BgViewServerHelper.getCompanyFromOrgUnit((Context)ctx, (BOSUuid)BOSUuid.read((String)((String)objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID])));
                        companyId = company != null ? company.getId().toString() : null;
                        companyMap.put((String)objs[BgAnalyseConstants.ANALYSE_ORGUNIT_ID], companyId);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"queryExecute Error:", (Throwable)ex);
                    }
                    objs[BgAnalyseConstants.ANALYSE_COMAPNY_ID] = companyId;
                }
                objs[BgAnalyseConstants.ANALYSE_ORGUNIT_NAME] = rst.getString("FBizOrgUnitName");
                objs[BgAnalyseConstants.ANALYSE_REQORGUNIT_ID] = rst.getString("FReqOrgUnitID");
                objs[BgAnalyseConstants.ANALYSE_REQORGUNIT_NAME] = rst.getString("FReqOrgUnitName");
                Timestamp timestamp = rst.getTimestamp("FBizDate");
                objs[BgAnalyseConstants.ANALYSE_BIZDATE_TIME] = timestamp == null ? timestamp : timestamp.toString().substring(0, timestamp.toString().indexOf(" "));
                Timestamp timestamp2 = rst.getTimestamp("FCreateTime");
                objs[BgAnalyseConstants.ANALYSE_CONTROL_TIME] = timestamp2 == null ? timestamp2 : timestamp2.toString().substring(0, timestamp2.toString().indexOf(" "));
                objs[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER] = rst.getString("FBgIndexNum");
                objs[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER] = this.getExtItemNumber(rst.getString("FBgIndexNum"), rst.getString("FItemExtNumber"));
                objs[BgAnalyseConstants.ANALYSE_AMOUNT] = rst.getBigDecimal("FActaulAmount");
                objs[BgAnalyseConstants.ANALYSE_PERIOD_ID] = rst.getString("FBgPeriodID");
                objs[BgAnalyseConstants.ANALYSE_PERIOD_NUMBER] = rst.getString("PNumber");
                objs[BgAnalyseConstants.ANALYSE_PERIOD_NAME] = rst.getString("PName");
                objs[BgAnalyseConstants.ANALYSE_CURRENCY_ID] = rst.getString("FCurrencyID");
                objs[BgAnalyseConstants.ANALYSE_CURRENCY_NUMBER] = rst.getString("CNumber");
                objs[BgAnalyseConstants.ANALYSE_CURRENCY_NAME] = rst.getString("CName");
                objs[BgAnalyseConstants.ANALYSE_ELEMENT_ID] = rst.getString("FBgElementID");
                objs[BgAnalyseConstants.ANALYSE_ELEMENT_NUMBER] = rst.getString("ENumber");
                objs[BgAnalyseConstants.ANALYSE_ELEMENT_NAME] = rst.getString("EName");
                objs[BgAnalyseConstants.ANALYSE_SCENARIO_NAME] = rst.getString("SName");
                objs[BgAnalyseConstants.ANALYSE_VERSION_NAME] = rst.getString("VName");
                objs[BgAnalyseConstants.ANALYSE_SCENARIO_ID] = String.valueOf(rst.getInt("FScenario"));
                objs[BgAnalyseConstants.ANALYSE_VERSION_ID] = String.valueOf(rst.getInt("FVersion"));
                querys.add(objs);
                numberSet.add((String)objs[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER]);
                if (StringUtils.isEmpty((String)((String)objs[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER]))) continue;
                numberSet.add((String)objs[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER]);
            }
            if (!querys.isEmpty()) break block96;
            ArrayList<Object[]> timestamp = querys;
            SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
            pool.releaseTable(tmpOrgUnitName);
            pool.releaseTable(tmpPeriodName);
            pool.releaseTable(tmpBgIndexName);
            return timestamp;
        }
        try {
            HashMap<String, Map<String, LinkedHashSet<String>>> parentMap = new HashMap<String, Map<String, LinkedHashSet<String>>>();
            HashMap<String, Set<String>> otherDimNumbers = new HashMap<String, Set<String>>();
            for (String itemNumber : numberSet) {
                for (String combin : tmpStrs = DimensionFormulaHelper.splitCombinations((String)itemNumber)) {
                    srcNumber = DimensionFormulaHelper.getSrcNumber((String)combin);
                    number = DimensionFormulaHelper.getMemberNumber((String)combin);
                    if (!otherDimNumbers.containsKey(srcNumber)) {
                        otherDimNumbers.put(srcNumber, new HashSet());
                    }
                    ((Set)otherDimNumbers.get(srcNumber)).add(number);
                }
            }
            this.queryOtherParentMap(tmpBgIndexName, schemeHelper, conn, parentMap, otherDimNumbers);
            if (!_param.isShowDetailOfQuery()) {
                parentMap.put(DimensionConstants.DEF_PERIOD_SRCNUMBER, this.queryParentMap(conn, tmpPeriodName, false));
                parentMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, this.queryParentMap(conn, tmpOrgUnitName, true));
                HashMap subOrgSet = new HashMap();
                for (int i = 0; i < _param.getOrgUnits().size(); ++i) {
                    subOrgSet.put(((OrgUnitInfo)_param.getOrgUnits().get(i)).getId().toString(), _param.getOrgUnits().get(i));
                }
                HashMap<String, BgPeriodInfo> subPeriodSet = new HashMap<String, BgPeriodInfo>();
                if (colls != null) {
                    BgPeriodInfo bgPeriodInfo = null;
                    int in = colls.size();
                    for (int i = 0; i < in; ++i) {
                        bgPeriodInfo = colls.get(i);
                        subPeriodSet.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                    }
                } else {
                    subPeriodSet.put(_param.getBeginPeriod().getNumber(), _param.getBeginPeriod());
                    subPeriodSet.put(_param.getEndPeriod().getNumber(), _param.getEndPeriod());
                }
                HashSet<String> subDimNumberSet = new HashSet<String>();
                HashSet<String> ignoreOrgIds = new HashSet<String>(MbgSqlHelper.executeQuery((Connection)conn, (String)"Select FOrgUnitId FROM T_MBG_BgOrgUnit Where FViewId = ? AND FpolAlgorithm = 3", (Object[])new Object[]{bgOrgViewId}));
                HashSet<String> accountNumberSet = new HashSet<String>();
                for (String dimN : numberSet) {
                    if (!dimN.startsWith(DimensionConstants.DEF_INDEX_SRCNUMBER + ":")) continue;
                    accountNumberSet.add(DimensionFormulaHelper.getMemberNumber((String)DimensionFormulaHelper.splitCombinations((String)dimN)[0]));
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)("Delete FROM " + tmpBgIndexName));
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpBgIndexName + " (FNumber) values (?)"), accountNumberSet);
                HashMap<String, BgUpperGatherEnum> accountGather = new HashMap<String, BgUpperGatherEnum>();
                HashMap<String, BgPeriodSumEnum> accountPeriod = new HashMap<String, BgPeriodSumEnum>();
                HashSet<String> ignoreAccNumberSet = new HashSet<String>();
                int method = -1;
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"Select FNumber, FPolAlgorithm, FPeriodAlgorithm FROM T_MBG_BgAccount Where FBgAccountViewID = ? AND (FPolAlgorithm <> 1 OR FPeriodAlgorithm <> 1)", (Object[])new Object[]{accountViewId});
                while (rst.next()) {
                    number = rst.getString("FNumber");
                    method = rst.getInt("FPolAlgorithm");
                    if (1 != method) {
                        accountGather.put(number, BgUpperGatherEnum.getEnum((int)method));
                    }
                    if (3 == method) {
                        ignoreAccNumberSet.add(number);
                    }
                    if (1 == (method = rst.getInt("FPeriodAlgorithm"))) continue;
                    accountPeriod.put(number, BgPeriodSumEnum.getEnum((int)method));
                }
                SQLUtils.cleanup((ResultSet)rst);
                this.filterIgnore((Map)parentMap.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER), ignoreOrgIds);
                this.filterIgnore((Map)parentMap.get(DimensionConstants.DEF_INDEX_SRCNUMBER), ignoreAccNumberSet);
                if (_param.getMembers().isEmpty()) {
                    HashMap parentAccMap = new HashMap();
                    parentMap.put(DimensionConstants.DEF_INDEX_SRCNUMBER, parentAccMap);
                    ArrayList<String> accountViewIds = new ArrayList<String>();
                    accountViewIds.add(accountViewId);
                    List result2 = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)("Select FLongNumber FROM T_MBG_BgAccount Where FBgAccountViewID = ? AND FNumber IN(Select FNumber FROM " + tmpBgIndexName + ")"), accountViewIds);
                    if (result2 != null) {
                        String[] lns = null;
                        for (int i = 0; i < result2.size(); ++i) {
                            lns = ((String)result2.get(i)).split("!");
                            number = lns[lns.length - 1];
                            if (!parentAccMap.containsKey(number)) {
                                parentAccMap.put(number, new LinkedHashSet());
                                if (_param.isShowDetailOfEmptyMember()) {
                                    ((LinkedHashSet)parentAccMap.get(number)).add("");
                                }
                            }
                            if (!_param.isShowDetailOfEmptyMember()) {
                                subDimNumberSet.add(DimensionFormulaHelper.getCombination((String)DimensionConstants.DEF_INDEX_SRCNUMBER, (String)lns[0]));
                            }
                            ((LinkedHashSet)parentAccMap.get(number)).add(lns[0]);
                        }
                    }
                    numberSet.addAll(subDimNumberSet);
                } else {
                    for (AnalyseMember member : _param.getMembers()) {
                        numberSet.add(member.getBgIndex().getCombNumber());
                        if (member.getDimMember() != null) {
                            numberSet.add(member.getDimMember().getCombNumber());
                            subDimNumberSet.add(member.getBgIndex().getCombNumber() + "," + member.getDimMember().getCombNumber());
                            continue;
                        }
                        subDimNumberSet.add(member.getBgIndex().getCombNumber());
                    }
                }
                Map<String, Object> queryMap = this.buildQueryMap(subDimNumberSet, srcNumbers);
                if (_param.getMembers().isEmpty() && _param.isShowDetailOfEmptyMember() && queryMap.isEmpty() && srcNumber != null) {
                    for (int i = 0; i < srcNumber.length(); ++i) {
                        if (i == srcNumber.length() - 1) {
                            queryMap.put("", "");
                            continue;
                        }
                        queryMap.put("", new HashMap());
                    }
                }
                LinkedHashMap<String, List<Object[]>> _querys = new LinkedHashMap<String, List<Object[]>>();
                String orgUnitId = null;
                String bgPeriodNumber = null;
                String indexNumber = null;
                String otherNumber = null;
                String parentOrgId = null;
                HashMap<String, String> numberMap = new HashMap<String, String>();
                Object combins = null;
                String[] memberNumbers = new String[srcNumbers.length];
                for (Object[] query : querys) {
                    orgUnitId = (String)query[BgAnalyseConstants.ANALYSE_ORGUNIT_ID];
                    bgPeriodNumber = (String)query[BgAnalyseConstants.ANALYSE_PERIOD_NUMBER];
                    indexNumber = (String)query[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER];
                    otherNumber = (String)query[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER];
                    if (((Map)parentMap.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)).get(orgUnitId) == null) continue;
                    String[] parentOrgIds = ((LinkedHashSet)((Map)parentMap.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)).get(orgUnitId)).toArray(new String[0]);
                    Set parentPeriodNumbers = (Set)((Map)parentMap.get(DimensionConstants.DEF_PERIOD_SRCNUMBER)).get(bgPeriodNumber);
                    if (parentOrgIds == null || parentOrgIds.length == 0 || parentPeriodNumbers == null || parentPeriodNumbers.isEmpty()) continue;
                    numberMap.clear();
                    this.buildNumberMap(indexNumber, otherNumber, numberMap);
                    for (int po = 0; po < parentOrgIds.length; ++po) {
                        parentOrgId = parentOrgIds[po];
                        if (!subOrgSet.containsKey(parentOrgId)) continue;
                        for (String pPeriodNumber : parentPeriodNumbers) {
                            if (!subPeriodSet.containsKey(pPeriodNumber)) continue;
                            String nextPeriodNumber = null;
                            boolean isParent = false;
                            for (String p : parentPeriodNumbers) {
                                if (p.equals(pPeriodNumber)) {
                                    isParent = true;
                                    continue;
                                }
                                if (!isParent) continue;
                                nextPeriodNumber = p;
                                break;
                            }
                            for (int mm = 0; mm < memberNumbers.length; ++mm) {
                                memberNumbers[mm] = null;
                            }
                            this.collectionQuerys(memberNumbers, numberMap, srcNumbers, queryMap, parentMap, query, _querys, 0, (OrgUnitInfo)subOrgSet.get(parentOrgId), (BgPeriodInfo)subPeriodSet.get(pPeriodNumber), nextPeriodNumber, accountGather, accountPeriod, _param.isShowDetailOfEmptyMember());
                        }
                    }
                }
                Object[] query = null;
                querys.clear();
                HashSet<String> orgUnitIds = new HashSet<String>();
                HashMap queryMemberMap = new HashMap();
                numberSet.clear();
                for (List subQ : _querys.values()) {
                    for (Object[] q : subQ) {
                        numberSet.add((String)q[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER]);
                        if (q[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER] == null) continue;
                        numberSet.add((String)q[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER]);
                    }
                    query = (Object[])subQ.get(0);
                    if (query[BgAnalyseConstants.ANALYSE_BILL_ID] != null || subQ.size() == 1) {
                        querys.addAll(subQ);
                    } else {
                        querys.add(query);
                        for (int i = 1; i < subQ.size(); ++i) {
                            query[BgAnalyseConstants.ANALYSE_AMOUNT] = ((BigDecimal)query[BgAnalyseConstants.ANALYSE_AMOUNT]).add((BigDecimal)((Object[])subQ.get(i))[BgAnalyseConstants.ANALYSE_AMOUNT]);
                        }
                    }
                    orgUnitIds.add((String)query[BgAnalyseConstants.ANALYSE_ORGUNIT_ID]);
                }
            } else if (!_param.getMembers().isEmpty()) {
                HashSet<String> ignoreAccNumberSet = new HashSet<String>();
                HashSet ignoreOrgIds = new HashSet();
                if (_param.isBgExcuteAnalysis()) {
                    int method = -1;
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)"Select FNumber, FPolAlgorithm, FPeriodAlgorithm FROM T_MBG_BgAccount Where FBgAccountViewID = ? AND (FPolAlgorithm <> 1 OR FPeriodAlgorithm <> 1)", (Object[])new Object[]{accountViewId});
                    while (rst.next()) {
                        number = rst.getString("FNumber");
                        method = rst.getInt("FPolAlgorithm");
                        if (3 != method) continue;
                        ignoreAccNumberSet.add(number);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    ignoreOrgIds.addAll(MbgSqlHelper.executeQuery((Connection)conn, (String)"Select FOrgUnitId FROM T_MBG_BgOrgUnit Where FViewId = ? AND FpolAlgorithm = 3", (Object[])new Object[]{bgOrgViewId}));
                }
                Object[] query = null;
                HashSet<String> subDimNumberSet = new HashSet<String>();
                for (AnalyseMember member : _param.getMembers()) {
                    numberSet.add(member.getBgIndex().getCombNumber());
                    if (member.getDimMember() != null) {
                        numberSet.add(member.getDimMember().getCombNumber());
                        subDimNumberSet.add(member.getBgIndex().getCombNumber() + "," + member.getDimMember().getCombNumber());
                        continue;
                    }
                    subDimNumberSet.add(member.getBgIndex().getCombNumber());
                }
                Map<String, Object> queryMap = this.buildQueryMap(subDimNumberSet, srcNumbers);
                HashMap<String, String> numberMap = new HashMap<String, String>();
                boolean isBgExcuteAnalysis = false;
                Iterator it = querys.iterator();
                while (it.hasNext()) {
                    query = (Object[])it.next();
                    this.buildNumberMap((String)query[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER], (String)query[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER], numberMap);
                    boolean bl = isBgExcuteAnalysis = _param.isBgExcuteAnalysis() && (ignoreOrgIds.contains((String)query[BgAnalyseConstants.ANALYSE_ORGUNIT_ID]) || ignoreAccNumberSet.contains((String)query[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER]));
                    if (this.isInFilter(numberMap, srcNumbers, 0, parentMap, queryMap) && !isBgExcuteAnalysis) continue;
                    it.remove();
                }
            }
            final Map<String, String> orgIdAndLongNumber = this.queryOrgIdAndLongNumber(conn, tmpOrgUnitName);
            Collections.sort(querys, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] o1, Object[] o2) {
                    if (!o1[BgAnalyseConstants.ANALYSE_ORGUNIT_ID].equals(o2[BgAnalyseConstants.ANALYSE_ORGUNIT_ID])) {
                        return ((String)orgIdAndLongNumber.get(o1[BgAnalyseConstants.ANALYSE_ORGUNIT_ID])).compareTo((String)orgIdAndLongNumber.get(o2[BgAnalyseConstants.ANALYSE_ORGUNIT_ID]));
                    }
                    int r = ((String)o1[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER]).compareTo((String)o2[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER]);
                    if (r != 0) {
                        return r;
                    }
                    return r;
                }
            });
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                pool.releaseTable(tmpOrgUnitName);
                pool.releaseTable(tmpPeriodName);
                pool.releaseTable(tmpBgIndexName);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        pool.releaseTable(tmpOrgUnitName);
        pool.releaseTable(tmpPeriodName);
        pool.releaseTable(tmpBgIndexName);
        if (!numberSet.isEmpty() && (result = DimensionFormulaFacadeFactory.getLocalInstance((Context)ctx).getDimensionCombName(_param.getBgScheme().getId().toString(), numberSet, ((OrgUnitInfo)_param.getOrgUnits().get(0)).getId().toString(), true, false)) != null) {
            int in = querys.size();
            for (int i = 0; i < in; ++i) {
                objs = (Object[])querys.get(i);
                if (result.containsKey(objs[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER])) {
                    objs[BgAnalyseConstants.ANALYSE_BGINDEX_NAME] = result.get(objs[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER]);
                }
                if (!result.containsKey(objs[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER])) continue;
                objs[BgAnalyseConstants.ANALYSE_EXTITEM_NAME] = result.get(objs[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER]);
            }
        }
        this.setPeriodAlias(ctx, querys, periodNumbers, rootScheme.getEditOrgViewId().toString());
        ArrayList<Object[]> _querys = new ArrayList<Object[]>();
        for (Object[] _objs : querys) {
            if (_objs[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER] != null && _objs[BgAnalyseConstants.ANALYSE_BGINDEX_NAME] == null || _objs[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER] != null && _objs[BgAnalyseConstants.ANALYSE_EXTITEM_NAME] == null) continue;
            _querys.add(_objs);
        }
        if (_querys.isEmpty() && _param.isBgExcuteAnalysis() && _param.isShowDetailOfQuery()) {
            _param.setShowDetailOfQuery(false);
            return this._queryExecute(ctx, (FilterParam)_param);
        }
        querys.clear();
        querys.addAll(_querys);
        return querys;
    }

    private void addChild(List<Object[]> orgParams, Map<String, Set<String>> childMap, String orgId, String longNumber, Map<String, BgOrgUnitInfo> orgUnitMap) {
        Set<String> childSet = childMap.get(orgId);
        if (childSet == null || childSet.isEmpty()) {
            return;
        }
        for (String child : childSet) {
            BgOrgUnitInfo info = orgUnitMap.get(child);
            String childLongNumber = longNumber + "!" + info.getNumber();
            orgParams.add(new Object[]{child, childLongNumber});
            this.addChild(orgParams, childMap, child, childLongNumber, orgUnitMap);
        }
    }

    private boolean isInFilter(Map<String, String> numberMap, String[] srcNumbers, int dimIndex, Map<String, Map<String, LinkedHashSet<String>>> parentMap, Map<String, Object> queryMap) {
        String srcNumber = srcNumbers[dimIndex];
        String number = numberMap.get(srcNumber);
        if (number == null) {
            number = "";
        }
        if (parentMap.get(srcNumber) == null || !parentMap.get(srcNumber).containsKey(number)) {
            return false;
        }
        for (String cNumber : parentMap.get(srcNumber).get(number)) {
            if (queryMap.get(cNumber) == null) continue;
            if (queryMap.get(cNumber) instanceof Map) {
                if (!this.isInFilter(numberMap, srcNumbers, dimIndex + 1, parentMap, (Map)queryMap.get(cNumber))) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    protected void buildNumberMap(String indexNumber, String otherNumber, Map<String, String> numberMap) {
        numberMap.clear();
        numberMap.put(DimensionFormulaHelper.getSrcNumber((String)indexNumber), DimensionFormulaHelper.getMemberNumber((String)indexNumber));
        if (!StringUtils.isEmpty((String)otherNumber)) {
            String[] combins = DimensionFormulaHelper.splitCombinations((String)otherNumber);
            for (int i = 0; i < combins.length; ++i) {
                numberMap.put(DimensionFormulaHelper.getSrcNumber((String)combins[i]), DimensionFormulaHelper.getMemberNumber((String)combins[i]));
            }
        }
    }

    private void filterIgnore(Map<String, LinkedHashSet<String>> parentMap, Set<String> ignores) {
        if (parentMap == null || parentMap.isEmpty() || ignores == null || ignores.isEmpty()) {
            return;
        }
        LinkedHashSet<String> subSet = null;
        boolean hasIgnore = false;
        String[] subArrs = null;
        for (String cId : parentMap.keySet()) {
            hasIgnore = false;
            subSet = parentMap.get(cId);
            subArrs = subSet.toArray(new String[0]);
            for (int i = subArrs.length - 1; i >= 0; --i) {
                if (hasIgnore) {
                    subSet.remove(subArrs[i]);
                    continue;
                }
                if (!ignores.contains(subArrs[i])) continue;
                hasIgnore = true;
            }
        }
    }

    private void collectionQuerys(String[] memberNumbers, Map<String, String> numberMap, String[] srcNumbers, Map<String, Object> queryMap, Map<String, Map<String, LinkedHashSet<String>>> parentMap, Object[] query, Map<String, List<Object[]>> querys, int dimIndex, OrgUnitInfo orgUnit, BgPeriodInfo bgPeriod, String nextPeriodNumber, Map<String, BgUpperGatherEnum> accountGather, Map<String, BgPeriodSumEnum> accountPeriod, boolean isShowDetail) {
        String srcNumber = srcNumbers[dimIndex];
        if (parentMap.get(srcNumber) == null || parentMap.get(srcNumber).get(numberMap.get(srcNumber)) == null) {
            return;
        }
        Map _queryMap = null;
        String queryKey = null;
        Object[] newQuery = null;
        String orgUnitId = orgUnit.getId().toString();
        String bgPeriodId = bgPeriod.getId().toString();
        BgPeriodSumEnum periodSum = BgPeriodSumEnum.sum;
        String cIndexNumber = DimensionFormulaHelper.getMemberNumber((String)((String)query[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER]));
        int gather = 1;
        if (dimIndex > 0) {
            gather = this.calGather(memberNumbers[0], cIndexNumber, parentMap.get(DimensionConstants.DEF_INDEX_SRCNUMBER), accountGather);
            if (accountPeriod.containsKey(memberNumbers[0])) {
                periodSum = accountPeriod.get(memberNumbers[0]);
            }
        }
        String item = (String)query[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER];
        if (!StringUtils.isEmpty((String)((String)query[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER]))) {
            item = item + "," + query[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER];
        }
        Map memberMap = DimensionFormulaHelper.getMemberMap((String)item);
        item = "";
        for (String src : srcNumbers) {
            if (!memberMap.containsKey(src)) continue;
            if (!item.equals("")) {
                item = item + ",";
            }
            item = item + DimensionFormulaHelper.getCombination((String)src, (String)((String)memberMap.get(src)));
        }
        String sourceQueryKey = this.getQueryKey((String)query[BgAnalyseConstants.ANALYSE_ORGUNIT_ID], (String)query[BgAnalyseConstants.ANALYSE_PERIOD_ID], (String)query[BgAnalyseConstants.ANALYSE_SCENARIO_ID], (String)query[BgAnalyseConstants.ANALYSE_VERSION_ID], (String)query[BgAnalyseConstants.ANALYSE_ELEMENT_ID], (String)query[BgAnalyseConstants.ANALYSE_CURRENCY_ID], item.toString());
        Object subQueryMap = null;
        Iterator it = parentMap.get(srcNumber).get(numberMap.get(srcNumber)).iterator();
        String sumNumber = (String)it.next();
        if (sumNumber.equals("")) {
            sumNumber = (String)it.next();
        }
        Set parentSet = null;
        parentSet = parentMap.get(srcNumber).get(numberMap.get(srcNumber));
        for (String pNumber : parentSet) {
            if (dimIndex == 0) {
                gather = this.calGather(pNumber, cIndexNumber, parentMap.get(DimensionConstants.DEF_INDEX_SRCNUMBER), accountGather);
                periodSum = accountPeriod.containsKey(memberNumbers[0]) ? accountPeriod.get(memberNumbers[0]) : BgPeriodSumEnum.sum;
            }
            subQueryMap = queryMap.get(pNumber);
            memberNumbers[dimIndex] = pNumber;
            if (subQueryMap == null) continue;
            if (subQueryMap instanceof Map && dimIndex < srcNumbers.length - 1) {
                _queryMap = (Map)subQueryMap;
                this.collectionQuerys(memberNumbers, numberMap, srcNumbers, _queryMap, parentMap, query, querys, dimIndex + 1, orgUnit, bgPeriod, nextPeriodNumber, accountGather, accountPeriod, isShowDetail);
                continue;
            }
            queryKey = this.getQueryKey(orgUnitId, bgPeriodId, memberNumbers, srcNumbers, query, isShowDetail);
            if (!querys.containsKey(queryKey)) {
                if (queryKey.equals(sourceQueryKey)) {
                    newQuery = query;
                } else {
                    newQuery = this.copyQuery(query);
                    if (!orgUnitId.equals(newQuery[BgAnalyseConstants.ANALYSE_ORGUNIT_ID])) {
                        newQuery[BgAnalyseConstants.ANALYSE_ORGUNIT_ID] = orgUnitId;
                        newQuery[BgAnalyseConstants.ANALYSE_ORGUNIT_NAME] = orgUnit.getName();
                    }
                    if (!bgPeriodId.equals(newQuery[BgAnalyseConstants.ANALYSE_PERIOD_ID])) {
                        newQuery[BgAnalyseConstants.ANALYSE_PERIOD_ID] = bgPeriodId;
                        newQuery[BgAnalyseConstants.ANALYSE_PERIOD_NUMBER] = bgPeriod.getNumber();
                        newQuery[BgAnalyseConstants.ANALYSE_PERIOD_NAME] = bgPeriod.getName();
                    }
                    newQuery[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER] = DimensionFormulaHelper.getCombination((String)DimensionConstants.DEF_INDEX_SRCNUMBER, (String)memberNumbers[0]);
                    StringBuffer otherNumbers = new StringBuffer();
                    for (int i = 1; i < srcNumbers.length; ++i) {
                        if (StringUtils.isEmpty((String)memberNumbers[i])) continue;
                        if (otherNumbers.length() > 0) {
                            otherNumbers.append(",");
                        }
                        otherNumbers.append(srcNumbers[i]).append(":").append(memberNumbers[i]);
                    }
                    newQuery[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER] = otherNumbers.length() > 0 ? otherNumbers.toString() : null;
                    this.setNoDetail(newQuery);
                    if (gather == -1) {
                        newQuery[BgAnalyseConstants.ANALYSE_AMOUNT] = ((BigDecimal)newQuery[BgAnalyseConstants.ANALYSE_AMOUNT]).negate();
                    }
                    newQuery[BgAnalyseConstants.ANALYSE_NEXT_PERIOD_NUMBER] = nextPeriodNumber;
                }
                querys.put(queryKey, new ArrayList());
                querys.get(queryKey).add(newQuery);
                continue;
            }
            List<Object[]> subQuerys = querys.get(queryKey);
            Object[] oldQuery = subQuerys.get(0);
            newQuery = null;
            BigDecimal value = null;
            value = gather == -1 ? ((BigDecimal)query[BgAnalyseConstants.ANALYSE_AMOUNT]).negate() : (BigDecimal)query[BgAnalyseConstants.ANALYSE_AMOUNT];
            if (queryKey.equals(sourceQueryKey)) {
                subQuerys.add(query);
                continue;
            }
            if (oldQuery[BgAnalyseConstants.ANALYSE_BILL_ID] == null) {
                newQuery = oldQuery;
                boolean isReplace = false;
                if (!StringUtils.isEmpty((String)nextPeriodNumber)) {
                    if (BgPeriodSumEnum.opening.equals((Object)periodSum)) {
                        if (nextPeriodNumber.compareTo((String)newQuery[BgAnalyseConstants.ANALYSE_NEXT_PERIOD_NUMBER]) < 0) {
                            isReplace = true;
                        }
                    } else if (BgPeriodSumEnum.ending.equals((Object)periodSum) && nextPeriodNumber.compareTo((String)newQuery[BgAnalyseConstants.ANALYSE_NEXT_PERIOD_NUMBER]) > 0) {
                        isReplace = true;
                    }
                }
                if (!isReplace) {
                    newQuery[BgAnalyseConstants.ANALYSE_AMOUNT] = ((BigDecimal)newQuery[BgAnalyseConstants.ANALYSE_AMOUNT]).add(value);
                    continue;
                }
                newQuery[BgAnalyseConstants.ANALYSE_AMOUNT] = value;
                newQuery[BgAnalyseConstants.ANALYSE_NEXT_PERIOD_NUMBER] = nextPeriodNumber;
                continue;
            }
            newQuery = this.copyQuery(oldQuery);
            this.setNoDetail(newQuery);
            newQuery[BgAnalyseConstants.ANALYSE_AMOUNT] = gather == -1 ? value : value;
            newQuery[BgAnalyseConstants.ANALYSE_NEXT_PERIOD_NUMBER] = nextPeriodNumber;
        }
    }

    private Object[] copyQuery(Object[] query) {
        Object[] newQuerys = new Object[query.length];
        System.arraycopy(query, 0, newQuerys, 0, query.length);
        return newQuerys;
    }

    private void setNoDetail(Object[] newQuerys) {
        newQuerys[BgAnalyseConstants.ANALYSE_BILL_ID] = null;
        newQuerys[BgAnalyseConstants.ANALYSE_BILL_NUMBER] = null;
        newQuerys[BgAnalyseConstants.ANALYSE_BILL_TYPE] = null;
        newQuerys[BgAnalyseConstants.ANALYSE_BIZDATE_TIME] = null;
        newQuerys[BgAnalyseConstants.ANALYSE_CONTROL_TIME] = null;
        newQuerys[BgAnalyseConstants.ANALYSE_REQORGUNIT_ID] = null;
        newQuerys[BgAnalyseConstants.ANALYSE_REQORGUNIT_NAME] = null;
    }

    private int calGather(String pIndexNumber, String cIndexNumber, Map<String, LinkedHashSet<String>> parentMap, Map<String, BgUpperGatherEnum> accountGather) {
        int gather = 1;
        if (parentMap == null || parentMap.get(cIndexNumber) == null || accountGather.isEmpty()) {
            return gather;
        }
        boolean isChild = false;
        for (String p : parentMap.get(cIndexNumber)) {
            if (p.equals(pIndexNumber)) {
                isChild = true;
                continue;
            }
            if (!isChild || !BgUpperGatherEnum.subtract.equals((Object)accountGather.get(p))) continue;
            gather *= -1;
        }
        return gather;
    }

    private String getQueryKey(String pOrgUnitId, String pPeriodId, String[] memberNumbers, String[] srcNumbers, Object[] query, boolean isShowDetail) {
        HashMap queryMembers = new HashMap();
        if (isShowDetail) {
            String queryItem = (String)query[BgAnalyseConstants.ANALYSE_BGINDEX_NUMBER];
            String otherItem = (String)query[BgAnalyseConstants.ANALYSE_EXTITEM_NUMBER];
            if (!StringUtils.isEmpty((String)otherItem)) {
                queryItem = queryItem + "," + otherItem;
            }
            queryMembers.putAll(DimensionFormulaHelper.getMemberMap((String)queryItem));
        }
        StringBuilder item = new StringBuilder();
        for (int i = 0; i < srcNumbers.length; ++i) {
            if (i > 0) {
                item.append(",");
            }
            if (isShowDetail && StringUtils.isEmpty((String)memberNumbers[i])) {
                memberNumbers[i] = (String)queryMembers.get(srcNumbers[i]);
            }
            item.append(srcNumbers[i]).append(":").append(memberNumbers[i]);
        }
        return this.getQueryKey(pOrgUnitId, pPeriodId, (String)query[BgAnalyseConstants.ANALYSE_SCENARIO_ID], (String)query[BgAnalyseConstants.ANALYSE_VERSION_ID], (String)query[BgAnalyseConstants.ANALYSE_ELEMENT_ID], (String)query[BgAnalyseConstants.ANALYSE_CURRENCY_ID], item.toString());
    }

    private String getQueryKey(String orgUnitId, String periodId, String scenarioId, String versionId, String elementId, String currencyId, String dimItemNumber) {
        return orgUnitId + "_" + periodId + "_" + scenarioId + "_" + versionId + "_" + elementId + "_" + currencyId + "_" + dimItemNumber;
    }

    protected void queryOtherParentMap(String tmpBgIndexName, BgSchemeDimensionHelper schemeHelper, Connection conn, Map<String, Map<String, LinkedHashSet<String>>> parentMap, Map<String, Set<String>> otherDimNumbers) throws SQLException, BOSException {
        String srcNumber = null;
        String number = null;
        String tableName = null;
        String viewIdField = null;
        for (Map.Entry<String, Set<String>> entry : otherDimNumbers.entrySet()) {
            srcNumber = entry.getKey();
            if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(entry.getKey())) {
                tableName = "T_MBG_BgAccount";
                viewIdField = "FBgAccountViewID";
            } else {
                tableName = "T_MBG_MbgMember";
                viewIdField = "FViewId";
            }
            BgDBUtils.executeUpdate((Connection)conn, (String)("Delete FROM " + tmpBgIndexName));
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpBgIndexName + " (FNumber) Values(?)"), (Collection)entry.getValue());
            List result = MbgSqlHelper.executeQuery((Connection)conn, (String)("Select FLongNumber FROM " + tableName + " Where " + viewIdField + " = ? AND FNumber IN(Select FNumber FROM " + tmpBgIndexName + ")"), (Object[])new Object[]{((BgDimensionInfo)schemeHelper.getDimensionBySrcNumber().get(entry.getKey())).getViewId()});
            String[] lns = null;
            HashMap parentOtherMap = new HashMap();
            parentMap.put(srcNumber, parentOtherMap);
            for (int i = 0; i < result.size(); ++i) {
                lns = ((String)result.get(i)).split("!");
                number = lns[lns.length - 1];
                parentOtherMap.put(number, new LinkedHashSet());
                ((LinkedHashSet)parentOtherMap.get(number)).add("");
                for (int l = 0; l < lns.length; ++l) {
                    ((LinkedHashSet)parentOtherMap.get(number)).add(lns[l]);
                }
            }
        }
    }

    private Map<String, Object> buildQueryMap(Set<String> subDimNumberSet, String[] srcNumbers) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        Map comMap = null;
        Map<String, Object> subQueryMap = null;
        String srcNumber = null;
        String number = null;
        for (String itemNumber : subDimNumberSet) {
            comMap = DimensionFormulaHelper.getMemberMap((String)itemNumber);
            subQueryMap = queryMap;
            for (int i = 0; i < srcNumbers.length; ++i) {
                srcNumber = srcNumbers[i];
                number = comMap.containsKey(srcNumber) ? (String)comMap.get(srcNumber) : "";
                if (i == srcNumbers.length - 1) {
                    subQueryMap.put(number, itemNumber);
                    continue;
                }
                if (!subQueryMap.containsKey(number)) {
                    subQueryMap.put(number, new HashMap());
                }
                subQueryMap = (Map)subQueryMap.get(number);
            }
        }
        return queryMap;
    }

    private Map<String, LinkedHashSet<String>> queryParentMap(Connection conn, String tmpTable, boolean isId) throws BOSException {
        HashMap<String, LinkedHashSet<String>> result = new HashMap<String, LinkedHashSet<String>>();
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("Select FLongNumber" + (isId ? ", FID" : "") + " FROM " + tmpTable + " Order By FLongNumber"));
            HashMap<String, String> numberId = new HashMap<String, String>();
            String[] lns = null;
            String number2 = null;
            while (rst.next()) {
                lns = rst.getString("FLongNumber").split("!");
                number2 = lns[lns.length - 1];
                if (isId) {
                    numberId.put(number2, rst.getString("FID"));
                } else {
                    numberId.put(number2, number2);
                }
                if (!result.containsKey(number2)) {
                    result.put(number2, new LinkedHashSet());
                }
                for (int i = 0; i < lns.length; ++i) {
                    ((LinkedHashSet)result.get(number2)).add(lns[i]);
                }
            }
            if (isId) {
                HashMap backup = new HashMap(result);
                result.clear();
                LinkedHashSet subSet = null;
                for (String number2 : backup.keySet()) {
                    if (!numberId.containsKey(number2)) continue;
                    subSet = new LinkedHashSet();
                    result.put((String)numberId.get(number2), subSet);
                    for (String pNumber : (LinkedHashSet)backup.get(number2)) {
                        if (!numberId.containsKey(pNumber)) continue;
                        subSet.add(numberId.get(pNumber));
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return result;
    }

    protected Map<String, String> queryOrgIdAndLongNumber(Connection conn, String tmpTable) throws BOSException {
        HashMap<String, String> idsMap = new HashMap<String, String>();
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("Select FID, FLongNumber FROM " + tmpTable + " Order By FLongNumber"));
            while (rst.next()) {
                idsMap.put(rst.getString("FID"), rst.getString("FLongNumber"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return idsMap;
    }

    private void setPeriodAlias(Context ctx, List<Object[]> querys, Set periodNumbers, String orgViewId) throws BOSException {
        int i;
        if (querys.size() == 0 || periodNumbers.size() == 0 || orgViewId == null) {
            return;
        }
        Object bgPeriodDispCols = null;
        HashSet<Object> orgUnitSet = new HashSet<Object>();
        Map bgPeriodMap = BgViewServerHelper.queryPeriodMapByNumbers((Context)ctx, (Set)periodNumbers, null);
        for (int i2 = 0; i2 < querys.size(); ++i2) {
            Object[] obj = querys.get(i2);
            orgUnitSet.add(obj[BgAnalyseConstants.ANALYSE_ORGUNIT_ID]);
        }
        BgOrgUnitCollection bgOrgUnitCols = null;
        HashSet<String> hasAliasOrg = new HashSet<String>();
        bgOrgUnitCols = BgOrgUnitFactory.getLocalInstance((Context)ctx).getBgOrgUnitCollection(this.getOrgAliasEntityInfo(orgViewId, orgUnitSet));
        for (i = 0; i < bgOrgUnitCols.size(); ++i) {
            hasAliasOrg.add(bgOrgUnitCols.get(i).getOrgUnitID());
        }
        for (i = 0; i < querys.size(); ++i) {
            Object[] obj = querys.get(i);
            String orgUnitId = obj[BgAnalyseConstants.ANALYSE_ORGUNIT_ID].toString();
            String periodNumber = obj[BgAnalyseConstants.ANALYSE_PERIOD_NUMBER].toString();
            if (!hasAliasOrg.contains(orgUnitId) || !bgPeriodMap.containsKey(periodNumber)) continue;
            obj[BgAnalyseConstants.ANALYSE_PERIOD_NAME] = ((BgPeriodInfo)bgPeriodMap.get(periodNumber)).getDisplayName();
        }
    }

    private EntityViewInfo getOrgAliasEntityInfo(String orgViewId, Set orgUnit) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("longNumber");
        evi.getSelector().add("orgUnitID");
        evi.getSelector().add("viewID");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgUnit, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)orgViewId, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("periodName", (Object)1, CompareType.EQUALS));
        return evi;
    }

    private String getExtItemNumber(String bgIndexNum, String dimNumber) {
        if (bgIndexNum == null || dimNumber == null) {
            return dimNumber;
        }
        if (bgIndexNum.equals(dimNumber)) {
            return null;
        }
        StringBuffer strs = new StringBuffer();
        String[] tmpStr = dimNumber.split(",");
        if (tmpStr != null) {
            int in = tmpStr.length;
            for (int i = 0; i < in; ++i) {
                if (bgIndexNum.equals(tmpStr[i])) continue;
                strs.append(tmpStr[i] + ",");
            }
            strs = strs.delete(strs.length() - 1, strs.length());
        }
        return strs.toString();
    }

    private static class QueryCompareObject
    implements Comparable<QueryCompareObject> {
        private String[] compareValue = null;
        private Object[] query = null;

        private QueryCompareObject() {
        }

        @Override
        public int compareTo(QueryCompareObject o) {
            for (int i = 0; i < this.compareValue.length; ++i) {
                int value = this.compareValue[i].compareTo(o.compareValue[i]);
                if (value == 0) continue;
                return value;
            }
            return 0;
        }
    }
}

