/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.face.IControlData;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BgControlDataFacade {
    private IControlParameter parameter = null;
    Map<String, BgSchemeAccIntHelper> accIntMap = null;
    private Map<String, List<IControlData>> actualData = new HashMap<String, List<IControlData>>();

    public void setParameter(IControlParameter parameter) {
        this.parameter = parameter;
    }

    public IControlParameter getParameter() {
        return this.parameter;
    }

    public void setAccIntMap(Map<String, BgSchemeAccIntHelper> accIntMap) {
        this.accIntMap = accIntMap;
    }

    public BgControlDataFacade(IControlParameter parameter, Map<String, BgSchemeAccIntHelper> accIntMap) {
        this.setParameter(parameter);
        this.setAccIntMap(accIntMap);
    }

    public Map<String, List<IControlData>> getActualData() {
        return this.actualData;
    }

    public void addControlData(String cubeName, IControlData data) {
        if (cubeName == null || data == null) {
            return;
        }
        List<Object> datas = null;
        if (this.getActualData().containsKey(cubeName)) {
            datas = this.getActualData().get(cubeName);
        } else {
            datas = new ArrayList();
            this.getActualData().put(cubeName, datas);
        }
        datas.add(data);
    }

    public void saveControlData(Context ctx, Connection conn) throws Exception {
        if (ctx == null || conn == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        for (Map.Entry<String, List<IControlData>> entry : this.getActualData().entrySet()) {
            String cubeName = entry.getKey();
            List<IControlData> datas = entry.getValue();
            this.updateActualData(ctx, conn, cubeName, datas);
        }
    }

    private String getControlKey(String orgUnitId, String formulaStr, String versionNum) {
        return orgUnitId + "_" + formulaStr + "_" + versionNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateActualData(Context ctx, Connection conn, String dataCube, List<IControlData> controlDatas) throws Exception {
        PreparedStatement pstmt;
        TempTablePool pool;
        String tmpTableName;
        block28: {
            if (ctx == null || conn == null || StringUtils.isEmpty((String)dataCube) || controlDatas == null || controlDatas.isEmpty()) {
                return;
            }
            int batchIndex = 0;
            int refDimSize = 0;
            String cubeName = "T_MBG_BGDATA" + BgSchemeConvertToAccIntUtils.getCodeNumber((String)dataCube);
            String cubeActual = null;
            String dimStr = null;
            tmpTableName = null;
            String controlKey = null;
            String[] dimStrs = null;
            String[] srcStrs = null;
            StringBuffer sql = null;
            StringBuffer table = null;
            Timestamp time = new Timestamp(System.currentTimeMillis());
            MbgDimInfo dimInfo = null;
            IControlData controlData = null;
            List refDims = null;
            ArrayList<IControlData> upActualData = new ArrayList<IControlData>();
            HashSet<String> controlKeys = new HashSet<String>();
            HashMap<String, String> valueMap = new HashMap<String, String>();
            if (this.getParameter().getDataManager().getSrcDimMap() == null) {
                this.getParameter().getDataManager().setSrcDimMap(DimUtils.getDimInfoMap((Context)ctx));
            }
            Map<String, MbgDimInfo> srcDimMap = this.getParameter().getDataManager().getSrcDimMap();
            Map<String, BgSchemeInfo> schemeMap = this.getParameter().getDataManager().getBgSchemeMap();
            BgSchemeInfo bgSchemeInfo = null;
            bgSchemeInfo = schemeMap.get(cubeName);
            refDims = BgCubeUtils.getRefDims((BgSchemeInfo)bgSchemeInfo, this.getParameter().getDataManager().getSrcDimMap().values(), (boolean)false);
            refDimSize = refDims.size();
            cubeActual = BgCubeUtils.getActualCubeName((String)dataCube);
            pool = TempTablePool.getInstance((Context)ctx);
            BgSchemeAccIntHelper accIntHelper = this.accIntMap.get(bgSchemeInfo.getId().toString());
            pstmt = null;
            try {
                int i;
                int in;
                int i2;
                table = new StringBuffer();
                table.append("Create Table TEML_KSQL_0 (FID VARCHAR(44) DEFAULT '' NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, " + (accIntHelper.isUseAccInt() ? "FOrgUnitID INT NOT NULL, " : "FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, ") + "FFormula NVARCHAR(" + 300 + ") DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
                int in2 = refDims.size();
                for (i2 = 0; i2 < in2; ++i2) {
                    if (accIntHelper.isUseAccInt()) {
                        table.append((String)refDims.get(i2) + " INT, ");
                        continue;
                    }
                    table.append((String)refDims.get(i2) + " NVARCHAR(84), ");
                }
                table.append("FBgItemCombination NVARCHAR(300) DEFAULT '' NOT NULL, " + (accIntHelper.isUseAccInt() ? "FBgPeriodID INT NOT NULL, " : "FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, ") + (accIntHelper.isUseAccInt() ? "FBgElementID INT NOT NULL, " : "FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, ") + "FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FState INT DEFAULT 1)");
                tmpTableName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)table.toString());
                pool.createIndex(tmpTableName, "FID", true, false);
                pool.createIndex(tmpTableName, "FOrgUnitID,FFormula,FVersion", false, false);
                sql = new StringBuffer();
                sql.append("Insert Into " + tmpTableName + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, ");
                in2 = refDims.size();
                for (i2 = 0; i2 < in2; ++i2) {
                    sql.append((String)refDims.get(i2) + ", ");
                }
                sql.append(" FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState) values (?,?,?,?,?,?,?,?,?,");
                in2 = refDims.size();
                for (i2 = 0; i2 < in2; ++i2) {
                    sql.append("?,");
                }
                sql.append("?,?,?,?,?,?,?)");
                HashMap<String, BigDecimal> sumMap = new HashMap<String, BigDecimal>();
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    in = controlDatas.size();
                    for (i = 0; i < in; ++i) {
                        controlData = controlDatas.get(i);
                        controlKey = this.getControlKey(controlData.getOrgUnitId(), controlData.getFormula(), "Ve");
                        if (sumMap.containsKey(controlKey)) {
                            sumMap.put(controlKey, controlData.getValue().add((BigDecimal)sumMap.get(controlKey)));
                            continue;
                        }
                        sumMap.put(controlKey, controlData.getValue());
                    }
                    in = controlDatas.size();
                    for (i = 0; i < in; ++i) {
                        controlData = controlDatas.get(i);
                        controlKey = this.getControlKey(controlData.getOrgUnitId(), controlData.getFormula(), "Ve");
                        if (controlKeys.contains(controlKey)) continue;
                        controlKeys.add(controlKey);
                        controlData.setId(BOSUuid.create((String)"3BA4D30D").toString());
                        upActualData.add(controlData);
                        pstmt.setString(1, controlData.getId());
                        pstmt.setString(2, BgControlConstants.DEFAULT_USER_ID);
                        pstmt.setTimestamp(3, time);
                        pstmt.setString(4, BgControlConstants.DEFAULT_USER_ID);
                        pstmt.setTimestamp(5, time);
                        accIntHelper.setParam(pstmt, 6, controlData.getOrgUnitId(), DimensionConstants.DEF_ORGUNIT_FIELD);
                        pstmt.setString(7, controlData.getFormula());
                        pstmt.setBigDecimal(8, (BigDecimal)sumMap.get(controlKey));
                        pstmt.setBigDecimal(9, (BigDecimal)sumMap.get(controlKey));
                        dimStrs = controlData.getBgDimItemNumber().split(",");
                        if (dimStrs != null) {
                            int j;
                            valueMap.clear();
                            int jn = dimStrs.length;
                            for (j = 0; j < jn; ++j) {
                                srcStrs = dimStrs[j].split(":");
                                if (srcStrs == null) continue;
                                dimInfo = srcDimMap.get(srcStrs[0]);
                                valueMap.put(dimInfo.getRefField(), dimStrs[j]);
                            }
                            jn = refDims.size();
                            for (j = 0; j < jn; ++j) {
                                dimStr = (String)refDims.get(j);
                                if (valueMap.containsKey(dimStr)) {
                                    accIntHelper.setParam(pstmt, 10 + j, (String)valueMap.get(dimStr), dimStr);
                                    continue;
                                }
                                pstmt.setString(10 + j, null);
                            }
                        } else {
                            throw new BgControlException(BgControlException.PARSEBGDIMITEMNUMBERERROR);
                        }
                        pstmt.setString(10 + refDimSize, controlData.getBgDimItemNumber());
                        accIntHelper.setParam(pstmt, 11 + refDimSize, controlData.getBgPeriodId(), DimensionConstants.DEF_PERIOD_FIELD);
                        accIntHelper.setParam(pstmt, 12 + refDimSize, controlData.getBgElementId(), DimensionConstants.DEF_ELEMENT_FIELD);
                        pstmt.setString(13 + refDimSize, controlData.getCurrencyId());
                        pstmt.setInt(14 + refDimSize, controlData.getScenarioId());
                        pstmt.setInt(15 + refDimSize, BgVersionHelper.DEF_VERSION_VALUE);
                        pstmt.setInt(16 + refDimSize, 9);
                        pstmt.addBatch();
                        if (++batchIndex < 50) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex > 0) {
                        pstmt.executeBatch();
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)pstmt);
                sql.setLength(0);
                sql.append("Insert Into " + cubeActual + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, ");
                in = refDims.size();
                for (i = 0; i < in; ++i) {
                    sql.append((String)refDims.get(i) + ", ");
                }
                sql.append(" FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState) ");
                sql.append(" select FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, ");
                in = refDims.size();
                for (i = 0; i < in; ++i) {
                    sql.append((String)refDims.get(i) + ", ");
                }
                sql.append(" FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState from " + tmpTableName);
                sql.append(" where not exists (select FID from " + cubeActual + " where FOrgUnitID = " + tmpTableName + ".FOrgUnitID and FFormula = " + tmpTableName + ".FFormula and FVersion = " + tmpTableName + ".FVersion)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
                if (upActualData.isEmpty()) break block28;
                sql.setLength(0);
                sql.append("update " + cubeActual + " set FValue = FValue + ?, FTmpValue = FTmpValue + ? where FOrgUnitID = ? and FFormula = ? and FVersion = ? and FID <> ?");
                batchIndex = 0;
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    in = upActualData.size();
                    for (i = 0; i < in; ++i) {
                        controlData = (IControlData)upActualData.get(i);
                        controlKey = this.getControlKey(controlData.getOrgUnitId(), controlData.getFormula(), "Ve");
                        pstmt.setBigDecimal(1, (BigDecimal)sumMap.get(controlKey));
                        pstmt.setBigDecimal(2, (BigDecimal)sumMap.get(controlKey));
                        accIntHelper.setParam(pstmt, 3, controlData.getOrgUnitId(), DimensionConstants.DEF_ORGUNIT_FIELD);
                        pstmt.setString(4, controlData.getFormula());
                        pstmt.setInt(5, BgVersionHelper.DEF_VERSION_VALUE);
                        pstmt.setString(6, controlData.getId());
                        pstmt.addBatch();
                        if (++batchIndex < 50) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex > 0) {
                        pstmt.executeBatch();
                    }
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (SQLDataException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    pool.releaseTable(tmpTableName);
                    SQLUtils.cleanup(pstmt);
                    throw throwable;
                }
            }
        }
        pool.releaseTable(tmpTableName);
        SQLUtils.cleanup((Statement)pstmt);
    }
}

