/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BgControlLogThread
extends Thread {
    private static Logger logger = Logger.getLogger(BgControlLogThread.class);
    private static final String LOGSQL = "Insert Into T_MBG_BgControlLog (FID, FBillId, FOperTime, FOperType, FOperResult, FRuleID, FIsomer) values (?,?,?,?,?,?,?)";
    private static final String LOGRULESQL = "Insert into T_MBG_BgControlLogRule (FID, FData) values (?,?)";
    private static final String LOGID = "FC328ABF";
    private static final String LOGRULEID = "36881E5B";
    private Context ctx = null;
    private String billId = null;
    private int operType = 0;
    private int operResult = 0;
    private List<BgControlParam> params = null;
    private String threadStack = null;
    private List<String> conditions = null;
    private int isomer = 0;

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setBillId(String billId) {
        this.billId = billId;
    }

    public String getBillId() {
        return this.billId;
    }

    public void setOperType(int operType) {
        this.operType = operType;
    }

    public int getOperType() {
        return this.operType;
    }

    public void setOperResult(int operResult) {
        this.operResult = operResult;
    }

    public int getOperResult() {
        return this.operResult;
    }

    public void setParams(List<BgControlParam> params) {
        this.params = params;
    }

    public List<BgControlParam> getParams() {
        return this.params;
    }

    public void setThreadStack(String threadStack) {
        this.threadStack = threadStack;
    }

    public String getThreadStack() {
        return this.threadStack;
    }

    public void setConditions(List<String> conditions) {
        this.conditions = conditions;
    }

    public List<String> getConditions() {
        return this.conditions;
    }

    public int getIsomer() {
        return this.isomer;
    }

    public void setIsomer(int isomer) {
        this.isomer = isomer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block17: {
            super.run();
            if (this.getBillId() == null) {
                return;
            }
            conn = null;
            pstmt = null;
            rst = null;
            String logId = null;
            String ruleId = null;
            String logDetail = null;
            boolean detail = false;
            try {
                conn = BgDBUtils.getConnection((Context)this.getCtx());
                try {
                    pstmt = conn.prepareStatement("select FValue from T_MBG_BgParam where FKey = ?");
                    pstmt.setString(1, "C0002");
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        logDetail = rst.getString("FValue");
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                detail = !StringUtils.isEmpty((String)logDetail) && "1".equals(logDetail);
                logId = BOSUuid.create((String)LOGID).toString();
                ruleId = detail ? BOSUuid.create((String)LOGRULEID).toString() : null;
                try {
                    pstmt = conn.prepareStatement(LOGSQL);
                    pstmt.setString(1, logId);
                    pstmt.setString(2, this.getBillId());
                    pstmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    pstmt.setInt(4, this.getOperType());
                    pstmt.setInt(5, this.getOperResult());
                    pstmt.setString(6, ruleId);
                    pstmt.setInt(7, this.getIsomer());
                    pstmt.executeUpdate();
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
                if (!detail) break block17;
                byte[] bytes = BgAnalyseHelper.getBytes(this.toJSON(this.getParams(), this.getConditions(), this.getThreadStack()));
                try {
                    pstmt = conn.prepareStatement(LOGRULESQL);
                    pstmt.setString(1, ruleId);
                    if (bytes != null && bytes.length > 0) {
                        pstmt.setBinaryStream(2, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                    } else {
                        pstmt.setBytes(2, null);
                    }
                    pstmt.executeUpdate();
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"bgControlLogThread sql error:", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private List<String> toJSON(List<BgControlParam> params, List<String> conditions, String threadStack) {
        ArrayList<String> jsons = new ArrayList<String>();
        if (params != null) {
            for (BgControlParam param : params) {
                jsons.add(new JSONObject(BgControlUtils.toMap(param)).toString());
            }
        }
        if (conditions != null) {
            for (String condition : conditions) {
                jsons.add(new JSONObject(BgControlUtils.toMap(condition)).toString());
            }
        }
        if (threadStack != null) {
            jsons.add(new JSONObject(BgControlUtils.toThreadStackMap(threadStack)).toString());
        }
        return jsons;
    }
}

