/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlFacadeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.face.IControlResult;
import com.kingdee.eas.ma.control.face.IRequestControl;
import com.kingdee.eas.ma.control.impl.AbstractControlImpl;
import com.kingdee.eas.ma.control.impl.ControlCheck;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.utils.BgControlParamUtils;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.control.utils.BgCurrencyMappingUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RequestControlImpl
extends AbstractControlImpl
implements IRequestControl {
    private static Logger logger = Logger.getLogger(RequestControlImpl.class);
    private List<BgControlParam> params = null;
    private List<String> conditions = new ArrayList<String>();

    @Override
    public List<BgControlParam> getParams() {
        return this.params;
    }

    @Override
    public List<String> getConditions() {
        return this.conditions;
    }

    @Override
    public boolean isSupportRepeatControl(Context ctx, BOSUuid billId, IControlParameter parameter) throws Exception {
        if (ctx == null || billId == null || parameter == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        String bizUnit = BgControlUtils.getBizUnit(ctx, billId);
        return this.isSupportRepeatControl(bizUnit);
    }

    @Override
    public boolean isSupportRepeatControl(Context ctx, IObjectValue model, IControlParameter parameter) throws Exception {
        if (ctx == null || model == null || parameter == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        String bizUnit = BgControlUtils.getBizUnit(ctx, model);
        return this.isSupportRepeatControl(bizUnit);
    }

    private boolean isSupportRepeatControl(String bizUnit) {
        return bizUnit != null && bizUnit.toLowerCase(Locale.ENGLISH).startsWith("com.kingdee.eas.cp.bc");
    }

    @Override
    public IControlResult requestBudget(Context ctx, BOSUuid billId, IControlParameter parameter) throws Exception {
        if (ctx == null || billId == null || parameter == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        this.params = this.buildParam(ctx, billId, parameter);
        this.budgetControl(ctx, this.params, parameter);
        return parameter.getResult();
    }

    @Override
    public IControlResult requestBudget(Context ctx, IObjectValue model, IControlParameter parameter) throws Exception {
        if (ctx == null || model == null || parameter == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        this.params = this.buildParam(ctx, model, parameter);
        this.budgetControl(ctx, this.params, parameter);
        return parameter.getResult();
    }

    @Override
    protected List<BgControlParam> builderControlParam(Context ctx, BOSUuid billId, BgControlSchemeInfo controlScheme, IControlParameter parameter) throws BOSException, EASBizException {
        BgControlParamUtils utils = BgControlParamUtils.getInterace();
        List<BgControlParam> params = null;
        params = parameter.getBgControlIsomer() != null ? BgControlParamUtils.getInterace().getControlParam(ctx, controlScheme, parameter) : BgControlParamUtils.getInterace().getControlParam(ctx, billId, controlScheme, parameter);
        this.queryOrgEntrust(ctx, params);
        BgCurrencyMappingUtils.transCurrency(ctx, params);
        this.afterBuildControlParam(ctx, params);
        this.getConditions().addAll(utils.getConditions());
        return params;
    }

    @Override
    protected List<BgControlParam> builderControlParam(Context ctx, IObjectValue model, BgControlSchemeInfo controlScheme, IControlParameter parameter) throws BOSException, EASBizException {
        BgControlParamUtils utils = BgControlParamUtils.getInterace();
        List<BgControlParam> params = utils.getControlParam(ctx, model, controlScheme, parameter);
        this.queryOrgEntrust(ctx, params);
        BgCurrencyMappingUtils.transCurrency(ctx, params);
        this.afterBuildControlParam(ctx, params);
        this.getConditions().addAll(utils.getConditions());
        return params;
    }

    private void budgetControl(Context ctx, List<BgControlParam> params, IControlParameter parameter) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        BgControlUtils.queryBgScheme(ctx, parameter, params);
        BgControlFacadeFactory.getLocalInstance(ctx).lockTransaction(this.getOrgViewId(parameter, params), this.getLockOUIds(parameter, params));
        this.queryBalance(ctx, params, parameter);
        if (this.isCheckBalance(parameter)) {
            ControlCheck.getInstance().checkBalance(ctx, parameter, params);
        }
        if (parameter.getResult().getResult() == 1) {
            this.writeControlRecord(ctx, parameter, params);
        }
    }

    protected boolean isCheckBalance(IControlParameter parameter) {
        return parameter.getLogicParameter().isCheckBalance();
    }

    private BOSUuid getOrgViewId(IControlParameter parameter, List<BgControlParam> params) {
        BOSUuid orgViewId = null;
        if (parameter == null || params == null) {
            return orgViewId;
        }
        HashSet<BOSUuid> orgViewIds = new HashSet<BOSUuid>();
        for (BgControlParam param : params) {
            orgViewIds.add(param.getBgSchemeInfo().getEditOrgViewId());
        }
        if (orgViewIds.size() == 1) {
            orgViewId = (BOSUuid)orgViewIds.iterator().next();
        }
        return orgViewId;
    }

    private Set<String> getLockOUIds(IControlParameter parameter, List<BgControlParam> params) {
        HashSet<String> OUIDs = new HashSet<String>();
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            OUIDs.add(params.get(i).getOrgUnit().getId().toString());
        }
        return OUIDs;
    }
}

