/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.MetaDataFacadeFactory;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.base.utils.BgLocaleHelper;
import com.kingdee.eas.ma.base.utils.VirtualMetaInfo;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;

public class BgEntryTreeUtils {
    private Map genAssActTypeMap = null;
    private EntityObjectInfo rootEntity;

    public Map getGenAssActTypeMap() throws EASBizException, BOSException {
        if (this.genAssActTypeMap == null) {
            this.genAssActTypeMap = MetaDataFacadeFactory.getRemoteInstance().getGeneralAssActType();
        }
        if (this.genAssActTypeMap == null) {
            this.genAssActTypeMap = new HashMap();
        }
        return this.genAssActTypeMap;
    }

    public void clearAss() {
        if (this.genAssActTypeMap != null && !this.genAssActTypeMap.isEmpty()) {
            this.genAssActTypeMap = null;
        }
    }

    public DefaultKingdeeTreeNode createEntityTree(EntityObjectInfo entity) throws EASBizException, BOSException {
        if (entity == null) {
            return null;
        }
        this.rootEntity = entity;
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(BgEntityUtil.getEntityAlias((EntityObjectInfo)entity, null));
        VirtualMetaInfo dataObject = new VirtualMetaInfo();
        dataObject.setEntity(entity);
        dataObject.setName("");
        dataObject.setAlias("");
        root.setUserObject((Object)dataObject);
        this.addDefaultChildNode(root);
        return root;
    }

    public void addDefaultChildNode(DefaultKingdeeTreeNode parentNode) throws EASBizException, BOSException {
        VirtualMetaInfo dataObject = (VirtualMetaInfo)parentNode.getUserObject();
        EntityObjectInfo entity = dataObject.getEntity();
        if (entity == null || dataObject.isExpanded()) {
            return;
        }
        if (parentNode.getChildCount() > 0) {
            parentNode.removeAllChildren();
        }
        PropertyCollection properties = BgEntityUtil.getAllEntityProperties((EntityObjectInfo)entity);
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            VirtualMetaInfo childDataObject = new VirtualMetaInfo();
            childDataObject.setNodeLevel(dataObject.getNodeLevel() + 1);
            BgLocaleHelper.copyMultiLangField((IObjectValue)childDataObject, (IObjectValue)propertyInfo, (String)"alias", (String)"alias");
            childDataObject.setName(this.getValue(dataObject, propertyInfo.getName()));
            childDataObject.setExtendValue(this.getExtendValue(dataObject, propertyInfo));
            DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)childDataObject);
            childNode.setText(BgEntityUtil.getPropertyAlias((PropertyInfo)propertyInfo));
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo own = (OwnPropertyInfo)propertyInfo;
                if (own.getMappingField() == null) continue;
                childDataObject.setDataType(own.getDataType());
                childDataObject.setMultilingual(own.isMultilingual());
                childDataObject.setTableField(own.getMappingField().getName());
                if (((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.BYTEARRAY)) continue;
            }
            if (propertyInfo instanceof LinkPropertyInfo) {
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propertyInfo;
                EntityObjectInfo childEntity = linkProp.getRelationship().getChildObject(entity);
                if (childEntity.getFullName().equals(this.rootEntity.getFullName())) continue;
                if ("com.kingdee.eas.basedata.master.auxacct.app.GeneralAsstActType".equals(childEntity.getFullName()) && this.getGenAssActTypeMap().containsKey(linkProp.getRealName())) {
                    childNode.setText((String)this.getGenAssActTypeMap().get(linkProp.getRealName()));
                }
                childDataObject.setEntity(childEntity);
                childNode.setAllowsChildren(true);
                parentNode.add((MutableTreeNode)childNode);
                childNode.add((MutableTreeNode)new DefaultKingdeeTreeNode());
                continue;
            }
            childNode.setAllowsChildren(false);
            parentNode.add((MutableTreeNode)childNode);
        }
    }

    private String getValue(VirtualMetaInfo parent, String propertyName) {
        String value = "";
        String parentValue = parent.getName();
        value = parentValue.length() == 0 ? propertyName : parentValue + "." + propertyName;
        return value;
    }

    private String getExtendValue(VirtualMetaInfo parent, PropertyInfo propertyInfo) {
        String extendValue = "";
        String parentExtendValue = parent.getExtendValue();
        String refEntityName = null;
        if (propertyInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            refEntityName = BgEntityUtil.getEntity((String)parentExtendValue, (LinkPropertyInfo)linkPropertyInfo).getFullName();
        }
        extendValue = refEntityName == null ? parentExtendValue : refEntityName;
        return extendValue;
    }
}

