/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.gpgc.HQBalanceInfo;
import com.kingdee.eas.custom.gpgc.app.AbstractGpgcReportFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class GpgcReportFacadeControllerBean
extends AbstractGpgcReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.custom.gpgc.app.GpgcReportFacadeControllerBean");

    @Override
    protected void _saveAccountBalance(Context ctx, HashMap mapValue) throws BOSException, EASBizException {
        Connection cn = null;
        PreparedStatement stmt = null;
        String sql = "insert into t_gpgc_accountbalance(fbanktype,faccountnumber,finbalance,foutbalance,fspecbalance,fdate) values(?,?,?,?,?,?)";
        Date date = new Date(new java.util.Date().getTime());
        try {
            this.delete(ctx, date, "t_gpgc_accountbalance");
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            Iterator itor = mapValue.keySet().iterator();
            while (itor.hasNext()) {
                String key = itor.next().toString();
                int index = key.indexOf("__");
                if (index == -1) continue;
                stmt.setString(1, key.substring(0, index));
                stmt.setString(2, key.substring(index + 2));
                double[] values = (double[])mapValue.get(key);
                stmt.setDouble(3, values[0]);
                stmt.setDouble(4, values[1]);
                stmt.setDouble(5, values[2]);
                stmt.setDate(6, date);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private void delete(Context ctx, Date date, String table) throws BOSException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = " fdate = {ts'" + sf.format(date) + "'}";
        String sql = "delete from " + table + " where " + strDate;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _saveHQBalance(Context ctx, HashMap mapValue) throws BOSException, EASBizException {
        Connection cn = null;
        PreparedStatement stmt = null;
        String sql = "insert into t_gpgc_hqbalance(FNumber,faccountnumber,ffixed,fcurrent,fspec,fdate) values(?,?,?,?,?,?)";
        Date date = new Date(new java.util.Date().getTime());
        HQBalanceInfo info = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            Iterator itor = mapValue.keySet().iterator();
            while (itor.hasNext()) {
                String key = itor.next().toString();
                info = (HQBalanceInfo)mapValue.get(key);
                stmt.setString(1, info.bankType);
                stmt.setString(2, info.accountNumber);
                stmt.setDouble(3, info.fixed);
                stmt.setDouble(4, info.current);
                stmt.setDouble(5, info.spec);
                stmt.setDate(6, date);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    @Override
    protected void _updDesc(Context ctx) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        String sql = "update t_be_transdetail set fdescription_l1 = substring(fdescription_l2,1,3)";
        try {
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            stmt.execute(sql);
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    @Override
    protected void _importTransDetail(Context ctx, List lstData) throws BOSException, EASBizException {
        String sql = "insert into t_be_transdetail(fid,fcompanyid,fcurrencyid,fbankaccountid,fbankinterfacetype,fbiztime,fdescription_l1,fdescription_l2,fisdebit,fdebitamount,fcreditamount,ftransbalance,FOppUnit,FOppBankNumber,FOppBank) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Connection cn = null;
        PreparedStatement stmt = null;
        HashMap mapCurrency = null;
        String bosType = "380D4F63";
        try {
            cn = this.getConnection(ctx);
            mapCurrency = this.getCurrency(cn);
            stmt = cn.prepareStatement(sql);
            int size = lstData.size();
            for (int i = 0; i < size; ++i) {
                String[] arrs = (String[])lstData.get(i);
                int j = 0;
                int k = 0;
                String id = BOSUuid.create((String)bosType).toString();
                stmt.setString(++j, id);
                stmt.setString(++j, arrs[k++]);
                stmt.setString(++j, this.getCurrencyId(mapCurrency, arrs[k++]));
                stmt.setString(++j, arrs[k++]);
                stmt.setInt(++j, this.stringToInt(arrs[k++]));
                stmt.setDate(++j, this.stringToDateTime(arrs[k++]));
                stmt.setString(++j, arrs[++k]);
                stmt.setString(++j, arrs[k++]);
                this.setIsDebit(stmt, arrs, ++j, k);
                int n = ++k;
                stmt.setBigDecimal(++j, this.stringToBigDecimal(arrs[n]));
                int n2 = ++k;
                stmt.setBigDecimal(++j, this.stringToBigDecimal(arrs[n2]));
                int n3 = ++k;
                ++k;
                stmt.setBigDecimal(++j, this.stringToBigDecimal(arrs[n3]));
                int n4 = ++k;
                stmt.setString(++j, arrs[n4]);
                int n5 = ++k;
                stmt.setString(++j, arrs[n5]);
                int n6 = ++k;
                ++k;
                stmt.setString(++j, arrs[n6]);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private void setIsDebit(PreparedStatement stmt, String[] values, int index, int pos) throws SQLException {
        if (values[pos].trim().equalsIgnoreCase("0") || values[pos].length() == 0) {
            stmt.setInt(index, 1);
        } else {
            stmt.setInt(index, 0);
        }
    }

    private String getCurrencyId(HashMap map, String name) {
        if (!map.containsKey(name)) {
            return "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
        }
        return (String)map.get(name);
    }

    private HashMap getCurrency(Connection cn) throws BOSException {
        Statement stmt = null;
        ResultSet rs = null;
        HashMap<String, String> mapCurrency = new HashMap<String, String>();
        String sql = "select fid,fname_l2 from t_bd_currency";
        try {
            stmt = cn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                mapCurrency.put(rs.getString(2).trim(), rs.getString(1));
            }
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return mapCurrency;
    }

    private int stringToInt(String value) {
        int i = 2;
        try {
            i = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    private BigDecimal stringToBigDecimal(String value) {
        BigDecimal big = new BigDecimal("0.0");
        try {
            big = new BigDecimal(value);
        }
        catch (Exception e) {
            big = new BigDecimal("0.0");
        }
        return big;
    }

    private Date stringToDate(String value) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date date = new java.util.Date();
        try {
            date = sf.parse(value);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return new Date(date.getTime());
    }

    private Date stringToDateTime(String value) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date date = new java.util.Date();
        try {
            date = sf.parse(value);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return new Date(date.getTime());
    }
}

