/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.crbg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;

public class BgCrbgUtils {
    public static String getNewNumber(Context ctx, CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return null;
        }
        String result = null;
        try {
            if (ctx != null) {
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                result = codingRuleManager.getNumber((IObjectValue)info, companyId);
            } else {
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                result = codingRuleManager.getNumber((IObjectValue)info, companyId);
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, String companyId) {
        if (info != null && companyId != null && !companyId.equals("")) {
            try {
                ICodingRuleManager codingRuleManager = null;
                codingRuleManager = ctx != null ? CodingRuleManagerFactory.getLocalInstance((Context)ctx) : CodingRuleManagerFactory.getRemoteInstance();
                if (codingRuleManager.isExist((IObjectValue)info, companyId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                    codingRuleManager.recycleNumber((IObjectValue)info, companyId, info.getString("number"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static FilterInfo getCheckNumberDupFilter(IObjectValue model, boolean isNeedComp) {
        FilterInfo filter = new FilterInfo();
        if (isNeedComp) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)model.getObjectValue("company").getBOSUuid("id")));
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)model.getString("number")));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        return filter;
    }

    public static boolean isRuleAutoNumber(Context ctx, CoreBaseInfo info, String strCompanyID) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = null;
        iCodingRuleManager = ctx != null ? CodingRuleManagerFactory.getLocalInstance((Context)ctx) : CodingRuleManagerFactory.getRemoteInstance();
        return iCodingRuleManager.isExist((IObjectValue)info, strCompanyID);
    }

    public static boolean isCreatNumAddView(Context ctx, CoreBaseInfo info, String strCompanyID) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = null;
        iCodingRuleManager = ctx != null ? CodingRuleManagerFactory.getLocalInstance((Context)ctx) : CodingRuleManagerFactory.getRemoteInstance();
        return iCodingRuleManager.isExist((IObjectValue)info, strCompanyID) && !iCodingRuleManager.isAddView((IObjectValue)info, strCompanyID);
    }
}

