/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.crbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.IBgCtrlHandler;
import com.kingdee.eas.ma.crbg.BgUsefundEntryInfo;
import com.kingdee.eas.ma.crbg.BgUsefundFactory;
import com.kingdee.eas.ma.crbg.BgUsefundInfo;
import com.kingdee.eas.ma.crbg.BillstateEnum;
import com.kingdee.eas.ma.crbg.IBgUsefund;

public class BgCtrlUseFundHandler
implements IBgCtrlHandler {
    public BgCtrlParamCollection getParameters(Context ctx, String billId) throws BOSException, EASBizException {
        boolean noPass = false;
        BgCtrlParamCollection result = new BgCtrlParamCollection();
        IBgUsefund ibgUseFund = null;
        ibgUseFund = ctx == null ? BgUsefundFactory.getRemoteInstance() : BgUsefundFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("ApplyTime"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("entrys.pjNum"));
        sic.add(new SelectorItemInfo("entrys.pjName.*"));
        sic.add(new SelectorItemInfo("entrys.CurApplyAmt"));
        sic.add(new SelectorItemInfo("entrys.contNum.*"));
        sic.add(new SelectorItemInfo("billstate"));
        BgUsefundInfo info = ibgUseFund.getBgUsefundInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        if (info.getBillstate() == BillstateEnum.NOPASS) {
            noPass = true;
        }
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            BgUsefundEntryInfo entryInfo = info.getEntrys().get(i);
            BgCtrlParamInfo ctrlInfo = new BgCtrlParamInfo();
            ctrlInfo.setOrgUnitId(info.getOrgUnit().getId().toString());
            ctrlInfo.setCurrencyNumber(info.getCurrency().getNumber());
            ctrlInfo.setSrcBillId(billId);
            ctrlInfo.setSrcBillNumber(info.getNumber());
            if (entryInfo.getContNum() != null) {
                ctrlInfo.setItemCombinNumber(entryInfo.getPjNum() + "," + entryInfo.getContNum().getNumber());
                ctrlInfo.setItemCombinName(entryInfo.getPjName().getName().toString() + "_" + entryInfo.getContNum().getContractNum());
            } else {
                ctrlInfo.setItemCombinNumber(entryInfo.getPjNum());
                ctrlInfo.setItemCombinName(entryInfo.getPjName().getName().toString());
            }
            ctrlInfo.setBizDate(info.getApplyTime());
            if (noPass) {
                ctrlInfo.setAmount(entryInfo.getCurApplyAmt().negate());
            } else {
                ctrlInfo.setAmount(entryInfo.getCurApplyAmt());
            }
            result.add(ctrlInfo);
        }
        return result;
    }
}

