/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.crbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillBizException;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ICheque;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.crbg.BgContDBFactory;
import com.kingdee.eas.ma.crbg.BgContDBInfo;
import com.kingdee.eas.ma.crbg.BgContractFactory;
import com.kingdee.eas.ma.crbg.BgFundApplyEntryCollection;
import com.kingdee.eas.ma.crbg.BgFundApplyEntryInfo;
import com.kingdee.eas.ma.crbg.BgFundApplyFactory;
import com.kingdee.eas.ma.crbg.BgFundApplyInfo;
import com.kingdee.eas.ma.crbg.BillstateEnum;
import com.kingdee.eas.ma.crbg.CREasBizException;
import com.kingdee.eas.ma.crbg.IBgContDB;
import com.kingdee.eas.ma.crbg.IBgFundApply;
import com.kingdee.eas.ma.crbg.RecPayTypeEnum;
import com.kingdee.eas.ma.crbg.app.AbstractBgFundApplyControllerBean;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class BgFundApplyControllerBean
extends AbstractBgFundApplyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.crbg.app.BgFundApplyControllerBean");

    @Override
    public void audited(Context ctx, String model, String auditId) throws BOSException {
        super.audited(ctx, model, auditId);
        try {
            IBgFundApply bizApply = BgFundApplyFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(model);
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
            }
            BgFundApplyInfo info = this.getBgFundApplyInfo(ctx, (IObjectPK)new ObjectUuidPK(model));
            if (info != null) {
                info.setBillstate(BillstateEnum.AUDITED);
                IUser iuser = UserFactory.getLocalInstance((Context)ctx);
                if (auditId != null) {
                    info.setAuditor(iuser.getUserInfo((IObjectPK)new ObjectUuidPK(auditId)));
                }
                bizApply.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        catch (OtherBillBizException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void submitWF(Context ctx, BgFundApplyInfo model) throws BOSException {
        super.submitWF(ctx, model);
        System.out.println("china one ");
    }

    @Override
    public void dealed(Context ctx, String id) throws BOSException {
        super.dealed(ctx, id);
        if (id == null) {
            return;
        }
        try {
            IBgFundApply bizApply = BgFundApplyFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(id);
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
            }
            BgFundApplyInfo info = this.getBgFundApplyInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
            if (info != null) {
                info.setBillstate(BillstateEnum.DEALED);
                bizApply.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        catch (OtherBillBizException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean _deal(Context ctx, IObjectValue model) throws BOSException {
        BgFundApplyInfo info = (BgFundApplyInfo)model;
        boolean flag = true;
        try {
            IBgFundApply bizApply = BgFundApplyFactory.getLocalInstance(ctx);
            IBgContDB contDB = BgContDBFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(info.getId());
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
            }
            BgFundApplyEntryCollection entryCol = info.getEntrys();
            int entryCount = entryCol.size();
            for (int i = 0; i < entryCount; ++i) {
                BgFundApplyEntryInfo entryInfo = entryCol.get(i);
                if (entryInfo.getContNum() == null) continue;
                BOSUuid id = entryInfo.getContNum().getId();
                ObjectUuidPK contDBPK = new ObjectUuidPK(id);
                BgContDBInfo contDBInfo = contDB.getBgContDBInfo((IObjectPK)contDBPK);
                contDBInfo.setContApplyedAmt(contDBInfo.getContApplyedAmt().subtract(entryInfo.getCurPayAmt()));
                contDB.update((IObjectPK)contDBPK, (CoreBaseInfo)contDBInfo);
            }
            if (info != null) {
                bizApply.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        catch (OtherBillBizException e) {
            e.printStackTrace();
            flag = false;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            flag = false;
        }
        catch (BOSException e) {
            e.printStackTrace();
            flag = false;
        }
        flag = true;
        return true;
    }

    @Override
    protected boolean _submitCashier(Context ctx, IObjectValue model) throws BOSException {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeOff(Context ctx, BgFundApplyInfo model) throws BOSException {
        super.writeOff(ctx, model);
        BgFundApplyInfo info = model;
        IBgFundApply bizApply = BgFundApplyFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        try {
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (info == null) return;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return;
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _noPass(Context ctx, String id) throws BOSException {
        IBgFundApply bizApply = BgFundApplyFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        try {
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
            }
            BgFundApplyInfo info = this.getBgFundApplyInfo(ctx, (IObjectPK)pk);
            if (info != null) {
                info.setBillstate(BillstateEnum.NOPASS);
                bizApply.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _auditing(Context ctx, String id) throws BOSException {
        IBgFundApply bizApply = BgFundApplyFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        try {
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
            }
            BgFundApplyInfo info = this.getBgFundApplyInfo(ctx, (IObjectPK)pk);
            if (info != null) {
                info.setBillstate(BillstateEnum.AUDITING);
                bizApply.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _end(Context ctx, String id) throws BOSException {
        IBgFundApply bizApply = BgFundApplyFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        try {
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
            }
            BgFundApplyInfo info = this.getBgFundApplyInfo(ctx, (IObjectPK)pk);
            if (info != null) {
                info.setBillstate(BillstateEnum.END);
                bizApply.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void delete(Context arg0, IObjectPK arg1) throws BOSException, EASBizException {
        BgFundApplyInfo bgFundApplyInfo = BgFundApplyFactory.getLocalInstance(arg0).getBgFundApplyInfo(arg1);
        if (bgFundApplyInfo.getBillstate() != null && !bgFundApplyInfo.getBillstate().equals((Object)BillstateEnum.EDITING) && !bgFundApplyInfo.getBillstate().equals((Object)BillstateEnum.NOPASS)) {
            throw new CREasBizException(CREasBizException.NODELETE);
        }
        super.delete(arg0, arg1);
    }

    @Override
    protected String _writeNote(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BgFundApplyInfo billInfo = null;
        try {
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new CREasBizException(CREasBizException.BILL_NOTEXIST);
            }
            billInfo = this.getBgFundApplyInfo(ctx, (IObjectPK)pk);
            if (billInfo == null) {
                throw new CREasBizException(CREasBizException.BILL_NOTEXIST);
            }
            if (billInfo.isIsNoted()) {
                throw new CREasBizException(CREasBizException.BILL_NOTED);
            }
            billInfo.setIsNoted(true);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)billInfo);
        }
        catch (UuidException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected int _cancelNote(Context ctx, String id) throws BOSException, EASBizException {
        ICheque chequeCtl = ChequeFactory.getLocalInstance((Context)ctx);
        BgFundApplyInfo billInfo = null;
        ChequeInfo cheque = null;
        ObjectUuidPK pk = new ObjectUuidPK(id);
        ObjectUuidPK pkCheque = null;
        String chequeNum = null;
        try {
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new CREasBizException(CREasBizException.BILL_NOTEXIST);
            }
            billInfo = this.getBgFundApplyInfo(ctx, (IObjectPK)pk);
            if (billInfo == null) {
                throw new CREasBizException(CREasBizException.BILL_NOTEXIST);
            }
            if (!billInfo.isIsNoted()) {
                throw new CREasBizException(CREasBizException.BILL_NOTNOTED);
            }
            if (billInfo.getNtTypeNum() == null) {
                throw new CREasBizException(CREasBizException.CHEQUENUMISNULL);
            }
            chequeNum = billInfo.getNtTypeNum().getId().toString();
            pkCheque = new ObjectUuidPK(chequeNum);
            exist = chequeCtl.exists((IObjectPK)pkCheque);
            if (!exist) {
                throw new CREasBizException(CREasBizException.CHEQUENUMISNULL);
            }
            cheque = chequeCtl.getChequeInfo((IObjectPK)pkCheque);
            if (cheque == null) {
                throw new CREasBizException(CREasBizException.CHEQUENUMISNULL);
            }
            cheque.setIsAbandon(true);
            chequeCtl.abandon((IObjectPK)pkCheque, cheque);
            billInfo.setNtTypeNum(null);
            billInfo.setIsNoted(false);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)billInfo);
        }
        catch (UuidException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    @Override
    protected void _getBackAmt(Context ctx, String billid) throws BOSException, CREasBizException {
        try {
            BgFundApplyInfo billInfo = this.getBgFundApplyInfo(ctx, (IObjectPK)new ObjectUuidPK(billid));
            IBgItem bgItem = BgItemFactory.getLocalInstance((Context)ctx);
            Object itemInfo = null;
            int count = billInfo.getEntrys().size();
            for (int i = 0; i < count; ++i) {
                if (billInfo.getEntrys().get(i).getPjName() == null || billInfo.getEntrys().get(i).getContNum() == null || billInfo.getEntrys().get(i).getCurPayAmt() == null) continue;
                if (billInfo.getBillstate() == BillstateEnum.NOPASS) {
                    BgContractFactory.getLocalInstance(ctx).writebackAmount(billInfo.getEntrys().get(i).getContNum().getId().toString(), RecPayTypeEnum.pay, billInfo.getEntrys().get(i).getPjName().getId().toString(), billInfo.getEntrys().get(i).getCurPayAmt().negate());
                    continue;
                }
                BgContractFactory.getLocalInstance(ctx).writebackAmount(billInfo.getEntrys().get(i).getContNum().getId().toString(), RecPayTypeEnum.pay, billInfo.getEntrys().get(i).getPjName().getId().toString(), billInfo.getEntrys().get(i).getCurPayAmt().abs().negate());
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _substractAmt(Context ctx, String billid) throws BOSException, CREasBizException {
        try {
            BgFundApplyInfo billInfo = this.getBgFundApplyInfo(ctx, (IObjectPK)new ObjectUuidPK(billid));
            IBgItem bgItem = BgItemFactory.getLocalInstance((Context)ctx);
            Object itemInfo = null;
            int count = billInfo.getEntrys().size();
            for (int i = 0; i < count; ++i) {
                if (billInfo.getEntrys().get(i).getPjName() == null || billInfo.getEntrys().get(i).getContNum() == null || billInfo.getEntrys().get(i).getCurPayAmt() == null) continue;
                BgContractFactory.getLocalInstance(ctx).writebackAmount(billInfo.getEntrys().get(i).getContNum().getId().toString(), RecPayTypeEnum.pay, billInfo.getEntrys().get(i).getPjName().getId().toString(), billInfo.getEntrys().get(i).getCurPayAmt());
            }
            billInfo.setBillstate(BillstateEnum.EDITING);
            this._update(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), (IObjectValue)billInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _checkInfo(Context ctx, IObjectValue model) throws BOSException {
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgFundApplyInfo bgFundApplyInfo = (BgFundApplyInfo)model;
        if (bgFundApplyInfo.getBillstate() == null) {
            bgFundApplyInfo.setBillstate(BillstateEnum.EDITING);
        }
        return super._addnew(ctx, model);
    }

    @Override
    protected boolean _checkAmount(Context ctx, String id) throws BOSException, EASBizException {
        boolean flag = true;
        IBgFundApply ibizApply = BgFundApplyFactory.getLocalInstance(ctx);
        BgFundApplyInfo info = ibizApply.getBgFundApplyInfo((IObjectPK)new ObjectUuidPK(id));
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        boolean exist = this.exists(ctx, (IObjectPK)pk);
        if (!exist) {
            throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
        }
        BgFundApplyEntryCollection entryCol = info.getEntrys();
        int entryCount = entryCol.size();
        for (int i = 0; i < entryCount; ++i) {
            BgFundApplyEntryInfo entryInfo = entryCol.get(i);
            if (entryInfo.getCurPayAmt().compareTo(new BigDecimal(0)) <= 0) continue;
            flag = true;
            return true;
        }
        return false;
    }
}

