/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.crbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.ma.crbg.BgCrbgUtils;
import com.kingdee.eas.ma.crbg.CREasBizException;
import com.kingdee.eas.ma.crbg.CrbgBillBaseInfo;
import com.kingdee.eas.ma.crbg.app.AbstractCrbgBillBaseControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public abstract class CrbgBillBaseControllerBean
extends AbstractCrbgBillBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.crbg.app.CrbgBillBaseControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("number"));
        sc.add(new SelectorItemInfo("name"));
        sc.add(new SelectorItemInfo("company"));
        CrbgBillBaseInfo aCrbgBillBaseInfo = this.getCrbgBillBaseInfo(ctx, pk, sc);
        BgCrbgUtils.recycleNumber(ctx, (CoreBaseInfo)aCrbgBillBaseInfo, aCrbgBillBaseInfo.getCompany().getId().toString());
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CrbgBillBaseInfo info = (CrbgBillBaseInfo)model;
        if (info.getCU() == null) {
            info.setCU(super.getCU(ctx, (ObjectBaseInfo)info));
        }
        boolean isAddNew = this.isAddNew(ctx, (IObjectValue)info);
        String strCompanyID = info.getCompany().getId().toString();
        boolean isRuleAutoNumber = this.isRuleAutoNumber(ctx, info, strCompanyID);
        if (info.getNumber() == null || info.getNumber().toString().equals("")) {
            this.setBillNewNumber(ctx, (IObjectValue)info, isAddNew, isRuleAutoNumber, strCompanyID);
        }
        if (isAddNew && !isRuleAutoNumber) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            boolean isNeedCheck = true;
            if ((info.getNumber() == null || info.getNumber().toString().equals("")) && iCodingRuleManager.isExist((IObjectValue)info, strCompanyID) && iCodingRuleManager.isAddView((IObjectValue)info, strCompanyID)) {
                this.setBillNewNumber(ctx, (IObjectValue)info, isAddNew, true, strCompanyID);
                isNeedCheck = false;
            }
            if (isNeedCheck) {
                this.crbgCheckNumberBlank(ctx, (IObjectValue)info);
            }
        }
        if (!isAddNew || !isRuleAutoNumber) {
            this._checkNumberDup(ctx, null, (IObjectValue)info);
        }
        if (!isAddNew) {
            CrbgBillBaseInfo aCrbgBillBaseInfo = this.getDataNewStatus(ctx, (IObjectValue)info);
            this.checkSubmit(ctx, (IObjectValue)aCrbgBillBaseInfo, true);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        Object strCompanyID;
        CrbgBillBaseInfo info = (CrbgBillBaseInfo)model;
        boolean isAddNew = this.isAddNew(ctx, (IObjectValue)info);
        if (info.getCompany() != null) {
            strCompanyID = info.getCompany().getId().toString();
            boolean isRuleAutoNumber = this.isRuleAutoNumber(ctx, info, (String)strCompanyID);
            if (info.getCU() == null) {
                info.setCU(super.getCU(ctx, (ObjectBaseInfo)info));
            }
            if (info.getNumber() == null || info.getNumber().toString().equals("")) {
                this.setBillNewNumber(ctx, (IObjectValue)info, isAddNew, isRuleAutoNumber, (String)strCompanyID);
            }
            if (isAddNew && !isRuleAutoNumber) {
                this.crbgCheckNumberBlank(ctx, (IObjectValue)info);
            }
            if (!isAddNew || !isRuleAutoNumber) {
                this._checkNumberDup(ctx, null, model);
            }
        }
        if (!isAddNew) {
            strCompanyID = this.getDataNewStatus(ctx, (IObjectValue)info);
        }
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._passAudit(ctx, pk, model);
        if (model == null) {
            return;
        }
        CrbgBillBaseInfo aCrbgBillBaseInfo = (CrbgBillBaseInfo)model;
        if (!this.isAddNew(ctx, (IObjectValue)aCrbgBillBaseInfo)) {
            CrbgBillBaseInfo checkInfo = this.getDataNewStatus(ctx, (IObjectValue)aCrbgBillBaseInfo);
            this.checkSubmit(ctx, (IObjectValue)checkInfo, false);
        }
        this.updateBillStatus(ctx, model, true, 13);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._unpassAudit(ctx, pk, model);
        if (model == null) {
            return;
        }
        CrbgBillBaseInfo aCrbgBillBaseInfo = (CrbgBillBaseInfo)model;
        if (!this.isAddNew(ctx, (IObjectValue)aCrbgBillBaseInfo)) {
            CrbgBillBaseInfo checkInfo = this.getDataNewStatus(ctx, (IObjectValue)aCrbgBillBaseInfo);
            this.checkSubmit(ctx, (IObjectValue)checkInfo, true);
        }
        this.updateBillStatus(ctx, model, false, 12);
    }

    protected boolean checkSubmit(Context ctx, IObjectValue model, boolean isOk) throws EASBizException, BOSException {
        CrbgBillBaseInfo aCrbgBillBaseInfo = (CrbgBillBaseInfo)model;
        return true;
    }

    protected boolean isAddNew(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        boolean ret = false;
        CrbgBillBaseInfo aCrbgBillBaseInfo = (CrbgBillBaseInfo)model;
        ret = aCrbgBillBaseInfo.getId() == null || aCrbgBillBaseInfo.getId().toString().trim().length() == 0 || !this._exists(ctx, (IObjectPK)new ObjectUuidPK(aCrbgBillBaseInfo.getId()));
        return ret;
    }

    protected void setBillNewNumber(Context ctx, IObjectValue model, boolean isAddNew, boolean isRuleAutoNumber, String strCompanyID) throws BOSException, EASBizException {
        CrbgBillBaseInfo aCrbgBillBaseInfo = (CrbgBillBaseInfo)model;
        if (isAddNew) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo cr = iCodingRuleManager.getCodingRule((IObjectValue)aCrbgBillBaseInfo, strCompanyID);
            if (cr != null && !cr.isOrgFirst()) {
                aCrbgBillBaseInfo.setNumber(this.getNewNumber(ctx, (IObjectValue)aCrbgBillBaseInfo, strCompanyID, ""));
            }
            if (isRuleAutoNumber) {
                aCrbgBillBaseInfo.setNumber(this.getNewNumber(ctx, (IObjectValue)aCrbgBillBaseInfo, strCompanyID, ""));
            }
        }
    }

    protected String getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CrbgBillBaseInfo aCrbgBillBaseInfo = (CrbgBillBaseInfo)model;
        String number = "";
        number = iCodingRuleManager.getNumber((IObjectValue)aCrbgBillBaseInfo, strCompanyID, customString);
        aCrbgBillBaseInfo.setNumber(number);
        ObjectUuidPK pk = new ObjectUuidPK(aCrbgBillBaseInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aCrbgBillBaseInfo)) {
            String newNumber = "";
            newNumber = iCodingRuleManager.getNumber((IObjectValue)aCrbgBillBaseInfo, strCompanyID, customString);
            if (newNumber.equals(aCrbgBillBaseInfo.getNumber())) {
                throw new CREasBizException(CREasBizException.NUMBERRULEERROR);
            }
            number = newNumber;
            aCrbgBillBaseInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aCrbgBillBaseInfo)) {
                return this.getNewNumber(ctx, (IObjectValue)aCrbgBillBaseInfo, strCompanyID, customString);
            }
        }
        return number;
    }

    protected boolean isRuleAutoNumber(Context ctx, CrbgBillBaseInfo aCrbgBillBaseInfo, String strCompanyID) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return iCodingRuleManager.isExist((IObjectValue)aCrbgBillBaseInfo, strCompanyID) && !iCodingRuleManager.isAddView((IObjectValue)aCrbgBillBaseInfo, strCompanyID);
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CrbgBillBaseInfo aCrbgBillBaseInfo = (CrbgBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)aCrbgBillBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aCrbgBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aCrbgBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aCrbgBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aCrbgBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected boolean rolbackNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String strCompanyID;
        CrbgBillBaseInfo aCrbgBillBaseInfo = (CrbgBillBaseInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)aCrbgBillBaseInfo, strCompanyID = aCrbgBillBaseInfo.getCompany().getId().toString()) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)aCrbgBillBaseInfo, strCompanyID)) {
            return iCodingRuleManager.recycleNumber((IObjectValue)aCrbgBillBaseInfo, strCompanyID, aCrbgBillBaseInfo.getNumber());
        }
        return false;
    }

    protected boolean crbgCheckNumberBlank(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CrbgBillBaseInfo aCrbgBillBaseInfo = (CrbgBillBaseInfo)model;
        String number = aCrbgBillBaseInfo.getNumber();
        if (number == null || number.equals("")) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK, new Object[]{"number"});
        }
        return true;
    }

    protected CrbgBillBaseInfo getDataNewStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CrbgBillBaseInfo info = (CrbgBillBaseInfo)model;
        CrbgBillBaseInfo bCrbgBillBaseInfo = null;
        ObjectUuidPK pkNew = new ObjectUuidPK(info.getId());
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("name"));
        sc.add(new SelectorItemInfo("number"));
        sc.add(new SelectorItemInfo("billstate"));
        bCrbgBillBaseInfo = (CrbgBillBaseInfo)this._getValue(ctx, (IObjectPK)pkNew, sc);
        return bCrbgBillBaseInfo;
    }

    public void updateBillStatus(Context ctx, IObjectValue model, boolean isAudit, int billStatus) throws EASBizException, BOSException {
        String tableName = this.getMainTableName(ctx, model);
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        CrbgBillBaseInfo aCrbgBillBaseInfo = (CrbgBillBaseInfo)model;
        Connection conn = null;
        PreparedStatement preStmt = null;
        Statement sm = null;
        try {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditorID = ? , FBillState = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sqlBuff.toString());
            UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (isAudit) {
                preStmt.setString(1, aUserInfo.getId().toString());
            } else {
                preStmt.setString(1, null);
            }
            preStmt.setInt(2, billStatus);
            preStmt.setString(3, aCrbgBillBaseInfo.getId().toString());
            preStmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmt, conn);
                SQLUtils.cleanup(sm, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
        SQLUtils.cleanup(sm, (Connection)conn);
    }

    public String getMainTableName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(model.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        return tableName;
    }
}

