/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.crbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.crbg.BgContractFactory;
import com.kingdee.eas.ma.crbg.BillstateEnum;
import com.kingdee.eas.ma.crbg.CREasBizException;
import com.kingdee.eas.ma.crbg.IReceiveBill;
import com.kingdee.eas.ma.crbg.RecPayTypeEnum;
import com.kingdee.eas.ma.crbg.ReceiveBillFactory;
import com.kingdee.eas.ma.crbg.ReceiveBillInfo;
import com.kingdee.eas.ma.crbg.app.AbstractReceiveBillControllerBean;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ReceiveBillControllerBean
extends AbstractReceiveBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.crbg.app.ReceiveBillControllerBean");

    @Override
    public void audited(Context ctx, String model) throws BOSException {
        super.audited(ctx, model);
        try {
            IReceiveBill bizApply = ReceiveBillFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(model);
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
            }
            ReceiveBillInfo info = this.getReceiveBillInfo(ctx, (IObjectPK)new ObjectUuidPK(model));
            IObjectPK oid = ctx.getCaller();
            UserInfo uinfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(oid);
            if (info != null) {
                info.setBillstate(BillstateEnum.AUDITED);
                info.setAuditor(uinfo);
                bizApply.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        catch (OtherBillBizException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected void _save(Context arg0, IObjectPK arg1, IObjectValue arg2) throws BOSException, EASBizException {
        ReceiveBillInfo rinfo = ReceiveBillFactory.getLocalInstance(arg0).getReceiveBillInfo(arg1);
        if (rinfo.getBillstate() != null && !rinfo.getBillstate().equals((Object)BillstateEnum.EDITING)) {
            throw new CREasBizException(CREasBizException.RECEIVEBILLSTATE1);
        }
        super._save(arg0, arg1, arg2);
    }

    protected void _submit(Context arg0, IObjectPK arg1, IObjectValue arg2) throws BOSException, EASBizException {
        super._submit(arg0, arg1, arg2);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (arrayPK == null) {
            return;
        }
        for (int i = 0; i < arrayPK.length; ++i) {
            this._delete(ctx, arrayPK[i]);
        }
    }

    @Override
    protected void _delete(Context arg0, IObjectPK arg1) throws BOSException, EASBizException {
        ReceiveBillInfo rinfo = ReceiveBillFactory.getLocalInstance(arg0).getReceiveBillInfo(arg1);
        if (rinfo.getBillstate() != null && !rinfo.getBillstate().equals((Object)BillstateEnum.EDITING) && !rinfo.getBillstate().equals((Object)BillstateEnum.NOPASS)) {
            throw new CREasBizException(CREasBizException.RECEIVEBILLSTATE1);
        }
        super._delete(arg0, arg1);
    }

    @Override
    protected void _auditAccounter(Context ctx, String billid) throws BOSException {
    }

    @Override
    protected void _auditCasher(Context ctx, String billid) throws BOSException {
    }

    @Override
    protected void _subtractAmount(Context ctx, String billid) throws BOSException {
        try {
            ReceiveBillInfo billInfo = this.getReceiveBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billid));
            IBgItem bgItem = BgItemFactory.getLocalInstance((Context)ctx);
            Object itemInfo = null;
            int count = billInfo.getEntrys().size();
            for (int i = 0; i < count; ++i) {
                if (billInfo.getEntrys().get(i).getPjCommonNum() == null || billInfo.getEntrys().get(i).getContractNum() == null || billInfo.getEntrys().get(i).getCurRecAmt() == null) continue;
                BgContractFactory.getLocalInstance(ctx).writebackAmount(billInfo.getEntrys().get(i).getContractNum().getId().toString(), RecPayTypeEnum.receive, billInfo.getEntrys().get(i).getPjCommonNum().getId().toString(), billInfo.getEntrys().get(i).getCurRecAmt());
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _addAmount(Context ctx, String billid) throws BOSException {
        try {
            ReceiveBillInfo billInfo = this.getReceiveBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billid));
            IBgItem bgItem = BgItemFactory.getLocalInstance((Context)ctx);
            Object itemInfo = null;
            int count = billInfo.getEntrys().size();
            for (int i = 0; i < count; ++i) {
                if (billInfo.getEntrys().get(i).getPjCommonNum() == null || billInfo.getEntrys().get(i).getContractNum() == null || billInfo.getEntrys().get(i).getCurRecAmt() == null) continue;
                BgContractFactory.getLocalInstance(ctx).writebackAmount(billInfo.getEntrys().get(i).getContractNum().getId().toString(), RecPayTypeEnum.receive, billInfo.getEntrys().get(i).getPjCommonNum().getId().toString(), new BigDecimal("0").subtract(billInfo.getEntrys().get(i).getCurRecAmt()));
            }
            billInfo.setBillstate(BillstateEnum.NOPASS);
            this._update(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), (IObjectValue)billInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }
}

