/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemGroupFactory;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgItemGroup;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.nbudget.AbstractBgAnalyseSetInfo;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class BgAnalyseSetInfo
extends AbstractBgAnalyseSetInfo
implements Serializable {
    public BgAnalyseSetInfo() {
    }

    protected BgAnalyseSetInfo(String pkField) {
        super(pkField);
    }

    public Map getDataToMap(Context ctx) throws BOSException, EASBizException {
        String[] str;
        byte[] d = this.getData();
        if (d == null || d.length == 0) {
            return null;
        }
        Object obj = BgAnalyseHelper.getObject((byte[])d);
        if (!(obj instanceof Map)) {
            return null;
        }
        Map dataMap = (Map)obj;
        String schemeData = dataMap.get("schemeData").toString();
        String quotaData = dataMap.get("quotaData").toString();
        String formatData = dataMap.get("formatData").toString();
        String refData = null;
        String[] refs = null;
        String hideNull = "true";
        String[] schemes = schemeData.split("@");
        String[] quotas = quotaData.split("@");
        String[] formats = formatData.split("@");
        if (dataMap.get("refData") != null) {
            refData = dataMap.get("refData").toString();
            refs = refData.split("@");
        }
        if (dataMap.get("hideNull") != null) {
            hideNull = dataMap.get("hideNull").toString();
        }
        IBgPeriod iBgPeriod = null;
        IBgScheme iBgScheme = null;
        IMeasureUnit iMeasureUnit = null;
        IBgItemGroup iItemGroup = null;
        IBgItem iBgItem = null;
        IBgElement iBgElement = null;
        ICurrency iCurrency = null;
        IAccountView iAccountView = null;
        IAccountTable iAccountTable = null;
        if (ctx == null) {
            iBgPeriod = BgPeriodFactory.getRemoteInstance();
            iBgScheme = BgSchemeFactory.getRemoteInstance();
            iMeasureUnit = MeasureUnitFactory.getRemoteInstance();
            iItemGroup = BgItemGroupFactory.getRemoteInstance();
            iBgItem = BgItemFactory.getRemoteInstance();
            iBgElement = BgElementFactory.getRemoteInstance();
            iCurrency = CurrencyFactory.getRemoteInstance();
            iAccountView = AccountViewFactory.getRemoteInstance();
            iAccountTable = AccountTableFactory.getRemoteInstance();
        } else {
            iBgPeriod = BgPeriodFactory.getLocalInstance((Context)ctx);
            iBgScheme = BgSchemeFactory.getLocalInstance((Context)ctx);
            iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
            iItemGroup = BgItemGroupFactory.getLocalInstance((Context)ctx);
            iBgItem = BgItemFactory.getLocalInstance((Context)ctx);
            iBgElement = BgElementFactory.getLocalInstance((Context)ctx);
            iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
            iAccountTable = AccountTableFactory.getLocalInstance((Context)ctx);
        }
        ArrayList schemePeriod = new ArrayList();
        HashMap<Object, Object> temp = new HashMap<Object, Object>();
        for (int index = 0; index < schemes.length; ++index) {
            str = schemes[index].split("#");
            if (str.length <= 1 || StringUtils.isEmpty((String)str[1])) continue;
            String periodId = str[0];
            String schemeId = str[1];
            temp = new HashMap();
            temp.put(iBgPeriod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(periodId), this.getSelector()), iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId), this.getSelector()));
            schemePeriod.add(temp);
        }
        HashMap<String, HashMap<Object, Object>> quotaMap = new HashMap<String, HashMap<Object, Object>>();
        for (int index = 0; index < quotas.length; ++index) {
            str = quotas[index].split("#");
            temp = new HashMap();
            temp.put("name", str[0]);
            if (str.length > 1 && !StringUtils.isEmpty((String)str[1])) {
                temp.put("currency", iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(str[1]), this.getSelector()));
            }
            if (str.length > 2 && !StringUtils.isEmpty((String)str[2])) {
                temp.put("element", iBgElement.getBgElementInfo((IObjectPK)new ObjectUuidPK(str[2]), this.getSelector()));
            }
            if (str.length > 3 && !StringUtils.isEmpty((String)str[3])) {
                temp.put("itemGroup", iItemGroup.getBgItemGroupInfo((IObjectPK)new ObjectUuidPK(str[3]), this.getSelector()));
            }
            if (str.length > 4 && !StringUtils.isEmpty((String)str[4])) {
                String[] items = str[4].split(",");
                HashSet<String> ids = new HashSet<String>();
                for (int it = 0; it < items.length; ++it) {
                    ids.add(items[it]);
                }
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(new FilterInfo());
                view.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                view.setSelector(this.getSelector());
                temp.put("itemColls", iBgItem.getBgItemCollection(view));
            }
            quotaMap.put(str[0], temp);
        }
        HashMap<String, HashMap<Object, Object>> formatMap = new HashMap<String, HashMap<Object, Object>>();
        for (int index = 0; index < formats.length; ++index) {
            str = formats[index].split("#");
            if (str.length <= 3) continue;
            temp = new HashMap();
            temp.put("unit", iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(str[0]), this.getSelector()));
            temp.put("numberType", str[1]);
            temp.put("decimal", str[2]);
            temp.put("permillage", Integer.valueOf(str[3]) != 0);
            formatMap.put(str[1], temp);
        }
        ArrayList<HashMap<Object, Object>> refList = new ArrayList<HashMap<Object, Object>>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                str = refs[i].split("#");
                if (str.length > 1) {
                    temp = new HashMap();
                    temp.put("bgitem", iBgItem.getBgItemInfo((IObjectPK)new ObjectUuidPK(str[0]), this.getSelector()));
                    temp.put("acctTable", iAccountTable.getAccountTableInfo((IObjectPK)new ObjectUuidPK(str[1]), this.getSelector()));
                }
                if (str.length > 2) {
                    String[] acctItems = str[2].split(",");
                    HashSet<String> ids = new HashSet<String>();
                    for (int it = 0; it < acctItems.length; ++it) {
                        ids.add(acctItems[it]);
                    }
                    EntityViewInfo view = new EntityViewInfo();
                    view.setFilter(new FilterInfo());
                    view.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                    view.setSelector(this.getSelector());
                    temp.put("acctItems", iAccountView.getAccountViewCollection(view));
                }
                refList.add(temp);
            }
        }
        dataMap.put("schemeData", schemePeriod);
        dataMap.put("quotaData", quotaMap);
        dataMap.put("formatData", formatMap);
        dataMap.put("refList", refList);
        dataMap.put("hideNull", hideNull);
        return dataMap;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        return sic;
    }
}

