/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.client.BudgetUtilForClient;
import com.kingdee.eas.ma.nbudget.BgCslFormFactory;
import com.kingdee.eas.ma.nbudget.BgCslFormInfo;
import com.kingdee.eas.ma.nbudget.client.BgCslFormEditUI;
import com.kingdee.eas.ma.nbudget.client.BgNProcessUI;
import com.kingdee.eas.util.SysUtil;
import java.util.Map;

public class BgCslFormProvider
extends IBookProvider {
    private BgNProcessUI own = null;
    private String[] sheetIds = null;

    public BgCslFormProvider(BgNProcessUI ui) {
        this.own = ui;
    }

    public IObjectValue createNewReport() throws Exception {
        UIContext uiContext = new UIContext(this.own.getUIContext().get("Owner"));
        uiContext.put((Object)"ORG_UNIT", this.own.getUIContext().get("ORG_UNIT"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean isSubmt = false;
        IObjectValue model = null;
        if (uiWindow.getUIObject() instanceof BgCslFormEditUI) {
            isSubmt = ((BgCslFormEditUI)uiWindow.getUIObject()).isSubmit();
            if (isSubmt) {
                model = uiWindow.getUIObject().getDataObject();
            }
            if (model != null) {
                this.setEditValue(model);
            }
        }
        if (!isSubmt || !(model instanceof BgCslFormInfo)) {
            SysUtil.abort();
        }
        return model;
    }

    public String getBizFactoryName() {
        return "com.kingdee.eas.ma.nbudget.BgCslFormFactory";
    }

    public ICoreBase getBizInterface() throws Exception {
        return BgCslFormFactory.getRemoteInstance();
    }

    public Book loadBook() throws Exception {
        Book book = null;
        if (this.getBgCslFormInfo() == null) {
            this.setEditValue(this.createNewReport());
        }
        if (this.getBgCslFormInfo().getData() != null) {
            book = this.getBgCslFormInfo().getBook();
        }
        if (book != null) {
            if (OprtState.ADDNEW.equals(this.own.getOprtState())) {
                this.sheetIds = new String[book.getSheetCount()];
                int in = book.getSheetCount();
                for (int i = 0; i < in; ++i) {
                    this.sheetIds[i] = book.getSheet(i).getID();
                }
            }
            BudgetUtilForClient.prepareReportInfo4Display((ReportBaseInfo)this.getBgCslFormInfo(), (Book)book);
        }
        return book;
    }

    public void restoreSheetId(Book book) {
        if (book != null && this.sheetIds != null && book.getSheetCount() == this.sheetIds.length) {
            int in = book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                book.getSheet(i).setID(this.sheetIds[i]);
            }
        }
    }

    public void restoreBook(Book book) throws Exception {
        BudgetUtilForClient.prepareReportInfo4Save((ReportBaseInfo)this.getBgCslFormInfo(), (Book)book);
        this.getBgCslFormInfo().setBook(book);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.ma.nbudget.client.BgCslFormEditUI";
    }

    public IObjectValue queryEditData(IObjectPK pk) throws Exception {
        return super.queryEditData(pk);
    }

    public BgCslFormInfo getBgCslFormInfo() {
        BgCslFormInfo info = null;
        if (this.getEditValue() instanceof BgCslFormInfo) {
            info = (BgCslFormInfo)this.getEditValue();
        }
        return info;
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.periodType");
        sic.add("bgScheme.id");
        sic.add("bgScheme.number");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.orgUnit.id");
        sic.add("bgScheme.orgUnit.number");
        sic.add("bgScheme.orgUnit.name");
        sic.add("bgCslTemplate.id");
        sic.add("bgCslTemplate.number");
        sic.add("bgCslTemplate.name");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("cslFormMeasureUnit.id");
        sic.add("cslFormMeasureUnit.bgElement.id");
        sic.add("cslFormMeasureUnit.bgElement.number");
        sic.add("cslFormMeasureUnit.bgElement.name");
        sic.add("cslFormMeasureUnit.measureUnit.id");
        sic.add("cslFormMeasureUnit.measureUnit.number");
        sic.add("cslFormMeasureUnit.measureUnit.coefficient");
        sic.add("measureUnit.id");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("currency.id");
        sic.add("currency.number");
        sic.add("currency.precision");
        sic.add("currency.name");
        sic.add("orgTree.id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        return sic;
    }
}

