/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemModifyEnum;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgInfoHelper {
    private static final Logger logger = Logger.getLogger(BgInfoHelper.class);

    public static String checkHasAdjust(Connection conn, String bgFormId) throws EASBizException {
        if (conn == null || bgFormId == null) {
            return null;
        }
        String _adjustId = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select FID from T_BG_BgForm where FAdjustId = ? and FState = ?");
            pstmt.setString(1, bgFormId);
            pstmt.setInt(2, 4);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                _adjustId = rst.getString(1);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return _adjustId;
    }

    public static BgFormInfo getBgFormInfo(Connection conn, String bgFormId, boolean loadData) throws EASBizException {
        if (conn == null || StringUtils.isEmpty((String)bgFormId)) {
            return null;
        }
        return BgInfoHelper.getBgFormInfo(conn, BOSUuid.read((String)bgFormId), loadData);
    }

    public static BgFormInfo getBgFormInfo(Context ctx, BOSUuid bgFormId, boolean loadData) throws EASBizException, BOSException {
        SelectorItemCollection sic = BgInfoHelper.getSelectors();
        if (loadData) {
            sic.add("data");
        }
        return (BgFormInfo)BgFormFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(bgFormId), sic);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgFormInfo getBgFormInfo(Connection conn, BOSUuid bgFormId, boolean loadData) throws EASBizException {
        if (conn == null) return null;
        if (bgFormId == null) {
            return null;
        }
        BgFormInfo bgFormInfo = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _tmp = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID, FNumber, FName, FControlUnitID, FOrgUnitID, FBgSchemeID, FBgTemplateId, " + (loadData ? " FData, FAdjustMapData, " : "") + " FBgPeriodID, FCurrencyID, FMeasureUnitID, FDataSource, FState, FVersionNo, FAdjustID, FCertificateUserId ,FIsConfirm  From T_BG_BgForm where FID = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgFormInfo.setNumber(rst.getString("FNumber"));
                bgFormInfo.setName(rst.getString("FName"));
                _tmp = rst.getString("FControlUnitID");
                if (!StringUtils.isEmpty((String)_tmp)) {
                    bgFormInfo.setCU(new CtrlUnitInfo());
                    bgFormInfo.getCU().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FOrgUnitID")))) {
                    bgFormInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgFormInfo.getOrgUnit().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FBgSchemeID")))) {
                    bgFormInfo.setBgScheme(new BgSchemeInfo());
                    bgFormInfo.getBgScheme().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FBgTemplateId")))) {
                    bgFormInfo.setBgTemplate(new BgTemplateInfo());
                    bgFormInfo.getBgTemplate().setId(BOSUuid.read((String)_tmp));
                }
                if (loadData) {
                    bgFormInfo.setZipData(BgInfoHelper.getBytes(rst, "FData"));
                    bgFormInfo.setAdjustMapData(BgInfoHelper.getBytes(rst, "FAdjustMapData"));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FBgPeriodID")))) {
                    bgFormInfo.setBgPeriod(new BgPeriodInfo());
                    bgFormInfo.getBgPeriod().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FCurrencyID")))) {
                    bgFormInfo.setCurrency(new CurrencyInfo());
                    bgFormInfo.getCurrency().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FMeasureUnitID")))) {
                    bgFormInfo.setMeasureUnit(new MeasureUnitInfo());
                    bgFormInfo.getMeasureUnit().setId(BOSUuid.read((String)_tmp));
                }
                bgFormInfo.setDataSource(BgFormDataSourceEnum.getEnum((int)rst.getInt("FDataSource")));
                bgFormInfo.setState(BgFormStateEnum.getEnum((int)rst.getInt("FState")));
                bgFormInfo.setVersionNo(rst.getBigDecimal("FVersionNo"));
                _tmp = rst.getString("FAdjustID");
                if (!StringUtils.isEmpty((String)_tmp)) {
                    bgFormInfo.setAdjust(new BgFormInfo());
                    bgFormInfo.getAdjust().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FCertificateUserId")))) {
                    bgFormInfo.setCertificateUserId(_tmp);
                }
                bgFormInfo.setIsConfirm(rst.getBoolean("FIsConfirm"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (IOException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgFormInfo;
    }

    public static BgFormCollection getBgFormInfo(Context ctx, List bgFormIds) throws EASBizException, BOSException {
        return null;
    }

    public static BgTemplateInfo getBgTemplateInfo(Connection conn, String bgTemplateId, boolean loadData) throws EASBizException {
        if (conn == null || StringUtils.isEmpty((String)bgTemplateId)) {
            return null;
        }
        return BgInfoHelper.getBgTemplateInfo(conn, BOSUuid.read((String)bgTemplateId), loadData);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgTemplateInfo getBgTemplateInfo(Connection conn, BOSUuid bgTemplateId, boolean loadData) throws EASBizException {
        if (conn == null) return null;
        if (bgTemplateId == null) {
            return null;
        }
        BgTemplateInfo bgTemplateInfo = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _tmp = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID, FNumber, FName, FLastUpdateTime, FOrgUnitID, " + (loadData ? " FData, FMapData, " : "") + " FDefaultMeasureUnitID, FCanModify, FIsAllowChange, FParentID, FRootId, FFormType From T_BG_BgTemplate where FID = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgTemplateId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgTemplateInfo.setNumber(rst.getString("FNumber"));
                bgTemplateInfo.setName(rst.getString("FName"));
                bgTemplateInfo.setLastUpdateTime(rst.getTimestamp("FLastUpdateTime"));
                _tmp = rst.getString("FOrgUnitID");
                if (!StringUtils.isEmpty((String)_tmp)) {
                    bgTemplateInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgTemplateInfo.getOrgUnit().setId(BOSUuid.read((String)_tmp));
                }
                if (loadData) {
                    bgTemplateInfo.setZipData(BgInfoHelper.getBytes(rst, "FData"));
                    bgTemplateInfo.setMapData(BgInfoHelper.getBytes(rst, "FMapData"));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FDefaultMeasureUnitID")))) {
                    bgTemplateInfo.setDefaultMeasureUnit(new MeasureUnitInfo());
                    bgTemplateInfo.getDefaultMeasureUnit().setId(BOSUuid.read((String)_tmp));
                }
                bgTemplateInfo.setCanModify(BgTemModifyEnum.getEnum((int)rst.getInt("FCanModify")));
                bgTemplateInfo.setIsAllowChange(BgTemModifyEnum.getEnum((int)rst.getInt("FIsAllowChange")));
                _tmp = rst.getString("FParentID");
                if (!StringUtils.isEmpty((String)_tmp)) {
                    bgTemplateInfo.setParent(new BgTemplateInfo());
                    bgTemplateInfo.getParent().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FRootId")))) {
                    bgTemplateInfo.setRootId(BOSUuid.read((String)_tmp));
                }
                bgTemplateInfo.setFormType(BgTemFormTypeEnum.getEnum((int)rst.getInt("FFormType")));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (IOException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgTemplateInfo;
    }

    public static BgSchemeInfo getBgSchemeInfo(Locale locale, Connection conn, String bgSchemeId) throws EASBizException {
        if (locale == null || conn == null || StringUtils.isEmpty((String)bgSchemeId)) {
            return null;
        }
        return BgInfoHelper.getBgSchemeInfo(locale, conn, BOSUuid.read((String)bgSchemeId));
    }

    public static BgSchemeInfo getBgSchemeInfo(Locale locale, Connection conn, BOSUuid bgSchemeId) throws EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        BgSchemeInfo bgSchemeInfo;
        block8: {
            if (conn == null || bgSchemeId == null) {
                return null;
            }
            bgSchemeInfo = null;
            pstmt = null;
            rst = null;
            String _tmp = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FNumber, FName_" + locale + ", FOrgUnitID, FPeriod, FformallyYearScheme, FIsFormal, FDateFrom, FDateTo, FParentSchemeID, FRootID From T_BG_BgScheme where FID = ?");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgSchemeId.toString());
                rst = pstmt.executeQuery();
                if (!rst.next()) break block8;
                bgSchemeInfo = new BgSchemeInfo();
                bgSchemeInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgSchemeInfo.setNumber(rst.getString("FNumber"));
                bgSchemeInfo.setName(rst.getString("FName_" + locale));
                _tmp = rst.getString("FOrgUnitID");
                if (!StringUtils.isEmpty((String)_tmp)) {
                    bgSchemeInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgSchemeInfo.getOrgUnit().setId(BOSUuid.read((String)_tmp));
                }
                bgSchemeInfo.setFormallyYearScheme(rst.getBoolean("FformallyYearScheme"));
                bgSchemeInfo.setIsFormal(rst.getBoolean("FIsFormal"));
                bgSchemeInfo.setDateFrom((Date)rst.getDate("FDateFrom"));
                bgSchemeInfo.setDateTo((Date)rst.getDate("FDateTo"));
                _tmp = rst.getString("FParentSchemeID");
                if (!StringUtils.isEmpty((String)_tmp)) {
                    bgSchemeInfo.setParentScheme(new BgSchemeInfo());
                    bgSchemeInfo.getParentScheme().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FRootId")))) {
                    bgSchemeInfo.setRootId(BOSUuid.read((String)_tmp));
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgSchemeInfo;
    }

    public static Map getBgElementMap(Context ctx, Connection conn, Set bgElementSet) throws EASBizException {
        if (ctx == null || conn == null || bgElementSet == null || bgElementSet.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, BgElementInfo> dataMap = new HashMap<String, BgElementInfo>();
        ArrayList<String> bgElementList = new ArrayList<String>();
        BgElementInfo bgElementInfo = null;
        int index = 0;
        int batchNum = 200;
        int size = bgElementSet.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        String bgElementNumer2 = null;
        for (String bgElementNumer2 : bgElementSet) {
            bgElementList.add(bgElementNumer2);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName_" + ctx.getLocale() + ", FNumber from T_BG_BgElement where FNumber in(");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)bgElementList.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgElementInfo = new BgElementInfo();
                    bgElementInfo.setId(BOSUuid.read((String)rst.getString(1)));
                    bgElementInfo.setName(rst.getString(2));
                    bgElementInfo.setNumber(rst.getString(3));
                    dataMap.put(bgElementInfo.getNumber(), bgElementInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return dataMap;
    }

    public static Map getBgPeriodMap(Context ctx, Connection conn, Set bgPeriodSet) throws EASBizException {
        if (ctx == null || conn == null || bgPeriodSet == null || bgPeriodSet.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, BgPeriodInfo> dataMap = new HashMap<String, BgPeriodInfo>();
        ArrayList<String> bgPeriodList = new ArrayList<String>();
        BgPeriodInfo bgPeriodInfo = null;
        int index = 0;
        int batchNum = 200;
        int size = bgPeriodSet.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        String bgPeriodNumer2 = null;
        for (String bgPeriodNumer2 : bgPeriodSet) {
            bgPeriodList.add(bgPeriodNumer2);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName_" + ctx.getLocale() + ", FNumber from T_BG_BgPeriod where FNumber in(");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)bgPeriodList.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgPeriodInfo = new BgPeriodInfo();
                    bgPeriodInfo.setId(BOSUuid.read((String)rst.getString(1)));
                    bgPeriodInfo.setName(rst.getString(2));
                    bgPeriodInfo.setNumber(rst.getString(3));
                    dataMap.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return dataMap;
    }

    public static Map getCurrencyMap(Context ctx, Connection conn, Set currencySet) throws EASBizException {
        if (ctx == null || conn == null || currencySet == null || currencySet.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, CurrencyInfo> dataMap = new HashMap<String, CurrencyInfo>();
        ArrayList<String> currencyList = new ArrayList<String>();
        CurrencyInfo currencyInfo = null;
        int index = 0;
        int batchNum = 200;
        int size = currencySet.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        String currencyNumer2 = null;
        for (String currencyNumer2 : currencySet) {
            currencyList.add(currencyNumer2);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName_" + ctx.getLocale() + ", FNumber from T_BD_Currency where FNumber in(");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)currencyList.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    currencyInfo = new CurrencyInfo();
                    currencyInfo.setId(BOSUuid.read((String)rst.getString(1)));
                    currencyInfo.setName(rst.getString(2));
                    currencyInfo.setNumber(rst.getString(3));
                    dataMap.put(currencyInfo.getNumber(), currencyInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(ResultSet rst, String key) throws SQLException, IOException {
        if (rst == null || StringUtils.isEmpty((String)key)) {
            return null;
        }
        InputStream in = rst.getBinaryStream(key);
        if (in == null) {
            return null;
        }
        int len = -1;
        int blockSize = 1024;
        byte[] block = new byte[1024];
        byte[] bytes = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            do {
                if ((len = in.read(block)) <= 0) continue;
                byteOut.write(block, 0, len);
            } while (len == 1024);
            bytes = byteOut.toByteArray();
        }
        finally {
            in.close();
            byteOut.close();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(ResultSet rst, int index) throws SQLException, IOException {
        if (rst == null) {
            return null;
        }
        InputStream in = rst.getBinaryStream(index);
        if (in == null) {
            return null;
        }
        int len = -1;
        int blockSize = 1024;
        byte[] block = new byte[1024];
        byte[] bytes = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            do {
                if ((len = in.read(block)) <= 0) continue;
                byteOut.write(block, 0, len);
            } while (len == 1024);
            bytes = byteOut.toByteArray();
        }
        finally {
            in.close();
            byteOut.close();
        }
        return bytes;
    }

    public static void setBytes(PreparedStatement stat, int index, byte[] bytes) throws SQLException {
        if (stat == null) {
            return;
        }
        if (bytes != null && bytes.length > 0) {
            stat.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        } else {
            stat.setBytes(index, null);
        }
    }

    public static Map getBgItemsInfo(Context ctx, Set querySet, Map bgItemMap, SelectorItemCollection sic, String orgUnitId) throws BOSException, EASBizException {
        if (bgItemMap == null) {
            bgItemMap = new HashMap<String, BgItemInfo>();
        }
        if (querySet == null || querySet.isEmpty()) {
            return bgItemMap;
        }
        String number2 = null;
        String[] numbers = null;
        BgItemInfo bgItemInfo = null;
        BgItemCollection bgItemCol = null;
        HashSet<String> bgItemSet = new HashSet<String>();
        for (String number2 : querySet) {
            if (StringUtils.isEmpty((String)number2) || (numbers = number2.split(",")) == null) continue;
            int n = numbers.length;
            for (int i = 0; i < n; ++i) {
                if (bgItemMap.containsKey(numbers[i])) continue;
                bgItemSet.add(numbers[i]);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", bgItemSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg((Context)ctx, (String)orgUnitId), CompareType.EQUALS));
        view.setFilter(filter);
        if (sic == null || sic.isEmpty()) {
            if (sic == null) {
                sic = new SelectorItemCollection();
            }
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("longnumber"));
            sic.add(new SelectorItemInfo("specialNumber"));
        }
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("longnumber");
        sortColl.add(sortInfo);
        view.setSorter(sortColl);
        IBgItem ibgItem = null;
        try {
            ibgItem = ctx != null ? BgItemFactory.getLocalInstance((Context)ctx) : BgItemFactory.getRemoteInstance();
            if (ibgItem == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgItemCol = ibgItem.getBgItemCollection(view);
            if (bgItemCol != null && !bgItemCol.isEmpty()) {
                int n = bgItemCol.size();
                for (int i = 0; i < n; ++i) {
                    bgItemInfo = bgItemCol.get(i);
                    bgItemMap.put(bgItemInfo.getNumber(), bgItemInfo);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return bgItemMap;
    }

    public static String getBgItemName(String bgItemNumber, Map bgItemMap) {
        if (StringUtils.isEmpty((String)bgItemNumber)) {
            return "";
        }
        StringBuffer bgItemName = new StringBuffer();
        String[] _strtmp = bgItemNumber.split("_");
        if (_strtmp != null) {
            int in = _strtmp.length;
            for (int i = 0; i < in; ++i) {
                if (bgItemMap.containsKey(_strtmp[i])) {
                    bgItemName.append(bgItemMap.get(_strtmp[i]));
                } else {
                    bgItemName.append(" ");
                }
                if (i == in - 1) continue;
                bgItemName.append("_");
            }
        }
        return bgItemName.toString();
    }

    public static Map getBgPeriodInfo(Context ctx, Set querySet, Map bgPeriodMap, SelectorItemCollection sic) throws BOSException, EASBizException {
        if (bgPeriodMap == null) {
            bgPeriodMap = new HashMap<String, BgPeriodInfo>();
        }
        if (querySet == null || querySet.isEmpty()) {
            return bgPeriodMap;
        }
        String key2 = null;
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodCol = null;
        HashSet<String> bgPeriodSet = new HashSet<String>();
        for (String key2 : querySet) {
            if (bgPeriodMap.containsKey(key2)) continue;
            bgPeriodSet.add(key2);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bgPeriodSet, CompareType.INCLUDE));
        view.setFilter(filter);
        if (sic == null || sic.isEmpty()) {
            if (sic == null) {
                sic = new SelectorItemCollection();
            }
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
        }
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        IBgPeriod ibgPeriod = null;
        try {
            ibgPeriod = ctx != null ? BgPeriodFactory.getLocalInstance((Context)ctx) : BgPeriodFactory.getRemoteInstance();
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
                int n = bgPeriodCol.size();
                for (int i = 0; i < n; ++i) {
                    bgPeriodInfo = bgPeriodCol.get(i);
                    bgPeriodMap.put(bgPeriodInfo.getId().toString(), bgPeriodInfo);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return bgPeriodMap;
    }

    public static Map getBgElementInfo(Context ctx, Set querySet, Map bgElementMap, SelectorItemCollection sic) throws BOSException, EASBizException {
        if (bgElementMap == null) {
            bgElementMap = new HashMap<String, BgElementInfo>();
        }
        if (querySet == null || querySet.isEmpty()) {
            return bgElementMap;
        }
        String key2 = null;
        BgElementInfo bgElementInfo = null;
        BgElementCollection bgElementCol = null;
        HashSet<String> bgElementSet = new HashSet<String>();
        for (String key2 : querySet) {
            if (bgElementMap.containsKey(key2)) continue;
            bgElementSet.add(key2);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bgElementSet, CompareType.INCLUDE));
        view.setFilter(filter);
        if (sic == null || sic.isEmpty()) {
            if (sic == null) {
                sic = new SelectorItemCollection();
            }
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
        }
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        IBgElement ibgElement = null;
        try {
            ibgElement = ctx != null ? BgElementFactory.getLocalInstance((Context)ctx) : BgElementFactory.getRemoteInstance();
            if (ibgElement == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgElementCol = ibgElement.getBgElementCollection(view);
            if (bgElementCol != null && !bgElementCol.isEmpty()) {
                int n = bgElementCol.size();
                for (int i = 0; i < n; ++i) {
                    bgElementInfo = bgElementCol.get(i);
                    bgElementMap.put(bgElementInfo.getId().toString(), bgElementInfo);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return bgElementMap;
    }

    public static Map getCurrencyInfo(Context ctx, Set querySet, Map currencysMap, SelectorItemCollection sic) throws BOSException, EASBizException {
        if (currencysMap == null) {
            currencysMap = new HashMap<String, CurrencyInfo>();
        }
        if (querySet == null || querySet.isEmpty()) {
            return currencysMap;
        }
        String key2 = null;
        CurrencyInfo currencyInfo = null;
        CurrencyCollection currencyCol = null;
        HashSet<String> currencySet = new HashSet<String>();
        for (String key2 : querySet) {
            if (currencySet.contains(key2)) continue;
            currencySet.add(key2);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", currencySet, CompareType.INCLUDE));
        view.setFilter(filter);
        if (sic == null || sic.isEmpty()) {
            if (sic == null) {
                sic = new SelectorItemCollection();
            }
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("precision"));
        }
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        ICurrency iCurrency = null;
        try {
            iCurrency = ctx != null ? CurrencyFactory.getLocalInstance((Context)ctx) : CurrencyFactory.getRemoteInstance();
            if (iCurrency == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            currencyCol = iCurrency.getCurrencyCollection(view, true);
            if (currencyCol != null && !currencyCol.isEmpty()) {
                int n = currencyCol.size();
                for (int i = 0; i < n; ++i) {
                    currencyInfo = currencyCol.get(i);
                    currencysMap.put(currencyInfo.getId().toString(), currencyInfo);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return currencysMap;
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("state");
        sic.add("auditedStatus");
        sic.add("dataSource");
        sic.add("description");
        sic.add("versionNo");
        sic.add("startDate");
        sic.add("endDate");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("company.isBizUnit");
        sic.add("company.accountPeriodType.id");
        sic.add("CU.id");
        sic.add("CU.name");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.period");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.isFormal");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.canModify");
        sic.add("bgTemplate.parent.id");
        sic.add("bgTemplate.rootId");
        sic.add("bgTemplate.formType");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgPeriod.beginDate");
        sic.add("bgPeriod.endDate");
        sic.add("bgPeriod.year");
        sic.add("bgPeriod.halfYear");
        sic.add("bgPeriod.quarter");
        sic.add("bgPeriod.month");
        sic.add("bgPeriod.week");
        sic.add("periodType");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.isoCode");
        sic.add("currency.precision");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("postils.*");
        sic.add("postils.report.id");
        sic.add("postils.sheet.id");
        sic.add("postils.sheet.sheetID");
        sic.add("postils.creator.id");
        sic.add("postils.creator.name");
        sic.add("sheetParam.id");
        sic.add("sheetParam.*");
        sic.add("sheetParam.orgRela.id");
        sic.add("sheetParam.orgRela.orgType");
        sic.add("sheetParam.orgRela.orgUnit.id");
        sic.add("sheetParam.orgRela.orgUnit.type");
        sic.add("sheetParam.orgRela.orgUnit.name");
        sic.add("sheetParam.currency.id");
        sic.add("sheetParam.currency.number");
        sic.add("sheetParam.currency.name");
        sic.add("sheetParam.currency.precision");
        sic.add("sheetParam.postils.*");
        sic.add("sheetParam.postils.report.id");
        sic.add("sheetParam.postils.sheet.id");
        sic.add("sheetParam.postils.sheet.sheetID");
        sic.add("sheetParam.postils.creator.id");
        sic.add("sheetParam.postils.creator.name");
        sic.add("adjust.id");
        sic.add("adjustMapData");
        sic.add("auditTime");
        sic.add("courseOrgId");
        return sic;
    }
}

