/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.IFMIsqlFacade;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.BgWorkPaperInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public final class BgNExpressionHelper {
    private static final Logger logger = Logger.getLogger(BgNExpressionHelper.class);
    private static final CalendarHelper _calendar = new CalendarHelper();
    public static final String RPTDATE_STR = "RPTDATE";
    public static final String BGRPTDATE_STR = "BGRPTDATE";
    public static final String BGGETORGNUM_STR = "BGGETORGNUM";
    public static final String BGACTUALEXT_STR = "BGACTUALEXT";
    public static final String BGFORMULA_STR = "BGFORMULA";
    public static final String BGACTUAL_STR = "BGACTUAL";
    public static final String BGACT_STR = "BGACT";
    public static final String BGBAL_STR = "BGBAL";
    public static final String BGACTUALS_STR = "BGACTUALS";
    public static final String BGREFBGTEM_STR = "BGREFBGTEM";
    public static final String BGREFBGFORM_STR = "BGREFBGFORM";
    public static final String BGADJUST_STR = "BGADJUST";
    public static final String BGAVLBAL_STR = "BGAVLBAL";
    public static final String ACCT_STR = "ACCT";
    public static final String BGDIFFERENCE_STR = "BGDIFFERENCE";
    public static final String BGGETORGATTR_STR = "GetOrgTypVal";
    public static final String IF_STR = "IF";
    public static final String ACCTITEM_STR = "ACCTITEM";
    public static final String BGGETDIMEDATA_STR = "BGGETDIMEDATA";

    public static String checkExpression(Cell cell, String expressions, final IObjectValue model, final String costCenterNumber, final String companyNumber) {
        if (StringUtils.isEmpty((String)expressions) || model == null || !(model instanceof BgFormInfo) && !(model instanceof BgActualRecordInfo) && !(model instanceof BgWorkPaperInfo)) {
            return null;
        }
        String _expressions = null;
        Expression expression = null;
        if (expressions.toUpperCase().indexOf("KPGETSQL") >= 0) {
            return expressions;
        }
        try {
            expression = ExcelFormulaPaserHelper.parse((String)expressions);
            if (cell != null && expression instanceof FunctionExpr) {
                BgNExpressionHelper.checkFuncionName((FunctionExpr)expression, cell);
            }
            if (expression instanceof Ref3DExpr) {
                return expressions;
            }
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return BgNExpressionHelper.checkExpression(expr, model, costCenterNumber, companyNumber);
                }
            });
            _expressions = '=' + expression.toString();
        }
        catch (Exception ex) {
            logger.error((Object)expressions);
            logger.error((Object)ex);
        }
        return _expressions;
    }

    private static void checkFuncionName(FunctionExpr expr, Cell cell) {
        String obj;
        if (expr == null || cell == null) {
            return;
        }
        String funcionName = expr.funcionName;
        if ((RPTDATE_STR.equalsIgnoreCase(funcionName) || BGRPTDATE_STR.equalsIgnoreCase(funcionName) || BGGETORGNUM_STR.equalsIgnoreCase(funcionName)) && ((obj = cell.getStyle().getNumberFormat()) == null || !"@".equals(obj))) {
            BgNFSHelper.setNumberFormat(cell, "@");
        }
    }

    private static Expression checkExpression(Expression expression, IObjectValue model, String costCenterNumber, String companyNumber) {
        if (expression instanceof FunctionExpr) {
            expression = BgNExpressionHelper.checkFunctionExpr((FunctionExpr)expression, model, costCenterNumber, companyNumber);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgNExpressionHelper.checkBinaryOperationExpr((BinaryOperationExpr)expression, model, costCenterNumber, companyNumber);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = BgNExpressionHelper.checkUnaryOperationExpr((UnaryOperationExpr)expression, model);
        }
        return expression;
    }

    private static Expression checkFunctionExpr(FunctionExpr funExpr, IObjectValue model, String costCenterNumber, String companyNumber) {
        String funcionName = funExpr.funcionName;
        try {
            if (BGFORMULA_STR.equalsIgnoreCase(funcionName) || BGACT_STR.equalsIgnoreCase(funcionName) || BGBAL_STR.equalsIgnoreCase(funcionName) || BGACTUALS_STR.equalsIgnoreCase(funcionName) || BGREFBGTEM_STR.equalsIgnoreCase(funcionName) || BGADJUST_STR.equalsIgnoreCase(funcionName) || BGAVLBAL_STR.equalsIgnoreCase(funcionName) || BGREFBGFORM_STR.equalsIgnoreCase(funcionName) || BGACTUALEXT_STR.equalsIgnoreCase(funcionName) || BGDIFFERENCE_STR.equalsIgnoreCase(funcionName) || IF_STR.equalsIgnoreCase(funcionName) || ACCT_STR.equalsIgnoreCase(funcionName) || ACCTITEM_STR.equalsIgnoreCase(funcionName) || BGGETDIMEDATA_STR.equalsIgnoreCase(funcionName) || ACCT_STR.equalsIgnoreCase(funcionName)) {
                FunctionExpr _expression = funExpr;
                Expression p0 = (Expression)funExpr.parameters.get(0);
                if (p0 instanceof StringExpr) {
                    StringExpr sp = (StringExpr)p0;
                    String valueStr = sp.value;
                    String[] pp = valueStr.split(";");
                    if (pp != null && pp.length > 1) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < pp.length; ++i) {
                            funExpr.parameters.set(0, new StringExpr(pp[i].trim()));
                            if (sb.length() > 1) {
                                sb.append('+');
                            }
                            funExpr.output(sb);
                        }
                        _expression = ExcelFormulaPaserHelper.parse((String)sb.toString());
                        _expression = BgNExpressionHelper.checkExpression((Expression)_expression, model, costCenterNumber, companyNumber);
                    }
                } else if (p0 instanceof FunctionExpr) {
                    BgNExpressionHelper.checkExpressionParam((FunctionExpr)p0, model, costCenterNumber, companyNumber);
                }
                if (_expression instanceof FunctionExpr) {
                    BgNExpressionHelper.checkExpressionParam(_expression, model, costCenterNumber, companyNumber);
                }
                return _expression;
            }
            BgNExpressionHelper.checkExpressionParam(funExpr, model, costCenterNumber, companyNumber);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return funExpr;
    }

    private static BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, IObjectValue model, String costCenterNumber, String companyNumber) {
        boExpr.left = BgNExpressionHelper.checkExpression(boExpr.left, model, costCenterNumber, companyNumber);
        boExpr.right = BgNExpressionHelper.checkExpression(boExpr.right, model, costCenterNumber, companyNumber);
        return boExpr;
    }

    private static UnaryOperationExpr checkUnaryOperationExpr(UnaryOperationExpr boExpr, IObjectValue model) {
        return boExpr;
    }

    private static void checkExpressionParam(FunctionExpr funExpr, IObjectValue model, String costCenterNumber, String companyNumber) {
        String funcionName = funExpr.funcionName;
        if (BGACTUAL_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgActualParam(funExpr.parameters, model, costCenterNumber);
        } else if (BGFORMULA_STR.equalsIgnoreCase(funcionName) || BGACT_STR.equalsIgnoreCase(funcionName) || BGACTUALS_STR.equalsIgnoreCase(funcionName) || BGBAL_STR.equalsIgnoreCase(funcionName) || BGGETORGATTR_STR.equalsIgnoreCase(funcionName) || BGADJUST_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgFormulaParam(funExpr.parameters, model, costCenterNumber, 0, 1, 4, 5, 6);
        } else if (BGGETDIMEDATA_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgFormulaParam(funExpr.parameters, model, costCenterNumber, 0, 1, 5, 6, 7);
        } else if (BGAVLBAL_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgAvlBalFormulaParam(funExpr.parameters, model, costCenterNumber);
        } else if (BGREFBGTEM_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgRefBgTemplateParam(funExpr.parameters, model, costCenterNumber);
        } else if (BGREFBGFORM_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgRefBgFormParam(funExpr.parameters, model, costCenterNumber);
        } else if (ACCT_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkAcctParamForCom(funExpr.parameters, model, costCenterNumber, companyNumber);
        } else if (BGACTUALEXT_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgActualExtaram(funExpr.parameters, model, costCenterNumber);
        } else if (BGDIFFERENCE_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgDifferenceParam(funExpr.parameters, model, costCenterNumber);
        } else if (ACCTITEM_STR.equalsIgnoreCase(funcionName)) {
            try {
                BgNExpressionHelper.checkAcctItemParam(funExpr.parameters, model, costCenterNumber, (Expression)funExpr);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private static void checkAcctParamForCom(List parameter, IObjectValue model, String costCenterNumber, String companyNumber) {
        if (parameter == null || parameter.size() < 8 || parameter.size() > 9) {
            return;
        }
        if (model instanceof BgFormInfo) {
            BgFormInfo _bgFormInfo = (BgFormInfo)model;
            Object param0 = parameter.get(0);
            if (param0 instanceof StringExpr) {
                try {
                    String orgNum = ((StringExpr)param0).value;
                    if (StringUtils.isEmpty((String)orgNum)) {
                        FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(_bgFormInfo.getOrgUnit().getId()));
                        OrgUnitInfo company = BgNExpressionHelper.getCompanyOrgUnitByBgOrgUnit(null, (OrgUnitInfo)orgUnit);
                        ((StringExpr)param0).value = company.getNumber().trim();
                    }
                }
                catch (Exception e) {
                    logger.info((Object)e.toString());
                }
            }
        } else if (model instanceof BgActualRecordInfo) {
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            Object param0 = parameter.get(0);
            if (param0 instanceof StringExpr) {
                try {
                    String orgNum = ((StringExpr)param0).value;
                    if (StringUtils.isEmpty((String)orgNum)) {
                        FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(_bgActualInfo.getBgForm().getOrgUnit().getId()));
                        OrgUnitInfo company = BgNExpressionHelper.getCompanyOrgUnitByBgOrgUnit(null, (OrgUnitInfo)orgUnit);
                        ((StringExpr)param0).value = company.getNumber().trim();
                    }
                }
                catch (Exception e) {
                    logger.info((Object)e.toString());
                }
            }
        } else if (model instanceof BgWorkPaperInfo) {
            String orgNum;
            BgWorkPaperInfo info = (BgWorkPaperInfo)model;
            Object param0 = parameter.get(0);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value)) && !StringUtils.isEmpty((String)costCenterNumber)) {
                ((StringExpr)param0).value = costCenterNumber.trim();
            }
        }
    }

    private static void checkBgActualExtaram(List parameter, IObjectValue model, String costCenterNumber) {
        if (parameter == null || parameter.size() != 8) {
            return;
        }
        if (model instanceof BgFormInfo) {
            String orgNum;
            String currencyNum;
            BgFormInfo _bgFormInfo = (BgFormInfo)model;
            BgPeriodInfo _bgPeriodInfo = _bgFormInfo.getBgPeriod();
            Object param0 = parameter.get(0);
            StringExpr param1 = (StringExpr)parameter.get(1);
            StringExpr param4 = (StringExpr)parameter.get(4);
            StringExpr param5 = (StringExpr)parameter.get(5);
            StringExpr param6 = (StringExpr)parameter.get(6);
            StringExpr param7 = (StringExpr)parameter.get(7);
            String currBtime = String.valueOf(_bgPeriodInfo.getBeginDate());
            String currEtime = String.valueOf(_bgPeriodInfo.getEndDate());
            Date date = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String begindate = param5.value;
            String enddate = param6.value;
            String bgSchmeNum = param1.value;
            String periodtype = param7.value;
            if (StringUtils.isEmpty((String)bgSchmeNum)) {
                param1.value = _bgFormInfo.getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param4.value))) {
                param4.value = _bgFormInfo.getCurrency().getNumber();
            }
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value))) {
                ((StringExpr)param0).value = _bgFormInfo.getOrgUnit().getNumber().trim();
            }
            if (!StringUtils.isEmpty((String)begindate) && BgPeriodNVariableHelper.checkCanConvert((String)param5.value)) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param5.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                    date = BgPeriodHelper.getBeginDay((String)param5.value);
                    if (date != null) {
                        param5.value = formatter.format(date).toString();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (!StringUtils.isEmpty((String)enddate)) {
                try {
                    if (BgPeriodNVariableHelper.checkCanConvert((String)param6.value)) {
                        param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param6.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                        date = BgPeriodHelper.getEndDay((String)param6.value);
                        if (date != null) {
                            param6.value = formatter.format(date).toString();
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            if (StringUtils.isEmpty((String)periodtype)) {
                param7.value = "MONTH";
            }
        } else if (model instanceof BgActualRecordInfo) {
            String currencyNum;
            String bgSchmeNum;
            String orgNum;
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param1 = (StringExpr)parameter.get(1);
            StringExpr param4 = (StringExpr)parameter.get(4);
            StringExpr param5 = (StringExpr)parameter.get(5);
            StringExpr param6 = (StringExpr)parameter.get(6);
            StringExpr param7 = (StringExpr)parameter.get(7);
            String currBtime = String.valueOf(_bgActualInfo.getBgForm().getBgPeriod().getBeginDate());
            String currEtime = String.valueOf(_bgActualInfo.getBgForm().getBgPeriod().getEndDate());
            Date date = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value))) {
                ((StringExpr)param0).value = _bgActualInfo.getBgForm().getOrgUnit().getNumber().trim();
            }
            if (StringUtils.isEmpty((String)(bgSchmeNum = param1.value))) {
                param1.value = _bgActualInfo.getBgForm().getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param4.value))) {
                param4.value = _bgActualInfo.getBgForm().getCurrency().getNumber();
            }
            String begindate = param5.value;
            String enddate = param6.value;
            String periodtype = param7.value;
            if (!StringUtils.isEmpty((String)begindate)) {
                try {
                    if (BgPeriodNVariableHelper.checkCanConvert((String)param5.value)) {
                        param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param5.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                        date = BgPeriodHelper.getBeginDay((String)param5.value);
                        if (date != null) {
                            param5.value = formatter.format(date).toString();
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            if (!StringUtils.isEmpty((String)enddate)) {
                try {
                    if (BgPeriodNVariableHelper.checkCanConvert((String)param6.value)) {
                        param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param6.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                        date = BgPeriodHelper.getEndDay((String)param6.value);
                        if (date != null) {
                            param6.value = formatter.format(date).toString();
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            if (StringUtils.isEmpty((String)periodtype)) {
                param7.value = "MONTH";
            }
        } else if (model instanceof BgWorkPaperInfo) {
            String orgNum;
            String currencyNum;
            BgWorkPaperInfo info = (BgWorkPaperInfo)model;
            BgPeriodInfo _bgPeriodInfo = info.getBgPeriod();
            Object param0 = parameter.get(0);
            StringExpr param1 = (StringExpr)parameter.get(1);
            StringExpr param4 = (StringExpr)parameter.get(4);
            StringExpr param5 = (StringExpr)parameter.get(5);
            StringExpr param6 = (StringExpr)parameter.get(6);
            StringExpr param7 = (StringExpr)parameter.get(7);
            String currBtime = String.valueOf(_bgPeriodInfo.getBeginDate());
            String currEtime = String.valueOf(_bgPeriodInfo.getEndDate());
            Date date = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String begindate = param5.value;
            String enddate = param6.value;
            String bgSchmeNum = param1.value;
            String periodtype = param7.value;
            if (StringUtils.isEmpty((String)bgSchmeNum)) {
                param1.value = info.getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param4.value))) {
                param4.value = info.getCurrency().getNumber();
            }
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value)) && !StringUtils.isEmpty((String)costCenterNumber)) {
                ((StringExpr)param0).value = costCenterNumber.trim();
            }
            if (StringUtils.isEmpty((String)begindate)) {
                param5.value = currBtime;
            } else if (BgPeriodNVariableHelper.checkCanConvert((String)param5.value)) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)info.getBgPeriod().getNumber(), (String)param5.value, (int)info.getBgPeriod().getPeriodType().getValue());
                    date = BgPeriodHelper.getBeginDay((String)param5.value);
                    if (date != null) {
                        param5.value = formatter.format(date).toString();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (StringUtils.isEmpty((String)enddate)) {
                param6.value = currEtime;
            } else {
                try {
                    if (BgPeriodNVariableHelper.checkCanConvert((String)param6.value)) {
                        param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)info.getBgPeriod().getNumber(), (String)param6.value, (int)info.getBgPeriod().getPeriodType().getValue());
                        date = BgPeriodHelper.getEndDay((String)param6.value);
                        if (date != null) {
                            param6.value = formatter.format(date).toString();
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            if (StringUtils.isEmpty((String)periodtype)) {
                param7.value = "MONTH";
            }
        }
    }

    private static void checkBgActualParam(List parameter, IObjectValue model, String costCenterNumber) {
        if (parameter == null || parameter.size() != 6) {
            return;
        }
        if (model instanceof BgFormInfo) {
            String bgPeriodNum;
            String currencyNum;
            String orgNum;
            BgFormInfo _bgFormInfo = (BgFormInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param3 = (StringExpr)parameter.get(3);
            StringExpr param4 = (StringExpr)parameter.get(4);
            StringExpr param5 = (StringExpr)parameter.get(5);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value))) {
                ((StringExpr)param0).value = _bgFormInfo.getOrgUnit().getNumber().trim();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param3.value))) {
                param3.value = _bgFormInfo.getCurrency().getNumber();
            }
            if (StringUtils.isEmpty((String)(bgPeriodNum = param4.value))) {
                param4.value = _bgFormInfo.getBgPeriod().getNumber();
            }
            if (StringUtils.isEmpty((String)(bgPeriodNum = param5.value))) {
                param5.value = _bgFormInfo.getBgPeriod().getNumber();
            }
        } else if (model instanceof BgActualRecordInfo) {
            String bgPeriodNum;
            String currencyNum;
            String orgNum;
            BgActualRecordInfo _bgFormInfo = (BgActualRecordInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param3 = (StringExpr)parameter.get(3);
            StringExpr param4 = (StringExpr)parameter.get(4);
            StringExpr param5 = (StringExpr)parameter.get(5);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value))) {
                ((StringExpr)param0).value = _bgFormInfo.getBgForm().getOrgUnit().getNumber().trim();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param3.value))) {
                param3.value = _bgFormInfo.getBgForm().getCurrency().getNumber();
            }
            if (StringUtils.isEmpty((String)(bgPeriodNum = param4.value))) {
                param4.value = _bgFormInfo.getBgPeriod().getNumber();
            }
            if (StringUtils.isEmpty((String)(bgPeriodNum = param5.value))) {
                param5.value = _bgFormInfo.getBgPeriod().getNumber();
            }
        } else if (model instanceof BgWorkPaperInfo) {
            String bgPeriodNum;
            String currencyNum;
            String orgNum;
            BgWorkPaperInfo info = (BgWorkPaperInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param3 = (StringExpr)parameter.get(3);
            StringExpr param4 = (StringExpr)parameter.get(4);
            StringExpr param5 = (StringExpr)parameter.get(5);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value)) && !StringUtils.isEmpty((String)costCenterNumber)) {
                ((StringExpr)param0).value = costCenterNumber.trim();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param3.value))) {
                param3.value = info.getCurrency().getNumber();
            }
            if (StringUtils.isEmpty((String)(bgPeriodNum = param4.value))) {
                param4.value = info.getBgPeriod().getNumber();
            }
            if (StringUtils.isEmpty((String)(bgPeriodNum = param5.value))) {
                param5.value = info.getBgPeriod().getNumber();
            }
        }
    }

    private static void checkAcctParam(List parameter, IObjectValue model, String costCenterNumber) {
        if (parameter == null || parameter.size() != 8) {
            return;
        }
    }

    private static void checkBgRefBgFormParam(List parameter, IObjectValue model, String costCenterNumber) {
        String orgUnitNumber;
        Object param0;
        if (parameter == null || parameter.size() != 4) {
            return;
        }
        if (model instanceof BgFormInfo) {
            String orgUnitNumber2;
            BgFormInfo _bgFormInfo = (BgFormInfo)model;
            Object param02 = parameter.get(0);
            if (param02 instanceof StringExpr && StringUtils.isEmpty((String)(orgUnitNumber2 = ((StringExpr)param02).value))) {
                ((StringExpr)param02).value = _bgFormInfo.getOrgUnit().getNumber().trim();
            }
        } else if (model instanceof BgActualRecordInfo) {
            String orgUnitNumber3;
            BgActualRecordInfo _bgFormInfo = (BgActualRecordInfo)model;
            Object param03 = parameter.get(0);
            if (param03 instanceof StringExpr && StringUtils.isEmpty((String)(orgUnitNumber3 = ((StringExpr)param03).value))) {
                ((StringExpr)param03).value = _bgFormInfo.getBgForm().getOrgUnit().getNumber().trim();
            }
        } else if (model instanceof BgWorkPaperInfo && (param0 = parameter.get(0)) instanceof StringExpr && StringUtils.isEmpty((String)(orgUnitNumber = ((StringExpr)param0).value)) && !StringUtils.isEmpty((String)costCenterNumber)) {
            ((StringExpr)param0).value = costCenterNumber.trim();
        }
    }

    private static void checkBgRefBgTemplateParam(List parameter, IObjectValue model, String costCenterNumber) {
        if (parameter == null || parameter.size() != 7) {
            return;
        }
        if (model instanceof BgFormInfo) {
            String currencyNumber;
            String bgPeriodNumber;
            String bgSchemeNumber;
            String orgUnitNumber;
            BgFormInfo _bgFormInfo = (BgFormInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param1 = (StringExpr)parameter.get(1);
            StringExpr param3 = (StringExpr)parameter.get(3);
            StringExpr param4 = (StringExpr)parameter.get(4);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgUnitNumber = ((StringExpr)param0).value))) {
                ((StringExpr)param0).value = _bgFormInfo.getOrgUnit().getNumber().trim();
            }
            if (StringUtils.isEmpty((String)(bgSchemeNumber = param1.value))) {
                param1.value = _bgFormInfo.getBgScheme().getNumber();
            }
            if (!StringUtils.isEmpty((String)(bgPeriodNumber = param3.value))) {
                try {
                    param3.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param3.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            if (StringUtils.isEmpty((String)(currencyNumber = param4.value))) {
                param4.value = _bgFormInfo.getCurrency().getNumber();
            }
        } else if (model instanceof BgActualRecordInfo) {
            String currencyNumber;
            String bgPeriodNumber;
            String bgSchemeNumber;
            String orgUnitNumber;
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param1 = (StringExpr)parameter.get(1);
            StringExpr param3 = (StringExpr)parameter.get(3);
            StringExpr param4 = (StringExpr)parameter.get(4);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgUnitNumber = ((StringExpr)param0).value))) {
                ((StringExpr)param0).value = _bgActualInfo.getBgForm().getOrgUnit().getNumber().trim();
            }
            if (StringUtils.isEmpty((String)(bgSchemeNumber = param1.value))) {
                param1.value = _bgActualInfo.getBgForm().getBgScheme().getNumber();
            }
            if (!StringUtils.isEmpty((String)(bgPeriodNumber = param3.value))) {
                try {
                    param3.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param3.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            if (StringUtils.isEmpty((String)(currencyNumber = param4.value))) {
                param4.value = _bgActualInfo.getBgForm().getCurrency().getNumber();
            }
        } else if (model instanceof BgWorkPaperInfo) {
            String bgPeriodNumber;
            String bgSchemeNumber;
            String orgUnitNumber;
            BgWorkPaperInfo info = (BgWorkPaperInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param1 = (StringExpr)parameter.get(1);
            StringExpr param3 = (StringExpr)parameter.get(3);
            StringExpr param4 = (StringExpr)parameter.get(4);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgUnitNumber = ((StringExpr)param0).value)) && !StringUtils.isEmpty((String)costCenterNumber)) {
                ((StringExpr)param0).value = costCenterNumber.trim();
            }
            if (StringUtils.isEmpty((String)(bgSchemeNumber = param1.value))) {
                param1.value = info.getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(bgPeriodNumber = param3.value))) {
                param3.value = info.getBgPeriod().getNumber();
            } else {
                try {
                    param3.value = BgPeriodNVariableHelper.getBgPeriodByN((String)info.getBgPeriod().getNumber(), (String)param3.value, (int)info.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            String currencyNumber = param4.value;
            if (StringUtils.isEmpty((String)currencyNumber)) {
                param4.value = info.getCurrency().getNumber();
            }
        }
    }

    private static void checkBgFormulaParam(List parameter, IObjectValue model, String costCenterNumber, int orgIndex, int bgSchemeIndex, int currencyIndex, int startPeriodIndex, int endPeriodIndex) {
        if (parameter == null || parameter.size() < 7) {
            return;
        }
        String startPeriod = model.getString("StartBgPeriod");
        String endPeriod = model.getString("EndBgPeriod");
        boolean isNeedFillPeriod = model.get("isNeedFillPeriod") instanceof Boolean ? (Boolean)model.get("isNeedFillPeriod") : false;
        Object param0 = parameter.get(orgIndex);
        StringExpr param1 = (StringExpr)parameter.get(bgSchemeIndex);
        StringExpr param4 = (StringExpr)parameter.get(currencyIndex);
        StringExpr param5 = (StringExpr)parameter.get(startPeriodIndex);
        StringExpr param6 = (StringExpr)parameter.get(endPeriodIndex);
        if (model instanceof BgFormInfo) {
            String bgPeriodNum;
            String currencyNum;
            String bgSchmeNum;
            String orgNum;
            BgFormInfo _bgFormInfo = (BgFormInfo)model;
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value))) {
                ((StringExpr)param0).value = _bgFormInfo.getOrgUnit().getNumber().trim();
            }
            if (StringUtils.isEmpty((String)(bgSchmeNum = param1.value))) {
                String string = param1.value = _bgFormInfo.getBgScheme().getNumber() == null ? "" : _bgFormInfo.getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param4.value))) {
                param4.value = _bgFormInfo.getCurrency().getNumber();
            }
            if (!StringUtils.isEmpty((String)(bgPeriodNum = param5.value))) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param5.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            } else if (isNeedFillPeriod) {
                param5.value = StringUtils.isEmpty((String)startPeriod) ? _bgFormInfo.getBgPeriod().getNumber() : startPeriod;
            }
            if (!StringUtils.isEmpty((String)(bgPeriodNum = param6.value))) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param6.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            } else if (isNeedFillPeriod) {
                param6.value = StringUtils.isEmpty((String)endPeriod) ? _bgFormInfo.getBgPeriod().getNumber() : endPeriod;
            }
        } else if (model instanceof BgActualRecordInfo) {
            String bgPeriodNum;
            String currencyNum;
            String bgSchmeNum;
            String orgNum;
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value))) {
                ((StringExpr)param0).value = _bgActualInfo.getBgForm().getOrgUnit().getNumber().trim();
            }
            if (StringUtils.isEmpty((String)(bgSchmeNum = param1.value))) {
                param1.value = _bgActualInfo.getBgForm().getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param4.value))) {
                param4.value = _bgActualInfo.getBgForm().getCurrency().getNumber();
            }
            if (!StringUtils.isEmpty((String)(bgPeriodNum = param5.value))) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param5.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            } else if (isNeedFillPeriod) {
                param5.value = StringUtils.isEmpty((String)startPeriod) ? _bgActualInfo.getBgPeriod().getNumber() : startPeriod;
            }
            if (!StringUtils.isEmpty((String)(bgPeriodNum = param6.value))) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param6.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            } else if (isNeedFillPeriod) {
                param6.value = StringUtils.isEmpty((String)endPeriod) ? _bgActualInfo.getBgPeriod().getNumber() : endPeriod;
            }
        } else if (model instanceof BgWorkPaperInfo) {
            String bgPeriodNum;
            String currencyNum;
            String bgSchmeNum;
            String orgNum;
            BgWorkPaperInfo info = (BgWorkPaperInfo)model;
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value)) && !StringUtils.isEmpty((String)costCenterNumber)) {
                ((StringExpr)param0).value = costCenterNumber.trim();
            }
            if (StringUtils.isEmpty((String)(bgSchmeNum = param1.value))) {
                param1.value = info.getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param4.value))) {
                param4.value = info.getCurrency().getNumber();
            }
            if (StringUtils.isEmpty((String)(bgPeriodNum = param5.value))) {
                param5.value = info.getBgPeriod().getNumber();
            } else {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)info.getBgPeriod().getNumber(), (String)param5.value, (int)info.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            bgPeriodNum = param6.value;
            if (StringUtils.isEmpty((String)bgPeriodNum)) {
                param6.value = info.getBgPeriod().getNumber();
            } else {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)info.getBgPeriod().getNumber(), (String)param6.value, (int)info.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
    }

    private static void checkBgDifferenceParam(List parameter, IObjectValue model, String costCenterNumber) {
        if (parameter == null || parameter.size() != 8) {
            return;
        }
        if (model instanceof BgFormInfo) {
            String bgPeriodNum;
            String currencyNum;
            String bgSchmeNum;
            String orgNum;
            BgFormInfo _bgFormInfo = (BgFormInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param1 = (StringExpr)parameter.get(1);
            StringExpr param4 = (StringExpr)parameter.get(4);
            StringExpr param5 = (StringExpr)parameter.get(5);
            StringExpr param6 = (StringExpr)parameter.get(6);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value))) {
                ((StringExpr)param0).value = _bgFormInfo.getOrgUnit().getNumber().trim();
            }
            if (StringUtils.isEmpty((String)(bgSchmeNum = param1.value))) {
                param1.value = _bgFormInfo.getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param4.value))) {
                param4.value = _bgFormInfo.getCurrency().getNumber();
            }
            if (!StringUtils.isEmpty((String)(bgPeriodNum = param5.value))) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param5.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            if (!StringUtils.isEmpty((String)(bgPeriodNum = param6.value))) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param6.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof BgActualRecordInfo) {
            String bgPeriodNum;
            String currencyNum;
            String bgSchmeNum;
            String orgNum;
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param1 = (StringExpr)parameter.get(1);
            StringExpr param4 = (StringExpr)parameter.get(4);
            StringExpr param5 = (StringExpr)parameter.get(5);
            StringExpr param6 = (StringExpr)parameter.get(6);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value))) {
                ((StringExpr)param0).value = _bgActualInfo.getBgForm().getOrgUnit().getNumber().trim();
            }
            if (StringUtils.isEmpty((String)(bgSchmeNum = param1.value))) {
                param1.value = _bgActualInfo.getBgForm().getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param4.value))) {
                param4.value = _bgActualInfo.getBgForm().getCurrency().getNumber();
            }
            if (!StringUtils.isEmpty((String)(bgPeriodNum = param5.value))) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param5.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            if (!StringUtils.isEmpty((String)(bgPeriodNum = param6.value))) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param6.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof BgWorkPaperInfo) {
            String bgPeriodNum;
            String currencyNum;
            String bgSchmeNum;
            String orgNum;
            BgWorkPaperInfo info = (BgWorkPaperInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param1 = (StringExpr)parameter.get(1);
            StringExpr param4 = (StringExpr)parameter.get(4);
            StringExpr param5 = (StringExpr)parameter.get(5);
            StringExpr param6 = (StringExpr)parameter.get(6);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value)) && !StringUtils.isEmpty((String)costCenterNumber)) {
                ((StringExpr)param0).value = costCenterNumber.trim();
            }
            if (StringUtils.isEmpty((String)(bgSchmeNum = param1.value))) {
                param1.value = info.getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param4.value))) {
                param4.value = info.getCurrency().getNumber();
            }
            if (StringUtils.isEmpty((String)(bgPeriodNum = param5.value))) {
                param5.value = info.getBgPeriod().getNumber();
            } else {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)info.getBgPeriod().getNumber(), (String)param5.value, (int)info.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            bgPeriodNum = param6.value;
            if (StringUtils.isEmpty((String)bgPeriodNum)) {
                param6.value = info.getBgPeriod().getNumber();
            } else {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)info.getBgPeriod().getNumber(), (String)param6.value, (int)info.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
    }

    private static void checkBgAvlBalFormulaParam(List parameter, IObjectValue model, String costCenterNumber) {
        if (parameter == null || parameter.size() != 6) {
            return;
        }
        if (model instanceof BgFormInfo) {
            String bgPeriodNum;
            String currencyNum;
            String bgSchmeNum;
            String orgNum;
            BgFormInfo _bgFormInfo = (BgFormInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param1 = (StringExpr)parameter.get(1);
            StringExpr param4 = (StringExpr)parameter.get(4);
            StringExpr param5 = (StringExpr)parameter.get(5);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value))) {
                ((StringExpr)param0).value = _bgFormInfo.getOrgUnit().getNumber().trim();
            }
            if (StringUtils.isEmpty((String)(bgSchmeNum = param1.value))) {
                param1.value = _bgFormInfo.getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param4.value))) {
                param4.value = _bgFormInfo.getCurrency().getNumber();
            }
            if (!StringUtils.isEmpty((String)(bgPeriodNum = param5.value))) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param5.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof BgActualRecordInfo) {
            String bgPeriodNum;
            String currencyNum;
            String bgSchmeNum;
            String orgNum;
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param1 = (StringExpr)parameter.get(1);
            StringExpr param4 = (StringExpr)parameter.get(4);
            StringExpr param5 = (StringExpr)parameter.get(5);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value))) {
                ((StringExpr)param0).value = _bgActualInfo.getBgForm().getOrgUnit().getNumber().trim();
            }
            if (StringUtils.isEmpty((String)(bgSchmeNum = param1.value))) {
                param1.value = _bgActualInfo.getBgForm().getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param4.value))) {
                param4.value = _bgActualInfo.getBgForm().getCurrency().getNumber();
            }
            if (!StringUtils.isEmpty((String)(bgPeriodNum = param5.value))) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param5.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof BgWorkPaperInfo) {
            String bgPeriodNum;
            String currencyNum;
            String bgSchmeNum;
            String orgNum;
            BgWorkPaperInfo info = (BgWorkPaperInfo)model;
            Object param0 = parameter.get(0);
            StringExpr param1 = (StringExpr)parameter.get(1);
            StringExpr param4 = (StringExpr)parameter.get(4);
            StringExpr param5 = (StringExpr)parameter.get(5);
            if (param0 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param0).value)) && !StringUtils.isEmpty((String)costCenterNumber)) {
                ((StringExpr)param0).value = costCenterNumber.trim();
            }
            if (StringUtils.isEmpty((String)(bgSchmeNum = param1.value))) {
                param1.value = info.getBgScheme().getNumber();
            }
            if (StringUtils.isEmpty((String)(currencyNum = param4.value))) {
                param4.value = info.getCurrency().getNumber();
            }
            if (StringUtils.isEmpty((String)(bgPeriodNum = param5.value))) {
                param5.value = info.getBgPeriod().getNumber();
            } else {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)info.getBgPeriod().getNumber(), (String)param5.value, (int)info.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
    }

    private static void checkBgGetOrgAttrParam(List parameter, IObjectValue model) {
        if (parameter == null || parameter.size() != 3) {
            return;
        }
        if (model instanceof BgFormInfo) {
            BgFormInfo _bgFormInfo = (BgFormInfo)model;
            StringExpr param0 = (StringExpr)parameter.get(0);
            String orgUnitNumber = param0.value;
            if (StringUtils.isEmpty((String)orgUnitNumber)) {
                param0.value = _bgFormInfo.getOrgUnit().getNumber();
            }
        } else if (model instanceof BgActualRecordInfo) {
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            StringExpr param0 = (StringExpr)parameter.get(0);
            String orgUnitNumber = param0.value;
            if (StringUtils.isEmpty((String)orgUnitNumber)) {
                param0.value = _bgActualInfo.getBgForm().getOrgUnit().getNumber();
            }
        }
    }

    public static void getExpressionParam(String expressions, final BgPeriodInfo periodInfo, final Map param) {
        if (!StringUtils.isEmpty((String)expressions)) {
            Expression expression = null;
            try {
                expression = ExcelFormulaPaserHelper.parse((String)expressions);
                expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                    public Expression handle(Expression expr) {
                        return BgNExpressionHelper.checkExpression(expr, periodInfo, param);
                    }
                });
            }
            catch (Exception ex) {
                logger.error((Object)expressions);
                logger.error((Object)ex);
            }
        }
    }

    private static Expression checkExpression(Expression expression, BgPeriodInfo periodInfo, Map params) {
        if (expression instanceof FunctionExpr) {
            expression = BgNExpressionHelper.checkFunctionExpr((FunctionExpr)expression, periodInfo, params);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgNExpressionHelper.checkBinaryOperationExpr((BinaryOperationExpr)expression, periodInfo, params);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = BgNExpressionHelper.checkUnaryOperationExpr((UnaryOperationExpr)expression, periodInfo, params);
        }
        return expression;
    }

    private static BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, BgPeriodInfo periodInfo, Map params) {
        boExpr.left = BgNExpressionHelper.checkExpression(boExpr.left, periodInfo, params);
        boExpr.right = BgNExpressionHelper.checkExpression(boExpr.right, periodInfo, params);
        return boExpr;
    }

    private static UnaryOperationExpr checkUnaryOperationExpr(UnaryOperationExpr boExpr, BgPeriodInfo periodInfo, Map params) {
        return boExpr;
    }

    private static Expression checkFunctionExpr(FunctionExpr funExpr, BgPeriodInfo periodInfo, Map params) {
        String funcionName = funExpr.funcionName;
        try {
            if (BGFORMULA_STR.equalsIgnoreCase(funcionName)) {
                FunctionExpr _expression = funExpr;
                if (_expression instanceof FunctionExpr) {
                    BgNExpressionHelper.checkExpressionParam(_expression, periodInfo, params);
                }
                return _expression;
            }
            BgNExpressionHelper.checkExpressionParam(funExpr, periodInfo, params);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return funExpr;
    }

    private static void checkExpressionParam(FunctionExpr funExpr, BgPeriodInfo periodInfo, Map params) {
        String funcionName = funExpr.funcionName;
        if (BGFORMULA_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgFormulaParam(funExpr.toString(), periodInfo, funExpr.parameters, params);
        }
    }

    private static void checkBgFormulaParam(String expr, BgPeriodInfo periodInfo, List parameter, Map params) {
        if (parameter == null || parameter.size() != 7) {
            return;
        }
        Object[] item = new Object[7];
        item[0] = ((StringExpr)parameter.get((int)0)).value;
        item[1] = ((StringExpr)parameter.get((int)1)).value;
        item[2] = ((StringExpr)parameter.get((int)2)).value;
        item[3] = ((StringExpr)parameter.get((int)3)).value;
        item[4] = ((StringExpr)parameter.get((int)4)).value;
        item[5] = ((StringExpr)parameter.get((int)5)).value;
        if (item[5] != null && BgNExpressionHelper.isInteger((String)item[5])) {
            item[5] = BgNPeriodHelper.getOffsetBgPeriodNumberForExpression(periodInfo.getNumber(), Integer.parseInt((String)item[5]));
        }
        item[6] = ((StringExpr)parameter.get((int)6)).value;
        if (item[6] != null && BgNExpressionHelper.isInteger((String)item[6])) {
            item[6] = BgNPeriodHelper.getOffsetBgPeriodNumberForExpression(periodInfo.getNumber(), Integer.parseInt((String)item[6]));
        }
        params.put(expr, item);
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Expression checkAcctParam(Expression expression, IObjectValue model, Map cacheMap) {
        if (expression instanceof FunctionExpr) {
            if (ACCT_STR.equalsIgnoreCase(((FunctionExpr)expression).funcionName)) {
                BgNExpressionHelper.checkAcctParam(((FunctionExpr)expression).parameters, model, cacheMap);
            }
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgNExpressionHelper.checkAcctParam((BinaryOperationExpr)expression, model, cacheMap);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = BgNExpressionHelper.checkUnaryOperationExpr((UnaryOperationExpr)expression, model);
        }
        return expression;
    }

    private static BinaryOperationExpr checkAcctParam(BinaryOperationExpr boExpr, IObjectValue model, Map cacheMap) {
        boExpr.left = BgNExpressionHelper.checkAcctParam(boExpr.left, model, cacheMap);
        boExpr.right = BgNExpressionHelper.checkAcctParam(boExpr.right, model, cacheMap);
        return boExpr;
    }

    public static void checkAcctParam(List parameter, IObjectValue model, Map cacheMap) {
        block44: {
            CostCenterOrgUnitInfo costInfo;
            String accountItem;
            StringExpr param1;
            OrgUnitInfo info;
            Map<String, List> accountCache;
            block43: {
                if (parameter == null || parameter.size() < 8 || parameter.size() > 9) {
                    return;
                }
                Map<BOSUuid, OrgUnitInfo> comapnyCache = null;
                if (cacheMap != null && cacheMap.containsKey("ORGUNIT_COMPANY")) {
                    comapnyCache = (Map)cacheMap.get("ORGUNIT_COMPANY");
                } else {
                    comapnyCache = new HashMap();
                    if (cacheMap != null) {
                        cacheMap.put("ORGUNIT_COMPANY", comapnyCache);
                    }
                }
                Map<BOSUuid, CostCenterOrgUnitInfo> costCenterCache = null;
                if (cacheMap != null && cacheMap.containsKey("ORGUNIT_COST")) {
                    costCenterCache = (Map)cacheMap.get("ORGUNIT_COST");
                } else {
                    costCenterCache = new HashMap();
                    if (cacheMap != null) {
                        cacheMap.put("ORGUNIT_COST", costCenterCache);
                    }
                }
                accountCache = null;
                if (cacheMap != null && cacheMap.containsKey("ORGUNIT_ACCOUNT")) {
                    accountCache = (Map)cacheMap.get("ORGUNIT_ACCOUNT");
                } else {
                    accountCache = new HashMap();
                    if (cacheMap != null) {
                        cacheMap.put("ORGUNIT_ACCOUNT", accountCache);
                    }
                }
                OrgUnitInfo orginfo = null;
                info = null;
                if (model.get("orgUnit") instanceof OrgUnitInfo) {
                    orginfo = (OrgUnitInfo)model.get("orgUnit");
                }
                if (orginfo == null && model instanceof BgActualRecordInfo) {
                    BgActualRecordInfo actualInfo = (BgActualRecordInfo)model;
                    orginfo = actualInfo.getBgForm().getOrgUnit();
                }
                if (orginfo == null) {
                    return;
                }
                if (!(parameter.get(0) instanceof StringExpr)) {
                    return;
                }
                try {
                    StringExpr param0 = (StringExpr)parameter.get(0);
                    String orgNumber = param0.value;
                    if (comapnyCache.containsKey(orginfo.getId())) {
                        info = (OrgUnitInfo)comapnyCache.get(orginfo.getId());
                    } else {
                        orginfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orginfo.getId()));
                        info = BgNExpressionHelper.getCompanyOrgUnitByBgOrgUnit(null, orginfo);
                        comapnyCache.put(orginfo.getId(), info);
                    }
                    if (StringUtils.isEmpty((String)orgNumber)) {
                        param0.value = info.getNumber();
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                if (!(parameter.get(1) instanceof StringExpr)) {
                    return;
                }
                param1 = (StringExpr)parameter.get(1);
                accountItem = param1.value;
                costInfo = null;
                try {
                    if (orginfo.isIsCostOrgUnit()) {
                        if (costCenterCache.containsKey(orginfo.getId())) {
                            costInfo = (CostCenterOrgUnitInfo)costCenterCache.get(orginfo.getId());
                        } else {
                            costInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orginfo.getId()));
                            costCenterCache.put(orginfo.getId(), costInfo);
                        }
                        break block43;
                    }
                    return;
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
            String[] itemType = accountItem.split("\\|");
            if (info == null) {
                return;
            }
            String companyID = info.getId().toString();
            if (itemType.length >= 2) {
                try {
                    List costCenterOrgNumber = null;
                    List items = BgNExpressionHelper.getAccountItem(itemType[0]);
                    if (items == null) {
                        return;
                    }
                    String key = companyID + "_" + itemType[0];
                    if (accountCache.containsKey(key)) {
                        costCenterOrgNumber = (List)accountCache.get(key);
                    } else {
                        StringBuffer sql = new StringBuffer();
                        sql.append("select FASSTHGATTRIBUTE,fnumber from T_BD_AsstActType where fid in ");
                        sql.append("(select FAsstActTypeID from T_BD_AsstActGroupDetail where fAsstAccountID in ");
                        sql.append("(select FCAA from T_BD_AccountView where FCompanyID= '" + companyID + "'  and fnumber in ");
                        sql.append("(");
                        for (int n = 0; n < items.size(); ++n) {
                            sql.append("'").append(items.get(n)).append("'");
                            sql.append(",");
                        }
                        sql.deleteCharAt(sql.length() - 1);
                        sql.append(")");
                        sql.append("))");
                        costCenterOrgNumber = BgNFormFacadeFactory.getRemoteInstance().getAccountBizCostCenterNumber(sql.toString());
                        accountCache.put(key, costCenterOrgNumber);
                    }
                    if (costCenterOrgNumber == null || costCenterOrgNumber.isEmpty()) break block44;
                    String type = null;
                    String number = null;
                    String[] array = null;
                    for (int i = 0; i < costCenterOrgNumber.size(); ++i) {
                        array = (String[])costCenterOrgNumber.get(i);
                        type = array[0];
                        number = array[1];
                        if ("costOrg".equalsIgnoreCase(type) && itemType.length == 2) {
                            param1.value = itemType[0] + "|" + itemType[1] + "|" + costInfo.getNumber();
                        } else {
                            if (!"costOrg".equalsIgnoreCase(type) || itemType.length <= 3) continue;
                            int len = itemType.length;
                            String[] newItemType = new String[len + 1];
                            if (accountItem.endsWith("|") && itemType[len - 1].equals(number)) {
                                for (int k = 0; k < newItemType.length; ++k) {
                                    newItemType[k] = k == newItemType.length - 1 ? "" : itemType[k];
                                }
                                itemType = newItemType;
                                ++len;
                            }
                            for (int l = 0; l < len; ++l) {
                                if (!"".equals(itemType[l]) || !itemType[l - 1].equals(number)) continue;
                                itemType[l] = costInfo.getNumber();
                            }
                            param1.value = "";
                            for (int m = 0; m < len; ++m) {
                                param1.value = m == len - 1 ? param1.value + itemType[m] : param1.value + itemType[m] + "|";
                            }
                        }
                        break;
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    private static List getAccountItem(String item) {
        if (item == null) {
            return null;
        }
        ArrayList<String> itemList = new ArrayList<String>();
        String[] items = null;
        if (item.indexOf(58) >= 0) {
            String tmpItem = null;
            String[] tmpItems = null;
            items = item.split(":");
            for (int i = 0; i < items.length; ++i) {
                tmpItem = items[i];
                if (tmpItem != null && tmpItem.indexOf(44) >= 0) {
                    tmpItems = tmpItem.split(",");
                    for (int j = 0; j < tmpItems.length; ++j) {
                        if (StringUtils.isEmpty((String)tmpItems[j])) continue;
                        itemList.add(tmpItems[j]);
                    }
                    continue;
                }
                if (StringUtils.isEmpty((String)tmpItem)) continue;
                itemList.add(tmpItem);
            }
        } else if (item.indexOf(44) >= 0) {
            String tmpItem = null;
            String[] tmpItems = null;
            items = item.split(",");
            for (int i = 0; i < items.length; ++i) {
                tmpItem = items[i];
                if (tmpItem != null && tmpItem.indexOf(58) >= 0) {
                    tmpItems = tmpItem.split(":");
                    for (int j = 0; j < tmpItems.length; ++j) {
                        if (StringUtils.isEmpty((String)tmpItems[j])) continue;
                        itemList.add(tmpItems[j]);
                    }
                    continue;
                }
                if (StringUtils.isEmpty((String)tmpItem)) continue;
                itemList.add(tmpItem);
            }
        } else {
            itemList.add(item);
        }
        return itemList;
    }

    public static OrgUnitInfo getCompanyOrgUnitByBgOrgUnit(Context ctx, OrgUnitInfo orgInfo) {
        if (orgInfo == null) {
            return orgInfo;
        }
        if (orgInfo.isIsCompanyOrgUnit()) {
            return orgInfo;
        }
        if (orgInfo.isIsCostOrgUnit()) {
            try {
                CostCenterOrgUnitInfo costInfo = ctx == null ? CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId())) : CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId()));
                CostCenterOrgUnitInfo parentInfo = costInfo.getParent();
                if (parentInfo == null) {
                    return costInfo;
                }
                parentInfo = ctx == null ? CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentInfo.getId())) : CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentInfo.getId()));
                return BgNExpressionHelper.getCompanyOrgUnitByBgOrgUnit(ctx, (OrgUnitInfo)parentInfo);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return orgInfo;
    }

    public static void dealAcctExpressionAtAddNew(Book book, IObjectValue model, int viewMode) throws Exception {
        if (book == null) {
            return;
        }
        Sheet sheet = null;
        Cell cell = null;
        Object obj = null;
        Map tmpMap = null;
        String exp = null;
        Expression expression = null;
        BgNFSHelper.disableCal(book);
        boolean count = false;
        HashMap cacheMap = new HashMap();
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int maxRow = sheet.getMaxRowIndex() + 1;
            int maxCol = sheet.getMaxColIndex() + 1;
            for (int rowIndex = 0; rowIndex < maxRow; ++rowIndex) {
                for (int colIndex = 0; colIndex < maxCol; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasExpression(cell, viewMode)) continue;
                    obj = cell.getUserObjectValue("CELL_DATA");
                    if (obj != null && obj instanceof Map) {
                        tmpMap = (Map)obj;
                        switch (viewMode) {
                            case 0: {
                                if (!tmpMap.containsKey("BG_BUDGET_EXPRESSIONS")) break;
                                exp = (String)tmpMap.get("BG_BUDGET_EXPRESSIONS");
                                break;
                            }
                            case 1: {
                                if (!tmpMap.containsKey("BG_ACTUAL_EXPRESSIONS")) break;
                                exp = (String)tmpMap.get("BG_ACTUAL_EXPRESSIONS");
                                break;
                            }
                            case 2: {
                                if (!tmpMap.containsKey("BG_ADD_EXPRESSIONS")) break;
                                exp = (String)tmpMap.get("BG_ADD_EXPRESSIONS");
                                break;
                            }
                        }
                    }
                    if (exp == null || exp.trim().length() == 0 || exp.toUpperCase(Locale.ENGLISH).indexOf("ACCT(") < 0) continue;
                    expression = ExcelFormulaPaserHelper.parse((String)exp);
                    BgNExpressionHelper.checkAcctParam(expression, model, cacheMap);
                    if (obj != null && obj instanceof Map) {
                        tmpMap = (Map)obj;
                        switch (viewMode) {
                            case 0: {
                                tmpMap.put("BG_BUDGET_EXPRESSIONS", "=" + expression.toString());
                                break;
                            }
                            case 1: {
                                tmpMap.put("BG_ACTUAL_EXPRESSIONS", "=" + expression.toString());
                                break;
                            }
                            case 2: {
                                tmpMap.put("BG_ADD_EXPRESSIONS", "=" + expression.toString());
                                break;
                            }
                        }
                    }
                    BgNFSHelper.setExpression(cell, "=" + expression.toString());
                }
            }
        }
        BgNFSHelper.enableCal(book);
    }

    private static void checkAcctItemParam(List parameter, IObjectValue model, String costCenterNumber, Expression funExpr) throws BOSException {
        if (parameter == null || parameter.size() != 17) {
            return;
        }
        if (model instanceof BgFormInfo) {
            BgFormInfo _bgFormInfo = (BgFormInfo)model;
            Object param1 = parameter.get(1);
            if (param1 instanceof StringExpr) {
                String orgNum = ((StringExpr)param1).value;
                BgNExpressionHelper.expressionFix(funExpr, parameter, model, null, null, null, new HashMap(), new HashMap());
            }
        } else if (model instanceof BgActualRecordInfo) {
            String orgNum;
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            Object param1 = parameter.get(1);
            if (param1 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param1).value))) {
                ((StringExpr)param1).value = _bgActualInfo.getBgForm().getOrgUnit().getNumber().trim();
            }
        } else if (model instanceof BgWorkPaperInfo) {
            String orgNum;
            BgWorkPaperInfo info = (BgWorkPaperInfo)model;
            Object param1 = parameter.get(1);
            if (param1 instanceof StringExpr && StringUtils.isEmpty((String)(orgNum = ((StringExpr)param1).value)) && !StringUtils.isEmpty((String)costCenterNumber)) {
                ((StringExpr)param1).value = costCenterNumber.trim();
            }
        }
    }

    private static void expressionFix(Expression expression, List parameter, IObjectValue model, OrgUnitInfo orginfo, Context ctx, OrgUnitInfo info, Map cacheMap, Map orgTreeMap) throws BOSException {
        if (model.get("orgUnit") instanceof OrgUnitInfo) {
            orginfo = (OrgUnitInfo)model.get("orgUnit");
        }
        if (orginfo == null && model instanceof BgActualRecordInfo) {
            BgActualRecordInfo actualInfo = (BgActualRecordInfo)model;
            orginfo = actualInfo.getBgForm().getOrgUnit();
        }
        if (orginfo == null) {
            return;
        }
        if (!(parameter.get(1) instanceof StringExpr)) {
            return;
        }
        try {
            orginfo = ctx == null ? FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orginfo.getId())) : FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orginfo.getId()));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        if (cacheMap.containsKey(orginfo.getId())) {
            info = (OrgUnitInfo)cacheMap.get(orginfo.getId());
        } else {
            RptSrcTypeEnum rptTypeEnum;
            String rptType = parameter.get(10).toString();
            if (rptType != null && rptType.indexOf("\"") != -1) {
                rptType = rptType.replaceAll("\"", "");
            }
            if ((rptTypeEnum = RptSrcTypeEnum.getEnum((String)rptType)) != null && rptTypeEnum.equals((Object)RptSrcTypeEnum.COMMITREPORT)) {
                info = BgNExpressionHelper.getCompanyOrgUnit(ctx, orginfo);
            } else {
                String orgTreeID = null;
                if (orgTreeMap.containsKey(orgTreeID)) {
                    orgTreeID = (String)orgTreeMap.get(orgTreeID);
                } else {
                    IOrgTree orgTreeInteger = null;
                    orgTreeInteger = ctx == null ? OrgTreeFactory.getRemoteInstance() : OrgTreeFactory.getLocalInstance((Context)ctx);
                    String orgNumber = parameter.get(0).toString();
                    if (orgNumber != null && orgNumber.indexOf("\"") != -1) {
                        orgNumber = orgNumber.replaceAll("\"", "");
                    }
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber, CompareType.EQUALS));
                    view.setFilter(filter);
                    OrgTreeCollection orgTreeColl = orgTreeInteger.getOrgTreeCollection(view);
                    if (orgTreeColl != null && orgTreeColl.size() > 0) {
                        orgTreeID = orgTreeColl.get(0).getId().toString();
                        orgTreeMap.put(orgTreeID, orgTreeID);
                    }
                }
                String companyNumber = null;
                if (orginfo.isIsCostOrgUnit() && !orginfo.isIsCompanyOrgUnit()) {
                    OrgUnitInfo tmpOrgUnitInfo = null;
                    tmpOrgUnitInfo = ctx == null ? BgNExpressionHelper.getEntrustOrgUnit(null, orginfo.getId().toString()) : BgNExpressionHelper.getEntrustOrgUnit(ctx, orginfo.getId().toString());
                    if (tmpOrgUnitInfo != null) {
                        companyNumber = tmpOrgUnitInfo.getNumber();
                    }
                } else {
                    companyNumber = orginfo.getNumber();
                }
                if (orgTreeID != null && companyNumber != null) {
                    BgNExpressionHelper.acctItemCompanyNumHandle(ctx, (FunctionExpr)expression, orgTreeID, companyNumber);
                }
            }
            if (info != null) {
                cacheMap.put(orginfo.getId(), info);
            }
        }
        StringExpr param = (StringExpr)parameter.get(1);
        String orgNumber = param.value;
        if (StringUtils.isEmpty((String)orgNumber) && info != null) {
            param.value = info.getNumber();
        }
    }

    private static OrgUnitInfo getCompanyOrgUnit(Context ctx, OrgUnitInfo orgInfo) throws BOSException {
        if (orgInfo == null) {
            return null;
        }
        if (orgInfo.isIsCompanyOrgUnit() && orgInfo.isIsCostOrgUnit()) {
            return orgInfo;
        }
        if (orgInfo.isIsCostOrgUnit() && !orgInfo.isIsCompanyOrgUnit()) {
            if (ctx == null) {
                return BgNExpressionHelper.getEntrustOrgUnit(null, orgInfo.getId().toString());
            }
            return BgNExpressionHelper.getEntrustOrgUnit(ctx, orgInfo.getId().toString());
        }
        return null;
    }

    public static OrgUnitInfo getEntrustOrgUnit(Context ctx, String orgUnitID) throws BOSException {
        if (StringUtils.isEmpty((String)orgUnitID)) {
            return null;
        }
        OrgUnitRelationCollection coll = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", (Object)orgUnitID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(5), CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("toUnit.id"));
        selector.add(new SelectorItemInfo("toUnit.number"));
        view.setFilter(filter);
        view.setSelector(selector);
        coll = ctx == null ? OrgUnitRelationFactory.getRemoteInstance().getOrgUnitRelationCollection(view) : OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(view);
        if (coll != null && !coll.isEmpty()) {
            return coll.get(0).getToUnit();
        }
        return null;
    }

    private static void acctItemCompanyNumHandle(Context ctx, FunctionExpr e, String orgTreeID, String companyNumber) throws BOSException {
        RptSrcTypeEnum rptTypeEnum;
        ArrayList<String> param = new ArrayList<String>();
        String rptType = e.parameters.get(10).toString();
        if (rptType != null && rptType.indexOf("\"") != -1) {
            rptType = rptType.replaceAll("\"", "");
        }
        if ((rptTypeEnum = RptSrcTypeEnum.getEnum((String)rptType)) != null && rptTypeEnum.equals((Object)RptSrcTypeEnum.COMMITREPORT)) {
            return;
        }
        if (rptTypeEnum == null || rptTypeEnum.getValue() == RptSrcTypeEnum.NORMAL.getValue()) {
            rptType = RptSrcTypeEnum.COMMITREPORT.getName();
            StringExpr se = new StringExpr(rptType);
            e.parameters.set(10, se);
            return;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append(" select unit0.FNumber unitNum from t_org_OupartUnionGroup p \n");
        sql.append(" join t_org_BaseUnit company on p.FStockControlCompanyId= company.FId \n");
        sql.append(" join t_org_Structure s0 on p.FUnitId = s0.FUnitId \n");
        sql.append(" join t_org_BaseUnit unit0 on p.funitid = unit0.fid \n");
        sql.append(" where s0.FTreeId = ? \n");
        sql.append(" and company.fnumber = ? \n");
        param.add(orgTreeID);
        param.add(companyNumber);
        try {
            IFMIsqlFacade isql = null;
            isql = ctx == null ? FMIsqlFacadeFactory.getRemoteInstance() : FMIsqlFacadeFactory.getLocalInstance((Context)ctx);
            IRowSet rowset = isql.executeQuery(sql.toString(), param.toArray());
            if (rowset == null || rowset.size() == 0) {
                return;
            }
            if (rowset.next()) {
                String unitNumber = rowset.getString("unitNum");
                StringExpr se = new StringExpr(unitNumber);
                e.parameters.set(1, se);
            }
        }
        catch (Exception e1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"209_FormulaUtil", (Locale)ctx.getLocale()) + e.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"210_FormulaUtil", (Locale)ctx.getLocale()) + e1));
            }
            throw new BOSException((Throwable)e1);
        }
    }

    public static void dealAcctItemExpression(Context ctx, Book book, IObjectValue model) throws Exception {
        if (book == null) {
            return;
        }
        book.setCalculate(false);
        book.getUndoManager().enable(false);
        Sheet sheet = null;
        Cell cell = null;
        HashMap<BOSUuid, OrgUnitInfo> cacheMap = new HashMap<BOSUuid, OrgUnitInfo>();
        HashMap<String, String> orgTreeMap = new HashMap<String, String>();
        OrgUnitInfo orginfo = null;
        OrgUnitInfo info = null;
        Expression expression = null;
        List parameter = null;
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int maxRow = sheet.getMaxRowIndex() + 1;
            int maxCol = sheet.getMaxColIndex() + 1;
            for (int rowIndex = 0; rowIndex < maxRow; ++rowIndex) {
                for (int colIndex = 0; colIndex < maxCol; ++colIndex) {
                    String exp;
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasExpression(cell) || StringUtils.isEmpty((String)(exp = cell.getFormula())) || !exp.toUpperCase(Locale.ENGLISH).startsWith("=ACCTITEM")) continue;
                    expression = ExcelFormulaPaserHelper.parse((String)exp);
                    if (expression instanceof FunctionExpr) {
                        parameter = ((FunctionExpr)expression).parameters;
                        if (model.get("orgUnit") instanceof OrgUnitInfo) {
                            orginfo = (OrgUnitInfo)model.get("orgUnit");
                        }
                        if (orginfo == null && model instanceof BgActualRecordInfo) {
                            BgActualRecordInfo actualInfo = (BgActualRecordInfo)model;
                            orginfo = actualInfo.getBgForm().getOrgUnit();
                        }
                        if (orginfo == null) {
                            return;
                        }
                        if (!(parameter.get(1) instanceof StringExpr)) {
                            return;
                        }
                        try {
                            orginfo = ctx == null ? FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orginfo.getId())) : FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orginfo.getId()));
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex);
                        }
                        if (cacheMap.containsKey(orginfo.getId())) {
                            info = (OrgUnitInfo)cacheMap.get(orginfo.getId());
                        } else {
                            RptSrcTypeEnum rptTypeEnum;
                            String rptType = parameter.get(10).toString();
                            if (rptType != null && rptType.indexOf("\"") != -1) {
                                rptType = rptType.replaceAll("\"", "");
                            }
                            if ((rptTypeEnum = RptSrcTypeEnum.getEnum((String)rptType)) != null && rptTypeEnum.equals((Object)RptSrcTypeEnum.COMMITREPORT)) {
                                info = BgNExpressionHelper.getCompanyOrgUnit(ctx, orginfo);
                            } else {
                                String orgTreeID = null;
                                if (orgTreeMap.containsKey(orgTreeID)) {
                                    orgTreeID = (String)orgTreeMap.get(orgTreeID);
                                } else {
                                    IOrgTree orgTreeInteger = null;
                                    orgTreeInteger = ctx == null ? OrgTreeFactory.getRemoteInstance() : OrgTreeFactory.getLocalInstance((Context)ctx);
                                    String orgNumber = parameter.get(0).toString();
                                    if (orgNumber != null && orgNumber.indexOf("\"") != -1) {
                                        orgNumber = orgNumber.replaceAll("\"", "");
                                    }
                                    EntityViewInfo view = new EntityViewInfo();
                                    FilterInfo filter = new FilterInfo();
                                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber, CompareType.EQUALS));
                                    view.setFilter(filter);
                                    OrgTreeCollection orgTreeColl = orgTreeInteger.getOrgTreeCollection(view);
                                    if (orgTreeColl != null && orgTreeColl.size() > 0) {
                                        orgTreeID = orgTreeColl.get(0).getId().toString();
                                        orgTreeMap.put(orgTreeID, orgTreeID);
                                    }
                                }
                                String companyNumber = null;
                                if (orginfo.isIsCostOrgUnit() && !orginfo.isIsCompanyOrgUnit()) {
                                    OrgUnitInfo tmpOrgUnitInfo = null;
                                    tmpOrgUnitInfo = ctx == null ? BgNExpressionHelper.getEntrustOrgUnit(null, orginfo.getId().toString()) : BgNExpressionHelper.getEntrustOrgUnit(ctx, orginfo.getId().toString());
                                    if (tmpOrgUnitInfo != null) {
                                        companyNumber = tmpOrgUnitInfo.getNumber();
                                    }
                                } else {
                                    companyNumber = orginfo.getNumber();
                                }
                                if (orgTreeID != null && companyNumber != null) {
                                    BgNExpressionHelper.acctItemCompanyNumHandle(ctx, (FunctionExpr)expression, orgTreeID, companyNumber);
                                }
                            }
                            if (info != null) {
                                cacheMap.put(orginfo.getId(), info);
                            }
                        }
                        StringExpr param = (StringExpr)parameter.get(1);
                        String orgNumber = param.value;
                        if (StringUtils.isEmpty((String)orgNumber) && info != null) {
                            param.value = info.getNumber();
                        }
                    }
                    BgNFSHelper.setExpression(cell, "=" + expression.toString());
                }
            }
        }
    }

    public static void dealAcctExpressionAtAddNew(Context ctx, Book book, IObjectValue model) throws Exception {
        if (book == null) {
            return;
        }
        book.setCalculate(false);
        book.getUndoManager().enable(false);
        Sheet sheet = null;
        Cell cell = null;
        HashMap cacheMap = new HashMap();
        String exp = null;
        Expression expression = null;
        String companyNumber = BgNExpressionHelper.getCompanyNumber(ctx, model);
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int maxRow = sheet.getMaxRowIndex() + 1;
            int maxCol = sheet.getMaxColIndex() + 1;
            for (int rowIndex = 0; rowIndex < maxRow; ++rowIndex) {
                for (int colIndex = 0; colIndex < maxCol; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    try {
                        if (!BgNFSHelper.checkHasExpression(cell) || StringUtils.isEmpty((String)(exp = cell.getFormula())) || exp.toUpperCase().indexOf("ACCT(") < 0) continue;
                        expression = ExcelFormulaPaserHelper.parse((String)exp);
                        if (expression instanceof FunctionExpr) {
                            BgNExpressionHelper.checkAcctParam(((FunctionExpr)expression).parameters, model, cacheMap);
                        } else {
                            expression = BgNExpressionHelper.checkExpression(expression, model, null, companyNumber);
                        }
                        BgNFSHelper.setExpression(cell, "=" + expression.toString());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static String getCompanyNumber(Context ctx, IObjectValue model) {
        if (model == null) {
            return null;
        }
        BOSUuid id = null;
        if (model instanceof BgFormInfo) {
            id = ((BgFormInfo)model).getOrgUnit().getId();
        } else if (model instanceof BgActualRecordInfo) {
            id = ((BgActualRecordInfo)model).getBgForm().getOrgUnit().getId();
        } else {
            return null;
        }
        FullOrgUnitInfo orgUnit = null;
        try {
            orgUnit = ctx == null ? FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id)) : FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            OrgUnitInfo company = BgNExpressionHelper.getCompanyOrgUnitByBgOrgUnit(ctx, (OrgUnitInfo)orgUnit);
            return company.getNumber().trim();
        }
        catch (EASBizException e) {
            logger.error((Object)e.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.toString());
        }
        return null;
    }

    public static void dealCashExpressionAtAddNew(Book book, IObjectValue model) throws Exception {
        if (book == null) {
            return;
        }
        book.setCalculate(false);
        book.getUndoManager().enable(false);
        Sheet sheet = null;
        Cell cell = null;
        HashMap cacheMap = new HashMap();
        ArrayList list = new ArrayList();
        Date beginDate = null;
        Date endDate = null;
        StringExpr e6 = null;
        StringExpr e7 = null;
        StringExpr empty = new StringExpr("");
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int maxRow = sheet.getMaxRowIndex() + 1;
            int maxCol = sheet.getMaxColIndex() + 1;
            for (int rowIndex = 0; rowIndex < maxRow; ++rowIndex) {
                for (int colIndex = 0; colIndex < maxCol; ++colIndex) {
                    Expression expression;
                    String exp;
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasExpression(cell) || StringUtils.isEmpty((String)(exp = cell.getFormula())) || !exp.toUpperCase(Locale.ENGLISH).startsWith("=CASH") || !((expression = ExcelFormulaPaserHelper.parse((String)exp)) instanceof FunctionExpr)) continue;
                    list = (ArrayList)((FunctionExpr)expression).parameters;
                    e6 = (StringExpr)list.get(6);
                    e7 = (StringExpr)list.get(7);
                    if (empty.toString().equals(e6.toString()) && empty.toString().equals(e7.toString())) {
                        BgPeriodInfo bpIfno = (BgPeriodInfo)model.get("bgPeriod");
                        beginDate = (Date)bpIfno.get("beginDate");
                        endDate = (Date)bpIfno.get("endDate");
                        if (beginDate != null && endDate != null) {
                            list.set(6, new StringExpr(beginDate.toString()));
                            list.set(7, new StringExpr(endDate.toString()));
                        }
                    }
                    BgNFSHelper.setExpression(cell, "=" + expression.toString());
                }
            }
        }
    }
}

