/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgNFDataHelper {
    private static Logger logger = Logger.getLogger((String)BgNFDataHelper.class.getName());

    public static Map queryAddNewBgData(Context ctx, IObjectValue editValue) {
        if (!(editValue instanceof BgFormInfo)) {
            return null;
        }
        BgFormInfo bgFormInfo = (BgFormInfo)editValue;
        HashMap formulaCache = new HashMap();
        HashSet<String> formulas = new HashSet<String>();
        try {
            Book book = bgFormInfo.getBook();
            if (book != null) {
                for (int s = 0; s < book.getSheetCount(); ++s) {
                    Sheet sheet = book.getSheet(s);
                    int maxRow = sheet.getMaxRowIndex();
                    int maxCol = sheet.getMaxColIndex();
                    for (int r = 0; r <= maxRow; ++r) {
                        for (int c = 0; c <= maxCol; ++c) {
                            String formula = BgNFSHelper.getFormulaOfCell(sheet.getCell(r, c, false));
                            if (StringUtils.isEmpty((String)formula)) continue;
                            formulas.add(BgNFSHelper.checkFormula(formulaCache, formula, (IObjectValue)bgFormInfo));
                        }
                    }
                }
            }
            IBgForm bgForm = null;
            bgForm = ctx == null ? BgFormFactory.getRemoteInstance() : BgFormFactory.getLocalInstance((Context)ctx);
            return bgForm.getBgDataInfo(bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), formulas);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }
}

