/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.RangeManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.bos.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BoolExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgMeasureUnitCollection;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTemMeasureUnitCollection;
import com.kingdee.eas.ma.budget.BgTemMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.NumberExpandInfo;
import com.kingdee.eas.ma.nbudget.BgEnumerateHelper;
import com.kingdee.eas.ma.nbudget.BgEnumerateInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.range.BgRange;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public final class BgNFSHelper {
    private static final Logger logger = Logger.getLogger(BgNFSHelper.class);
    public static final boolean trans4TO6 = true;
    public static final int paraItem = 0;
    public static final int paraPeriod = 1;
    public static final int paraElement = 2;
    public static final int paraCurrency = 3;
    public static final int paraOldItem = 0;
    public static final int paraOldPeriod = 1;
    public static final int paraOldElement = 2;
    public static final int paraOldDataType = 3;
    public static final int paraOldCollect = 4;
    public static final int paraOldCurrency = 5;
    public static final int decimal = 8;
    public static final int BUDGET_VIEW = 0;
    public static final int ACTUAL_VIEW = 1;
    public static final int ADD_VIEW = 2;
    public static final String SHEET_CREATER_ID = "SHEET_CREATER_ID";
    private static final String DoubleOrgError = "#BAD FUNCTION: Source cell is not numeric!";

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("auditor.id");
        sic.add("auditor.name");
        sic.add("state");
        sic.add("auditedStatus");
        sic.add("dataSource");
        sic.add("description");
        sic.add("versionNo");
        sic.add("startDate");
        sic.add("endDate");
        sic.add("data");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("company.isBizUnit");
        sic.add("company.accountPeriodType.id");
        sic.add("CU.id");
        sic.add("CU.name");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.period");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.isFormal");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.canModify");
        sic.add("bgTemplate.parent.id");
        sic.add("bgTemplate.rootId");
        sic.add("bgTemplate.formType");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgPeriod.beginDate");
        sic.add("bgPeriod.endDate");
        sic.add("bgPeriod.year");
        sic.add("bgPeriod.halfYear");
        sic.add("bgPeriod.quarter");
        sic.add("bgPeriod.month");
        sic.add("bgPeriod.week");
        sic.add("bgRollPeriod.id");
        sic.add("bgRollPeriod.name");
        sic.add("bgRollPeriod.number");
        sic.add("periodType");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.isoCode");
        sic.add("currency.precision");
        sic.add("bgItemGroup.id");
        sic.add("bgItemGroup.name");
        sic.add("bgItemGroup.number");
        sic.add("bgItem.id");
        sic.add("bgItem.name");
        sic.add("bgItem.number");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("postils.*");
        sic.add("postils.report.id");
        sic.add("postils.sheet.id");
        sic.add("postils.sheet.sheetID");
        sic.add("postils.creator.id");
        sic.add("postils.creator.name");
        sic.add("sheetParam.id");
        sic.add("sheetParam.sheetName");
        sic.add("sheetParam.startYear");
        sic.add("sheetParam.endYear");
        sic.add("sheetParam.startPeriod");
        sic.add("sheetParam.endPeriod");
        sic.add("sheetParam.startDate");
        sic.add("sheetParam.endDate");
        sic.add("sheetParam.isIncludingUnposted");
        sic.add("sheetParam.relaType");
        sic.add("sheetParam.sheetID");
        sic.add("sheetParam.reportClass");
        sic.add("sheetParam.cslSheetManner");
        sic.add("sheetParam.orgRela.id");
        sic.add("sheetParam.orgRela.orgType");
        sic.add("sheetParam.orgRela.orgUnit.id");
        sic.add("sheetParam.orgRela.orgUnit.type");
        sic.add("sheetParam.orgRela.orgUnit.name");
        sic.add("sheetParam.currency.id");
        sic.add("sheetParam.currency.number");
        sic.add("sheetParam.currency.name");
        sic.add("sheetParam.currency.precision");
        sic.add("sheetParam.postils.*");
        sic.add("sheetParam.postils.report.id");
        sic.add("sheetParam.postils.sheet.id");
        sic.add("sheetParam.postils.sheet.sheetID");
        sic.add("sheetParam.postils.creator.id");
        sic.add("sheetParam.postils.creator.name");
        sic.add("adjust.id");
        sic.add("adjustMapData");
        sic.add("auditTime");
        sic.add("courseOrgId");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("entries.rollStep");
        sic.add("entries.schemes.id");
        sic.add("entries.schemes.seq");
        sic.add("entries.schemes.bgFormState");
        sic.add("entries.schemes.scheme.id");
        sic.add("entries.schemes.level");
        return sic;
    }

    public static SelectorItemCollection getTemplateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("isAllowChange");
        sic.add("data");
        sic.add("canModify");
        sic.add("templateStatus");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgTemplate.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("defaultMeasureUnit.id");
        sic.add("defaultMeasureUnit.name");
        sic.add("defaultMeasureUnit.number");
        sic.add("defaultMeasureUnit.coefficient");
        sic.add("parent.id");
        sic.add("rootId");
        sic.add("formType");
        return sic;
    }

    public static SelectorItemCollection getViewTemplateDimensionSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("data");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.rootId");
        return sic;
    }

    public static SelectorItemCollection getGatherSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("CU.id");
        sic.add("orgUnit.id");
        sic.add("bgScheme.id");
        sic.add("bgScheme.rootId");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.rootId");
        sic.add("currency.id");
        sic.add("bgPeriod.id");
        sic.add("adjust.id");
        return sic;
    }

    public static boolean hasNumber(String companyId, IObjectValue model, ICodingRuleManager codingRuleManager) {
        if (StringUtils.isEmpty((String)companyId) || model == null) {
            return false;
        }
        boolean result = false;
        try {
            if (codingRuleManager == null) {
                codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            }
            result = codingRuleManager.isExist(model, companyId);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return result;
    }

    public static boolean hasNumber_server(Context ctx, String companyId, IObjectValue model) {
        if (ctx == null || StringUtils.isEmpty((String)companyId) || model == null) {
            return false;
        }
        boolean result = true;
        try {
            ICodingRuleManager codingRuleManager = null;
            codingRuleManager = ctx == null ? CodingRuleManagerFactory.getRemoteInstance() : CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist(model, companyId);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return result;
    }

    public static boolean hasDisplayNumber(String companyId, IObjectValue model, ICodingRuleManager codingRuleManager) {
        if (StringUtils.isEmpty((String)companyId) || model == null) {
            return false;
        }
        boolean isAddView = false;
        CodingRuleInfo codingRuleInfo = null;
        try {
            if (codingRuleManager == null) {
                codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            }
            isAddView = (codingRuleInfo = codingRuleManager.getCodingRule(model, companyId)) != null && codingRuleInfo.isIsAddView();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return isAddView;
    }

    public static void setNumber(String companyId, IObjectValue model, KDTextField txtField) throws Exception {
        if (StringUtils.isEmpty((String)companyId) || model == null) {
            return;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        CodingRuleInfo codingRuleInfo = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isExist(model, companyId);
            if (result) {
                if (txtField != null) {
                    txtField.setEnabled(false);
                }
                if ((codingRuleInfo = codingRuleManager.getCodingRule(model, companyId)) != null && codingRuleInfo.isIsAddView()) {
                    String number = null;
                    number = codingRuleManager.isUseIntermitNumber(model, companyId) ? codingRuleManager.getNumber(model, companyId) : codingRuleManager.getNumber(model, companyId);
                    if (!StringUtils.isEmpty((String)number)) {
                        model.put("number", (Object)number);
                        if (txtField != null) {
                            txtField.setText(number);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.NUMBERMANAGERERROR);
        }
    }

    public static void setNumber(String companyId, IObjectValue model) throws Exception {
        if (StringUtils.isEmpty((String)companyId) || model == null) {
            return;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        CodingRuleInfo codingRuleInfo = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isExist(model, companyId);
            if (result && (codingRuleInfo = codingRuleManager.getCodingRule(model, companyId)) != null && codingRuleInfo.isIsAddView()) {
                String number = null;
                number = codingRuleManager.isUseIntermitNumber(model, companyId) ? codingRuleManager.getNumber(model, companyId) : codingRuleManager.getNumber(model, companyId);
                if (!StringUtils.isEmpty((String)number)) {
                    model.put("number", (Object)number);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.NUMBERMANAGERERROR);
        }
    }

    public static void setNumber_server(Context ctx, String companyId, IObjectValue model) throws EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)companyId) || model == null) {
            return;
        }
        boolean result = true;
        String number = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist(model, companyId);
            if (result) {
                if (!codingRuleManager.isAddView(model, companyId)) {
                    number = codingRuleManager.getNumber(model, companyId);
                }
                if (!StringUtils.isEmpty(number)) {
                    model.put("number", (Object)number);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.NUMBERMANAGERERROR);
        }
    }

    public static boolean checkInProInst(String billId) throws BOSException {
        boolean result = false;
        ProcessInstInfo[] procInsts = EnactmentServiceFactory.createRemoteEnactService().getProcessInstanceByHoldedObjectId(billId);
        if (procInsts != null) {
            int in = procInsts.length;
            for (int i = 0; i < in; ++i) {
                if (!procInsts[i].getState().startsWith("open")) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean checkIsEmptyRow(Row row) {
        return BgNFSHelper.checkIsEmptyRow(row, false);
    }

    public static boolean checkIsEmptyRow(Row row, boolean isCheckMarge) {
        if (row == null) {
            return true;
        }
        Cell _cell = null;
        Sheet sheet = row.getSheet();
        int in = sheet.getMaxColIndex();
        for (int i = 0; i <= in; ++i) {
            CellBlock m_cell;
            _cell = row.getCell(i, false);
            if (!BgNFSHelper.checkIsEmptyCell(_cell)) {
                return false;
            }
            if (!isCheckMarge) continue;
            MergeBlocks mbs = sheet.getMerger(false);
            CellBlock cbl = sheet.getRange(row.getRow(), i).getBlock(0);
            if (mbs == null || !mbs.isMerged(cbl) || (m_cell = mbs.calActualBlock(cbl)) == null) continue;
            for (int mr = m_cell.getRow(); mr <= m_cell.getRow2(); ++mr) {
                for (int mc = m_cell.getCol(); mc <= m_cell.getCol2(); ++mc) {
                    if (BgNFSHelper.checkIsEmptyCell(sheet.getCell(mr, mc, false))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean checkIsEmptyCell(Cell cell) {
        return BgNFSHelper.checkIsEmptyValue(cell) && !BgNFSHelper.checkHasFormulaOfCell(cell) && !BgNFSHelper.checkHasExpression(cell) && !BgNFSHelper.checkHasBgItemInfo(cell) && !BgNFSHelper.checkHasBgPeriodInfo(cell) && !BgNFSHelper.checkHasBgElementInfo(cell) && !BgNFSHelper.checkHasCurrencyInfo(cell) && !BgNFSHelper.checkHasComment(cell) && !BgNFSHelper.checkHasLinked(cell) && !BgNFSHelper.checkHasEnumerateOfCell(cell);
    }

    public static boolean checkIsItemFormulaCell(Cell cell) {
        return !BgNFSHelper.checkHasFormulaOfCell(cell) && !BgNFSHelper.checkHasBgItemInfo(cell) && !BgNFSHelper.checkHasBgPeriodInfo(cell) && !BgNFSHelper.checkHasBgElementInfo(cell) && !BgNFSHelper.checkHasCurrencyInfo(cell);
    }

    public static boolean checkOnlyHasFormulaOfCell(Cell cell) {
        return BgNFSHelper.checkHasFormulaOfCell(cell) && !BgNFSHelper.checkHasExpression(cell) && !BgNFSHelper.checkHasBgItemInfo(cell) && !BgNFSHelper.checkHasBgPeriodInfo(cell) && !BgNFSHelper.checkHasBgElementInfo(cell) && !BgNFSHelper.checkHasCurrencyInfo(cell) && !BgNFSHelper.checkHasComment(cell) && !BgNFSHelper.checkHasLinked(cell) && !BgNFSHelper.checkHasEnumerateOfCell(cell);
    }

    public static boolean checkIsEmptyValue(Cell cell) {
        if (cell == null || cell.getValue() == Variant.nullVariant) {
            return true;
        }
        return cell.getValue() == Variant.nullVariant || cell.getValue().getValue() == null || cell.getValue().isNull() || cell.getValue().isEmpty() || StringUtils.isEmpty((String)cell.getValue().getValue().toString());
    }

    public static boolean checkIsEmptyContext(Cell cell) {
        return cell == null || cell.getValue().getValue() == null || cell.isEmptyContent();
    }

    public static boolean checkHasItemFormula(Cell cell) {
        Object obj;
        return cell != null && (obj = cell.getUserObjectValue("ITEM")) != null && obj instanceof ItemFormula;
    }

    public static boolean checkHasComment(Cell cell) {
        return cell != null && cell.getComment() != null;
    }

    public static boolean checkHasLinked(Cell cell) {
        return false;
    }

    public static boolean checkHasData(Cell cell) {
        if (cell == null) {
            return false;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null) {
            if (obj instanceof Map) {
                _tmpMap = (Map)obj;
                if (_tmpMap.isEmpty()) {
                    cell.removeUserObject("CELL_DATA");
                    return false;
                }
                return true;
            }
            cell.removeUserObject("CELL_DATA");
        }
        return false;
    }

    public static boolean checkHasCtrlData(Cell cell) {
        if (cell == null) {
            return false;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
        if (obj != null) {
            if (obj instanceof Map) {
                _tmpMap = (Map)obj;
                if (_tmpMap.isEmpty()) {
                    cell.removeUserObject("CELL_DATA_EXT");
                    return false;
                }
                return true;
            }
            cell.removeUserObject("CELL_DATA_EXT");
        }
        return false;
    }

    public static boolean checkHasFormulaOfCell(Cell cell) {
        if (cell == null) {
            return false;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String formulaStr = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            formulaStr = itemFormula.getFormula();
            return !StringUtils.isEmpty((String)formulaStr);
        }
        return false;
    }

    public static boolean checkHasFormula(Row row) {
        if (row == null) {
            return false;
        }
        Cell _cell = null;
        int colCount = row.getSheet().getMaxColIndex();
        for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
            _cell = row.getCell(colIndex, false);
            if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHasCertificate(Cell cell) {
        if (cell == null) {
            return false;
        }
        Object _obj = BgNFSHelper.getCellData(cell, "COURSE_CER");
        return _obj != null && BgNConstants.TRUE_STE.equals(_obj.toString());
    }

    public static boolean checkHasCause(Cell cell) {
        if (cell == null) {
            return false;
        }
        Object _obj = BgNFSHelper.getCellData(cell, "COURSE_CAUSE");
        return _obj != null && BgNConstants.TRUE_STE.equals(_obj.toString());
    }

    public static boolean checkHasEnumerateOfCell(Cell cell) {
        if (cell == null) {
            return false;
        }
        UserObject obj1 = cell.getUserObject("BeginCell");
        UserObject obj2 = cell.getUserObject("EndCell");
        UserObject obj3 = cell.getUserObject("CollBeginCell");
        UserObject obj4 = cell.getUserObject("CollEndCell");
        UserObject obj5 = cell.getUserObject("ItemBeginCell");
        UserObject obj6 = cell.getUserObject("ItemEndCell");
        UserObject obj7 = cell.getUserObject("Special_Begin_Cell");
        UserObject obj8 = cell.getUserObject("Special_End_Cell");
        UserObject obj9 = cell.getUserObject("ScriptBeginCell");
        UserObject obj10 = cell.getUserObject("ScriptEndCell");
        return obj1 != null || obj2 != null || obj3 != null || obj4 != null || obj5 != null || obj6 != null || obj7 != null || obj8 != null || obj9 != null || obj10 != null;
    }

    public static boolean checkHasEnumerateOfRow(Row row, int cols) {
        Cell cell = null;
        UserObject obj1 = null;
        UserObject obj2 = null;
        UserObject obj3 = null;
        UserObject obj4 = null;
        UserObject obj5 = null;
        UserObject obj6 = null;
        UserObject obj7 = null;
        UserObject obj8 = null;
        UserObject obj9 = null;
        UserObject obj10 = null;
        for (int i = 0; i <= cols; ++i) {
            cell = row.getCell(i, false);
            if (cell == null) continue;
            obj1 = cell.getUserObject("BeginCell");
            obj2 = cell.getUserObject("EndCell");
            obj3 = cell.getUserObject("CollBeginCell");
            obj4 = cell.getUserObject("CollEndCell");
            obj5 = cell.getUserObject("ItemBeginCell");
            obj6 = cell.getUserObject("ItemEndCell");
            obj7 = cell.getUserObject("Special_Begin_Cell");
            obj8 = cell.getUserObject("Special_End_Cell");
            obj9 = cell.getUserObject("ScriptBeginCell");
            obj10 = cell.getUserObject("ScriptEndCell");
            if (obj1 == null && obj2 == null && obj3 == null && obj4 == null && obj5 == null && obj6 == null && obj7 == null && obj8 == null && obj9 == null && obj10 == null) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHasNColOfCell(Cell cell) {
        if (cell == null) {
            return false;
        }
        UserObject obj7 = cell.getUserObject("NotRemoveCol");
        return obj7 != null;
    }

    public static boolean checkHasNRowOfCell(Cell cell) {
        if (cell == null) {
            return false;
        }
        UserObject obj7 = cell.getUserObject("NotRemoveRow");
        return obj7 != null;
    }

    public static boolean checkHasGatFormulaOfCell(Cell cell) {
        if (cell == null) {
            return false;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String formulaStr = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            formulaStr = itemFormula.getExt("GATHER_FORMULA");
            return !StringUtils.isEmpty((String)formulaStr);
        }
        return false;
    }

    public static void setGatFormulaOfCell(Cell cell, String formula) {
        BgNFSHelper.setGatFormulaOfCell(cell, formula, false);
    }

    public static void setGatFormulaOfCell(Cell cell, String formula, boolean isCreate) {
        if (cell == null || StringUtils.isEmpty((String)formula)) {
            return;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            itemFormula.putExt("GATHER_FORMULA", formula);
        } else if (isCreate) {
            itemFormula = new ItemFormula();
            itemFormula.putExt("GATHER_FORMULA", formula);
            cell.setUserObject("ITEM", (Object)itemFormula);
        }
    }

    public static String getFormulaOfCell(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String formulaStr = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            formulaStr = itemFormula.getFormula();
            return !StringUtils.isEmpty((String)formulaStr) ? formulaStr : null;
        }
        return null;
    }

    public static String getGatFormulaOfCell(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String formulaStr = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            formulaStr = itemFormula.getExt("GATHER_FORMULA");
            return !StringUtils.isEmpty((String)formulaStr) ? formulaStr : null;
        }
        return null;
    }

    public static String getDisplayFormula(String formulaStr, Map formulaMap) {
        if (StringUtils.isEmpty((String)formulaStr)) {
            return null;
        }
        String[] parameter = BgNFSHelper.parseFormulaPara(formulaMap, formulaStr);
        if (parameter != null) {
            StringBuffer _formulaStr = new StringBuffer();
            if (parameter.length == 6) {
                _formulaStr.append("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[5] + "\")");
                return _formulaStr.toString();
            }
            if (parameter.length == 4) {
                _formulaStr.append("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\")");
                return _formulaStr.toString();
            }
        }
        return formulaStr;
    }

    public static String getItemFormula(String[] formulaParam) {
        if (formulaParam == null || formulaParam.length != 6) {
            return null;
        }
        StringBuffer _formulaStr = new StringBuffer();
        _formulaStr.append("=BgItem(\"" + formulaParam[0] + "\",\"" + formulaParam[1] + "\",\"" + formulaParam[2] + "\",\"BgData\",true,\"" + formulaParam[5] + "\")");
        return _formulaStr.toString();
    }

    public static void setFormulaOfCell(Cell cell, String formulaStr, boolean isCreate) {
        if (cell == null || StringUtils.isEmpty((String)formulaStr)) {
            return;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            itemFormula.putExt("13", formulaStr);
        } else if (isCreate) {
            itemFormula = new ItemFormula(formulaStr);
            cell.setUserObject("ITEM", (Object)itemFormula);
        }
    }

    public static void setFormulaOfCell(Cell cell, String formulaStr) {
        BgNFSHelper.setFormulaOfCell(cell, formulaStr, false);
    }

    public static void clearFormulaOfCell(Cell cell) {
        if (cell != null) {
            cell.removeUserObject("ITEM");
        }
    }

    public static BigDecimal getBudgetValue(Cell cell) {
        if (cell == null) {
            return BgNConstants.ZERO;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String valueStr = null;
        BigDecimal value = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula && !StringUtils.isEmpty((String)(valueStr = (itemFormula = (ItemFormula)obj).getExt("BG_BUDGET_VALUE")))) {
            try {
                value = new BigDecimal(valueStr);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                value = BgNConstants.ZERO;
            }
            return value;
        }
        return BgNConstants.ZERO;
    }

    public static void setBudgetValue(Cell cell, BigDecimal value) {
        if (cell == null) {
            return;
        }
        Object obj = null;
        String valueStr = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            valueStr = value != null ? CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)value) : "0";
            itemFormula.putExt("BG_BUDGET_VALUE", valueStr);
        }
    }

    public static BigDecimal getActualValue(Cell cell) {
        if (cell == null) {
            return BgNConstants.ZERO;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String valueStr = null;
        BigDecimal value = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula && !StringUtils.isEmpty((String)(valueStr = (itemFormula = (ItemFormula)obj).getExt("BG_ACTUAL_VALUE")))) {
            try {
                value = new BigDecimal(valueStr);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                value = BgNConstants.ZERO;
            }
            return value;
        }
        return BgNConstants.ZERO;
    }

    public static void setActualValue(Cell cell, BigDecimal value) {
        if (cell == null) {
            return;
        }
        Object obj = null;
        String valueStr = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            valueStr = value != null ? CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)value) : "0";
            itemFormula.putExt("BG_ACTUAL_VALUE", valueStr);
        }
    }

    public static BigDecimal getAddValue(Cell cell) {
        if (cell == null) {
            return BgNConstants.ZERO;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String valueStr = null;
        BigDecimal value = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula && !StringUtils.isEmpty((String)(valueStr = (itemFormula = (ItemFormula)obj).getExt("BG_ACTUAL_ADD_VALUE")))) {
            try {
                value = new BigDecimal(valueStr);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                value = BgNConstants.ZERO;
            }
            return value;
        }
        return BgNConstants.ZERO;
    }

    public static String checkFormula(Map formulaMap, String formulaStr, IObjectValue model) throws BgFormException {
        if (StringUtils.isEmpty((String)formulaStr) || model == null || !(model instanceof BgFormInfo)) {
            return formulaStr;
        }
        boolean isBuilder = false;
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        String[] parameter = BgNFSHelper.parseFormulaPara(formulaMap, formulaStr);
        String bgFormPeriod = bgFormInfo.getBgPeriod().getNumber();
        int bgFormPeriodType = bgFormInfo.getBgPeriod().getPeriodType().getValue();
        if (parameter != null) {
            if (parameter.length == 6) {
                if (StringUtils.isEmpty((String)parameter[1])) {
                    parameter[1] = bgFormInfo.getBgPeriod().getNumber();
                    isBuilder = true;
                } else {
                    String newPeriod = BgPeriodNVariableHelper.getBgPeriodByN((String)bgFormPeriod, (String)parameter[1], (int)bgFormPeriodType);
                    if (!newPeriod.equals(parameter[1])) {
                        parameter[1] = newPeriod;
                        isBuilder = true;
                    } else if (Pattern.matches("\\-?\\d+", parameter[1])) {
                        parameter[1] = BgNPeriodHelper.getOffsetBgPeriodNumber(bgFormInfo.getBgPeriod().getNumber(), new Integer(parameter[1]));
                        isBuilder = true;
                    }
                }
                if (StringUtils.isEmpty((String)parameter[5])) {
                    parameter[5] = bgFormInfo.getCurrency().getNumber();
                    isBuilder = true;
                }
            } else if (parameter.length == 4) {
                isBuilder = true;
                if (StringUtils.isEmpty((String)parameter[1])) {
                    parameter[1] = bgFormInfo.getBgPeriod().getNumber();
                    isBuilder = true;
                } else {
                    String newPeriod = BgPeriodNVariableHelper.getBgPeriodByN((String)bgFormPeriod, (String)parameter[1], (int)bgFormPeriodType);
                    if (!newPeriod.equals(parameter[1])) {
                        parameter[1] = newPeriod;
                        isBuilder = true;
                    } else if (Pattern.matches("\\-?\\d+", parameter[1])) {
                        parameter[1] = BgNPeriodHelper.getOffsetBgPeriodNumber(bgFormInfo.getBgPeriod().getNumber(), new Integer(parameter[1]));
                        isBuilder = true;
                    }
                }
                if (StringUtils.isEmpty((String)parameter[3])) {
                    parameter[3] = bgFormInfo.getCurrency().getNumber();
                    isBuilder = true;
                }
            } else {
                return null;
            }
        }
        if (isBuilder) {
            if (formulaMap != null) {
                formulaMap.remove(formulaStr);
            }
            if (parameter.length == 6) {
                formulaStr = new StringBuffer("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\"," + parameter[4] + ",\"" + parameter[5] + "\")").toString();
            } else if (parameter.length == 4) {
                formulaStr = new StringBuffer("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + "BgData\",true,\"" + parameter[3] + "\")").toString();
            }
            BgNFSHelper.parseFormulaPara(formulaMap, formulaStr);
        }
        return formulaStr;
    }

    public static String[] parseFormulaPara(Map formulaMap, String formulaStr) {
        if (StringUtils.isEmpty((String)formulaStr)) {
            return null;
        }
        Expression expression = null;
        FunctionExpr expr = null;
        List parameterList = null;
        String[] parameter = null;
        if (formulaMap != null && formulaMap.containsKey(formulaStr)) {
            parameter = (String[])formulaMap.get(formulaStr);
        } else {
            try {
                expression = ExcelFormulaPaserHelper.parse((String)formulaStr);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            if (expression != null && expression instanceof FunctionExpr) {
                expr = (FunctionExpr)expression;
                parameterList = expr.parameters;
                int parameterSize = parameterList.size();
                parameter = new String[parameterSize];
                for (int i = 0; i < parameterSize; ++i) {
                    if (parameterList.get(i) != null) {
                        if (parameterList.get(i) instanceof StringExpr) {
                            parameter[i] = ((StringExpr)parameterList.get((int)i)).value;
                            continue;
                        }
                        if (parameterList.get(i) instanceof BoolExpr) {
                            parameter[i] = String.valueOf(((BoolExpr)parameterList.get((int)i)).value).toLowerCase();
                            continue;
                        }
                        parameter[i] = "";
                        continue;
                    }
                    parameter[i] = "";
                }
                parameterList.clear();
                if (formulaMap != null) {
                    formulaMap.put(formulaStr, parameter);
                }
            } else {
                parameter = new String[6];
            }
        }
        return parameter;
    }

    public static String getFormulaFromParam(String[] parameter) {
        if (parameter == null) {
            return null;
        }
        String formulaStr = null;
        if (parameter.length == 6) {
            formulaStr = new StringBuffer("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\"," + parameter[4] + ",\"" + parameter[5] + "\")").toString();
        } else if (parameter.length == 4) {
            formulaStr = new StringBuffer("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + "BgData\",true,\"" + parameter[3] + "\")").toString();
        }
        return formulaStr;
    }

    public static String[] parseFormulaPara(String formulaStr) {
        return BgNFSHelper.parseFormulaPara(null, formulaStr);
    }

    public static void setFormulaEditOfEnable(Cell cell) {
        BgNFSHelper.setFormulaEditOfCell(cell, true);
    }

    public static void setFormulaEditOfDisable(Cell cell) {
        BgNFSHelper.setFormulaEditOfCell(cell, false);
    }

    public static void setFormulaEditOfCell(Cell cell, boolean editable) {
        if (cell == null) {
            return;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            if (editable) {
                itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.TRUE_UPDATE);
            } else {
                itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.FALSE_UPDATE);
            }
        }
    }

    public static void setFormulaSourceTemplateOfCell(Cell cell, boolean source) {
        if (cell == null) {
            return;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            if (source) {
                itemFormula.putExt("BGFORMULA_SOURCETEMPLATE", BgNConstants.TRUE_UPDATE);
            } else {
                itemFormula.putExt("BGFORMULA_SOURCETEMPLATE", BgNConstants.FALSE_UPDATE);
            }
        }
    }

    public static boolean checkFormulaSourceTemplateOfCell(Cell cell) {
        if (cell == null) {
            return false;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            if (itemFormula.getExt("BGFORMULA_SOURCETEMPLATE") == null) {
                return false;
            }
            if (itemFormula.getExt("BGFORMULA_CANUPDATE").equals(BgNConstants.FALSE_UPDATE)) {
                return false;
            }
            if (itemFormula.getExt("BGFORMULA_CANUPDATE").equals(BgNConstants.TRUE_UPDATE)) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkCanEditFormulaOfCell(Cell cell) {
        if (cell == null) {
            return true;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            if (itemFormula.getExt("BGFORMULA_CANUPDATE") == null) {
                itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.TRUE_UPDATE);
                return true;
            }
            if (itemFormula.getExt("BGFORMULA_CANUPDATE").equals(BgNConstants.FALSE_UPDATE)) {
                return false;
            }
            if (itemFormula.getExt("BGFORMULA_CANUPDATE").equals(BgNConstants.TRUE_UPDATE)) {
                return true;
            }
        }
        return true;
    }

    public static void setEditFormulaOfCell(Cell cell, boolean canEdit) {
        if (cell != null) {
            Object obj = null;
            ItemFormula itemFormula = null;
            obj = cell.getUserObjectValue("ITEM");
            if (obj != null && obj instanceof ItemFormula) {
                itemFormula = (ItemFormula)obj;
                if (canEdit) {
                    itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.TRUE_UPDATE);
                } else {
                    itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.FALSE_UPDATE);
                }
            }
        }
    }

    public static void checkExpressions(Cell cell, IObjectValue model, int VIEW_MODE, String companyNumber) {
        if (cell == null || model == null || !(model instanceof BgFormInfo)) {
            return;
        }
        Object obj = null;
        Map _tmpMap = null;
        String expressions = null;
        obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            if (StringUtils.isEmpty(expressions)) {
                switch (VIEW_MODE) {
                    case 0: {
                        if (!_tmpMap.containsKey("BG_BUDGET_EXPRESSIONS")) break;
                        expressions = (String)_tmpMap.get("BG_BUDGET_EXPRESSIONS");
                        break;
                    }
                    case 1: {
                        if (!_tmpMap.containsKey("BG_ACTUAL_EXPRESSIONS")) break;
                        expressions = (String)_tmpMap.get("BG_ACTUAL_EXPRESSIONS");
                        break;
                    }
                    case 2: {
                        if (!_tmpMap.containsKey("BG_ADD_EXPRESSIONS")) break;
                        expressions = (String)_tmpMap.get("BG_ADD_EXPRESSIONS");
                        break;
                    }
                }
            }
            if (!StringUtils.isEmpty(expressions)) {
                if (!StringUtils.isEmpty((String)(expressions = BgNFSHelper.checkExpression(cell, expressions, model, companyNumber)))) {
                    switch (VIEW_MODE) {
                        case 0: {
                            _tmpMap.put("BG_BUDGET_EXPRESSIONS", expressions);
                            break;
                        }
                        case 1: {
                            _tmpMap.put("BG_ACTUAL_EXPRESSIONS", expressions);
                            break;
                        }
                        case 2: {
                            _tmpMap.put("BG_ADD_EXPRESSIONS", expressions);
                            break;
                        }
                    }
                    BgNFSHelper.setExpression(cell, expressions);
                }
            } else {
                BgNFSHelper.clearExpression(cell);
            }
        }
    }

    public static void checkExpression(Cell cell, IObjectValue model, String companyNumber) {
        String _expression;
        if (cell == null || model == null || !(model instanceof BgFormInfo)) {
            return;
        }
        String expression = BgNFSHelper.getExpression(cell);
        if (!StringUtils.isEmpty((String)expression) && (_expression = BgNFSHelper.checkExpression(cell, expression, model, companyNumber)) != null && !expression.equalsIgnoreCase(_expression.replaceAll(" ", ""))) {
            cell.setFormula(_expression);
            cell.setValue(cell.getValue());
        }
    }

    public static String checkExpression(Cell cell, String expression, IObjectValue model, String companyNumber) {
        return BgNExpressionHelper.checkExpression(cell, expression, model, null, companyNumber);
    }

    public static boolean checkHasExpression(Cell cell) {
        return cell != null && cell.hasFormula();
    }

    public static boolean checkHasExpression(Cell cell, int VIEW_MODE) {
        if (cell == null) {
            return false;
        }
        Object obj = null;
        Map _tmpMap = null;
        String _expression = null;
        obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            switch (VIEW_MODE) {
                case 0: {
                    if (!_tmpMap.containsKey("BG_BUDGET_EXPRESSIONS")) break;
                    _expression = (String)_tmpMap.get("BG_BUDGET_EXPRESSIONS");
                    break;
                }
                case 1: {
                    if (!_tmpMap.containsKey("BG_ACTUAL_EXPRESSIONS")) break;
                    _expression = (String)_tmpMap.get("BG_ACTUAL_EXPRESSIONS");
                    break;
                }
                case 2: {
                    if (!_tmpMap.containsKey("BG_ADD_EXPRESSIONS")) break;
                    _expression = (String)_tmpMap.get("BG_ADD_EXPRESSIONS");
                    break;
                }
            }
        }
        return !StringUtils.isEmpty(_expression);
    }

    public static boolean checkIsExpression(String text) {
        return !StringUtils.isEmpty((String)text) && text.indexOf("=") == 0;
    }

    public static String getExpression(Cell cell) {
        return cell != null ? cell.getFormula() : null;
    }

    public static void setExpressions(Cell cell, int VIEW_MODE) {
        if (cell == null) {
            return;
        }
        Object obj = null;
        Map _tmpMap = null;
        String expressions = null;
        obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            switch (VIEW_MODE) {
                case 0: {
                    if (!_tmpMap.containsKey("BG_BUDGET_EXPRESSIONS")) break;
                    expressions = (String)_tmpMap.get("BG_BUDGET_EXPRESSIONS");
                    break;
                }
                case 1: {
                    if (!_tmpMap.containsKey("BG_ACTUAL_EXPRESSIONS")) break;
                    expressions = (String)_tmpMap.get("BG_ACTUAL_EXPRESSIONS");
                    break;
                }
                case 2: {
                    if (!_tmpMap.containsKey("BG_ADD_EXPRESSIONS")) break;
                    expressions = (String)_tmpMap.get("BG_ADD_EXPRESSIONS");
                    break;
                }
            }
            if (!StringUtils.isEmpty(expressions)) {
                BgNFSHelper.setExpression(cell, expressions);
            } else {
                BgNFSHelper.clearExpression(cell);
            }
        }
    }

    public static void setExpression(Cell cell, String expression) {
        if (cell != null) {
            cell.setFormula(expression);
            cell.setValue(cell.getValue());
        }
    }

    public static void clearExpression(Cell cell) {
        if (cell != null && cell.hasFormula()) {
            cell.setFormula(null);
        }
    }

    public static void clearExpression(Cell cell, int VIEW_MODE) {
        if (cell == null) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            switch (VIEW_MODE) {
                case 0: {
                    _tmpMap.remove("BG_BUDGET_EXPRESSIONS");
                    break;
                }
                case 1: {
                    _tmpMap.remove("BG_ACTUAL_EXPRESSIONS");
                    break;
                }
                case 2: {
                    _tmpMap.remove("BG_ADD_EXPRESSIONS");
                    break;
                }
            }
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static String loadExpression(Cell cell, int VIEW_MODE) {
        if (cell == null) {
            return null;
        }
        String _expression = null;
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            switch (VIEW_MODE) {
                case 0: {
                    if (!_tmpMap.containsKey("BG_BUDGET_EXPRESSIONS")) break;
                    _expression = (String)_tmpMap.get("BG_BUDGET_EXPRESSIONS");
                    break;
                }
                case 1: {
                    if (!_tmpMap.containsKey("BG_ACTUAL_EXPRESSIONS")) break;
                    _expression = (String)_tmpMap.get("BG_ACTUAL_EXPRESSIONS");
                    break;
                }
                case 2: {
                    if (!_tmpMap.containsKey("BG_ADD_EXPRESSIONS")) break;
                    _expression = (String)_tmpMap.get("BG_ADD_EXPRESSIONS");
                    break;
                }
            }
        }
        return _expression;
    }

    public static void saveExpression(Cell cell, String expression, int VIEW_MODE) {
        if (cell == null) {
            return;
        }
        Map<String, String> _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
        } else {
            _tmpMap = new HashMap();
            cell.setUserObject("CELL_DATA", _tmpMap);
        }
        switch (VIEW_MODE) {
            case 0: {
                if (!StringUtils.isEmpty((String)expression)) {
                    _tmpMap.put("BG_BUDGET_EXPRESSIONS", expression);
                    break;
                }
                _tmpMap.remove("BG_BUDGET_EXPRESSIONS");
                break;
            }
            case 1: {
                if (!StringUtils.isEmpty((String)expression)) {
                    _tmpMap.put("BG_ACTUAL_EXPRESSIONS", expression);
                    break;
                }
                _tmpMap.remove("BG_ACTUAL_EXPRESSIONS");
                break;
            }
            case 2: {
                if (!StringUtils.isEmpty((String)expression)) {
                    _tmpMap.put("BG_ADD_EXPRESSIONS", expression);
                    break;
                }
                _tmpMap.remove("BG_ADD_EXPRESSIONS");
                break;
            }
        }
        if (_tmpMap.isEmpty()) {
            cell.removeUserObject("CELL_DATA");
        }
    }

    public static void setLockOfCell(Cell cell, RangeManager manager, boolean isLocked) {
        if (cell == null || manager == null) {
            return;
        }
        Range r = manager.getRange(cell.getRow(), cell.getCol());
        if (r != null) {
            r.setCellLocked(isLocked);
        }
    }

    public static void setLockOfCell(Cell cell, boolean isLocked) {
        BgNFSHelper.setCellLocked(cell, isLocked);
    }

    public static boolean isLockOfCell(Cell cell) {
        if (cell == null) {
            return false;
        }
        return cell.isLocked();
    }

    public static void setLockOfSheet(Sheet sheet, boolean isLocked) {
        if (sheet == null) {
            return;
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(isLocked);
        sheet.getSheetRange().setStyle(sa, Styles.getEmptySA());
    }

    public static void setLockOfBook(Book book, boolean isLocked) {
        if (book == null) {
            return;
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(isLocked);
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            book.getSheet(i).getSheetRange().setStyle(sa, Styles.getEmptySA());
        }
    }

    public static boolean checkHasBudget(IObjectValue model) {
        if (model == null) {
            return false;
        }
        Object obj = model.get("BGFORMINFO_TYPE");
        if (obj != null && obj instanceof String) {
            String _tmpStr = (String)obj;
            return _tmpStr.equals("BGFORM_BUDGET");
        }
        return false;
    }

    public static void setBudget(IObjectValue model) {
        if (model != null) {
            model.put("BGFORMINFO_TYPE", (Object)"BGFORM_BUDGET");
        }
    }

    public static boolean checkHasActual(IObjectValue model) {
        if (model == null) {
            return false;
        }
        Object obj = model.get("BGFORMINFO_TYPE");
        if (obj != null && obj instanceof String) {
            String _tmpStr = (String)obj;
            return _tmpStr.equals("BGFORM_ACTUAL");
        }
        return false;
    }

    public static void setActual(IObjectValue model) {
        if (model != null) {
            model.put("BGFORMINFO_TYPE", (Object)"BGFORM_ACTUAL");
        }
    }

    public static void clearTypeSign(IObjectValue model) {
        if (model != null) {
            model.remove("BGFORMINFO_TYPE");
        }
    }

    public static boolean checkHasAdjust(BOSUuid bgFormId) throws Exception {
        return BgNFSHelper.checkHasAdjust(null, bgFormId);
    }

    public static boolean checkHasAdjust(Context ctx, BOSUuid bgFormId) throws Exception {
        if (bgFormId == null) {
            return false;
        }
        IBgForm iBgForm = null;
        iBgForm = ctx == null ? BgFormFactory.getRemoteInstance() : BgFormFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        BgFormInfo bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), sic);
        if (bgFormInfo != null) {
            return BgNFSHelper.checkHasAdjust((IObjectValue)bgFormInfo);
        }
        return false;
    }

    public static boolean checkHasAdjust(IObjectValue model) {
        if (model == null) {
            return false;
        }
        BgFormInfo info = (BgFormInfo)model;
        return info.getState().getValue() == 4 || info.getState().getValue() == 35 || info.getState().getValue() == 6;
    }

    public static boolean checkHasRollEdit(IObjectValue model) {
        if (model == null) {
            return false;
        }
        BgFormInfo info = (BgFormInfo)model;
        return info.getState().getValue() == 6;
    }

    public static boolean checkHasDivData(IObjectValue model) {
        return model != null && model.get("SIGN_DIV_DATA") != null && model.get("SIGN_DIV_DATA") instanceof Map;
    }

    public static Object getDivData(IObjectValue model) {
        if (model != null && model.get("SIGN_DIV_DATA") != null && model.get("SIGN_DIV_DATA") instanceof Map) {
            Object obj = model.get("SIGN_DIV_DATA");
            model.remove("SIGN_DIV_DATA");
            return obj;
        }
        return new HashMap();
    }

    public static ItemFormula getItemFormula(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            return (ItemFormula)obj;
        }
        return null;
    }

    public static void removeItemFormula(Cell cell) {
        if (cell == null) {
            return;
        }
        cell.removeUserObject("ITEM");
    }

    public static void setItemFormula(Cell cell, ItemFormula itemFormula) {
        if (cell != null && itemFormula != null) {
            cell.setUserObject("ITEM", (Object)itemFormula);
        }
    }

    public static String getExtValue(ItemFormula itemFormula, String key) {
        if (itemFormula != null && !StringUtils.isEmpty((String)key)) {
            return itemFormula.getExt(key);
        }
        return null;
    }

    public static String getExtValue(Cell cell, String key) {
        if (cell == null || StringUtils.isEmpty((String)key)) {
            return null;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            return itemFormula.getExt(key);
        }
        return null;
    }

    public static String getIsCtrl(Cell cell) {
        return BgNFSHelper.getExtValue(cell, "isCtrl");
    }

    public static String getIsFlexCtrl(Cell cell) {
        return BgNFSHelper.getExtValue(cell, "isFlexCtrl");
    }

    public static String getFlexCtrlPara(Cell cell) {
        return BgNFSHelper.getExtValue(cell, "flexCtrlParam");
    }

    public static String getPeriodCtrlPolicy(Cell cell) {
        return BgNFSHelper.getExtValue(cell, "periodCtrlPolicy");
    }

    public static String getIsGroupCtrl(Cell cell) {
        return BgNFSHelper.getExtValue(cell, "isGroupCtrl");
    }

    public static String getGroupCtrlNo(Cell cell) {
        return BgNFSHelper.getExtValue(cell, "groupCtrlNo");
    }

    public static String getIsAllowAccess(Cell cell) {
        return BgNFSHelper.getExtValue(cell, "isAllowAccess");
    }

    public static String getIsCtrl(ItemFormula itemFormula) {
        return BgNFSHelper.getExtValue(itemFormula, "isCtrl");
    }

    public static String getIsFlexCtrl(ItemFormula itemFormula) {
        return BgNFSHelper.getExtValue(itemFormula, "isFlexCtrl");
    }

    public static String getFlexCtrlPara(ItemFormula itemFormula) {
        return BgNFSHelper.getExtValue(itemFormula, "flexCtrlParam");
    }

    public static String getPeriodCtrlPolicy(ItemFormula itemFormula) {
        return BgNFSHelper.getExtValue(itemFormula, "periodCtrlPolicy");
    }

    public static String getIsGroupCtrl(ItemFormula itemFormula) {
        return BgNFSHelper.getExtValue(itemFormula, "isGroupCtrl");
    }

    public static String getGroupCtrlNo(ItemFormula itemFormula) {
        return BgNFSHelper.getExtValue(itemFormula, "groupCtrlNo");
    }

    public static String getIsAllowAccess(ItemFormula itemFormula) {
        return BgNFSHelper.getExtValue(itemFormula, "isAllowAccess");
    }

    public static void setIsCtrl(Cell cell, String isCtrl, boolean isCanUndo) {
        BgNTemplateHelper.setItemFormulaUserObject(cell, "isCtrl", isCtrl, isCanUndo);
    }

    public static void setIsAllowAccess(Cell cell, String isAllowAccess, boolean isCanUndo) {
        BgNTemplateHelper.setItemFormulaUserObject(cell, "isAllowAccess", isAllowAccess, isCanUndo);
    }

    public static void setIsFlexCtrl(Cell cell, String flexCtrl, boolean isCanUndo) {
        BgNTemplateHelper.setItemFormulaUserObject(cell, "isFlexCtrl", flexCtrl, isCanUndo);
    }

    public static void setFlexCtrlPara(Cell cell, String flexCtrlPara, boolean isCanUndo) {
        BgNTemplateHelper.setItemFormulaUserObject(cell, "flexCtrlParam", flexCtrlPara, isCanUndo);
    }

    public static void setPeriodCtrlPolicy(Cell cell, String periodCtrlPolicy, boolean isCanUndo) {
        BgNTemplateHelper.setItemFormulaUserObject(cell, "periodCtrlPolicy", periodCtrlPolicy, isCanUndo);
    }

    public static void setIsGroupCtrl(Cell cell, String isGroupCtrl, boolean isCanUndo) {
        BgNTemplateHelper.setItemFormulaUserObject(cell, "isGroupCtrl", isGroupCtrl, isCanUndo);
    }

    public static void setGroupCtrlNo(Cell cell, String groupCtrlNo, boolean isCanUndo) {
        BgNTemplateHelper.setItemFormulaUserObject(cell, "groupCtrlNo", groupCtrlNo, isCanUndo);
    }

    public static boolean checkHasBgItemInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return false;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType")) {
            obj = _tmpMap.get("bgFillType");
            return "bgFillValueType_item".equals(obj);
        }
        return false;
    }

    public static String[] getBgItemInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return null;
        }
        String[] _tmpInfo = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType") && "bgFillValueType_item".equals(obj = _tmpMap.get("bgFillType"))) {
            _tmpInfo = new String[3];
            obj = _tmpMap.get("bgFillType");
            _tmpInfo[0] = obj != null ? (String)obj : null;
            obj = _tmpMap.get("bgFillValue");
            _tmpInfo[1] = obj != null ? (String)obj : null;
            obj = _tmpMap.get("bgFillValue_itemId");
            _tmpInfo[2] = obj != null ? (String)obj : null;
        }
        return _tmpInfo;
    }

    public static void removeBgItemInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType") && "bgFillValueType_item".equals(obj = _tmpMap.get("bgFillType"))) {
            _tmpMap.remove("bgFillType");
            _tmpMap.remove("bgFillValue");
            _tmpMap.remove("bgFillValue_itemId");
            cell.setUserObject("CELL_DATA", (Object)_tmpMap);
            BgNFSHelper.setValue(cell, null);
        }
    }

    public static void setBgItemInfo(Cell cell, String bgItemNumber, String bgItemId) {
        if (cell == null || StringUtils.isEmpty((String)bgItemNumber)) {
            return;
        }
        Map<String, String> _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
        } else {
            _tmpMap = new HashMap();
            cell.setUserObject("CELL_DATA", _tmpMap);
        }
        if (_tmpMap != null) {
            _tmpMap.put("bgFillType", "bgFillValueType_item");
            _tmpMap.put("bgFillValue", bgItemNumber);
            _tmpMap.put("bgFillValue_itemId", bgItemId);
        }
    }

    public static void clearBgItemInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            if (_tmpMap.containsKey("bgFillType") && "bgFillValueType_item".equals(obj = _tmpMap.get("bgFillType"))) {
                _tmpMap.remove("bgFillType");
                _tmpMap.remove("bgFillValue");
                _tmpMap.remove("bgFillValue_itemId");
            }
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static boolean checkHasBgElementInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return false;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType")) {
            obj = _tmpMap.get("bgFillType");
            return "bgFillValueType_element".equals(obj);
        }
        return false;
    }

    public static String[] getBgElementInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return null;
        }
        String[] _tmpInfo = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType") && "bgFillValueType_element".equals(obj = _tmpMap.get("bgFillType"))) {
            _tmpInfo = new String[3];
            obj = _tmpMap.get("bgFillType");
            _tmpInfo[0] = obj != null ? (String)obj : null;
            obj = _tmpMap.get("bgFillValue");
            _tmpInfo[1] = obj != null ? (String)obj : null;
            obj = _tmpMap.get("isAttachFormula");
            _tmpInfo[2] = obj != null ? (String)obj : null;
        }
        return _tmpInfo;
    }

    public static void setBgElementInfo(Cell cell, String bgElementNum, String isAutoCreateFormula) {
        if (cell == null || StringUtils.isEmpty((String)bgElementNum)) {
            return;
        }
        Map<String, String> _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
        } else {
            _tmpMap = new HashMap();
            cell.setUserObject("CELL_DATA", _tmpMap);
        }
        if (_tmpMap != null) {
            _tmpMap.put("bgFillType", "bgFillValueType_element");
            _tmpMap.put("bgFillValue", bgElementNum);
            _tmpMap.put("isAttachFormula", isAutoCreateFormula);
        }
    }

    public static void clearBgElementInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            if (_tmpMap.containsKey("bgFillType") && "bgFillValueType_element".equals(obj = _tmpMap.get("bgFillType"))) {
                _tmpMap.remove("bgFillType");
                _tmpMap.remove("bgFillValue");
                _tmpMap.remove("isAttachFormula");
            }
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static boolean checkHasBgPeriodInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return false;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType")) {
            obj = _tmpMap.get("bgFillType");
            return "bgFillValueType_period".equals(obj);
        }
        return false;
    }

    public static String[] getBgPeriodInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return null;
        }
        String[] _tmpInfo = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType") && "bgFillValueType_period".equals(obj = _tmpMap.get("bgFillType"))) {
            _tmpInfo = new String[2];
            obj = _tmpMap.get("bgFillType");
            _tmpInfo[0] = obj != null ? (String)obj : null;
            obj = _tmpMap.get("bgFillValue");
            _tmpInfo[1] = obj != null ? (String)obj : null;
        }
        return _tmpInfo;
    }

    public static void setBgPeriodInfo(Cell cell, String bgPeriodNum) {
        if (cell == null || StringUtils.isEmpty((String)bgPeriodNum)) {
            return;
        }
        Map<String, String> _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
        } else {
            _tmpMap = new HashMap();
            cell.setUserObject("CELL_DATA", _tmpMap);
        }
        if (_tmpMap != null) {
            _tmpMap.put("bgFillType", "bgFillValueType_period");
            _tmpMap.put("bgFillValue", bgPeriodNum);
        }
    }

    public static void clearBgPeriodInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            if ("bgFillValueType_period".equals(obj = _tmpMap.get("bgFillType"))) {
                _tmpMap.remove("bgFillType");
                _tmpMap.remove("bgFillValue");
            }
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static boolean checkHasCurrencyInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return false;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType")) {
            obj = _tmpMap.get("bgFillType");
            return "bgFillValueType_currency".equals(obj);
        }
        return false;
    }

    public static String[] getCurrencyInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return null;
        }
        String[] _tmpInfo = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType") && "bgFillValueType_currency".equals(obj = _tmpMap.get("bgFillType"))) {
            _tmpInfo = new String[2];
            obj = _tmpMap.get("bgFillType");
            _tmpInfo[0] = obj != null ? (String)obj : null;
            obj = _tmpMap.get("bgFillValue");
            _tmpInfo[1] = obj != null ? (String)obj : null;
        }
        return _tmpInfo;
    }

    public static void setCurrencyInfo(Cell cell, String currencyNum) {
        if (cell == null || StringUtils.isEmpty((String)currencyNum)) {
            return;
        }
        Map<String, String> _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
        } else {
            _tmpMap = new HashMap();
            cell.setUserObject("CELL_DATA", _tmpMap);
        }
        if (_tmpMap != null) {
            _tmpMap.put("bgFillType", "bgFillValueType_currency");
            _tmpMap.put("bgFillValue", currencyNum);
        }
    }

    public static void clearCurrencyInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            if (_tmpMap.containsKey("bgFillType") && "bgFillValueType_currency".equals(obj = _tmpMap.get("bgFillType"))) {
                _tmpMap.remove("bgFillType");
                _tmpMap.remove("bgFillValue");
            }
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static boolean checkHasOverstepMax(BigDecimal value) {
        return value != null && value.compareTo(GlUtils.maxBigDecimal) > 0;
    }

    public static boolean checkHasOverstepMin(BigDecimal value) {
        return value != null && value.compareTo(GlUtils.minBigDecimal) < 0;
    }

    public static Map getMeasureUnitMap(BgFormInfo model) {
        if (model == null) {
            return new HashMap();
        }
        if (model.getBgMeasureUnit() != null && !model.getBgMeasureUnit().isEmpty()) {
            HashMap<String, BigDecimal> measureUnit = new HashMap<String, BigDecimal>();
            BgMeasureUnitInfo muInfo2 = null;
            BgMeasureUnitCollection muCol = model.getBgMeasureUnit();
            for (BgMeasureUnitInfo muInfo2 : muCol) {
                measureUnit.put(muInfo2.getBgElement().getNumber(), muInfo2.getMeasureUnit().getCoefficient());
            }
            return measureUnit;
        }
        return new HashMap();
    }

    public static Map getMeasureUnitMap(BgTemplateInfo model) {
        if (model == null) {
            return new HashMap();
        }
        if (model.getBgMeasureUnit() != null && !model.getBgMeasureUnit().isEmpty()) {
            HashMap<String, BigDecimal> measureUnit = new HashMap<String, BigDecimal>();
            BgTemMeasureUnitInfo muInfo2 = null;
            BgTemMeasureUnitCollection muCol = model.getBgMeasureUnit();
            for (BgTemMeasureUnitInfo muInfo2 : muCol) {
                measureUnit.put(muInfo2.getBgElement().getNumber(), muInfo2.getMeasureUnit().getCoefficient());
            }
            return measureUnit;
        }
        return new HashMap();
    }

    public static Object getValue(Cell cell) {
        return cell != null && cell.getValue() != Variant.nullVariant ? cell.getValue().getValue() : null;
    }

    public static void setValue(Cell cell, Object value) {
        if (cell != null) {
            if (value != null) {
                cell.setValue(new Variant(value));
            } else {
                cell.setValue(Variant.nullVariant);
            }
        }
    }

    public static boolean checkHasTextOfCell(Sheet sheet, int rowIndex, int colIndex) {
        try {
            if (sheet != null) {
                StyleAttributes sa = Styles.getEmptySA();
                sheet.getRange(rowIndex, colIndex).getStyle(sa, sa);
                return BgNFSHelper.checkHasTextOfCell(sa.getNumberFormat());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkHasTextOfCell(String numberFormat) {
        return !StringUtils.isEmpty((String)numberFormat) && "@".equals(numberFormat);
    }

    public static boolean checkHasTextOfCell(Cell cell) {
        String _numberFormat;
        return cell != null && cell.getStyle() != null && !StringUtils.isEmpty((String)(_numberFormat = cell.getStyle().getNumberFormat())) && "@".equals(_numberFormat);
    }

    public static boolean checkHasPercentage(Sheet sheet, int rowIndex, int colIndex) {
        if (sheet != null) {
            StyleAttributes sa = Styles.getEmptySA();
            sheet.getRange(rowIndex, colIndex).getStyle(sa, sa);
            try {
                return BgNFSHelper.checkHasPercentage(sa.getNumberFormat());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean checkHasPercentage(String numberFormat) {
        return !StringUtils.isEmpty((String)numberFormat) && (numberFormat.endsWith("%") || numberFormat.endsWith("%)"));
    }

    public static boolean checkHasPercentage(Cell cell) {
        String _numberFormat;
        return cell != null && cell.getStyle() != null && !StringUtils.isEmpty((String)(_numberFormat = cell.getStyle().getNumberFormat())) && "%".equals(_numberFormat.substring(_numberFormat.length() - 1));
    }

    public static boolean checkIsNumericOfCell(Cell cell) {
        return cell != null && cell.getValue() != null && cell.getValue() != Variant.nullVariant && cell.getValue().getValue() != null && (cell.getValue().isNumber() || cell.getValue().isNumeric());
    }

    public static boolean checkHasNumbericOfCell(Cell cell) {
        String _numberFormat;
        if (cell != null && cell.getStyle() != null && (StringUtils.isEmpty((String)(_numberFormat = cell.getStyle().getNumberFormat())) || _numberFormat.equals(BgNConstants.routineStr) || _numberFormat.indexOf("0") >= 0)) {
            return _numberFormat.indexOf("%") < 0 && _numberFormat.indexOf("\uffe5") < 0;
        }
        return false;
    }

    public static String checkShowStrByNumberic(Cell cell) {
        if (cell == null || cell.getStyle() == null || StringUtils.isEmpty((String)cell.getStyle().getNumberFormat())) {
            return null;
        }
        String numberFormat = cell.getStyle().getNumberFormat();
        String[] split = numberFormat.split(";");
        if (split != null && split.length == 3 && Pattern.matches("(#|,)*\\d+.\\d+(;|-|\\[Red\\]|\\()*(#|,)*\\d+.\\d+(\\))*", split[0] + ";" + split[1])) {
            return split[2].replaceAll("\"", "");
        }
        return null;
    }

    public static int getDigitOfNumber(Cell cell, int digit) {
        if (cell == null || cell.getStyle() == null || cell.getStyle().getNumberFormat() == null) {
            return digit;
        }
        String numberFormat = cell.getStyle().getNumberFormat();
        if (numberFormat.indexOf("0") >= 0) {
            String tmpString = null;
            if (numberFormat.trim().indexOf(";") >= 0) {
                Pattern p = Pattern.compile(";");
                String[] str = p.split(numberFormat.trim());
                tmpString = str[0];
                if (tmpString != null && tmpString.indexOf(".") >= 0) {
                    Pattern p1 = Pattern.compile("\\.");
                    String[] str1 = p1.split(tmpString);
                    if (str1[1] != null && str1[1].length() > 0) {
                        digit = str1[1].length();
                    }
                } else {
                    digit = 0;
                }
            } else if (numberFormat != null && numberFormat.indexOf(".") >= 0) {
                Pattern p = Pattern.compile("\\.");
                String[] str = p.split(numberFormat);
                if (str[1] != null && str[1].length() > 0) {
                    digit = 0;
                    int n = str[1].length();
                    for (int i = 0; i < n; ++i) {
                        tmpString = str[1].substring(i, i + 1);
                        if (!tmpString.equals("0")) continue;
                        ++digit;
                    }
                } else {
                    digit = 0;
                }
            } else {
                digit = 0;
            }
        }
        return digit;
    }

    public static String getNumberFormat(String str, int number) {
        if (str == null || number <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static boolean checkIsNumeric(Object obj) {
        if (obj != null) {
            try {
                new BigDecimal(obj.toString().trim().replaceAll(",", ""));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static Row addRow(Sheet sheet, int rowIndex) {
        if (sheet == null || rowIndex < 0) {
            return null;
        }
        Range range = sheet.getRowRange(rowIndex, rowIndex);
        range.setIgnoreProtected(true);
        range.insert(true);
        Row row = sheet.getRow(rowIndex, true);
        int maxColIndex = row.size();
        for (int i = 0; i < maxColIndex; ++i) {
            BgNTemplateHelper.clearAll(row.getAt(i), false);
        }
        return row;
    }

    public static Row addRow(Sheet sheet, int rowIndex, boolean hasStyle) {
        if (sheet == null || rowIndex < 0) {
            return null;
        }
        Range range = sheet.getRowRange(rowIndex, rowIndex);
        range.setIgnoreProtected(true);
        if (hasStyle) {
            range.insert(true);
        } else {
            range.insert(true, InsertType.NOSTYLE);
        }
        Row row = sheet.getRow(rowIndex, true);
        int maxColIndex = row.size();
        for (int i = 0; i < maxColIndex; ++i) {
            BgNTemplateHelper.clearAll(row.getAt(i), false);
        }
        return row;
    }

    public static void addRows(Sheet sheet, int rowIndex, int rowCont) {
        if (sheet == null || rowIndex < 0) {
            return;
        }
        Range range = sheet.getRowRange(rowIndex, rowIndex + rowCont);
        range.setIgnoreProtected(true);
        range.insert(true);
    }

    public static void addRows(Sheet sheet, int rowIndex, int rowCont, boolean hasStyle) {
        if (sheet == null || rowIndex < 0) {
            return;
        }
        Range range = sheet.getRowRange(rowIndex, rowIndex + rowCont);
        range.setIgnoreProtected(true);
        if (hasStyle) {
            range.insert(true);
        } else {
            range.insert();
        }
    }

    public static boolean removeRow(Sheet sheet, int rowIndex) {
        if (sheet == null || rowIndex < 0 || rowIndex > sheet.getMaxRowIndex()) {
            return false;
        }
        Range range = sheet.getRowRange(rowIndex, rowIndex);
        range.setIgnoreProtected(true);
        return range.delete();
    }

    public static boolean removeRow(Sheet sheet, int rowBegin, int rowEnd) {
        if (sheet == null || rowBegin < 0 || rowEnd < 0 || rowBegin > sheet.getMaxRowIndex() || rowEnd > sheet.getMaxRowIndex() || rowEnd < rowBegin) {
            return false;
        }
        Range range = sheet.getRowRange(rowBegin, rowEnd);
        range.setIgnoreProtected(true);
        return range.delete();
    }

    public static Column addColumn(Sheet sheet, int colIndex) {
        if (sheet == null || colIndex < 0) {
            return null;
        }
        Range range = sheet.getColRange(colIndex, colIndex);
        range.setIgnoreProtected(true);
        range.insert();
        Column col = sheet.getColumn(colIndex, true);
        int maxRowIndex = sheet.getMaxRowIndex() + 1;
        for (int i = 0; i < maxRowIndex; ++i) {
            BgNTemplateHelper.clearAll(sheet.getCell(i, colIndex, false), false);
        }
        return col;
    }

    public static Column addColumn(Sheet sheet, int colIndex, boolean hasStyle) {
        if (sheet == null || colIndex < 0) {
            return null;
        }
        BgRange range1 = new BgRange(sheet.getBook(), sheet, CellBlock.getNewCellBlock((int)0, (int)colIndex, (int)1048575, (int)colIndex));
        range1.setIgnoreProtected(true);
        if (hasStyle) {
            range1.insert(false);
        } else {
            range1.insert(false, InsertType.NOSTYLE);
        }
        Column col = sheet.getColumn(colIndex, true);
        int maxRowIndex = sheet.getMaxRowIndex() + 1;
        for (int i = 0; i < maxRowIndex; ++i) {
            BgNTemplateHelper.clearAll(sheet.getCell(i, colIndex, false), false);
        }
        return col;
    }

    public static Column addColumnWithOutMode(Sheet sheet, int colIndex) {
        if (sheet == null || colIndex < 0) {
            return null;
        }
        Range range = sheet.getColRange(colIndex, colIndex);
        range.setIgnoreProtected(true);
        range.insert(false, InsertType.NOSTYLE);
        Column col = sheet.getColumn(colIndex, true);
        int maxRowIndex = sheet.getMaxRowIndex() + 1;
        for (int i = 0; i < maxRowIndex; ++i) {
            BgNTemplateHelper.clearAll(sheet.getCell(i, colIndex, false), false);
        }
        return col;
    }

    public static Row addRowWithOutMode(Sheet sheet, int rowIndex) {
        if (sheet == null || rowIndex < 0) {
            return null;
        }
        Range range = sheet.getRowRange(rowIndex, rowIndex);
        range.setIgnoreProtected(true);
        range.insert(false, InsertType.NOSTYLE);
        Row row = sheet.getRow(rowIndex, true);
        int maxColIndex = row.size();
        for (int i = 0; i < maxColIndex; ++i) {
            BgNTemplateHelper.clearAll(row.getAt(i), false);
        }
        return row;
    }

    public static void addColumns(Sheet sheet, int colIndex, int colCont) {
        if (sheet == null || colIndex < 0) {
            return;
        }
        Range range = sheet.getColRange(colIndex, colIndex + colCont);
        range.setIgnoreProtected(true);
        range.insert(false);
    }

    public static void addColumns(Sheet sheet, int colIndex, int colCont, boolean hasStyle) {
        if (sheet == null || colIndex < 0) {
            return;
        }
        Range range = sheet.getColRange(colIndex, colIndex + colCont);
        range.setIgnoreProtected(true);
        if (hasStyle) {
            range.insert(false);
        } else {
            range.insert(false, InsertType.NOSTYLE);
        }
    }

    public static boolean removeColumn(Sheet sheet, int colIndex) {
        if (sheet == null || colIndex < 0 || colIndex > sheet.getMaxColIndex()) {
            return false;
        }
        Range range = sheet.getColRange(colIndex, colIndex);
        range.setIgnoreProtected(true);
        return range.delete();
    }

    public static void enableUndo(Book book) {
        if (book != null) {
            book.getUndoManager().enable(true);
        }
    }

    public static void disableUndo(Book book) {
        if (book != null) {
            book.getUndoManager().enable(false);
        }
    }

    public static void enableCal(Book book) {
        if (book != null) {
            book.setCalculate(true);
        }
    }

    public static void disableCal(Book book) {
        if (book != null) {
            book.setCalculate(false);
        }
    }

    public static void checkFormulaPara(String formulaStr, String[] formulaPara) throws EASBizException {
        if (formulaPara == null) {
            throw new BgFormException(BgFormException.ERRORPARAMETER, (Object[])new String[]{formulaStr});
        }
        if (formulaPara.length == 6) {
            if (StringUtils.isEmpty((String)formulaPara[0])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOITEM, (Object[])new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[1])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOPERIOD, (Object[])new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[2])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOELEMENT, (Object[])new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[5])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOCURRENCY, (Object[])new String[]{formulaStr});
            }
        } else if (formulaPara.length == 4) {
            if (StringUtils.isEmpty((String)formulaPara[0])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOITEM, (Object[])new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[1])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOPERIOD, (Object[])new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[2])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOELEMENT, (Object[])new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[3])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOCURRENCY, (Object[])new String[]{formulaStr});
            }
        }
    }

    public static void saveFormulaPara(String[] formulaPara, List bgItemList, List bgPeriodList, List bgElementList, List currencyList) {
        bgItemList.add(formulaPara[0].replaceAll(",", "_"));
        bgPeriodList.add(formulaPara[1]);
        bgElementList.add(formulaPara[2]);
        currencyList.add(formulaPara[5]);
    }

    public static void saveFormulaPara(String[] formulaPara, Set bgItemSet, Set bgPeriodSet, Set bgElementSet, Set currencySet) {
        bgItemSet.add(formulaPara[0].replaceAll(",", "_"));
        bgPeriodSet.add(formulaPara[1]);
        bgElementSet.add(formulaPara[2]);
        currencySet.add(formulaPara[5]);
    }

    public static void saveFormulaParaTem(String[] formulaPara, List bgItemList, List bgPeriodList, List bgElementList, List currencyList) {
        if (!StringUtils.isEmpty((String)formulaPara[0])) {
            bgItemList.add(formulaPara[0].replaceAll(",", "_"));
        }
        if (!StringUtils.isEmpty((String)formulaPara[1]) && formulaPara[1].indexOf("!") == -1) {
            bgPeriodList.add(formulaPara[1]);
        }
        if (!StringUtils.isEmpty((String)formulaPara[2])) {
            bgElementList.add(formulaPara[2]);
        }
        if (!StringUtils.isEmpty((String)formulaPara[5])) {
            currencyList.add(formulaPara[5]);
        }
    }

    public static void saveFormulaParaTem(String[] formulaPara, Set bgItemSet, Set bgPeriodSet, Set bgElementSet, Set currencySet) {
        if (!StringUtils.isEmpty((String)formulaPara[0])) {
            bgItemSet.add(formulaPara[0].replaceAll(",", "_"));
        }
        if (!StringUtils.isEmpty((String)formulaPara[1])) {
            bgPeriodSet.add(formulaPara[1]);
        }
        if (!StringUtils.isEmpty((String)formulaPara[2])) {
            bgElementSet.add(formulaPara[2]);
        }
        if (!StringUtils.isEmpty((String)formulaPara[5])) {
            currencySet.add(formulaPara[5]);
        }
    }

    public static void removeFormulaParaTem(String[] formulaPara, Set bgItemSet, Set bgPeriodSet, Set bgElementSet, Set currencySet) {
        if (!StringUtils.isEmpty((String)formulaPara[0])) {
            bgItemSet.remove(formulaPara[0].replaceAll(",", "_"));
        }
        if (!StringUtils.isEmpty((String)formulaPara[1])) {
            bgPeriodSet.remove(formulaPara[1]);
        }
        if (!StringUtils.isEmpty((String)formulaPara[2])) {
            bgElementSet.remove(formulaPara[2]);
        }
        if (!StringUtils.isEmpty((String)formulaPara[5])) {
            currencySet.remove(formulaPara[5]);
        }
    }

    public static void removeFormulaPara(String[] formulaPara, Set bgItemSet, Set bgPeriodSet, Set bgElementSet, Set currencySet) {
        bgItemSet.remove(formulaPara[0].replaceAll(",", "_"));
        bgPeriodSet.remove(formulaPara[1]);
        bgElementSet.remove(formulaPara[2]);
        currencySet.remove(formulaPara[5]);
    }

    public static Object getBookObject(Book book, String key) {
        if (book != null && !StringUtils.isEmpty((String)key)) {
            return book.getUserObjectValue(key);
        }
        return null;
    }

    public static void setBookObject(Book book, String key, Object obj) {
        if (book != null && !StringUtils.isEmpty((String)key)) {
            book.setUserObject(key, obj);
        }
    }

    public static Object getSheetObject(Sheet sheet, String key) {
        if (sheet != null && !StringUtils.isEmpty((String)key)) {
            return sheet.getUserObjectValue(key);
        }
        return null;
    }

    public static void setSheetObject(Sheet sheet, String key, Object obj) {
        if (sheet != null && !StringUtils.isEmpty((String)key)) {
            sheet.setUserObject(key, obj);
        }
    }

    public static boolean checkHasSign(Sheet sheet) {
        String sign = BgNFSHelper.getSheetSign(sheet);
        return sign != null && !StringUtils.isEmpty((String)sign.toString());
    }

    public static String getSheetSign(Sheet sheet) {
        if (sheet != null) {
            Object obj = sheet.getUserObjectValue("SIGN_DATA_ID");
            return obj != null ? obj.toString() : null;
        }
        return null;
    }

    public static void setSheetSign(Sheet sheet) {
        if (sheet != null) {
            BgNFSHelper.setSheetSign(sheet, BOSUuid.create((String)"FF66566A").toString());
        }
    }

    public static void setSheetSign(Sheet sheet, String sign) {
        if (sheet != null && !StringUtils.isEmpty((String)sign)) {
            sheet.setUserObject("SIGN_DATA_ID", (Object)sign);
        }
    }

    public static void clearSheetSign(Sheet sheet) {
        if (sheet != null) {
            sheet.removeUserObject("SIGN_DATA_ID");
            sheet.removeUserObject("SIGN_DATA_SOURCE");
            sheet.removeUserObject("SIGN_DATA_SOURCE_OTHER");
        }
    }

    public static Object getRowObject(Row row, String key) {
        if (row != null && !StringUtils.isEmpty((String)key)) {
            return row.getUserObjectValue(key);
        }
        return null;
    }

    public static void setRowObject(Row row, String key, Object obj) {
        if (row != null && !StringUtils.isEmpty((String)key)) {
            row.setUserObject(key, obj);
        }
    }

    public static Object getColObject(Column column, String key) {
        if (column != null && !StringUtils.isEmpty((String)key)) {
            return column.getUserObjectValue(key);
        }
        return null;
    }

    public static void setColObject(Column column, String key, Object obj) {
        if (column != null && !StringUtils.isEmpty((String)key)) {
            column.setUserObject(key, obj);
        }
    }

    public static boolean checkHasSign(Row row) {
        String sign = BgNFSHelper.getRowSign(row);
        return sign != null && !StringUtils.isEmpty((String)sign.toString());
    }

    public static String getRowSign(Row row) {
        if (row != null) {
            Object obj = row.getUserObjectValue("SIGN_DATA_ID");
            return obj != null ? obj.toString() : null;
        }
        return null;
    }

    public static String setRowSign(Row row) {
        String sign = BOSUuid.create((String)"BBBCCAAA").toString();
        BgNFSHelper.setRowSign(row, sign);
        return sign;
    }

    public static void setRowNullSign(Row row) {
        if (row != null) {
            row.setUserObject("IS_NULL_ROW", (Object)"IS_NULL_ROW");
        }
    }

    public static boolean checkHasNullSign(Row row) {
        return row.getUserObject("IS_NULL_ROW") != null && row.getUserObject("IS_NULL_ROW").getValue() != null && "IS_NULL_ROW".equals(row.getUserObject("IS_NULL_ROW").getValue().toString());
    }

    public static void setRowSign(Row row, String sign) {
        if (row != null && !StringUtils.isEmpty((String)sign)) {
            row.setUserObject("SIGN_DATA_ID", (Object)sign);
        }
    }

    public static void clearRowSign(Row row, String key) {
        if (row != null && !StringUtils.isEmpty((String)key)) {
            row.removeUserObject(key);
        }
    }

    public static void clearRowSign(Row row) {
        if (row != null) {
            row.removeUserObject("SIGN_DATA_ID");
            row.removeUserObject("SIGN_DATA_SOURCE");
            row.removeUserObject("SIGN_DATA_SOURCE_OTHER");
        }
    }

    public static void setRowSource(Row row, String source) {
        if (row != null && !StringUtils.isEmpty((String)source)) {
            BgNFSHelper.setRowObject(row, "SIGN_DATA_SOURCE", source);
        }
    }

    public static Object getRowSource(Row row) {
        if (row != null) {
            return BgNFSHelper.getRowObject(row, "SIGN_DATA_SOURCE");
        }
        return null;
    }

    public static void removeRowSource(Row row) {
        if (row != null) {
            row.removeUserObject("SIGN_DATA_SOURCE");
            row.removeUserObject("SIGN_DATA_SOURCE_OTHER");
        }
    }

    public static boolean checkHasSign(Column column) {
        String sign = BgNFSHelper.getColSign(column);
        return sign != null && !StringUtils.isEmpty((String)sign.toString());
    }

    public static String getColSign(Column column) {
        if (column != null) {
            Object obj = column.getUserObjectValue("SIGN_DATA_ID");
            return obj != null ? obj.toString() : null;
        }
        return null;
    }

    public static String setColSign(Column column) {
        String sign = BOSUuid.create((String)"CCCAABBB").toString();
        BgNFSHelper.setColSign(column, sign);
        return sign;
    }

    public static void setColSign(Column column, String sign) {
        if (column != null && !StringUtils.isEmpty((String)sign)) {
            column.setUserObject("SIGN_DATA_ID", (Object)sign);
        }
    }

    public static void clearColSign(Column column) {
        if (column != null) {
            column.removeUserObject("SIGN_DATA_ID");
            column.removeUserObject("SIGN_DATA_SOURCE");
            column.removeUserObject("SIGN_DATA_SOURCE_OTHER");
        }
    }

    public static void setColSource(Column column, String source) {
        if (column != null && !StringUtils.isEmpty((String)source)) {
            BgNFSHelper.setColObject(column, "SIGN_DATA_SOURCE", source);
        }
    }

    public static Object getColSource(Column column) {
        if (column != null) {
            return column.getUserObjectValue("SIGN_DATA_SOURCE");
        }
        return null;
    }

    public static void removeColumnSource(Column column) {
        if (column != null) {
            column.removeUserObject("SIGN_DATA_SOURCE");
            column.removeUserObject("SIGN_DATA_SOURCE_OTHER");
        }
    }

    public static void setCellSource(Cell cell, String source) {
        if (cell == null || StringUtils.isEmpty((String)source)) {
            return;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            itemFormula.putExt("SIGN_DATA_SOURCE", source);
        }
    }

    public static String getCellSource(Cell cell) {
        if (cell != null) {
            Object obj = null;
            ItemFormula itemFormula = null;
            obj = cell.getUserObjectValue("ITEM");
            if (obj != null && obj instanceof ItemFormula) {
                itemFormula = (ItemFormula)obj;
                return itemFormula.getExt("SIGN_DATA_SOURCE");
            }
        }
        return null;
    }

    public static void setUserObject(Cell cell, String key, String obj) {
        if (cell != null && !StringUtils.isEmpty((String)key)) {
            cell.setUserObject(key, (Object)obj);
        }
    }

    public static Object getUserObject(Cell cell, String key) {
        if (cell != null && !StringUtils.isEmpty((String)key)) {
            return cell.getUserObjectValue(key);
        }
        return null;
    }

    public static void setCellFormulaValue(Cell cell, String key, String value) {
        if (cell == null || StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) {
            return;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            itemFormula.putExt(key, value);
        }
    }

    public static String getCellFormulaValue(Cell cell, String key) {
        if (cell == null || StringUtils.isEmpty((String)key)) {
            return null;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            return itemFormula.getExt(key);
        }
        return null;
    }

    public static void removeCellData(Cell cell, String key) {
        if (cell == null || StringUtils.isEmpty((String)key)) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            _tmpMap.remove(key);
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static void removeCellAllData(Cell cell) {
        if (cell != null) {
            cell.removeUserObject("CELL_DATA");
        }
    }

    public static void setCellData(Cell cell, String key, Object value) {
        if (cell != null && !StringUtils.isEmpty((String)key)) {
            Map<String, Object> _tmpMap = null;
            Object obj = cell.getUserObjectValue("CELL_DATA");
            if (obj != null && obj instanceof Map) {
                _tmpMap = (Map)obj;
            } else {
                _tmpMap = new HashMap();
                cell.setUserObject("CELL_DATA", _tmpMap);
            }
            if (_tmpMap != null) {
                _tmpMap.put(key, value);
            }
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static Object getCellData(Cell cell, String key) {
        if (cell != null && !StringUtils.isEmpty((String)key)) {
            Map _tmpMap = null;
            Object obj = cell.getUserObjectValue("CELL_DATA");
            if (obj != null && obj instanceof Map) {
                _tmpMap = (Map)obj;
                return _tmpMap.get(key);
            }
        }
        return null;
    }

    public static void removeCellExtData(Cell cell, String key) {
        if (cell == null || StringUtils.isEmpty((String)key)) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            _tmpMap.remove(key);
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA_EXT");
            }
        }
    }

    public static void removeCellAllExtData(Cell cell) {
        if (cell != null) {
            cell.removeUserObject("CELL_DATA_EXT");
        }
    }

    public static void setCellExtData(Cell cell, String key, Object value) {
        if (cell != null && !StringUtils.isEmpty((String)key)) {
            Map<String, Object> _tmpMap = null;
            Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
            if (obj != null && obj instanceof Map) {
                _tmpMap = (Map)obj;
            } else {
                _tmpMap = new HashMap();
                cell.setUserObject("CELL_DATA_EXT", _tmpMap);
            }
            if (_tmpMap != null) {
                _tmpMap.put(key, value);
            }
        }
    }

    public static Object getCellExtData(Cell cell, String key) {
        if (cell != null && !StringUtils.isEmpty((String)key)) {
            Map _tmpMap = null;
            Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
            if (obj != null && obj instanceof Map) {
                _tmpMap = (Map)obj;
                return _tmpMap.get(key);
            }
        }
        return null;
    }

    public static Map getFormulaMapOfBook(Book book, String orgUnitId, String schemeId) {
        HashMap<String, BigDecimal> formulaMap = new HashMap<String, BigDecimal>();
        if (book == null) {
            return formulaMap;
        }
        String formulaStr = null;
        StringBuffer _tmpKey = null;
        BigDecimal value = null;
        Sheet _sheet = null;
        Cell _cell = null;
        Object _obj = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    _tmpKey = new StringBuffer(orgUnitId).append("!").append(schemeId).append("!").append(formulaStr);
                    _obj = _cell.getVar();
                    try {
                        value = new BigDecimal(_obj.toString());
                    }
                    catch (Exception e) {
                        value = BgNConstants.ZERO;
                    }
                    formulaMap.put(_tmpKey.toString(), value);
                }
            }
        }
        return formulaMap;
    }

    public static Set getFormulaSetOfBook(Book book, Set bgFormSheetIds) {
        HashSet<String> formulaSet = new HashSet<String>();
        if (book == null) {
            return formulaSet;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        String formulaStr = null;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            if (bgFormSheetIds != null && !bgFormSheetIds.contains(_sheet.getID())) continue;
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    formulaSet.add(formulaStr);
                }
            }
        }
        return formulaSet;
    }

    public static List getFormulaListOfBook(Book book) {
        ArrayList<String> formulaList = new ArrayList<String>();
        if (book == null) {
            return formulaList;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        String formulaStr = null;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    formulaList.add(formulaStr);
                }
            }
        }
        return formulaList;
    }

    public static SortedParameterArray checkParameter(SortedParameterArray params, Map<Parameter, List<Parameter>> sumExpMap) {
        if (params == null) {
            return params;
        }
        Object[] objs = null;
        Parameter parameter = null;
        Parameter tmpParam = null;
        String orgNumber = null;
        String[] orgNumbers = null;
        ArrayList<Parameter> sumList = null;
        SortedParameterArray newParams = new SortedParameterArray();
        for (int i = 0; i < params.size(); ++i) {
            parameter = params.getParameter(i);
            objs = parameter.getArgs();
            orgNumber = (String)((Variant)objs[0]).getValue();
            if (StringUtils.isEmpty((String)orgNumber)) continue;
            orgNumbers = orgNumber.split(";");
            if (orgNumbers.length == 1) {
                newParams.append((Object)parameter);
                continue;
            }
            sumList = new ArrayList<Parameter>();
            int jn = orgNumbers.length;
            for (int j = 0; j < jn; ++j) {
                orgNumber = orgNumbers[j].trim();
                tmpParam = new Parameter(BgNFSHelper.getNewObj(objs, orgNumber), parameter.getSheetName(), parameter.isNeedSheetInfo());
                tmpParam.setUID(parameter.getUID());
                tmpParam.setValue(parameter.getValue());
                newParams.append((Object)tmpParam);
                sumList.add(tmpParam);
            }
            sumExpMap.put(parameter, sumList);
        }
        return newParams;
    }

    private static Object[] getNewObj(Object[] objs, String orgNumber) {
        if (objs == null || StringUtils.isEmpty((String)orgNumber) || objs.length == 0) {
            return objs;
        }
        Object[] newObj = new Object[objs.length];
        newObj[0] = new Variant((Object)orgNumber);
        for (int n = 1; n < objs.length; ++n) {
            newObj[n] = objs[n];
        }
        return newObj;
    }

    public static void lockedCellOfBook(Book book) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasExpression(_cell)) continue;
                    BgNFSHelper.setCellLocked(_cell, true);
                }
            }
        }
    }

    public static boolean checkHasFormulaOfRow(Row row, int colSize) {
        if (row == null) {
            return false;
        }
        Cell cell = null;
        for (int i = 0; i < colSize; ++i) {
            cell = row.getCell(i, false);
            if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
            return true;
        }
        return false;
    }

    public static void setBackGroup(Cell cell, Color color) {
        if (cell == null) {
            return;
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBackground(color);
        Sheet sheet = cell.getSheet();
        if (sheet == null) {
            return;
        }
        Range range = sheet.getRange(cell);
        boolean oldFlag = range.isIgnoreProtected();
        range.setIgnoreProtected(true);
        range.setStyle(sa, Styles.getEmptySA());
        range.setIgnoreProtected(oldFlag);
    }

    public static void setItalicFont(Cell cell) {
        if (cell == null) {
            return;
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setItalic(true);
        Sheet sheet = cell.getSheet();
        if (sheet == null) {
            return;
        }
        Range range = sheet.getRange(cell);
        boolean oldFlag = range.isIgnoreProtected();
        range.setIgnoreProtected(true);
        range.setStyle(sa, Styles.getEmptySA());
        range.setIgnoreProtected(oldFlag);
    }

    public static void clearBackGroup(Cell cell) {
        if (cell == null) {
            return;
        }
        if (!cell.getStyle().getBackground().equals(Styles.getNullColor())) {
            StyleAttributes sa = Styles.getEmptySA();
            sa.setBackground(Styles.getNullColor());
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            range.setStyle(sa, Styles.getEmptySA());
        }
    }

    public static Color getBackGroup(Cell cell) {
        if (cell == null) {
            return null;
        }
        StyleAttributes SA = Styles.getSA((ShareStyleAttributes)cell.getSSA());
        if (SA == null) {
            return null;
        }
        return SA.getBackground();
    }

    public static void setNumberFormat(Cell cell, String numFormat) {
        if (cell == null) {
            return;
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setNumberFormat(numFormat);
        Range range = cell.getSheet().getRange(cell);
        range.setIgnoreProtected(true);
        range.setStyle(sa, Styles.getEmptySA());
    }

    public static void setHided(Row row, boolean hided) {
        if (row != null) {
            Range range = row.getSheet().getRowRange(row.getRow(), row.getRow());
            range.setIgnoreProtected(true);
            range.setHidden(hided, true);
        }
    }

    public static void setHided(Column column, boolean hided) {
        if (column != null) {
            Range range = column.getSheet().getColRange(column.getCol(), column.getCol());
            range.setIgnoreProtected(true);
            range.setColumnHidden(hided);
        }
    }

    public static boolean isHided(Row row) {
        Range range = row.getSheet().getRowRange(row.getRow(), row.getRow());
        return range != null && range.getHidden() != null && (range.getHidden() != false || range.getRowHeight() == 0);
    }

    public static boolean isHided(Column col) {
        Range range = col.getSheet().getColRange(col.getCol(), col.getCol());
        return range != null && (range.getHidden() != false || range.getColumnWidth() == 0);
    }

    public static boolean checkHasFormulaOfRow(Sheet sheet, int rowIndex, int colBegin, int colEnd) {
        if (sheet == null) {
            return false;
        }
        Cell cell = null;
        for (int i = colBegin; i <= colEnd; ++i) {
            cell = sheet.getCell(rowIndex, i, false);
            if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHasFormulaOfCol(Sheet sheet, int colIndex, int rowBegin, int rowEnd) {
        if (sheet == null) {
            return false;
        }
        Cell cell = null;
        for (int i = rowBegin; i <= rowEnd; ++i) {
            cell = sheet.getCell(i, colIndex, false);
            if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
            return true;
        }
        return false;
    }

    public static void clearStyle(Cell cell) {
        if (cell != null) {
            cell.getSheet().getRange(cell).setStyle(null, Styles.getEmptySA());
        }
    }

    public static void replaceSheetSign(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        Row _row = null;
        Column _column = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        rowCount = sheet.getMaxRowIndex();
        colCount = sheet.getMaxColIndex();
        for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            _row = sheet.getRow(rowIndex, false);
            if (_row == null || !BgNFSHelper.checkHasSign(_row)) continue;
            BgNFSHelper.setRowSource(_row, "DATA_SOURCE_TEMPLATE");
        }
        for (colIndex = 0; colIndex <= colCount; ++colIndex) {
            _column = sheet.getColumn(colIndex, false);
            if (_column == null || !BgNFSHelper.checkHasSign(_column)) continue;
            BgNFSHelper.setColSource(_column, "DATA_SOURCE_TEMPLATE");
        }
    }

    public static void checkBookSign(Book book) {
        if (book == null) {
            return;
        }
        Object _obj = null;
        Sheet _sheet = null;
        Row _row = null;
        Column _column = null;
        boolean isEmptyRow = false;
        int sheetIndex = 0;
        int sheetSize = 0;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        sheetSize = book.getSheetCount();
        for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            boolean check = true;
            if (!BgNFSHelper.checkHasSign(_sheet)) {
                BgNFSHelper.setSheetSign(_sheet);
            }
            for (rowIndex = rowCount; rowIndex >= 0; --rowIndex) {
                _row = _sheet.getRow(rowIndex, true);
                isEmptyRow = BgNFSHelper.checkIsEmptyRow(_row);
                if (check && isEmptyRow) {
                    BgNFSHelper.removeRowSign(_row);
                    BgNFSHelper.removeRowSource(_row);
                    continue;
                }
                check = false;
                if (!BgNFSHelper.checkHasSign(_row)) {
                    BgNFSHelper.setRowSign(_row);
                }
                if (isEmptyRow) {
                    BgNFSHelper.setRowNullSign(_row);
                }
                if (BgNFSHelper.checkHasNullSign(_row) && !isEmptyRow) {
                    if (!BgNFSHelper.checkHasEnumerateOfRow(_row, _sheet.getMaxColIndex())) {
                        BgNFSHelper.setRowSign(_row);
                    }
                    BgNFSHelper.setRowSource(_row, "DATA_SOURCE_EDIT");
                    BgNFSHelper.removeNullRowSign(_row);
                    continue;
                }
                _obj = BgNFSHelper.getRowSource(_row);
                if (_obj != null) continue;
                BgNFSHelper.setRowSource(_row, "DATA_SOURCE_EDIT");
            }
            for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                _column = _sheet.getColumn(colIndex, true);
                if (!BgNFSHelper.checkHasSign(_column)) {
                    BgNFSHelper.setColSign(_column);
                }
                if ((_obj = BgNFSHelper.getColSource(_column)) != null) continue;
                BgNFSHelper.setColSource(_column, "DATA_SOURCE_EDIT");
            }
        }
    }

    public static void removeBookNullSign(Book book) {
        BgNFSHelper.removeBookNullSign(book, null);
    }

    public static void removeBookNullSign(Book book, Set filterSheet) {
        if (book == null) {
            return;
        }
        boolean isFilterBySheet = false;
        if (filterSheet != null && !filterSheet.isEmpty()) {
            isFilterBySheet = true;
        }
        Sheet _sheet = null;
        Row _row = null;
        boolean isEmptyRow = false;
        int sheetIndex = 0;
        int sheetSize = 0;
        int rowIndex = 0;
        int rowCount = 0;
        sheetSize = book.getSheetCount();
        for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            if (isFilterBySheet && !filterSheet.contains(BgNFSHelper.getSheetSign(_sheet))) continue;
            rowCount = _sheet.getMaxRowIndex();
            if (!BgNFSHelper.checkHasSign(_sheet)) {
                BgNFSHelper.setSheetSign(_sheet);
            }
            for (rowIndex = rowCount; rowIndex >= 0; --rowIndex) {
                _row = _sheet.getRow(rowIndex, true);
                isEmptyRow = BgNFSHelper.checkIsEmptyRow(_row);
                if (!BgNFSHelper.checkHasNullSign(_row) || isEmptyRow) continue;
                BgNFSHelper.removeNullRowSign(_row);
            }
        }
    }

    public static void updateAliasAudit(Book book) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Row _row = null;
        Column _column = null;
        Cell _cell = null;
        Object _source = null;
        int sheetIndex = 0;
        int sheetSize = 0;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        sheetSize = book.getSheetCount();
        for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                _row = _sheet.getRow(rowIndex, false);
                if (_row != null && BgNFSHelper.checkHasSign(_row)) {
                    _source = BgNFSHelper.getRowSource(_row);
                    if (_source != null && "DATA_SOURCE_COLLECT".equals(_source.toString())) {
                        BgNFSHelper.setRowSource(_row, "DATA_SOURCE_EDIT");
                        BgNFSHelper.setRowObject(_row, "SIGN_DATA_SOURCE_OTHER", "DATA_SOURCE_COLLECT");
                    }
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        String sourceString;
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (_cell == null || (sourceString = BgNFSHelper.getCellSource(_cell)) == null || !"DATA_SOURCE_COLLECT".equals(sourceString)) continue;
                        BgNFSHelper.setCellSource(_cell, "DATA_SOURCE_EDIT");
                        BgNFSHelper.setCellFormulaValue(_cell, "SIGN_DATA_SOURCE_OTHER", "DATA_SOURCE_COLLECT");
                    }
                }
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    if (rowIndex == 0 && (_column = _sheet.getColumn(colIndex, false)) != null && BgNFSHelper.checkHasSign(_column) && (_source = BgNFSHelper.getColSource(_column)) != null && "DATA_SOURCE_COLLECT".equals(_source.toString())) {
                        BgNFSHelper.setColSource(_column, "DATA_SOURCE_EDIT");
                        BgNFSHelper.setColObject(_column, "SIGN_DATA_SOURCE_OTHER", "DATA_SOURCE_COLLECT");
                    }
                    if (BgNFSHelper.checkHasFormulaOfCell(_cell = _sheet.getCell(rowIndex, colIndex, false))) {
                        BgNFSHelper.setEditFormulaOfCell(_cell, false);
                    }
                    if (_cell == null) continue;
                    _cell.removeUserObject("SIGN_DATA_SOURCE");
                }
            }
        }
    }

    public static void removeRowSign(Row row) {
        if (row != null) {
            row.removeUserObject("SIGN_DATA_ID");
            row.removeUserObject("SIGN_DATA_SOURCE");
            row.removeUserObject("IS_NULL_ROW");
        }
    }

    public static void removeNullRowSign(Row row) {
        if (row != null) {
            row.removeUserObject("IS_NULL_ROW");
        }
    }

    public static void removeColSign(Column col) {
        if (col != null && BgNFSHelper.checkHasSign(col)) {
            col.removeUserObject("SIGN_DATA_ID");
            if (col.getUserObjectValue("SIGN_DATA_SOURCE") != null) {
                col.removeUserObject("SIGN_DATA_SOURCE");
            }
        }
    }

    public static void removeSheetSign(Sheet sheet) {
        if (sheet != null && BgNFSHelper.checkHasSign(sheet)) {
            sheet.removeUserObject("SIGN_DATA_ID");
            if (sheet.getUserObjectValue("SIGN_DATA_SOURCE") != null) {
                sheet.removeUserObject("SIGN_DATA_SOURCE");
            }
        }
    }

    public static boolean checkIsLinkCell(Cell cell) {
        return cell != null && (!StringUtils.isEmpty((String)((String)BgNFSHelper.getCellData(cell, "BG_LINK_FORM_ID"))) || !StringUtils.isEmpty((String)((String)BgNFSHelper.getCellData(cell, "BG_LINK_TEMPLATE_ID"))));
    }

    public static void setFocusOfCell(SpreadContext spread) {
        if (spread == null || spread.getSpread().getBook() == null || spread.getSpread().getBook().getSheet(0) == null) {
            return;
        }
        Range range = spread.getSpread().getBook().getSheet(0).getRange(0, 0);
        if (range != null) {
            range.select();
        }
        spread.getSpread().scrollCellVisible(0, 0);
    }

    public static void setFocusOfCell(SpreadContext spread, int sheetIndex, int rowIndex, int colIndex) {
        if (spread == null || spread.getSpread().getBook() == null || spread.getSpread().getBook().getSheet(sheetIndex) == null) {
            return;
        }
        Range range = spread.getSpread().getBook().getSheet(sheetIndex).getRange(rowIndex, colIndex);
        if (range != null) {
            range.select();
        }
        spread.getSpread().scrollCellVisible(0, 0);
    }

    public static void setLinkOfCell(Cell cell, String link, String bgFormId) {
        if (cell == null || StringUtils.isEmpty((String)link) || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        BgNFSHelper.setCellData(cell, "BG_LINK_FORM_ID", bgFormId);
        BgNFSHelper.setValue(cell, link);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setFontColor(Color.BLUE);
        sa.setUnderline(true);
        sa.setNumberFormat("@");
        cell.getSheet().getRange(cell).setStyle(sa, Styles.getEmptySA());
    }

    public static void clearLinkOfCell(Cell cell) {
        if (cell == null) {
            return;
        }
        if (BgNFSHelper.checkIsLinkCell(cell)) {
            Map _tmpMap = (Map)cell.getUserObjectValue("CELL_DATA");
            BgNFSHelper.removeCellData(cell, "BG_LINK_FORM_ID");
            BgNFSHelper.removeCellData(cell, "BG_LINK_ORGUNIT_ID");
            BgNFSHelper.removeCellData(cell, "BG_LINK_SCHEME_ID");
            BgNFSHelper.removeCellData(cell, "BG_LINK_SCHEME_NUMBER");
            BgNFSHelper.removeCellData(cell, "BG_LINK_TEMPLATE_ID");
            BgNFSHelper.removeCellData(cell, "BG_LINK_TEMPLATE_NUMBER");
            BgNFSHelper.removeCellData(cell, "BG_LINK_PERIOD_ID");
            BgNFSHelper.removeCellData(cell, "BG_LINK_CURRENCY_ID");
            StyleAttributes sa = Styles.getEmptySA();
            sa.setUnderline(false);
            cell.getSheet().getRange(cell).setStyle(sa, Styles.getEmptySA());
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static void setCellLockedAndProtection(Cell cell, boolean locked) {
        if (cell == null) {
            return;
        }
        Protection pro = cell.getSheet().getSheetOption().getProtection(true);
        if (locked) {
            if (!pro.isProtected()) {
                pro.appendOperation(65536);
                pro.appendOperation(8192);
                if (!BgSHelper.isProtectionRowAndCol()) {
                    pro.appendOperation(8);
                    pro.appendOperation(16);
                }
                pro.appendOperation(64);
                pro.appendOperation(32);
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
        } else if (pro.isProtected()) {
            pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(locked);
        cell.getSheet().getRange(cell).setStyle(sa, Styles.getEmptySA());
        if (locked) {
            BgNTemplateHelper.setCellCtrlValue(cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE, false);
        } else {
            BgNTemplateHelper.removeCellCtrlValue(cell, "CELL_LOCK", false);
        }
    }

    public static void setCellLockedAndProtectionFromSuper(Cell cell, boolean locked) {
        if (cell == null) {
            return;
        }
        if (locked) {
            BgNTemplateHelper.setCellCtrlValue(cell, "CELL_LOCK_SUPER", BgNConstants.TRUE_UPDATE, false);
        } else {
            BgNTemplateHelper.removeCellCtrlValue(cell, "CELL_LOCK_SUPER", false);
        }
        BgNFSHelper.setCellLockedAndProtection(cell, locked);
    }

    public static boolean isCellLockedAndProtectionFromSupser(Cell cell) {
        if (cell == null) {
            return false;
        }
        return BgNTemplateHelper.getCellCtrlValue(cell, "CELL_LOCK_SUPER") != null && BgNTemplateHelper.getCellCtrlValue(cell, "CELL_LOCK_SUPER").equals(BgNConstants.TRUE_UPDATE);
    }

    public static boolean isBookLockedAndProtection(Book book) {
        return book != null && book.getUserObjectValue("BOOK_LOCK") != null && book.getUserObjectValue("BOOK_LOCK").equals(BgNConstants.TRUE_UPDATE);
    }

    public static boolean isSheetLockedAndProtection(Sheet sheet) {
        return sheet != null && sheet.getUserObjectValue("BOOK_LOCK") != null && sheet.getUserObjectValue("BOOK_LOCK").equals(BgNConstants.TRUE_UPDATE);
    }

    public static boolean isCellLockedAndProtection(Cell cell) {
        if (cell == null) {
            return false;
        }
        return BgNTemplateHelper.getCellCtrlValue(cell, "CELL_LOCK") != null && BgNTemplateHelper.getCellCtrlValue(cell, "CELL_LOCK").equals(BgNConstants.TRUE_UPDATE);
    }

    public static void setBookLocked(Book book, boolean locked) {
        if (book == null) {
            return;
        }
    }

    public static void setBookProtection(Book book, boolean locked) {
        if (book == null) {
            return;
        }
        BookProtection pro = book.getProtection();
        if (locked) {
            if (!pro.isProtected()) {
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            book.setUserObject("SHEET_LOCK", (Object)BgNConstants.FALSE_UPDATE);
        } else {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
                if (pro.isProtected()) {
                    pro.stop();
                }
            }
            if (pro.isProtected()) {
                pro.setPassword("abcdefghijklmnopqrstuvwxyz123456789987654321");
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            book.setUserObject("SHEET_LOCK", (Object)BgNConstants.TRUE_UPDATE);
        }
    }

    public static void setBookProtection(Book book, boolean locked, List bookOperation) {
        if (book == null) {
            return;
        }
        BookProtection pro = book.getProtection();
        if (locked) {
            if (!pro.isProtected()) {
                if (bookOperation != null && !bookOperation.isEmpty()) {
                    Object _obj2 = null;
                    pro.deleteOperations();
                    for (Object _obj2 : bookOperation) {
                        if (_obj2 == null || !(_obj2 instanceof Integer)) continue;
                        pro.appendOperation(((Integer)_obj2).intValue());
                    }
                }
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            book.setUserObject("SHEET_LOCK", (Object)BgNConstants.FALSE_UPDATE);
        } else {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
                if (pro.isProtected()) {
                    pro.stop();
                }
            }
            if (pro.isProtected()) {
                pro.setPassword("abcdefghijklmnopqrstuvwxyz123456789987654321");
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            book.setUserObject("SHEET_LOCK", (Object)BgNConstants.TRUE_UPDATE);
        }
    }

    public static void setSheetLocked(Sheet sheet, boolean locked) {
        if (sheet == null) {
            return;
        }
        StyleAttributes sa = Styles.getEmptySA();
        StyleAttributes saIn = Styles.getEmptySA();
        Range r = sheet.getSheetRange();
        r.getStyle(sa, saIn);
        sa.setLocked(locked);
        r.setStyle(sa, saIn);
        boolean isHide = false;
        isHide = sheet.isHide();
        sheet.setHide(isHide);
    }

    public static void setSheetProtection(Sheet sheet, boolean locked) {
        if (sheet == null) {
            return;
        }
        Protection pro = sheet.getSheetOption().getProtection(true);
        if (locked) {
            if (!pro.isProtected()) {
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            sheet.setUserObject("SHEET_LOCK", (Object)BgNConstants.FALSE_UPDATE);
        } else {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
                if (pro.isProtected()) {
                    pro.stop();
                }
            }
            sheet.setUserObject("SHEET_LOCK", (Object)BgNConstants.TRUE_UPDATE);
        }
    }

    public static void setSheetProtection(Sheet sheet, boolean locked, List sheetOperation) {
        if (sheet == null) {
            return;
        }
        Protection pro = sheet.getSheetOption().getProtection(true);
        if (locked) {
            if (!pro.isProtected()) {
                if (sheetOperation != null && !sheetOperation.isEmpty()) {
                    Object _obj2 = null;
                    pro.deleteOperations();
                    for (Object _obj2 : sheetOperation) {
                        if (_obj2 == null || !(_obj2 instanceof Integer)) continue;
                        pro.appendOperation(((Integer)_obj2).intValue());
                    }
                }
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            sheet.setUserObject("SHEET_LOCK", (Object)BgNConstants.FALSE_UPDATE);
        } else {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
                if (pro.isProtected()) {
                    pro.stop();
                }
            }
            if (pro.isProtected()) {
                pro.setPassword("abcdefghijklmnopqrstuvwxyz123456789987654321");
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            sheet.setUserObject("SHEET_LOCK", (Object)BgNConstants.TRUE_UPDATE);
        }
    }

    public static void setCellLocked(Cell cell, boolean isLocked) {
        if (cell == null || BgNTemplateHelper.hasForceLock(cell)) {
            return;
        }
        if (isLocked) {
            BgNFSHelper.setCellExtData(cell, "CELL_LOCK", BgNConstants.FALSE_UPDATE);
        } else {
            BgNFSHelper.setCellExtData(cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE);
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(isLocked);
        Range range = cell.getSheet().getRange(cell);
        range.setIgnoreProtected(true);
        range.setStyle(sa, Styles.getEmptySA());
    }

    public static void setCellLocked(Cell cell, boolean isLocked, Color color) {
        if (cell == null) {
            return;
        }
        if (isLocked) {
            BgNFSHelper.setCellExtData(cell, "CELL_LOCK", BgNConstants.FALSE_UPDATE);
        } else {
            BgNFSHelper.setCellExtData(cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE);
        }
        StyleAttributes sa = Styles.getEmptySA();
        if (color != null) {
            sa.setBackground(color);
        }
        Range range = cell.getSheet().getRange(cell);
        range.setIgnoreProtected(true);
        range.setStyle(sa, Styles.getEmptySA());
    }

    public static void setCellProtection(Cell cell, boolean locked) {
        if (cell == null) {
            return;
        }
        Protection pro = cell.getSheet().getSheetOption().getProtection(true);
        if (locked) {
            if (!pro.isProtected()) {
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            BgNFSHelper.setCellExtData(cell, "CELL_LOCK", BgNConstants.FALSE_UPDATE);
        } else {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
                if (pro.isProtected()) {
                    pro.stop();
                }
            }
            BgNFSHelper.setCellExtData(cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE);
        }
    }

    public static void setCellProtection(Cell cell, boolean locked, List cellOperation) {
        if (cell == null) {
            return;
        }
        Protection pro = cell.getSheet().getSheetOption().getProtection(true);
        if (locked) {
            if (!pro.isProtected()) {
                if (cellOperation != null && !cellOperation.isEmpty()) {
                    Object _obj2 = null;
                    pro.deleteOperations();
                    for (Object _obj2 : cellOperation) {
                        if (_obj2 == null || !(_obj2 instanceof Integer)) continue;
                        pro.appendOperation(((Integer)_obj2).intValue());
                    }
                }
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            BgNFSHelper.setCellExtData(cell, "CELL_LOCK", BgNConstants.FALSE_UPDATE);
        } else {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
                if (pro.isProtected()) {
                    pro.stop();
                }
            }
            BgNFSHelper.setCellExtData(cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE);
        }
    }

    public static void setBookLANDP(Book book, boolean locked, List bookOperation, List sheetOperation) {
        if (book == null) {
            return;
        }
        BgNFSHelper.setBookProtection(book, locked, bookOperation);
        BgNFSHelper.setBookLocked(book, locked);
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            BgNFSHelper.setSheetLANDP(book.getSheet(i), locked, sheetOperation);
        }
    }

    public static void setSheetLANDP(Sheet sheet, boolean locked, List sheetOperation) {
        if (sheet == null) {
            return;
        }
        BgNFSHelper.setSheetProtection(sheet, locked, sheetOperation);
        BgNFSHelper.setSheetLocked(sheet, locked);
    }

    public static void setCellLANDP(Cell cell, boolean locked, List cellOperation) {
        if (cell == null) {
            return;
        }
        BgNFSHelper.setCellProtection(cell, locked, cellOperation);
    }

    public static void setAllCellLocked(Book book, boolean isLocked) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            StyleAttributes sa = Styles.getEmptySA();
            sa.setLocked(isLocked);
            Range range = null;
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (_cell == null) continue;
                    if (isLocked) {
                        if (_cell.isLocked() || _cell == null) continue;
                        if (isLocked) {
                            BgNFSHelper.setCellExtData(_cell, "CELL_LOCK", BgNConstants.FALSE_UPDATE);
                        } else {
                            BgNFSHelper.setCellExtData(_cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE);
                        }
                        if (range == null) {
                            range = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (!_cell.isLocked() || _cell == null) continue;
                    if (isLocked) {
                        BgNFSHelper.setCellExtData(_cell, "CELL_LOCK", BgNConstants.FALSE_UPDATE);
                    } else {
                        BgNFSHelper.setCellExtData(_cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE);
                    }
                    if (range == null) {
                        range = _cell.getSheet().getRange(_cell);
                        continue;
                    }
                    range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                }
            }
            if (range == null) continue;
            range.setIgnoreProtected(true);
            range.setStyle(sa, Styles.getEmptySA());
        }
    }

    public static List getOnlySelectCellOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        if (!BgSHelper.isProtectionRowAndCol()) {
            sheetOperation.add(new Integer(8));
            sheetOperation.add(new Integer(16));
        }
        sheetOperation.add(new Integer(4));
        sheetOperation.add(new Integer(32768));
        return sheetOperation;
    }

    public static List getOnlySelectCellOperationWorkFlow() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(8));
        sheetOperation.add(new Integer(16));
        sheetOperation.add(new Integer(32768));
        return sheetOperation;
    }

    public static List getMaxOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(4));
        if (!BgSHelper.isProtectionRowAndCol()) {
            sheetOperation.add(new Integer(8));
            sheetOperation.add(new Integer(16));
        }
        sheetOperation.add(new Integer(32));
        sheetOperation.add(new Integer(64));
        sheetOperation.add(new Integer(128));
        sheetOperation.add(new Integer(256));
        sheetOperation.add(new Integer(512));
        sheetOperation.add(new Integer(65536));
        sheetOperation.add(new Integer(8192));
        sheetOperation.add(new Integer(16384));
        sheetOperation.add(new Integer(32768));
        sheetOperation.add(new Integer(4096));
        return sheetOperation;
    }

    public static List getBookOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        return sheetOperation;
    }

    public static void checkFormulaIsEctype(List formulas) throws EASBizException {
        if (formulas == null || formulas.isEmpty()) {
            return;
        }
        String formulaString = null;
        String checkString = null;
        String[] parameter = null;
        HashMap checkMap = new HashMap();
        int count = formulas.size();
        for (int index = 0; index < count; ++index) {
            parameter = (String[])formulas.get(index);
            if (parameter == null || parameter[0] == null || parameter[1] == null || parameter[2] == null || parameter[3] == null) continue;
            formulaString = parameter[1];
            if (checkMap.containsKey(formulaString)) {
                checkString = formulaString;
                break;
            }
            checkMap.put(formulaString, null);
        }
        try {
            if (!StringUtils.isEmpty(checkString)) {
                throw new BgFormException(BgFormException.EXISTFORMFORMULA, (Object[])new String[]{checkString});
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            checkMap.clear();
        }
    }

    public static void setCellLocked(Sheet sheet, Range range, boolean isLocked) {
        if (sheet == null || range == null) {
            return;
        }
        Cell _cell = null;
        range.setIgnoreProtected(true);
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            for (int rowIndex = block.getRow(); rowIndex <= block.getRow2(); ++rowIndex) {
                for (int colIndex = block.getCol(); colIndex <= block.getCol2(); ++colIndex) {
                    _cell = sheet.getCell(rowIndex, colIndex, false);
                    BgNFSHelper.setCellLocked(_cell, isLocked);
                }
            }
        }
    }

    public static void checkFormulaParaTemplate(String formulaStr, String[] formulaPara) throws EASBizException {
        if (formulaPara == null) {
            throw new BgFormException(BgFormException.ERRORPARAMETER, (Object[])new String[]{formulaStr});
        }
        if (formulaPara.length == 6) {
            if (StringUtils.isEmpty((String)formulaPara[0])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOITEM, (Object[])new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[2])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOELEMENT, (Object[])new String[]{formulaStr});
            }
        } else if (formulaPara.length == 4) {
            if (StringUtils.isEmpty((String)formulaPara[0])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOITEM, (Object[])new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[2])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOELEMENT, (Object[])new String[]{formulaStr});
            }
        }
    }

    public static ITableForPrint.IBlock creatBlock(String str) {
        int delIndex = str.indexOf(":");
        ITableForPrint.IBlock block = null;
        if (delIndex >= 0) {
            block = BgNFSHelper.creatEmptyBlock();
            String s1 = str.substring(0, delIndex);
            String s2 = str.substring(delIndex + 1);
            int[] p1 = BgNFSHelper.parserRowColStr(s1);
            int[] p2 = BgNFSHelper.parserRowColStr(s2);
            block.set(p1[0], p1[1], p2[0], p2[1]);
        }
        return block;
    }

    static int[] parserRowColStr(String str) {
        int[] rowCol = new int[]{-1, -1};
        StringTokenizer oneM = null;
        oneM = new StringTokenizer(str, "$");
        while (oneM.hasMoreElements()) {
            String mStr = oneM.nextToken();
            try {
                rowCol[0] = Integer.parseInt(mStr) - 1;
            }
            catch (NumberFormatException e) {
                rowCol[1] = TablePageSetupModel.getColumnIndexByName((String)mStr);
            }
        }
        return rowCol;
    }

    static ITableForPrint.IBlock creatEmptyBlock() {
        ITableForPrint.IBlock block = new ITableForPrint.IBlock(){
            private int row = -1;
            private int col = -1;
            private int row2 = -1;
            private int col2 = -1;

            public int getCol2() {
                return this.col2;
            }

            public void set(int row, int col, int row2, int col2) {
                this.row = row;
                this.col = col;
                this.row2 = row2;
                this.col2 = col2;
            }

            public int getRow() {
                return this.row;
            }

            public int getCol() {
                return this.col;
            }

            public int getRow2() {
                return this.row2;
            }

            public int getMode() {
                return -1;
            }
        };
        return block;
    }

    public static Map getRowAliasMapInfo(Sheet sheet) {
        HashMap<String, Integer> aliasMap = new HashMap<String, Integer>();
        if (sheet == null) {
            return aliasMap;
        }
        Row row = null;
        String rowId = null;
        Object dataSource = null;
        int rowCount = sheet.getMaxRowIndex();
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            row = sheet.getRow(rowIndex, false);
            if (row == null || !BgNFSHelper.checkHasSign(row)) continue;
            rowId = BgNFSHelper.getRowSign(row);
            dataSource = BgNFSHelper.getRowSource(row);
            if (dataSource == null || !"DATA_SOURCE_TEMPLATE".equals(dataSource) && !"DATA_SOURCE_EDIT".equals(dataSource)) continue;
            aliasMap.put(rowId, new Integer(rowIndex));
        }
        return aliasMap;
    }

    public static Map getColAliasMapInfo(Sheet sheet) {
        HashMap<String, Integer> aliasMap = new HashMap<String, Integer>();
        if (sheet == null) {
            return aliasMap;
        }
        Column column = null;
        String colId = null;
        Object dataSource = null;
        int colCount = sheet.getMaxColIndex();
        for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
            column = sheet.getColumn(colIndex, false);
            if (column == null || !BgNFSHelper.checkHasSign(column)) continue;
            colId = BgNFSHelper.getColSign(column);
            dataSource = BgNFSHelper.getColSource(column);
            if (dataSource == null || !"DATA_SOURCE_TEMPLATE".equals(dataSource) && !"DATA_SOURCE_EDIT".equals(dataSource)) continue;
            aliasMap.put(colId, new Integer(colIndex));
        }
        return aliasMap;
    }

    public static Map getRowIDMapInfo(Sheet sheet) {
        HashMap<String, Integer> aliasMap = new HashMap<String, Integer>();
        if (sheet == null) {
            return aliasMap;
        }
        Row row = null;
        String rowId = null;
        int rowCount = sheet.getMaxRowIndex();
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            row = sheet.getRow(rowIndex, false);
            if (row == null || !BgNFSHelper.checkHasSign(row)) continue;
            rowId = BgNFSHelper.getRowSign(row);
            aliasMap.put(rowId, new Integer(rowIndex));
        }
        return aliasMap;
    }

    public static Map getColIDMapInfo(Sheet sheet) {
        HashMap<String, Integer> aliasMap = new HashMap<String, Integer>();
        if (sheet == null) {
            return aliasMap;
        }
        Column column = null;
        String colId = null;
        int colCount = sheet.getMaxColIndex();
        for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
            column = sheet.getColumn(colIndex, false);
            if (column == null || !BgNFSHelper.checkHasSign(column)) continue;
            colId = BgNFSHelper.getColSign(column);
            aliasMap.put(colId, new Integer(colIndex));
        }
        return aliasMap;
    }

    public static List getIsNotEnumerateOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(4));
        if (!BgParamCHelper.isProtectionRowAndCol()) {
            sheetOperation.add(new Integer(8));
            sheetOperation.add(new Integer(16));
        }
        sheetOperation.add(new Integer(32768));
        sheetOperation.add(new Integer(65536));
        sheetOperation.add(new Integer(8192));
        return sheetOperation;
    }

    public static List getIsEnumerateOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(4));
        if (!BgParamCHelper.isProtectionRowAndCol()) {
            sheetOperation.add(new Integer(8));
            sheetOperation.add(new Integer(16));
        }
        sheetOperation.add(new Integer(64));
        sheetOperation.add(new Integer(128));
        sheetOperation.add(new Integer(512));
        sheetOperation.add(new Integer(65536));
        sheetOperation.add(new Integer(8192));
        sheetOperation.add(new Integer(16384));
        sheetOperation.add(new Integer(32768));
        sheetOperation.add(new Integer(4096));
        return sheetOperation;
    }

    public static void setIsWorkFlowUpdateCellLocked(Book book, boolean isLocked) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        boolean _isLockOfOpen = BgParamCHelper.isLockedOfOpen();
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        Object obj = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            StyleAttributes sa = Styles.getEmptySA();
            sa.setLocked(isLocked);
            Range range = null;
            StyleAttributes sa2 = Styles.getEmptySA();
            sa2.setLocked(true);
            Range range2 = null;
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (_cell != null && (BgNFSHelper.checkHasExpression(_cell) || BgNFSHelper.checkHasFormulaOfCell(_cell))) {
                        if (isLocked) {
                            if (!_cell.isLocked()) {
                                if (range == null) {
                                    range = _cell.getSheet().getRange(_cell);
                                } else {
                                    range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                                }
                            }
                        } else if (!(!_cell.isLocked() || BgNFSHelper.checkHasCertificate(_cell) || _isLockOfOpen && _cell.hasFormula())) {
                            if (range == null) {
                                range = _cell.getSheet().getRange(_cell);
                            } else {
                                range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                            }
                        }
                        if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                        if (range2 == null) {
                            range2 = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range2.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (_cell != null && (_cell.getValue() == Variant.nullVariant || "".equals(_cell.getValue().toString().trim()))) {
                        if (range == null) {
                            range = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (_cell == null) continue;
                    obj = BgNFSHelper.getCellExtData(_cell, "CELL_LOCK");
                    boolean cellIsLock = obj instanceof String && BgNConstants.FALSE_UPDATE.equals((String)obj);
                    boolean isUserEdit = BgNFSHelper.isUserEditBgFormCell(_cell);
                    if (cellIsLock) {
                        if (range2 == null) {
                            range2 = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range2.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (isUserEdit) {
                        if (range == null) {
                            range = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (range2 == null) {
                        range2 = _cell.getSheet().getRange(_cell);
                        continue;
                    }
                    range2.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                }
            }
            if (range != null) {
                range.setIgnoreProtected(true);
                range.setStyle(sa, Styles.getEmptySA());
            }
            if (range2 == null) continue;
            range2.setIgnoreProtected(true);
            range2.setStyle(sa2, Styles.getEmptySA());
        }
    }

    public static void setIsNotEnumerateCellLocked(Book book, boolean isLocked) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        boolean _isLockOfOpen = BgParamCHelper.isLockedOfOpen();
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        Object obj = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            StyleAttributes sa = Styles.getEmptySA();
            sa.setLocked(isLocked);
            Range range = null;
            StyleAttributes sa2 = Styles.getEmptySA();
            sa2.setLocked(true);
            Range range2 = null;
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    obj = BgNFSHelper.getCellExtData(_cell, "CELL_LOCK");
                    if (_cell != null && (BgNFSHelper.checkHasExpression(_cell) || BgNFSHelper.checkHasFormulaOfCell(_cell))) {
                        if (isLocked) {
                            if (_cell.isLocked()) continue;
                            if (range == null) {
                                range = _cell.getSheet().getRange(_cell);
                                continue;
                            }
                            range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                            continue;
                        }
                        if (!_cell.isLocked() || BgNFSHelper.checkHasCertificate(_cell)) continue;
                        if (_isLockOfOpen && _cell.hasFormula()) {
                            if (range2 == null) {
                                range2 = _cell.getSheet().getRange(_cell);
                                continue;
                            }
                            range2.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                            continue;
                        }
                        if (BgNFSHelper.checkHasFormulaOfCell(_cell) && BgNConstants.FALSE_UPDATE.equals(obj)) continue;
                        if (range == null) {
                            range = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (_cell != null && (_cell.getValue() == Variant.nullVariant || "".equals(_cell.getValue().toString().trim()))) {
                        if (range == null) {
                            range = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (_cell == null) continue;
                    obj = BgNFSHelper.getCellExtData(_cell, "CELL_LOCK");
                    boolean cellIsLock = obj instanceof String && BgNConstants.FALSE_UPDATE.equals((String)obj);
                    boolean isUserEdit = BgNFSHelper.isUserEditBgFormCell(_cell);
                    if (cellIsLock) {
                        if (range2 == null) {
                            range2 = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range2.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (isUserEdit) {
                        if (range == null) {
                            range = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (range2 == null) {
                        range2 = _cell.getSheet().getRange(_cell);
                        continue;
                    }
                    range2.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                }
            }
            if (range != null) {
                range.setIgnoreProtected(true);
                range.setStyle(sa, Styles.getEmptySA());
            }
            if (range2 == null) continue;
            range2.setIgnoreProtected(true);
            range2.setStyle(sa2, Styles.getEmptySA());
        }
    }

    public static boolean isUserEditBgFormCell(Cell _cell) {
        if (_cell == null) {
            return false;
        }
        Object colObj = null;
        Object rowObj = null;
        colObj = BgNFSHelper.getColSource(_cell.getSheet().getColumn(_cell.getCol(), false));
        rowObj = BgNFSHelper.getRowSource(_cell.getSheet().getRow(_cell.getRow(), false));
        Object obj = null;
        obj = BgNFSHelper.getCellData(_cell, "USER_EIDT");
        if (obj instanceof String && Boolean.TRUE.toString().equals((String)obj)) {
            return true;
        }
        if (colObj instanceof String && "DATA_SOURCE_EDIT".equals((String)colObj)) {
            return true;
        }
        return rowObj instanceof String && "DATA_SOURCE_EDIT".equals((String)rowObj);
    }

    public static String outTime(long startTime, long beginTime, long endTime) {
        return new StringBuffer("invoke process use = ").append(endTime - beginTime).append(" ms; alluse = ").append(endTime - startTime).append(" ms;").toString();
    }

    public static void setNumberExpandInfo(Cell cell, NumberExpandInfo expandInfo) {
        if (cell == null) {
            return;
        }
        cell.setUserObject("NEId", (Object)expandInfo.getId());
        cell.setUserObject("NEName", (Object)expandInfo.getName());
        cell.setUserObject("NENum", (Object)expandInfo.getNumber());
        cell.setUserObject("NELNum", (Object)expandInfo.getLongNumber());
        cell.setUserObject("NELevel", (Object)new Integer(expandInfo.getLevel()));
        cell.setUserObject("NELeaf", (Object)new Boolean(expandInfo.isLeaf()));
        cell.setUserObject("NEStatus", (Object)new Boolean(expandInfo.isExpandStatus()));
        cell.setUserObject("NECol", (Object)new Boolean(expandInfo.isCollect()));
        BgNFSHelper.setValue(cell, expandInfo.getName());
    }

    public static void printBookRowSign(Book book) {
    }

    public static Map getFormulaMap(BgFormInfo bgFormInfo) {
        if (bgFormInfo != null) {
            return (Map)bgFormInfo.get("formulaMap_calculate");
        }
        return null;
    }

    public static void setFormulaMap(BgFormInfo bgFormInfo, Map formulaMap) {
        if (bgFormInfo != null) {
            bgFormInfo.put("formulaMap_calculate", (Object)formulaMap);
        }
    }

    public static void clearFormulaMap(BgFormInfo bgFormInfo) {
        if (bgFormInfo != null) {
            bgFormInfo.remove("formulaMap_calculate");
        }
    }

    public static boolean isSimpleExpression(Cell cell, String expressions) {
        return BookFormulaHelper.isExcelFunction((Book)cell.getSheet().getBook(), (Sheet)cell.getSheet(), (String)expressions);
    }

    public static boolean checkIsEmptyRow(Row row, int y, int width) {
        if (row == null) {
            return true;
        }
        Cell _cell = null;
        int in = width;
        for (int i = y; i <= in; ++i) {
            _cell = row.getCell(i, false);
            if (BgNFSHelper.checkIsItemFormulaCell(_cell)) continue;
            return false;
        }
        return true;
    }

    public static String getTemplateKey(Context ctx, BgTemplateInfo temp) {
        if (ctx == null || temp == null) {
            return null;
        }
        return ctx.getAIS() + "_" + ContextUtil.getCurrentUserInfo((Context)ctx).getInvalidationDate() + "_" + temp.getId();
    }

    public static Row addRowWithFreeze(Sheet sheet, int rowIndex) {
        Row r = BgNFSHelper.addRow(sheet, rowIndex);
        ViewSplitInfo vs = sheet.getSheetOption().getViewSplitInfo();
        if (vs != null && vs.isFreezed() && rowIndex < vs.getRowSplit()) {
            vs.setRowSplit(vs.getRowSplit() + 1);
            vs.setFirstRow2(vs.getFirstRow2() + 1);
        }
        return r;
    }

    public static Column addColWithFreeze(Sheet sheet, int colIndex) {
        Column col = BgNFSHelper.addColumn(sheet, colIndex);
        ViewSplitInfo vs = sheet.getSheetOption().getViewSplitInfo();
        if (vs != null && vs.isFreezed() && colIndex < vs.getColSplit()) {
            vs.setColSplit(vs.getColSplit() + 1);
            vs.setFirstCol2(vs.getFirstCol2() + 1);
        }
        return col;
    }

    public static TreeModel getOrgTreeModel(String orgUnitId) throws Exception {
        return BgNFSHelper.getOrgTreeModel(null, orgUnitId);
    }

    public static TreeModel getFullTreeModel(String orgUnitId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        }
        TreeModel tree = BgFormFacadeFactory.getRemoteInstance().getFullTreeModel(orgUnitId, OrgViewType.COSTCENTER);
        BgNFSHelper.setTreeNodeEnable((DefaultKingdeeTreeNode)tree.getRoot(), true);
        return tree;
    }

    public static void setTreeNodeEnable(DefaultKingdeeTreeNode root, boolean isEnable) {
        if (root == null) {
            return;
        }
        Color color = new Color(77, 77, 77);
        if (isEnable) {
            color = Color.BLACK;
        }
        root.setTextColor(color);
        for (int index = 0; index < root.getChildCount(); ++index) {
            DefaultKingdeeTreeNode temp = (DefaultKingdeeTreeNode)root.getChildAt(index);
            temp.setTextColor(color);
            OrgStructureInfo org = (OrgStructureInfo)temp.getUserObject();
            if (org.getUnit().isIsLeaf()) continue;
            BgNFSHelper.setTreeNodeEnable(temp, isEnable);
        }
    }

    public static TreeModel getOrgTreeModel(String orgUnitId, KDTree treeOrgUnit) throws Exception {
        String _tmpStr = null;
        _tmpStr = StringUtils.isEmpty((String)orgUnitId) ? SysContext.getSysContext().getCurrentCostUnit().getId().toString() : orgUnitId;
        TreeModel treeMode = BgNFSHelper.getNewTreeModel(OrgViewType.COSTCENTER, _tmpStr);
        if (treeMode != null && treeOrgUnit != null) {
            treeOrgUnit.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                    try {
                        BgNFSHelper.addChildNode(node);
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((String)"", (Throwable)e1);
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                }
            });
        }
        return treeMode;
    }

    public static void addChildNode(DefaultKingdeeTreeNode node) throws Exception {
        if (node == null) {
            return;
        }
        int childCount = node.getChildCount();
        if (childCount == 1) {
            int index;
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)node.getChildAt(0);
            if (tempNode.getUserObject() != null) {
                return;
            }
            node.removeAllChildren();
            DefaultKingdeeTreeNode tempNode1 = BgNFSHelper.getDefaultKingdeeTreeNode(node, null);
            BgNFSHelper.dealNode(tempNode1);
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            for (index = tempNode1.getChildCount(); index > 0; --index) {
                list.add(tempNode1.getChildAt(index - 1));
            }
            if (!list.isEmpty()) {
                for (index = list.size(); index > 0; --index) {
                    node.add((MutableTreeNode)((DefaultKingdeeTreeNode)list.get(index - 1)));
                }
            }
        }
    }

    private static TreeModel getNewTreeModel(OrgViewType viewType, String orgUnitId) throws Exception {
        if (viewType == null) {
            viewType = OrgViewType.COSTCENTER;
        }
        DefaultTreeModel _model = null;
        IOrgStructure istruct = OrgStructureFactory.getRemoteInstance();
        OrgStructureInfo selectNode = istruct.getOrgStructureInfo("select id, longnumber ,unit.id,unit.number,unit.longnumber,unit.name where unit.id = '" + orgUnitId + "' and tree.id = '" + NewOrgViewHelper.convert2TreeId((OrgViewType)viewType) + "'");
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)selectNode);
        DefaultKingdeeTreeNode node = BgNFSHelper.getDefaultKingdeeTreeNode(rootNode, viewType);
        node.setTextColor(Color.BLACK);
        BgNFSHelper.dealNode(node);
        _model = new DefaultTreeModel((TreeNode)node);
        return _model;
    }

    private static DefaultKingdeeTreeNode getDefaultKingdeeTreeNode(DefaultKingdeeTreeNode rootNode, OrgViewType viewType) throws EASBizException, BOSException {
        if (viewType == null) {
            viewType = OrgViewType.COSTCENTER;
        }
        String treeid = NewOrgViewHelper.convert2TreeId((OrgViewType)viewType);
        return NewOrgViewFacadeFactory.getRemoteInstance().getViewDirectChildNodesByMultiCondition(viewType, treeid, true, true, rootNode, true, true, null, null, null);
    }

    private static void dealNode(DefaultKingdeeTreeNode node) {
        if (node == null || node.getChildCount() == 0) {
            return;
        }
        int count = node.getChildCount();
        DefaultKingdeeTreeNode child = null;
        OrgStructureInfo orginfo = null;
        for (int index = 0; index < count; ++index) {
            child = (DefaultKingdeeTreeNode)node.getChildAt(index);
            child.setTextColor(Color.BLACK);
            orginfo = (OrgStructureInfo)child.getUserObject();
            if (orginfo == null || orginfo.isIsLeaf()) continue;
            child.add((MutableTreeNode)new DefaultKingdeeTreeNode());
        }
    }

    public static TreeModel getOrgTreeModel(OrgViewType viewType, String orgUnitId) throws Exception {
        String _tmpStr = null;
        _tmpStr = StringUtils.isEmpty((String)orgUnitId) ? SysContext.getSysContext().getCurrentCostUnit().getId().toString() : orgUnitId;
        if (BgNFSHelper.checkHasNewOrgInterface()) {
            return BgNFSHelper.getNewOrgTreeModel(viewType, _tmpStr);
        }
        return BgNFSHelper.getOldOrgTreeModel(viewType, _tmpStr);
    }

    private static boolean checkHasNewOrgInterface() {
        boolean re = false;
        Class<?> _class = null;
        Method _method = null;
        try {
            _class = Class.forName("com.kingdee.eas.basedata.org.NewOrgUtils");
            _method = _class.getMethod("getTreeModel", OrgViewType.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, Boolean.TYPE, HashMap.class, Integer.TYPE, Boolean.TYPE, IMetaDataPK.class, IMetaDataPK.class);
            if (_method != null) {
                re = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return re;
    }

    private static TreeModel getOldOrgTreeModel(OrgViewType viewType, String orgUnitId) throws Exception {
        OrgViewType _viewType = viewType;
        if (_viewType == null) {
            _viewType = OrgViewType.COSTCENTER;
        }
        return NewOrgUtils.getTreeModel((OrgViewType)_viewType, null, (boolean)false, (boolean)false, (boolean)false, (String)orgUnitId, (boolean)true, null, (int)0, null, null);
    }

    private static TreeModel getNewOrgTreeModel(OrgViewType viewType, String orgUnitId) throws Exception {
        OrgViewType _viewType = viewType;
        if (_viewType == null) {
            _viewType = OrgViewType.COSTCENTER;
        }
        TreeModel _model = null;
        Class<?> _class = null;
        Method _method = null;
        _class = Class.forName("com.kingdee.eas.basedata.org.NewOrgUtils");
        _method = _class.getMethod("getTreeModel", OrgViewType.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, Boolean.TYPE, HashMap.class, Integer.TYPE, Boolean.TYPE, IMetaDataPK.class, IMetaDataPK.class);
        _model = (TreeModel)_method.invoke(_class, _viewType, null, false, false, false, orgUnitId, true, null, new Integer(0), true, null, null);
        return _model;
    }

    public static FullOrgUnitCollection getOrgPermission(IObjectPK pk) throws Exception {
        if (pk == null) {
            return new FullOrgUnitCollection();
        }
        if (BgNFSHelper.checkHasNewOrgPermissionInterface()) {
            return BgNFSHelper.getNewOrgPermission(pk);
        }
        return BgNFSHelper.getOldOrgPermission(pk);
    }

    public static FullOrgUnitCollection getOrgPermission(Context ctx, IObjectPK pk) throws Exception {
        if (pk == null) {
            return new FullOrgUnitCollection();
        }
        if (BgNFSHelper.checkHasNewOrgPermissionInterface()) {
            return BgNFSHelper.getNewOrgPermission(ctx, pk);
        }
        return BgNFSHelper.getOldOrgPermission(ctx, pk);
    }

    private static boolean checkHasNewOrgPermissionInterface() {
        boolean re = false;
        Class<?> _class = null;
        Method _method = null;
        try {
            _class = Class.forName("com.kingdee.eas.basedata.org.OrgSwitchFacade");
            _method = _class.getMethod("getSimpleOrgRanges", IObjectPK.class);
            if (_method != null) {
                re = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return re;
    }

    private static FullOrgUnitCollection getOldOrgPermission(IObjectPK pk) throws Exception {
        return PermissionFactory.getRemoteInstance().getOrgRanges(pk);
    }

    private static FullOrgUnitCollection getOldOrgPermission(Context ctx, IObjectPK pk) throws Exception {
        return PermissionFactory.getLocalInstance((Context)ctx).getOrgRanges(pk);
    }

    private static FullOrgUnitCollection getNewOrgPermission(IObjectPK pk) throws Exception {
        Class<?> _class = null;
        Method _method = null;
        Object _obj = null;
        FullOrgUnitCollection unitCollection = null;
        _class = Class.forName("com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory");
        _method = _class.getMethod("getRemoteInstance", null);
        if (_method != null) {
            _obj = _method.invoke(_class, null);
            _method = _obj.getClass().getMethod("getSimpleOrgRanges", IObjectPK.class);
            if (_method != null) {
                unitCollection = (FullOrgUnitCollection)_method.invoke(_obj, pk);
            }
        }
        if (unitCollection == null) {
            unitCollection = new FullOrgUnitCollection();
        }
        return unitCollection;
    }

    private static FullOrgUnitCollection getNewOrgPermission(Context ctx, IObjectPK pk) throws Exception {
        Class<?> _class = null;
        Method _method = null;
        Object _obj = null;
        FullOrgUnitCollection unitCollection = null;
        _class = Class.forName("com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory");
        _method = _class.getMethod("getLocalInstance", Context.class);
        if (_method != null) {
            _obj = _method.invoke(_class, ctx);
            _method = _obj.getClass().getMethod("getSimpleOrgRanges", IObjectPK.class);
            if (_method != null) {
                unitCollection = (FullOrgUnitCollection)_method.invoke(_obj, pk);
            }
        }
        if (unitCollection == null) {
            unitCollection = new FullOrgUnitCollection();
        }
        return unitCollection;
    }

    public static String getBgFormName(BgFormInfo bgFormInfo, int maxLength) {
        String bgFormName = null;
        bgFormName = bgFormInfo.getCU().getId().equals((Object)bgFormInfo.getOrgUnit().getId()) || StringUtils.isEmpty((String)bgFormInfo.getCU().getName()) ? new StringBuffer(bgFormInfo.getOrgUnit().getName()).append("-").append(bgFormInfo.getBgPeriod().getName()).append("-").append(bgFormInfo.getBgTemplate().getName()).toString().trim() : new StringBuffer(bgFormInfo.getCU().getName()).append("-").append(bgFormInfo.getOrgUnit().getName()).append("-").append(bgFormInfo.getBgPeriod().getName()).append("-").append(bgFormInfo.getBgTemplate().getName()).toString().trim();
        return bgFormName.length() > maxLength ? bgFormName.substring(1, maxLength) : bgFormName;
    }

    public static void gatherResult(Map<Parameter, List<Parameter>> sumExpMap) {
        if (sumExpMap == null || sumExpMap.isEmpty()) {
            return;
        }
        Parameter parameter = null;
        Parameter tmpParam = null;
        BigDecimal value = null;
        Map.Entry<Parameter, List<Parameter>> entry2 = null;
        List<Parameter> sumList = null;
        for (Map.Entry<Parameter, List<Parameter>> entry2 : sumExpMap.entrySet()) {
            parameter = entry2.getKey();
            sumList = entry2.getValue();
            value = BgConstants.ZERO;
            int in = sumList.size();
            for (int i = 0; i < in; ++i) {
                tmpParam = sumList.get(i);
                if (!(tmpParam.getValue() instanceof BigDecimal)) continue;
                value = value.add((BigDecimal)tmpParam.getValue());
            }
            parameter.setValue((Object)value);
        }
    }

    public static boolean isHasHideRowOrCol(Book book) {
        if (book == null) {
            return false;
        }
        boolean isHasHide = false;
        block0: for (int n = 0; n < book.getSheetCount() && !isHasHide; ++n) {
            Sheet sheet = book.getSheet(n);
            int maxRow = sheet.getMaxRowIndex() + 1;
            int maxCol = sheet.getMaxColIndex() + 1;
            for (int row = 0; row < maxRow; ++row) {
                if (!BgNFSHelper.isHided(sheet.getRow(row, false))) continue;
                isHasHide = true;
                break;
            }
            for (int col = 0; col < maxCol && !isHasHide; ++col) {
                if (!BgNFSHelper.isHided(sheet.getColumn(col, false))) continue;
                isHasHide = true;
                continue block0;
            }
        }
        return isHasHide;
    }

    public static void synchronizeHideRowOrCol(Sheet templateSheet, Sheet updateSheet) {
        if (templateSheet == null || updateSheet == null) {
            return;
        }
        Map superMap = BgNFSHelper.getRowIDMapInfo(templateSheet);
        Map childMap = BgNFSHelper.getRowIDMapInfo(updateSheet);
        Row superRow = null;
        Row childRow = null;
        Iterator it = superMap.keySet().iterator();
        while (it.hasNext()) {
            String rowId = it.next().toString();
            superRow = templateSheet.getRow(new Integer(superMap.get(rowId).toString()).intValue(), false);
            if (!childMap.containsKey(rowId)) continue;
            childRow = updateSheet.getRow(new Integer(childMap.get(rowId).toString()).intValue(), false);
            BgNFSHelper.setRowHide(superRow, childRow);
        }
        Map superColMap = BgNFSHelper.getColIDMapInfo(templateSheet);
        Map childColMap = BgNFSHelper.getColIDMapInfo(updateSheet);
        Column superCol = null;
        Column childCol = null;
        Iterator it2 = superColMap.keySet().iterator();
        while (it2.hasNext()) {
            String colId = it2.next().toString();
            superCol = templateSheet.getColumn(new Integer(superColMap.get(colId).toString()).intValue(), false);
            if (!childColMap.containsKey(colId)) continue;
            childCol = updateSheet.getColumn(new Integer(childColMap.get(colId).toString()).intValue(), false);
            BgNFSHelper.setColHide(superCol, childCol);
        }
    }

    private static void setColHide(Column superCol, Column childCol) {
        if (superCol == null || childCol == null) {
            return;
        }
        if (BgNFSHelper.isHided(superCol)) {
            BgNFSHelper.setHided(childCol, true);
        } else {
            BgNFSHelper.setHided(childCol, false);
        }
    }

    private static void setRowHide(Row superRow, Row childRow) {
        if (superRow == null || childRow == null) {
            return;
        }
        if (BgNFSHelper.isHided(superRow)) {
            BgNFSHelper.setHided(childRow, true);
        } else {
            BgNFSHelper.setHided(childRow, false);
        }
    }

    public static void dealNewAndOldParameter(SortedParameterArray newParamter, SortedParameterArray oldParameter) {
        if (newParamter == null || oldParameter == null) {
            return;
        }
        Parameter parameter = null;
        Parameter tempParameter = null;
        BigDecimal value = BgConstants.BIGZERO;
        int in = oldParameter.size();
        for (int i = 0; i < in; ++i) {
            value = BgConstants.BIGZERO;
            parameter = oldParameter.getParameter(i);
            Integer UID = parameter.getUID();
            for (int n = 0; n < newParamter.size(); ++n) {
                tempParameter = newParamter.getParameter(n);
                if (!tempParameter.getUID().equals(UID) || !(tempParameter.getValue() instanceof BigDecimal)) continue;
                value = value.add((BigDecimal)tempParameter.getValue());
            }
            parameter.setValue((Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getRefField(Context ctx, Map bgItemMap, String orgUnitId) throws BOSException {
        if (ctx == null || bgItemMap == null || orgUnitId == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rst = null;
        int GROUPSIZE = 50;
        Vector strVec = new Vector();
        List<String> _tmpList = new ArrayList<String>();
        for (String number : bgItemMap.keySet()) {
            _tmpList.add(number);
            if (_tmpList.size() < GROUPSIZE) continue;
            strVec.add(_tmpList);
            _tmpList = new ArrayList();
        }
        if (_tmpList.size() > 0) {
            strVec.add(_tmpList);
            int kn = GROUPSIZE - _tmpList.size();
            for (int k = 0; k < kn; ++k) {
                _tmpList.add("#");
            }
        }
        try {
            String _orgUnitId = BgSHelper.getIsolateOrg((Context)ctx, (String)orgUnitId);
            String sql = "select fnumber, freffield from t_bg_bgItem where fnumber in (" + BgNSQLHelper.getParamSizeString(GROUPSIZE) + ") and FOrgUnitId = ?";
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < strVec.size(); ++i) {
                _tmpList = (List)strVec.get(i);
                _tmpList.add(_orgUnitId);
                BgNSQLHelper.setParams(ps, _tmpList);
                try {
                    rst = ps.executeQuery();
                    while (rst.next()) {
                        bgItemMap.put(rst.getString(1), rst.getString(2));
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)ps, (Connection)conn);
    }

    public static Set getFinanceOrgID(Set costCenterOrgIds) throws BOSException {
        if (costCenterOrgIds == null || costCenterOrgIds.isEmpty()) {
            return null;
        }
        HashSet<String> ids = new HashSet<String>();
        ICostCenterOrgUnit iCost = CostCenterOrgUnitFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo(EntryFilterType.NORMAL);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)costCenterOrgIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isCompanyOrgUnit", (Object)1, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longNumber");
        view.setSelector(sic);
        view.setFilter(filter);
        CostCenterOrgUnitCollection costs = iCost.getCostCenterOrgUnitCollection(view);
        for (int index = 0; index < costs.size(); ++index) {
            ids.add(costs.get(index).getId().toString());
        }
        return ids;
    }

    public static void getAllCostCenterIDs(Set costIDSet, DefaultKingdeeTreeNode node) {
        OrgStructureInfo oui;
        if (node == null) {
            return;
        }
        if (costIDSet == null) {
            costIDSet = new HashSet<String>();
        }
        if ((oui = (OrgStructureInfo)node.getUserObject()).getUnit() != null) {
            costIDSet.add(oui.getUnit().getId().toString());
        }
        Enumeration child = node.children();
        while (child.hasMoreElements()) {
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)child.nextElement();
            if (!(tempNode.getUserObject() instanceof OrgStructureInfo)) continue;
            oui = (OrgStructureInfo)tempNode.getUserObject();
            if (oui.getUnit() != null) {
                costIDSet.add(oui.getUnit().getId().toString());
            }
            if (tempNode.isLeaf()) continue;
            BgNFSHelper.getAllCostCenterIDs(costIDSet, tempNode);
        }
    }

    public static void setTableSort(KDTMouseEvent e, KDTable table) {
        if (e == null || table == null) {
            return;
        }
        if (e.getType() == 0 && e.getClickCount() == 1) {
            String key;
            HashMap<String, Integer> map;
            int colIndex = e.getColIndex();
            KDTSortManager sort = table.getSortMange();
            if (sort == null) {
                sort = new KDTSortManager(table);
            }
            IColumn col = table.getColumn(colIndex);
            int sortType = 0;
            if (col.getUserObject() instanceof Map) {
                map = (HashMap<String, Integer>)col.getUserObject();
                if (map != null && !map.isEmpty()) {
                    sortType = Integer.parseInt(map.get("sortType").toString());
                    sortType = 0 == sortType ? 1 : 0;
                    map.clear();
                    map.put("sortType", sortType);
                }
                col.setUserObject(map);
            } else {
                map = new HashMap<String, Integer>();
                map.put("sortType", sortType);
                col.setUserObject(map);
            }
            sort.sort(colIndex, sortType);
            if (table == null || table.getRowCount() < 1) {
                return;
            }
            int rowCount = table.getRowCount();
            HashMap<String, IRow> valueMap = new HashMap<String, IRow>();
            ArrayList<String> keyList = new ArrayList<String>();
            for (int index = 0; index < table.getRowCount(); ++index) {
                IRow row = table.getRow(index);
                key = (row.getCell(colIndex).getValue() == null ? "" : row.getCell(colIndex).getValue().toString()) + "_" + index;
                keyList.add(key);
                valueMap.put(key, row);
            }
            if (keyList == null || keyList.isEmpty()) {
                return;
            }
            Collections.sort(keyList);
            table.removeRows();
            if (0 == sortType) {
                for (int k = 0; k < keyList.size(); ++k) {
                    key = keyList.get(k).toString();
                    if (!valueMap.containsKey(key)) continue;
                    table.addRow(k, (IRow)valueMap.get(key));
                }
            } else {
                int n = 0;
                for (int k = keyList.size() - 1; k >= 0; --k) {
                    key = keyList.get(k).toString();
                    if (!valueMap.containsKey(key)) continue;
                    table.addRow(n, (IRow)valueMap.get(key));
                    ++n;
                }
            }
            keyList.clear();
            valueMap.clear();
            table.setRowCount(rowCount);
            table.setRefresh(true);
            table.reLayoutAndPaint();
        }
    }

    public static void copyBeforeRowExcelFunction(Book book, Sheet sheet, Row row, Row beforeRow) {
        Cell cell = null;
        Cell beforeCell = null;
        if (row != null && beforeRow != null) {
            BgNFSHelper.disableCal(book);
            BgNFSHelper.disableUndo(book);
            for (int colIndex = 0; colIndex < sheet.getMaxColIndex(); ++colIndex) {
                beforeCell = beforeRow.getCell(colIndex, false);
                if (!BgNFSHelper.checkHasExpression(beforeCell) || !BookFormulaHelper.isExcelFunction((Book)book, (Sheet)sheet, (String)BgNFSHelper.getExpression(beforeCell))) continue;
                cell = row.getCell(colIndex, true);
                BgNFSHelper.copyFormula(sheet, cell, beforeCell);
            }
            BgNFSHelper.enableCal(book);
            BgNFSHelper.enableUndo(book);
        }
    }

    public static void copyFormula(Sheet sheet, Cell dstCell, Cell srcCell) {
        Range srcRange = sheet.getRange(srcCell.getRow(), srcCell.getCol(), srcCell.getRow(), srcCell.getCol());
        srcRange.select();
        srcRange.copy();
        Range desRange = sheet.getRange(dstCell.getRow(), dstCell.getCol(), dstCell.getRow(), dstCell.getCol());
        desRange.paste(PasteMode.FORMULAS);
    }

    public static void setEnumItemAreaCellsLocked(Book book, Map<String, List<Cell>> enumAreaCellMap) {
        UserObject areaObject;
        UserObject userObject = areaObject = book == null ? null : book.getUserObject("EnumerAteArea");
        if (enumAreaCellMap == null || enumAreaCellMap.isEmpty() || areaObject == null) {
            return;
        }
        Map areaMap = (Map)BgAnalyseHelper.getObject((byte[])Base64.decode((String)((String)areaObject.getValue())));
        UserObject cellObj = null;
        Map enumArea = new HashMap();
        Map selMap = null;
        Map item = null;
        String sheetID = null;
        String objKey = null;
        String itemArea = null;
        List<Cell> cellList = null;
        Sheet sheet = null;
        BgEnumerateInfo info = null;
        ITableForPrint.IBlock block = null;
        Range range = null;
        for (Map.Entry<String, List<Cell>> entry : enumAreaCellMap.entrySet()) {
            StyleAttributes sa;
            Range lockRange = null;
            Range unLockRange = null;
            sheetID = entry.getKey();
            cellList = entry.getValue();
            sheet = book.getSheetByID(sheetID);
            for (Cell cell : cellList) {
                boolean isCurCellEnumerate = false;
                cellObj = cell.getUserObject("BeginCell");
                objKey = (String)cellObj.getValue();
                enumArea = (Map)areaMap.get(sheetID);
                Map map = selMap = enumArea == null ? null : (Map)enumArea.get(objKey);
                if (selMap != null && !EmptyUtil.isEmpty((Object)(item = (info = new BgEnumerateInfo(selMap, sheet, true, true)).getItemArea()))) {
                    Iterator iteItem = item.keySet().iterator();
                    while (iteItem.hasNext()) {
                        itemArea = iteItem.next().toString();
                        block = BgEnumerateHelper.creatBlock(itemArea);
                        range = sheet.getRange(block.getRow(), block.getCol(), block.getRow2(), block.getCol2());
                        if (lockRange == null) {
                            lockRange = cell.getSheet().getRange(cell);
                        }
                        if (range.contains(cell.getSheet().getRange(cell).getBlock(0))) {
                            isCurCellEnumerate = true;
                        }
                        BgNFSHelper.setCellLocked(sheet, range, true, true, lockRange);
                    }
                }
                if (BgNFSHelper.isLockOfCell(cell) || isCurCellEnumerate) continue;
                if (unLockRange == null) {
                    unLockRange = cell.getSheet().getRange(cell);
                    continue;
                }
                unLockRange.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
            }
            if (lockRange != null) {
                sa = Styles.getEmptySA();
                sa.setLocked(true);
                if (lockRange != null) {
                    lockRange.setIgnoreProtected(true);
                    lockRange.setStyle(sa, Styles.getEmptySA());
                }
            }
            if (unLockRange == null) continue;
            sa = Styles.getEmptySA();
            sa.setLocked(false);
            if (unLockRange == null) continue;
            unLockRange.setIgnoreProtected(true);
            unLockRange.setStyle(sa, Styles.getEmptySA());
        }
    }

    public static void setCellLocked(Sheet sheet, Range range, boolean isLocked, boolean bCreateIfEmpty, Range lockRange) {
        if (sheet == null || range == null) {
            return;
        }
        Cell _cell = null;
        range.setIgnoreProtected(true);
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            for (int rowIndex = block.getRow(); rowIndex <= block.getRow2(); ++rowIndex) {
                for (int colIndex = block.getCol(); colIndex <= block.getCol2(); ++colIndex) {
                    _cell = sheet.getCell(rowIndex, colIndex, bCreateIfEmpty);
                    if (isLocked) {
                        lockRange.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (!BgNFSHelper.isLockOfCell(_cell)) continue;
                    BgNFSHelper.setLockOfCell(_cell, isLocked);
                }
            }
        }
    }

    public static Map getEnumCellsMap(Book book) {
        HashMap enumAreaCellMap = new HashMap();
        if (book == null) {
            return enumAreaCellMap;
        }
        Sheet sheet = null;
        Cell cell = null;
        String sheetID = null;
        List<Cell> enumAreaCellList = null;
        UserObject obj = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheet = book.getSheet(i);
            if (sheet == null) continue;
            for (int j = 0; j < sheet.getMaxRowIndex() + 1; ++j) {
                for (int m = 0; m < sheet.getMaxColIndex() + 1; ++m) {
                    cell = sheet.getCell(j, m, false);
                    UserObject userObject = obj = cell == null ? null : cell.getUserObject("BeginCell");
                    if (obj == null || !(obj.getValue() instanceof String)) continue;
                    sheetID = cell.getSheet().getID();
                    if (enumAreaCellMap.containsKey(sheetID)) {
                        enumAreaCellList = (List)enumAreaCellMap.get(sheetID);
                        enumAreaCellList.add(cell);
                        continue;
                    }
                    enumAreaCellList = new ArrayList();
                    enumAreaCellList.add(cell);
                    enumAreaCellMap.put(sheetID, enumAreaCellList);
                }
            }
        }
        return enumAreaCellMap;
    }

    public static void stopBookProtection(Book book) {
        if (book == null) {
            return;
        }
        BookProtection pro = book.getProtection();
        if (pro.isProtected()) {
            pro.stop("");
        }
        if (pro.isProtected()) {
            pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
        }
        pro.deleteOperations();
    }

    public static void stopSheetProtection(SheetOption sheetOption) {
        if (sheetOption == null) {
            return;
        }
        Protection pro = sheetOption.getProtection(false);
        if (pro.isProtected()) {
            pro.stop("");
        }
        if (pro.isProtected()) {
            pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
        }
        pro.deleteOperations();
    }
}

