/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.StringEnum;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class BgNPeriodHelper {
    public static final String MATCH_STR = "\\-?\\d+";
    public static final String DAY_VALUE = "day";
    public static final String MONTH_VALUE = "month";
    public static final String WEEK_VALUE = "week";
    public static final String SEASON_VALUE = "season";
    public static final String HALFYEAR_VALUE = "halfYear";
    public static final String YEAR_VALUE = "year";

    public static String getPeriodNum(Date date, BgPeriodEnum periodType) {
        String periodNum = "";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (periodType.getValue() == 1) {
            periodNum = BgNPeriodHelper.createNewYearBgPeriodNumber(calendar.get(1), 0, false);
        } else if (periodType.getValue() == 2) {
            periodNum = BgNPeriodHelper.createNewHalfYearBgPeriodNumber(calendar.get(1), calendar.get(2) + 1 > 7 ? 0 : 1, 0, false);
        } else if (periodType.getValue() == 3) {
            int month = calendar.get(2) + 1;
            int quarter = 0;
            if (month <= 3) {
                quarter = 0;
            } else if (month <= 6) {
                quarter = 1;
            } else if (month <= 9) {
                quarter = 2;
            } else if (month <= 12) {
                quarter = 3;
            }
            periodNum = BgNPeriodHelper.createNewQuarterBgPeriodNumber(calendar.get(1), quarter, 0, false);
        } else if (periodType.getValue() == 4) {
            periodNum = BgNPeriodHelper.createNewMonthBgPeriodNumber(calendar.get(1), calendar.get(2) + 1, 0, false);
        } else if (periodType.getValue() == 9) {
            int day = calendar.get(5);
            int tendays = 0;
            tendays = day <= 10 ? 0 : (day <= 20 ? 1 : 2);
            periodNum = BgNPeriodHelper.createNewTenDaysBgPeriodNumber(calendar.get(1), calendar.get(2) + 1, tendays, 0, false);
        }
        return periodNum;
    }

    public static String getOffsetBgPeriodNumber(String ccbgPeriodNumber, int offset) {
        if (StringUtils.isEmpty((String)ccbgPeriodNumber)) {
            return BgNPeriodHelper.getCcbgPeriodNumber();
        }
        if (offset == 0) {
            return ccbgPeriodNumber;
        }
        offset = offset < -100 ? -100 : offset;
        offset = offset > 100 ? 100 : offset;
        String _offsetBgPeriodNumber = ccbgPeriodNumber;
        String[] parameter = null;
        parameter = ccbgPeriodNumber.split("\\.");
        if (parameter != null) {
            switch (parameter.length) {
                case 1: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkOneLevelNumber(parameter, offset, false);
                    break;
                }
                case 2: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkTwoLevelNumber(parameter, offset, false);
                    break;
                }
                case 3: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkThreeLevelNumber(parameter, offset, false);
                    break;
                }
            }
        }
        return _offsetBgPeriodNumber;
    }

    public static String getOffsetBgPeriodNumberForExpression(String ccbgPeriodNumber, int offset) {
        if (StringUtils.isEmpty((String)ccbgPeriodNumber)) {
            return BgNPeriodHelper.getCcbgPeriodNumber();
        }
        if (offset == 0) {
            return ccbgPeriodNumber;
        }
        if (offset < 0) {
            return BgNPeriodHelper.getOffsetBgPeriodNumber(ccbgPeriodNumber, offset);
        }
        String _offsetBgPeriodNumber = ccbgPeriodNumber;
        String[] parameter = null;
        parameter = ccbgPeriodNumber.split("\\.");
        if (parameter != null) {
            switch (parameter.length) {
                case 1: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkOneLevelNumber(parameter, offset, true);
                    break;
                }
                case 2: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkTwoLevelNumber(parameter, offset, true);
                    break;
                }
                case 3: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkThreeLevelNumber(parameter, offset, true);
                    break;
                }
            }
        }
        return _offsetBgPeriodNumber;
    }

    public static String getOffsetBgPeriodNumberForYear(String ccbgPeriodNumber, int offset) {
        if (StringUtils.isEmpty((String)ccbgPeriodNumber)) {
            return BgNPeriodHelper.getCcbgPeriodNumber();
        }
        if (offset == 0) {
            return ccbgPeriodNumber;
        }
        offset = offset < -100 ? -100 : offset;
        offset = offset > 100 ? 100 : offset;
        String _offsetBgPeriodNumber = ccbgPeriodNumber;
        String[] parameter = null;
        parameter = ccbgPeriodNumber.split("\\.");
        if (parameter != null) {
            _offsetBgPeriodNumber = BgNPeriodHelper.checkOneLevelNumber(parameter, offset, false);
        }
        String newPeriod = _offsetBgPeriodNumber;
        for (int i = 1; i < parameter.length; ++i) {
            newPeriod = newPeriod + "." + parameter[i];
        }
        return newPeriod;
    }

    private static String getCcbgPeriodNumber() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        return String.valueOf(calendar.get(1)) + "Y";
    }

    private static String checkOneLevelNumber(String[] parameter, int offset, boolean isExpression) {
        String _oneNumber = parameter[0];
        String _code = "";
        if (_oneNumber.length() >= 5) {
            _code = _oneNumber.substring(4);
        }
        String _bgPeriodNumber = _oneNumber;
        if ("Y".equals(_code) && Pattern.matches("[\\d]{4}Y", _bgPeriodNumber)) {
            int year = new Integer(_oneNumber.substring(0, 4));
            _bgPeriodNumber = BgNPeriodHelper.createNewYearBgPeriodNumber(year, offset, isExpression);
        }
        return _bgPeriodNumber;
    }

    private static String checkTwoLevelNumber(String[] parameter, int offset, boolean isExpression) {
        String _oneNumber = parameter[0];
        String _twoNumber = parameter[1];
        String _code = "";
        if (_twoNumber.length() >= 3) {
            _code = _twoNumber.substring(2);
        }
        String _bgPeriodNumber = _oneNumber + "." + _twoNumber;
        if ("HY".equals(_code)) {
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}HY", _bgPeriodNumber)) {
                int year = new Integer(_oneNumber.substring(0, 4));
                int halfYear = new Integer(_twoNumber.substring(0, 2));
                _bgPeriodNumber = BgNPeriodHelper.createNewHalfYearBgPeriodNumber(year, halfYear, offset, isExpression);
            }
        } else if ("Q".equals(_code)) {
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}Q", _bgPeriodNumber)) {
                int year = new Integer(_oneNumber.substring(0, 4));
                int quarter = new Integer(_twoNumber.substring(0, 2));
                _bgPeriodNumber = BgNPeriodHelper.createNewQuarterBgPeriodNumber(year, quarter, offset, isExpression);
            }
        } else if ("M".equals(_code)) {
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M", _bgPeriodNumber)) {
                int year = new Integer(_oneNumber.substring(0, 4));
                int month = new Integer(_twoNumber.substring(0, 2));
                _bgPeriodNumber = BgNPeriodHelper.createNewMonthBgPeriodNumber(year, month, offset, isExpression);
            }
        } else if ("W".equals(_code) && Pattern.matches("[\\d]{4}Y.[\\d]{2}W", _bgPeriodNumber)) {
            int year = new Integer(_oneNumber.substring(0, 4));
            int week = new Integer(_twoNumber.substring(0, 2));
            _bgPeriodNumber = BgNPeriodHelper.createNewYearWeekBgPeriodNumber(year, week, offset, isExpression);
        }
        return _bgPeriodNumber;
    }

    private static String checkThreeLevelNumber(String[] parameter, int offset, boolean isExpression) {
        String _oneNumber = parameter[0];
        String _twoNumber = parameter[1];
        String _threeNumber = parameter[2];
        String _code = "";
        if (_threeNumber.length() >= 3) {
            _code = _threeNumber.substring(2);
        }
        String _bgPeriodNumber = _oneNumber + "." + _twoNumber + "." + _threeNumber;
        if ("D".equals(_code)) {
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}D", _bgPeriodNumber)) {
                int year = new Integer(_oneNumber.substring(0, 4));
                int month = new Integer(_twoNumber.substring(0, 2));
                int day = new Integer(_threeNumber.substring(0, 2));
                _bgPeriodNumber = BgNPeriodHelper.createNewDayBgPeriodNumber(year, month, day, offset, isExpression);
            }
        } else if ("TD".equals(_code)) {
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}TD", _bgPeriodNumber)) {
                int year = new Integer(_oneNumber.substring(0, 4));
                int month = new Integer(_twoNumber.substring(0, 2));
                int tendays = new Integer(_threeNumber.substring(0, 2));
                _bgPeriodNumber = BgNPeriodHelper.createNewTenDaysBgPeriodNumber(year, month, tendays, offset, isExpression);
            }
        } else if ("MW".equals(_code) && Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}MW", _bgPeriodNumber)) {
            int year = new Integer(_oneNumber.substring(0, 4));
            int month = new Integer(_twoNumber.substring(0, 2));
            int week = new Integer(_threeNumber.substring(0, 2));
            _bgPeriodNumber = BgNPeriodHelper.createNewMonthWeekBgPeriodNumber(year, month, week, offset, isExpression);
        }
        return _bgPeriodNumber;
    }

    private static String createNewYearBgPeriodNumber(int year, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        if (isExpression) {
            int _offset = offset;
            if (_offset > 1900) {
                calendar.set(_offset, 0, 1);
            } else {
                calendar.set(year + _offset, 0, 1);
            }
        } else {
            calendar.set(year, 0, 1);
            calendar.add(1, offset);
        }
        return String.valueOf(calendar.get(1)) + "Y";
    }

    private static String createNewHalfYearBgPeriodNumber(int year, int halfYear, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        if (isExpression) {
            int _offset = offset;
            if (_offset > 2) {
                return null;
            }
            calendar.set(year, (_offset - 1) * 6, 1);
        } else {
            calendar.set(year, (halfYear - 1) * 6, 1);
            calendar.add(2, offset * 6);
        }
        StringBuffer _bgPeriodNumber = new StringBuffer();
        _bgPeriodNumber.append(new SimpleDateFormat("yyyy'Y.'").format(calendar.getTime()));
        int _month = calendar.get(2) + 1;
        _bgPeriodNumber.append(_month > 6 ? "02" : "01");
        _bgPeriodNumber.append("HY");
        return _bgPeriodNumber.toString();
    }

    private static String createNewQuarterBgPeriodNumber(int year, int quarter, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        if (isExpression) {
            int _offset = offset;
            if (_offset > 4) {
                return null;
            }
            calendar.set(year, (_offset - 1) * 3, 1);
        } else {
            calendar.set(year, (quarter - 1) * 3, 1);
            calendar.add(2, offset * 3);
        }
        StringBuffer _bgPeriodNumber = new StringBuffer();
        _bgPeriodNumber.append(new SimpleDateFormat("yyyy'Y.'").format(calendar.getTime()));
        int _month = calendar.get(2) + 1;
        if (_month > 6) {
            if (_month > 9) {
                _bgPeriodNumber.append("04");
            } else {
                _bgPeriodNumber.append("03");
            }
        } else if (_month > 3) {
            _bgPeriodNumber.append("02");
        } else {
            _bgPeriodNumber.append("01");
        }
        _bgPeriodNumber.append("Q");
        return _bgPeriodNumber.toString();
    }

    private static String createNewYearWeekBgPeriodNumber(int year, int week, int offset, boolean isExpression) {
        CalendarHelper helper = new CalendarHelper();
        int maxWeek = 0;
        int tmp = 0;
        if (offset > 0) {
            maxWeek = helper.getWeeksOfYear(year, true);
            for (tmp = week + offset - maxWeek; tmp > 0; tmp -= maxWeek) {
                maxWeek = helper.getWeeksOfYear(++year, true);
            }
            String tmpWeek = tmp + maxWeek + "";
            if (tmpWeek.trim().length() == 1) {
                tmpWeek = "0" + tmpWeek;
            }
            return year + "Y" + "." + tmpWeek + "W";
        }
        if (offset < 0) {
            maxWeek = helper.getWeeksOfYear(year, true);
            for (tmp = week + offset; tmp <= 0; tmp += maxWeek) {
                maxWeek = helper.getWeeksOfYear(--year, true);
            }
            String tmpWeek = tmp + "";
            if (tmpWeek.trim().length() == 1) {
                tmpWeek = "0" + tmpWeek;
            }
            return year + "Y" + "." + tmpWeek + "W";
        }
        String tmpWeek = week + "";
        if (tmpWeek.trim().length() == 1) {
            tmpWeek = "0" + tmpWeek;
        }
        return year + "Y" + "." + tmpWeek + "W";
    }

    private static String createNewMonthBgPeriodNumber(int year, int month, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        if (isExpression) {
            int _offset = offset;
            if (_offset > 12) {
                _offset = 12;
            }
            calendar.set(1, year);
            calendar.set(2, _offset - 1);
        } else {
            calendar.set(year, month - 1, 1);
            calendar.add(2, offset);
        }
        return new SimpleDateFormat("yyyy'Y.'MM'M'").format(calendar.getTime());
    }

    private static String createNewDayBgPeriodNumber(int year, int month, int day, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        if (isExpression) {
            int _offset = offset;
            CalendarHelper calendarHelper = new CalendarHelper();
            int maxDays = calendarHelper.getDaysOfYear(year);
            if (_offset > maxDays) {
                _offset = maxDays;
            }
            calendar.set(year, month - 1, _offset);
        } else {
            calendar.set(year, month - 1, day);
            calendar.add(6, offset);
        }
        return new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(calendar.getTime());
    }

    private static String createNewTenDaysBgPeriodNumber(int year, int month, int tendays, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        String _tenDaysNumber = null;
        if (isExpression) {
            calendar.set(year, month - 1, 1);
            if (offset > 3) {
                return null;
            }
            tendays = offset;
        } else {
            int _tendays = tendays + offset;
            if (_tendays <= 0) {
                while (_tendays <= 0) {
                    offset += 3;
                    if (--month < 1) {
                        month = 12;
                        --year;
                    }
                    _tendays = tendays + offset;
                }
            } else if (_tendays > 3) {
                while (_tendays > 3) {
                    offset -= 3;
                    if (++month > 12) {
                        month = 1;
                        ++year;
                    }
                    _tendays = tendays + offset;
                }
            }
            if ((tendays += offset) == 1) {
                calendar.set(year, month - 1, 1);
            } else if (tendays == 2) {
                calendar.set(year, month - 1, 11);
            } else {
                calendar.set(year, month - 1, 21);
            }
        }
        if (tendays == 1) {
            calendar.set(5, 1);
            _tenDaysNumber = "01TD";
        } else if (tendays == 2) {
            calendar.set(5, 11);
            _tenDaysNumber = "02TD";
        } else if (tendays == 3) {
            calendar.set(5, 21);
            _tenDaysNumber = "03TD";
        }
        _tenDaysNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'").format(calendar.getTime()) + _tenDaysNumber;
        return _tenDaysNumber;
    }

    private static String createNewMonthWeekBgPeriodNumber(int year, int month, int week, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        CalendarHelper calendarHelper = new CalendarHelper();
        int _year = year;
        int _month = month;
        int _week = week;
        int _offset = offset;
        int _amount = calendarHelper.getWeeksOfMonth(_year, _month);
        if (isExpression) {
            if (_offset > _amount) {
                _offset = _amount;
            }
            calendar.setTime(calendarHelper.getFirstDayOfWeek(_year, _month, _offset));
        } else {
            if (_offset > 0) {
                while (_week + _offset > _amount) {
                    _offset -= _amount;
                    if (++_month > 12) {
                        ++_year;
                        _month = 1;
                    }
                    _amount = calendarHelper.getWeeksOfMonth(_year, _month);
                }
                _week += _offset;
            } else {
                while (_week + _offset <= 0) {
                    _offset += _amount;
                    if (--_month <= 0) {
                        --_year;
                        _month = 12;
                    }
                    _amount = calendarHelper.getWeeksOfMonth(_year, _month);
                }
                _week += _offset;
            }
            calendar.setTime(calendarHelper.getFirstDayOfWeek(_year, _month, _week));
        }
        String _monthWeekNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'").format(calendar.getTime());
        _monthWeekNumber = _monthWeekNumber + new DecimalFormat("00").format(calendar.get(4)) + "MW";
        return _monthWeekNumber;
    }

    public static String getOffsetBgPeriodNumberForViewTmp(int bgPeriodType, int year, int offset) {
        String _bgPeriodNumber = null;
        Calendar _calendar = Calendar.getInstance();
        _calendar.set(1, year);
        if (bgPeriodType == 3) {
            if (offset > 0) {
                _calendar.set(2, (offset - 1) * 3);
                _calendar.set(5, 1);
            }
            int _currYear = _calendar.get(1);
            int _currMonth = _calendar.get(2) + 1;
            int _currQuarter = 0;
            _currQuarter = _currMonth < 7 ? (_currMonth < 4 ? 1 : 2) : (_currMonth < 10 ? 3 : 4);
            _bgPeriodNumber = new StringBuffer(new DecimalFormat("0000").format(_currYear)).append("Y").append(".").append(new DecimalFormat("00").format(_currQuarter)).append("Q").toString();
        } else if (bgPeriodType == 4) {
            if (offset > 0) {
                _calendar.set(2, offset - 1);
                _calendar.set(5, 1);
            }
            int _currYear = _calendar.get(1);
            int _currMonth = _calendar.get(2) + 1;
            _bgPeriodNumber = new StringBuffer(new DecimalFormat("0000").format(_currYear)).append("Y").append(".").append(new DecimalFormat("00").format(_currMonth)).append("M").toString();
        } else if (bgPeriodType == 9) {
            if (offset > 0) {
                _calendar.set(2, (offset - 1) / 3);
                _calendar.set(5, (offset - 1) % 3 * 10 + 1);
            }
            int _currYear = _calendar.get(1);
            int _currMonth = _calendar.get(2) + 1;
            int _currDate = _calendar.get(5);
            int _currTenDays = 1;
            if (_currDate / 10 == 1) {
                _currTenDays = 2;
            } else if (_currDate / 10 == 2) {
                _currTenDays = 3;
            }
            _bgPeriodNumber = new StringBuffer(new DecimalFormat("0000").format(_currYear)).append("Y").append(".").append(new DecimalFormat("00").format(_currMonth)).append("M").append(".").append(new DecimalFormat("00").format(_currTenDays)).append("TD").toString();
        }
        return _bgPeriodNumber;
    }

    public static String getOffsetBgPeriodNumber(int bgPeriodType, int currYear, int currPeriod, int offset) {
        String _bgPeriodNumber = null;
        if (bgPeriodType == 6) {
            _bgPeriodNumber = new DecimalFormat("0000").format(currYear + offset) + "Y";
        } else if (bgPeriodType == 5) {
            currPeriod = currPeriod < 1 ? 1 : currPeriod;
            currPeriod = currPeriod > 2 ? 2 : currPeriod;
            Calendar _calendar = Calendar.getInstance();
            _calendar.set(1, currYear);
            if (offset > 0) {
                _calendar.set(2, (offset - 1) * 6);
            } else {
                _calendar.set(2, (currPeriod - 1) * 6);
                _calendar.add(2, offset * 6);
            }
            int _currYear = _calendar.get(1);
            int _currMonth = _calendar.get(2) + 1;
            int _currHalfYear = _currMonth < 7 ? 1 : 2;
            _bgPeriodNumber = new StringBuffer(new DecimalFormat("0000").format(_currYear)).append("Y").append(".").append(new DecimalFormat("00").format(_currHalfYear)).append("HY").toString();
        } else if (bgPeriodType == 4) {
            currPeriod = currPeriod < 1 ? 1 : currPeriod;
            currPeriod = currPeriod > 4 ? 4 : currPeriod;
            Calendar _calendar = Calendar.getInstance();
            _calendar.set(1, currYear);
            if (offset > 0) {
                _calendar.set(2, (offset - 1) * 3);
            } else {
                _calendar.set(2, (currPeriod - 1) * 3);
                _calendar.add(2, offset * 3);
            }
            int _currYear = _calendar.get(1);
            int _currMonth = _calendar.get(2) + 1;
            int _currQuarter = 0;
            _currQuarter = _currMonth < 7 ? (_currMonth < 4 ? 1 : 2) : (_currMonth < 10 ? 3 : 4);
            _bgPeriodNumber = new StringBuffer(new DecimalFormat("0000").format(_currYear)).append("Y").append(".").append(new DecimalFormat("00").format(_currQuarter)).append("Q").toString();
        } else if (bgPeriodType == 3) {
            currPeriod = currPeriod < 1 ? 1 : currPeriod;
            currPeriod = currPeriod > 12 ? 12 : currPeriod;
            Calendar _calendar = Calendar.getInstance();
            _calendar.set(1, currYear);
            if (offset > 0) {
                _calendar.set(2, offset - 1);
            } else {
                _calendar.set(2, currPeriod - 1);
                _calendar.add(2, offset);
            }
            int _currYear = _calendar.get(1);
            int _currMonth = _calendar.get(2) + 1;
            _bgPeriodNumber = new StringBuffer(new DecimalFormat("0000").format(_currYear)).append("Y").append(".").append(new DecimalFormat("00").format(_currMonth)).append("M").toString();
        } else if (bgPeriodType == 2) {
            currPeriod = currPeriod < 1 ? 1 : currPeriod;
            currPeriod = currPeriod > 52 ? 52 : currPeriod;
            Calendar _calendar = Calendar.getInstance();
            _calendar.set(1, currYear);
            if (offset > 0) {
                _calendar.set(3, offset);
            } else {
                _calendar.set(3, currPeriod);
                _calendar.add(3, offset);
            }
            int _currYear = _calendar.get(1);
            int _currWeek = _calendar.get(3);
            _bgPeriodNumber = new StringBuffer(new DecimalFormat("0000").format(_currYear)).append("Y").append(".").append(new DecimalFormat("00").format(_currWeek)).append("W").toString();
        } else if (bgPeriodType == 1) {
            CalendarHelper _calendarHelper = new CalendarHelper();
            int _maxDays = _calendarHelper.getDaysOfYear(currYear);
            currPeriod = currPeriod < 1 ? 1 : currPeriod;
            currPeriod = currPeriod > _maxDays ? _maxDays : currPeriod;
            String _key = new StringBuffer("yyyy'").append("Y").append(".").append("'MM'").append("M").append(".").append("'dd'").append("D").toString();
            Calendar _calendar = Calendar.getInstance();
            _calendar.set(1, currYear);
            if (offset > 0) {
                _calendar.set(6, offset);
            } else {
                _calendar.set(6, currPeriod);
                _calendar.add(6, offset);
            }
            _bgPeriodNumber = new SimpleDateFormat(_key).format(_calendar.getTime());
        }
        return _bgPeriodNumber;
    }

    public static int parserBgPeriodType(String bgPeriodNumber) {
        if (bgPeriodNumber == null) {
            return -1;
        }
        int bgPeriodType = 0;
        String[] parameter = null;
        String _code = null;
        String _bgPeriodNumber = null;
        _bgPeriodNumber = bgPeriodNumber;
        if (_bgPeriodNumber.startsWith("ZDY_")) {
            return 8;
        }
        parameter = _bgPeriodNumber.split("\\.");
        if (parameter != null) {
            switch (parameter.length) {
                case 1: {
                    if (_bgPeriodNumber != null && _bgPeriodNumber.endsWith("Y") && Pattern.matches("[\\d]{4}Y", _bgPeriodNumber)) {
                        bgPeriodType = 1;
                        break;
                    }
                    bgPeriodType = 8;
                    break;
                }
                case 2: {
                    _code = parameter[1].substring(2);
                    if ("HY".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}HY", _bgPeriodNumber)) break;
                        bgPeriodType = 2;
                        break;
                    }
                    if ("Q".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}Q", _bgPeriodNumber)) break;
                        bgPeriodType = 3;
                        break;
                    }
                    if ("M".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}M", _bgPeriodNumber)) break;
                        bgPeriodType = 4;
                        break;
                    }
                    if (!"W".equals(_code) || !Pattern.matches("[\\d]{4}Y.[\\d]{2}W", _bgPeriodNumber)) break;
                    bgPeriodType = 5;
                    break;
                }
                case 3: {
                    _code = parameter[2].substring(2);
                    if ("D".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}D", _bgPeriodNumber)) break;
                        bgPeriodType = 7;
                        break;
                    }
                    if ("TD".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}TD", _bgPeriodNumber)) break;
                        bgPeriodType = 9;
                        break;
                    }
                    if (!"MW".equals(_code) || !Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}MW", _bgPeriodNumber)) break;
                    bgPeriodType = 6;
                    break;
                }
            }
        }
        return bgPeriodType;
    }

    public static int parserBgPeriodYear(String bgPeriodNumber) {
        int _year = 0;
        if (StringUtils.isEmpty((String)bgPeriodNumber) || bgPeriodNumber.length() < 5) {
            return _year;
        }
        try {
            _year = Integer.valueOf(bgPeriodNumber.substring(0, 4));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _year;
    }

    public static int parserBgPeriodHalfYearOrQuarterOrMonth(String bgPeriodNumber) {
        int month = 0;
        if (StringUtils.isEmpty((String)bgPeriodNumber) || bgPeriodNumber.length() < 9) {
            return month;
        }
        try {
            month = Integer.valueOf(bgPeriodNumber.substring(6, 8));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return month;
    }

    public static int parserBgPeriodWeekOrTenDaysOrDay(String bgPeriodNumber) {
        int day = 0;
        if (StringUtils.isEmpty((String)bgPeriodNumber) || bgPeriodNumber.length() < 9) {
            return day;
        }
        try {
            day = Integer.valueOf(bgPeriodNumber.substring(10, 12));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return day;
    }

    public static String getBgPeriodNumberForKPI(Date date, StringEnum type) {
        StringBuffer bgPeriodNumber = new StringBuffer("");
        if (date == null || type == null) {
            return bgPeriodNumber.toString();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (DAY_VALUE.equals(type.getValue())) {
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            bgPeriodNumber.append(year).append("Y");
            bgPeriodNumber.append(".");
            if (month <= 9) {
                bgPeriodNumber.append(0).append(month).append("M");
            } else {
                bgPeriodNumber.append(month).append("M");
            }
            bgPeriodNumber.append(".");
            if (day <= 9) {
                bgPeriodNumber.append(0).append(day).append("D");
            } else {
                bgPeriodNumber.append(day).append("D");
            }
        } else if (MONTH_VALUE.equals(type.getValue())) {
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            bgPeriodNumber.append(year).append("Y");
            bgPeriodNumber.append(".");
            if (month <= 9) {
                bgPeriodNumber.append(0).append(month).append("M");
            } else {
                bgPeriodNumber.append(month).append("M");
            }
        } else if (WEEK_VALUE.equals(type.getValue())) {
            int year = cal.get(1);
            int weekOfYear = cal.get(3);
            bgPeriodNumber.append(year).append("Y");
            bgPeriodNumber.append(".");
            if (weekOfYear <= 9) {
                bgPeriodNumber.append(0).append(weekOfYear).append("W");
            } else {
                bgPeriodNumber.append(weekOfYear).append("W");
            }
        } else if (SEASON_VALUE.equals(type.getValue())) {
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            bgPeriodNumber.append(year).append("Y");
            bgPeriodNumber.append(".");
            int quarter = -1;
            if (month >= 1 && month <= 3) {
                quarter = 1;
            }
            if (month >= 4 && month <= 6) {
                quarter = 2;
            }
            if (month >= 7 && month <= 9) {
                quarter = 3;
            }
            if (month >= 10 && month <= 12) {
                quarter = 4;
            }
            bgPeriodNumber.append(0).append(quarter).append("Q");
        } else if (HALFYEAR_VALUE.equals(type.getValue())) {
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            bgPeriodNumber.append(year).append("Y");
            bgPeriodNumber.append(".");
            int halfYear = -1;
            if (month >= 1 && month <= 6) {
                halfYear = 1;
            }
            if (month >= 7 && month <= 12) {
                halfYear = 2;
            }
            bgPeriodNumber.append(0).append(halfYear).append("HY");
        } else if (YEAR_VALUE.equals(type.getValue())) {
            int year = cal.get(1);
            bgPeriodNumber.append(year).append("Y");
        }
        return bgPeriodNumber.toString();
    }

    public static void convertPeriodVarialbes(Context ctx, Book book) throws Exception {
        ReportVariables v;
        if (book != null && (v = ReportVariables.loadFromBook((Book)book)) != null) {
            HashMap periodCache = new HashMap();
            IBgPeriod iPeriod = null;
            iPeriod = ctx == null ? BgPeriodFactory.getRemoteInstance() : BgPeriodFactory.getLocalInstance((Context)ctx);
            String sheetName = null;
            for (int i = 0; i < book.getSheetCount(); ++i) {
                sheetName = book.getSheet(i).getSheetName();
                BgNPeriodHelper.convertVariable(v, "StartBgPeriod", sheetName, iPeriod, periodCache);
                BgNPeriodHelper.convertVariable(v, "EndBgPeriod", sheetName, iPeriod, periodCache);
            }
        }
    }

    public static int[] convertPeriod(BgPeriodInfo period) {
        int[] r = null;
        if (period != null) {
            r = new int[3];
            BgPeriodEnum periodType = period.getPeriodType();
            int year = period.getYear();
            int halfYear = period.getHalfYear();
            int month = period.getMonth();
            int quart = period.getQuarter();
            if (periodType != null) {
                if (periodType.getValue() == 1) {
                    r[2] = RptPeriodTypeEnum.YEARLY.getValue();
                    r[0] = year;
                    r[1] = 1;
                } else if (periodType.getValue() == 2) {
                    r[2] = RptPeriodTypeEnum.SEMIYEARLY.getValue();
                    r[0] = year;
                    r[1] = halfYear;
                } else if (periodType.getValue() == 3) {
                    r[2] = RptPeriodTypeEnum.QUARTERLY.getValue();
                    r[0] = year;
                    r[1] = quart;
                } else if (periodType.getValue() == 4) {
                    r[2] = RptPeriodTypeEnum.MONTHLY.getValue();
                    r[0] = year;
                    r[1] = month;
                } else if (periodType.getValue() == 5 || periodType.getValue() == 6) {
                    r[2] = RptPeriodTypeEnum.MONTHLY.getValue();
                    r[0] = year;
                    r[1] = month;
                } else {
                    r = null;
                }
            }
        }
        return r;
    }

    private static void setVariablie(ReportVariables vs, String vName, String sheetName, String value) {
        if (vs != null && !StringUtils.isEmpty((String)vName) && !StringUtils.isEmpty((String)sheetName)) {
            VariableEntry ve = null;
            if (vs.contains(vName, sheetName)) {
                ve = vs.get(vName, sheetName);
                ve.setValue(value);
            } else {
                ve = VariablesHelper.createReservedEntry((String)vName, (String)vName, (String)sheetName, (String)value);
                vs.add(ve);
            }
        }
    }

    private static void convertVariable(ReportVariables vs, String bgPeriodType, String sheetName, IBgPeriod iPeriod, Map periodCache) throws Exception {
        if (vs == null || StringUtils.isEmpty((String)bgPeriodType) || StringUtils.isEmpty((String)sheetName) || iPeriod == null || periodCache == null) {
            return;
        }
        String sYear = null;
        String sPeriod = null;
        if ("StartBgPeriod".equals(bgPeriodType)) {
            sYear = "StartYear";
            sPeriod = "StartPeriod";
        } else if ("EndBgPeriod".equals(bgPeriodType)) {
            sYear = "EndYear";
            sPeriod = "EndPeriod";
        } else {
            return;
        }
        VariableEntry ve = null;
        String periodNumber = null;
        BgPeriodInfo period = null;
        if (vs != null && vs.contains(bgPeriodType, sheetName) && !StringUtils.isEmpty((String)(periodNumber = (ve = vs.get(bgPeriodType, sheetName)).getValue()))) {
            if (periodCache.get(periodNumber) instanceof BgPeriodInfo) {
                period = (BgPeriodInfo)periodCache.get(periodNumber);
            } else {
                period = iPeriod.getBgPeriodInfo("select id,name,number,year,halfYear,quarter,month,week,periodType,beginDate,endDate where number = '" + periodNumber + "'");
                periodCache.put(periodNumber, period);
            }
            int[] periods = BgNPeriodHelper.convertPeriod(period);
            if (periods != null) {
                int rpt_year = periods[0];
                int rpt_period = periods[1];
                BgNPeriodHelper.setVariablie(vs, sYear, sheetName, String.valueOf(rpt_year));
                BgNPeriodHelper.setVariablie(vs, sPeriod, sheetName, String.valueOf(rpt_period));
            }
        }
    }
}

