/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgCommonException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeException;
import com.kingdee.eas.ma.budget.IBgFormulaFacade;
import com.kingdee.eas.ma.budget.MultiOrgMethodCodeExpr;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.nbudget.BgAutoEnurameHelper;
import com.kingdee.eas.ma.nbudget.BgExpressionsParseHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNLockProtectHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNTemplateHelper {
    public static final Logger logger = Logger.getLogger((String)BgNTemplateHelper.class.getName());
    public static final String SOURCE_STR = "com.kingdee.eas.ma.nbudget.client.BgNFormResource";
    public static final String STRRESOURCE = "com.kingdee.eas.ma.budget.BgTemplateResource";

    public static void setFormulaEditOfEnable(Cell cell, boolean isCanUndo) {
        BgNTemplateHelper.setFormulaEditOfCell(cell, true, isCanUndo);
    }

    public static void setBackGroup(Cell cell, Color color, boolean isIgnoreLock) {
        if (cell == null) {
            return;
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBackground(color);
        Sheet sheet = cell.getSheet();
        if (sheet == null) {
            return;
        }
        Range range = sheet.getRange(cell);
        range.setIgnoreProtected(true);
        range.setStyle(sa, Styles.getEmptySA());
    }

    public static void getItemFormulaMap(IBgFormulaFacade iBgF, String orgUnitId, String formulaLine, Map formulaMap, Map formualParamMap) throws EASBizException, BOSException {
        if (formulaMap.containsKey(formulaLine)) {
            return;
        }
        if (formulaLine.toLowerCase().indexOf("=bgitem") < 0) {
            return;
        }
        String[] params = BgNFSHelper.parseFormulaPara(formualParamMap, formulaLine);
        if (params == null) {
            return;
        }
        String strItemCombi = params[0];
        String _strItemCombi = "";
        String[] paramsNew = new String[6];
        _strItemCombi = !StringUtils.isEmpty((String)strItemCombi) && strItemCombi.indexOf(",") > 0 ? iBgF.parseBgItemCombi(strItemCombi, orgUnitId) : strItemCombi;
        params[0] = _strItemCombi;
        if (params.length == 4) {
            paramsNew[0] = params[0];
            paramsNew[1] = params[1];
            paramsNew[2] = params[2];
            paramsNew[3] = "BgData";
            paramsNew[4] = "true";
            paramsNew[5] = params[3];
        } else if (params.length == 6) {
            paramsNew = params;
        }
        String formula = "=BgItem(\"" + paramsNew[0] + "\",\"" + paramsNew[1] + "\",\"" + paramsNew[2] + "\",\"BgData\",true,\"" + paramsNew[5] + "\")";
        formulaMap.put(formulaLine, formula);
        if (!formula.equalsIgnoreCase(formulaLine)) {
            formulaMap.put(formula, formula);
            formualParamMap.put(formula, paramsNew);
        }
    }

    public static void setFormulaEditOfCell(Cell cell, boolean editable, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        ItemFormula itemFormula = BgNTemplateHelper.getItemFormula(cell, isCanUndo);
        if (itemFormula != null) {
            if (editable) {
                itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.TRUE_UPDATE);
            } else {
                itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.FALSE_UPDATE);
            }
        }
    }

    public static void setFormulaOfCell(Cell cell, String formulaStr, boolean isCreate, boolean isCanUndo) {
        if (cell == null || StringUtils.isEmpty((String)formulaStr)) {
            return;
        }
        if (isCanUndo) {
            Object obj = null;
            ItemFormula itemFormula = null;
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            obj = cell.getUserObjectValue("ITEM");
            if (obj != null && obj instanceof ItemFormula) {
                itemFormula = (ItemFormula)obj;
                itemFormula.putExt("13", formulaStr);
            } else if (isCreate) {
                itemFormula = new ItemFormula(formulaStr);
                range.setUserObject("ITEM", (Object)itemFormula);
            }
        } else {
            Object obj = null;
            ItemFormula itemFormula = null;
            obj = cell.getUserObjectValue("ITEM");
            if (obj != null && obj instanceof ItemFormula) {
                itemFormula = (ItemFormula)obj;
                itemFormula.putExt("13", formulaStr);
            } else if (isCreate) {
                itemFormula = new ItemFormula(formulaStr);
                cell.setUserObject("ITEM", (Object)itemFormula);
            }
        }
        if (cell != null && BgNFSHelper.checkHasFormulaOfCell(cell)) {
            BgNFSHelper.clearCurrencyInfo(cell);
            BgNFSHelper.clearBgPeriodInfo(cell);
            BgNFSHelper.clearBgElementInfo(cell);
            BgNFSHelper.clearBgItemInfo(cell);
        }
    }

    public static void clearAll(Cell cell, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        BgNTemplateHelper.clearFormulaOfCell(cell, isCanUndo);
        BgNTemplateHelper.clearBgaDataValue(cell, isCanUndo);
        BgNTemplateHelper.clearCellCtrlValue(cell, isCanUndo);
        cell.setFormula(null);
        BgNTemplateHelper.setValue(cell, null, isCanUndo);
    }

    public static void clearFormulaOfCell(Cell cell, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            range.setUserObject("ITEM", null);
        } else {
            cell.removeUserObject("ITEM");
        }
    }

    public static void setValue(Cell cell, Object value, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            if (value != null) {
                range.setValue(new Variant(value));
            } else {
                range.setValue(Variant.emptyVariant);
            }
        } else if (value != null) {
            cell.setValue(new Variant(value));
        } else {
            cell.setValue(Variant.emptyVariant);
        }
    }

    public static void clearBgaDataValue(Cell cell, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            Object obj = range.getUserObject("CELL_DATA");
            if (obj != null) {
                BgNSHelper.objClear(obj);
            }
            range.setUserObject("CELL_DATA", null);
        } else {
            Object obj = cell.getUserObjectValue("CELL_DATA");
            if (obj != null) {
                BgNSHelper.objClear(obj);
            }
            cell.removeUserObject("CELL_DATA");
        }
    }

    public static void clearCellCtrlValue(Cell cell, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            Object obj = range.getUserObject("CELL_DATA_EXT");
            if (obj != null) {
                BgNSHelper.objClear(obj);
            }
            range.setUserObject("CELL_DATA_EXT", null);
        } else {
            Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
            if (obj != null) {
                BgNSHelper.objClear(obj);
            }
            cell.removeUserObject("CELL_DATA_EXT");
        }
    }

    public static String getBgDataValue(Cell cell, String key) {
        Map _tmpMap;
        if (cell == null) {
            return null;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey(key)) {
            return (String)_tmpMap.get(key);
        }
        return null;
    }

    public static void removeDataValue(Cell cell, String key, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            Object obj = range.getUserObject("CELL_DATA");
            if (obj != null && obj instanceof Map) {
                Map _tmpMap = (Map)obj;
                if (_tmpMap.containsKey(key)) {
                    _tmpMap.remove(key);
                }
                if (_tmpMap.isEmpty()) {
                    range.setUserObject("CELL_DATA", null);
                } else {
                    range.setUserObject("CELL_DATA", (Object)_tmpMap);
                }
            }
        } else {
            Object obj = cell.getUserObjectValue("CELL_DATA");
            if (obj != null && obj instanceof Map) {
                Map _tmpMap = (Map)obj;
                if (_tmpMap.containsKey(key)) {
                    _tmpMap.remove(key);
                }
                if (_tmpMap.isEmpty()) {
                    cell.removeUserObject("CELL_DATA");
                }
            }
        }
    }

    public static void setBgDataValue(Cell cell, String key, Object value, boolean isCanUndo) {
        if (cell == null || value == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            HashMap obj = range.getUserObject("CELL_DATA");
            Map<String, Object> _tmpMap = null;
            if (obj == null || !(obj instanceof Map)) {
                _tmpMap = new HashMap();
                obj = _tmpMap;
            }
            _tmpMap = obj;
            _tmpMap.put(key, value);
            range.setUserObject("CELL_DATA", obj);
        } else {
            HashMap<String, Object> _tmpMap = null;
            String keyW2 = null;
            if (cell.getUserObjectValue("CELL_DATA") != null && cell.getUserObjectValue("CELL_DATA") instanceof Map) {
                Map tmpMap = (Map)cell.getUserObjectValue("CELL_DATA");
                _tmpMap = new HashMap();
                for (String keyW2 : tmpMap.keySet()) {
                    _tmpMap.put(keyW2, tmpMap.get(keyW2));
                }
            } else {
                _tmpMap = new HashMap<String, Object>();
                cell.setUserObject("CELL_DATA", _tmpMap);
            }
            _tmpMap.put(key, value);
            cell.setUserObject("CELL_DATA", _tmpMap);
        }
    }

    public static void setItemFormulaUserObject(Cell cell, String key, String value, boolean isCanUndo) {
        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) {
            return;
        }
        ItemFormula itemformul = BgNTemplateHelper.getItemFormula(cell, isCanUndo);
        if (itemformul == null) {
            return;
        }
        itemformul.putExt(key, value);
    }

    public static ItemFormula getItemFormula(Cell cell, boolean isCanUndo) {
        if (cell == null) {
            return null;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            Object obj = range.getUserObject("ITEM");
            if (obj != null && obj instanceof ItemFormula) {
                return (ItemFormula)obj;
            }
        } else {
            Object obj = cell.getUserObjectValue("ITEM");
            if (obj != null && obj instanceof ItemFormula) {
                return (ItemFormula)obj;
            }
        }
        return null;
    }

    public static String getBgItemForumluaUserObject(Cell cell, String key) {
        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) {
            return null;
        }
        ItemFormula itemformul = BgNTemplateHelper.getItemFormula(cell, false);
        return itemformul.getExt(key);
    }

    public static void removeBgItemForumluaUserObject(Cell cell, String key) {
        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) {
            return;
        }
        ItemFormula itemformul = BgNTemplateHelper.getItemFormula(cell, false);
        if (itemformul.getExt(key) != null) {
            itemformul.removeExt(key);
        }
    }

    public static void setCellCtrlValue(Cell cell, String key, Object value, boolean isCanUndo) {
        if (cell == null || value == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            HashMap obj = range.getUserObject("CELL_DATA_EXT");
            Map<String, Object> _tmpMap = null;
            if (obj == null || !(obj instanceof Map)) {
                _tmpMap = new HashMap();
                obj = _tmpMap;
                range.setUserObject("CELL_DATA_EXT", obj);
            }
            _tmpMap = obj;
            _tmpMap.put(key, value);
        } else {
            HashMap obj = cell.getUserObjectValue("CELL_DATA_EXT");
            Map<String, Object> _tmpMap = null;
            if (obj == null || !(obj instanceof Map)) {
                _tmpMap = new HashMap();
                obj = _tmpMap;
                cell.setUserObject("CELL_DATA_EXT", obj);
            }
            _tmpMap = obj;
            _tmpMap.put(key, value);
        }
    }

    public static void removeCellCtrlValue(Cell cell, String key, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            Object obj = range.getUserObject("CELL_DATA_EXT");
            if (obj != null && obj instanceof Map) {
                Map _tmpMap = (Map)obj;
                if (_tmpMap.containsKey(key)) {
                    _tmpMap.remove(key);
                }
                if (_tmpMap.isEmpty()) {
                    range.setUserObject("CELL_DATA_EXT", null);
                }
            }
        } else {
            Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
            if (obj != null && obj instanceof Map) {
                Map _tmpMap = (Map)obj;
                if (_tmpMap.containsKey(key)) {
                    _tmpMap.remove(key);
                }
                if (_tmpMap.isEmpty()) {
                    // empty if block
                }
            }
        }
    }

    public static String getCellCtrlValue(Cell cell, String key) {
        Map _tmpMap;
        if (cell == null) {
            return null;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey(key)) {
            return (String)_tmpMap.get(key);
        }
        return null;
    }

    public static String rebuildExpressionForm(String param, MethodInvokeExpr codeExpr, BgFormInfo bgFormInfo) {
        if (param == null || "".equals(param)) {
            return "";
        }
        String strParam = param.toString();
        strParam = strParam.replaceAll(";", ",");
        String[] array = (strParam = strParam.replaceAll("\"", "")).split(",");
        int length = array.length;
        if (length == 1) {
            return "";
        }
        ArrayList list = (ArrayList)codeExpr.paramList;
        if (bgFormInfo != null) {
            String endPeriod;
            String beginPeriod;
            String currency;
            String scheme;
            CodeExpr param1 = (CodeExpr)list.get(1);
            CodeExpr param4 = (CodeExpr)list.get(4);
            CodeExpr param5 = (CodeExpr)list.get(5);
            CodeExpr param6 = (CodeExpr)list.get(6);
            if (param1 instanceof StringExpr && ((scheme = ((StringExpr)param1).text) == null || scheme.equals(""))) {
                ((StringExpr)param1).text = bgFormInfo.getBgScheme().getNumber();
            }
            if (param4 instanceof StringExpr && ((currency = ((StringExpr)param4).text) == null || currency.equals(""))) {
                ((StringExpr)param4).text = bgFormInfo.getCurrency().getNumber();
            }
            if (param5 instanceof StringExpr && ((beginPeriod = ((StringExpr)param5).text) == null || beginPeriod.equals(""))) {
                ((StringExpr)param5).text = bgFormInfo.getBgPeriod().getNumber();
            }
            if (param6 instanceof StringExpr && ((endPeriod = ((StringExpr)param6).text) == null || endPeriod.equals(""))) {
                ((StringExpr)param6).text = bgFormInfo.getBgPeriod().getNumber();
            }
        }
        Object[] objAry = new Object[length];
        for (int i = 0; i < length; ++i) {
            ArrayList tempList = (ArrayList)list.clone();
            StringExpr newParam0 = new StringExpr(array[i].trim());
            tempList.set(0, newParam0);
            objAry[i] = tempList;
        }
        MultiOrgMethodCodeExpr momc = new MultiOrgMethodCodeExpr(codeExpr, objAry);
        return momc.toString();
    }

    public static void dealWith(Book book, String orgUnitId, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula, boolean needItemVariable, boolean isEnumForm, Context ctx) throws BOSException, EASBizException {
        BgNTemplateHelper.dealWith(book, orgUnitId, itemFormulaMap, isFromTemplate, isDealItemFormula, null, needItemVariable, isEnumForm, ctx);
    }

    public static void dealWith(Book book, String orgUnitId, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula, boolean needItemVariable, boolean isEnumForm, Context ctx, Set filterSheet) throws BOSException, EASBizException {
        BgNTemplateHelper.dealWith(book, orgUnitId, itemFormulaMap, isFromTemplate, isDealItemFormula, null, needItemVariable, isEnumForm, ctx, filterSheet);
    }

    public static void dealWith(Book book, String orgUnitId, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula, String currFormulaType, boolean needItemVariable, boolean isEnumForm, Context ctx) throws BOSException, EASBizException {
        BgNTemplateHelper.dealWith(book, orgUnitId, itemFormulaMap, isFromTemplate, isDealItemFormula, needItemVariable, isEnumForm, ctx, null);
    }

    public static void dealWith(Book book, String orgUnitId, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula, String currFormulaType, boolean needItemVariable, boolean isEnumForm, Context ctx, Set filterSheet) throws BOSException, EASBizException {
        if (book == null) {
            return;
        }
        boolean isFilterBySheet = false;
        if (filterSheet != null && !filterSheet.isEmpty()) {
            isFilterBySheet = true;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            if (isFilterBySheet && !filterSheet.contains(BgNFSHelper.getSheetSign(_sheet))) continue;
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (_cell == null || !BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    BgNFSHelper.clearCurrencyInfo(_cell);
                    BgNFSHelper.clearBgPeriodInfo(_cell);
                    BgNFSHelper.clearBgElementInfo(_cell);
                    BgNFSHelper.clearBgItemInfo(_cell);
                }
            }
        }
        HashMap bgItemCombinMap = new HashMap();
        int sheetSize2 = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize2; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (_cell == null) continue;
                    BgNTemplateHelper.collectBgItemCombin(_cell, bgItemCombinMap);
                }
            }
        }
        IBgFormulaFacade iBgF = null;
        iBgF = ctx == null ? BgFormulaFacadeFactory.getRemoteInstance() : BgFormulaFacadeFactory.getLocalInstance((Context)ctx);
        bgItemCombinMap = iBgF.batchParseBgItemCombi(bgItemCombinMap, orgUnitId);
        int sheetSize3 = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize3; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            if (isFilterBySheet && !filterSheet.contains(BgNFSHelper.getSheetSign(_sheet))) continue;
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (_cell == null) continue;
                    BgNTemplateHelper.dealWith(_cell, bgItemCombinMap, itemFormulaMap, isFromTemplate, isDealItemFormula, needItemVariable, currFormulaType, isEnumForm);
                    BgNTemplateHelper.resetExpression(_cell, currFormulaType);
                }
            }
        }
        Object key2 = null;
        if (bgItemCombinMap == null || bgItemCombinMap.isEmpty()) {
            return;
        }
        for (Object key2 : bgItemCombinMap.keySet()) {
            Object[] obj;
            if (bgItemCombinMap.get(key2) == null || !(bgItemCombinMap.get(key2) instanceof Object[]) || (obj = (Object[])bgItemCombinMap.get(key2)).length < 2 || obj[1] == null || !((Boolean)obj[1]).booleanValue()) continue;
            throw new BgCommonException(BgCommonException.EXISTSAMEITEMGROUP);
        }
    }

    public static void resetExpression(Cell _cell, String formulaType) {
        if (BgNFSHelper.checkHasExpression(_cell)) {
            String expression = BgNTemplateHelper.getFormula(_cell);
            if (StringUtils.isEmpty((String)expression) || expression.charAt(0) != '=') {
                return;
            }
            if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                if ("bgData".equals(formulaType)) {
                    BgNTemplateHelper.setBgDataValue(_cell, "BG_BUDGET_EXPRESSIONS", expression, false);
                } else if ("bgActual".equals(formulaType)) {
                    BgNTemplateHelper.setBgDataValue(_cell, "BG_ACTUAL_EXPRESSIONS", expression, false);
                } else if ("bgActualAdd".equals(formulaType)) {
                    BgNTemplateHelper.setBgDataValue(_cell, "BG_ADD_EXPRESSIONS", expression, false);
                }
            } else {
                BgNTemplateHelper.setBgDataValue(_cell, "BG_BUDGET_EXPRESSIONS", expression, false);
                BgNTemplateHelper.setBgDataValue(_cell, "BG_ACTUAL_EXPRESSIONS", expression, false);
                BgNTemplateHelper.setBgDataValue(_cell, "BG_ADD_EXPRESSIONS", expression, false);
            }
        }
    }

    public static void addNotRemove(Book book, boolean isEnumerateForm) throws BOSException, EASBizException {
        int m = -1;
        int n = -1;
        int sizeBook = book.getSheetCount();
        for (int k = 0; k < sizeBook; ++k) {
            int i;
            Sheet sheet = book.getSheet(k);
            Cell cell = null;
            int maxRowIndex = sheet.getMaxRowIndex();
            for (i = 0; i <= maxRowIndex; ++i) {
                int maxColIndex = sheet.getMaxColIndex();
                for (int j = 0; j <= maxColIndex; ++j) {
                    cell = sheet.getCell(i, j, false);
                    if (cell == null) continue;
                    m = i;
                    n = j;
                }
            }
            if (!isEnumerateForm) {
                maxRowIndex = m;
                for (i = 0; i <= maxRowIndex; ++i) {
                    cell = sheet.getCell(i, 0, true);
                    cell.setUserObject("NotRemoveRow", (Object)"NotRemoveRow");
                }
            }
            int maxColIndex = n;
            for (int j = 0; j <= maxColIndex; ++j) {
                cell = sheet.getCell(0, j, true);
                cell.setUserObject("NotRemoveCol", (Object)"NotRemoveCol");
            }
        }
    }

    public static void collectBgItemCombin(Cell cell, HashMap bgItemCombinMap) {
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            cell.setDiagonalHeader(null);
            String itemFormula = BgNFSHelper.getFormulaOfCell(cell);
            itemFormula = BgNTemplateHelper.get6ParematerItemFormula(itemFormula);
            if (itemFormula != null) {
                List list = new ArrayList();
                FunctionExpr funExpr = null;
                try {
                    Expression expr = ExcelFormulaPaserHelper.parse((String)itemFormula);
                    if (expr instanceof FunctionExpr) {
                        funExpr = (FunctionExpr)expr;
                        list = ((FunctionExpr)expr).parameters;
                    }
                }
                catch (ParserException e1) {
                    logger.error((Object)e1);
                    return;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return;
                }
                if (list == null || list.isEmpty()) {
                    return;
                }
                if (list.size() == 6 && funExpr.funcionName.equalsIgnoreCase("BgItem") && list.get(0) != null) {
                    String strItemCombi = ((com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr)list.get((int)0)).value;
                    bgItemCombinMap.put(strItemCombi, null);
                }
            }
        }
        if (BgNTemplateHelper.getFormula(cell) != null) {
            String formula = BgNTemplateHelper.getFormula(cell);
            cell.setDiagonalHeader(null);
            try {
                Expression expr = ExcelFormulaPaserHelper.parse((String)formula);
                BgExpressionsParseHelper.processBgItemCombine(expr, bgItemCombinMap);
            }
            catch (ParserException e1) {
                logger.error((Object)e1);
                return;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return;
            }
        }
    }

    private static void dealWith(Cell cell, HashMap bgItemCombinMap, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula, boolean needItemVariable, String currFormulaType, boolean isEnumForm) {
        if (cell == null) {
            return;
        }
        if (bgItemCombinMap == null) {
            bgItemCombinMap = new HashMap();
        }
        if (itemFormulaMap == null) {
            itemFormulaMap = new HashMap<String, String>();
        }
        if (!BgNFSHelper.checkCanEditFormulaOfCell(cell) && !"false".equals(itemFormulaMap.get("FIXEDFORM"))) {
            return;
        }
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            String itemFormula = BgNFSHelper.getFormulaOfCell(cell);
            if ((itemFormula = BgNTemplateHelper.get6ParematerItemFormula(itemFormula)) != null) {
                FunctionExpr funExpr = null;
                try {
                    Expression expr = ExcelFormulaPaserHelper.parse((String)itemFormula);
                    if (expr instanceof FunctionExpr) {
                        funExpr = (FunctionExpr)expr;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return;
                }
                if (funExpr == null) {
                    return;
                }
                String[] params = BgNFSHelper.parseFormulaPara(itemFormula);
                ItemFormula item = (ItemFormula)cell.getUserObjectValue("ITEM");
                if (params.length == 6 && funExpr.funcionName.equalsIgnoreCase("BgItem")) {
                    String strItemCombi = params[0];
                    String _strItemCombi = null;
                    Object[] obj = (Object[])bgItemCombinMap.get(strItemCombi);
                    if (obj != null && obj.length >= 2 && obj[1] != null && !((Boolean)obj[1]).booleanValue()) {
                        _strItemCombi = (String)obj[0];
                    }
                    if (_strItemCombi == null) {
                        item.FormulaToObject("=BgItem(\"\",\"" + params[1] + "\",\"" + params[2] + "\",\"BgData\",true,\"" + params[5] + "\")");
                        if (isDealItemFormula && isFromTemplate && itemFormulaMap != null) {
                            itemFormulaMap.put(itemFormula, "=BgItem(\"\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[5] + "\")");
                        }
                        itemFormula = "=BgItem(\"\",\"" + params[1] + "\",\"" + params[2] + "\",\"BgData\",true,\"" + params[5] + "\")";
                        BgNFSHelper.setFormulaOfCell(cell, itemFormula);
                        if (!needItemVariable && isEnumForm) {
                            String currExprType = BgAutoEnurameHelper.getExprType(currFormulaType);
                            BgAutoEnurameHelper.checkExpr4AutoFill(cell, "BG_BUDGET_EXPRESSIONS", currExprType, bgItemCombinMap, isEnumForm);
                            BgAutoEnurameHelper.checkExpr4AutoFill(cell, "BG_ACTUAL_EXPRESSIONS", currExprType, bgItemCombinMap, isEnumForm);
                            BgAutoEnurameHelper.checkExpr4AutoFill(cell, "BG_ADD_EXPRESSIONS", currExprType, bgItemCombinMap, isEnumForm);
                        }
                        return;
                    }
                    itemFormula = "=BgItem(\"" + _strItemCombi + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"BgData\",true,\"" + params[5] + "\")";
                    if (isDealItemFormula && isFromTemplate && itemFormulaMap != null) {
                        itemFormulaMap.put(itemFormula, "=BgItem(\"" + _strItemCombi + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[5] + "\")");
                    }
                    BgNFSHelper.setFormulaOfCell(cell, itemFormula);
                }
            }
        }
        if (!needItemVariable && isEnumForm) {
            String currExprType = BgAutoEnurameHelper.getExprType(currFormulaType);
            BgAutoEnurameHelper.checkExpr4AutoFill(cell, "BG_BUDGET_EXPRESSIONS", currExprType, bgItemCombinMap, isEnumForm);
            BgAutoEnurameHelper.checkExpr4AutoFill(cell, "BG_ACTUAL_EXPRESSIONS", currExprType, bgItemCombinMap, isEnumForm);
            BgAutoEnurameHelper.checkExpr4AutoFill(cell, "BG_ADD_EXPRESSIONS", currExprType, bgItemCombinMap, isEnumForm);
        } else {
            String expressions = null;
            String _expressions = null;
            if (BgNFSHelper.checkHasExpression(cell)) {
                expressions = BgNFSHelper.getExpression(cell);
                HashMap convertMap = new HashMap();
                Boolean convertResult = (Boolean)convertMap.get("CONVERT_RESULT");
                if (convertResult != null && !convertResult.booleanValue()) {
                    BgNFSHelper.clearExpression(cell);
                    if (cell != null) {
                        cell.removeUserObject("AUTO_CREATE");
                    }
                } else if (!StringUtils.isEmpty(_expressions)) {
                    BgNFSHelper.setExpression(cell, _expressions);
                }
            }
        }
    }

    public static boolean CheckTemplateHaveDataFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        if (BgNTemplateHelper.getFormula(cell) != null && BgNTemplateHelper.getFormula(cell).trim().length() > 0) {
            return true;
        }
        return BgNTemplateHelper.getBgDataValue(cell, "BG_BUDGET_EXPRESSIONS") != null && BgNTemplateHelper.getBgDataValue(cell, "BG_BUDGET_EXPRESSIONS").trim().length() > 0 || BgNTemplateHelper.getBgDataValue(cell, "BG_ACTUAL_EXPRESSIONS") != null && BgNTemplateHelper.getBgDataValue(cell, "BG_ACTUAL_EXPRESSIONS").trim().length() > 0 || BgNTemplateHelper.getBgDataValue(cell, "BG_ADD_EXPRESSIONS") != null && BgNTemplateHelper.getBgDataValue(cell, "BG_ADD_EXPRESSIONS").trim().length() > 0;
    }

    public static void initAliasObjectTem(Book book, boolean isEnum) {
        Sheet sheet = null;
        Column col = null;
        Row row = null;
        int bookCount = book.getSheetCount();
        for (int i = 0; i < bookCount; ++i) {
            sheet = book.getSheet(i);
            boolean check = true;
            HashMap aliMap = new HashMap();
            int j = 0;
            for (int maxRowIndex = sheet.getMaxRowIndex(); j <= maxRowIndex; --maxRowIndex) {
                row = sheet.getRow(maxRowIndex, true);
                boolean isEmpty = BgNFSHelper.checkIsEmptyRow(row, true);
                if (check && isEmpty) {
                    BgNFSHelper.removeRowSign(row);
                } else {
                    check = false;
                    if (!BgNFSHelper.checkHasSign(row)) {
                        BgNFSHelper.setRowSign(row);
                        if (isEnum && isEmpty) {
                            BgNFSHelper.setRowNullSign(row);
                        }
                    } else if (BgNFSHelper.checkHasNullSign(row) && !isEmpty) {
                        if (!BgNFSHelper.checkHasEnumerateOfRow(row, sheet.getMaxColIndex())) {
                            BgNFSHelper.setRowSign(row);
                        }
                        BgNFSHelper.removeNullRowSign(row);
                        BgNFSHelper.setRowSource(row, "DATA_SOURCE_EDIT");
                    } else if (isEnum && BgNFSHelper.checkHasSign(row) && isEmpty) {
                        BgNFSHelper.setRowNullSign(row);
                    }
                }
                if (BgNFSHelper.getRowSource(row) != null) continue;
                BgNFSHelper.setRowSource(row, "DATA_SOURCE_EDIT");
            }
            int maxColIndex = sheet.getMaxColIndex();
            for (j = 0; j <= maxColIndex; ++j) {
                col = sheet.getColumn(j, true);
                if (col == null) continue;
                if (aliMap.containsKey(String.valueOf(j))) {
                    if (!BgNFSHelper.checkHasSign(col)) {
                        BgNFSHelper.setColSign(col);
                    }
                    if (BgNFSHelper.getColObject(col, "SIGN_DATA_SOURCE") != null) continue;
                    BgNFSHelper.setColObject(col, "SIGN_DATA_SOURCE", "DATA_SOURCE_EDIT");
                    continue;
                }
                if (BgNFSHelper.checkHasSign(col)) continue;
                BgNFSHelper.setColSign(col);
            }
            if (!BgNFSHelper.checkHasSign(sheet)) {
                BgNFSHelper.setSheetSign(sheet);
            }
            BgNFSHelper.setSheetObject(sheet, "SIGN_DATA_SOURCE", "DATA_SOURCE_EDIT");
        }
    }

    public static boolean isUpdateBgItemFormulaFromUpper(Context ctx) {
        String paramValue = null;
        try {
            paramValue = ctx == null ? ParamManager.getParamValue(null, null, (String)"BG013") : ParamManager.getParamValue((Context)ctx, null, (String)"BG013");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (paramValue == null || paramValue.trim().equals("")) {
            return false;
        }
        return Boolean.valueOf(paramValue);
    }

    public static List getBgItemByBgFormID(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException {
        BgFormInfo formInfo;
        String formID = filterParam.getBgFormID();
        Map listAnaLysis = filterParam.getAnalysisColsMap();
        try {
            formInfo = BgFormFactory.getLocalInstance((Context)ctx).getBgFormInfo("select data where id='" + formID + "'");
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        Book book = null;
        try {
            book = formInfo.getBook();
            BgNFSHelper.disableCal(book);
            BgNFSHelper.disableUndo(book);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        Object key2 = null;
        Object value = null;
        List valueList = null;
        String[] sheetKey = null;
        Sheet sheet = null;
        int colIndex = -1;
        int maxRowIndex = -1;
        Column col = null;
        Cell cell = null;
        ArrayList<String> list = new ArrayList<String>();
        if (listAnaLysis != null) {
            for (Object key2 : listAnaLysis.keySet()) {
                if (StringUtils.isEmpty((String)((String)key2)) || !((value = listAnaLysis.get(key2)) instanceof List)) continue;
                valueList = value;
                sheetKey = key2.toString().split("&");
                if (sheetKey == null || sheetKey.length < 1 || (sheet = book.getSheetByID(sheetKey[0])) == null) continue;
                maxRowIndex = sheet.getMaxRowIndex() + 1;
                int sizeVlaueList = valueList.size();
                for (int k = 0; k < sizeVlaueList; ++k) {
                    colIndex = -1;
                    try {
                        colIndex = Integer.valueOf(valueList.get(k) + "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (colIndex == -1 || (col = sheet.getColumn(colIndex, false)) == null) continue;
                    for (int j = 0; j < maxRowIndex; ++j) {
                        cell = sheet.getCell(j, colIndex, false);
                        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                        list.add(BgNFSHelper.getFormulaOfCell(cell));
                    }
                }
            }
        }
        return list;
    }

    public static boolean updateAliasSuperior(Sheet sheet) {
        if (sheet == null) {
            return false;
        }
        boolean hasRowFlagOrColFlag = false;
        Row row = null;
        Column column = null;
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = sheet.getRow(rowIndex, false);
            if (BgNFSHelper.getRowSign(row) == null) continue;
            BgNFSHelper.setRowSource(row, "DATA_SOURCE_SUPERIOR");
            hasRowFlagOrColFlag = true;
        }
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            column = sheet.getColumn(colIndex, false);
            if (BgNFSHelper.getColSign(column) == null) continue;
            BgNFSHelper.setColSource(column, "DATA_SOURCE_SUPERIOR");
            hasRowFlagOrColFlag = true;
        }
        return hasRowFlagOrColFlag;
    }

    public static boolean updateAliasTemplate(Sheet sheet) {
        if (sheet == null) {
            return false;
        }
        boolean hasRowFlagOrColFlag = false;
        Row row = null;
        Column column = null;
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = sheet.getRow(rowIndex, false);
            if (BgNFSHelper.getRowSign(row) == null) continue;
            BgNFSHelper.setRowSource(row, "DATA_SOURCE_TEMPLATE");
            hasRowFlagOrColFlag = true;
        }
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            column = sheet.getColumn(colIndex, false);
            if (BgNFSHelper.getColSign(column) == null) continue;
            BgNFSHelper.setColSource(column, "DATA_SOURCE_TEMPLATE");
            hasRowFlagOrColFlag = true;
        }
        return hasRowFlagOrColFlag;
    }

    public static void updateAliasSuperior(Book book) {
        if (book == null) {
            return;
        }
        Sheet sheet = null;
        int bookcount = book.getSheetCount();
        for (int i = 0; i < bookcount; ++i) {
            sheet = book.getSheet(i);
            if (sheet == null) continue;
            BgNTemplateHelper.updateAliasSuperior(sheet);
            sheet.setUserObject("SIGN_DATA_SOURCE", (Object)"DATA_SOURCE_SUPERIOR");
        }
    }

    public static void setStyleAttributesCell(Cell cell, StyleAttributes ssaOuter, StyleAttributes ssaInter) {
        if (cell == null) {
            return;
        }
        Range range = cell.getSheet().getRange(cell);
        range.setIgnoreProtected(true);
        range.setStyle(ssaOuter, ssaInter);
    }

    public static void setStyleAttributesCell(Cell cell, StyleAttributes ssa) {
        if (cell == null) {
            return;
        }
        Range range = cell.getSheet().getRange(cell);
        range.setIgnoreProtected(true);
        range.setStyle(ssa, Styles.getEmptySA());
    }

    public static void setStyleAttributesRow(Row row, StyleAttributes ssaOuter, StyleAttributes ssaInter) {
        if (row == null) {
            return;
        }
        Range range = row.getSheet().getRowRange(row.getRow(), row.getRow());
        range.setIgnoreProtected(true);
        range.setStyle(ssaOuter, ssaInter);
    }

    public static void setStyleAttributesCol(Column col, StyleAttributes ssaOuter, StyleAttributes ssaInter) {
        if (col == null) {
            return;
        }
        Range range = col.getSheet().getColRange(col.getCol(), col.getCol());
        range.setStyle(ssaOuter, ssaInter);
    }

    public static boolean checkCanEditFormulaOfCell(Cell cell) {
        if (cell == null) {
            return true;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            if (itemFormula.getExt("BGFORMULA_CANUPDATE") == null) {
                itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.TRUE_UPDATE);
                return true;
            }
            if (itemFormula.getExt("BGFORMULA_CANUPDATE").equals(BgNConstants.FALSE_UPDATE)) {
                return false;
            }
            if (itemFormula.getExt("BGFORMULA_CANUPDATE").equals(BgNConstants.TRUE_UPDATE)) {
                return true;
            }
        }
        return true;
    }

    public static String getItemFormulaObject(Cell cell, String key) {
        if (cell == null) {
            return null;
        }
        if (!BgNFSHelper.checkHasFormulaOfCell(cell)) {
            return null;
        }
        ItemFormula item = BgNFSHelper.getItemFormula(cell);
        return item.getExt(key);
    }

    public static Object getBgFillValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        return BgNTemplateHelper.getBgDataValue(cell, "bgFillValue");
    }

    public static void removeBgFillValue(Cell cell, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        BgNTemplateHelper.removeDataValue(cell, "bgFillValue", isCanUndo);
    }

    public static void removeBgFillInfo(Cell cell, boolean isCanUndo) {
        BgNTemplateHelper.removeBgFillValue(cell, isCanUndo);
        BgNTemplateHelper.removeBgFillType(cell, isCanUndo);
        BgNTemplateHelper.removeDataValue(cell, "bgFillValue_itemId", isCanUndo);
        BgNTemplateHelper.removeDataValue(cell, "isAttachFormula", isCanUndo);
    }

    public static void removeBgFillType(Cell cell, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        BgNTemplateHelper.removeDataValue(cell, "bgFillType", isCanUndo);
    }

    public static Object getBgFillType(Cell cell) {
        if (cell == null) {
            return null;
        }
        return BgNTemplateHelper.getBgDataValue(cell, "bgFillType");
    }

    public static void setBgFillType(Cell cell, String fillType, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        BgNTemplateHelper.setBgDataValue(cell, "bgFillType", fillType, isCanUndo);
    }

    public static boolean checkHaveBgFillType(Cell cell) {
        return BgNTemplateHelper.getBgFillType(cell) != null && BgNTemplateHelper.getBgFillType(cell).toString().trim().length() > 0;
    }

    public static boolean checkHaveBgFillValue(Cell cell) {
        return BgNTemplateHelper.getBgFillValue(cell) != null && BgNTemplateHelper.getBgFillValue(cell).toString().trim().length() > 0;
    }

    public static void setBgFillValue(Cell cell, String fillValue, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        BgNTemplateHelper.setBgDataValue(cell, "bgFillType", fillValue, isCanUndo);
    }

    public static void checkCanEdit(Sheet sheet) throws Exception {
        if (sheet == null) {
            return;
        }
        Range range = sheet.getSelectionRange();
        range.setIgnoreProtected(true);
        int num = range.size();
        if (num <= 0) {
            return;
        }
        Protection pro = sheet.getSheetOption().getProtection(false);
        boolean isPro = false;
        if (pro != null && pro.isProtected() && !pro.allowEditObjects()) {
            isPro = true;
        }
        Cell cell = null;
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            for (int j = block.getRow(); j <= Math.min(maxRow, block.getRow2()); ++j) {
                for (int k = block.getCol(); k <= Math.min(maxCol, block.getCol2()); ++k) {
                    cell = sheet.getCell(j, k, false);
                    if (cell == null) continue;
                    if (!BgNTemplateHelper.checkCanEditFormulaOfCell(cell)) {
                        throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_NOT_EDIT);
                    }
                    if (!isPro || !BgNLockProtectHelper.isCellLocked(cell)) continue;
                    throw new BgNTemplateException(BgNTemplateException.CELL_LOCK);
                }
            }
        }
    }

    public static void setRangeNoChangeLeft(Sheet sheet, Range range, boolean locked, boolean isCanUndo) {
        if (range == null) {
            return;
        }
        range.setIgnoreProtected(true);
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                for (int k = block.getCol(); k <= block.getCol2(); ++k) {
                    Cell cell = sheet.getCell(j, k, true);
                    if (cell == null) continue;
                    if (BgNLockProtectHelper.isCellLockedAndProtectionFromSupser(cell)) {
                        return;
                    }
                    BgNLockProtectHelper.setCellLockedAndProtectionOnlyCell(cell, locked, isCanUndo);
                }
            }
        }
    }

    public static void setRangeFormulaNoChangeLeft(Sheet sheet, Range range, boolean locked, boolean isCanUndo) {
        if (range == null) {
            return;
        }
        range.setIgnoreProtected(true);
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                for (int k = block.getCol(); k <= block.getCol2(); ++k) {
                    Cell cell = sheet.getCell(j, k, true);
                    if (cell == null || !BgNTemplateHelper.CheckTemplateHaveDataFormula(cell) || !locked && BgNLockProtectHelper.isCellLockedAndProtectionFromSupser(cell)) continue;
                    BgNLockProtectHelper.setCellLockedAndProtectionOnlyCell(cell, locked, isCanUndo);
                }
            }
        }
    }

    public static boolean isDataSourceSuperior(Row row) {
        return BgNFSHelper.getRowSource(row) != null && BgNFSHelper.getRowSource(row).equals("DATA_SOURCE_SUPERIOR");
    }

    public static boolean isDataSourceSuperior(Column col) {
        return BgNFSHelper.getColSource(col) != null && BgNFSHelper.getColSource(col).equals("DATA_SOURCE_SUPERIOR");
    }

    public static boolean isDataSourceTemplate(Row row) {
        return BgNFSHelper.getRowSource(row) != null && BgNFSHelper.getRowSource(row).equals("DATA_SOURCE_TEMPLATE");
    }

    public static boolean isDataSourceTemplate(Column col) {
        return BgNFSHelper.getColSource(col) != null && BgNFSHelper.getColSource(col).equals("DATA_SOURCE_TEMPLATE");
    }

    public static Map getSelectCells(Sheet activeSheet) {
        Range range = activeSheet.getSelectionRange();
        range.setIgnoreProtected(true);
        int num = range.size();
        if (num <= 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        int maxRow = activeSheet.getMaxRowIndex();
        int maxCol = activeSheet.getMaxColIndex();
        for (int i = 0; i < num; ++i) {
            CellBlock block = range.getBlock(i);
            for (int j = block.getRow(); j <= Math.min(maxRow, block.getRow2()); ++j) {
                for (int k = block.getCol(); k <= Math.min(maxCol, block.getCol2()); ++k) {
                    map.put(j + "-" + k, null);
                }
            }
        }
        return map;
    }

    public static String get6ParematerItemFormula(String formula) {
        FunctionExpr funExpr = null;
        try {
            Expression expr = ExcelFormulaPaserHelper.parse((String)formula);
            if (expr instanceof FunctionExpr) {
                funExpr = (FunctionExpr)expr;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        if (funExpr == null) {
            return null;
        }
        String[] params = BgNFSHelper.parseFormulaPara(formula);
        if ((params.length != 6 || !funExpr.funcionName.equalsIgnoreCase("BgItem")) && params.length == 4 && funExpr.funcionName.equalsIgnoreCase("BgItem")) {
            formula = "=BgItem(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"BgData\",true,\"" + params[3] + "\")";
        }
        return formula;
    }

    public static String get4ParematerItemFormula(String formula) {
        FunctionExpr funExpr = null;
        try {
            Expression expr = ExcelFormulaPaserHelper.parse((String)formula);
            if (expr instanceof FunctionExpr) {
                funExpr = (FunctionExpr)expr;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        if (funExpr == null) {
            return null;
        }
        String[] params = BgNFSHelper.parseFormulaPara(formula);
        if (params.length == 6 && funExpr.funcionName.equalsIgnoreCase("BgItem")) {
            formula = "=BgItem(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[5] + "\")";
        } else if (params.length != 4 || funExpr.funcionName.equalsIgnoreCase("BgItem")) {
            // empty if block
        }
        return formula;
    }

    public static String getFormula(Cell cell) {
        if (!BgNFSHelper.checkHasExpression(cell)) {
            return null;
        }
        return cell.getFormula();
    }

    public static void setCellLockedAndProtection(Cell cell, boolean locked, List notAllowOperation, boolean isCanUndo) {
        if (cell == null) {
            return;
        }
        Protection pro = cell.getSheet().getSheetOption().getProtection(true);
        if (locked) {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
                BgNTemplateHelper.initSheeProtected(pro, notAllowOperation, true);
            } else {
                BgNTemplateHelper.initSheeProtected(pro, notAllowOperation, false);
            }
            pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(locked);
        Range range = cell.getSheet().getRange(cell);
        range.setStyle(sa, Styles.getEmptySA());
        if (locked) {
            BgNTemplateHelper.setCellCtrlValue(cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE, isCanUndo);
        } else {
            BgNTemplateHelper.removeCellCtrlValue(cell, "CELL_LOCK", isCanUndo);
        }
    }

    private static Protection initSheeProtected(Protection pro, List notAllowOperation, boolean isProExit) {
        if (notAllowOperation != null) {
            if (!isProExit) {
                pro.appendOperation(2048);
                pro.appendOperation(256);
                pro.appendOperation(512);
                pro.appendOperation(65536);
                pro.appendOperation(8192);
                pro.appendOperation(16384);
                pro.appendOperation(4);
                pro.appendOperation(32);
                pro.appendOperation(128);
                pro.appendOperation(64);
                pro.appendOperation(16);
                pro.appendOperation(1);
                pro.appendOperation(2);
                pro.appendOperation(8);
                pro.appendOperation(16);
                pro.appendOperation(1024);
                pro.appendOperation(4096);
            }
            int size = notAllowOperation.size();
            for (int i = 0; i < size; ++i) {
                pro.deleteOperation(((Integer)notAllowOperation.get(i)).intValue());
            }
        } else {
            pro.deleteOperations();
            pro.appendOperation(1);
            pro.appendOperation(2);
        }
        return pro;
    }

    public static void setBookLockedAndProtection(Book book, boolean locked, List notAllowBookOperation, List notAllowSheetOperation) {
        if (book == null) {
            return;
        }
        BgNTemplateHelper.setBookProtection(book, locked, notAllowBookOperation);
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            BgNTemplateHelper.setSheetLockedAndProtection(book.getSheet(i), locked, notAllowSheetOperation);
        }
    }

    public static void setSheetLockedAndProtection(Sheet sheet, boolean locked, List notAllowOperation) {
        StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(true);
        Range range = sheet.getSheetRange();
        range.setStyle(sa, Styles.getEmptySA());
        BgNTemplateHelper.setSheetProtection(sheet, locked, notAllowOperation);
    }

    public static boolean isBookLockedAndProtection(Book book) {
        return book != null && book.getUserObjectValue("BOOK_LOCK") != null && book.getUserObjectValue("BOOK_LOCK").equals(BgNConstants.TRUE_UPDATE);
    }

    public static void setSheetProtection(Sheet sheet, boolean locked, List notAllowOperation) {
        if (sheet == null) {
            return;
        }
        Protection pro = sheet.getSheetOption().getProtection(true);
        if (locked) {
            pro.deleteOperations();
            pro.appendOperation(1);
            pro.appendOperation(2);
            if (!pro.isProtected()) {
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            sheet.setUserObject("SHEET_LOCK", (Object)BgNConstants.FALSE_UPDATE);
        } else {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            sheet.setUserObject("SHEET_LOCK", (Object)BgNConstants.TRUE_UPDATE);
        }
    }

    public static void setBookProtection(Book book, boolean locked, List notAllowOperation) {
        if (book == null) {
            return;
        }
        BookProtection pro = book.getProtection();
        if (locked) {
            pro.deleteOperations();
            if (!pro.isProtected()) {
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            book.setUserObject("BOOK_LOCK", (Object)BgNConstants.TRUE_UPDATE);
        } else {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            book.setUserObject("BOOK_LOCK", (Object)BgNConstants.FALSE_UPDATE);
        }
    }

    public static void checkFormulaIsEctype(List formulas, Locale locale) throws EASBizException {
        int index;
        if (formulas == null || formulas.isEmpty()) {
            return;
        }
        String formulaString = null;
        String checkString = null;
        String sheetString = null;
        StringBuffer msg = null;
        String[] parameter = null;
        HashMap checkMap = new HashMap();
        int count = formulas.size();
        for (index = 0; index < count; ++index) {
            parameter = (String[])formulas.get(index);
            if (parameter == null || parameter[0] == null || parameter[1] == null || parameter[2] == null || parameter[3] == null) continue;
            formulaString = parameter[1];
            if (checkMap.containsKey(formulaString)) {
                checkString = formulaString;
                break;
            }
            checkMap.put(formulaString, null);
        }
        try {
            if (checkString != null) {
                msg = new StringBuffer(1024);
                count = formulas.size();
                for (index = 0; index < count; ++index) {
                    parameter = (String[])formulas.get(index);
                    if (parameter == null || parameter[0] == null || parameter[1] == null || parameter[2] == null || parameter[3] == null || !(formulaString = parameter[1]).equals(checkString)) continue;
                    if (sheetString == null || !sheetString.equals(parameter[0])) {
                        sheetString = parameter[0];
                        msg.append(BgNTemplateHelper.getMessage("left", locale) + sheetString + BgNTemplateHelper.getMessage("right", locale) + BgNTemplateHelper.getMessage("checkFormulade", locale));
                    }
                    msg.append(TableToolkit.xy2range((int)Integer.valueOf(parameter[3]), (int)Integer.valueOf(parameter[2])) + BgNTemplateHelper.getMessage("andtwo", locale));
                }
                msg.delete(msg.length() - 1, msg.length());
                msg.append(BgNTemplateHelper.getMessage("checkFormula", locale) + BgNTemplateHelper.getMessage("left", locale) + checkString.replaceAll(",\"BgData\",true", "") + BgNTemplateHelper.getMessage("right", locale) + BgNTemplateHelper.getMessage("checkFormulaEctype", locale));
                throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, (Object[])new String[]{msg.toString()});
            }
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        finally {
            checkMap.clear();
        }
    }

    public static String getMessage(String msg, Locale locale) {
        return ResourceBase.getString((String)STRRESOURCE, (String)msg, (Locale)locale);
    }

    public static String getAuctualFormula(Cell cell) {
        return BgNTemplateHelper.getBgDataValue(cell, "BG_ACTUAL_EXPRESSIONS");
    }

    public static String getAuctualAddFormula(Cell cell) {
        return BgNTemplateHelper.getBgDataValue(cell, "BG_ADD_EXPRESSIONS");
    }

    public static String getBudgetFormula(Cell cell) {
        return BgNTemplateHelper.getBgDataValue(cell, "BG_BUDGET_EXPRESSIONS");
    }

    public static void mergeRow(Sheet sheet, int rowindex, int start, int end) {
        boolean isBeginMerge = false;
        int startMerge = start;
        int endMerge = start;
        Range range = null;
        String formula = null;
        String fillType = null;
        String fillValue = null;
        Object value = null;
        String formulaOld = null;
        String fillTypeOld = null;
        String fillValueOld = null;
        Object valueOld = null;
        Row row = sheet.getRow(rowindex, false);
        if (row == null) {
            return;
        }
        for (int i = start; i < end + 1; ++i) {
            Cell cell = row.getCell(i, false);
            if (cell == null) {
                if (!isBeginMerge) continue;
                if (endMerge > startMerge) {
                    range = sheet.getRange(rowindex, startMerge, rowindex, endMerge);
                    range.setIgnoreProtected(true);
                    range.merge();
                }
                isBeginMerge = false;
                startMerge = i;
                endMerge = i;
                formulaOld = null;
                valueOld = null;
                fillTypeOld = null;
                fillValueOld = null;
                continue;
            }
            formula = BgNFSHelper.getExpression(cell);
            if (formulaOld == null) {
                formulaOld = formula;
            }
            value = BgNFSHelper.getValue(cell);
            if (valueOld == null) {
                valueOld = value;
            }
            fillType = (String)BgNTemplateHelper.getBgFillType(cell);
            if (fillTypeOld == null) {
                fillTypeOld = fillType;
            }
            fillValue = (String)BgNTemplateHelper.getBgFillType(cell);
            if (fillValueOld == null) {
                fillValueOld = fillValue;
            }
            if (!isBeginMerge) {
                isBeginMerge = true;
                endMerge = i;
                continue;
            }
            boolean isAllSame = true;
            if (formula == null && formulaOld != null || formulaOld != null && formula == null || !formula.equalsIgnoreCase(formulaOld)) {
                isAllSame = false;
            }
            if (isAllSame && value == null && valueOld != null || valueOld != null && value == null || !value.equals(valueOld)) {
                isAllSame = false;
            }
            if (isAllSame && fillType == null && fillTypeOld != null || fillTypeOld != null && fillType == null || !fillType.equals(fillTypeOld)) {
                isAllSame = false;
            }
            if (isAllSame && fillValue == null && fillValueOld != null || fillValueOld != null && fillValue == null || !fillValue.equals(fillValueOld)) {
                isAllSame = false;
            }
            if (!isAllSame) {
                if (endMerge > startMerge) {
                    range = sheet.getRange(rowindex, startMerge, rowindex, endMerge);
                    range.setIgnoreProtected(true);
                    range.merge();
                }
                isBeginMerge = false;
                startMerge = i;
                endMerge = i;
                formulaOld = null;
                valueOld = null;
                fillTypeOld = null;
                fillValueOld = null;
                continue;
            }
            endMerge = i;
        }
    }

    public static void mergeCol(Sheet sheet, int colindex, int start, int end) {
        boolean isBeginMerge = false;
        int startMerge = start;
        int endMerge = start;
        Range range = null;
        String formula = null;
        String fillType = null;
        String fillValue = null;
        Object value = null;
        String formulaOld = null;
        String fillTypeOld = null;
        String fillValueOld = null;
        Object valueOld = null;
        Column col = sheet.getColumn(colindex, false);
        if (col == null) {
            return;
        }
        for (int i = start; i < end + 1; ++i) {
            Cell cell = sheet.getCell(i, colindex, false);
            if (cell == null) {
                if (!isBeginMerge) continue;
                if (endMerge > startMerge) {
                    range = sheet.getRange(startMerge, colindex, endMerge, colindex);
                    range.setIgnoreProtected(true);
                    range.merge();
                }
                startMerge = i;
                endMerge = i;
                isBeginMerge = false;
                formulaOld = null;
                valueOld = null;
                fillTypeOld = null;
                fillValueOld = null;
                continue;
            }
            formula = BgNFSHelper.getExpression(cell);
            if (formulaOld == null) {
                formulaOld = formula;
            }
            value = BgNFSHelper.getValue(cell);
            if (valueOld == null) {
                valueOld = value;
            }
            fillType = (String)BgNTemplateHelper.getBgFillType(cell);
            if (fillTypeOld == null) {
                fillTypeOld = fillType;
            }
            fillValue = (String)BgNTemplateHelper.getBgFillValue(cell);
            if (fillValueOld == null) {
                fillValueOld = fillValue;
            }
            if (!isBeginMerge) {
                isBeginMerge = true;
                endMerge = i;
                continue;
            }
            boolean isAllSame = true;
            if (formula == null && formulaOld != null || formulaOld != null && formula == null || !formula.equalsIgnoreCase(formulaOld)) {
                isAllSame = false;
            }
            if (isAllSame && value == null && valueOld != null || valueOld != null && value == null || !value.equals(valueOld)) {
                isAllSame = false;
            }
            if (isAllSame && fillType == null && fillTypeOld != null || fillTypeOld != null && fillType == null || !fillType.equals(fillTypeOld)) {
                isAllSame = false;
            }
            if (isAllSame && fillValue == null && fillValueOld != null || fillValueOld != null && fillValue == null || !fillValue.equals(fillValueOld)) {
                isAllSame = false;
            }
            if (!isAllSame) {
                if (endMerge > startMerge) {
                    range = sheet.getRange(startMerge, colindex, endMerge, colindex);
                    range.setIgnoreProtected(true);
                    range.merge();
                }
                startMerge = i;
                endMerge = i;
                isBeginMerge = true;
                formulaOld = formula;
                valueOld = value;
                fillTypeOld = fillType;
                fillValueOld = fillValue;
                continue;
            }
            endMerge = i;
        }
    }

    public static void setExpression(Cell cell, String expression, boolean isCanUndo) {
        if (isCanUndo) {
            Range range = cell.getSheet().getRange(cell);
            range.setFormula(expression);
        } else {
            cell.setFormula(expression);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateSheetName(Context ctx, Connection conn, String bgTemId, Book book) throws BOSException, EASBizException {
        if (conn == null) return;
        if (bgTemId == null) return;
        if (book == null) {
            return;
        }
        String _Sign = "A1B2C3D4";
        String _sheetId = null;
        String _sheetName = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstUpPer = null;
        PreparedStatement pstUp2 = null;
        Sheet _sheet = null;
        ResultSet rst = null;
        ResultSet rst1 = null;
        try {
            try {
                pstmt = conn.prepareStatement("delete from T_BG_BgTemSheet where FBgTemplateID = ?");
                pstmt.setString(1, bgTemId);
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                throw ex;
            }
            finally {
                SQLUtils.cleanup((Statement)pstmt);
            }
            pstUpPer = conn.prepareStatement("update T_BG_BgSheetPermission set  FSheetName = ? where FBgTem = ? and FSheetId = ?;");
            pstmt = conn.prepareStatement("Insert Into T_BG_BgTemSheet (FID, FBgTemplateID, FSheetIndex, FSheetID, FSheetName) values (?, ?, ?, ?, ?)");
            int in = book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                _sheet = book.getSheet(i);
                _sheetId = BgNFSHelper.getSheetSign(_sheet);
                _sheetName = _sheet.getSheetName();
                pstmt.setString(1, BOSUuid.create((String)_Sign).toString());
                pstmt.setString(2, bgTemId);
                pstmt.setInt(3, i);
                pstmt.setString(4, _sheetId);
                pstmt.setString(5, _sheetName);
                pstmt.addBatch();
                pstUpPer.setString(1, _sheetName);
                pstUpPer.setString(2, bgTemId);
                pstUpPer.setString(3, _sheetId);
                pstUpPer.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            pstUp2 = conn.prepareStatement("select fbgsheetpermissionid from T_BG_BgSheetPermission where FBgTem = ? ");
            pstUp2.setString(1, bgTemId);
            rst1 = pstUp2.executeQuery();
            String sheetName = "";
            while (rst1.next()) {
                sheetName = "";
                if (!BgSHelper.isBgSheetPermissionUsed((Context)ctx)) continue;
                pstUpPer.executeBatch();
                pstmt = conn.prepareStatement("select FSheetName from T_BG_BgSheetPermission where FBgTem = ? and fbgsheetpermissionid = ? order by FSheetIndex");
                pstmt.setString(1, bgTemId);
                pstmt.setString(2, rst1.getString(1));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    sheetName = sheetName + rst.getString(1) + " ,";
                }
                SQLUtils.cleanup((Statement)pstmt);
                pstmt = conn.prepareStatement("update t_bg_bgpermission set FSheetPerName = ? where FBgTemplateID = ? and fid = ?");
                if (sheetName.equals("")) continue;
                if (sheetName.length() > 290) {
                    sheetName = sheetName.substring(0, 285);
                    sheetName = sheetName + "...";
                }
                pstmt.setString(1, sheetName);
                pstmt.setString(2, bgTemId);
                pstmt.setString(3, rst1.getString(1));
                pstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst1, pstUp2);
                SQLUtils.cleanup(rst, (Statement)pstmt);
                SQLUtils.cleanup(pstUpPer);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst1, (Statement)pstUp2);
        SQLUtils.cleanup(rst, (Statement)pstmt);
        SQLUtils.cleanup((Statement)pstUpPer);
    }

    public static boolean hasForceLock(Cell cell) {
        return BgNTemplateHelper.getForceLockLongNumber(cell) != null;
    }

    public static boolean setForceLock(Cell cell, String orgLongnumber) {
        boolean flag = false;
        if (cell == null || orgLongnumber == null) {
            return flag;
        }
        String value = BgNTemplateHelper.getForceLockLongNumber(cell);
        if (value == null || value.indexOf(orgLongnumber) == 0) {
            cell.setUserObject("force_lock_org_longnumber", (Object)orgLongnumber);
            flag = true;
        }
        return flag;
    }

    public static boolean removeForceLock(Cell cell, String orgLongnumber) {
        boolean flag = true;
        String value = BgNTemplateHelper.getForceLockLongNumber(cell);
        if (value != null) {
            if (value.equals(orgLongnumber)) {
                BgNTemplateHelper.removeForceLock(cell);
            } else {
                flag = false;
            }
        }
        return flag;
    }

    public static void removeForceLock(Cell cell) {
        if (cell != null) {
            Range r = cell.getSheet().getRange(cell);
            r.setIgnoreProtected(true);
            r.setCellLocked(false);
            cell.removeUserObject("force_lock_org_longnumber");
        }
    }

    public static boolean canEditForForceLock(Cell cell, String orgLongnumber) {
        boolean flag = true;
        if (cell != null) {
            String value = BgNTemplateHelper.getForceLockLongNumber(cell);
            flag = value == null || value.equals(orgLongnumber);
        }
        return flag;
    }

    public static String getForceLockLongNumber(Cell cell) {
        if (cell != null) {
            return (String)cell.getUserObjectValue("force_lock_org_longnumber");
        }
        return null;
    }

    public static void showForceLock(Book book) {
        if (book != null) {
            int sheetIndex = 0;
            int sheetSize = book.getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                Sheet sheet = book.getSheet(sheetIndex);
                BgNTemplateHelper.showForceLock(sheet);
            }
        }
    }

    public static void showForceLock(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        String orgLongnumber = SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo().getLongNumber();
        Range rangeUnlock = null;
        Range rangeLock = null;
        Cell cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                if (cell == null || !BgNTemplateHelper.hasForceLock(cell)) continue;
                if (BgNTemplateHelper.canEditForForceLock(cell, orgLongnumber)) {
                    if (rangeUnlock == null) {
                        rangeUnlock = cell.getSheet().getRange(cell);
                        continue;
                    }
                    rangeUnlock.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
                    continue;
                }
                if (rangeLock == null) {
                    rangeLock = cell.getSheet().getRange(cell);
                    continue;
                }
                rangeLock.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
            }
        }
        if (rangeUnlock != null) {
            StyleAttributes saUnlock = Styles.getEmptySA();
            saUnlock.setLocked(false);
            rangeUnlock.setIgnoreProtected(true);
            rangeUnlock.setStyle(saUnlock, Styles.getEmptySA());
        }
        if (rangeLock != null) {
            StyleAttributes saLock = Styles.getEmptySA();
            saLock.setLocked(true);
            rangeLock.setIgnoreProtected(true);
            rangeLock.setStyle(saLock, Styles.getEmptySA());
        }
    }

    public static void copyForceLock(Cell desCell, Cell sourCell, CoreUI ui) {
        if (desCell == null || sourCell == null) {
            return;
        }
        String forceLock = BgNTemplateHelper.getForceLockLongNumber(sourCell);
        if (forceLock != null) {
            BgNTemplateHelper.setForceLock(desCell, forceLock);
            String orgLongnumber = (String)ui.getUIContext().get("force_lock_org_longnumber");
            if (orgLongnumber == null) {
                orgLongnumber = SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo().getLongNumber();
                ui.getUIContext().put("force_lock_org_longnumber", orgLongnumber);
            }
            if (!BgNTemplateHelper.canEditForForceLock(sourCell, orgLongnumber)) {
                StyleAttributes sa = Styles.getEmptySA();
                sa.setLocked(true);
                Range range = desCell.getSheet().getRange(desCell);
                range.setIgnoreProtected(true);
                range.setStyle(sa, Styles.getEmptySA());
            }
        }
    }
}

